<?php

/**
 * This is the model class for table "{{hr_employee_brand_salary_percent}}".
 *
 * The followings are the available columns in table '{{hr_employee_brand_salary_percent}}':
 * @property integer $id
 * @property integer $employee_id
 * @property integer $brand_id
 * @property string $salary_percent
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class EmployeeBrandSalaryPercent extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{hr_employee_brand_salary_percent}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('employee_id, brand_id, salary_percent', 'required'),
			array('employee_id, brand_id, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('salary_percent', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, employee_id, brand_id, salary_percent, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on'=>'search'),
		);
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'employeedetail' => array(self::BELONGS_TO, 'Employee', 'employee_id'),
                    'branddetail' => array(self::BELONGS_TO, 'ProductClass', 'brand_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'employee_id' => 'Employee',
			'brand_id' => 'Brand',
			'salary_percent' => 'Salary Percent',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_datetime' => 'Created Datetime',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('employee_id',$this->employee_id);
		$criteria->compare('brand_id',$this->brand_id);
		$criteria->compare('salary_percent',$this->salary_percent,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EmployeeBrandSalaryPercent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        public static function getbrandpercentage($emp_id) {
            $brand_details='';
            if ($emp_id>0) {
                $model = self::model()->findAll(array('condition' =>'employee_id="'.$emp_id.'"'));
                foreach ($model as $key => $value) {
                    if($key!=0)$brand_details.=',';
                    $brand_details.=$value->branddetail->product_class.'('.$value->salary_percent.'%)';
                }
            }
            return $brand_details;
        }
        public static function getEmployeeName() {
            $SQL ="SELECT * FROM  {{hr_employee}}  WHERE isActive='Y'  && id NOT IN (SELECT  employee_id FROM  {{hr_employee_brand_salary_percent}})";                               
            $model = Yii::app()->db->createCommand($SQL)->queryAll();
            $arr_employee = array();
            $employee_details = array();
            foreach ($model as $key => $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
            return CHtml::listData($employee_details, 'id', 'name');
        }
}
