<?php

class WpsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('EmployeeCompany', 'employeewps', 'Saveemployeewps'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionEmployeeCompany() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('employee_wps_form');
    }

    public function actionEmployeewps() {
        $branch_id = $_POST['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('wps_employes_list', array('branch_id' => $branch_id));
    }

    public function actionsaveemployeewps() {

        if (isset($_POST['EmployeewpsCompany'])) {
            foreach ($_POST['EmployeewpsCompany'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = EmployeewpsCompany::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_datetime = date('Y-m-d h:i:s');
                } else {
                    $model[$i] = new EmployeewpsCompany;
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_datetime = date('Y-m-d h:i:s');
                }
                $model[$i]->employee_id = $items['employee_id'];
                $model[$i]->wps_company_id = $items['wps_company_id'];

                $valid1 = $model[$i]->validate();
            }

            if ($valid1) {
                foreach ($model as $eachModel) {
                    $eachModel->save();
                    Employee::model()->updateByPK($eachModel->employee_id, array('employee_wps_company' => $eachModel->wps_company_id));
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                if (!isset($model)) {
                    $model = new EmployeewpsCompany;
                }
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode($error1);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }
}
