<?php

class SalarysettingController extends Controller
{
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Save','GetLockMonth','SalaryIndex','GetSalaryProcedure','CreateProcedure','SaveProcedure'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_lockmonth_menu']) || Yii::app()->user->authorised_user == 1) {   
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            }else{
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        }
        public function actionGetLockMonth() {
        $model = new MasterSalaryLock();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'payroll_branch',
            2 => 'payroll_month',
            3 => 'payroll_year',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (branch_sponsor.branch_or_sponsor_name LIKE '%" . $searchString . "%' OR payroll_month LIKE '%" . $searchString . "%' OR payroll_year LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_sponsor')->count(array('condition' => $condition));
        $model = $model->with('branch_sponsor')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'branch_sponsor.branch_or_sponsor_name asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit_button =0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_lockmonth_edit'])  || Yii::app()->user->authorised_user == 1) {
                $edit_button=1;
                $icon='<div class="btn-wrap text-center">
                <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/salarysetting/create&id=' . $row['id'] . '\',\'Master Salary Settings\',\'md\')">
                <i class="fa fa-pencil"></i></button> ';
                $icon.= '</div>';
            }
            
            $sponsor_name="";
            if($row['payroll_branch']>0){
                $sponsor_name = $row['branch_sponsor']['branch_or_sponsor_name'];
            }
            $rowData[] = array(++$m,$sponsor_name,HrGenerelSettings::getMonthName($row['payroll_month']), $row['payroll_year'],array('id'=>$row['id'],'edit_button'=>$edit_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new MasterSalaryLock();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model));
    }
    public function actionSave()
        {
            $model = new MasterSalaryLock();
            if (isset($_POST['MasterSalaryLock']))
            {
    		if ((int) @$_POST['MasterSalaryLock']['id'] > 0)
                {
                    $id= (int) @$_POST['MasterSalaryLock']['id'];
                    $model=$model->findByPk($id);
                    $model->scenario = 'update'; 
                }else{
                   
                   $model->scenario = 'add';
                }
                $model->attributes=$_POST['MasterSalaryLock'];
                $model->payroll_month=$_POST['MasterSalaryLock']['payroll_month'];
                if($model->save())
                {       
                      
                        $jsonData['status'] = 'success';
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
            }
        }
        public function actionSalaryIndex() {
               if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_datesetting_menu']) || Yii::app()->user->authorised_user == 1) {       
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('salary_procedure_index');
            }else{
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        }
        public function actionGetSalaryProcedure() {
        $model = new MasterSalaryProcedure();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'payroll_branch',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (branch_sponsor.branch_or_sponsor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_sponsor')->count(array('condition' => $condition));
        $model = $model->with('branch_sponsor')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'branch_sponsor.branch_or_sponsor_name asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $edit_button =0;
            $icon='';
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_datesetting_edit'])  || Yii::app()->user->authorised_user == 1) {
                $icon='<div class="btn-wrap text-center">
                <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/salarysetting/createprocedure&id=' . $row['id'] . '\',\'Salary Procedure Settings\',\'md\')">
                <i class="fa fa-pencil"></i></button> ';
               $icon.= '</div>';
               $edit_button=1;
            }
            $sponsor_name="";
            if($row['payroll_branch']>0){
                $sponsor_name = $row['branch_sponsor']['branch_or_sponsor_name'];
            }
            $rowData[] = array($m,$sponsor_name, $row['payroll_start_day'],array('id'=>$row['id'],'edit_button'=>$edit_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateProcedure() {
        $model = new MasterSalaryProcedure();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_procedure', array('model' => $model));
    }
    public function actionSaveProcedure()
        {
            $model = new MasterSalaryProcedure();
            if (isset($_POST['MasterSalaryProcedure']))
            {
    		if ((int) @$_POST['MasterSalaryProcedure']['id'] > 0)
                {
                    $id= (int) @$_POST['MasterSalaryProcedure']['id'];
                    $model=$model->findByPk($id); 
                    $model->scenario = 'update';
                }else{
                    $model->scenario="add";
                    
                }
                $model->attributes=$_POST['MasterSalaryProcedure'];
                if($model->save())
                {       
                       
                        $jsonData['status'] = 'success';
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
            }
        }    
}