<?php

class SalarymigrationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetSalaryList','DownloadSalaryTemplate','UploadsalaryDetails','Upload','SaveUploadCsv','ViewSalaryDetails',
                    'editsalarydetails','EditEmployeeSalary','UpdateSalary','SalarySlip','getEmployeeName','PrintSalarySlip'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    public function actionGetSalaryList() {
        $model = new HrSalaryMasterMigrated();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'branch.branch_or_sponsor_name',
            2 => 'payroll_month',
            3 => 'payroll_year',
            4 => '',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (branch.branch_or_sponsor_name LIKE '%" . $searchString . "%' OR payroll_year LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch')->count(array('condition' => $condition));
        $model = $model->with('branch')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string.= '<a class="btn btn-primary btn-xs" title="View Salary" onclick="loadPopupModal(\'salarymigration/viewsalarydetails&id=' . $row['id'] . '\',\'SALARY DETAILS\',\'xl\');"><i class="fa fa-eye"></i></a>&nbsp;';
            $button_string.= '<a class="btn btn-primary btn-xs" title="View Salary" onclick="loadPopupModal(\'salarymigration/editsalarydetails&id=' . $row['id'] . '\',\'SALARY DETAILS\',\'xl\');"><i class="fa fa-edit"></i></a>&nbsp;';
            $rowData[] = array($m,$row->branch->branch_or_sponsor_name,HrGenerelSettings::getMonthName($row->payroll_month),$row->payroll_year,$row->totalsalary, $button_string);
            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionDownloadSalaryTemplate() {
        $filename = 'employee_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $title_string='Employee Code *';
        $model_salary_master=MasSalarytype::model()->findAll(array('condition' => 'salary_occurence="2"'));
        foreach ($model_salary_master as $key => $value) {
            $title_string.=',';
            $title_string.=$value->salary_name;
        }
        $title_string.=',Overtime Amount,Other Additions,Salary Advance,Leave Amount,Loan Amount,Other Deductions,Total Additions,Total Deductions,Total Salary Amount,Remarks';
        echo $title_string;
        Yii::app()->end();
    }
    public function actionUploadsalaryDetails() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    	$this->render('upload_salary_details');
    }
    public function readsalaryCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveUploadCsv() {
        $branch = Yii::app()->request->getParam('branch');  
        $month = Yii::app()->request->getParam('month');  
        $year = Yii::app()->request->getParam('year');  
        $file_name = Yii::app()->request->getParam('filename');  
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/salarydetails/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/salarydetails/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $salary_list = $this->readsalaryCSV("uploads/salarydetails/" . $file_name);
        $model_salary_master=MasSalarytype::model()->findAll(array('condition' => 'salary_occurence="2"'));
        $f=0;
        foreach (array_slice($salary_list, 1) as $i => $data) {
            if($data[0]!=''){
                $model_salary[$i] = new HrSalaryMigration();
                $model_salary[$i]->scenario="excelupload";
                $employee_id=0;
                if($data[0]!=''){
                    $employee_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
                    $employee_code=$this->ciphertext($employee_code, "e");
                    $model_employee=Employee::model()->find(array('condition'=>'employee_code="'.$employee_code.'"'));
                    if($model_employee->id>0){
                        $model_salary[$i]->employee_id =$model_employee->id;
                        $employee_id=$model_employee->id;
                    }else{
                        $model_salary[$i]->employee_id ='';
                    }
                }else{                    
                    $model_salary[$i]->employee_id = '';
                }
                $index_start=1;
                foreach ($model_salary_master as $key => $value) {
                    if($data[$index_start]!=''){
                        $amount=trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        if($amount>0 && $amount!=''){
                            $model_salary_details[$f] = new HrSalaryMigrationDetails();
                            $model_salary_details[$f]->created_by = Yii::app()->user->id;
                            $model_salary_details[$f]->created_date_time = date('Y-m-d H:i:s'); 
                            $model_salary_details[$f]->employee_id = $employee_id;
                            $model_salary_details[$f]->salary_id = $value->id;
                            $model_salary_details[$f]->salary_type = $value->salary_type;
                            $model_salary_details[$f]->salary_name = $value->salary_name;
                            $model_salary_details[$f]->salary_amount = $amount;
                            $f++;
                        }
                    }
                    $index_start++;
                }
                for($h=1;$h<=10;$h++){
                    if($h==1){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->overtime_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->overtime_amount =0.00;
                        }
                    }
                    if($h==2){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->other_addition = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->other_addition =0.00;
                        }
                    }
                    if($h==3){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->salary_advance_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->salary_advance_amount =0.00;
                        }
                    }
                    if($h==4){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->leave_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->leave_amount =0.00;
                        }
                    }
                    if($h==5){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->loan_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->loan_amount =0.00;
                        }
                    }
                    if($h==6){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->other_deduction = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->other_deduction =0.00;
                        }
                    }
                    if($h==7){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->total_addition_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->total_addition_amount =0.00;
                        }
                    }
                    if($h==8){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->total_deduction_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->total_deduction_amount =0.00;
                        }
                    }
                    if($h==9){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->total_salary_amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->total_salary_amount =0.00;
                        }
                    }
                    if($h==10){
                        if($data[$index_start]!=''){
                            $model_salary[$i]->remarks = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[$index_start]), '"'));
                        }else{
                            $model_salary[$i]->remarks ='';
                        }
                    }
                    $index_start++;
                }
                $model_salary[$i]->created_by = Yii::app()->user->id;
                $model_salary[$i]->created_date_time = date('Y-m-d H:i:s'); 
                $validate = $model_salary[$i]->validate() && $validate;
            }
        }
        if ($validate) {
            date_default_timezone_set("Asia/Dubai");
            $payroll_startdate=$year.'-'.$month.'-01';
            $payroll_enddate=date(''.$year.'-'.$month.'-t');
            $model_salary_master = new HrSalaryMasterMigrated();
            $model_salary_master->payroll_branch_or_sponsor_id = $branch;
            $model_salary_master->payroll_startdate = $payroll_startdate;
            $model_salary_master->payroll_enddate = $payroll_enddate;
            $model_salary_master->payroll_month = $month;
            $model_salary_master->payroll_year = $year;
            $model_salary_master->created_by = Yii::app()->user->id;
            $model_salary_master->created_date_time = date('Y-m-d H:i:s');
            $model_salary_master->save();
            //Salary Details
            if (!empty($model_salary)) {
                foreach ($model_salary as $eachModel) {  
                    $eachModel->salary_processing_id=$model_salary_master->id;
                    $eachModel->save();
                }
            }	
            if (!empty($model_salary_details)) {
                foreach ($model_salary_details as $eachModel) {  
                    $eachModel->salary_processing_id=$model_salary_master->id;
                    $eachModel->save();
                }
            }	
            $jsonData['error'] ="";	
        } else {			
            if (!empty($client_model)) {
                foreach ($client_model as $s => $data_model) {
                    $error_list[$s]['name'] =$data_model['name'];
                    $error_list[$s]['code'] =$data_model['code'];
                    $error_list[$s]['reply_email'] =$data_model['reply_email'];
                    $error_list[$s]['high_priority_day'] =$data_model['high_priority_day'];
                    $error_list[$s]['medium_priority_day'] =$data_model['medium_priority_day'];
                    $error_list[$s]['low_priority_day'] =$data_model['low_priority_day'];
                    $error_list[$s]['high_priority_time'] =$data_model['high_priority_time'];
                    $error_list[$s]['medium_priority_time'] =$data_model['medium_priority_time'];
                    $error_list[$s]['low_priority_time'] =$data_model['low_priority_time'];
                    if($data_model->validate()){
                    $error_list[$s]['remarks']     ="Correct";
                    }else{
                    $error_list[$s]['remarks']     =$data_model->getErrors();	
                    }
                }
            }	
	}				
              		 
	$j=0;
        fclose($file);
        $list = array(); 
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $title_string='Employee Code *';
            $model_salary_master=MasSalarytype::model()->findAll(array('condition' => 'salary_occurence="2"'));
            foreach ($model_salary_master as $key => $value) {
                $title_string.=',';
                $title_string.=$value->salary_name;
            }
            $title_string.=',Overtime Amount,Other Additions,Salary Advance,Leave Amount,Loan Amount,Other Deductions,Total Additions,Total Deductions,Total Salary Amount,Remarks,Error';        
            $list[$j++] =$title_string;
            foreach ($error_list as $i => $error_detail) {
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){						
                                $error_view[$i] .= $error_value[0]." / ";	
                        }
                    }else{
                        $error_view[$i] .= '';
                    }
                    $list[$j++] = $error_detail['name']. ',' .$error_detail['code']. ',' .$error_detail['reply_email']. ',' .$error_detail['high_priority_day']. ',' .$error_detail['medium_priority_day']. ',' .$error_detail['low_priority_day']. ',' .$error_detail['high_priority_time']. ',' .$error_detail['medium_priority_time']. ',' .$error_detail['low_priority_time']. ',' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
		

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('salarymigration/DownloadErrorCsv', 'id'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionViewSalaryDetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = HrSalaryMasterMigrated::model()->findbyPK($id);
        $model_salary_slip = HrSalaryMigration::model()->findAll(array('condition' => 'salary_processing_id="' . $model->id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view_salary_details', array('model' => $model, 'model_salary_slip' => $model_salary_slip), false, true);
    }
    public function actioneditsalarydetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = HrSalaryMasterMigrated::model()->findbyPK($id);
        $model_salary_slip = HrSalaryMigration::model()->findAll(array('condition' => 'salary_processing_id="' . $model->id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_salary_details', array('model' => $model, 'model_salary_slip' => $model_salary_slip), false, true);
    }
    public function actionEditEmployeeSalary() {
        $id = (int) Yii::app()->request->getParam('id');
        $employee_id = (int) Yii::app()->request->getParam('emp_id');
        $model_salary_slip = HrSalaryMigration::model()->find(array('condition' => 'salary_processing_id="' . $id . '" and employee_id="' . $employee_id . '"'));
        $model_salary_slip_details = HrSalaryMigrationDetails::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '" and employee_id="' . $employee_id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_employee_salary', array('model_salary_slip' => $model_salary_slip, 'model_salary_slip_details' => $model_salary_slip_details), false, true);
    }
    public function actionUpdateSalary() {
        if (isset($_POST['HrSalaryMigration'])) {
            if ((int) @$_POST['HrSalaryMigration']['id'] > 0) {
                $model_salary_slip = HrSalaryMigration::model()->findByPK($_POST['HrSalaryMigration']['id']);
                $model_salary_slip->salary_advance_amount = $_POST['HrSalaryMigration']['salary_advance_amount'];
                $model_salary_slip->leave_amount = $_POST['HrSalaryMigration']['leave_amount'];
                $model_salary_slip->loan_amount = $_POST['HrSalaryMigration']['loan_amount'];
                $model_salary_slip->overtime_amount = $_POST['HrSalaryMigration']['overtime_amount'];
                $model_salary_slip->other_addition = $_POST['HrSalaryMigration']['other_addition'];
                $model_salary_slip->other_deduction = $_POST['HrSalaryMigration']['other_deduction'];
                $total_addition = $_POST['HrSalaryMigration']['overtime_amount'] + $_POST['HrSalaryMigration']['other_addition'];
                $total_deduction = $_POST['HrSalaryMigration']['loan_amount'] + $_POST['HrSalaryMigration']['salary_advance_amount'] + $_POST['HrSalaryMigration']['leave_amount'] + $_POST['HrSalaryMigration']['other_deduction'];
                $model_salary_slip->total_addition_amount = $total_addition;
                $model_salary_slip->total_deduction_amount = $total_deduction;
                $model_salary_slip->total_salary_amount = $_POST['HrSalaryMigration']['total_salary_amount'];
                $model_salary_slip->remarks = $_POST['HrSalaryMigration']['remarks'];
                $model_salary_slip->updated_by = Yii::app()->user->id;
                $model_salary_slip->updated_date_time = date('Y-m-d h:i:s');
                $model_salary_slip->save();

                //Salary Slip Details
                if (isset($_POST['HrSalaryMigrationDetails'])) {
                    foreach ($_POST['HrSalaryMigrationDetails'] as $i => $item) {
                        if ($item['id'] > 0) {
                            $model_salary_slip_details = HrSalaryMigrationDetails::model()->findByPK($item['id']);
                            $model_salary_slip_details->salary_amount = $item['salary_amount'];
                            $model_salary_slip_details->updated_by = Yii::app()->user->id;
                            $model_salary_slip_details->updated_date_time = date('Y-m-d h:i:s');
                            $model_salary_slip_details->save();
                        } else {
                            if ($item['salary_amount'] > 0) {
                                $model_salary_slip_details = new HrSalaryMigrationDetails();
                                $model_salary_slip_details->salary_slip_id = $model_salary_slip->id;
                                $model_salary_slip_details->salary_id = $item['salary_id'];
                                $model_salary_slip_details->salary_name = $item['salary_name'];
                                $model_salary_slip_details->salary_type = $item['salary_type'];
                                $model_salary_slip_details->salary_amount = $item['salary_amount'];
                                $model_salary_slip_details->created_by = Yii::app()->user->id;
                                $model_salary_slip_details->created_date_time = date('Y-m-d h:i:s');
                                $model_salary_slip_details->save();
                            }
                        }
                    }
                }
                $jsonData['id'] = $model_salary_slip->salary_processing_id;
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
            echo CJSON::encode($jsonData);
        }
    }
    public function actionSalarySlip() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('salary_slip_form');
    }
    public function actiongetEmployeeName() {
        $id = $_POST['id'];
        if ($id > 0) {
            $jsonData['emp_name'] = CHtml::dropdownlist("slip_employee_id", '', HrSalaryMigration::getEmployee($id), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionPrintSalarySlip() {
        $id = Yii::app()->request->getParam('id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.salarymigration.salary_slip', array('employee_id' => $employee_id, 'id' => $id), true));
        $mPDF1->Output('salaryslip.pdf', 'I');
    }
}