<?php

class SalarycheckerController extends Controller {

    public function accessRules() {
        return array(array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), 'users' => array('*'),), array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'LoadCheckerTabContent', 'Checker', 'GetAdvanceDetailsChecker', 'GetLoanDetailsChecker', 'GetAttendanceDetailsChecker', 'GetEmployeeLeaveChecker', 'GetExpenseList', 'GetOverTimeList', 'GetPaymentCheckerDetails', 'GetibanDetails', 'GetBankRouteNoDetails', 'GetwpsEntityDetails', 'ticketChekerDetails', 'EmployeeTicketChecker', 'FamilyTicketChecker', 'PensionChecker', 'DependantTicketChecker','NetSalaryChecker','FlexiTimeChecker','GetimolDetails','ZeroSalaryChecker','SalaryComponentChecker','AttendanceAbsentChecker'), 'expression' => '$user->isMember()',), array('deny', // deny all users
                'users' => array('*'),),);
    }

    //code added by abin on 12-09-2023 to get the checker  contents 
    public function actionChecker() {
        $model_module_payroll= HrModules::model()->findByPK(7);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_checking_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')) {
            $this->render('checker');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

//code added by abin on 12-09-2023 to get the checker tab contents
    public function actionLoadCheckerTabContent() {
        $salary_branch_id = $_POST['salary_branch_id'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('checker_tab_contents', array('from_date' => $from_date, 'salary_branch_id' => $salary_branch_id, 'to_date' => $to_date));
    }

//code added by abin on 12-09-2023 to get the loan details when clicked on the amchart slices
    public function actionGetAdvanceDetailsChecker() {
        $model = new EmployeeSalaryAdvance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 't.employee_id',
            2 => 'employee_id',
            3 => 'advance_payment_date',
            4 => 'advance_payment_date',
            5 => 'amount',
            6 => 'advance_payment_status',
            7 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        $payment_start_date = $_POST['frmdate'];
        $payment_end_date = $_POST['todate'];
        $payment_start_date = date("Y-m-d", strtotime(str_replace('/', '-',  $payment_start_date)));
        $payment_end_date = date("Y-m-d", strtotime(str_replace('/', '-',  $payment_end_date)));
        $condition.= " AND apply_date  >= '" . $payment_start_date . "' AND  apply_date  <= '" .$payment_end_date . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' AND employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
       
        if ($status == '') {
            $condition .= " AND advance_payment_status IN (1,2,4,6,8,10)";
        } else {
            $condition .= " AND advance_payment_status = '" . $status . "'";
        }
    
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit));
        // print_r($model);die();
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $apply_date = '';
            if ($row['apply_date'] != '0000-00-00' && $row['apply_date'] != '') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            $approved_date = '';
            if ($row['approved_date'] != '0000-00-00') {
                $approved_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $advance_payment_date = '';
            if ($row['advance_payment_date'] != '0000-00-00') {
                $advance_payment_date = date("d/m/Y", strtotime($row['advance_payment_date']));
            }
            $rowData[] = array(++$m,$row->employeedetail->branch_sponsor->branch_or_sponsor_name,$row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $apply_date, $advance_payment_date, $row['amount'], EmployeeSalaryAdvance::getStatus($row['advance_payment_status']));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    //code added by abin on 12-09-2023 to get the loan details when clicked on the amchart slices
    public function actionGetLoanDetailsChecker() {
        $model = new EmployeeLoanDetail();
        $status = $_POST['loanstatus'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $columns = array(
            0 => 't.id',
            1 => 'employee_id',
            2 => 'employee_id',
            3 => 'loan_amount',
            4 => 'loan_monthly_payment',
            5 => 'loan_total_installment',
            6 => 'apply_date',
            7 => 'approved_date',
            8 => 'loan_repayment',
            9 => 'loan_status',
            10 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $loan_start_date = $_POST['frmdate'];
        $loan_end_date = $_POST['todate'];
        $loan_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $loan_start_date)));
        $loan_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $loan_end_date)));
        $condition = "apply_date  >= '" . $loan_start_date . "' AND  apply_date  <= '" . $loan_end_date . "'";
        if ($branch_id > 0) {
            $condition .= " AND employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        }
        if ($status == '') {
            $condition .= " AND loan_status IN (1,2,4,6,8)";
        } else {
            $condition .= " AND loan_status = '" . $status . "'";
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $loandate = '';
            $button_string='';
            if ($row['approved_date'] != '0000-00-00') {
                $loandate = date("d/m/Y", strtotime($row['approved_date']));
            }
            $applydate = "";
            if ($row['apply_date'] != '0000-00-00') {
                $applydate = date("d/m/Y", strtotime($row['apply_date']));
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_loan_hierarchy_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string = '<button class="btn btn-primary btn-xs" title="Approval Hierarchy" onclick="loadPopupModal(\'hr/loandetail/approvalhierarchy&function_type=2&employee_id=' . $row['employee_id'] . '\',\'Employee Hierarchy\',\'md\')"><i class="fa fa-book"></i></button>&nbsp;';
            }
            $rowData[] = array(++$m, $row->employeedetail->branch_sponsor->branch_or_sponsor_name, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['loan_amount'], $row['loan_monthly_payment'], $row['loan_total_installment'], $applydate, $loandate, $row['loan_repayment'], EmployeeLoanDetail::getLoanStatus($row['loan_status']),$button_string);
            }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

//code added by abin on 15-09-2023 to get the Leave details when clicked on the salary checker amchart slices
    public function actionGetEmployeeLeaveChecker() {
        $model = new EmployeeLeaveDetail();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = $_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 'employee_id',
            2 => 'view_status',
            3 => 'apply_date',
            4 => 'leave_type',
            5 => 'leave_start_date',
            6 => 'leave_end_date',
            7 => 'no_days',
            8 => 'leave_status',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $branch_id = $_POST['branch_id'];
        $leave_start_date = $_POST['frmdate'];
        $leave_end_date = $_POST['todate'];
        $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $leave_start_date)));
        $to_date = date("Y-m-d", strtotime(str_replace('/', '-', $leave_end_date)));
        $condition = "((leave_start_date<='" . $from_date . "' AND leave_end_date>='" . $to_date . "') OR  (leave_start_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'
                                            OR leave_end_date BETWEEN  '" . $from_date . "' AND  '" . $to_date . "'))";
        if ($branch_id > 0) {
            $condition .= " AND employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        }
        if ($status == '') {
            $condition .= " AND leave_status IN (1,2,4,6,8,10,14,15,17,19,21,23)";
        } else {
            $condition .= " AND leave_status = '" . $status . "'";
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' AND employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " AND (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'leave_start_date,leave_status asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $h => $row) {
            $button_string='';
            $apply_date = $leave_start_date = $leave_end_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_hierarchy_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Approval Hierarchy" onclick="loadPopupModal(\'hr/leave/approvalhierarchy&function_type=1&employee_id=' . $row['employee_id'] . '\',\'Employee Hierarchy\',\'md\')"><i class="fa fa-book"></i></button>&nbsp;';
            }
            $status = EmployeeLeaveDetail::getstatuswithapprover($row->id);
            $rowData[] = array(++$m, $row->employeedetail->branch_sponsor->branch_or_sponsor_name, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $apply_date, $row->leavetype->leave_name, $leave_start_date, $leave_end_date, $row->no_days, $status,$button_string);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

//code added by abin on 15-09-2023 to get the attendance details when clicked on the amchart slices
    public function actionGetAttendanceDetailsChecker() {
        $model = new EmployeeAttendance();

        // Initialize variables
        $draw = $_POST['draw'] ?? '';  // Draw for DataTables
        $offset = $_POST['start'] ?? 0;  // Offset for pagination
        $limit = $_POST['length'] ?? 10;  // Limit for pagination
        $status = $_POST['status'] ?? '';  // Status filter
        $branch_id = $_POST['branch_id'] ?? '';  // Branch ID filter
        $from_date = $_POST['from_date'] ?? '';  // From date filter
        $to_date = $_POST['to_date'] ?? '';  // To date filter

        $condition = 'status = "2"';  // Default condition
        // Add branch ID condition if provided
        if (!empty($branch_id)) {
            $condition .= " AND employeedetail.branch_or_sponsor_id = '" . $branch_id . "'";
        }

        // Add status condition if provided
        if (!empty($status)) {
            $condition .= " AND status = '" . $status . "'";
        }

        // Add date range condition if both from_date and to_date are provided
        if (!empty($from_date) && !empty($to_date)) {
            $condition .= " AND (attendance_date BETWEEN '" . $from_date . "' AND '" . $to_date . "')";
        }

        // Get the count of matching records
        $count = $model->with('employeedetail')->count(array('condition' => $condition));

        // Get the records with the applied conditions, limit, and offset
        $attendanceData = $model->with('employeedetail')
                ->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset
        ));

        // Prepare the data to be returned
        $rowData = array();
        $m = $offset + 1;  // For row numbering, starting from the offset + 1
        foreach ($attendanceData as $row) {
            $rowData[] = array(
                $m, // Row number
                $row['employeedetail']['employeefullname'], // Employee name
                $row['attendance_date'], // Attendance date
                $row['status']  // Attendance status
            );
            $m++;
        }

        // Prepare the final output
        $data = array(
            'draw' => $draw,
            'recordsTotal' => $count, // Total number of records
            'recordsFiltered' => $count, // Filtered number of records (same as total in this case)
            'data' => $rowData  // The actual data
        );

        // Return the data as JSON
        echo json_encode($data);
    }

    // Get employee expense details
    public function actionGetExpenseList() {
        $model = new EmployeeExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $status = $_POST['expstatus'];
        // Columns configuration
        $columns = array(
            0 => 't.id',
            1 => 't.id',
            2 => 'employeedetail.employee_code',
            3 => 'employeedetail.first_name',
            4 => 'created_date',
            5 => 'approved_date',
            6 => 'total',
            7 => 'status'
        );
        $orderBy = "t.id ASC";  // Static ordering by `t.id` or any default column.
        // Apply date range filter
        $apply_from_date = $_POST['frmdate'];
        $apply_to_date = $_POST['todate'];
        $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $apply_from_date)));
        $todate = date("Y-m-d", strtotime(str_replace('/', '-', $apply_to_date)));
        $condition = "created_date <= '" . $todate . "'";
        // Apply branch filter if provided
        if ($branch_id) {
            $condition .= " AND employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        }
        if ($status == '') {
            $condition .= " AND status IN (1,2,4,6,8,10)";
        } else {
            $condition .= " AND status = '" . $status . "'";
        }
        // Apply user-related condition
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' AND employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        // Count the total records based on the final condition
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        // Fetch records with applied conditions (without any dynamic search/filter)
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        // Prepare the data response
        $recordsTotal = $count;
        $recordsFiltered = $count;  // Records filtered will be the same as the total in this case.
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        // Process each row and generate the required response data
        foreach ($model as $row) {
            $button_string="";
            // Format the created date and approved date
            $created_date = "";
            $approve_date = "";
            if ($row['created_date'] != '0000-00-00' && $row['created_date'] != '') {
                $created_date = date("d/m/Y", strtotime($row['created_date']));
            }
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approve_date = date("d/m/Y", strtotime($row['approved_date']));
            }
             if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_expense_hierarchy_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string = '<button class="btn btn-primary btn-xs" title="Approval Hierarchy" onclick="loadPopupModal(\'hr/hrrequest/approvalhierarchy&function_type=7&employee_id=' . $row['employee_id'] . '\',\'Employee Hierarchy\',\'md\')"><i class="fa fa-book"></i></button>&nbsp;';
            }
            // Add data to the rowData array
            $rowData[] = array(
                ++$m,
                $row->employeedetail->branch_sponsor->branch_or_sponsor_name,
                $row['employeedetail']['employeecode'],
                $row['employeedetail']['employeefullname'],
                $created_date,
                $approve_date,
                number_format($row['total'], 2),
                EmployeeExpense::getStatus($row['status']),
                $button_string
            );
        }
        // Final data response
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetOverTimeList() {
        $model = new HrOutsourceOvertime();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch = $_POST['branch_id'];
        $to_date = $_POST['todate'];
        $condition = '';

        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employeecode',
            2 => 'employeedetail.employeefullname',
            3 => 'normal_overtime',
            4 => 'holiday_overtime',
            5 => 'night_overtime',
            6 => 'weekend_overtime'
        );

        // Build conditions based on inputs
        $conditionsAdded = false;  // Flag to track if any condition has been added

        if ($branch != '') {
            $condition .= " employeedetail.branch_or_sponsor_id = '" . $branch . "'";
            $conditionsAdded = true;  // Mark that a condition has been added
        }

        // Handling the to_date and extracting month/year
        if ($to_date != '') {
            // Split the to_date into day, month, and year (DD/MM/YYYY format)
            $date_parts = explode('/', $to_date);

            // Ensure there are 3 parts (day, month, year)
            if (count($date_parts) == 3) {
                $day = $date_parts[0];
                $month = $date_parts[1];
                $year = $date_parts[2];

                // Ensure the month and year are correct, and construct the valid date format
                $formatted_date = $year . '-' . $month . '-' . $day;

                // Create a DateTime object to check the validity
                $date = DateTime::createFromFormat('Y-m-d', $formatted_date);

                // If valid, extract the month and year
                if ($date) {
                    $month = $date->format('m');  // Extract month (e.g., '11')
                    $year = $date->format('Y');   // Extract year (e.g., '2024')
                } else {
                    echo "Invalid to_date format.";
                    return;  // Stop further execution if the date is invalid
                }
            } else {
                echo "Invalid to_date format.";
                return;  // Stop further execution if the format is incorrect
            }
        } else {
            // If no to_date is provided, set month and year to empty
            $month = '';
            $year = '';
        }

        // Add the month and year to the condition if they are available
        if ($month != '' && $year != '') {
            if ($conditionsAdded) {
                $condition .= " AND overtime_month = '" . $month . "' AND overtime_year = '" . $year . "'";
            } else {
                $condition .= " overtime_month = '" . $month . "' AND overtime_year = '" . $year . "'";
            }
        }

        // Fetch the total count of records matching the condition
        $count = $model->with('employeedetail')->count(array('condition' => $condition));

        // Retrieve the actual records with the same condition
        $model = $model->with('employeedetail')->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset,
            'order' => 'employeedetail.de_first_name ASC'
        ));

        // Prepare the data response
        $recordsTotal = $count;
        $recordsFiltered = $count;  // Records filtered will be the same as the total in this case.
        // Ensure $data is initialized
        $data = [];

        // Assign values to $data properties
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        // Initialize total overtime variables
        $total_normal_overtime = 0;
        $total_holiday_overtime = 0;
        $total_night_overtime = 0;
        $total_weekend_overtime = 0;

        // Check if $model is not empty
        if (!empty($model)) {
            // Loop through the model data and calculate totals
            foreach ($model as $index => $row) {
                // Get the overtime values for each employee
                $normal_overtime = $row['normal_overtime'];
                $holiday_overtime = $row['holiday_overtime'];
                $night_overtime = $row['night_overtime'];
                $weekend_overtime = $row['weekend_overtime'];

                // Update the running totals for overtime
                $total_normal_overtime += $normal_overtime;
                $total_holiday_overtime += $holiday_overtime;
                $total_night_overtime += $night_overtime;
                $total_weekend_overtime += $weekend_overtime;

                // Add the employee data to the 'data' array
                $data['data'][] = [
                    $index + 1, // No
                    $row['employeedetail']['branch_sponsor']['branch_or_sponsor_name'], // HR Code
                    $row['employeedetail']['employeecode'], // Employee Code
                    $row['employeedetail']['employeefullname'], // Employee Name
                    number_format($normal_overtime, 2), // Normal Overtime
                    number_format($holiday_overtime, 2), // Holiday Overtime
                    number_format($night_overtime, 2), // Night Overtime
                    number_format($weekend_overtime, 2), // Weekend Overtime
                    number_format($normal_overtime + $holiday_overtime + $night_overtime + $weekend_overtime, 2)  // Total Overtime
                ];
            }

            // Only add the total row if any of the totals are non-zero
            if ($total_normal_overtime || $total_holiday_overtime || $total_night_overtime || $total_weekend_overtime) {
                $data['data'][] = [
                    '', // Merged columns for 'Total'
                    '', // Empty column
                    '<div style="text-align:right; font-weight: bold;">Total</div>', // Text 'Total' for the total row
                    '', // Empty column
                    '<b>' . number_format($total_normal_overtime, 2) . '</b>', // Total Normal Overtime
                    '<b>' . number_format($total_holiday_overtime, 2) . '</b>', // Total Holiday Overtime
                    '<b>' . number_format($total_night_overtime, 2) . '</b>', // Total Night Overtime
                    '<b>' . number_format($total_weekend_overtime, 2) . '</b>', // Total Weekend Overtime
                    '<b>' . number_format($total_normal_overtime + $total_holiday_overtime + $total_night_overtime + $total_weekend_overtime, 2) . '</b>'  // Total Overtime Sum
                ];
            }
        } else {
            // If $model is empty, ensure 'data' is an empty array
            $data['data'] = [];
        }

        // Encode the $data array into JSON and echo it
        echo json_encode($data);
    }

    public function actionGetPaymentCheckerDetails() {
        $model = new EmployeePayment();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'TYPE',
            2 => 'employee_code',
            3 => 'first_name',
            4 => 'approved_date',
            5 => 'amount'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        //$orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';
        $condition .= " AND TYPE != 'End of Service'";

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $approved_date = "";
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approved_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $paymnt_type = $row['TYPE'];
            $rowData[] = array(
                $m,
                $row['branch_sponsor']['branch_or_sponsor_name'],
                $this->ciphertext($row['employee_code'], 'd'),
                $this->ciphertext($row['first_name'], 'd') . ' ' . $this->ciphertext($row['last_name'], 'd'),
                $paymnt_type,
                $approved_date,
                Yii::app()->numberFormatter->formatCurrency($row['amount'], ""));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetibanDetails() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $department = $_POST['dept'];
        $designation = $_POST['desg'];
        $branch_id = $_POST['branch_id'];
        $status = $_POST['status'];
        $team = $_POST['team'];
        $report_id = $_POST['report_id'];
        $employee_status = $_POST['employee_status'];
        $columns = array(
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'employee_code',
        );
        
        $condition = 't.isActive="Y"';
        
        // Add conditions for `employee_iban_no` field
        $ibanCondition = '';
        
        // Condition where `employee_iban_no` is greater than 23 characters
        $ibanCondition .= ' OR LENGTH(employee_iban_no) > 23';
        
        // Condition where `employee_iban_no` is less than 23 characters
        $ibanCondition .= ' OR LENGTH(employee_iban_no) < 23';
        
        // Condition where `employee_iban_no` contains extra spaces (more than one consecutive space)
        $ibanCondition .= ' OR employee_iban_no LIKE "%  %"'; // This checks for extra spaces in the IBAN
        
        // Condition to exclude IBANs that start with "AE" and are followed by exactly 21 digits
        $ibanCondition .= ' OR NOT (employee_iban_no LIKE "AE%" AND LENGTH(employee_iban_no) = 23 AND employee_iban_no REGEXP "^[A-Za-z]{2}[0-9]{21}$")';
        
        // Condition to check for duplicate `employee_iban_no` (same IBAN in multiple records)
        $ibanCondition .= ' OR employee_iban_no IN (SELECT employee_iban_no FROM erp_hr_employee WHERE employee_iban_no != "" GROUP BY employee_iban_no HAVING COUNT(employee_iban_no) > 1)';
        
        // Add the conditions for `employee_iban_no` to the main condition
        if (!empty($ibanCondition)) {
            $condition .= ' AND (' . substr($ibanCondition, 3) . ')'; // Remove the first 'OR' and concatenate the conditions
        }
        
        $count = $model->count(array('condition' => $condition));
        
        // Fetch the employee data based on the condition
        $model = $model->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset,
            'order' => 'id asc'
        ));
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        
        $rowData = array();
        $m = $offset;
        
        // Loop through the fetched records and prepare the response data
        $ibanDuplicates = array();
        foreach ($model as $row) {
            // If an IBAN already exists, mark it as a duplicate
            if (isset($ibanDuplicates[$row['employee_iban_no']])) {
                $ibanDuplicates[$row['employee_iban_no']][] = $row;
            } else {
                $ibanDuplicates[$row['employee_iban_no']] = [$row];
            }
        }
        
        // Loop through the fetched records and prepare the response data
        foreach ($model as $row) {
            $ibanLength = strlen($row['employee_iban_no']);
            
            // Check if the current row is a duplicate
            $isDuplicate = count($ibanDuplicates[$row['employee_iban_no']]) > 1 ? true : false;
        
            // Add the row data, including a flag for duplicate rows
            $rowData[] = array(
                ++$m,
                $row['branch_sponsor']['branch_or_sponsor_name'],
                $this->ciphertext($row['employee_code'], "d"),
                $this->ciphertext($row['first_name'], "d") . ' ' . $this->ciphertext($row['last_name'], "d"),
                $row['employee_iban_no'],
                $isDuplicate // Flag indicating if this row is a duplicate
            );
        }
        
        $data['data'] = $rowData;
        echo json_encode($data);
        
    }

    public function actionGetBankRouteNoDetails() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $department = $_POST['dept'];
        $designation = $_POST['desg'];
        $branch_id = $_POST['branch_id'];
        $status = $_POST['status'];
        $team = $_POST['team'];
        $report_id = $_POST['report_id'];
        $employee_status = $_POST['employee_status'];
        $columns = array(
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'employee_code',
        );

        $condition = 't.isActive="Y"';

        // Add conditions for `employee_wpscode` field
        $wpsCodeCondition = '';

        // Condition where `employee_wpscode` length is either less than 9 or greater than 9
        $wpsCodeCondition .= ' OR LENGTH(employee_wpscode) < 9';
        $wpsCodeCondition .= ' OR LENGTH(employee_wpscode) > 9';

        // Condition where `employee_wpscode` contains extra spaces (leading, trailing, or multiple spaces)
        $wpsCodeCondition .= ' OR employee_wpscode LIKE " %"';  // Leading space
        $wpsCodeCondition .= ' OR employee_wpscode LIKE "% "';  // Trailing space
        $wpsCodeCondition .= ' OR employee_wpscode LIKE "%  %"'; // Multiple spaces
        // Add the conditions for `employee_wpscode` to the main condition
        if (!empty($wpsCodeCondition)) {
            $condition .= ' AND (' . substr($wpsCodeCondition, 3) . ')'; // Remove the first 'OR' and concatenate the conditions
        }

        // Count the total number of employees that match the condition
        $count = $model->count(array('condition' => $condition));

        // Fetch the employee data based on the condition
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id asc'));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = $offset;

        // Loop through the fetched records and prepare the response data
        foreach ($model as $row) {
            $wpsCodeLength = strlen($row['employee_wpscode']);  // Get the length of employee_wpscode
            $rowData[] = array(
                ++$m,
                $row['branch_sponsor']['branch_or_sponsor_name'],
                $this->ciphertext($row['employee_code'], "d"),
                $this->ciphertext($row['first_name'], "d") . ' ' . $this->ciphertext($row['last_name'], "d"),
                $row['employee_wpscode'], // Display the employee_wpscode
            );
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetwpsEntityDetails() {

        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $department = $_POST['dept'];
        $designation = $_POST['desg'];
        $branch_id = $_POST['branch_id'];
        $status = $_POST['status'];
        $team = $_POST['team'];
        $report_id = $_POST['report_id'];
        $employee_status = $_POST['employee_status'];
        $columns = array(
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'employee_code',
        );

        $condition = 't.isActive="Y"';

        // Add a condition to check for empty employee_wps_company_name
        $condition .= ' AND (t.employee_wps_company IS NULL OR t.employee_wps_company = "")';

        // Count the total number of employees that match the condition
        $count = $model->count(array('condition' => $condition));

        // Fetch the employee data based on the condition
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id asc'));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = $offset;

        // Loop through the fetched records and prepare the response data
        foreach ($model as $row) {
            $wpsCodeLength = strlen($row['employee_wpscode']);  // Get the length of employee_wpscode
            $rowData[] = array(
                ++$m,
                $row['branch_sponsor']['branch_or_sponsor_name'],
                $this->ciphertext($row['employee_code'], "d"),
                $this->ciphertext($row['first_name'], "d") . ' ' . $this->ciphertext($row['last_name'], "d"),
            );
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    function processPayrollWithTicket($joiningDate, $payrollStartDate, $payrollEndDate) {
        $joinDate = new DateTime($joiningDate);
        $payrollStart = new DateTime($payrollStartDate);
        $payrollEnd = new DateTime($payrollEndDate);
        // Check if the employee has completed at least 1 year of service before the end of the payroll period
        $oneYearAfterJoining = clone $joinDate;
        $oneYearAfterJoining->modify('+1 year');

        // Check if the joining date is within the payroll period and the employee has completed 1 year
        if ($joinDate <= $payrollEnd && $oneYearAfterJoining <= $payrollEnd) {
            // Check if the joining month matches the payroll period (i.e., employee joins within the same month)
            $joinMonth = $joinDate->format('m');
            if ($payrollStart->format('m') == $joinMonth) {
                // Employee is eligible for the ticket
                return true;
            }
        }

        // If any condition is not met
        return false;
    }

    function processPayrollWithTicketold($joiningDate, $payrollStartDate, $payrollEndDate) {
        $nextTicketDateStr = null;
        $joinDate = new DateTime($joiningDate);
        $currentYear = (new DateTime())->format('Y');
        $currentYearAnniversary = new DateTime($currentYear . '-' . $joinDate->format('m-d'));
        $oneYearAfterJoining = clone $joinDate;
        $oneYearAfterJoining->modify('+1 year');
        if (new DateTime() >= $oneYearAfterJoining) {
            $nextTicketDateStr = $currentYearAnniversary->format('Y-m-d');
        }
        $payrollStart = new DateTime($payrollStartDate);
        $payrollEnd = new DateTime($payrollEndDate);
        if ($nextTicketDateStr === null) {
            return false;
        }
        $nextTicketDate = new DateTime($nextTicketDateStr);
        if ($nextTicketDate >= $payrollStart && $nextTicketDate <= $payrollEnd) {
            return true;
        } else {
            return false;
        }
    }

    function getserviceyear($joining_date, $payroll_start) {
        $date1 = new DateTime($joining_date);
        $date2 = new DateTime($payroll_start);
        $dd = date_diff($date1, $date2);
        $service_yr = $dd->y;
        return $service_yr;
    }

    public function actionticketChekerDetails() {
        // Get the form date and to date
        $frmdate = $_POST['frmdate'];
        $todate = $_POST['todate'];

        $payroll_startdate = Yii::app()->request->getParam('frmdate');
        $payroll_startdate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_startdate)));
        $payroll_enddate = Yii::app()->request->getParam('todate');
        $payroll_enddate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_enddate)));

        // Format the frmdate and todate to MySQL compatible date
        $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $frmdate)));
        $todate = date("Y-m-d", strtotime(str_replace('/', '-', $todate)));

        // Extract the month from the frmdate (start date)
        $from_month = date("m", strtotime($from_date));
        $start_of_current_year = date("Y-01-01");

        // Initialize rowData and counter
        $rowData = array();
        $m = 0;

        // Build the condition for employee filtering
        $condition = "1=1 AND isActive='Y'";
        $condition .= ' AND travel_allowance IS NOT NULL ';
        $condition .= ' AND MONTH(date_join) = ' . $from_month;
        $condition .= ' AND date_join <= "' . $start_of_current_year . '"';

        // Debugging: Output the condition to verify correctness
        // Yii::log("Condition for employee query: " . $condition, CLogger::LEVEL_INFO);
        // Fetch employees based on condition
        $model_employee = Employee::model()->findAll(array(
            'condition' => $condition,
            'order' => 'de_first_name ASC'
        ));

        // Debugging: Log the number of employees fetched
        // Yii::log("Number of employees fetched: " . count($model_employee), CLogger::LEVEL_INFO);

        if (empty($model_employee)) {
            // If no employees are found, output debug information
            echo json_encode([
                "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            ]);
            return;
        }
        $total_employee_ticket_amount = 0.00;
        $total_spouse_ticket_amount = 0.00;
        $total_child_ticket_amount = 0.00;
        $total_infant_ticket_amount = 0.00;
        $total_grand_total = 0.00;

        $rowData = array(); // Initialize an array to store the data
        $m = 0; // Counter for row index
        // Payroll period for calculation
        // Loop through each employee
        foreach ($model_employee as $v => $each_employee) {
            // Reset ticket amounts for each employee
            $employee_ticket_amount = $spouse_ticket_amount = $child_ticket_amount = $infant_ticket_amount = $total_ticket_amount = 0.00;

            // Check if the employee has a valid joining date
            if ($each_employee->date_join != '' && $each_employee->date_join != '0000-00-00' && ($each_employee->travel_allowance == 1 || $each_employee->travel_allowance == 2)) {

                // Check if ticket is available for the employee
                $ticket_available = $this->processPayrollWithTicket($each_employee->date_join, $payroll_startdate, $payroll_enddate);

                if ($ticket_available === true) {
                    // Fetch employee ticket details from the master table
                    $model_master_ticket = HrMasTicketDetails::model()->find(array(
                        'condition' => 'ticket_type="E" AND FIND_IN_SET(' . $each_employee->nationality . ', country_ids) AND FIND_IN_SET(' . $each_employee->designation . ', designation_id)'
                    ));

                    if (!empty($model_master_ticket)) {
                        $employee_ticket_amount += $model_master_ticket->ticket_amount;
                        $total_ticket_amount += $model_master_ticket->ticket_amount;
                    }

                    // Check if the employee has family ticket available
                    if ($each_employee->family_ticket == 'Y') {
                        // Fetch dependants with available tickets
                        $model_dependant = EmployeeDependants::model()->findAll(array(
                            'condition' => 'ticket_available="Y" AND employee_id="' . $each_employee->id . '"'
                        ));

                        if (!empty($model_dependant)) {
                            foreach ($model_dependant as $key_tkt => $value_dept) {
                                $individual_tkt_amt = 0.00;

                                // Handle tickets for spouse or children (relationships 3 or 4)
                                if ($value_dept->relationship == 3 || $value_dept->relationship == 4) {
                                    $model_master_ticket = HrMasTicketDetails::model()->find(array(
                                        'condition' => 'ticket_type="D" AND FIND_IN_SET(' . $each_employee->nationality . ', country_ids) AND FIND_IN_SET(' . $each_employee->designation . ', designation_id) AND relation_type="' . $value_dept->relationship . '"'
                                    ));

                                    if (!empty($model_master_ticket)) {
                                        $individual_tkt_amt = $model_master_ticket->ticket_amount;
                                        if ($model_master_ticket->ticket_availed == 2) {
                                            $individual_tkt_amt = round($model_master_ticket->ticket_amount / 2);
                                        }
                                        $spouse_ticket_amount = $individual_tkt_amt;
                                        $total_ticket_amount += $individual_tkt_amt;
                                    }
                                }
                                // Handle infant tickets (relationship 5)
                                else if ($value_dept->relationship == 5) {
                                    $nominee_age_below_2 = $this->getserviceyear($value_dept->date_of_birth, $payroll_enddate);
                                    $tkt_eligibility = $this->isEligibleForTkt($value_dept->date_of_birth, $payroll_startdate, $payroll_enddate);

                                    // If the infant is below 2 years old
                                    if ($nominee_age_below_2 < 2) {
                                        $model_master_ticket = HrMasTicketDetails::model()->find(array(
                                            'condition' => 'ticket_type="D" AND FIND_IN_SET(' . $each_employee->nationality . ', country_ids) AND FIND_IN_SET(' . $each_employee->designation . ', designation_id) AND relation_type="' . $value_dept->relationship . '" AND age_limit=2'
                                        ));

                                        if (!empty($model_master_ticket)) {
                                            $individual_tkt_amt = $model_master_ticket->ticket_amount;
                                            if ($model_master_ticket->ticket_availed == 2) {
                                                $individual_tkt_amt = round($model_master_ticket->ticket_amount / 2);
                                            }
                                            $infant_ticket_amount += $individual_tkt_amt;
                                        }
                                    }
                                    // If the infant is eligible for a ticket (above 2 years old)
                                    else if ($tkt_eligibility == true) {
                                        $model_master_ticket = HrMasTicketDetails::model()->find(array(
                                            'condition' => 'ticket_type="D" AND FIND_IN_SET(' . $each_employee->nationality . ', country_ids) AND FIND_IN_SET(' . $each_employee->designation . ', designation_id) AND relation_type="' . $value_dept->relationship . '" AND age_limit=18'
                                        ));

                                        if (!empty($model_master_ticket)) {
                                            $individual_tkt_amt = $model_master_ticket->ticket_amount;
                                            if ($model_master_ticket->ticket_availed == 2) {
                                                $individual_tkt_amt = round($model_master_ticket->ticket_amount / 2);
                                            }
                                            $child_ticket_amount += $individual_tkt_amt;
                                        }
                                    }
                                    $total_ticket_amount += $individual_tkt_amt;
                                }
                                // Handle female dependants (relationship 6)
                                else if ($value_dept->relationship == 6) {
                                    $nominee_age_below_2 = $this->getserviceyear($value_dept->date_of_birth, $payroll_enddate);

                                    // If the female dependant is under 2 years old
                                    if ($nominee_age_below_2 < 2) {
                                        $model_master_ticket = HrMasTicketDetails::model()->find(array(
                                            'condition' => 'ticket_type="D" AND FIND_IN_SET(' . $each_employee->nationality . ', country_ids) AND FIND_IN_SET(' . $each_employee->designation . ', designation_id) AND relation_type="' . $value_dept->relationship . '" AND age_limit=2'
                                        ));

                                        if (!empty($model_master_ticket)) {
                                            $individual_tkt_amt = $model_master_ticket->ticket_amount;
                                            if ($model_master_ticket->ticket_availed == 2) {
                                                $individual_tkt_amt = round($model_master_ticket->ticket_amount / 2);
                                            }
                                            $total_ticket_amount += $individual_tkt_amt;
                                            $infant_ticket_amount += $individual_tkt_amt;
                                        }
                                    }
                                    // For unmarried female dependants above 2 years
                                    else if ($value_dept->marital_status == 1) {
                                        $individual_tkt_amt = 0.00;
                                        $model_master_ticket = HrMasTicketDetails::model()->find(array(
                                            'condition' => 'ticket_type="D" AND FIND_IN_SET(' . $each_employee->nationality . ', country_ids) AND FIND_IN_SET(' . $each_employee->designation . ', designation_id) AND relation_type="' . $value_dept->relationship . '" AND age_limit=18'
                                        ));

                                        if (!empty($model_master_ticket)) {
                                            $individual_tkt_amt = $model_master_ticket->ticket_amount;
                                            if ($model_master_ticket->ticket_availed == 2) {
                                                $individual_tkt_amt = round($model_master_ticket->ticket_amount / 2);
                                            }
                                            $child_ticket_amount += $individual_tkt_amt;
                                        }
                                        $total_ticket_amount += $individual_tkt_amt;
                                    }
                                    // For married female dependants with no ticket available
                                    else if ($value_dept->marital_status == 2) {
                                        $total_ticket_amount += 0.00;
                                    }
                                }
                            }
                        }
                    }
                }

                // Add the employee data to rowData if there is any ticket amount
                if ($total_ticket_amount > 0) {
                    $rowData[] = array(
                        ++$m,
                        $each_employee->branch_sponsor->branch_or_sponsor_name,
                        $this->ciphertext($each_employee->employee_code, "d"),
                        $this->ciphertext($each_employee->first_name, "d") . ' ' . $this->ciphertext($each_employee->last_name, "d"),
                        $each_employee->employeenationality->nationality,
                        date("d/m/Y", strtotime($each_employee->date_join)),
                        $each_employee->designationdetail->designation_name,
                        number_format($employee_ticket_amount, 2),
                        number_format($spouse_ticket_amount, 2),
                        number_format($child_ticket_amount, 2),
                        number_format($infant_ticket_amount, 2),
                        number_format($total_ticket_amount, 2)
                    );

                    $total_employee_ticket_amount += $employee_ticket_amount;
                    $total_spouse_ticket_amount += $spouse_ticket_amount;
                    $total_child_ticket_amount += $child_ticket_amount;
                    $total_infant_ticket_amount += $infant_ticket_amount;
                    $total_grand_total += $total_ticket_amount;
                }
            }
        }

        $rowData[] = array(
            "", // Label for totals row
            "<div style='text-align:right; font-weight: bold;'>Total</div>", // Empty field for employee code
            "", // Empty field for HR code
            "", // Empty field for employee name
            "", // Empty field for nationality
            "", // Empty field for date join
            "", // Empty field for designation
            '<b>' . number_format($total_employee_ticket_amount, 2) . '</b>',
            '<b>' . number_format($total_spouse_ticket_amount, 2) . '</b>',
            '<b>' . number_format($total_child_ticket_amount, 2) . '</b>',
            '<b>' . number_format($total_infant_ticket_amount, 2) . '</b>',
            '<b>' . number_format($total_grand_total, 2) . '</b>'
        );



        // Return the data to DataTable
        $data = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($rowData),
            "recordsFiltered" => count($rowData),
            "data" => $rowData
        );

        // Return the JSON response
        echo json_encode($data);
    }

    function isEligibleForTkt($birthDate, $payrollStartDate, $payrollEndDate) {
        //Age as of month Start
        $birthDate_1 = new DateTime($birthDate);
        $checkDate_1 = new DateTime($payrollStartDate);
        $age_1 = $checkDate_1->diff($birthDate_1);
        $ageAtStart = ['years' => $age_1->y, 'months' => $age_1->m, 'days' => $age_1->d];
        //Age as of month End
        $birthDate_2 = new DateTime($birthDate);
        $checkDate_2 = new DateTime($payrollEndDate);
        $age_2 = $checkDate_2->diff($birthDate_2);
        $ageAtEnd = ['years' => $age_2->y, 'months' => $age_2->m, 'days' => $age_2->d];
        // If the person is 18 years, 0 months, and at least 1 day before the payroll period start date, they are not eligible
        if (($ageAtStart['years'] > 18) || ($ageAtStart['years'] == 18 && ($ageAtStart['months'] > 0 || $ageAtStart['days'] > 0))) {
            return false; // Not eligible if age is 18+ at the start of the month
        } else if (($ageAtEnd['years'] >= 18) && ($ageAtEnd['years'] == 18 && ($ageAtStart['months'] == 0 && $ageAtStart['days'] > 0))) {
            return true; //Eligible if they turn 18 during the payroll month
        } else if ($ageAtEnd['years'] >= 2 && $ageAtEnd['years'] < 18) {
            return true; //Eligible from 2 upto less than 18
        }
        return false;
    }

    public function actionEmployeeTicketChecker() {
        // Get the form date and to date
        $frmdate = $_POST['frmdate'];
        $todate = $_POST['todate'];

        $payroll_startdate = Yii::app()->request->getParam('frmdate');
        $payroll_startdate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_startdate)));
        $payroll_enddate = Yii::app()->request->getParam('todate');
        $payroll_enddate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_enddate)));

        // Format the frmdate and todate to MySQL compatible date
        $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $frmdate)));
        $todate = date("Y-m-d", strtotime(str_replace('/', '-', $todate)));

        // Extract the month from the frmdate (start date)
        $from_month = date("m", strtotime($from_date));
        $start_of_current_year = date("Y-01-01");

        // Initialize rowData and counter
        $rowData = array();
        $m = 0;

        // Build the condition for employee filtering
        $condition = "1=1 AND isActive='Y'";
        $condition .= ' AND (travel_allowance = "") ';
        //$condition .= ' AND MONTH(date_join) = ' . $from_month; 
        $condition .= ' AND date_join <= "' . $start_of_current_year . '"';

        // Debugging: Output the condition to verify correctness
        // Yii::log("Condition for employee query: " . $condition, CLogger::LEVEL_INFO);
        // Fetch employees based on condition
        $model_employee = Employee::model()->findAll(array(
            'condition' => $condition,
            'order' => 'de_first_name ASC'
        ));

        // Debugging: Log the number of employees fetched
        // Yii::log("Number of employees fetched: " . count($model_employee), CLogger::LEVEL_INFO);

        if (empty($model_employee)) {
            // If no employees are found, output debug information
            echo json_encode([
                "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            ]);
            return;
        }

        // Payroll period for calculation
        // Loop through each employee
        foreach ($model_employee as $v => $each_employee) {



            // Add the employee data to rowData if there is any ticket amount

            $rowData[] = array(
                ++$m,
                $each_employee->branch_sponsor->branch_or_sponsor_name,
                $this->ciphertext($each_employee->employee_code, "d"),
                $this->ciphertext($each_employee->first_name, "d") . ' ' . $this->ciphertext($each_employee->last_name, "d"),
                $each_employee->employeenationality->nationality,
                $each_employee->designationdetail->designation_name,
                date("d/m/Y", strtotime($each_employee->date_join)),
                "Not Allowed",
            );
        }





        // Return the data to DataTable
        $data = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($rowData),
            "recordsFiltered" => count($rowData),
            "data" => $rowData
        );

        // Return the JSON response
        echo json_encode($data);
    }

    public function actionFamilyTicketChecker() {
        // Get the form date and to date
        $frmdate = $_POST['frmdate'];
        $todate = $_POST['todate'];

        $payroll_startdate = Yii::app()->request->getParam('frmdate');
        $payroll_startdate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_startdate)));
        $payroll_enddate = Yii::app()->request->getParam('todate');
        $payroll_enddate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_enddate)));

// Format the frmdate and todate to MySQL compatible date
        $from_date = date("Y-m-d", strtotime(str_replace('/', '-', $frmdate)));
        $todate = date("Y-m-d", strtotime(str_replace('/', '-', $todate)));

// Extract the month from the frmdate (start date)
        $from_month = date("m", strtotime($from_date));
        $start_of_current_year = date("Y-01-01");

// Initialize rowData and counter
        $rowData = array();
        $m = 0;

// Build the condition for employee filtering
        $condition = "isActive='Y'";  // Simplified from "1=1"
//$condition .= ' AND (travel_allowance IS NULL OR travel_allowance = "") ';
//$condition .= ' AND MONTH(date_join) = ' . $from_month; 
        $condition .= ' AND date_join <= "' . $start_of_current_year . '"';
        $condition .= ' AND family_ticket = "N"'; // Added condition for family_ticket
// Debugging: Output the condition to verify correctness
// Yii::log("Condition for employee query: " . $condition, CLogger::LEVEL_INFO);
// Fetch employees based on condition
        $model_employee = Employee::model()->findAll(array(
            'condition' => $condition,
            'order' => 'de_first_name ASC'
        ));

// Debugging: Log the number of employees fetched
// Yii::log("Number of employees fetched: " . count($model_employee), CLogger::LEVEL_INFO);

        if (empty($model_employee)) {
            // If no employees are found, output debug information
            echo json_encode([
                "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            ]);
            return;
        }

// Payroll period for calculation
// Loop through each employee
        foreach ($model_employee as $v => $each_employee) {
            // Check if the employee has dependants with ticket_available = 'Y'
            $model_dependant = EmployeeDependants::model()->findAll(array(
                'condition' => 'ticket_available="Y" AND employee_id="' . $each_employee->id . '"'
            ));

            // If dependants with a ticket available exist, process the employee data
            if (!empty($model_dependant)) {
                // Add the employee data to rowData if there is any dependant ticket available
                $rowData[] = array(
                    ++$m,
                    $each_employee->branch_sponsor->branch_or_sponsor_name,
                    $this->ciphertext($each_employee->employee_code, "d"),
                    $this->ciphertext($each_employee->first_name, "d") . ' ' . $this->ciphertext($each_employee->last_name, "d"),
                    $each_employee->employeenationality->nationality,
                    $each_employee->designationdetail->designation_name,
                    date("d/m/Y", strtotime($each_employee->date_join)),
                );
            }
        }

// Return the data to DataTable
        $data = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($rowData),
            "recordsFiltered" => count($rowData),
            "data" => $rowData
        );

// Return the JSON response
        echo json_encode($data);
    }

    public function actionPensionChecker() {
        /// Initialize rowData and counter
        $rowData = array();
        $m = 0;
        $condition = "isActive='Y'";  // Simplified from "1=1"
        $condition .= ' AND nationality="143"';
        $model_employee = Employee::model()->findAll(array(
            'condition' => $condition,
            'order' => 'de_first_name ASC'
        ));

        // Debugging: Log the number of employees fetched
        // Yii::log("Number of employees fetched: " . count($model_employee), CLogger::LEVEL_INFO);

        if (empty($model_employee)) {
            // If no employees are found, output debug information
            echo json_encode([
                "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            ]);
            return;
        }

        // Loop through each employee
        foreach ($model_employee as $v => $each_employee) {
            // Assuming nationality is linked to MasPension, get the employee_percent
            // You might need to adjust this depending on your database structure
            $model_pension = MasPension::model()->find(
                    'nationality = :nationality', array(':nationality' => $each_employee->nationality)
            );

            // Set default value for employee_percent if no matching record is found
            if ($each_employee->have_pension == '1') {
                $employee_percent= ($each_employee->pensiondetails->scheme_name. ' (' . $each_employee->pensiondetails->employee_percent . ' %)');
            } else {
                $employee_percent = '-';
            }
            $have_pension_text = ($each_employee->have_pension == '1') ? 'Yes' : 'No';

            // Add the employee data to rowData if there is any dependant ticket available
            $rowData[] = array(
                ++$m,
                $each_employee->branch_sponsor->branch_or_sponsor_name,
                $this->ciphertext($each_employee->employee_code, "d"),
                $this->ciphertext($each_employee->first_name, "d") . ' ' . $this->ciphertext($each_employee->last_name, "d"),
                $each_employee->employeenationality->nationality,
                date("d/m/Y", strtotime($each_employee->date_join)),
                $have_pension_text,
                $employee_percent, // Use the employee_percent from MasPension model
            );
        }

        // Return the data to DataTable
        $data = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($rowData),
            "recordsFiltered" => count($rowData),
            "data" => $rowData
        );

        // Return the JSON response
        echo json_encode($data);
    }

    public function actionDependantTicketChecker() {
        // Initialize rowData and counter
        $rowData = array();
        $m = 0;
        $frmdate = Yii::app()->request->getParam('frmdate');
        $startdate = date("Y-m-d", strtotime(str_replace('/', '-', $frmdate)));
        $enddate = Yii::app()->request->getParam('todate');
        $enddate = date("Y-m-d", strtotime(str_replace('/', '-', $enddate)));
        $currentDate = new DateTime($startdate);  // Use $startdate for the current month
        $lastDayPreviousMonth = clone $currentDate->modify('first day of this month')->modify('-1 day');
        // Get the last day of the previous month in 'Y-m-d' format
        $lastDatePreviousMonth = $lastDayPreviousMonth->format('Y-m-d');
        $model_dependants = EmployeeDependants::model()->with('employeedetail')->findAll(array(
            'condition' => 't.ticket_available = "Y" 
                    AND t.relationship = 5 
                    AND TIMESTAMPDIFF(YEAR, t.date_of_birth, "' . $lastDatePreviousMonth . '") > 18',
            'order' => 'employeedetail.employee_code ASC'
        ));
        // If no dependants with a ticket available exist, return empty response
        if (empty($model_dependants)) {
            echo json_encode([
                "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            ]);
            return;
        }

        foreach ($model_dependants as $dependant) {
            $employeeCode = $this->ciphertext($dependant->employeedetail->employee_code, "d");
            $fullName = $this->ciphertext($dependant->employeedetail->first_name, "d") . ' ' . $this->ciphertext($dependant->employeedetail->last_name, "d");
            $branchSponsorName = $dependant->employeedetail->branch_sponsor->branch_or_sponsor_name;

            $rowData[] = array(
                ++$m,
                $branchSponsorName,
                $employeeCode,
                $fullName,
                $dependant->dependant_name,
                date("d/m/Y", strtotime($dependant->date_of_birth)),
            );
        }

        // Return the data to DataTable
        $data = array(
            "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
            "recordsTotal" => count($rowData),
            "recordsFiltered" => count($rowData),
            "data" => $rowData
        );

        // Return the JSON response
        echo json_encode($data);
    }

    public function actionNetSalaryChecker() {
        $offset = $_POST['start'];
        $length = $_POST['length'];
        $draw    = $_POST['draw'];
        $frmdate = Yii::app()->request->getParam('frmdate');
        $startdate = date("Y-m-d", strtotime(str_replace('/', '-', $frmdate)));
        $todate = Yii::app()->request->getParam('todate');
        $enddate = date("Y-m-d", strtotime(str_replace('/', '-', $todate)));
        //1-Less Than %,2-Greater Than %,3-No effect
        $count_sql_query='SELECT COUNT(*) as total_filtered from view_net_salary where payroll_startdate="'.$startdate.'" AND payroll_enddate="'.$enddate.'" AND (salary_comparison=1 OR salary_comparison=2)';
        $total_filtered = Yii::app()->db->createCommand($count_sql_query)->queryScalar();
        $sql_query = 'SELECT * FROM view_net_salary WHERE payroll_startdate = "' . $startdate . '" AND payroll_enddate = "' . $enddate . '" AND (salary_comparison = 1 OR salary_comparison = 2) ORDER BY branch_or_sponsor_name, de_first_name ASC LIMIT ' . $length . ' OFFSET ' . $offset;
        $model_salary_details = Yii::app()->db->createCommand($sql_query)->queryAll();
        $rowData = [];
        $m=$offset;
        if (empty($model_salary_details)) {
            echo json_encode([
                "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            ]);
            return;
        }
        foreach ($model_salary_details as $salary_details) {
            $employee_code= $this->ciphertext($salary_details['employee_code'], "d");
            $employee_name=ucwords(strtolower($this->ciphertext($salary_details['first_name'], "d") . ' ' . $this->ciphertext($salary_details['middle_name'], "d") . ' ' . $this->ciphertext($salary_details['last_name'], "d")));
            $rowData[] = array(
                ++$m,$salary_details['branch_or_sponsor_name'],$employee_code, $employee_name,
                Yii::app()->numberFormatter->formatCurrency($salary_details['employee_monthly_salary_amount'], ""), 
                Yii::app()->numberFormatter->formatCurrency($salary_details['total_salary_amount'], ""),
                Yii::app()->numberFormatter->formatCurrency(($salary_details['total_salary_amount']-$salary_details['employee_monthly_salary_amount']), ""),
                $salary_details['salary_comparison']
            );
        }
        // Return the response as JSON
        echo json_encode([
            "draw" =>$draw,
            "recordsTotal" => $total_filtered,
            "recordsFiltered" => $total_filtered,
            "data" => $rowData
        ]);    
    }


    public function actionFlexiTimeChecker()
    {
        $model = new HrEmployeeAttendanceExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $employee_id=$_POST['employee_id'];
        $branch_id=$_POST['branch_id'];
        //$status=$_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2=>  'employeedetail.first_name',
            3 => 'apply_date',
            4=>'status',
            5=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $start_date = $_POST['frmdate'];
        $end_date = $_POST['todate'];
        $start_date = date("Y-m-d", strtotime(str_replace('/', '-',  $start_date)));
        $end_date = date("Y-m-d", strtotime(str_replace('/', '-',  $end_date)));
        $condition="1=1";
        $condition.= " AND apply_date  >= '" . $start_date . "' AND  apply_date  <= '" .$end_date . "'";

        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        foreach ($model as $row) {
           
            $rowData[] = array(++$m,$row->employeedetail->branch_sponsor->branch_or_sponsor_name,$this->ciphertext($row['employeedetail']['employee_code'], "d"),$row['employeedetail']['employeefullname'], date('d/m/Y', strtotime($row['apply_date'])),HrEmployeeAttendanceExcuse::getStatus($row->status));
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }


    public function actionGetimolDetails()
    {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $department = $_POST['dept'];
        $designation = $_POST['desg'];
        $branch_id = $_POST['branch_id'];
        $status = $_POST['status'];
        $team = $_POST['team'];
        $report_id = $_POST['report_id'];
        $employee_status = $_POST['employee_status'];
        $columns = array(
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'employee_code',
        );
        
        $condition = 't.isActive="Y"';
        
        $molCondition = '';
        
        $molCondition .= ' OR LENGTH(personal_file_no) > 14';
        
        $molCondition .= ' OR LENGTH(personal_file_no) < 14';
        
        $molCondition .= ' OR personal_file_no LIKE "%  %"'; 
    
        $molCondition .= ' OR personal_file_no IN (SELECT personal_file_no FROM erp_hr_employee WHERE personal_file_no != "" GROUP BY personal_file_no HAVING COUNT(personal_file_no) > 1)';

        if (!empty($molCondition)) {
            $condition .= ' AND (' . substr($molCondition, 3) . ')'; 
        }
        
    
        
        // Count the total number of employees that match the condition
        $count = $model->count(array('condition' => $condition));
        
        // Fetch the employee data based on the condition
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id asc'));
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        
        $rowData = array();
        $m = $offset;
        
       // Loop through the fetched records and prepare the response data
       $ibanDuplicates = array();
       foreach ($model as $row) {
           // If an already exists, mark it as a duplicate
           if (isset($ibanDuplicates[$row['personal_file_no']])) {
               $ibanDuplicates[$row['personal_file_no']][] = $row;
           } else {
               $ibanDuplicates[$row['personal_file_no']] = [$row];
           }
       }
       
       // Loop through the fetched records and prepare the response data
       foreach ($model as $row) {
           $ibanLength = strlen($row['personal_file_no']);
           
           // Check if the current row is a duplicate
           $isDuplicate = count($ibanDuplicates[$row['personal_file_no']]) > 1 ? true : false;
       
           // Add the row data, including a flag for duplicate rows
           $rowData[] = array(
               ++$m,
               $row['branch_sponsor']['branch_or_sponsor_name'],
               $this->ciphertext($row['employee_code'], "d"),
               $this->ciphertext($row['first_name'], "d") . ' ' . $this->ciphertext($row['last_name'], "d"),
               $row['personal_file_no'],
               $isDuplicate // Flag indicating if this row is a duplicate
           );
       }
        
        $data['data'] = $rowData;
        echo json_encode($data);  
    }


    public function actionZeroSalaryChecker()
    {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];  

        $columns = array(
            0 => 'id',
            1 => 'employee_code',
            2 => 'first_name'
        );
        
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        
        $condition = "1=1";

        $condition.=(' AND NOT EXISTS (SELECT 1 FROM erp_hr_employee_salary ea WHERE ea.employee_id = t.id )');
        //$condition .= " AND (employeesalarydetail.employee_id )";
        
        // $count = $model->with('employeesalarydetail')->count(array(
        //     'condition' => $condition
        // ));
        // $model = $model->with('employeesalarydetail')->findAll(array(
        //     'condition' => $condition,
        //     'limit' => $limit,
        //     'offset' => $offset,
        //     'order' => "t.id desc" 
        // ));


        $count = $model->count(array(
            'condition' => $condition
        ));
        $model = $model->findAll(array(
            'condition' => $condition,
            'limit' => $limit,
            'offset' => $offset,
            'order' => "t.id desc" 
        ));
        
        $recordsTotal = $count;
        $recordsFiltered = $count; 
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
        
            $rowData[] = array(
                ++$m, 
                $row->branch_sponsor->branch_or_sponsor_name,
                $this->ciphertext($row->employee_code,"d"),
                $row->employeefullname
            );
        }
        
        $data['data'] = $rowData;
        echo json_encode($data);
        
        
    }

public function actionSalaryComponentChecker()
{
$model = new HrMonthlySalaryComponent();
$draw = $_POST['draw'];
$offset = $_POST['start'];
$limit = $_POST['length'];


$columns = array(
    0 => 'id',
);

$filterColumn = $columns[$_POST['order'][0]['column']];
$filterOrder = $_POST['order'][0]['dir'];

$condition = "1=1";

$start_date = $_POST['frmdate'];
$start_date = date("Y-m-d", strtotime(str_replace('/', '-',  $start_date)));
$dateObj = new DateTime($start_date);

$year = $dateObj->format('Y');
$month = $dateObj->format('m');

//$condition = "1=1";

if ($year && $month) {
    $condition .= " AND salary_month = " . $month . " AND salary_year = " . $year;
}

$count = $model->count(array(
    'condition' => $condition,
));

$modelSalaryDetails = $model->findAll(array(
    'condition' => $condition,
    'limit' => $limit,
    'offset' => $offset,
    'order' => "t.id desc"
));

$recordsTotal = $count;
$recordsFiltered = $count;
$data['draw'] = $draw;
$data['recordsTotal'] = $recordsTotal;
$data['recordsFiltered'] = $recordsFiltered;

$rowData = array();
$m = $offset;
$totalAmount = 0; 

foreach ($modelSalaryDetails as $row) {
    // if ($row->salarytype->consider_deduction == 'Y') {
    //     $type = 'Deduction';
    // } else {
    //     $type = 'Addition';
    // }
    $type   = array(1=>"Addition",2=>"Deduction");
    $amount = $row->amount;
    $totalAmount += $amount; 

    $rowData[] = array(
        ++$m,
        $row->employeedetail->branch_sponsor->branch_or_sponsor_name,
        $row->employeedetail->employeecode,
        $row->employeedetail->employeefullname,
        $row->salarytype->salary_name,
        $type[$row->salarytype->salary_type],
        Yii::app()->numberFormatter->formatCurrency($amount, ""),
        $row->remarks
    );
}

$data['data'] = $rowData;
echo json_encode($data);
} 
     public function actionAttendanceAbsentChecker() { 
        $model = new EmployeeAttendance();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        //$status=$_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'attendance_date',
            4 => '',
        );
        $start_date = $_POST['frmdate'];
        $end_date = $_POST['todate'];
        $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $start_date)));
        $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $end_date)));
        $condition = 'status = "2" AND employeedetail.isActive="Y"';
        if (!empty($branch_id)) {
            $condition .= " AND employeedetail.branch_or_sponsor_id = '" . $branch_id . "'";
            }
        if (!empty($start_date) && !empty($end_date)) {
            $condition .= " AND attendance_date  >= '" . $start_date . "' AND  attendance_date  <= '" . $end_date . "'";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $rowData[] = array(++$m, $row->employeedetail->branch_sponsor->branch_or_sponsor_name, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, date('d/m/Y', strtotime($row['attendance_date'])));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
        
    }
}
