<?php

class SalaryadvanceController extends Controller
{    
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','GetAdvanceDetails','employeecreate','GetEmployeeAdvanceDetails','Create','Approve','employeeIndex',
                                        'SaveAdvance','SaveEmployeeAdvance','GetSalary','View','SaveEmployeeAdvanceDetails','deletesalaryadvance',
                                        'SaveApproveSalaryAdvance','ApprovalDocument','UploadDocument','downloadapprovaldocument','AdvancePayment',
                                        'SaveAdvancePayment','AdvanceApproval','GetPendingAdvanceDetails','loadmasterbranch'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
   
    public function actionIndex() {
        $model_module_salary_advance =HrModules::model()->findByPK(5);
        if (((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_saladvance_menu']) || Yii::app()->user->authorised_user == 1))&& ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y')){
            $en_id = Yii::app()->request->getParam('id');
            $branch =$this->ciphertext($en_id,"d");
            if($branch!=''){
                $model = new EmployeeSalaryAdvance();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model,'branch'=>$branch));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionCreate()
    {
        $model=new EmployeeSalaryAdvance(); 
        $id=(int) Yii::app()->request->getParam('id');
        $branch=(int) Yii::app()->request->getParam('branch');
        $salary_amount=0.00; 
        if($id>0){
            $model=$model->findByPk($id);
            $current_date = date('Y-m-d');
            $condition = 'employee_id="'.$model->employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
            if($model_salary->amount>0){
                $salary_amount = $model_salary->amount;
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model,'id'=>$id,'branch'=>$branch,'salary'=>$salary_amount), false, true);                                  
    }
    public function actionGetSalary() {      
        $employee_id= $_POST['employee_id'];
        $current_date = date('Y-m-d');
        $salary_amount=0.00;
        $condition = 'employee_id="'.$employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
        $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
        if($model_salary->amount>0){
            $salary_amount = $model_salary->amount;
        }
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="3"'));
        $functiontype=$model_master_approve_setting->id;
        $model_details_pending = EmployeeSalaryAdvance::model()->find(array('condition'=>'employee_id="'.$employee_id.'" and (advance_payment_status = "1" or advance_payment_status = "2" or advance_payment_status = "4" or advance_payment_status = "6" or advance_payment_status = "8" or advance_payment_status = "10" or advance_payment_status = "12" or advance_payment_status = "14" or advance_payment_status = "15")'));
        $pending='N';
        if(!empty($model_details_pending) && $model_details_pending->id>0){
            $pending='Y';
        }
        $jsonData['salary_amount'] =$salary_amount;   
        $jsonData['functiontype'] = $functiontype;
        $jsonData['pending'] = $pending;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData); 
    }
    public function actionSaveEmployeeAdvance() {				 
        $model = new EmployeeSalaryAdvance();
	if (isset($_POST['EmployeeSalaryAdvance'])) {
            if ($_POST['EmployeeSalaryAdvance']['id'] > 0) {
                $id = (int) $_POST['EmployeeSalaryAdvance']['id'];
                $model = EmployeeSalaryAdvance::model()->findByPK($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date = date("Y-m-d");   
                $model->advance_payment_status=1;
            }			
            $model->attributes = $_POST['EmployeeSalaryAdvance'];	
            //Employee ID
            $employee_id=$_POST['EmployeeSalaryAdvance']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="3"'));
            if(!empty($model_master_approve_setting)){
                $model->function_type =$model_master_approve_setting->id;
                $model->max_level =$model_master_approve_setting->max_level;
            }
            $model->payment_note = $_POST['EmployeeSalaryAdvance']['payment_note'];
            if($model->save()){       
                $jsonData['status'] = 'success';                
                echo CJSON::encode($jsonData);
            }
            else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                echo $error;
            }
        }			
    }
    
    public function actionGetAdvanceDetails(){		
        $model=new EmployeeSalaryAdvance();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
       // $status  = $_POST['status'];
        $employee_id  = $_POST['employee_id'];
        $branch_id=$_POST['branch_id'];
        $columns = array(
            0 =>'t.id',
            1 =>'t.employee_id',
            2 =>'employee_id',
            3 =>'advance_payment_date',
            4 =>'advance_payment_date',
            5 =>'amount',
            6 =>'advance_payment_status',
            7 =>'id',
           

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_advance=EmployeeSalaryAdvance::getPendingapproval($branch_id,1);
        $condition = "employeedetail.branch_or_sponsor_id='".$branch_id."'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' AND employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_advance.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND advance_payment_status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (advance_payment_status IN(".$status.") OR t.id IN(".$pending_advance."))";
            }
        }
        if($employee_id>0){
             $condition.= ' and t.employee_id ="'.$employee_id.'"';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'apply_date desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        { 
            $button_string="";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($next_approval_level<=$row->max_level){
                if($next_approval_level==1 && $row->approvelevel->level_1_type=='H' && $row->approvelevel->level_1_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && $row->approvelevel->level_2_type=='H' && $row->approvelevel->level_2_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && $row->approvelevel->level_3_type=='H' && $row->approvelevel->level_3_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && $row->approvelevel->level_4_type=='H' && $row->approvelevel->level_4_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && $row->approvelevel->level_5_type=='H' && $row->approvelevel->level_5_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if($next_approval_level==$row->max_level){
                $final_level='Y';
            }
            $approve_reject=$advance_edit=$advance_view=$direct_approval=$advance_payment=$direct_approval=0;
            if($show_approve_button==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Approve/Reject Salary Advance" onclick="loadPopupModal(\'hr/salaryadvance/approve&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Salary Advance\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                    $approve_reject =1;
                }
            }
            $status= $row['advance_payment_status'];
            if($status==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-success btn-xs" title="Edit Salary Advance Details" onclick="loadPopupModal(\'hr/salaryadvance/create&id='.$row['id'].'\',\'EDIT EMPLOYEE SALARY ADVANCE \',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';           
                $advance_edit =1;
                
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_delete'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<a href ="javascript:void(0);" title="Delete Salary Advance Details" class="btn btn-danger btn-xs" onclick="deletesalaryadvance('.$row['id'].')"><i class="fa fa-trash-o "></i></a>&nbsp;';          
                $advance_delete =1;
                
                }
//                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_download'])  || Yii::app()->user->authorised_user == 1) {
//                    $button_string.= '<a href="?r=salaryadvance/approvaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
//                }
            }else{
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_view'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-default btn-xs" title="View Salary Advance Details" onclick="loadPopupModal(\'hr/salaryadvance/view&id='.$row['id'].'\',\'SALARY ADVANCE DETAILS\',\'lg\')"><i class="fa fa-eye"></i></button> &nbsp;';							          
                    $advance_view=1;
                    
                }
//                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_download'])  || Yii::app()->user->authorised_user == 1) {
//                    if($row['approval_document']!=""){
//                    $button_string.= '<a href="?r=salaryadvance/downloadapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
//                    }
//                }
            }	
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salary_advance_payment'])  || Yii::app()->user->authorised_user == 1) {
                if($status==14 || $status==15):					
                    $button_string.= '<button class="btn btn-info btn-xs" title="Salary Advance Payment" onclick="loadPopupModal(\'hr/salaryadvance/advancepayment&id='.$row['id'].'\',\'Advance Payment\',\'md\')"><i class="fa fa-money"></i></button> &nbsp;';            
                    $advance_payment=1;
                endif;
            }
            if ($status==1 || $status==2 || $status==4 || $status==6 || $status==8 || $status==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_admin_salary_advance_details_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $last_level=$row->max_level;
                    $direct_approval=1;
                    $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/salaryadvance/approve&final_level=Y&level='.$last_level.'&id=' . $row['id'] . '\',\'Approve/Reject Salary Advance\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                    }
                }
            $apply_date='';
            if($row['apply_date']!='0000-00-00' && $row['apply_date'] !=''){
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            $approved_date='';
            if($row['approved_date'] != '0000-00-00'){
                $approved_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $advance_payment_date = '';				
            if($row['advance_payment_date'] != '0000-00-00'){
                $advance_payment_date = date("d/m/Y", strtotime($row['advance_payment_date']));	
            }
            $rowData[]=array($m,$row['employeedetail']['employeecode'],$row['employeedetail']['employeefullname'],$apply_date,$advance_payment_date,$row['amount'],EmployeeSalaryAdvance::getStatus($row['advance_payment_status']),array('id'=>$row['id'],'final_level'=>$final_level,'last_level'=>$last_level,'level_no'=>$level_no,'approve_reject'=>$approve_reject,'advance_edit'=>$advance_edit,'advance_view'=>$advance_view,'direct_approval'=>$direct_approval,'advance_payment'=>$advance_payment,'$direct_approval'=>$direct_approval));             
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionView()
    {
        $model=new EmployeeSalaryAdvance(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }               
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('salary_advance_view', array('model' => $model,'id'=>$id), false, true);                                  
    }
    public function actionEmployeeIndex() {
        $this->layout = 'main';
        $model_module_salary_advance = HrModules::model()->findByPK(5);
        if ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_employee');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionemployeecreate()
    {
        $model=new EmployeeSalaryAdvance(); 
        $id=(int) Yii::app()->request->getParam('id');
        $user_id = Yii::app()->user->id; 				
        $modelemployee = User::model()->findByPK($user_id);
        $current_date = date('Y-m-d');
        $condition = 'employee_id="'.$modelemployee->employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
        $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
        $salary_amount = $model_salary->amount;
        $employee_id=$modelemployee->employee_id;
        if($id>0){
            $model=$model->findByPk($id);
        }            
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$modelemployee->employee_id.'" and functionality_id="3"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('employeecreate', array('model' => $model,'salary_amount'=>$salary_amount,'employee_id'=>$employee_id,'model_master_approve_setting'=>$model_master_approve_setting), false, true);                                  
    }
	
    public function actionSaveEmployeeAdvanceDetails() {				 
        $model = new EmployeeSalaryAdvance();
	if (isset($_POST['EmployeeSalaryAdvance'])) {
            if ($_POST['EmployeeSalaryAdvance']['id'] > 0) {
                $id = (int) $_POST['EmployeeSalaryAdvance']['id'];
                $model = EmployeeSalaryAdvance::model()->findByPK($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date = date("Y-m-d");   
            }			
            $model->attributes = $_POST['EmployeeSalaryAdvance'];
            //Employee ID
            $employee_id=$_POST['EmployeeSalaryAdvance']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="3"'));
            if(!empty($model_master_approve_setting)){
                $model->function_type =$model_master_approve_setting->id;
                $model->max_level =$model_master_approve_setting->max_level;
            }
            $model->payment_note = $_POST['EmployeeSalaryAdvance']['payment_note'];
            $model->advance_payment_status=1;
            if($model->save()){     
                 //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="16"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(16,$model->employee_id,$model->id);
                    }
                }
                $jsonData['status'] = 'success';                
                echo CJSON::encode($jsonData);
            }
            else{
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                    echo $error;
            }
        }			
    }
    public function actionGetEmployeeAdvanceDetails(){		
        $model=new EmployeeSalaryAdvance();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'id',
            1 =>'employee_id',
            2 =>'apply_date',
            3 =>'advance_payment_date',
            4 =>'amount',
            5 =>'advance_payment_status',
            6 =>'posted',
            7 =>'approved_date',
            8 =>'credit_account',
            9 =>'credit_account',
            10=>'credit_account',
           

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $user_id = Yii::app()->user->id; 				
        $modelemployee = User::model()->findByPK($user_id);				
        $employee_id = $modelemployee->employee_id;
        //Notification update
        EmployeeSalaryAdvance::model()->updateAll(array('view_status' =>1,'updated_by'=> Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="'.$employee_id.'" and view_status="0" and (advance_payment_status="12" OR advance_payment_status="13")');
        $condition="t.isActive='Y' and employee_id ='".$employee_id."'";      
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $apply_date='';
            if($row['apply_date']!='0000-00-00' && $row['apply_date'] !=''){
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            $approved_date='';
            if($row['approved_date'] != '0000-00-00'){
                $approved_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $advance_payment_date = '';				
            if($row['advance_payment_date'] != '0000-00-00'){
                $advance_payment_date = date("d/m/Y", strtotime($row['advance_payment_date']));	
            }       
            $button_string="";
            $status= $row['advance_payment_status'];
            $edit_button=$delete_button=$view_button=$download_button=0;
            if($status==1){
                $edit_button =1;
                $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/salaryadvance/employeecreate&id='.$row['id'].'\',\'EDIT EMPLOYEE SALARY ADVANCE \',\'md\')"><i class="fa fa-edit"></i></button>&nbsp;';           
                $button_string.= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletesalaryadvance('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                $delete_button =1;
                
            }else{
                $view_button =1;
                $button_string.= '<button class="btn btn-primary btn-xs" title="SALARY ADVANCE DETAILS" onclick="loadPopupModal(\'hr/salaryadvance/view&id='.$row['id'].'\',\'SALARY ADVANCE DETAILS\',\'lg\')"><i class="fa fa-eye"></i></button> &nbsp;';							   
                if($row['approval_document']!=""){
                    $download_button=1;
                    $button_string.= '<a href="?r=hr/salaryadvance/downloadapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                }
            }	
            $rowData[]=array($m,$apply_date,$approved_date,Yii::app()->numberFormatter->formatCurrency($row['amount'],""),Yii::app()->numberFormatter->formatCurrency($row['amount_paid'],""),Yii::app()->numberFormatter->formatCurrency(($row['amount']-$row['amount_paid']),""),EmployeeSalaryAdvance::getStatus($status),$row['payment_note'],array("id"=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button,'view_button'=>$view_button,'download_button'=>$download_button));             
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
	
    public function actiondeletesalaryadvance(){       
        $id = $_POST['id'];
         if($id>0){            
             $model = new EmployeeSalaryAdvance();                
             $model->deleteByPk($id);
             echo "success";
         }
         else{
             echo "fail";
         }      
    }
    public function actionApprove() {								
        $model=new EmployeeSalaryAdvance(); 
        $id=(int) Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if($id>0){
            $model=$model->findByPk($id);
            $current_date = date('Y-m-d');
            $condition = 'employee_id="'.$model->employee_id.'" and isActive="Y" and valid_from <="'.$current_date . '" AND valid_to ="0000-00-00"';
            $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
            $salary_amount = $model_salary->amount;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve', array('model' => $model,'id'=>$id,'salary_amount'=>$salary_amount,'level'=>$level,'final_level'=>$final_level), false, true);
    }
    public function actionSaveApproveSalaryAdvance() {				 
        $model = new EmployeeSalaryAdvance();
	if (isset($_POST['EmployeeSalaryAdvance'])) {
            if ($_POST['EmployeeSalaryAdvance']['id'] > 0) {
                $id = (int) $_POST['EmployeeSalaryAdvance']['id'];
                $model = EmployeeSalaryAdvance::model()->findByPK($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }   
                			
            $model->attributes = $_POST['EmployeeSalaryAdvance'];
            $model->advance_payment_status=$_POST['EmployeeSalaryAdvance']['advance_payment_status'];
            $model->last_approved_level = $_POST['EmployeeSalaryAdvance']['last_approved_level'];
            //$model->approved_date=date("Y-m-d");
           // $model->payment_note = $_POST['EmployeeSalaryAdvance']['payment_note'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            $level= $_POST['approval_level'];
            $final_level= $_POST['final_level']; 
            if($level==1 && $final_level=='N'){
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            }else if($level==2 && $final_level=='N'){
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            }else if($level==3 && $final_level=='N'){
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            }else if($level==4 && $final_level=='N'){
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            }else if($level==5 && $final_level=='N'){
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if($final_level=='Y'){
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if($model->save()){    
                 //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="17"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(17,$model->employee_id,$model->id);
                    }
                }
                $jsonData['status'] = 'success';                
                echo CJSON::encode($jsonData);
            }
            else{
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                    echo $error;
            }
        }			
    }
    public function actionApprovalDocument() {
        $id= Yii::app()->request->getParam('id');
        $model_salary_advance= EmployeeSalaryAdvance::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.hrdocuments.salaryadvance_approval_document', array('id'=>$id,'model_salary_advance'=>$model_salary_advance), true));
        $mPDF1->Output('Cash Advance Request.pdf', 'D');
    }
    public function actiondownloadapprovaldocument() {
        $id = Yii::app()->request->getParam('id');
        $document = EmployeeSalaryAdvance::model()->findByPk($id);
        $file =$document->approval_document;  
        $path = Yii::getPathOfAlias('webroot') . "/uploads/salaryadvancedocument/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }
    public function actionAdvancePayment() {
        $model=new EmployeeSalaryAdvance(); 
        $model_advance_payment=new EmployeeSalaryAdvancePayment(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('advance_payment', array('model' => $model,'model_advance_payment' => $model_advance_payment,'id'=>$id), false, true);                                  
    }
    public function actionSaveAdvancePayment() {	 
        $modelloan = new EmployeeSalaryAdvance();       
        if (isset($_POST['EmployeeSalaryAdvance'])) {
            if ($_POST['EmployeeSalaryAdvance']['id'] > 0) {      
                $model_salary_advance = EmployeeSalaryAdvance::model()->findByPK($_POST['EmployeeSalaryAdvance']['id']);	
                $model_salary_advance->created_by= Yii::app()->user->id;
                $model_salary_advance->created_date_time = date('Y-m-d H:i:s');
            }                  
            $advance_amount=$model_salary_advance->amount;
            $advance_repaid=$model_salary_advance->amount_paid;
            $advance_repayment=$_POST['EmployeeSalaryAdvancePayment']['advance_amount'];
            $total_payment=$advance_repaid+$advance_repayment;
            if($total_payment==$advance_amount){
                $model_salary_advance->advance_payment_status=16;
            }else{
                $model_salary_advance->advance_payment_status=15;
            }
            $model_salary_advance->amount_paid=$total_payment;
            if ($model_salary_advance->validate()) {
                $model_salary_advance->save();
                $model_salary_advance_payment = new EmployeeSalaryAdvancePayment();
                $model_salary_advance_payment->employee_id = $model_salary_advance->employee_id;
                $model_salary_advance_payment->advance_id = $model_salary_advance->id;
                $model_salary_advance_payment->advance_amount = $_POST['EmployeeSalaryAdvancePayment']['advance_amount'];
                $model_salary_advance_payment->payment_date = date('Y-m-d');

                //ALTER TABLE `erp_hr_employee_salary_advance_payment` ADD `posted` ENUM('N','Y') NOT NULL DEFAULT 'N' AFTER `salary_lock_id`, ADD `voucher_id` INT NOT NULL AFTER `posted`;
                //$model_salary_advance_payment->postVoucher();
                $model_salary_advance_payment->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                
            }else{
                $error = CActiveForm::validate($modelloan, '', false);
                if ($error != '[]')
                echo $error;
            }

        }			
    }
    public function actionAdvanceApproval() {
        $this->layout = 'main';
        $model_module_salary_advance = HrModules::model()->findByPK(5);
        if ($model_module_salary_advance->grant_access == 1 && $model_module_salary_advance->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetPendingAdvanceDetails(){
        $model=new EmployeeSalaryAdvance();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'t.id',
            1 =>'employeedetail.first_name',
            2 =>'apply_date',
            3 =>'amount',
            4 =>'advance_payment_status',
            5 =>'',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $user_id = Yii::app()->user->id; 
	$modelemployee = User::model()->findByPK($user_id);
	$employee_id = $modelemployee->employee_id;
        $pending_salaryadvance=EmployeeSalaryAdvance::getintermediateapproval($employee_id,1);
        $condition = 'employeedetail.isActive="Y" AND t.last_approved_level<t.max_level AND t.id IN('.$pending_salaryadvance.')';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";       
        }
        $count = $model->with('employeedetail','approvelevel')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail','approvelevel')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string = "";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($next_approval_level<=$row->max_level){
                if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if($next_approval_level==$row->max_level){
                $final_level='Y';
            }
            $approve_reject=0;
            if($show_approve_button==1){ //For Approval
                $approve_reject=1;
                $button_string.= '<button class="btn btn-warning btn-xs" title="Approve/Reject Salary Advance" onclick="loadPopupModal(\'hr/salaryadvance/approve&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Salary Advance \',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';           
            }
            $applydate = date("d/m/Y", strtotime($row['apply_date']));
            $rowData[]=array($m,$row['employeedetail']['employeefullname'],$applydate,$row['amount'],EmployeeSalaryAdvance::getStatus($row['advance_payment_status']), array("id"=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_reject'=>$approve_reject));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    } 
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
}