<?php
Yii::import('application.modules.finance.models.*');
class SalaryController extends Controller {
    public function accessRules() {
        return array(array('allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('login', 'error', 'logout'), 'users' => array('*'),), array('allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array('Index', 'CalculateSalary', 'EmployeeIndex', 'PrintSalarySlipReportPDF', 'getSalarySlip', 'EditSalary', 'EditEmployeeSalary', 'RollbackSalary', 'LockSalary', 'UnLockSalary', 'UpdateSalary', 'ViewSalary', 'getpayrolldatebybranch', 'PrintSalarySlip', 'SalarySlip','LoadCheckerTabContent', 'PrintSalarySlipindividual', 'History','Checker', 'Getsalaryhistory', 'ViewSalaryDetails', 'getEmployeeName', 'NewSalarySlip', 'PreviewSalarySlip', 'getEmployeeDetail', 'SalaryslipPreview', 'MonthlyDeduction', 'loadunlocksalarylist', 'SaveDeductionAmount', 'salaryeditindex', 'GetMonthlyList', 'editemployeesalarydetail', 'SalaryDetails', 'GetComponentList', 'UploadSalaryComponent', 'DownloadFormat', 'UploadEmployeecsv', 'SaveSalaryComponents', 'DownloadErrorCsv', 'deletesalarycomponentdetails', 'ViewSalaryComponentdetails', 'downloadsalarycomponentlist', 'viewsalaryslip','Disable','RollbackEmployeeSalary','pendingSalary','calculatependingsalary'), 'expression' => '$user->isMember()',), array('deny', // deny all users
        'users' => array('*'),),);
    }
    public function actiongetSalarySlip() {
        $month_id = $_POST['month_id'];
        $year_id = $_POST['year_id'];
        $emp_id = $_POST['emp_id'];
        $this->renderPartial('salaryslip_list', array('month_id' => $month_id, 'employee_id' => $emp_id, 'year_id' => $year_id));
    }
    public function actionSalarySlip() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('salary_slip_form');
    }
    public function actionPrintSalarySlipReportPDF() {
        $month_id = Yii::app()->request->getParam('month_id');
        $year_id = Yii::app()->request->getParam('year_id');
        $emp_id = Yii::app()->request->getParam('emp_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.SalarySlip_list', array('month_id' => $month_id, 'year_id' => $year_id, 'emp_id' => $emp_id), true));
        $mPDF1->Output('Salaryslip.pdf', 'I');
    }
    public function actionIndex() {
        $model = new SalaryProcessing();
        //Salary already locked
        $model_unlock = SalaryProcessing::model()->find(array('condition' => 'payroll_status="1"'));
        $start_date = '';
        $end_date = '';
        $month = '';
        $salary_unlock_exist = 0; //Unlock=1,lock=0;
        $unlock_id = 0;
        $salary_lock_exist = 0; //Unlock=1,lock=0;
        $lock_id = 0;
        $id = 0;
        $sif_created = 0;
        $payroll_branch_or_sponsor_id = 0;
        $salary_posted = '';
        $last_locked_month = "";
        $salary_unlock = "";
        if(empty($model_unlock)) {
            $model_max_date_1 = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate'));
            if(!empty($model_max_date_1) && $model_max_date_1->payroll_enddate != '' && $model_max_date_1->payroll_enddate != '0000-00-00'){
                $model_max_date = SalaryProcessing::model()->find(array('condition' => 'payroll_enddate="' . $model_max_date_1->payroll_enddate . '"'));
            }
            $start_date = date('01/m/Y');
            $end_date = date('t/m/Y');
            $month = date("F");
            if (!empty($model_max_date) && $model_max_date->payroll_enddate != '' && $model_max_date->payroll_enddate != '0000-00-00') {
                $start_date = date('Y-m-d', strtotime('+1 days', strtotime($model_max_date->payroll_enddate)));
                $payrollend_date_11 = $model_max_date->payroll_enddate;
                $model_start_day = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                if (!empty($model_start_day) && $model_start_day->payroll_start_day == 1) {
                    $end_date = date("Y-m-t", strtotime($start_date));
                } else {
                    $end_date = date('Y-m-d', strtotime('+30 days', strtotime($payrollend_date_11)));
                }
                $date = strtotime($end_date);
                $end_date = date('d/m/Y', strtotime($end_date));
                $start_date = date("d/m/Y", strtotime($start_date));
                $month = date("F", $date);
                $id = $model_max_date->id;
                $last_locked_month = date('F', strtotime($model_max_date->payroll_enddate));
                $salary_lock_exist = 1;
                $lock_id = $model_max_date->id;
                $salary_posted = $model_max_date->posted;
//                $model_salary_slip = MonthlySalarySif::model()->find(array('condition' => 'salary_processing_id="' . $model_max_date->id . '"'));
                $model_pay_rl = SalaryProcessing::model()->findbyPK($model_max_date->id);
                $model_salary_slip= MonthlySalarySifDetails::model()->find(array('condition' => 'start_date="'.$model_pay_rl->payroll_startdate.'" and end_date="'.$model_pay_rl->payroll_enddate.'"'));
                if (!empty($model_salary_slip)) {
                    $sif_created = 1;
                }
            } else {
                $salary_lock_exist = 0;
                $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                if(!empty($model_lock_month)){
                    $payroll_month = $model_lock_month->payroll_month;
                    $payroll_year = $model_lock_month->payroll_year;
                    $master_payroll_year = $model_lock_month->payroll_year;
                    if ($payroll_month == 12) {
                        $payroll_year+= 1;
                    }
                    $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                    $payroll_start_day = $model_lock_days->payroll_start_day;
                    $next_payroll_month = $payroll_month;
                    if ($payroll_start_day > 1) {
                        if ($payroll_month == 12) {
                            $payroll_month = 1;
                        }
                        $next_payroll_month = $payroll_month + 1;
                    }
                    if ($payroll_start_day == 1) {
                        if ($payroll_month == 12) {
                            $payroll_month = 1;
                        } else {
                            $payroll_month+= 1;
                        }
                        $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                        $start_date = date("d/m/Y", strtotime($start_date));
                        $end_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                        $date = strtotime($end_date);
                        $end_date = date("t/m/Y", strtotime($end_date));
                    } else {
                        if ($payroll_start_day > 1 && $master_payroll_year == date('Y') - 1) {
                            if ($payroll_month == 1) {
                                $payroll_month = 12;
                                $payroll_year_1 = date("Y") - 1;
                                $start_date = $payroll_year_1 . '-' . $payroll_month . '-' . $payroll_start_day;
                            } else {
                                $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                            }
                            if ($payroll_month == 12) {
                                $next_payroll_month = 1;
                            } else {
                                $next_payroll_month = $payroll_month + 1;
                            }
                        } else {
                            $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                        }
                        $start_date = date("d/m/Y", strtotime($start_date));
                        $payroll_end_day = $payroll_start_day - 1;
                        $end_date = $payroll_year . '-' . $next_payroll_month . '-' . $payroll_end_day;
                        $date = strtotime($end_date);
                        $end_date = date("d/m/Y", strtotime($end_date));
                    }
                    $month = date("F", $date);
                }
            }
            $salary_unlock = 1;
        } else {
            if(!empty($model_unlock)){
                $start_date = date("d/m/Y", strtotime($model_unlock->payroll_startdate));
                $end_date = date("d/m/Y", strtotime($model_unlock->payroll_enddate));
                $month = $model_unlock->payroll_month;
                $id = $model_unlock->id;
                $payroll_branch_or_sponsor_id = $model_unlock->payroll_branch_or_sponsor_id;
                $last_locked_month = date('F', strtotime($model_unlock->payroll_enddate));
                $unlock_id = $model_unlock->id;
                $salary_posted = $model_unlock->posted;
            }
            $salary_unlock_exist = 1;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index', array('salary_posted' => $salary_posted, 'sif_created' => $sif_created, 'lock_id' => $lock_id, 'unlock_id' => $unlock_id, 'salary_lock_exist' => $salary_lock_exist, 'salary_unlock_exist' => $salary_unlock_exist, 'model' => $model, 'payroll_branch_or_sponsor_id' => $payroll_branch_or_sponsor_id, 'start_date' => $start_date, 'end_date' => $end_date, 'month' => $month, 'salary_unlock' => $salary_unlock, 'id' => $id, 'last_locked_month' => $last_locked_month));
    }
    public function actionEmployeeIndex() {
        $this->layout = 'main';
        $model_module_payroll = HrModules::model()->findByPK(7);
        if ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $model_user = User::model()->findByPK(Yii::app()->user->id);
            if ($model_user->employee_details->branch_sponsor->salary_slip_view_ess == 'Y') {
                $this->render('index_employee');
            } else {
                throw new CHttpException(401, 'Unauthorized Access');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }
    public function actionCalculateSalary() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $branch = (int)Yii::app()->request->getParam('branch');
        $payroll_startdate = Yii::app()->request->getParam('payroll_startdate');
        $payroll_startdate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_startdate)));
        $payroll_enddate = Yii::app()->request->getParam('payroll_enddate');
        $payroll_enddate = date("Y-m-d", strtotime(str_replace('/', '-', $payroll_enddate)));
        $month_name = date('F', strtotime($payroll_enddate));
        $calculated_month = date('m', strtotime($payroll_enddate));
        $calculated_year = date('Y', strtotime($payroll_enddate));
        //Days
        $start_date = strtotime($payroll_startdate);
        $end_date = strtotime($payroll_enddate);
        $datediff = $end_date - $start_date;
        $diff_days = $datediff / (60 * 60 * 24);
        $model_hr_general_settings = HrGenerelSettings::model()->find();
        //Employee
        $condition = 'isActive="Y" and salary_commission="SP" AND date_join<="' . $payroll_enddate . '"';
        if ($branch > 0) {
            $condition.= ' AND branch_or_sponsor_id="' . $branch . '"';
        }
        //$condition.=' and id="45"';
        //        $SQL ="SELECT id FROM  `erp_hr_employee` emp WHERE $condition && id
        //            NOT IN (
        //                SELECT  employee_id
        //                FROM  erp_hr_employee_salary
        //                WHERE (('".$payroll_startdate."' BETWEEN valid_from AND valid_to) OR (valid_from <= '".$payroll_startdate."' AND valid_to='0000-00-00'))
        //            )";
        //        $model_employee_details= Yii::app()->db->createCommand($SQL)->queryAll();
        //        if(empty($model_employee_details)){
        $z = 0;
        $valid = true;
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        if (!empty($model_employee)) {
            $arr_employee = array();
            foreach ($model_employee as $key => $value) {
                $arr_employee[$this->ciphertext($value['first_name'], "d") . ' ' . $this->ciphertext($value['last_name'], "d") . ' ' . $value['employeecode']] = $value['id'];
            }
            ksort($arr_employee);
            //Total Days Working
            $date_con_1 = strtotime($payroll_startdate);
            $date_con_2 = strtotime($payroll_enddate);
            $total_working_day = $date_con_2 - $date_con_1;
            $total_working_days = floor($total_working_day / (60 * 60 * 24)) + 1;
            foreach ($arr_employee as $empid) {
                $each_employee = Employee::model()->findbyPK($empid);
                //Loan Amount
                $loan_amount = 0.00;
                $total_loan_amount = 0.00;
                $monthly_payment = 0.00;
                $total_loan_paid = 0.00;
                $loan_pending = 0.00;
                $model_loan = EmployeeLoanDetail::model()->findAll(array('condition' => '(loan_status="14" OR loan_status="15")  and isActive="Y" and repayment_start_date<="' . $payroll_enddate . '" AND employee_id=' . $each_employee->id));
                if (!empty($model_loan)) {
                    foreach ($model_loan as $key_1 => $loan_detail) {
                        $monthly_payment = $loan_detail->loan_monthly_payment; //Monthly Payment
                        $total_loan_amount = $loan_detail->loan_amount; //Total Loan Amount
                        $total_loan_paid = $loan_detail->loan_repayment; //Total loan paid
                        $loan_pending = $total_loan_amount - $total_loan_paid;
                        if ($loan_pending < $monthly_payment) {
                            $loan_amount+= $loan_pending;
                        } else {
                            $loan_amount+= $monthly_payment;
                        }
                    }
                }
                //End loan amount Calculation
                //Salary Advance Amount
                $salary_advance_deduction = 0.00;
                $model_salary_advance = EmployeeSalaryAdvance::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $each_employee->id . '" and approved_date<="' . $payroll_enddate . '" and (advance_payment_status="14" OR advance_payment_status="15")'));
                if ($model_salary_advance->amount != '') {
                    $salary_advance_deduction = $model_salary_advance->amount;
                }
                //End Salary Advance Amount
                //Start Employee Salary
                $joining_date = $each_employee->date_join;
                $employee_salary = 0.00;
                $arr_salary_detail = array();
                $late_joining_employee_salary = 0.00;
                $emp_sal_deduction = 0.00;
                $f_key = 0;
                $model_salary_details = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'salary.salary_occurence="2" AND employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                foreach ($model_salary_details as $key => $salarydetail) {
                    $sal_value = 0.00;
                    $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                    $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salary->salary_name;
                    $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salary->salary_type;
                    $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                    $employee_salary+= $salarydetail->amount;
                    if (strtotime($joining_date) > strtotime($payroll_startdate)) {
                        $salary_start_date = strtotime($payroll_enddate);
                        $joining_date_1 = strtotime($joining_date);
                        $datediff = $salary_start_date - $joining_date_1;
                        $diff_day = $datediff / (60 * 60 * 24) + 1;
                        //$salary_emp_per_day=round($salarydetail->amount/30, 2);
                        //$sal_value=round($salary_emp_per_day*$diff_day, 2);
                        $salary_emp_per_day = number_format($salarydetail->amount / $total_working_days, 2, '.', ''); //number_format($sal_value, $z)
                        $sal_value = round($salary_emp_per_day * $diff_day, 2);
                        $late_joining_employee_salary+= $sal_value;
                        //$arr_salary_detail[$key]['salary_amount'] =$sal_value;
                        
                    }
                    $f_key++;
                }
                $model_salary_details_single = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'salary.salary_occurence="1" AND employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                if (!empty($model_salary_details_single)) {
                    foreach ($model_salary_details_single as $key => $salarydetail) {
                        $sal_value = 0.00;
                        $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                        $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salary->salary_name;
                        $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salary->salary_type;
                        $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                        $employee_salary+= $salarydetail->amount;
                        if (strtotime($joining_date) > strtotime($payroll_startdate)) {
                            $salary_start_date = strtotime($payroll_enddate);
                            $joining_date_1 = strtotime($joining_date);
                            $datediff = $salary_start_date - $joining_date_1;
                            $diff_day = $datediff / (60 * 60 * 24) + 1;
                            //$salary_emp_per_day=round($salarydetail->amount/30, 2);
                            //$sal_value=round($salary_emp_per_day*$diff_day, 2);
                            $salary_emp_per_day = number_format($salarydetail->amount / $total_working_days, 2, '.', ''); //number_format($sal_value, $z)
                            $sal_value = round($salary_emp_per_day * $diff_day, 2);
                            $late_joining_employee_salary+= $sal_value;
                            //$arr_salary_detail[$key]['salary_amount'] =$sal_value;
                            
                        }
                        $f_key++;
                    }
                }
                //Adding Data from Table-Additions
                $uploaded_salary_additions = 0.00;
                $model_salary_uploaded_additions = HrMonthlySalaryComponent::model()->with('salarytype')->findAll(array('condition' => 'salarytype.salary_type="1" AND salarytype.salary_occurence="1" AND employee_id="' . $each_employee->id . '" AND salary_month="' . $calculated_month . '" AND salary_year="' . $calculated_year . '"'));
                if (!empty($model_salary_uploaded_additions)) {
                    foreach ($model_salary_uploaded_additions as $key => $salarydetail) {
                        $sal_value = 0.00;
                        $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                        $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salarytype->salary_name;
                        $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salarytype->salary_type;
                        $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                        $uploaded_salary_additions+= $salarydetail->amount;
                        $f_key++;
                    }
                }
                //Adding Data from Table-Deductions
                $uploaded_salary_deductions = 0.00;
                $model_salary_uploaded_deductions = HrMonthlySalaryComponent::model()->with('salarytype')->findAll(array('condition' => 'salarytype.salary_type="2" AND salarytype.salary_occurence="1" AND employee_id="' . $each_employee->id . '" AND salary_month="' . $calculated_month . '" AND salary_year="' . $calculated_year . '"'));
                if (!empty($model_salary_uploaded_deductions)) {
                    foreach ($model_salary_uploaded_deductions as $key => $salarydetail) {
                        $sal_value = 0.00;
                        $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                        $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salarytype->salary_name;
                        $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salarytype->salary_type;
                        $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                        $uploaded_salary_deductions+= $salarydetail->amount;
                        $f_key++;
                    }
                }
                //End Employee Salary
                //Pension Calculation
                $pension_salary = 0.00;
                $employee_percent_amt = 0.00;
                $company_percent_amt = 0.00;
                $total_pension_amount = 0.00;
                if ($each_employee->have_pension == 1 && $each_employee->employee_pension_scheme>0) {
                    $model_master_pension = MasPension::model()->findbyPk($each_employee->employee_pension_scheme);
                    if (!empty($model_master_pension)) {
                        $salary_type = explode(',', $model_master_pension->salary_type);
                        if (count($salary_type) > 1) {
                            foreach ($salary_type as $value_1) {
                                $model_pension_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                                $pension_salary+= $model_pension_salary->amount;
                            }
                        } else {
                            $model_pension_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $model_pension_salary->salary_type . '" AND isActive="Y"'));
                            $pension_salary = $model_pension_salary->amount;
                        }
                        $employee_percent_amt = (($pension_salary * $model_master_pension->employee_percent) / 100);
                        $company_percent_amt = (($pension_salary * $model_master_pension->company_percent) / 100);
                        $total_pension_amount = $employee_percent_amt + $company_percent_amt;
                    }
                }
                //End Pension Calculation
                //Gratuity Calculation
                $gratuity_days = 0;
                $gratuity_salary = 0.00;
                $gratuity_amount_year = 0.00;
                $gratuity_salary_per_day = 0.00;
                $total_gratuity = 0.00;
                $gratuity_per_day = 0.00;
                $gratuity_gross_amount = 0.00;
                /*if ($each_employee->probation_date != '' && $each_employee->probation_date != '0000-00-00') {
                    $date1 = new DateTime($each_employee->probation_date);
                    $date2 = new DateTime($payroll_enddate);
                    $gratuity_days = $date2->diff($date1)->format("%a");
                    $model_gratuity = MasGratuity::model()->find(array('condition' => 'days_from<="' . $gratuity_days . '" AND days_to>="' . $gratuity_days . '"'));
                    if (!empty($model_gratuity)) {
                        $salary_type = explode(',', $model_gratuity->salary_type);
                        if (count($salary_type) > 1) {
                            foreach ($salary_type as $value_1) {
                                $model_gratuity_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                                $gratuity_salary+= $model_gratuity_salary->amount;
                            }
                        } else {
                            $model_gratuity_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $model_gratuity->salary_type . '" AND isActive="Y"'));
                            if(!empty($model_gratuity_salary)){
                                $gratuity_salary = $model_gratuity_salary->amount;
                            }
                        }
                        $gratuity_amount_year = $gratuity_salary * 12;
                        $gratuity_salary_per_day = ($gratuity_amount_year / 365);
                        $total_gratuity = $gratuity_days * $gratuity_salary_per_day;
                        $gratuity_per_day = ($total_gratuity / 365);
                        $gratuity_gross_amount = round($gratuity_per_day * $diff_days, 2);
                    }
                }*/
                //End Gratuity Calculation
                $month = (int)date("m", strtotime($payroll_enddate));
                $year = (int)date("Y", strtotime($payroll_enddate));
                //$days=cal_days_in_month(CAL_GREGORIAN,$month,$year); //Total days in a month
                $days = $total_working_days;
                //$employee_per_day_salary = round($employee_salary / $days, 2); //Employee Per day salary
                $employee_per_day_salary = round(($employee_salary * 12 / 365), 2); //Employee Per day salary
                //Leave Amount Calculation
                $leave_count = 0;
                $half_salary_leave_count = 0;
                /*
                $model_master_leave = MasLeave::model()->findAll(array('condition' => 'salary_deduction="Y"'));
                foreach ($model_master_leave as $key => $value) {
                $model_leave_attendance = EmployeeAttendance::model()->with('leave')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leave.leave_type="' . $value->id . '"'));
                $leave_count+=$model_leave_attendance->id;
                }
                */
                $model_full_deduction_leave = EmployeeSalaryDeductionLeave::model()->with('leavedetail')->find(array('select' => 'count(t.id) as id', 'condition' => 'leavedetail.leave_status="12" and t.employee_id=' . $each_employee->id . ' AND leave_date>="' . $payroll_startdate . '" AND leave_date<="' . $payroll_enddate . '" AND salary_deduction_type="Y"'));
                if (!empty($model_full_deduction_leave) && $model_full_deduction_leave->id > 0) {
                    $leave_count+= $model_full_deduction_leave->id;
                }
                $model_half_deduction_leave = EmployeeSalaryDeductionLeave::model()->with('leavedetail')->find(array('select' => 'count(t.id) as id', 'condition' => 'leavedetail.leave_status="12" and t.employee_id=' . $each_employee->id . ' AND leave_date>="' . $payroll_startdate . '" AND leave_date<="' . $payroll_enddate . '" AND salary_deduction_type="H"'));
                if (!empty($model_half_deduction_leave) && $model_half_deduction_leave->id > 0) {
                    $half_salary_leave_count+= $model_half_deduction_leave->id;
                }
                //End leave calculation
                //Half Salary Leave
                /*$model_master_leave_detail = MasLeave::model()->findAll(array('condition' => 'salary_deduction="H"'));
                foreach ($model_master_leave_detail as $key => $value) {
                $model_half_leave_attendance = EmployeeAttendance::model()->with('leave')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leave.leave_type="' . $value->id . '"'));
                $half_salary_leave_count+=$model_half_leave_attendance->id;
                }*/
                //End Half Salary Leave
                //Absent Salary Deduction
                $model_absent = EmployeeAttendance::model()->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="2"'));
                if ($model_absent->id > 0) {
                    $leave_count+= $model_absent->id;
                }
                //End Absent calculation
                //Annual Leave Amount-Start
                $annual_leave_amount = 0.00;
                $model_annual_leave_attendance = EmployeeAttendance::model()->with('leave.leavetype')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leavetype.is_annual_leave="Y"'));
                if (!empty($model_annual_leave_attendance) && $model_annual_leave_attendance->id > 0) {
                    $leave_deduction_sal = 0.00;
                    $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    $leave_deduction_sal+= $model_leavededuction_salary->amount;
                    $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                    //                $leave_per_day_sal=round($leave_deduction_sal / $days, 2);
                    $leave_per_day_sal = round(($leave_deduction_sal * 12 / 365), 2);
                    $annual_leave_amount = round($leave_per_day_sal * $model_annual_leave_attendance->id, 2);
                }
                //Annual Leave Amount-End
                //Salary Deduction for leave
                $leave_deduction_amount = 0.00;
                if ($leave_count > 0) {
                    $leave_deduction_sal = 0.00;
                    //Recurring
                    $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                     if(!empty($model_leavededuction_salary) && $model_leavededuction_salary->amount >0){
                        $leave_deduction_sal+= $model_leavededuction_salary->amount;
                    }
                    $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    if(!empty($model_leavededuction_salary_single) && $model_leavededuction_salary_single->amount >0){
                            $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                    }
                    //                $leave_per_day_sal=round($leave_deduction_sal / $days, 2);
                    $leave_per_day_sal = round(($leave_deduction_sal * 12 / 365), 2);
                    $leave_deduction_amount+= round($leave_per_day_sal * $leave_count, 2);
                }
                $half_sal_amnt = 0.00;
                if ($half_salary_leave_count > 0) {
                    $leave_deduction_sal = 0.00;
                    $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                     if(!empty($model_leavededuction_salary) && $model_leavededuction_salary->amount >0){
                    $leave_deduction_sal+= $model_leavededuction_salary->amount;
                    }
                    $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    if(!empty($model_leavededuction_salary_single) && $model_leavededuction_salary_single->amount >0){
                    $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                }
                    //                $leave_per_day_sal=round($leave_deduction_sal / $days, 2);
                    $leave_per_day_sal = round(($leave_deduction_sal * 12 / 365), 2);
                    $half_sal_amnt = ($leave_per_day_sal * $half_salary_leave_count) / 2;
                    $leave_deduction_amount+= round($half_sal_amnt, 2);
                }
                //Overtime Calculation
                $overtime_work = "00:00:00";
                $overtime_amount = 0.00;
                $ofc_overtime_work = "00:00:00";
                $ofc_overtime_amount = 0.00;
                $onsite_overtime_work = "00:00:00";
                $onsite_overtime_amount = 0.00;
                $night_shift_overime_time_detail = "00:00:00";
                $normal_overime_time_detail = "00:00:00";
                $holiday_overime_time_detail = "00:00:00";
                $weekend_overime_time_detail = "00:00:00";
                //            $overtime_start_date= date('Y-m-d', strtotime('-1 month', strtotime($payroll_startdate)));
                //            $overtime_end_date=date('Y-m-d', strtotime('-1 month', strtotime($payroll_enddate)));
                $overtime_start_date = $payroll_startdate;
                $overtime_end_date = $payroll_enddate;
                $normal_ot_amount = $night_ot_amount = $holiday_ot_amount = $weekend_ot_amount = 0.00;
                if ($each_employee->overtime == "Y" && $model_hr_general_settings->calculate_overtime=="Y") {
                    //Night Shift overtime
                    $night_wrk_days = $total_working_days;
                    if ($each_employee->departmentdetail->night_ot_days > 0) {
                        $night_wrk_days = $each_employee->departmentdetail->night_ot_days;
                    }
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`night_shift_overtime`))) As night_shift_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    // $overtime_work = $model_attendance->normal_overtime;
                    if ($model_attendance->night_shift_overtime != "00:00:00") {
                        $night_shift_overime_time_detail = $model_attendance->night_shift_overtime;
                        $night_shift_overtime = explode(':', $model_attendance->night_shift_overtime);
                        $n_overtime = $night_shift_overtime[0];
                        //Overtime Salary
                        $model_master_night_shift = MasOverTime::model()->findByPk(4);
                        $night_shift_overtime_salary = 0.00;
                        $each_night_shift_ot = explode(',', $model_master_night_shift->salary);
                        foreach ($each_night_shift_ot as $value_1) {
                            $model_night_shift_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $night_shift_overtime_salary+= $model_night_shift_salary->amount;
                        }
                        $night_shift_ot_salary_per_day = round($night_shift_overtime_salary / $night_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            //$working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
                            // $working_hours_second = strtotime($working_time); //In second
                            //$working_time = explode(':', $model_company_shift->branch_working_hours);
                            //$working_hours_second=$working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        //echo $normal_ot_salary_per_day;
                        // gmdate('H:i', $working_hours_second);
                        $salary_per_second_night_shift = $night_shift_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_night_shift * 3600;
                        //Overtimesalary
                        $salary_overtime_night_shift = $salary_per_hour_normal * $model_master_night_shift->times;
                        $night_shift_salary_per_min = ($salary_overtime_night_shift / 60);
                        $overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_night_shift, 2);
                        $overtime_amount+= round((float)$night_shift_overtime[1] * (float)$night_shift_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_night_shift, 2);
                        $ofc_overtime_amount+= round((float)$night_shift_overtime[1] * (float)$night_shift_salary_per_min, 2);
                        $night_ot_amount+= round((float)$n_overtime * (float)$salary_overtime_night_shift, 2);
                        $night_ot_amount+= round((float)$night_shift_overtime[1] * (float)$night_shift_salary_per_min, 2);
                    }
                    //End Night Shift Overtime
                    //Normal overtime
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    // $overtime_work = $model_attendance->normal_overtime;
                    if ($model_attendance->normal_overtime != "00:00:00") {
                        $norm_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->normal_ot_days > 0) {
                            $norm_wrk_days = $each_employee->departmentdetail->normal_ot_days;
                        }
                        $normal_overime_time_detail = $model_attendance->normal_overtime;
                        $normal_overtime = explode(':', $model_attendance->normal_overtime);
                        $n_overtime = $normal_overtime[0];
                        //Overtime Salary
                        $model_master_normal = MasOverTime::model()->findByPk(1);
                        $normal_overtime_salary = 0.00;
                        $each_normal_ot = explode(',', $model_master_normal->salary);
                        foreach ($each_normal_ot as $value_1) {
                            $model_normalovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $normal_overtime_salary+= $model_normalovertime_salary->amount;
                        }
                        $normal_ot_salary_per_day = round($normal_overtime_salary / $norm_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        //echo $normal_ot_salary_per_day;
                        // gmdate('H:i', $working_hours_second);
                        $salary_per_second_normal = $normal_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_normal * 3600;
                        //Overtimesalary
                        $salary_overtime_normal = $salary_per_hour_normal * $model_master_normal->times;
                        $normal_salary_per_min = ($salary_overtime_normal / 60);
                        $overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_normal, 2);
                        $overtime_amount+= round((float)$normal_overtime[1] * (float)$normal_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_normal, 2);
                        $ofc_overtime_amount+= round((float)$normal_overtime[1] * (float)$normal_salary_per_min, 2);
                        $normal_ot_amount+= round((float)$n_overtime * (float)$salary_overtime_normal, 2);
                        $normal_ot_amount+= round((float)$normal_overtime[1] * (float)$normal_salary_per_min, 2);
                    }
                    //End Normal Overtime
                    //Start Holiday Overtime
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`holiday_overtime`))) As holiday_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    //$overtime_work = $model_attendance->holiday_overtime;
                    if ($model_attendance->holiday_overtime != "00:00:00") {
                        $hol_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->holiday_ot_days > 0) {
                            $hol_wrk_days = $each_employee->departmentdetail->holiday_ot_days;
                        }
                        $holiday_overime_time_detail = $model_attendance->holiday_overtime;
                        $holiday_overtime = explode(':', $model_attendance->holiday_overtime);
                        $h_overtime = $holiday_overtime[0];
                        //Overtime Salary
                        $holiday_overtime_salary = 0.00;
                        $model_master_holiday = MasOverTime::model()->findByPk(2);
                        $each_holiday_ot = explode(',', $model_master_holiday->salary);
                        foreach ($each_holiday_ot as $value_1) {
                            $model_holidayovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $holiday_overtime_salary+= $model_holidayovertime_salary->amount;
                        }
                        $holiday_ot_salary_per_day = $holiday_overtime_salary / $hol_wrk_days; //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_holiday = $holiday_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_holiday = $salary_per_second_holiday * 3600;
                        //Overtimesalary
                        $salary_overtime_holiday = $salary_per_hour_holiday * $model_master_holiday->times;
                        $holiday_salary_per_min = ($salary_overtime_holiday / 60);
                        $overtime_amount+= round((float)$h_overtime * (float)$salary_overtime_holiday, 2);
                        $overtime_amount+= round((float)$holiday_overtime[1] * (float)$holiday_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$h_overtime * (float)$salary_overtime_holiday, 2);
                        $ofc_overtime_amount+= round((float)$holiday_overtime[1] * (float)$holiday_salary_per_min, 2);
                        $holiday_ot_amount+= round((float)$h_overtime * (float)$salary_overtime_holiday, 2);
                        $holiday_ot_amount+= round((float)$holiday_overtime[1] * (float)$holiday_salary_per_min, 2);
                    }
                    //End Holiday Overtime
                    //Weekend Overtime
                    $model_attendance_weekend = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`weekend_overtime`))) As weekend_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    if ($model_attendance_weekend->weekend_overtime != "00:00:00") {
                        $wkd_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->weekend_ot_days > 0) {
                            $wkd_wrk_days = $each_employee->departmentdetail->weekend_ot_days;
                        }
                        $weekend_overime_time_detail = $model_attendance_weekend->weekend_overtime;
                        $weekend_overtime = explode(':', $model_attendance_weekend->weekend_overtime);
                        $w_overtime = $weekend_overtime[0];
                        //Overtime Salary
                        $model_master_weekend = MasOverTime::model()->findByPk(3);
                        $each_weekend_ot = explode(',', $model_master_weekend->salary);
                        $weekend_overtime_salary = 0.00;
                        foreach ($each_weekend_ot as $value_1) {
                            $model_weekendovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $weekend_overtime_salary+= $model_weekendovertime_salary->amount;
                        }
                        $weekend_ot_salary_per_day = $weekend_overtime_salary / $wkd_wrk_days; //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_weekend = $weekend_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_weekend = $salary_per_second_weekend * 3600;
                        //Overtimesalary
                        $salary_overtime_weekend = $salary_per_hour_weekend * $model_master_weekend->times;
                        $weekend_salary_per_min = ($salary_overtime_weekend / 60);
                        $overtime_amount+= round((float)$w_overtime * (float)$salary_overtime_weekend, 2);
                        $overtime_amount+= round((float)$weekend_overtime[1] * (float)$weekend_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$w_overtime * (float)$salary_overtime_weekend, 2);
                        $ofc_overtime_amount+= round((float)$weekend_overtime[1] * (float)$weekend_salary_per_min, 2);
                        $weekend_ot_amount+= round((float)$w_overtime * (float)$salary_overtime_weekend, 2);
                        $weekend_ot_amount+= round((float)$weekend_overtime[1] * (float)$weekend_salary_per_min, 2);
                    }
                    //End weekend overtime
                }
                $model_total_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`)+time_to_sec(`night_shift_overtime`)+time_to_sec(`holiday_overtime`)+time_to_sec(`weekend_overtime`)+time_to_sec(`onsite_normal_overtime`)+time_to_sec(`onsite_holiday_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                $overtime_work = $model_total_overtime->normal_overtime;
                $model_total_onsite_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`onsite_normal_overtime`)+time_to_sec(`onsite_holiday_overtime`))) As onsite_normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                $onsite_overtime_work = $model_total_onsite_overtime->onsite_normal_overtime;
                $model_total_ofc_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`)+time_to_sec(`night_shift_overtime`)+time_to_sec(`holiday_overtime`)+time_to_sec(`weekend_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                $ofc_overtime_work = $model_total_ofc_overtime->normal_overtime;
                //End Overtime Calculation
                //Employee Joining Date
                if ($joining_date != '' && $joining_date != '0000-00-00') {
                    if (strtotime($joining_date) > strtotime($payroll_startdate)) {
                        $emp_sal_deduction = $employee_salary - $late_joining_employee_salary;
                    }
                }
                //End by joining date calculation
                //Incentive Amount-Start
                $incentive_amount = 0.00;
                $model_incentive_details = HrSaleTargetDetails::model()->with('targetdetail')->find(array('condition' => 'employee_id ="' . $each_employee->id . '" and year="' . $year . '" and month="' . $month . '"'));
                if (!empty($model_incentive_details) && $model_incentive_details->net_incentive_amount > 0) {
                    $incentive_amount = $model_incentive_details->net_incentive_amount;
                }
                //Incentive Amount-End
                //Public Holiday Allowance-Start
                $holiday_count = 0;
                $holiday_allowance = 0.00;
                if ($model_hr_general_settings->consider_public_holiday_allowance == 'Y') {
                    $model_holiday = MasHoliday::model()->findAll(array('condition' => 'FIND_IN_SET("' . $each_employee->branch_or_sponsor_id . '",branch_id) AND holiday_date>="' . $payroll_startdate . '" AND holiday_date<="' . $payroll_enddate . '"'));
                    if (!empty($model_holiday)) {
                        foreach ($model_holiday as $key => $value) {
                            $model_attendance_holiday = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $each_employee->id . '" and attendance_date="' . $value->holiday_date . '" and status="1"'));
                            if (!empty($model_attendance_holiday) && $model_attendance_holiday->id > 0) {
                                $holiday_count++;
                            }
                        }
                        //Holiday Allowance
                        $model_allowance_details = HrHolidayAllowance::model()->find(array('condition' => 'employee_id ="' . $each_employee->id . '"'));
                        if(!empty($model_allowance_details)){
                            if ($holiday_count > 0) {
                                $per_day_allowance = $model_allowance_details->allowance_amount;
                                $holiday_allowance+= $per_day_allowance * $holiday_count;
                            }
                        }
                        $holiday_allowance+= $employee_per_day_salary * $holiday_count * $each_employee->departmentdetail->holiday_incentive;
                    }
                }
                //Public Holiday Allowance-End
                //Night Shift Allowance-Start
                $night_shift_count = 0;
                $night_shift_allowance = 0.00;
                $model_night_shift_days = EmployeeAttendance::model()->with('shift', 'shift.shiftdetails')->find(array('select' => 'count(t.id) as id', 'condition' => 'shiftdetails.shift_type="N" AND t.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="1"'));
                if (!empty($model_night_shift_days) && $model_night_shift_days->id > 0) {
                    $night_shift_count = $model_night_shift_days->id;
                    //Night Shift Allowance
                    $model_allowance_details = EmployeeAttendance::model()->find(array('select' => 'sum(t.night_shift_allowance) as night_shift_allowance', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '"'));
                    if ($model_allowance_details->night_shift_allowance > 0) {
                        $night_shift_allowance = $model_allowance_details->night_shift_allowance;
                    }
                }
                //Night Shift Allowance-End
                //Calculation from Overtime sheet upload-Start
                $model_timesheet_overtime = HrOutsourceOvertime::model()->find(array('condition' => 'employee_id=' . $each_employee->id . ' AND overtime_month="' . $month . '" AND overtime_year="' . $year . '"'));
                if (!empty($model_timesheet_overtime) && $model_timesheet_overtime->id > 0) {
                    //Start Normal OT
                    if ($model_timesheet_overtime->normal_overtime > 0) {
                        $norm_wrk_days =$total_working_days;
                        if ($each_employee->departmentdetail->normal_ot_days > 0) {
                            $norm_wrk_days = $each_employee->departmentdetail->normal_ot_days;
                        }
                        $model_master_normal = MasOverTime::model()->findByPk(1);
                        $normal_overtime_salary = 0.00;
                        $each_normal_ot = explode(',', $model_master_normal->salary);
                        foreach ($each_normal_ot as $value_1) {
                            $model_normalovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $normal_overtime_salary+= $model_normalovertime_salary->amount;
                        }
                        $normal_ot_salary_per_day = round($normal_overtime_salary / $norm_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_normal = $normal_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_normal * 3600;
                        //Overtimesalary
                        $salary_overtime_normal = $salary_per_hour_normal * $model_master_normal->times;
                        $normal_salary_per_min = ($salary_overtime_normal / 60);
                        $ot_nor = $salary_overtime_normal * $model_timesheet_overtime->normal_overtime;
                        $overtime_amount+= $ot_nor;
                        $ofc_overtime_amount+= $ot_nor;
                        $normal_ot_amount+= $ot_nor;
                    }
                    //End Normal Overtime
                    //Start Holiday Overtime
                    if ($model_timesheet_overtime->holiday_overtime > 0) {
                        $hol_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->holiday_ot_days > 0) {
                            $hol_wrk_days = $each_employee->departmentdetail->holiday_ot_days;
                        }
                        $model_master_holiday = MasOverTime::model()->findByPk(2);
                        $each_holiday_ot = explode(',', $model_master_holiday->salary);
                        $holiday_overtime_salary = 0.00;
                        foreach ($each_holiday_ot as $value_1) {
                            $model_holidayovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $holiday_overtime_salary+= $model_holidayovertime_salary->amount;
                        }
                        $holiday_ot_salary_per_day = $holiday_overtime_salary / $hol_wrk_days; //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_holiday = $holiday_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_holiday = $salary_per_second_holiday * 3600;
                        //Overtimesalary
                        $salary_overtime_holiday = $salary_per_hour_holiday * $model_master_holiday->times;
                        $holiday_salary_per_min = ($salary_overtime_holiday / 60);
                        $ot_hol = $salary_overtime_holiday * $model_timesheet_overtime->holiday_overtime;
                        $overtime_amount+= $ot_hol;
                        $ofc_overtime_amount+= $ot_hol;
                        $holiday_ot_amount+= $ot_hol;
                    }
                    //End Holiday Overtime
                    //Holiday Allowance-Start
                    if ($model_timesheet_overtime->holiday_count > 0) {
                        $holiday_allowance+= $employee_per_day_salary * $model_timesheet_overtime->holiday_count * $each_employee->departmentdetail->holiday_incentive;
                    }
                    //Holiday Allowance-End
                    //Night Shift Overtime-start
                    if ($model_timesheet_overtime->night_overtime > 0) {
                        $night_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->night_ot_days > 0) {
                            $night_wrk_days = $each_employee->departmentdetail->night_ot_days;
                        }
                        $model_master_night_shift = MasOverTime::model()->findByPk(4);
                        $night_shift_overtime_salary = 0.00;
                        $each_night_shift_ot = explode(',', $model_master_night_shift->salary);
                        foreach ($each_night_shift_ot as $value_1) {
                            $model_night_shift_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $night_shift_overtime_salary+= $model_night_shift_salary->amount;
                        }
                        $night_shift_ot_salary_per_day = round($night_shift_overtime_salary / $night_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_night_shift = $night_shift_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_night_shift * 3600;
                        //Overtimesalary
                        $salary_overtime_night_shift = $salary_per_hour_normal * $model_master_night_shift->times;
                        $night_shift_salary_per_min = ($salary_overtime_night_shift / 60);
                        $ot_nit = $salary_overtime_night_shift * $model_timesheet_overtime->night_overtime;
                        $overtime_amount+= $ot_nit;
                        $ofc_overtime_amount+= $ot_nit;
                        $night_ot_amount+= $ot_nit;
                    }
                    //Night Shift Overtime-end
                    //Night Shift Allowance-Start
                    if ($model_timesheet_overtime->night_shift > 0) {
                        $night_shift_allowance = $model_timesheet_overtime->night_shift * $model_hr_general_settings->night_shift_allowance;
                    }
                    //Night Shift Allowance-End
                    //Salary Deduction for absent-Start
                    if ($model_timesheet_overtime->absent_with_deduction > 0) {
                        if ($each_employee->departmentdetail->absent_deduction > 0) {
                            $leave_deduction_amount+= round($each_employee->departmentdetail->absent_deduction * $model_timesheet_overtime->absent_with_deduction, 2);
                        }
                    }
                    if ($model_timesheet_overtime->absent_without_deduction > 0) {
                        $leave_deduction_sal = 0.00;
                        //Recurring
                        $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                        $leave_deduction_sal+= $model_leavededuction_salary->amount;
                        $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                        $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                        $leave_per_day_sal = round($leave_deduction_sal / $days, 2);
                        $leave_deduction_amount+= round($leave_per_day_sal * $model_timesheet_overtime->absent_without_deduction, 2);
                    }
                    //Salary Deduction for absent-End
                    
                }
                //Calculation from Overtime sheet upload-End
                //Total Addition
                $total_additions = $overtime_amount + $annual_leave_amount + $incentive_amount + $holiday_allowance + $night_shift_allowance + $uploaded_salary_additions;
                //Total Deduction
                $total_deductions = $loan_amount + $salary_advance_deduction + $leave_deduction_amount + $employee_percent_amt + $annual_leave_amount + $emp_sal_deduction + $uploaded_salary_deductions;
                $total_salary_amount = ($employee_salary + $total_additions) - $total_deductions;
                //Start Days Absent without pay
                $days_absent_without_pay = 0.00;
                //Absent Salary Deduction
                $model_absent = EmployeeAttendance::model()->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND (status="2" OR status="3")'));
                if ($model_absent->id > 0) {
                    $days_absent_without_pay+= $model_absent->id;
                }
                $joining_date_1 = $each_employee->date_join;
                if ($joining_date_1 != '' && $joining_date_1 != '0000-00-00') {
                    if (strtotime($joining_date_1) > strtotime($payroll_startdate)) {
                        $salary_start_date = strtotime($payroll_startdate);
                        $joining_date_2 = strtotime($joining_date);
                        $datediff = $joining_date_2 - $salary_start_date;
                        $absent_days = $datediff / (60 * 60 * 24);
                        $days_absent_without_pay+= $absent_days;
                    }
                }
                if (!empty($model_timesheet_overtime) && $model_timesheet_overtime->id > 0) {
                    $days_absent_without_pay = $model_timesheet_overtime->absent_with_deduction + $model_timesheet_overtime->absent_without_deduction;
                }
                //End Days Absent without pay
                //Ticket Increment Excluded Days
                $ticket_increment_excluded_days=0;
                $model_tkt_excluded_days = EmployeeAttendance::model()->with('leave.leavetype')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leavetype.ticket_increment_hold_on_leave="Y"'));
                if ($model_tkt_excluded_days->id > 0) {
                    $ticket_increment_excluded_days= $model_tkt_excluded_days->id;
                }
                //Leave Increment Excluded Days
                $leave_increment_excluded_days=0;
                $model_leave_excluded_days = EmployeeAttendance::model()->with('leave.leavetype')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leavetype.leave_increment_hold_on_leave="Y"'));
                if ($model_leave_excluded_days->id > 0) {
                    $leave_increment_excluded_days= $model_leave_excluded_days->id;
                }
                //if ($employee_per_day_salary > 0) {
                //Salary Slip
                //Modified on 9/8/2022 by Dikson R
                if ($z == 0) {
                    date_default_timezone_set("Asia/Dubai");
                    $model_salary_processing = new SalaryProcessing();
                    $model_salary_processing->payroll_branch_or_sponsor_id = $branch;
                    $model_salary_processing->payroll_startdate = $payroll_startdate;
                    $model_salary_processing->payroll_enddate = $payroll_enddate;
                    $model_salary_processing->payroll_month = $month_name;
                    $model_salary_processing->payroll_status = 1;
                    $model_salary_processing->created_by = Yii::app()->user->id;
                    $model_salary_processing->created_date_time = date('Y-m-d H:i:s');
                    $model_salary_processing->scenario = 'calculate';
                    $valid = $model_salary_processing->validate();
                    if ($valid) {
                        $model_salary_processing->save();
                    }
                }
                //Valid then only add details
                if ($valid) {
                    $model_salary_slip = new SalarySlip();
                    $model_salary_slip->salary_processing_id = $model_salary_processing->id;
                    $model_salary_slip->employee_id = $each_employee->id;
                    $model_salary_slip->total_working_days = $total_working_days;
                    $model_salary_slip->absent_working_days = $days_absent_without_pay;
                    $model_salary_slip->ticket_increment_excluded_days = $ticket_increment_excluded_days;
                    $model_salary_slip->leave_increment_excluded_days = $leave_increment_excluded_days;
                    $model_salary_slip->salary_advance_amount = $salary_advance_deduction;
                    $model_salary_slip->leave_amount = $leave_deduction_amount;
                    $model_salary_slip->loan_amount = $loan_amount;
                    $model_salary_slip->incentive = $incentive_amount;
                    $model_salary_slip->public_holiday = $holiday_count;
                    $model_salary_slip->public_holiday_allowance = $holiday_allowance;
                    $model_salary_slip->night_shift_days = $night_shift_count;
                    $model_salary_slip->night_shift_allowance = $night_shift_allowance;
                    $model_salary_slip->normal_ot_amount = $normal_ot_amount;
                    $model_salary_slip->night_ot_amount = $night_ot_amount;
                    $model_salary_slip->holiday_ot_amount = $holiday_ot_amount;
                    $model_salary_slip->weekend_ot_amount = $weekend_ot_amount;
                    $model_salary_slip->onsite_overtime = $onsite_overtime_work;
                    $model_salary_slip->onsite_overtime_amount = $onsite_overtime_amount;
                    $model_salary_slip->office_ot = $ofc_overtime_work;
                    $model_salary_slip->office_ot_amount = $ofc_overtime_amount;
                    $model_salary_slip->overtime_hour = $overtime_work;
                    $model_salary_slip->overtime_amount = $overtime_amount;
                    //Pension split
                    $model_salary_slip->pension_amount_employee = $employee_percent_amt;
                    $model_salary_slip->pension_amount_company = $company_percent_amt;
                    //
                    $model_salary_slip->pension_amount = $employee_percent_amt;
                    $model_salary_slip->gratuity_amount = $gratuity_gross_amount;
                    $model_salary_slip->employee_salary_amount = $employee_salary;
                    $model_salary_slip->before_joining_salary = $emp_sal_deduction;
                    $model_salary_slip->annual_leave_addition = 0;
                    $model_salary_slip->annual_leave_deduction = 0;
                    $model_salary_slip->total_addition_amount = $total_additions;
                    $model_salary_slip->total_deduction_amount = $total_deductions;
                    $model_salary_slip->total_salary_amount = $total_salary_amount;
                    //Threshold salary
                    if ($model_hr_general_settings->consider_threshold_salary == 'Y') {
                        $model_salary_slip->threshold_salary = $each_employee->threshold_salary;
                        $threshold_salary = $each_employee->threshold_salary;
                        if ($total_salary_amount > $threshold_salary) {
                            $sif_bal_salary = $total_salary_amount - $threshold_salary;
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $threshold_salary;
                            $model_salary_slip->sif_untransfer_salary = $sif_bal_salary;
                        } else {
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                            $model_salary_slip->sif_untransfer_salary = 0.00;
                        }
                    } else {
                        $model_salary_slip->threshold_salary = 0.00;
                        $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                        $model_salary_slip->sif_untransfer_salary = 0.00;
                    }
                    $model_salary_slip->created_by = Yii::app()->user->id;
                    $model_salary_slip->created_date_time = date('Y-m-d H:i:s');
                    $model_salary_slip->save();
                    //Pension Save
                    if ($each_employee->have_pension == 1 && $each_employee->employee_pension_scheme>0) {
                        $model_pension = new EmployeePension();
                        $model_pension->salary_slip_id = $model_salary_slip->id;
                        $model_pension->employee_id = $each_employee->id;
                        $model_pension->employee_contribution_amount = $employee_percent_amt;
                        $model_pension->company_contribution_amount = $company_percent_amt;
                        $model_pension->total_pension_amount = $total_pension_amount;
                        $model_pension->created_date = date('Y-m-d');
                        $model_pension->save();
                    }
                    //End Pension Save
                    //Gratuity Saving
                    /*$model_gratuity = new MonthlyGratuity();
                    $model_gratuity->employee_id = $each_employee->id;
                    $model_gratuity->salary_slip_id = $model_salary_slip->id;
                    $model_gratuity->gratuity_amount = $gratuity_gross_amount;
                    $model_gratuity->created_date = date('Y-m-d');
                    $model_gratuity->save();*/
                    //End Gratuity Saving
                    //Salary Slip Details
                    foreach ($arr_salary_detail as $i => $item) {
                        $model_salary_slip_details = new SalarySlipDetails();
                        $model_salary_slip_details->salary_processing_id = $model_salary_processing->id;
                        $model_salary_slip_details->salary_slip_id = $model_salary_slip->id;
                        $model_salary_slip_details->salary_id = $item['salary_id'];
                        $model_salary_slip_details->salary_name = $item['salary_name'];
                        $model_salary_slip_details->salary_type = $item['salary_type'];
                        $model_salary_slip_details->salary_amount = $item['salary_amount'];
                        $model_salary_slip_details->created_by = Yii::app()->user->id;
                        $model_salary_slip_details->created_date_time = date('Y-m-d H:i:s');
                        $model_salary_slip_details->save();
                    }
                    $z++;
                } else {
                    $error = CActiveForm::validate($model_salary_processing, '', false);
                    if ($error != '[]') echo $error;
                    Yii::app()->end();
                }
                //}
                
            }
            //End Employee
            if ($z == 0) {
                $jsonData['status'] = 'error';
            } else {
                $jsonData['status'] = 'success';
            }
            echo CJSON::encode($jsonData);
        } else {
            $jsonData['status'] = 'error';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionEditSalary() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $id = (int)Yii::app()->request->getParam('processing_id');
        $model = SalaryProcessing::model()->findbyPK($id);
        $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $model->id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_salary', array('model' => $model, 'model_salary_slip' => $model_salary_slip), false, true);
    }
    public function actionEditEmployeeSalary() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $id = (int)Yii::app()->request->getParam('id');
        $model_salary_slip = SalarySlip::model()->findbyPK($id);
        $model_salary_slip_details = SalarySlipDetails::model()->findAll(array('condition' => 'salary_slip_id="' . $id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_employee_salary', array('model_salary_slip' => $model_salary_slip, 'model_salary_slip_details' => $model_salary_slip_details), false, true);
    }
    public function actionRollbackSalary() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $id = $_POST['processing_id'];
        $salary_delete = SalaryProcessing::model()->deletebyPK($id);
        if ($salary_delete == 1) {
            $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '"'));
            foreach ($model_salary_slip as $key => $value) {
                SalarySlipDetails::model()->deleteAll(array('condition' => 'salary_slip_id="' . $value->id . '"'));
                EmployeePension::model()->deleteAll(array('condition' => 'salary_slip_id="' . $value->id . '"'));
                MonthlyGratuity::model()->deleteAll(array('condition' => 'salary_slip_id="' . $value->id . '"'));
                SalarySlip::model()->deletebyPK($value->id);
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $jsonData['status'] = 'error';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionLockSalary() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $id = $_POST['processing_id'];
        date_default_timezone_set("Asia/Dubai");
        if ($id > 0) {
            $model = SalaryProcessing::model()->findbyPK($id);
            $month = (int)date("m", strtotime($model->payroll_enddate));
            $year = (int)date("Y", strtotime($model->payroll_enddate));
            $created_date = date('Y-m-d', strtotime($model->created_date_time));
            $payroll_end_date=$model->payroll_enddate;
            $model_general_setting = HrGenerelSettings::model()->find();
            SalaryProcessing::model()->updateByPK($id, array('payroll_status' => 2, 'salary_lock_date' => date('Y-m-d')));
            //Loan Details
            $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '" and loan_amount>0'));
            foreach ($model_salary_slip as $key => $value) {
                $loan_amount = $value->loan_amount;
                $model_loan = EmployeeLoanDetail::model()->findAll(array('condition' => '(loan_status="14" OR loan_status="15") and isActive="Y" AND employee_id="' . $value->employee_id . '" and repayment_start_date<="' . $payroll_end_date . '"'));
                $loan_repayment = 0.00;
                foreach ($model_loan as $key_1 => $value_1) {
                    $paymnt = 0.00;
                    $loan_taken = $value_1->loan_amount;
                    if ($loan_amount > $value_1->loan_monthly_payment) {
                        $paymnt = $value_1->loan_monthly_payment;
                        $loan_amount = $loan_amount - $value_1->loan_monthly_payment;
                    } else if ($loan_amount == $value_1->loan_monthly_payment) {
                        $paymnt = $value_1->loan_monthly_payment;
                        $loan_amount = $loan_amount - $value_1->loan_monthly_payment;
                    } else {
                        $paymnt = $loan_amount;
                        $loan_amount = $loan_amount - $value_1->loan_monthly_payment;
                    }
                    $model_loan_installment = EmployeeLoan::model()->find(array('select' => 'max(loan_installment) as loan_installment', 'condition' => 'loan_id="' . $value_1->id . '"'));
                    if ($paymnt > 0) {
                        $model_loan_payment = new EmployeeLoan();
                        $model_loan_payment->employee_id = $value->employee_id;
                        $model_loan_payment->loan_id = $value_1->id;
                        $model_loan_payment->loan_amount = $paymnt;
                        $model_loan_payment->added_from = 2;
                        $model_loan_payment->salary_lock_id = $model->id;
                        $model_loan_payment->date_payment = date('Y-m-d');
                        $model_loan_payment->loan_installment = $model_loan_installment->loan_installment + 1;
                        $model_loan_payment->save();
                        $loan_repayment = $value_1->loan_repayment + $paymnt;
                        $loan_status = $value_1->loan_status;
                        if ($loan_taken == $loan_repayment) {
                            $loan_status = 16;
                        } else {
                            $loan_status = 15;
                        }
                        EmployeeLoanDetail::model()->updateByPK($value_1->id, array('loan_repayment' => $loan_repayment, 'loan_status' => $loan_status));
                    }
                }
            }
            //End Loan Details
            //Salary Advance
            $model_salary_slip_1 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '" and salary_advance_amount>0'));
            foreach ($model_salary_slip_1 as $key => $value) {
                $model_salary_advance = EmployeeSalaryAdvance::model()->find(array('condition' => '(advance_payment_status="14" OR advance_payment_status="15") AND employee_id="' . $value->employee_id . '" and  approved_date<="' . $created_date . '"'));
                $salary_advance_amount = $value->salary_advance_amount;
                $model_salary_advance_payment = new EmployeeSalaryAdvancePayment();
                $model_salary_advance_payment->employee_id = $value->employee_id;
                $model_salary_advance_payment->advance_id = $model_salary_advance->id;
                $model_salary_advance_payment->advance_amount = $value->salary_advance_amount;
                $model_salary_advance_payment->payment_date = date('Y-m-d');
                $model_salary_advance_payment->added_from = 2;
                $model_salary_advance_payment->salary_lock_id = $model->id;
                $model_salary_advance_payment->save();
                //$model_advance_amount = EmployeeSalaryAdvance::model()->find(array('condition' => 'employee_id="' . $value->employee_id . '" and advance_payment_status="1"'));
                $advance_amount = $model_salary_advance->amount;
                $advance_payment_status = 15;
                if ($salary_advance_amount == $advance_amount) {
                    $advance_payment_status = 16;
                } else {
                    $advance_payment_status = 15;
                }
                EmployeeSalaryAdvance::model()->updateByPK($model_salary_advance->id, array('advance_payment_status' => $advance_payment_status));
            }
            //End Salary Advance
            //Incrementing leave
            $model_leave = MasLeave::model()->findAll(array('condition' => 'leave_type="1" and branch_id="' . $model->payroll_branch_or_sponsor_id . '"'));
            foreach ($model_leave as $key => $value) {
                $model_salary_slip_2 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '"'));
                foreach ($model_salary_slip_2 as $key_1 => $value_1) {
                    $incremented_leave = $value->leave_days;
                    $basic_increment=$value->leave_days;
                    $joining_date = $value_1->employeedetail->date_join;
                    $payroll_start = $value_1->processing->payroll_startdate;
                    $payroll_end = $value_1->processing->payroll_enddate;
                    if (strtotime($joining_date) > strtotime($payroll_start)) {
                        $salary_start_date = strtotime($payroll_end);
                        $joining_date_1 = strtotime($joining_date);
                        $datediff = $salary_start_date - $joining_date_1;
                        $diff_day = $datediff / (60 * 60 * 24) + 1;
                        $per_day_leave = $incremented_leave / 30;
                        $inc_day = round($per_day_leave * $diff_day, 2);
                        $incremented_leave = $inc_day;
                    }
                    $service_year = $this->getserviceyear($joining_date, $payroll_start);
                    if ($service_year >= 10) {
                        $incremented_leave = $value->leave_days_above_10;
                        $basic_increment=$value->leave_days_above_10;
                    } else if ($service_year >= 5) {
                        $incremented_leave = $value->leave_days_above_5;
                        $basic_increment=$value->leave_days_above_5;
                    }else if ($service_year >= 1) {
                        $incremented_leave = $value->leave_days_above_1;
                        $basic_increment=$value->leave_days_above_1;
                    }
                    if($value_1->leave_increment_excluded_days>0){
                        $per_day_leave = $basic_increment / 30;
                        $inc_day = round($per_day_leave * $value_1->leave_increment_excluded_days, 2);
                        $incremented_leave = $incremented_leave-$inc_day;
                    }
                    if($incremented_leave<0){
                        $incremented_leave=0;
                    }
                    $current_month = date("m");
                    $current_year = date('Y');
                    $leave_year = $current_year;
                    if ($month < $model_general_setting->leave_carry_forward_month) {
                        $year = $year - 1;
                        $leave_year = $current_year - 1;
                    }
                    $model_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $year . '"'));
                    $total_leave = 0;
                    $model_leave_details_new = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $leave_year . '"'));
                    $model_leave_details_current_year = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $current_year . '"'));
                    if (empty($model_leave_details) && empty($model_leave_details_new) && empty($model_leave_details_current_year)) {
                        $model_employee_leave = new EmployeeLeave();
                        $model_employee_leave->employee_id = $value_1->employee_id;
                        $model_employee_leave->leave_type = $value->id;
                        $model_employee_leave->leave_year = $leave_year;
                        $model_employee_leave->leave_opening = 0;
                        $model_employee_leave->leave_current_balance = $incremented_leave;
                        $model_employee_leave->created_by = Yii::app()->user->id;
                        $model_employee_leave->created_date_time = date('Y-m-d H:i:s');
                        $model_employee_leave->save(false);
                    } else if (!empty($model_leave_details_current_year)) {
                        $total_leave = $model_leave_details_current_year->leave_current_balance + $incremented_leave;
                        EmployeeLeave::model()->updateByPK($model_leave_details_current_year->id, array('leave_current_balance' => $total_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    } else if (!empty($model_leave_details_new)) {
                        $total_leave = $model_leave_details_new->leave_current_balance + $incremented_leave;
                        EmployeeLeave::model()->updateByPK($model_leave_details_new->id, array('leave_current_balance' => $total_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    } else if (!empty($model_leave_details)) {
                        $total_leave = $model_leave_details->leave_current_balance + $incremented_leave;
                        EmployeeLeave::model()->updateByPK($model_leave_details->id, array('leave_current_balance' => $total_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    } else {
                        $total_leave = $model_leave_details->leave_current_balance + $incremented_leave;
                        $model_leave_details_curr = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $current_year . '"'));
                        if ($model_leave_details_curr->id > 0) {
                            EmployeeLeave::model()->updateByPK($model_leave_details_curr->id, array('leave_current_balance' => $total_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        } else {
                            $model_employee_leave = new EmployeeLeave();
                            $model_employee_leave->employee_id = $value_1->employee_id;
                            $model_employee_leave->leave_type = $value->id;
                            $model_employee_leave->leave_year = $leave_year;
                            $model_employee_leave->leave_opening = $model_leave_details->leave_current_balance;
                            $model_employee_leave->leave_current_balance = $total_leave;
                            $model_employee_leave->created_by = Yii::app()->user->id;
                            $model_employee_leave->created_date_time = date('Y-m-d H:i:s');
                            $model_employee_leave->save(false);
                        }
                    }
                    //In leave ledger
                    $model_leave_ledger = new EmployeeLeaveLedger();
                    $model_leave_ledger->employee_id = $value_1->employee_id;
                    $model_leave_ledger->leave_type = $value->id;
                    $model_leave_ledger->leave_count = $incremented_leave;
                    $model_leave_ledger->remarks = "Leave added by salary locked for " . $model->payroll_month;
                    $model_leave_ledger->created_by = Yii::app()->user->id;
                    $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                    $model_leave_ledger->save();
                    //Salary Slip table annual leave updation
                    if ($value->is_annual_leave =='Y') {
                        $model_current_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $year . '"'));
                        SalarySlip::model()->updateByPK($value_1->id, array('current_leave_balance' => $model_current_leave_details->leave_current_balance));
                    }
                }
            }
            //Start Ticket detail
            if ($model->branch_sponsor->ticket_provided == "Y" && $model->branch_sponsor->ticket_monthly_incremented == "Y") {
               // $ticket_amount = round(100 / 12, 2);
                $model_salary_slip_7 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '"'));
                foreach ($model_salary_slip_7 as $key_1 => $value_7) {
                    if ($value_7->employeedetail->travel_allowance > 0) {
                        $ticket_amount_per_month = 100 / (12*$value_7->employeedetail->travel_allowance);
                        $days_before_joining=0;
                        if (strtotime($value_7->employeedetail->date_join)>strtotime($model->payroll_startdate)){
                            $datediff_1 = strtotime($value_7->employeedetail->date_join)-strtotime($model->payroll_startdate) ;
                            $days_before_joining = $datediff_1 / (60 * 60 * 24);
                        }
                        $ticket_amount_per_day=$ticket_amount_per_month/$value_7->total_working_days;
                        $ticket_available_days=$value_7->total_working_days-$value_7->ticket_increment_excluded_days-$days_before_joining;
                        $ticket_amount=round($ticket_amount_per_day*$ticket_available_days, 2);
                        $model_ticket_details_current_year = EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="' . $value_7->employee_id . '" and ticket_year="' . $current_year . '"'));
                        $model_ticket_details_new = EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="' . $value_7->employee_id . '" and ticket_year="' . $leave_year . '"'));
                        $model_ticket_details = EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="' . $value_7->employee_id . '" and ticket_year="' . $year . '"'));
                        if (empty($model_ticket_details) && empty($model_ticket_details_new) && empty($model_ticket_details_current_year)) {
                            $old_year  = $current_year - 1;
                            $model_ticket_details_old = EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="' . $value_7->employee_id . '" and ticket_year="' . $old_year . '"'));
                            $new_balance =$ticket_amount;
                            if(!empty($model_ticket_details_old)){
                              $old_balance =  $model_ticket_details_old->ticket_balance;
                              $new_balance = $old_balance + $ticket_amount;
                            }else{
                               $old_balance=0.00; 
                            }
                            $model_ticket_entitlement = new EmployeeTicketEntitlement();
                            $model_ticket_entitlement->created_by = Yii::app()->user->id;
                            $model_ticket_entitlement->created_date_time = date('Y-m-d H:i:s');
                            $model_ticket_entitlement->employee_id = $value_7->employee_id;
                            $model_ticket_entitlement->ticket_balance = $new_balance;
                            $model_ticket_entitlement->ticket_year = $year;
                            $model_ticket_entitlement->opening_balance = $old_balance;
                            $model_ticket_entitlement->branch_id = $model->payroll_branch_or_sponsor_id;
                            $model_ticket_entitlement->save();
                        } else if (!empty($model_ticket_details)) {
                            $tkt_amount = $model_ticket_details->ticket_balance + $ticket_amount;
                            EmployeeTicketEntitlement::model()->updateByPK($model_ticket_details->id, array('ticket_balance' => $tkt_amount, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                        } else if (!empty($model_ticket_details_current_year)) {
                            $tkt_amount = $model_ticket_details_current_year->ticket_balance + $ticket_amount;
                            EmployeeTicketEntitlement::model()->updateByPK($model_ticket_details_current_year->id, array('ticket_balance' => $tkt_amount, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        } else if (!empty($model_ticket_details_new)) {
                            $tkt_amount = $model_ticket_details_new->ticket_balance + $ticket_amount;
                            EmployeeTicketEntitlement::model()->updateByPK($model_ticket_details_new->id, array('ticket_balance' => $tkt_amount, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        } else {
                            $model_ticket_entitlement = new EmployeeTicketEntitlement();
                            $model_ticket_entitlement->created_by = Yii::app()->user->id;
                            $model_ticket_entitlement->created_date_time = date('Y-m-d H:i:s');
                            $model_ticket_entitlement->employee_id = $value_7->employee_id;
                            $model_ticket_entitlement->ticket_balance = $ticket_amount;
                            $model_ticket_entitlement->ticket_year = $year;
                            $model_ticket_entitlement->opening_balance = $model_ticket_details->ticket_amount;
                            $model_ticket_entitlement->branch_id = $model->payroll_branch_or_sponsor_id;
                            $model_ticket_entitlement->save();
                        }
                        //In leave ledger
                        if ($ticket_amount > 0) {
                            $model_ticket_ledger = new HrEmployeeTicketLedger();
                            $model_ticket_ledger->employee_id = $value_7->employee_id;
                            $model_ticket_ledger->ticket_percentage = $ticket_amount;
                            $model_ticket_ledger->remarks = "Ticket added by salary locked for " . $model->payroll_month;
                            $model_ticket_ledger->created_by = Yii::app()->user->id;
                            $model_ticket_ledger->created_date_time = date('Y-m-d H:i:s');
                            $model_ticket_ledger->save();
                        }
                        SalarySlip::model()->updateByPK($value_7->id, array('ticket_entitlement_balance' => $ticket_amount));
                    }
                }
            }
  
            //End Ticket detail
            //Leave adding in salary slip
            $model_salary_slip_3 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '"'));
            foreach ($model_salary_slip_3 as $key_1 => $value_3) {
                $model_leave_slip = MasLeave::model()->findAll(array('condition' => 'show_in_payslip="Y" and branch_id="' . $model->payroll_branch_or_sponsor_id . '"'));
                foreach ($model_leave_slip as $key => $value_detail) {
                    $model_leave_count = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_3->employee_id . '" and leave_type="' . $value_detail->id . '" and leave_year="' . $year . '"'));
                    $leave_count = 0.00;
                    if (!empty($model_leave_count)) {
                        $leave_count = $model_leave_count->leave_current_balance;
                    }
                    $model_leave_salary_slip_details = new SalarySlipLeavedetails();
                    $model_leave_salary_slip_details->salary_processing_id = $value_3->salary_processing_id;
                    $model_leave_salary_slip_details->salary_slip_id = $value_3->id;
                    $model_leave_salary_slip_details->employee_id = $value_3->employee_id;
                    $model_leave_salary_slip_details->leave_id = $value_detail->id;
                    $model_leave_salary_slip_details->leave_name = $value_detail->leave_name;
                    $model_leave_salary_slip_details->leave_count = $leave_count;
                    $model_leave_salary_slip_details->created_by = Yii::app()->user->id;
                    $model_leave_salary_slip_details->created_date_time = date('Y-m-d H:i:s');
                    $model_leave_salary_slip_details->save();
                }
            }
            //End Leave adding in salary slip
            //Leave Calculation Ends
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionUnLockSalary() {
        $id = $_POST['processing_id'];
        if ($id > 0) {
            $model = SalaryProcessing::model()->findbyPK($id);
            $salary_lock_date = $model->salary_lock_date;
            SalaryProcessing::model()->updateByPK($id, array('payroll_status' => 1, 'salary_lock_date' => '0000-00-00'));
            SalarySlipLeavedetails::model()->deleteAll(array('condition' => 'salary_processing_id="' . $id . '"'));
            $model_general_setting = HrGenerelSettings::model()->find();
            //Salary Advance Revert
            $model_salary_slip_1 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '" and salary_advance_amount>0'));
            foreach ($model_salary_slip_1 as $key => $value) {
                //$model_advance_amount = EmployeeSalaryAdvance::model()->find(array('select' => 'max(id) as id', 'condition' => 'employee_id="' . $value->employee_id . '" and (advance_payment_status="5")'));
                $model_advance_installment = EmployeeSalaryAdvancePayment::model()->findAll(array('condition' => 'payment_date="' . $salary_lock_date . '" and employee_id="' . $value->employee_id . '" and salary_lock_id="' . $model->id . '" and added_from="2"'));
                foreach ($model_advance_installment as $key_5 => $value_5) {
                    EmployeeSalaryAdvance::model()->updateByPK($value_5->advance_id, array('advance_payment_status' => 15));
                }
                EmployeeSalaryAdvancePayment::model()->deleteAll(array('condition' => 'payment_date="' . $salary_lock_date . '" AND employee_id="' . $value->employee_id . '"'));
            }
            //End Advance Revert
            //Loan Revert
            $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '" and loan_amount>0'));
            foreach ($model_salary_slip as $key => $value) {
                $model_loan_installment = EmployeeLoan::model()->findAll(array('condition' => 'date_payment="' . $salary_lock_date . '" and employee_id="' . $value->employee_id . '" and salary_lock_id="' . $model->id . '" and added_from="2"'));
                foreach ($model_loan_installment as $key_1 => $value_1) {
                    $loan_id = $value_1->loan_id;
                    EmployeeLoan::model()->deletebyPK($value_1->id);
                    $model_loan = EmployeeLoanDetail::model()->findbyPK($loan_id);
                    $model_loan_paid = EmployeeLoan::model()->find(array('select' => 'sum(loan_amount) as loan_amount', 'condition' => 'loan_id="' . $loan_id . '"'));
                    $loan_taken = $model_loan->loan_amount;
                    $loan_paid = $model_loan_paid->loan_amount;
                    $loan_status = $model_loan->loan_status;
                    if ($loan_paid != $loan_taken) {
                        $loan_status = 15;
                    }
                    EmployeeLoanDetail::model()->updateByPK($loan_id, array('loan_repayment' => $loan_paid, 'loan_status' => $loan_status));
                }
            }
            //End Loan Revert
            //Leave Revert
            $current_year = date('Y');
            $year = (int)date("Y", strtotime($model->payroll_enddate));
            $month = (int)date("m", strtotime($model->payroll_enddate));
            $model_leave = MasLeave::model()->findAll(array('condition' => 'leave_type="1" and branch_id="' . $model->payroll_branch_or_sponsor_id . '"'));
            foreach ($model_leave as $key => $value) {
                $model_salary_slip_2 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '"'));
                foreach ($model_salary_slip_2 as $key_1 => $value_1) {
                    $incremented_leave = $value->leave_days;
                    $basic_increment=$value->leave_days;
                    $joining_date = $value_1->employeedetail->date_join;
                    $payroll_start = $value_1->processing->payroll_startdate;
                    $payroll_end = $value_1->processing->payroll_enddate;
                    if (strtotime($joining_date) > strtotime($payroll_start)) {
                        $salary_start_date = strtotime($payroll_end);
                        $joining_date_1 = strtotime($joining_date);
                        $datediff = $salary_start_date - $joining_date_1;
                        $diff_day = $datediff / (60 * 60 * 24) + 1;
                        $per_day_leave = $incremented_leave / 30;
                        $inc_day = round($per_day_leave * $diff_day, 2);
                        $incremented_leave = $inc_day;
                    }
                    $service_year = $this->getserviceyear($joining_date, $payroll_start);
                    if ($service_year >= 10) {
                        $incremented_leave = $value->leave_days_above_10;
                        $basic_increment=$value->leave_days_above_10;
                    } else if ($service_year >= 5) {
                        $incremented_leave = $value->leave_days_above_5;
                        $basic_increment=$value->leave_days_above_5;
                    }else if ($service_year >= 1) {
                        $incremented_leave = $value->leave_days_above_1;
                        $basic_increment=$value->leave_days_above_1;
                    }
                    if($value_1->leave_increment_excluded_days>0){
                        $per_day_leave = $basic_increment / 30;
                        $inc_day = round($per_day_leave * $value_1->leave_increment_excluded_days, 2);
                        $incremented_leave = $incremented_leave-$inc_day;
                    }
                    if($incremented_leave<0){
                        $incremented_leave=0;
                    }
                    $current_month = date("m");
                    $current_year = date('Y');
                    $leave_year = $current_year;
                    if ($month < $model_general_setting->leave_carry_forward_month) {
                        $year = $year - 1;
                        $leave_year = $current_year - 1;
                    }
                    $model_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $current_year . '"'));
                    if (empty($model_leave_details)) {
                        $model_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $leave_year . '"'));
                    }
                    if (empty($model_leave_details)) {
                        $model_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $year . '"'));
                    }
                    if (!empty($model_leave_details)) {
                        $total_leave = $model_leave_details->leave_current_balance - $incremented_leave;
                        EmployeeLeave::model()->updateByPK($model_leave_details->id, array('leave_current_balance' => $total_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    }
                    $remarks = "Leave added by salary locked for " . $model->payroll_month;
                    EmployeeLeaveLedger::model()->deleteAll(array('condition' => 'remarks="' . $remarks . '" and DATE(created_date_time)="' . $salary_lock_date . '" AND employee_id="' . $value_1->employee_id . '" and leave_count>0 and leave_type="' . $value->id . '"'));
                    //Salary Slip table annual leave updation
                    if ($value->is_annual_leave =='Y') {
                        $model_current_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $value_1->employee_id . '" and leave_type="' . $value->id . '" and leave_year="' . $year . '"'));
                        SalarySlip::model()->updateByPK($value_1->id, array('current_leave_balance' => $model_current_leave_details->leave_current_balance));
                    }
                }
            }
            //End Leave Revert
            //Start Ticket detail
            if ($model->branch_sponsor->ticket_provided == "Y" && $model->branch_sponsor->ticket_monthly_incremented == "Y") {
                $ticket_amount = round(100 / 12, 2);
                $model_salary_slip_7 = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $id . '"'));
                foreach ($model_salary_slip_7 as $key_1 => $value_7) {
                    if ($value_7->employeedetail->travel_allowance > 0) {
                        $ticket_amount_per_month = 100 / (12*$value_7->employeedetail->travel_allowance);
                        $days_before_joining=0;
                        if (strtotime($value_7->employeedetail->date_join)>strtotime($model->payroll_startdate)){
                            $datediff_1 = strtotime($value_7->employeedetail->date_join)-strtotime($model->payroll_startdate) ;
                            $days_before_joining = $datediff_1 / (60 * 60 * 24);
                        }
                        $ticket_amount_per_day=$ticket_amount_per_month/$value_7->total_working_days;
                        $ticket_available_days=$value_7->total_working_days-$value_7->ticket_increment_excluded_days-$days_before_joining;
                        $ticket_amount=round($ticket_amount_per_day*$ticket_available_days, 2);
                        $model_ticket_details = EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="' . $value_7->employee_id . '" and ticket_year="' . $year . '"'));
                        if (!empty($model_ticket_details)) {
                            $tkt_amount = $model_ticket_details->ticket_balance - $ticket_amount;
                            EmployeeTicketEntitlement::model()->updateByPK($model_ticket_details->id, array('ticket_balance' => $tkt_amount, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                        }
                        $remarks = "Ticket added by salary locked for " . $model->payroll_month;
                        HrEmployeeTicketLedger::model()->deleteAll(array('condition' => 'remarks="' . $remarks . '" and DATE(created_date_time)="' . $salary_lock_date . '" AND employee_id="' . $value_7->employee_id . '" and ticket_percentage="' . $ticket_amount . '"'));
                        SalarySlip::model()->updateByPK($value_7->id, array('ticket_entitlement_balance' => 0.00));
                    }
                }
            }
            //End Ticket detail
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionUpdateSalary() {
        if (isset($_POST['SalarySlip'])) {
            $model_salary_slip_exist = SalarySlip::model()->findByPK($_POST['SalarySlip']['id']);
            if ($model_salary_slip_exist->id > 0 && $model_salary_slip_exist->processing->payroll_status == 1) {
                if ((int)@$_POST['SalarySlip']['id'] > 0) {
                    $model_salary_slip = SalarySlip::model()->findByPK($_POST['SalarySlip']['id']);
                    $model_salary_slip->salary_advance_amount = $_POST['SalarySlip']['salary_advance_amount'];
                    $model_salary_slip->leave_amount = $_POST['SalarySlip']['leave_amount'];
                    $model_salary_slip->loan_amount = $_POST['SalarySlip']['loan_amount'];
                    $model_salary_slip->before_joining_salary = $_POST['SalarySlip']['before_joining_salary'];
                    $model_salary_slip->annual_leave_deduction = $_POST['SalarySlip']['annual_leave_deduction'];
                    $model_salary_slip->total_working_days = $_POST['SalarySlip']['total_working_days'];
                    $model_salary_slip->absent_working_days = $_POST['SalarySlip']['absent_working_days'];
                    $model_salary_slip->annual_leave_addition = $_POST['SalarySlip']['annual_leave_addition'];
                    $model_salary_slip->incentive = $_POST['SalarySlip']['incentive'];
                    $overtime_amount = $_POST['SalarySlip']['overtime_amount'];
                    if ($overtime_amount > 0) {
                        $model_salary_slip->overtime_amount = $_POST['SalarySlip']['overtime_amount'];
                    } else {
                        $model_salary_slip->overtime_hour = '';
                        $model_salary_slip->overtime_amount = 0.00;
                    }
                    $model_salary_slip->other_addition = $_POST['SalarySlip']['other_addition'];
                    $model_salary_slip->other_deduction = $_POST['SalarySlip']['other_deduction'];
                    $total_addition = $overtime_amount + $_POST['SalarySlip']['other_addition'] + $_POST['SalarySlip']['annual_leave_addition'] + $_POST['SalarySlip']['incentive'];
                    $total_deduction = $_POST['SalarySlip']['loan_amount'] + $_POST['SalarySlip']['salary_advance_amount'] + $_POST['SalarySlip']['leave_amount'] + $_POST['SalarySlip']['pension_amount_1'] + $_POST['SalarySlip']['before_joining_salary'] + $_POST['SalarySlip']['annual_leave_deduction'];
                    $model_salary_slip->total_addition_amount = $total_addition;
                    $model_salary_slip->total_deduction_amount = $total_deduction + $_POST['SalarySlip']['other_deduction'];
                    $model_hr_general_settings = HrGenerelSettings::model()->find();
                    $total_salary_amount = $_POST['SalarySlip']['total_salary_amount'];
                    $model_salary_slip->total_salary_amount = $_POST['SalarySlip']['total_salary_amount'];
                    if ($model_hr_general_settings->consider_threshold_salary == 'Y') {
                        $model_salary_slip->threshold_salary = $model_salary_slip->employeedetail->threshold_salary;
                        $threshold_salary = $model_salary_slip->employeedetail->threshold_salary;
                        if ($total_salary_amount > $threshold_salary) {
                            $sif_bal_salary = $total_salary_amount - $threshold_salary;
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $threshold_salary;
                            $model_salary_slip->sif_untransfer_salary = $sif_bal_salary;
                        } else {
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                            $model_salary_slip->sif_untransfer_salary = 0.00;
                        }
                    } else {
                        $model_salary_slip->threshold_salary = 0.00;
                        $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                        $model_salary_slip->sif_untransfer_salary = 0.00;
                    }
                    $model_salary_slip->remarks = $_POST['SalarySlip']['remarks'];
                    $model_salary_slip->updated_by = Yii::app()->user->id;
                    $model_salary_slip->updated_date_time = date('Y-m-d H:i:s');
                    $model_salary_slip->save();
                    //Salary Slip Details
                    if (isset($_POST['SalarySlipDetails'])) {
                        foreach ($_POST['SalarySlipDetails'] as $i => $item) {
                            $model_slip_exist = SalarySlipDetails::model()->find(array('condition' => 'salary_processing_id ="' . $model_salary_slip->salary_processing_id . '" and salary_slip_id="' . $model_salary_slip->id . '" AND salary_id="' . $item['salary_id'] . '"'));
                            if (!empty($model_slip_exist) && $model_slip_exist->id > 0) {
                                $model_salary_slip_details = SalarySlipDetails::model()->findByPK($model_slip_exist->id);
                                $model_salary_slip_details->salary_amount = $item['salary_amount'];
                                $model_salary_slip_details->updated_by = Yii::app()->user->id;
                                $model_salary_slip_details->updated_date_time = date('Y-m-d H:i:s');
                                $model_salary_slip_details->save();
                            } else {
                                if ($item['salary_amount'] > 0) {
                                    $model_salary_slip_details = new SalarySlipDetails();
                                    $model_salary_slip_details->salary_processing_id = $model_salary_slip->salary_processing_id;
                                    $model_salary_slip_details->salary_slip_id = $model_salary_slip->id;
                                    $model_salary_slip_details->salary_id = $item['salary_id'];
                                    $model_salary_slip_details->salary_name = $item['salary_name'];
                                    $model_salary_slip_details->salary_type = $item['salary_type'];
                                    $model_salary_slip_details->salary_amount = $item['salary_amount'];
                                    $model_salary_slip_details->created_by = Yii::app()->user->id;
                                    $model_salary_slip_details->created_date_time = date('Y-m-d H:i:s');
                                    $model_salary_slip_details->save();
                                }
                            }
                        }
                    }
                    $jsonData['id'] = $model_salary_slip->salary_processing_id;
                    $jsonData['status'] = 'success';
                } else {
                    $jsonData['status'] = 'error';
                }
            } else if ($model_salary_slip_exist->id > 0 && $model_salary_slip_exist->processing->payroll_status == 2) {
                $jsonData['status'] = 'locked';
            } else {
                $jsonData['status'] = 'notexist';
            }
            echo CJSON::encode($jsonData);
        }
    }
    public function actionViewSalary() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        $id = (int)Yii::app()->request->getParam('id');
        $model = SalaryProcessing::model()->findbyPK($id);
        $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $model->id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view_salary', array('model' => $model, 'model_salary_slip' => $model_salary_slip), false, true);
    }
    public function actionGetpayrolldatebybranch() {
        $branch_id = $_POST['branch_id'];
        $model = new SalaryProcessing();
        //Salary already locked
        $model_unlock = SalaryProcessing::model()->find(array('condition' => 'payroll_status="1" and payroll_branch_or_sponsor_id="' . $branch_id . '"'));
        if (empty($model_unlock)) {
            $model_unlock = SalaryProcessing::model()->find(array('condition' => 'payroll_status="1" and payroll_branch_or_sponsor_id="0"'));
        }
        $start_date = '';
        $end_date = '';
        $month = '';
        $salary_unlock = 0;
        $salary_unlock_exist = 0; //Unlock=1,lock=0;
        $unlock_id = 0;
        $salary_lock_exist = 0; //Unlock=1,lock=0;
        $lock_id = 0;
        $id = 0;
        $last_locked_month = "";
        $sif_created = 0;
        $salary_posted = '';
        if (empty($model_unlock)) {
            $model_max_date = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_branch_or_sponsor_id="' . $branch_id . '"'));
            if ($model_max_date->payroll_enddate != '' && $model_max_date->payroll_enddate != '0000-00-00') {
                $model_max_date = SalaryProcessing::model()->find(array('select' => 'payroll_enddate,id,posted', 'condition' => 'payroll_branch_or_sponsor_id="' . $branch_id . '" and payroll_enddate="' . $model_max_date->payroll_enddate . '"'));
            } else if ($model_max_date->payroll_enddate == '') {
                $model_max_date = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_branch_or_sponsor_id="0"'));
                if ($model_max_date->payroll_enddate != '' && $model_max_date->payroll_enddate != '0000-00-00') {
                    $model_max_date = SalaryProcessing::model()->find(array('select' => 'payroll_enddate,id,posted', 'condition' => 'payroll_branch_or_sponsor_id="0" and payroll_enddate="' . $model_max_date->payroll_enddate . '"'));
                }
            }
            $start_date = date('01/m/Y');
            $end_date = date('t/m/Y');
            $month = date("F");
            if ($model_max_date->payroll_enddate != '' && $model_max_date->payroll_enddate != '0000-00-00') {
                $start_date = date('Y-m-d', strtotime('+1 days', strtotime($model_max_date->payroll_enddate)));
                $payrollend_date_11 = $model_max_date->payroll_enddate;
                $model_start_day = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $branch_id . '"'));
                if ($model_start_day->id == '') {
                    $model_start_day = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                }
                if ($model_start_day->payroll_start_day == 1) {
                    $end_date = date("Y-m-t", strtotime($start_date));
                } else {
                    $end_date = date('Y-m-d', strtotime('+1 month', strtotime($payrollend_date_11)));
                }
                $date = strtotime($end_date);
                $end_date = date('d/m/Y', strtotime($end_date));
                //$date = strtotime($start_date);
                $start_date = date("d/m/Y", strtotime($start_date));
                $month = date("F", $date);
                $id = $model_max_date->id;
                $last_locked_month = date('F', strtotime($model_max_date->payroll_enddate));
                $salary_lock_exist = 1;
                $lock_id = $model_max_date->id;
//                $model_salary_slip = MonthlySalarySif::model()->find(array('condition' => 'salary_processing_id="' . $model_max_date->id . '"'));
                $model_pay_rl = SalaryProcessing::model()->findbyPK($model_max_date->id);
                $model_salary_slip= MonthlySalarySifDetails::model()->find(array('condition' => 'start_date="'.$model_pay_rl->payroll_startdate.'" and end_date="'.$model_pay_rl->payroll_enddate.'"'));
                if (!empty($model_salary_slip)) {
                    $sif_created = 1;
                }
                $salary_posted = $model_max_date->posted;
            } else {
                $salary_lock_exist = 0;
                $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $branch_id . '"'));
                if (empty($model_lock_month)) {
                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="0"'));
                }
                $payroll_month = $model_lock_month->payroll_month;
                $payroll_year = $model_lock_month->payroll_year;
                $master_payroll_year = $model_lock_month->payroll_year;
                if ($payroll_month == 12) {
                    $payroll_year+= 1;
                }
                $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $branch_id . '"'));
                if (empty($model_lock_days)) {
                    $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="0"'));
                }
                $payroll_start_day = $model_lock_days->payroll_start_day;
                $next_payroll_month = $payroll_month;
                if ($payroll_start_day > 1) {
                    if ($payroll_month == 12) {
                        $payroll_month = 1;
                    }
                    $next_payroll_month = $payroll_month + 1;
                }
                if ($payroll_start_day == 1) {
                    if ($payroll_month == 12) {
                        $payroll_month = 1;
                    } else {
                        $payroll_month+= 1;
                    }
                    $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                    $start_date = date("d/m/Y", strtotime($start_date));
                    $end_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                    $date = strtotime($end_date);
                    $end_date = date("t/m/Y", strtotime($end_date));
                } else {
                    if ($payroll_start_day > 1 && $master_payroll_year == date('Y') - 1) {
                        if ($payroll_month == 1) {
                            $payroll_month = 12;
                            $payroll_year_1 = date("Y") - 1;
                            $start_date = $payroll_year_1 . '-' . $payroll_month . '-' . $payroll_start_day;
                        } else {
                            $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                        }
                        if ($payroll_month == 12) {
                            $next_payroll_month = 1;
                        } else {
                            $next_payroll_month = $payroll_month + 1;
                        }
                    } else {
                        $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
                    }
                    $start_date = date("d/m/Y", strtotime($start_date));
                    $payroll_end_day = $payroll_start_day - 1;
                    $end_date = $payroll_year . '-' . $next_payroll_month . '-' . $payroll_end_day;
                    $date = strtotime($end_date);
                    $end_date = date("d/m/Y", strtotime($end_date));
                }
                $month = date("F", $date);
            }
            $salary_unlock = 1;
        } else {
            if(!empty($model_unlock)){
                $start_date = date("d/m/Y", strtotime($model_unlock->payroll_startdate));
                $end_date = date("d/m/Y", strtotime($model_unlock->payroll_enddate));
                $month = $model_unlock->payroll_month;
                $id = $model_unlock->id;
                //$payroll_branch_or_sponsor_id = $model_unlock->payroll_branch_or_sponsor_id;
                $last_locked_month = date('F', strtotime($model_unlock->payroll_enddate));
                $unlock_id = $model_unlock->id;
            }
            $salary_unlock_exist = 1;
        }
        $jsonData['start'] = $start_date;
        $jsonData['end'] = $end_date;
        $jsonData['month'] = $month;
        $jsonData['lockid'] = $id;
        $jsonData['lockid_en'] = $this->ciphertext($id, "e");;
        $jsonData['salary_unlock'] = $salary_unlock;
        $jsonData['last_locked'] = $last_locked_month;
        $jsonData['lock_id'] = $lock_id;
        $jsonData['unlock_id'] = $unlock_id;
        $jsonData['salary_lock_exist'] = $salary_lock_exist;
        $jsonData['salary_unlock_exist'] = $salary_unlock_exist;
        $jsonData['sif_created'] = $sif_created;
        $jsonData['salary_posted'] = $salary_posted;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    //added by dikson on 15/8/2018
    public function actionPrintSalarySlip() {
        $id = Yii::app()->request->getParam('id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.salary.pdf.salary_slip', array('id' => $id), true));
        $mPDF1->Output('salaryslip.pdf', 'I');
    }
    public function actionPrintSalarySlipindividual() {
        $id = Yii::app()->request->getParam('id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.salary.pdf.printSalarySlip_list', array('employee_id' => $employee_id, 'id' => $id), true));
        $mPDF1->Output('salaryslip.pdf', 'I');
    }
    //Added by jo
    public function actionHistory() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sallist_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('history');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetsalaryhistory() {
        $model = new SalaryProcessing();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $columns = array(0 => 't.id', 1 => 'branch_sponsor.branch_or_sponsor_name', 2 => 't.payroll_startdate', 3 => 't.payroll_enddate', 4 => 't.payroll_month', 5 => 't.payroll_status', 6 => 't.id');
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $model_user = User::model()->findByPK(Yii::app()->user->id);
        $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
        if ($branch_id == '') {
            $salary_branch_id=array();
            $permitted_branch_id=array();
            if ($model_usergroup->salary_tab_permission != '') {
                $salary_branch_id = explode(',', $model_usergroup->salary_tab_permission);
            }
            if(isset(Yii::app()->user->user_branch) && Yii::app()->user->user_branch!=''){
                $permitted_branch_id = explode(',', Yii::app()->user->user_branch);
            }
            $allowed_branch_id = array_unique(array_merge($salary_branch_id, $permitted_branch_id));
            $branch_id=0;
            if(!empty($allowed_branch_id)){
                $branch_id = implode(',', $allowed_branch_id);
            }
            if (Yii::app()->user->authorised_user == 1) {
                $condition = '1=1';
            } else {
                $condition = 'payroll_branch_or_sponsor_id IN(' . $branch_id . ')';
            }
        } else {
            $condition = 'payroll_branch_or_sponsor_id="' . $branch_id . '"';
        }
        if ($month > 0) {
            $condition.= ' AND MONTH(payroll_enddate)="' . $month . '"';
        }
        if ($year > 0) {
            $condition.= ' AND YEAR(payroll_enddate)="' . $year . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " AND (t.payroll_month LIKE '%" . $searchString . "%' OR branch_sponsor.branch_or_sponsor_name LIKE '%" . $searchString . "%' OR DATE(t.payroll_enddate) LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_sponsor')->count(array('condition' => $condition));
        $model = $model->with('branch_sponsor')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $status = array(1 => 'Unlocked', 2 => 'Locked');
        foreach ($model as $row) {
//            $div = '';
            $salary_edit=$salary_view=$salary_disable=$salary_roll_back=$salary_lock=0;
            $en_id = $this->ciphertext($row['id'], "e");
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_edit']) || Yii::app()->user->authorised_user == 1) {
                if ($row['payroll_status'] == 1) {
                    $salary_edit=1;
//                    $div.= '<a href="?r=hr/salary/salaryeditindex&id=' . $en_id . '" title="Edit Salary Details"><button class="btn btn-primary btn-xs" title="Edit Salary Details" ><i class="fa fa-edit"></i></button></a>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_rollback']) || Yii::app()->user->authorised_user == 1) {
                if ($row['payroll_status'] == 1) {
                    $salary_roll_back=1;
//                    $div.= '<a href="?r=hr/salary/salaryeditindex&id=' . $en_id . '" title="Edit Salary Details"><button class="btn btn-primary btn-xs" title="Edit Salary Details" ><i class="fa fa-edit"></i></button></a>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_lock']) || Yii::app()->user->authorised_user == 1) {
                if ($row['payroll_status'] == 1) {
                    $salary_lock=1;
//                    $div.= '<a href="?r=hr/salary/salaryeditindex&id=' . $en_id . '" title="Edit Salary Details"><button class="btn btn-primary btn-xs" title="Edit Salary Details" ><i class="fa fa-edit"></i></button></a>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_view']) || Yii::app()->user->authorised_user == 1) {
                $salary_view=1;
//                $div.= '<a class="btn btn-primary btn-xs" title="View Salary" onclick="loadPopupModal(\'hr/salary/viewsalarydetails&id=' . $row['id'] . '\',\'SALARY DETAILS\',\'xl\');"><i class="fa fa-eye"></i></a>&nbsp;';
            }
            if ($row['payroll_status'] == 2) {
                if ((isset(Yii::app()->user->haveHrPermissionOn['hr_salary_block_unblock']) || Yii::app()->user->authorised_user == 1 ) && ($row['branch_sponsor']['salary_slip_view_ess'] == "Y")) {
                    $salary_disable=1;
                    /*$view_sal_slip = "'" . $row['show_pay_slip_employee'] . "'";
                    if ($row['show_pay_slip_employee'] == 'Y') {
                        $div .= ' <a href ="javascript:void(0);" title="Disable Salary Slip View" class="btn btn-danger btn-xs" onclick= "DisableSalarySlip(' . $row['id'] . ',' . $view_sal_slip . ');"><i class="fa fa-ban "></i></a>';
                    } else {
                        $div .= ' <a href ="javascript:void(0);" title="Enable Salary Slip View" class="btn btn-success btn-xs"  onclick="DisableSalarySlip(' . $row['id'] . ',' . $view_sal_slip . ');"><i class="fa fa-retweet"></i></a>';
                    }*/
                }
            }
            $rowData[] = array(++$m, $row['branch_sponsor']['branch_or_sponsor_name'], date('d/m/Y', strtotime($row['payroll_startdate'])), date('d/m/Y', strtotime($row['payroll_enddate'])), $row['payroll_month'], $status[$row['payroll_status']], array('id'=>$row['id'],'slip_status'=>$row['show_pay_slip_employee'],'payroll_status'=>$row['payroll_status'],'salary_edit'=>$salary_edit,'salary_view'=>$salary_view,'salary_disable'=>$salary_disable,'en_id'=>$en_id,'salary_roll_back'=>$salary_roll_back,'salary_lock'=>$salary_lock));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    //end
    public function actionViewSalaryDetails() {
        $id = (int)Yii::app()->request->getParam('id');
        $model = SalaryProcessing::model()->findbyPK($id);
        $model_salary_slip = SalarySlip::model()->findAll(array('condition' => 'salary_processing_id="' . $model->id . '"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view_salary_details', array('model' => $model, 'model_salary_slip' => $model_salary_slip), false, true);
    }
    public function actiongetEmployeeName() {
        $id = $_POST['id'];
        if ($id != '') {
            $id = $this->ciphertext($id, "d");
            $jsonData['emp_name'] = CHtml::dropdownlist("slip_employee_id", '', SalarySlip::getEmployee($id), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionNewSalarySlip_old() {
        $en_id = Yii::app()->request->getParam('f1');
        $en_employee_id = Yii::app()->request->getParam('f2');
        $id = $this->ciphertext($en_id, "d");
        $employee_id = $this->ciphertext($en_employee_id, "d");
        $en_emp_signature = Yii::app()->request->getParam('f3');
        $emp_signature = $this->ciphertext($en_emp_signature, "d");
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.new_salary_slip', array('employee_id' => $employee_id, 'id' => $id, 'emp_signature' => $emp_signature), true));
        $mPDF1->Output('salaryslip.pdf', 'I');
    }
    public function actionNewSalarySlip() {
        $en_id = Yii::app()->request->getParam('f1');
        $en_employee_id = Yii::app()->request->getParam('f2');
        $id = $this->ciphertext($en_id, "d");
        $employee_id = $this->ciphertext($en_employee_id, "d");
        $en_emp_signature = Yii::app()->request->getParam('f3');
        $emp_signature = $this->ciphertext($en_emp_signature, "d");
        $model = SalaryProcessing::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if (!empty($model)) {
            $model_user = User::model()->findByPK(Yii::app()->user->id);
            $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '" and FIND_IN_SET("' . $model->payroll_branch_or_sponsor_id . '",salary_tab_permission)'));
            if (Yii::app()->user->authorised_user == 1 || ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_salary_tab'])) && $model_usergroup->id > 0 && (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salslip_menu'])))) {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.new_salary_slip', array('employee_id' => $employee_id, 'id' => $id, 'emp_signature' => $emp_signature), true));
            } else {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views..salary.pdf.error_slip', array(), true));
            }
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.error_slip', array(), true));
        }
        $mPDF1->Output('salaryslip.pdf', 'I');
    }
    public function actionPreviewSalarySlip() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('salary_slip_preview');
    }
    public function actiongetEmployeeDetail() {
        $id = $_POST['id'];
        if ($id > 0) {
            $jsonData['emp_name'] = CHtml::dropdownlist("slip_preview_employee_id", '', SalarySlip::getEmployee($id), array('empty' => 'Select', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionSalaryslipPreview() {
        $en_id = Yii::app()->request->getParam('f1');
        $en_employee_id = Yii::app()->request->getParam('f2');
        $id = $this->ciphertext($en_id, "d");
        $employee_id = $this->ciphertext($en_employee_id, "d");
        $en_emp_signature = Yii::app()->request->getParam('f3');
        $emp_signature = $this->ciphertext($en_emp_signature, "d");
        $model = SalaryProcessing::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if (!empty($model)) {
            $model_user = User::model()->findByPK(Yii::app()->user->id);
            $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '" and FIND_IN_SET("' . $model->payroll_branch_or_sponsor_id . '",salary_tab_permission)'));
            if (Yii::app()->user->authorised_user == 1 || ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_salary_tab'])) && $model_usergroup->id > 0 && (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_salslip_menu'])))) {
                $mPDF1->SetWatermarkText("Preview");
                $mPDF1->showWatermarkText = true;
                $mPDF1->watermarkTextAlpha = 0.1;
                //$mPDF1->SetDisplayMode('fullpage');
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.new_salary_slip_preview', array('employee_id' => $employee_id, 'id' => $id), true));
            } else {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views..salary.pdf.error_slip', array(), true));
            }
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.error_slip', array(), true));
        }
        $mPDF1->Output('salaryslip.pdf', 'I');
    }
    function decimalHours($time) {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1] / 60) + ($hms[2] / 3600));
    }
    function getserviceyear($joining_date, $payroll_start) {
        $date1 = new DateTime($joining_date);
        $date2 = new DateTime($payroll_start);
        $dd = date_diff($date1, $date2);
        $service_yr = $dd->y;
        return $service_yr;
    }
    public function actionMonthlyDeduction() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('monthly_deduction_form');
    }
    public function actionloadunlocksalarylist() {
        $slip_id = Yii::app()->request->getparam('slip_id');
        $en_employee_id = Yii::app()->request->getparam('employee_id');
        $employee_id =$this->ciphertext($en_employee_id,"d");
        $condition = 'salary_processing_id="' . $slip_id . '"';

        if ($employee_id > 0) {
            $condition.= ' AND employee_id="' . $employee_id . '"';
        }
        $model_salary_slip = SalarySlip::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($model_salary_slip as $key => $value) {
            $arr_employee[$value['employeedetail']['employeefullname'] . ' ' . $value['employeedetail']['employeecode']] = $value['employee_id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('salary_unlock_list', array('arr_employee' => $arr_employee, 'slip_id' => $slip_id), false, true);
    }
    public function actionSaveDeductionAmount() {
        if (isset($_POST['SalarySlip'])) {
            $model_hr_general_settings = HrGenerelSettings::model()->find();
            foreach ($_POST['SalarySlip'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model_salary_slip = SalarySlip::model()->findByPK($items['id']);
                    $model_salary_slip->other_deduction = $items['other_deduction'];
                    $model_salary_slip->total_deduction_amount = $items['total_deduction_amount'];
                    $total_salary_amount = $items['total_salary_amount'];
                    $model_salary_slip->total_salary_amount = $items['total_salary_amount'];
                    if ($model_hr_general_settings->consider_threshold_salary == 'Y') {
                        $model_salary_slip->threshold_salary = $model_salary_slip->employeedetail->threshold_salary;
                        $threshold_salary = $model_salary_slip->employeedetail->threshold_salary;
                        if ($total_salary_amount > $threshold_salary) {
                            $sif_bal_salary = $total_salary_amount - $threshold_salary;
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $threshold_salary;
                            $model_salary_slip->sif_untransfer_salary = $sif_bal_salary;
                        } else {
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                            $model_salary_slip->sif_untransfer_salary = 0.00;
                        }
                    } else {
                        $model_salary_slip->threshold_salary = 0.00;
                        $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                        $model_salary_slip->sif_untransfer_salary = 0.00;
                    }
                    $model_salary_slip->updated_by = Yii::app()->user->id;
                    $model_salary_slip->updated_date_time = date('Y-m-d H:i:s');
                    $model_salary_slip->save();
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionsalaryeditindex() {
        $en_id = Yii::app()->request->getParam('id');
        $id = $this->ciphertext($en_id, "d");
        $model = SalaryProcessing::model()->findbyPK($id);
        $this->render('salaryedit_index', array('id' => $id, 'model' => $model));
    }
    public function actionGetMonthlyList() {
        $model = new SalarySlip();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $emp_id = $_POST['emp_id'];
        $columns = array(0 => 't.id', 1 => 'employeedetail.employee_code', 2 => 'employeedetail.first_name', 3 => '', 4 => '', 5 => '', 6 => '', 7 => '');
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.salary_processing_id="' . $id . '" and payroll_status="1"';
        if ($emp_id != '') {
            $emp_id = $this->ciphertext($emp_id, "d");
            $condition.= ' AND employee_id="' . $emp_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.= " AND (employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('processing', 'employeedetail')->count(array('condition' => $condition));
        $model = $model->with('processing', 'employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $en_slip_id = $this->ciphertext($row['id'], "e");
            $edit_salary=$rollback_salary=1;
            $title="Roll Back ".$row['employeedetail']['employeefullname']." Salary";
            $div = '<a href="?r=hr/salary/editemployeesalarydetail&id=' . $en_slip_id . '" title="Edit ' . $row['employeedetail']['employeefullname'] . 'Salary"><button class="btn btn-primary btn-xs" title="Edit Salary Details" ><i class="fa fa-edit"></i></button></a>&nbsp;';
            $div .= ' <a href ="javascript:void(0);" title="'.$title.'" class="btn btn-danger btn-xs" title="Block" onclick="rollbackemployeesalary(' .$row['id']. ')"><i class="fa fa-trash "></i></a>';
            //Net Salary
            $net_salary = 0.00;
            $model_net_salary = SalarySlipDetails::model()->with('salarymaster')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' => 'salary_slip_id="' . $row['id'] . '" and salarymaster.salary_occurence="2" and salarymaster.salary_type="1"'));
            if(!empty($model_net_salary) && $model_net_salary->salary_amount>0){
                $net_salary += $model_net_salary->salary_amount;
            }
            //Additions
            $salary_addition = 0.00;
            $model_salary_addition = SalarySlipDetails::model()->with('salarymaster')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' => 'salary_slip_id="' . $row['id'] . '" and salarymaster.salary_occurence="1" and salarymaster.salary_type="1"'));
            if(!empty($model_salary_addition) && $model_salary_addition->salary_amount>0){
                $salary_addition += $model_salary_addition->salary_amount;
            }
            //DEDUCTION
            $deduction_amt = 0.00;
            $model_salary_deduction = SalarySlipDetails::model()->with('salarymaster')->find(array('select'=>'sum(salary_amount) as salary_amount','condition' => 'salary_slip_id="' . $row['id'] . '" and salarymaster.salary_type="2"'));
            if(!empty($model_salary_deduction) && $model_salary_deduction->salary_amount>0){
                $deduction_amt += $model_salary_deduction->salary_amount;
            }
            $total_addition = $row->overtime_amount + $row->annual_leave_addition + $row->incentive + $row->public_holiday_allowance + $row->night_shift_allowance + $row->other_addition;
            $total_deduction = $row->leave_amount + $row->salary_advance_amount + $row->loan_amount + $row->pension_amount_employee + $row->annual_leave_deduction + $row->before_joining_salary + $row->other_deduction;
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], Yii::app()->numberFormatter->formatCurrency($net_salary, ""), Yii::app()->numberFormatter->formatCurrency($salary_addition + $total_addition, ""), Yii::app()->numberFormatter->formatCurrency($net_salary + $salary_addition + $total_addition, ""), Yii::app()->numberFormatter->formatCurrency($deduction_amt + $total_deduction, ""), Yii::app()->numberFormatter->formatCurrency($row->total_salary_amount, ""), array('id'=>$row->id,'en_slip_id'=>$en_slip_id,'edit_salary'=>$edit_salary,'rollback_salary'=>$rollback_salary));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actioneditemployeesalarydetail() {
        $en_id = Yii::app()->request->getParam('id');
        $id = $this->ciphertext($en_id, "d");
        $model_salary_slip = SalarySlip::model()->findbyPK($id);
        $model_previous = SalarySlip::model()->find(array('select' => 'max(id) as id', 'condition' => 'salary_processing_id="' . $model_salary_slip->salary_processing_id . '" and id<"' . $id . '"'));
        $model_next = SalarySlip::model()->find(array('select' => 'min(id) as id', 'condition' => 'salary_processing_id="' . $model_salary_slip->salary_processing_id . '" and id>"' . $id . '"'));
        $model_salary_slip_details = SalarySlipDetails::model()->findAll(array('condition' => 'salary_slip_id="' . $id . '"'));
        $this->render('edit_employee_salary_detail', array('model_salary_slip' => $model_salary_slip, 'model_salary_slip_details' => $model_salary_slip_details, 'model_previous' => $model_previous, 'model_next' => $model_next));
    }
    //added by DR on 10/11/2022
    public function actionSalaryDetails() {
        $model_module_payroll = HrModules::model()->findByPK(7);
        if ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_component_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('salary_component_index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetComponentList() {
        $model = new HrMonthlySalaryComponent();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $columns = array(0 => 't.id', 1 => 'branch_sponsor.branch_or_sponsor_name', 2 => 't.salary_month', 3 => 't.salary_year', 4 => 't.id');
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $model_user = User::model()->findByPK(Yii::app()->user->id);
        $model_usergroup = MasUserGroup::model()->find(array('condition' => 'id="' . $model_user->user_group_id . '"'));
        if ($branch_id == '') {
            $salary_branch_id=array();
            $permitted_branch_id=array();
            if ($model_usergroup->salary_tab_permission != '') {
                $salary_branch_id = explode(',', $model_usergroup->salary_tab_permission);
            }
            if(isset(Yii::app()->user->user_branch) && Yii::app()->user->user_branch!=''){
                $permitted_branch_id = explode(',', Yii::app()->user->user_branch);
            }
            $allowed_branch_id = array_unique(array_merge($salary_branch_id, $permitted_branch_id)); 
            $branch_id=0;
            if(!empty($allowed_branch_id)){
                $branch_id = implode(',', $allowed_branch_id);
            }
            if (Yii::app()->user->authorised_user == 1) {
                $condition = '1=1';
            } else {
                $condition = 'branch_id IN(' . $branch_id . ')';
            }
        } else {
            $condition = 'branch_id="' . $branch_id . '"';
        }
        if ($month > 0) {
            $condition.= ' AND salary_month="' . $month . '"';
        }
        if ($year > 0) {
            $condition.= ' AND salary_year="' . $year . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " AND (t.salary_month LIKE '%" . $searchString . "%' OR branch_sponsor.branch_or_sponsor_name LIKE '%" . $searchString . "%' OR salary_year LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_sponsor')->count(array('condition' => $condition));
        $model = $model->with('branch_sponsor')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'group' => 'salary_month,salary_year,branch_id', 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $div = '';
             $delete_button=$view_button=$download_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_component_view']) || Yii::app()->user->authorised_user == 1) {
                $view_button =1;
                $div.= '<a class="btn btn-primary btn-xs" title="View Salary Component Details" onclick="loadPopupModal(\'hr/salary/viewsalarycomponentdetails&id=' . $row['id'] . '\',\'View Salary Component List\',\'lg\');"><i class="fa fa-eye"></i></a>&nbsp;';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_component_download']) || Yii::app()->user->authorised_user == 1) {
               $download_button=1;
                $div.= '<a href="?r=hr/salary/downloadsalarycomponentlist&id=' . $row['id'] . '" title="Download" target="_blank"><button class="btn btn-primary btn-xs" title="Download" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }
            $model_salary_already_locked = SalaryProcessing::model()->find(array('condition' => 'payroll_branch_or_sponsor_id="' . $row['branch_id'] . '" AND MONTH(payroll_enddate)="' . $row['salary_month'] . '" AND YEAR(payroll_enddate)="' . $row['salary_year'] . '"'));
            if (empty($model_salary_already_locked)) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_salary_component_delete']) || Yii::app()->user->authorised_user == 1) {
                   $delete_button=1;
                    $div.= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Block" onclick="deletesalarycomponentdetails(' . $row['id'] . ')"><i class="fa fa-trash "></i></a>';
                }
            }
            $month = '-';
            if ($row['salary_month'] > 0) {
                $month=str_pad($row['salary_month'], 2, '0', STR_PAD_LEFT); 
                $month = HrGenerelSettings::getMonthName($month);
            }
            
            $rowData[] = array(++$m, $row['branch_sponsor']['branch_or_sponsor_name'], $month, $row['salary_year'],array('id'=>$row['id'],'delete_button'=>$delete_button,'view_button'=>$view_button,'download_button'=>$download_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionUploadSalaryComponent() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_salary_component', array(), false, true);
    }
    public function actionDownloadFormat() {
        $filename = 'salary_component_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee Code *,Salary Type *,Amount*,Remarks';
        Yii::app()->end();
    }
    public function readEmployeeCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveSalaryComponents() {
        $file_name = Yii::app()->request->getParam('filename');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $branch = Yii::app()->request->getParam('branch');
        $model_salary_already_locked = SalaryProcessing::model()->find(array('condition' => 'payroll_branch_or_sponsor_id="' . $branch . '" AND MONTH(payroll_enddate)="' . $month . '" AND YEAR(payroll_enddate)="' . $year . '"'));
        $model_salary_exist = HrMonthlySalaryComponent::model()->find(array('condition' => 'branch_id="' . $branch . '" AND salary_month="' . $month . '" AND salary_year="' . $year . '"'));
        if (empty($model_salary_already_locked) && empty($model_salary_exist)) {
            $jsonData['status'] = "success";
            $url = Yii::app()->basePath . '/../uploads/monthlysalary/' . $file_name;
            $error_url = Yii::app()->basePath . '/../uploads/monthlysalary/error/' . $file_name;
            $file = fopen($url, "r");
            $data = fgetcsv($file);
            $validate = TRUE;
            $error_list = array();
            $salary_list = $this->readEmployeeCSV("uploads/monthlysalary/" . $file_name);
            $salarytype_code_error = array();
            foreach (array_slice($salary_list, 1) as $i => $data) {
                if (!empty($data[0]) || !empty($data[1])  || !empty($data[2]) || !empty($data[3])) {
                    $model_salary[$i] = new HrMonthlySalaryComponent();
                    $model_salary[$i]->scenario = "excelupload";
                    if (!empty($data[0])) {
                        $employee_code = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"')), "e");
                        $model_employee = Employee::model()->find(array('condition' => 'employee_code="' . $employee_code . '" AND branch_or_sponsor_id="' . $branch . '"'));
                        if (!empty($model_employee) && $model_employee->id > 0) {
                            $model_salary[$i]->employee_id = $model_employee->id;
                        } else {
                            $model_salary[$i]->employee_id = '';
                        }
                    } else {
                        $model_salary[$i]->employee_id = '';
                    }
                    $model_salary[$i]->emp_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                    if (!empty($data[1])) {
                        $condition = '(salary_name="' . trim($data[1]) . '" AND salary_occurence="1" AND isActive ="Y")';
                        $model_salarytype[$i] = MasSalarytype::model()->find(array('select' => 'id', 'condition' => $condition));
                        if(isset($model_salarytype[$i])){
                            $model_salary[$i]->salary_type = $model_salarytype[$i]->id;
                        }
                    } else {
                        $model_salary[$i]->salary_type = 0;
                    }
                    $salarytype_code_error[$i] = trim($data[0]) . '-' . strtoupper(str_replace(' ', '', trim($data[1]))); //For checking Duplicate Component-28/3/2023 by DR
                    $model_salary[$i]->salary_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                    $model_salary[$i]->amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                    $model_salary[$i]->remarks = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"'));
                    $model_salary[$i]->branch_id = $branch;
                    $model_salary[$i]->salary_month = $month;
                    $model_salary[$i]->salary_year = $year;
                    $model_salary[$i]->created_by = Yii::app()->user->id;
                    $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                    $validate = $model_salary[$i]->validate() && $validate;
                }
            }
            function array_not_unique($raw_array) {
                $dupes = array();
                natcasesort($raw_array);
                reset($raw_array);
                $old_key = NULL;
                $old_value = NULL;
                foreach ($raw_array as $key => $value) {
                    if ($value === NULL) {
                        continue;
                    }
                    if($old_value!=NULL){
                        if (strcasecmp($old_value, $value) === 0) {
                            $dupes[$old_key] = $old_value;
                            $dupes[$key] = $value;
                        }
                    }
                    $old_value = $value;
                    $old_key = $key;
                }
                return $dupes;
            }
            //            echo '<pre>';print_r($salarytype_code_error); die();
            $check_duplicate_component = array_not_unique($salarytype_code_error);
            //            echo '<pre>';print_r($check_duplicate_component); die();
            if ($validate && empty($check_duplicate_component)) {
                if (!empty($model_salary)) {
                    foreach ($model_salary as $eachModel) {
                        $eachModel->save();
                    }
                    $jsonData['error'] = "";
                }
            } else {
                if (!empty($model_salary)) {
                    foreach ($model_salary as $s => $data_model) {
                        $error_list[$s]['emp_code'] = $data_model['emp_code'];
                        $error_list[$s]['salary_name'] = $data_model['salary_name'];
                        $error_list[$s]['amount'] = $data_model['amount'];
                        $error_list[$s]['salarycomponentduplicate'] = trim($data_model['emp_code']) . '-' . strtoupper(str_replace(' ', '', trim($data_model['salary_name'])));
                        if ($data_model->validate()) {
                            $error_list[$s]['remarks'] = "correct";
                        } else {
                            $error_list[$s]['remarks'] = $data_model->getErrors();
                        }
                    }
                }
            }
            $j = 0;
            fclose($file);
            $list = array();
            if (!empty($error_list)) {
                $file_error = fopen($error_url, "w+");
                $list[$j++] = 'Employee Code *,Salary Type *,Amount*,Remarks';
                foreach ($error_list as $i => $error_detail) {
                    if (!empty($error_detail)) {
                        if (!empty($error_detail['remarks'])) {
                            $error_view[$i] = '';
                            foreach ($error_detail['remarks'] as $p => $error_value) {
                                $error_view[$i].= $error_value[0] . " / ";
                            }
                        } else {
                            $error_view[$i].= '';
                        }
                        if (in_array($error_detail['salarycomponentduplicate'], $check_duplicate_component)) {
                            $error_view[$i].= " Duplicate Salary Component Exist /";
                        } else {
                            $error_view[$i].= '';
                        }
                        $list[$j++] = $error_detail['emp_code'] . ',' . $error_detail['salary_name'] . ',' . $error_detail['amount'] . ',' . $error_view[$i];
                    }
                }
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                fclose($file_error);
            }
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download log', array('salary/DownloadErrorCsv', 'id' => $file_name), array('target' => '_blank', 'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;' . ''));
        } else {
            $jsonData['status'] = "error";
            if (!empty($model_salary_already_locked)) {
                $jsonData['error'] = 'Salary Calculated already for this month';
            } else if (!empty($model_salary_exist)) {
                $jsonData['error'] = 'Salary Component Details already uploaded.Please delete and try again';
            }
        }
        echo CJSON::encode($jsonData);
    }
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/monthlysalary/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function actiondeletesalarycomponentdetails() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = HrMonthlySalaryComponent::model()->findByPk($id);
            if ($model->id) {
                $branch_id = $model->branch_id;
                $salary_month = $model->salary_month;
                $salary_year = $model->salary_year;
                $model_salary_already_locked = SalaryProcessing::model()->find(array('condition' => 'payroll_branch_or_sponsor_id="' . $branch_id . '" AND MONTH(payroll_enddate)="' . $salary_month . '" AND YEAR(payroll_enddate)="' . $salary_year . '"'));
                if (empty($model_salary_already_locked)) {
                    HrMonthlySalaryComponent::model()->deleteAll(array('condition' => 'branch_id="' . $branch_id . '" AND salary_month="' . $salary_month . '" AND salary_year="' . $salary_year . '"'));
                    $model_salary_exist = HrMonthlySalaryComponent::model()->findAll(array('condition' => 'branch_id="' . $branch_id . '" AND salary_month="' . $salary_month . '" AND salary_year="' . $salary_year . '"'));
                    if (empty($model_salary_exist)) {
                        $jsonData['status'] = 'success';
                    } else {
                        $jsonData['status'] = 'error';
                    }
                } else {
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionViewSalaryComponentdetails() {
        $id = (int)Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = HrMonthlySalaryComponent::model()->findbyPK($id);
            $branch_id = $model->branch_id;
            $salary_month = $model->salary_month;
            $salary_year = $model->salary_year;
            $model_salary_details = HrMonthlySalaryComponent::model()->findAll(array('condition' => 'branch_id="' . $branch_id . '" AND salary_month="' . $salary_month . '" AND salary_year="' . $salary_year . '"'));
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->renderPartial('view_salary_componentdetails', array('model' => $model, 'model_salary_details' => $model_salary_details), false, true);
        } else {
            throw new CHttpException(404, 'Page not found.');
        }
    }
    public function actiondownloadsalarycomponentlist() {
        $id = (int)Yii::app()->request->getParam('id');
        $model = HrMonthlySalaryComponent::model()->findbyPK($id);
        $branch_id = $model->branch_id;
        $salary_month = $model->salary_month;
        $salary_year = $model->salary_year;
        $model_salary_details = HrMonthlySalaryComponent::model()->findAll(array('condition' => 'branch_id="' . $branch_id . '" AND salary_month="' . $salary_month . '" AND salary_year="' . $salary_year . '"'));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', 'EMPLOYEE CODE')->setCellValue('B1', 'EMPLOYEE NAME')->setCellValue('C1', 'SALARY TYPE')->setCellValue('D1', 'AMOUNT');
        $objPHPExcel->getActiveSheet()->getStyle('A1:D1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle("A1:D1")->getFont()->setSize(12)->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('D')->getNumberFormat()->setFormatCode('0.00');
        $rowCount = 2;
        $start = $rowCount;
        $end = 0;
        $total_salary = 0.00;
        foreach ($model_salary_details as $j => $details) {
            $total_salary+= $details->amount;
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $details->employeedetail->employeecode);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $details->employeedetail->employeefullname);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $details->salarytype->salary_name);
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, Yii::app()->numberFormatter->formatCurrency($details->amount, " "));
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
            $end = $rowCount;
            $rowCount++;
        }
        $objPHPExcel->getActiveSheet()->getStyle('A' . $start . ':A' . $end . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('B' . $start . ':B' . $end . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
        $objPHPExcel->getActiveSheet()->getStyle('C' . $start . ':C' . $end . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('D' . $start . ':D' . $end . '')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('A' . $start . ':L' . $end . '')->getFont()->setSize(11);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('SALARY COMPONENT LIST');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="SALARY COMPONENT LIST.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionViewSalarySlip() {
        $en_id = Yii::app()->request->getParam('_id');
        $sal_id = $this->ciphertext($en_id, "d");
        $model_slip_details = SalarySlip::model()->findbyPK($sal_id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if (!empty($model_slip_details)) {
            $id = $model_slip_details->salary_processing_id;
            $employee_id = $model_slip_details->employee_id;
            //Password for Opening file
            if ($model_slip_details->employeedetail->date_of_birth != '' && $model_slip_details->employeedetail->date_of_birth != '0000-00-00') {
                $company_id = Yii::app()->user->master_user_company_id;
                $model_company = MasCompany::getMasCompanyDetails($company_id); //uSERNAME
                //pASSWORD
                $emp_name = trim(substr($model_slip_details->employeedetail->employeefullname, 0, 4));
                $emp_name.= date('d', strtotime($model_slip_details->employeedetail->date_of_birth));
                $emp_name.= date('m', strtotime($model_slip_details->employeedetail->date_of_birth));
                $mPDF1->SetProtection(array('print'), $model_company->company_name, $emp_name);
            }
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.new_salary_slip', array('employee_id' => $employee_id, 'id' => $id, 'emp_signature' => $emp_signature), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.salary.pdf.error_slip', array(), true));
        }
        $mPDF1->Output('salaryslip.pdf', 'I');
    }


    public function actionChecker() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_sallist_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('checker');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

//code added by abin on 12-09-2023 to get the checker tab contents
public function actionLoadCheckerTabContent() {
        $salary_branch_id = $_POST['salary_branch_id'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('checker_tab_contents', array('from_date' => $from_date, 'salary_branch_id' => $salary_branch_id, 'to_date' => $to_date));
    }

      public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new SalaryProcessing();
        $model = $model->findByPk($id);
        $model->show_pay_slip_employee = ($status == "Y" ) ? "N" : "Y";
        $model->save(false);
         echo json_encode(array("status" => "success"));
    }
    public function actionRollbackEmployeeSalary() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = SalarySlip::model()->findByPk($id);
        if (!empty($model)) {
            $salary_processing_id=$model->salary_processing_id;
            $count = SalarySlip::model()->count(array('condition' => 'salary_processing_id="' . $salary_processing_id . '"'));
            if($count>1){
                SalarySlipDetails::model()->deleteAll(array('condition' => 'salary_slip_id="'.$id. '"'));
                EmployeePension::model()->deleteAll(array('condition' => 'salary_slip_id="'.$id.'"'));
                MonthlyGratuity::model()->deleteAll(array('condition' => 'salary_slip_id="' .$id. '"'));
                SalarySlip::model()->deletebyPK($id);
            }else{
                SalarySlipDetails::model()->deleteAll(array('condition' => 'salary_slip_id="'.$id. '"'));
                EmployeePension::model()->deleteAll(array('condition' => 'salary_slip_id="'.$id.'"'));
                MonthlyGratuity::model()->deleteAll(array('condition' => 'salary_slip_id="' .$id. '"'));
                SalarySlip::model()->deletebyPK($id);
                SalaryProcessing::model()->deletebyPK($salary_processing_id);
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {
            $jsonData['status'] = 'error';
            echo CJSON::encode($jsonData);
        }
    }
    
    public function actionpendingSalary() {
        $id = (int)Yii::app()->request->getParam('id');
        $model_salary_processing = SalaryProcessing::model()->findByPK($id);
        $condition = 'E.isActive="Y"  AND E.date_join<="' . $model_salary_processing->payroll_enddate . '"  AND E.branch_or_sponsor_id="' . $model_salary_processing->payroll_branch_or_sponsor_id . '"';
        $SQL = " SELECT * FROM  `erp_hr_employee` E WHERE $condition && id 
                   NOT IN (SELECT  employee_id FROM  erp_hr_salary_slip S WHERE E.id=S.employee_id AND salary_processing_id ='".$id."')";
        $model = Yii::app()->db->createCommand($SQL)->queryAll();        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('pending_salary', array('model' => $model, 'id' => $id,'model_salary_processing'=>$model_salary_processing), false, true);
    }
    public function actioncalculatependingsalary() {
        $branch = (int)Yii::app()->request->getParam('branch');
        $id = (int)Yii::app()->request->getParam('salary_process_id');
        $payroll_startdate = $_POST['SalaryProcessing'] ['payroll_startdate'];
        $payroll_enddate = $_POST['SalaryProcessing'] ['payroll_enddate'];
        $month_name = date('F', strtotime($payroll_enddate));
        $calculated_month = date('m', strtotime($payroll_enddate));
        $calculated_year = date('Y', strtotime($payroll_enddate));
        //Days
        $start_date = strtotime($payroll_startdate);
        $end_date = strtotime($payroll_enddate);
        $datediff = $end_date - $start_date;
        $diff_days = $datediff / (60 * 60 * 24);
        $model_hr_general_settings = HrGenerelSettings::model()->find();
        
        $valid = true;
        foreach ($_POST['SalarySlip'] as $i => $items) {
            if (isset($_POST['arraycid']) && is_array($_POST['arraycid'])) {
                if (in_array($items['employee_id'], $_POST['arraycid'])) {
            //Total Days Working
            $date_con_1 = strtotime($payroll_startdate);
            $date_con_2 = strtotime($payroll_enddate);
            $total_working_day = $date_con_2 - $date_con_1;
            $total_working_days = floor($total_working_day / (60 * 60 * 24)) + 1;
                $each_employee = Employee::model()->findbyPK($items['employee_id']);
                //Loan Amount
                $loan_amount = 0.00;
                $total_loan_amount = 0.00;
                $monthly_payment = 0.00;
                $total_loan_paid = 0.00;
                $loan_pending = 0.00;
                $model_loan = EmployeeLoanDetail::model()->findAll(array('condition' => '(loan_status="14" OR loan_status="15")  and isActive="Y" and repayment_start_date<="' . $payroll_enddate . '" AND employee_id=' . $each_employee->id));
                if (!empty($model_loan)) {
                    foreach ($model_loan as $key_1 => $loan_detail) {
                        $monthly_payment = $loan_detail->loan_monthly_payment; //Monthly Payment
                        $total_loan_amount = $loan_detail->loan_amount; //Total Loan Amount
                        $total_loan_paid = $loan_detail->loan_repayment; //Total loan paid
                        $loan_pending = $total_loan_amount - $total_loan_paid;
                        if ($loan_pending < $monthly_payment) {
                            $loan_amount+= $loan_pending;
                        } else {
                            $loan_amount+= $monthly_payment;
                        }
                    }
                }
                //End loan amount Calculation
                //Salary Advance Amount
                $salary_advance_deduction = 0.00;
                $model_salary_advance = EmployeeSalaryAdvance::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $each_employee->id . '" and approved_date<="' . $payroll_enddate . '" and (advance_payment_status="14" OR advance_payment_status="15")'));
                if ($model_salary_advance->amount != '') {
                    $salary_advance_deduction = $model_salary_advance->amount;
                }
                //End Salary Advance Amount
                //Start Employee Salary
                $joining_date = $each_employee->date_join;
                $employee_salary = 0.00;
                $arr_salary_detail = array();
                $late_joining_employee_salary = 0.00;
                $emp_sal_deduction = 0.00;
                $f_key = 0;
                $model_salary_details = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'salary.salary_occurence="2" AND employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                foreach ($model_salary_details as $key => $salarydetail) {
                    $sal_value = 0.00;
                    $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                    $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salary->salary_name;
                    $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salary->salary_type;
                    $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                    $employee_salary+= $salarydetail->amount;
                    if (strtotime($joining_date) > strtotime($payroll_startdate)) {
                        $salary_start_date = strtotime($payroll_enddate);
                        $joining_date_1 = strtotime($joining_date);
                        $datediff = $salary_start_date - $joining_date_1;
                        $diff_day = $datediff / (60 * 60 * 24) + 1;
                        //$salary_emp_per_day=round($salarydetail->amount/30, 2);
                        //$sal_value=round($salary_emp_per_day*$diff_day, 2);
                        $salary_emp_per_day = number_format($salarydetail->amount / $total_working_days, 2, '.', ''); //number_format($sal_value, $z)
                        $sal_value = round($salary_emp_per_day * $diff_day, 2);
                        $late_joining_employee_salary+= $sal_value;
                        //$arr_salary_detail[$key]['salary_amount'] =$sal_value;
                        
                    }
                    $f_key++;
                }
                $model_salary_details_single = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'salary.salary_occurence="1" AND employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                if (!empty($model_salary_details_single)) {
                    foreach ($model_salary_details_single as $key => $salarydetail) {
                        $sal_value = 0.00;
                        $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                        $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salary->salary_name;
                        $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salary->salary_type;
                        $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                        $employee_salary+= $salarydetail->amount;
                        if (strtotime($joining_date) > strtotime($payroll_startdate)) {
                            $salary_start_date = strtotime($payroll_enddate);
                            $joining_date_1 = strtotime($joining_date);
                            $datediff = $salary_start_date - $joining_date_1;
                            $diff_day = $datediff / (60 * 60 * 24) + 1;
                            //$salary_emp_per_day=round($salarydetail->amount/30, 2);
                            //$sal_value=round($salary_emp_per_day*$diff_day, 2);
                            $salary_emp_per_day = number_format($salarydetail->amount / $total_working_days, 2, '.', ''); //number_format($sal_value, $z)
                            $sal_value = round($salary_emp_per_day * $diff_day, 2);
                            $late_joining_employee_salary+= $sal_value;
                            //$arr_salary_detail[$key]['salary_amount'] =$sal_value;
                            
                        }
                        $f_key++;
                    }
                }
                //Adding Data from Table-Additions
                $uploaded_salary_additions = 0.00;
                $model_salary_uploaded_additions = HrMonthlySalaryComponent::model()->with('salarytype')->findAll(array('condition' => 'salarytype.salary_type="1" AND salarytype.salary_occurence="1" AND employee_id="' . $each_employee->id . '" AND salary_month="' . $calculated_month . '" AND salary_year="' . $calculated_year . '"'));
                if (!empty($model_salary_uploaded_additions)) {
                    foreach ($model_salary_uploaded_additions as $key => $salarydetail) {
                        $sal_value = 0.00;
                        $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                        $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salarytype->salary_name;
                        $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salarytype->salary_type;
                        $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                        $uploaded_salary_additions+= $salarydetail->amount;
                        $f_key++;
                    }
                }
                //Adding Data from Table-Deductions
                $uploaded_salary_deductions = 0.00;
                $model_salary_uploaded_deductions = HrMonthlySalaryComponent::model()->with('salarytype')->findAll(array('condition' => 'salarytype.salary_type="2" AND salarytype.salary_occurence="1" AND employee_id="' . $each_employee->id . '" AND salary_month="' . $calculated_month . '" AND salary_year="' . $calculated_year . '"'));
                if (!empty($model_salary_uploaded_deductions)) {
                    foreach ($model_salary_uploaded_deductions as $key => $salarydetail) {
                        $sal_value = 0.00;
                        $arr_salary_detail[$f_key]['salary_id'] = $salarydetail->salary_type;
                        $arr_salary_detail[$f_key]['salary_name'] = $salarydetail->salarytype->salary_name;
                        $arr_salary_detail[$f_key]['salary_type'] = $salarydetail->salarytype->salary_type;
                        $arr_salary_detail[$f_key]['salary_amount'] = $salarydetail->amount;
                        $uploaded_salary_deductions+= $salarydetail->amount;
                        $f_key++;
                    }
                }
                //End Employee Salary
                //Pension Calculation
                $pension_salary = 0.00;
                $employee_percent_amt = 0.00;
                $company_percent_amt = 0.00;
                $total_pension_amount = 0.00;
                if ($each_employee->have_pension == 1 && $each_employee->employee_pension_scheme>0) {
                    $model_master_pension = MasPension::model()->findbyPk($each_employee->employee_pension_scheme);
                    if (!empty($model_master_pension)) {
                        $salary_type = explode(',', $model_master_pension->salary_type);
                        if (count($salary_type) > 1) {
                            foreach ($salary_type as $value_1) {
                                $model_pension_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                                $pension_salary+= $model_pension_salary->amount;
                            }
                        } else {
                            $model_pension_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $model_pension_salary->salary_type . '" AND isActive="Y"'));
                            $pension_salary = $model_pension_salary->amount;
                        }
                        $employee_percent_amt = (($pension_salary * $model_master_pension->employee_percent) / 100);
                        $company_percent_amt = (($pension_salary * $model_master_pension->company_percent) / 100);
                        $total_pension_amount = $employee_percent_amt + $company_percent_amt;
                    }
                }
                //End Pension Calculation
                //Gratuity Calculation
                $gratuity_days = 0;
                $gratuity_salary = 0.00;
                $gratuity_amount_year = 0.00;
                $gratuity_salary_per_day = 0.00;
                $total_gratuity = 0.00;
                $gratuity_per_day = 0.00;
                $gratuity_gross_amount = 0.00;
                if ($each_employee->probation_date != '' && $each_employee->probation_date != '0000-00-00') {
                    $date1 = new DateTime($each_employee->probation_date);
                    $date2 = new DateTime($payroll_enddate);
                    $gratuity_days = $date2->diff($date1)->format("%a");
                    $model_gratuity = MasGratuity::model()->find(array('condition' => 'days_from<="' . $gratuity_days . '" AND days_to>="' . $gratuity_days . '"'));
                    if (!empty($model_gratuity)) {
                        $salary_type = explode(',', $model_gratuity->salary_type);
                        if (count($salary_type) > 1) {
                            foreach ($salary_type as $value_1) {
                                $model_gratuity_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                                $gratuity_salary+= $model_gratuity_salary->amount;
                            }
                        } else {
                            $model_gratuity_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $model_gratuity->salary_type . '" AND isActive="Y"'));
                            if(!empty($model_gratuity_salary)){
                                $gratuity_salary = $model_gratuity_salary->amount;
                            }
                        }
                        $gratuity_amount_year = $gratuity_salary * 12;
                        $gratuity_salary_per_day = ($gratuity_amount_year / 365);
                        $total_gratuity = $gratuity_days * $gratuity_salary_per_day;
                        $gratuity_per_day = ($total_gratuity / 365);
                        $gratuity_gross_amount = round($gratuity_per_day * $diff_days, 2);
                    }
                }
                //End Gratuity Calculation
                $month = (int)date("m", strtotime($payroll_enddate));
                $year = (int)date("Y", strtotime($payroll_enddate));
                //$days=cal_days_in_month(CAL_GREGORIAN,$month,$year); //Total days in a month
                $days = $total_working_days;
                //$employee_per_day_salary = round($employee_salary / $days, 2); //Employee Per day salary
                $employee_per_day_salary = round(($employee_salary * 12 / 365), 2); //Employee Per day salary
                //Leave Amount Calculation
                $leave_count = 0;
                $half_salary_leave_count = 0;
                /*
                $model_master_leave = MasLeave::model()->findAll(array('condition' => 'salary_deduction="Y"'));
                foreach ($model_master_leave as $key => $value) {
                $model_leave_attendance = EmployeeAttendance::model()->with('leave')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leave.leave_type="' . $value->id . '"'));
                $leave_count+=$model_leave_attendance->id;
                }
                */
                $model_full_deduction_leave = EmployeeSalaryDeductionLeave::model()->with('leavedetail')->find(array('select' => 'count(t.id) as id', 'condition' => 'leavedetail.leave_status="12" and t.employee_id=' . $each_employee->id . ' AND leave_date>="' . $payroll_startdate . '" AND leave_date<="' . $payroll_enddate . '" AND salary_deduction_type="Y"'));
                if (!empty($model_full_deduction_leave) && $model_full_deduction_leave->id > 0) {
                    $leave_count+= $model_full_deduction_leave->id;
                }
                $model_half_deduction_leave = EmployeeSalaryDeductionLeave::model()->with('leavedetail')->find(array('select' => 'count(t.id) as id', 'condition' => 'leavedetail.leave_status="12" and t.employee_id=' . $each_employee->id . ' AND leave_date>="' . $payroll_startdate . '" AND leave_date<="' . $payroll_enddate . '" AND salary_deduction_type="H"'));
                if (!empty($model_half_deduction_leave) && $model_half_deduction_leave->id > 0) {
                    $half_salary_leave_count+= $model_half_deduction_leave->id;
                }
                //End leave calculation
                //Half Salary Leave
                /*$model_master_leave_detail = MasLeave::model()->findAll(array('condition' => 'salary_deduction="H"'));
                foreach ($model_master_leave_detail as $key => $value) {
                $model_half_leave_attendance = EmployeeAttendance::model()->with('leave')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leave.leave_type="' . $value->id . '"'));
                $half_salary_leave_count+=$model_half_leave_attendance->id;
                }*/
                //End Half Salary Leave
                //Absent Salary Deduction
                $model_absent = EmployeeAttendance::model()->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="2"'));
                if ($model_absent->id > 0) {
                    $leave_count+= $model_absent->id;
                }
                //End Absent calculation
                //Annual Leave Amount-Start
                $annual_leave_amount = 0.00;
                $model_annual_leave_attendance = EmployeeAttendance::model()->with('leave.leavetype')->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="3" AND leavetype.is_annual_leave="Y"'));
                if (!empty($model_annual_leave_attendance) && $model_annual_leave_attendance->id > 0) {
                    $leave_deduction_sal = 0.00;
                    $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    $leave_deduction_sal+= $model_leavededuction_salary->amount;
                    $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                    //                $leave_per_day_sal=round($leave_deduction_sal / $days, 2);
                    $leave_per_day_sal = round(($leave_deduction_sal * 12 / 365), 2);
                    $annual_leave_amount = round($leave_per_day_sal * $model_annual_leave_attendance->id, 2);
                }
                //Annual Leave Amount-End
                //Salary Deduction for leave
                $leave_deduction_amount = 0.00;
                if ($leave_count > 0) {
                    $leave_deduction_sal = 0.00;
                    //Recurring
                    $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                     if(!empty($model_leavededuction_salary) && $model_leavededuction_salary->amount >0){
                        $leave_deduction_sal+= $model_leavededuction_salary->amount;
                    }
                    $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    if(!empty($model_leavededuction_salary_single) && $model_leavededuction_salary_single->amount >0){
                            $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                    }
                    //                $leave_per_day_sal=round($leave_deduction_sal / $days, 2);
                    $leave_per_day_sal = round(($leave_deduction_sal * 12 / 365), 2);
                    $leave_deduction_amount+= round($leave_per_day_sal * $leave_count, 2);
                }
                $half_sal_amnt = 0.00;
                if ($half_salary_leave_count > 0) {
                    $leave_deduction_sal = 0.00;
                    $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                     if(!empty($model_leavededuction_salary) && $model_leavededuction_salary->amount >0){
                    $leave_deduction_sal+= $model_leavededuction_salary->amount;
                    }
                    $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                    if(!empty($model_leavededuction_salary_single) && $model_leavededuction_salary_single->amount >0){
                    $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                }
                    //                $leave_per_day_sal=round($leave_deduction_sal / $days, 2);
                    $leave_per_day_sal = round(($leave_deduction_sal * 12 / 365), 2);
                    $half_sal_amnt = ($leave_per_day_sal * $half_salary_leave_count) / 2;
                    $leave_deduction_amount+= round($half_sal_amnt, 2);
                }
                //Overtime Calculation
                $overtime_work = "00:00:00";
                $overtime_amount = 0.00;
                $ofc_overtime_work = "00:00:00";
                $ofc_overtime_amount = 0.00;
                $onsite_overtime_work = "00:00:00";
                $onsite_overtime_amount = 0.00;
                $night_shift_overime_time_detail = "00:00:00";
                $normal_overime_time_detail = "00:00:00";
                $holiday_overime_time_detail = "00:00:00";
                $weekend_overime_time_detail = "00:00:00";
                //            $overtime_start_date= date('Y-m-d', strtotime('-1 month', strtotime($payroll_startdate)));
                //            $overtime_end_date=date('Y-m-d', strtotime('-1 month', strtotime($payroll_enddate)));
                $overtime_start_date = $payroll_startdate;
                $overtime_end_date = $payroll_enddate;
                $normal_ot_amount = $night_ot_amount = $holiday_ot_amount = $weekend_ot_amount = 0.00;
                if ($each_employee->overtime == "Y") {
                    //Night Shift overtime
                    $night_wrk_days = $total_working_days;
                    if ($each_employee->departmentdetail->night_ot_days > 0) {
                        $night_wrk_days = $each_employee->departmentdetail->night_ot_days;
                    }
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`night_shift_overtime`))) As night_shift_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    // $overtime_work = $model_attendance->normal_overtime;
                    if ($model_attendance->night_shift_overtime != "00:00:00") {
                        $night_shift_overime_time_detail = $model_attendance->night_shift_overtime;
                        $night_shift_overtime = explode(':', $model_attendance->night_shift_overtime);
                        $n_overtime = $night_shift_overtime[0];
                        //Overtime Salary
                        $model_master_night_shift = MasOverTime::model()->findByPk(4);
                        $night_shift_overtime_salary = 0.00;
                        $each_night_shift_ot = explode(',', $model_master_night_shift->salary);
                        foreach ($each_night_shift_ot as $value_1) {
                            $model_night_shift_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $night_shift_overtime_salary+= $model_night_shift_salary->amount;
                        }
                        $night_shift_ot_salary_per_day = round($night_shift_overtime_salary / $night_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            //$working_time=date("H:i",strtotime($model_company_shift->branch_working_hours));
                            // $working_hours_second = strtotime($working_time); //In second
                            //$working_time = explode(':', $model_company_shift->branch_working_hours);
                            //$working_hours_second=$working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        //echo $normal_ot_salary_per_day;
                        // gmdate('H:i', $working_hours_second);
                        $salary_per_second_night_shift = $night_shift_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_night_shift * 3600;
                        //Overtimesalary
                        $salary_overtime_night_shift = $salary_per_hour_normal * $model_master_night_shift->times;
                        $night_shift_salary_per_min = ($salary_overtime_night_shift / 60);
                        $overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_night_shift, 2);
                        $overtime_amount+= round((float)$night_shift_overtime[1] * (float)$night_shift_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_night_shift, 2);
                        $ofc_overtime_amount+= round((float)$night_shift_overtime[1] * (float)$night_shift_salary_per_min, 2);
                        $night_ot_amount+= round((float)$n_overtime * (float)$salary_overtime_night_shift, 2);
                        $night_ot_amount+= round((float)$night_shift_overtime[1] * (float)$night_shift_salary_per_min, 2);
                    }
                    //End Night Shift Overtime
                    //Normal overtime
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    // $overtime_work = $model_attendance->normal_overtime;
                    if ($model_attendance->normal_overtime != "00:00:00") {
                        $norm_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->normal_ot_days > 0) {
                            $norm_wrk_days = $each_employee->departmentdetail->normal_ot_days;
                        }
                        $normal_overime_time_detail = $model_attendance->normal_overtime;
                        $normal_overtime = explode(':', $model_attendance->normal_overtime);
                        $n_overtime = $normal_overtime[0];
                        //Overtime Salary
                        $model_master_normal = MasOverTime::model()->findByPk(1);
                        $normal_overtime_salary = 0.00;
                        $each_normal_ot = explode(',', $model_master_normal->salary);
                        foreach ($each_normal_ot as $value_1) {
                            $model_normalovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $normal_overtime_salary+= $model_normalovertime_salary->amount;
                        }
                        $normal_ot_salary_per_day = round($normal_overtime_salary / $norm_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        //echo $normal_ot_salary_per_day;
                        // gmdate('H:i', $working_hours_second);
                        $salary_per_second_normal = $normal_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_normal * 3600;
                        //Overtimesalary
                        $salary_overtime_normal = $salary_per_hour_normal * $model_master_normal->times;
                        $normal_salary_per_min = ($salary_overtime_normal / 60);
                        $overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_normal, 2);
                        $overtime_amount+= round((float)$normal_overtime[1] * (float)$normal_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$n_overtime * (float)$salary_overtime_normal, 2);
                        $ofc_overtime_amount+= round((float)$normal_overtime[1] * (float)$normal_salary_per_min, 2);
                        $normal_ot_amount+= round((float)$n_overtime * (float)$salary_overtime_normal, 2);
                        $normal_ot_amount+= round((float)$normal_overtime[1] * (float)$normal_salary_per_min, 2);
                    }
                    //End Normal Overtime
                    //Start Holiday Overtime
                    $model_attendance = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`holiday_overtime`))) As holiday_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    //$overtime_work = $model_attendance->holiday_overtime;
                    if ($model_attendance->holiday_overtime != "00:00:00") {
                        $hol_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->holiday_ot_days > 0) {
                            $hol_wrk_days = $each_employee->departmentdetail->holiday_ot_days;
                        }
                        $holiday_overime_time_detail = $model_attendance->holiday_overtime;
                        $holiday_overtime = explode(':', $model_attendance->holiday_overtime);
                        $h_overtime = $holiday_overtime[0];
                        //Overtime Salary
                        $holiday_overtime_salary = 0.00;
                        $model_master_holiday = MasOverTime::model()->findByPk(2);
                        $each_holiday_ot = explode(',', $model_master_holiday->salary);
                        foreach ($each_holiday_ot as $value_1) {
                            $model_holidayovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $holiday_overtime_salary+= $model_holidayovertime_salary->amount;
                        }
                        $holiday_ot_salary_per_day = $holiday_overtime_salary / $hol_wrk_days; //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_holiday = $holiday_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_holiday = $salary_per_second_holiday * 3600;
                        //Overtimesalary
                        $salary_overtime_holiday = $salary_per_hour_holiday * $model_master_holiday->times;
                        $holiday_salary_per_min = ($salary_overtime_holiday / 60);
                        $overtime_amount+= round((float)$h_overtime * (float)$salary_overtime_holiday, 2);
                        $overtime_amount+= round((float)$holiday_overtime[1] * (float)$holiday_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$h_overtime * (float)$salary_overtime_holiday, 2);
                        $ofc_overtime_amount+= round((float)$holiday_overtime[1] * (float)$holiday_salary_per_min, 2);
                        $holiday_ot_amount+= round((float)$h_overtime * (float)$salary_overtime_holiday, 2);
                        $holiday_ot_amount+= round((float)$holiday_overtime[1] * (float)$holiday_salary_per_min, 2);
                    }
                    //End Holiday Overtime
                    //Weekend Overtime
                    $model_attendance_weekend = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`weekend_overtime`))) As weekend_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                    if ($model_attendance_weekend->weekend_overtime != "00:00:00") {
                        $wkd_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->weekend_ot_days > 0) {
                            $wkd_wrk_days = $each_employee->departmentdetail->weekend_ot_days;
                        }
                        $weekend_overime_time_detail = $model_attendance_weekend->weekend_overtime;
                        $weekend_overtime = explode(':', $model_attendance_weekend->weekend_overtime);
                        $w_overtime = $weekend_overtime[0];
                        //Overtime Salary
                        $model_master_weekend = MasOverTime::model()->findByPk(3);
                        $each_weekend_ot = explode(',', $model_master_weekend->salary);
                        $weekend_overtime_salary = 0.00;
                        foreach ($each_weekend_ot as $value_1) {
                            $model_weekendovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $weekend_overtime_salary+= $model_weekendovertime_salary->amount;
                        }
                        $weekend_ot_salary_per_day = $weekend_overtime_salary / $wkd_wrk_days; //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_weekend = $weekend_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_weekend = $salary_per_second_weekend * 3600;
                        //Overtimesalary
                        $salary_overtime_weekend = $salary_per_hour_weekend * $model_master_weekend->times;
                        $weekend_salary_per_min = ($salary_overtime_weekend / 60);
                        $overtime_amount+= round((float)$w_overtime * (float)$salary_overtime_weekend, 2);
                        $overtime_amount+= round((float)$weekend_overtime[1] * (float)$weekend_salary_per_min, 2);
                        $ofc_overtime_amount+= round((float)$w_overtime * (float)$salary_overtime_weekend, 2);
                        $ofc_overtime_amount+= round((float)$weekend_overtime[1] * (float)$weekend_salary_per_min, 2);
                        $weekend_ot_amount+= round((float)$w_overtime * (float)$salary_overtime_weekend, 2);
                        $weekend_ot_amount+= round((float)$weekend_overtime[1] * (float)$weekend_salary_per_min, 2);
                    }
                    //End weekend overtime
                    /*
                    //Onsite Normal Overtime Calculation-Start
                    $model_site_overtime =OrderManhours::model()->findAll(array('condition' =>'overtime_type="N" AND overtime_hrs!="00:00:00" AND employee_id="' . $each_employee->id . '" AND work_date>="' . $payroll_startdate . '" AND work_date<="' . $payroll_enddate . '"'));
                    if(!empty($model_site_overtime)){
                    $site_DA=0.00;
                    $site_normal_ot_amt=0.00;
                    foreach ($model_site_overtime as $s_1 => $site_overtime) {
                        $normal_time=$this->decimalHours($site_overtime->overtime_hrs);
                        $site_ot_per_hour=$site_overtime->ot_per_hour;
                        $site_DA+=$site_overtime->da_per_day;
                        $site_normal_ot_amt+=$normal_time*$site_ot_per_hour;
                    }
                    $overtime_amount+= round($site_DA, 2);
                    $overtime_amount+= round($site_normal_ot_amt, 2);
                    $onsite_overtime_amount+=round($site_DA, 2);
                    $onsite_overtime_amount+= round($site_normal_ot_amt, 2);
                    }
                    //Onsite Normal Overtime Calculation-End
                    //Onsite Holiday Overtime Calculation-Start
                    $model_site_hldy_overtime =OrderManhours::model()->findAll(array('condition' =>'overtime_type="H" AND overtime_hrs!="00:00:00" AND employee_id="' . $each_employee->id . '" AND work_date>="' . $payroll_startdate . '" AND work_date<="' . $payroll_enddate . '"'));
                    if(!empty($model_site_hldy_overtime)){
                    $site_DA=0.00;
                    $site_hld_ot_amt=0.00;
                    foreach ($model_site_hldy_overtime as $s_1 => $site_overtime) {
                        $hld_time=$this->decimalHours($site_overtime->overtime_hrs);
                        $site_ot_per_hour=$site_overtime->ot_per_hour;
                        $site_DA+=$site_overtime->da_per_day;
                        $site_hld_ot_amt+=$hld_time*$site_ot_per_hour;
                    }
                    $overtime_amount+= round($site_DA, 2);
                    $overtime_amount+= round($site_hld_ot_amt, 2);
                    $onsite_overtime_amount+=round($site_DA, 2);
                    $onsite_overtime_amount+= round($site_hld_ot_amt, 2);
                    }
                    */
                    //Onsite Holiday Overtime Calculation-End
                    
                }
                //Onsite Overtime Calculation
                $model_onsite_overtime = EmployeeAttendance::model()->find(array('select' => 'sum(daily_allowance) as daily_allowance,sum(total_overtime_amount) as total_overtime_amount', 'condition' => 'total_amount>0 AND employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                if ($model_onsite_overtime->total_overtime_amount > 0) {
                    $overtime_amount+= round($model_onsite_overtime->total_overtime_amount, 2);
                    $onsite_overtime_amount+= round($model_onsite_overtime->total_overtime_amount, 2);
                }
                //DA Amount
                if ($model_onsite_overtime->daily_allowance > 0) {
                    $sal_value = 0.00;
                    $arr_salary_detail[$f_key]['salary_id'] = 19;
                    $arr_salary_detail[$f_key]['salary_name'] = 'Daily Allowance';
                    $arr_salary_detail[$f_key]['salary_type'] = 1;
                    $arr_salary_detail[$f_key]['salary_amount'] = $model_onsite_overtime->daily_allowance;
                    $employee_salary+= $model_onsite_overtime->daily_allowance;
                    $f_key++;
                }
                $model_total_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`)+time_to_sec(`night_shift_overtime`)+time_to_sec(`holiday_overtime`)+time_to_sec(`weekend_overtime`)+time_to_sec(`onsite_normal_overtime`)+time_to_sec(`onsite_holiday_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                $overtime_work = $model_total_overtime->normal_overtime;
                $model_total_onsite_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`onsite_normal_overtime`)+time_to_sec(`onsite_holiday_overtime`))) As onsite_normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                $onsite_overtime_work = $model_total_onsite_overtime->onsite_normal_overtime;
                $model_total_ofc_overtime = EmployeeAttendance::model()->find(array('select' => 'SEC_TO_TIME(SUM(time_to_sec(`normal_overtime`)+time_to_sec(`night_shift_overtime`)+time_to_sec(`holiday_overtime`)+time_to_sec(`weekend_overtime`))) As normal_overtime', 'condition' => 'employee_id="' . $each_employee->id . '" AND attendance_date>="' . $overtime_start_date . '" AND attendance_date<="' . $overtime_end_date . '"'));
                $ofc_overtime_work = $model_total_ofc_overtime->normal_overtime;
                //End Overtime Calculation
                //Employee Joining Date
                if ($joining_date != '' && $joining_date != '0000-00-00') {
                    if (strtotime($joining_date) > strtotime($payroll_startdate)) {
                        //                    $salary_start_date = strtotime($payroll_enddate);
                        //                    $joining_date = strtotime($joining_date);
                        //                    $datediff = $salary_start_date-$joining_date ;
                        //                    $diff_day = $datediff / (60 * 60 * 24)+1;
                        //                    $employee_salary = round($employee_per_day_salary * $diff_day, 2);
                        $emp_sal_deduction = $employee_salary - $late_joining_employee_salary;
                        //$employee_salary=$late_joining_employee_salary;
                        
                    }
                }
                //End by joining date calculation
                //Incentive Amount-Start
                $incentive_amount = 0.00;
                $model_incentive_details = HrSaleTargetDetails::model()->with('targetdetail')->find(array('condition' => 'employee_id ="' . $each_employee->id . '" and year="' . $year . '" and month="' . $month . '"'));
                if (!empty($model_incentive_details) && $model_incentive_details->net_incentive_amount > 0) {
                    $incentive_amount = $model_incentive_details->net_incentive_amount;
                }
                //Incentive Amount-End
                //Public Holiday Allowance-Start
                $holiday_count = 0;
                $holiday_allowance = 0.00;
                if ($model_hr_general_settings->consider_public_holiday_allowance == 'Y') {
                    $model_holiday = MasHoliday::model()->findAll(array('condition' => 'FIND_IN_SET("' . $each_employee->branch_or_sponsor_id . '",branch_id) AND holiday_date>="' . $payroll_startdate . '" AND holiday_date<="' . $payroll_enddate . '"'));
                    if (!empty($model_holiday)) {
                        foreach ($model_holiday as $key => $value) {
                            $model_attendance_holiday = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $each_employee->id . '" and attendance_date="' . $value->holiday_date . '" and status="1"'));
                            if (!empty($model_attendance_holiday) && $model_attendance_holiday->id > 0) {
                                $holiday_count++;
                            }
                        }
                        //Holiday Allowance
                        $model_allowance_details = HrHolidayAllowance::model()->find(array('condition' => 'employee_id ="' . $each_employee->id . '"'));
                        if(!empty($model_allowance_details)){
                            if ($holiday_count > 0) {
                                $per_day_allowance = $model_allowance_details->allowance_amount;
                                $holiday_allowance+= $per_day_allowance * $holiday_count;
                            }
                        }
                        $holiday_allowance+= $employee_per_day_salary * $holiday_count * $each_employee->departmentdetail->holiday_incentive;
                    }
                }
                //Public Holiday Allowance-End
                //Night Shift Allowance-Start
                $night_shift_count = 0;
                $night_shift_allowance = 0.00;
                $model_night_shift_days = EmployeeAttendance::model()->with('shift', 'shift.shiftdetails')->find(array('select' => 'count(t.id) as id', 'condition' => 'shiftdetails.shift_type="N" AND t.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND status="1"'));
                if (!empty($model_night_shift_days) && $model_night_shift_days->id > 0) {
                    $night_shift_count = $model_night_shift_days->id;
                    //Night Shift Allowance
                    $model_allowance_details = EmployeeAttendance::model()->find(array('select' => 'sum(t.night_shift_allowance) as night_shift_allowance', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '"'));
                    if ($model_allowance_details->night_shift_allowance > 0) {
                        $night_shift_allowance = $model_allowance_details->night_shift_allowance;
                    }
                }
                //Night Shift Allowance-End
                //Calculation from Overtime sheet upload-Start
                $model_timesheet_overtime = HrOutsourceOvertime::model()->find(array('condition' => 'employee_id=' . $each_employee->id . ' AND overtime_month="' . $month . '" AND overtime_year="' . $year . '"'));
                if (!empty($model_timesheet_overtime) && $model_timesheet_overtime->id > 0) {
                    //Start Normal OT
                    if ($model_timesheet_overtime->normal_overtime > 0) {
                        $norm_wrk_days =$total_working_days;
                        if ($each_employee->departmentdetail->normal_ot_days > 0) {
                            $norm_wrk_days = $each_employee->departmentdetail->normal_ot_days;
                        }
                        $model_master_normal = MasOverTime::model()->findByPk(1);
                        $normal_overtime_salary = 0.00;
                        $each_normal_ot = explode(',', $model_master_normal->salary);
                        foreach ($each_normal_ot as $value_1) {
                            $model_normalovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $normal_overtime_salary+= $model_normalovertime_salary->amount;
                        }
                        $normal_ot_salary_per_day = round($normal_overtime_salary / $norm_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_normal = $normal_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_normal * 3600;
                        //Overtimesalary
                        $salary_overtime_normal = $salary_per_hour_normal * $model_master_normal->times;
                        $normal_salary_per_min = ($salary_overtime_normal / 60);
                        $ot_nor = $salary_overtime_normal * $model_timesheet_overtime->normal_overtime;
                        $overtime_amount+= $ot_nor;
                        $ofc_overtime_amount+= $ot_nor;
                        $normal_ot_amount+= $ot_nor;
                    }
                    //End Normal Overtime
                    //Start Holiday Overtime
                    if ($model_timesheet_overtime->holiday_overtime > 0) {
                        $hol_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->holiday_ot_days > 0) {
                            $hol_wrk_days = $each_employee->departmentdetail->holiday_ot_days;
                        }
                        $model_master_holiday = MasOverTime::model()->findByPk(2);
                        $each_holiday_ot = explode(',', $model_master_holiday->salary);
                        $holiday_overtime_salary = 0.00;
                        foreach ($each_holiday_ot as $value_1) {
                            $model_holidayovertime_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $holiday_overtime_salary+= $model_holidayovertime_salary->amount;
                        }
                        $holiday_ot_salary_per_day = $holiday_overtime_salary / $hol_wrk_days; //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_holiday = $holiday_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_holiday = $salary_per_second_holiday * 3600;
                        //Overtimesalary
                        $salary_overtime_holiday = $salary_per_hour_holiday * $model_master_holiday->times;
                        $holiday_salary_per_min = ($salary_overtime_holiday / 60);
                        $ot_hol = $salary_overtime_holiday * $model_timesheet_overtime->holiday_overtime;
                        $overtime_amount+= $ot_hol;
                        $ofc_overtime_amount+= $ot_hol;
                        $holiday_ot_amount+= $ot_hol;
                    }
                    //End Holiday Overtime
                    //Holiday Allowance-Start
                    if ($model_timesheet_overtime->holiday_count > 0) {
                        $holiday_allowance+= $employee_per_day_salary * $model_timesheet_overtime->holiday_count * $each_employee->departmentdetail->holiday_incentive;
                    }
                    //Holiday Allowance-End
                    //Night Shift Overtime-start
                    if ($model_timesheet_overtime->night_overtime > 0) {
                        $night_wrk_days = $total_working_days;
                        if ($each_employee->departmentdetail->night_ot_days > 0) {
                            $night_wrk_days = $each_employee->departmentdetail->night_ot_days;
                        }
                        $model_master_night_shift = MasOverTime::model()->findByPk(4);
                        $night_shift_overtime_salary = 0.00;
                        $each_night_shift_ot = explode(',', $model_master_night_shift->salary);
                        foreach ($each_night_shift_ot as $value_1) {
                            $model_night_shift_salary = EmployeeSalary::model()->find(array('select' => 'amount', 'condition' => 'employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND salary_type="' . $value_1 . '" AND isActive="Y"'));
                            $night_shift_overtime_salary+= $model_night_shift_salary->amount;
                        }
                        $night_shift_ot_salary_per_day = round($night_shift_overtime_salary / $night_wrk_days, 2); //Per day salary for overtime
                        //Salary Per hour
                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($each_employee->branch_or_sponsor_id);
                        $working_hours_second = "";
                        if ($model_company_shift->branch_working_hours != '00:00:00') {
                            $working_total_hr = strtotime($model_company_shift->branch_working_hours);
                            $break_total_hr = strtotime($model_company_shift->lunch_break_time);
                            $diff = ($working_total_hr - $break_total_hr);
                            $total_working = gmdate('H:i', $diff);
                            $working_time = explode(':', $total_working);
                            $working_hours_second = $working_time[0] * 3600 + $working_time[1] * 60 + $working_time[2];
                        } else {
                            $original_start_time = date("H:i", strtotime($model_company_shift->workstart_time));
                            $original_stop_time = date("H:i", strtotime($model_company_shift->workend_time));
                            $original_start_time = strtotime($original_start_time);
                            $original_stop_time = strtotime($original_stop_time);
                            $working_hours_second = ($original_stop_time - $original_start_time); //In second
                            
                        }
                        $salary_per_second_night_shift = $night_shift_ot_salary_per_day / $working_hours_second;
                        $salary_per_hour_normal = $salary_per_second_night_shift * 3600;
                        //Overtimesalary
                        $salary_overtime_night_shift = $salary_per_hour_normal * $model_master_night_shift->times;
                        $night_shift_salary_per_min = ($salary_overtime_night_shift / 60);
                        $ot_nit = $salary_overtime_night_shift * $model_timesheet_overtime->night_overtime;
                        $overtime_amount+= $ot_nit;
                        $ofc_overtime_amount+= $ot_nit;
                        $night_ot_amount+= $ot_nit;
                    }
                    //Night Shift Overtime-end
                    //Night Shift Allowance-Start
                    if ($model_timesheet_overtime->night_shift > 0) {
                        $night_shift_allowance = $model_timesheet_overtime->night_shift * $model_hr_general_settings->night_shift_allowance;
                    }
                    //Night Shift Allowance-End
                    //Salary Deduction for absent-Start
                    if ($model_timesheet_overtime->absent_with_deduction > 0) {
                        if ($each_employee->departmentdetail->absent_deduction > 0) {
                            $leave_deduction_amount+= round($each_employee->departmentdetail->absent_deduction * $model_timesheet_overtime->absent_with_deduction, 2);
                        }
                    }
                    if ($model_timesheet_overtime->absent_without_deduction > 0) {
                        $leave_deduction_sal = 0.00;
                        //Recurring
                        $model_leavededuction_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="2" AND salary.consider_deduction="Y" and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                        $leave_deduction_sal+= $model_leavededuction_salary->amount;
                        $model_leavededuction_salary_single = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'salary.salary_occurence="1" AND salary.consider_deduction="Y"  and employee_id="' . $each_employee->id . '" AND (("' . $payroll_startdate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_startdate . '" AND valid_to="0000-00-00") OR ("' . $payroll_enddate . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $payroll_enddate . '" AND valid_to="0000-00-00")) AND t.isActive="Y"'));
                        $leave_deduction_sal+= $model_leavededuction_salary_single->amount;
                        $leave_per_day_sal = round($leave_deduction_sal / $days, 2);
                        $leave_deduction_amount+= round($leave_per_day_sal * $model_timesheet_overtime->absent_without_deduction, 2);
                    }
                    //Salary Deduction for absent-End
                    
                }
                //Calculation from Overtime sheet upload-End
                //Total Addition
                $total_additions = $overtime_amount + $annual_leave_amount + $incentive_amount + $holiday_allowance + $night_shift_allowance + $uploaded_salary_additions;
                //Total Deduction
                $total_deductions = $loan_amount + $salary_advance_deduction + $leave_deduction_amount + $employee_percent_amt + $annual_leave_amount + $emp_sal_deduction + $uploaded_salary_deductions;
                $total_salary_amount = ($employee_salary + $total_additions) - $total_deductions;
                //Start Days Absent without pay
                $days_absent_without_pay = 0.00;
                //Absent Salary Deduction
                $model_absent = EmployeeAttendance::model()->find(array('select' => 'count(t.id) as id', 'condition' => 't.employee_id=' . $each_employee->id . ' AND attendance_date>="' . $payroll_startdate . '" AND attendance_date<="' . $payroll_enddate . '" AND (status="2" OR status="3")'));
                if ($model_absent->id > 0) {
                    $days_absent_without_pay+= $model_absent->id;
                }
                $joining_date_1 = $each_employee->date_join;
                if ($joining_date_1 != '' && $joining_date_1 != '0000-00-00') {
                    if (strtotime($joining_date_1) > strtotime($payroll_startdate)) {
                        $salary_start_date = strtotime($payroll_startdate);
                        $joining_date_2 = strtotime($joining_date);
                        $datediff = $joining_date_2 - $salary_start_date;
                        $absent_days = $datediff / (60 * 60 * 24);
                        $days_absent_without_pay+= $absent_days;
                    }
                }
                if (!empty($model_timesheet_overtime) && $model_timesheet_overtime->id > 0) {
                    $days_absent_without_pay = $model_timesheet_overtime->absent_with_deduction + $model_timesheet_overtime->absent_without_deduction;
                }
                //End Days Absent without pay
            
                    date_default_timezone_set("Asia/Dubai");
                    $model_salary_processing = SalaryProcessing::model()->findbyPk($id);
                    $model_salary_processing->updated_by = Yii::app()->user->id;
                    $model_salary_processing->updated_date_time = date('Y-m-d H:i:s');
                    $model_salary_processing->scenario ='pendingcalcualte';
                    $valid = $model_salary_processing->validate();
                //Valid then only add details
                if ($valid) {
                     $model_salary_processing->save();
                    $model_salary_slip = new SalarySlip();
                    $model_salary_slip->salary_processing_id = $model_salary_processing->id;
                    $model_salary_slip->employee_id = $each_employee->id;
                    $model_salary_slip->total_working_days = $total_working_days;
                    $model_salary_slip->absent_working_days = $days_absent_without_pay;
                    $model_salary_slip->salary_advance_amount = $salary_advance_deduction;
                    $model_salary_slip->leave_amount = $leave_deduction_amount;
                    $model_salary_slip->loan_amount = $loan_amount;
                    $model_salary_slip->incentive = $incentive_amount;
                    $model_salary_slip->public_holiday = $holiday_count;
                    $model_salary_slip->public_holiday_allowance = $holiday_allowance;
                    $model_salary_slip->night_shift_days = $night_shift_count;
                    $model_salary_slip->night_shift_allowance = $night_shift_allowance;
                    $model_salary_slip->normal_ot_amount = $normal_ot_amount;
                    $model_salary_slip->night_ot_amount = $night_ot_amount;
                    $model_salary_slip->holiday_ot_amount = $holiday_ot_amount;
                    $model_salary_slip->weekend_ot_amount = $weekend_ot_amount;
                    $model_salary_slip->onsite_overtime = $onsite_overtime_work;
                    $model_salary_slip->onsite_overtime_amount = $onsite_overtime_amount;
                    $model_salary_slip->office_ot = $ofc_overtime_work;
                    $model_salary_slip->office_ot_amount = $ofc_overtime_amount;
                    $model_salary_slip->overtime_hour = $overtime_work;
                    $model_salary_slip->overtime_amount = $overtime_amount;
                    //Pension split
                    $model_salary_slip->pension_amount_employee = $employee_percent_amt;
                    $model_salary_slip->pension_amount_company = $company_percent_amt;
                    //
                    $model_salary_slip->pension_amount = $employee_percent_amt;
                    $model_salary_slip->gratuity_amount = $gratuity_gross_amount;
                    $model_salary_slip->employee_salary_amount = $employee_salary;
                    $model_salary_slip->before_joining_salary = $emp_sal_deduction;
                    $model_salary_slip->annual_leave_addition = 0;
                    $model_salary_slip->annual_leave_deduction = 0;
                    $model_salary_slip->total_addition_amount = $total_additions;
                    $model_salary_slip->total_deduction_amount = $total_deductions;
                    $model_salary_slip->total_salary_amount = $total_salary_amount;
                    //Threshold salary
                    if ($model_hr_general_settings->consider_threshold_salary == 'Y') {
                        $model_salary_slip->threshold_salary = $each_employee->threshold_salary;
                        $threshold_salary = $each_employee->threshold_salary;
                        if ($total_salary_amount > $threshold_salary) {
                            $sif_bal_salary = $total_salary_amount - $threshold_salary;
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $threshold_salary;
                            $model_salary_slip->sif_untransfer_salary = $sif_bal_salary;
                        } else {
                            $model_salary_slip->threshold_salary = $threshold_salary;
                            $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                            $model_salary_slip->sif_untransfer_salary = 0.00;
                        }
                    } else {
                        $model_salary_slip->threshold_salary = 0.00;
                        $model_salary_slip->sif_transfer_salary = $total_salary_amount;
                        $model_salary_slip->sif_untransfer_salary = 0.00;
                    }
                    $model_salary_slip->created_by = Yii::app()->user->id;
                    $model_salary_slip->created_date_time = date('Y-m-d H:i:s');
                    $model_salary_slip->save();
                  
                    //Pension Save
                    $model_pension = new EmployeePension();
                    $model_pension->salary_slip_id = $model_salary_slip->id;
                    $model_pension->employee_id = $each_employee->id;
                    $model_pension->employee_contribution_amount = $employee_percent_amt;
                    $model_pension->company_contribution_amount = $company_percent_amt;
                    $model_pension->total_pension_amount = $total_pension_amount;
                    $model_pension->created_date = date('Y-m-d');
                    $model_pension->save();
                    //End Pension Save
                    //Gratuity Saving
                    $model_gratuity = new MonthlyGratuity();
                    $model_gratuity->employee_id = $each_employee->id;
                    $model_gratuity->salary_slip_id = $model_salary_slip->id;
                    $model_gratuity->gratuity_amount = $gratuity_gross_amount;
                    $model_gratuity->created_date = date('Y-m-d');
                    $model_gratuity->save();
                    //End Gratuity Saving
                    //Salary Slip Details
                    foreach ($arr_salary_detail as $i => $item) {
                        $model_salary_slip_details = new SalarySlipDetails();
                        $model_salary_slip_details->salary_processing_id = $model_salary_processing->id;
                        $model_salary_slip_details->salary_slip_id = $model_salary_slip->id;
                        $model_salary_slip_details->salary_id = $item['salary_id'];
                        $model_salary_slip_details->salary_name = $item['salary_name'];
                        $model_salary_slip_details->salary_type = $item['salary_type'];
                        $model_salary_slip_details->salary_amount = $item['salary_amount'];
                        $model_salary_slip_details->created_by = Yii::app()->user->id;
                        $model_salary_slip_details->created_date_time = date('Y-m-d H:i:s');
                        $model_salary_slip_details->save();
                    }
                } else {
                    $error = CActiveForm::validate($model_salary_processing, '', false);
                    if ($error != '[]') echo $error;
                    Yii::app()->end();
                }
                
            }
            }
        }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        
    }
    

}
