<?php

class RoomsettingsController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetList','Create', 'Saveroomsettings','MasterIndex','GetbedspaceList','AddbedSpace','getroomdetail','getbedspacedetail',
                                    'Savebedspacedetails','Editbedspacedetail','allocationindex','GetAllocationList','Createallocation','getroomdetails','getbedspacedetails',
                                    'SaveRoomallocation','editroomallocation','deleteroomallocation','deletebedspace'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_room = HrModules::model()->findByPK(20);
        if ($model_module_room->grant_access == 1 && $model_module_room->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_room_setting_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new RoomSetting();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'building_name',
            2 => 'country.country_name',
            3 => 'location_name',
            4 => 'no_rooms',
            5 => 't.id',
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (building_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('country')->count(array('condition' => $condition));
        $model = $model->with('country')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_roomsetting_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string = '<div style="width:100%; text-align:center;"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/roomsettings/create&id=' . $row['id'] . '\',\'Edit Room Setting \',\'lg\')"><i class="fa fa-edit"></i></button></div>';
                $edit_button =1;
                
            }
            $rowData[] = array($m,$row['building_name'],$row['country']['country_name'],$row['location_name'],$row['no_rooms'],array('id'=>$row['id'],'edit_button'=>$edit_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new RoomSetting();
        $model_details = array(new RoomSettingDetails());
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = RoomSettingDetails::model()->findAll(array('condition'=>'room_setting_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($model_details)){
                $model_details = array(new RoomSettingDetails);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_details' => $model_details), false, true);
    }

    public function actionSaveroomsettings() {
        $model = new RoomSetting();
        $valid=true;
        if (isset($_POST['RoomSetting'])) {
            if ((int) @$_POST['RoomSetting']['id'] > 0) {
                $id = (int) @$_POST['RoomSetting']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['RoomSetting'];
            $model->location_name = $_POST['RoomSetting']['location_name'];
            $valid=$model->validate();
            if ((isset($_POST['RoomSettingDetails']))){                   		
                foreach ($_POST['RoomSettingDetails'] as $i => $items) {
                    if($items['id']>0){
                        $model_details[$i] =RoomSettingDetails::model()->findByPK($items['id']);   
                    }else{
                        $model_details[$i] = new RoomSettingDetails();   
                    } 
                    $model_details[$i]->room_name = $items['room_name'];
                    $model_details[$i]->room_bedspace = $items['room_bedspace'];
                    $valid=$model_details[$i]->validate() && $valid;
                }
            }else{
                $valid=false;
            }
            if($valid) {
                $model->save();
                foreach ($model_details as $eachModel) {
                    $eachModel->room_setting_id = $model->id;
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_details[0]->room_name!='')
                    $error2 = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionMasterIndex() {
        $model_module_room = HrModules::model()->findByPK(20);
        if ($model_module_room->grant_access == 1 && $model_module_room->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_bedspace_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('master_index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetbedspaceList() {
        $model = new RoomBedspace();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'buildingdetail.building_name',
            2 => 'buildingdetail.country_name',
            3 => 'buildingdetail.location_name',
            4 => 'roomdetail.room_name',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (building_name LIKE '%" . $searchString . "%' OR room_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('buildingdetail','roomdetail')->count(array('condition' => $condition, 'group'=>'roomdetail.room_name'));
        $model = $model->with('buildingdetail','roomdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'group'=>'roomdetail.room_name','order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_bedspace_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string = '<div style="width:100%; text-align:center;"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/roomsettings/editbedspacedetail&room_id=' . $row['room_id'] . '\',\'Edit Bed Space Detail \',\'lg\')"><i class="fa fa-edit"></i></button></div>';
                $edit_button=1;
            }
            $rowData[] = array($m,$row['buildingdetail']['building_name'],$row['buildingdetail']['country']['country_name'],$row['buildingdetail']['location_name'],$row['roomdetail']['room_name'],array('room_id'=>$row['room_id'],'edit_button'=>$edit_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionAddbedSpace() {
        $model_details = array(new RoomBedspace);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('bedspace_details', array('model_details' => $model_details), false, true);
    }
    public function actiongetroomdetail() {
        $floor_id = $_POST['floor_id'];
        $data = array();
        if($floor_id > 0){
            $data['roomdetail']  =  CHtml::dropDownList('room_id', '',RoomSettingDetails::getroomdetail($floor_id), array('onChange' => 'getroomcount(this.value);','class' => 'tooltipster', 'title' => 'Room Name', 'data-label' => 'Room Name', 'empty' => 'Select')); 
        }
         echo CJSON::encode($data);
    }
    public function actiongetbedspacedetail() {
        $room_id = $_POST['room_id'];
        if($room_id > 0){
            $model_room = RoomSettingDetails::model()->findByPk($room_id);
            $data['bedspacedetail']  ='<span>Bed Space-'.$model_room->room_bedspace.'</span>'; 
            $data['bedspacedetail'].=CHtml::hiddenField('bedspace_count',$model_room->room_bedspace); 
        }
         echo CJSON::encode($data);
    }
     public function actionSavebedspacedetails() { 
        $model = new RoomBedspace();
        $valid=true;
        if (isset($_POST['RoomBedspace'])) {                   		
            foreach ($_POST['RoomBedspace'] as $i => $items) {
                if($items['id']>0){
                    $model_details[$i] =RoomBedspace::model()->findByPK($items['id']); 
                    $model_details[$i]->updated_by= Yii::app()->user->id;
                    $model_details[$i]->updated_date_time = date('Y-m-d h:i:s');
                }else{
                    $model_details[$i] = new RoomBedspace();   
                    $model_details[$i]->created_by= Yii::app()->user->id;
                    $model_details[$i]->created_date_time = date('Y-m-d h:i:s');
                } 
                $model_details[$i]->building_floor_id = $_POST['building_floor_id'];
                $model_details[$i]->room_id = $_POST['room_id'];
                $model_details[$i]->bed_space_name = $items['bed_space_name'];
                $valid=$model_details[$i]->validate() && $valid;
            }
            if($valid) {
                $model->save();
                foreach ($model_details as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_details, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionEditbedspacedetail() {
        $model_details = array(new RoomBedspace());
        $id = (int) Yii::app()->request->getParam('room_id');
        if ($id > 0) {
            $model_details = RoomBedspace::model()->findAll(array('condition'=>'room_id="'.$id.'"','order' => 'id ASC')); 
            if(empty($model_details)){
                $model_details = array(new RoomBedspace);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('bedspace_details', array('model_details' => $model_details), false, true);
    }
    public function actionAllocationindex() {
        $model_module_room = HrModules::model()->findByPK(20);
        if ($model_module_room->grant_access == 1 && $model_module_room->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_room_allocation_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('allocation_index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetAllocationList() {
        $model = new RoomAllocation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'buildingdetail.building_name',
            2 => 'roomdetail.room_name',
            3 => 'bedspacedetail.bed_space_name',
            4 => 'employeedetail.first_name',
            5 => 'start_date',
            6 => 'end_date',
            7 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition .= " and (first_name LIKE '%" . $searchString_en . "%'OR employee_code LIKE '%" . $searchString_en . "%'OR building_name LIKE '%" . $searchString . "%'OR room_name LIKE '%" . $searchString . "%' OR bed_space_name LIKE '%" . $searchString . "%')";
        }else{
          //  $condition = 't.end_date="0000-00-00"';
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('buildingdetail','roomdetail','bedspacedetail','employeedetail')->count(array('condition' => $condition));
        $model = $model->with('buildingdetail','roomdetail','bedspacedetail','employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_button=$delete_button=1;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_room_allocation_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/roomsettings/editroomallocation&id=' . $row['id'] . '\',\'Edit Room Allocation \',\'lg\')"><i class="fa fa-edit"></i></button>';
                $edit_button =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_room_allocation_delete'])  || Yii::app()->user->authorised_user == 1) {
                if($row['end_date']=='0000-00-00'){
                    $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete" onclick="deleteroom('.$row['id'].')"><i class="fa fa-trash"></i></a>' ;                      
                    $delete_button =1;
                    
                }
            }
            $start_date=$end_date="";
            if($row['start_date']!='' && $row['start_date']!='0000-00-00'){
                $start_date=date("d/m/Y",strtotime($row->start_date));
            }
            $end_date="";
            if($row['end_date']!='' && $row['end_date']!='0000-00-00'){
                $end_date=date("d/m/Y",strtotime($row->end_date));
            }
            if($row['bedspace_id'] > 0){
               $bed_space_name=$row['bedspacedetail']['bed_space_name']; 
                
            }else{
                $bed_space_name='';
            }
            $rowData[] = array($m,$row['buildingdetail']['building_name'],$row['roomdetail']['room_name'],$bed_space_name,$row['employeedetail']['employeefullname'],$start_date,$end_date, array('id'=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateallocation() {
        $model_details = array(new RoomAllocation());
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('room_allocation', array('model_details' => $model_details), false, true);
    }
    public function actiongetroomdetails() {
        $floor_id = $_POST['floor_id'];
        $model =new RoomAllocation();
        $data = array();
        if($floor_id > 0){
            $data['roomdetail']  =  CHtml::activedropDownList($model,'room_id',RoomSettingDetails::getroomdetails($floor_id), array('onChange' => 'getbedspacedetail(this.id);','class' => 'go', 'title' => 'Room Name', 'empty' => 'Select')); 
        }
         echo CJSON::encode($data);
    }
    public function actiongetbedspacedetails() {
        $room_id = $_POST['room_id'];
        $model =new RoomAllocation();
        $data = array();
        if($room_id > 0){
            $data['bedspacedetail']  =  CHtml::activedropDownList($model,'bedspace_id',RoomBedspace::getbedspacedetail($room_id), array('class' => 'go', 'title' => 'Bed Space', 'empty' => 'Select')); 
        }
         echo CJSON::encode($data);
    }
    public function actionSaveRoomallocation() { 
        $model = new RoomAllocation();
        $valid=true;
        if (isset($_POST['RoomAllocation'])) {                   		
            foreach ($_POST['RoomAllocation'] as $i => $items) {
                if(!empty($items['id']) && $items['id']>0){
                    $model_details[$i] =RoomAllocation::model()->findByPK($items['id']); 
                    $model_details[$i]->updated_by= Yii::app()->user->id;
                    $model_details[$i]->updated_date_time = date('Y-m-d h:i:s');
                }else{
                    $model_details[$i] = new RoomAllocation();   
                    $model_details[$i]->created_by= Yii::app()->user->id;
                    $model_details[$i]->created_date_time = date('Y-m-d h:i:s');
                } 
                $model_details[$i]->building_id = $items['building_id'];
                $model_details[$i]->room_id = $items['room_id'];
                $model_details[$i]->employee_id = $items['employee_id'];
                $model_details[$i]->bedspace_id = $items['bedspace_id'];
                if ($items['start_date'] != '' && $items['start_date'] != '0000-00-00') {
                    $model_details[$i]->start_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['start_date'])));                   
                }
                if ($items['end_date'] != '' && $items['end_date'] != '0000-00-00') {
                    $model_details[$i]->end_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['end_date'])));                   
                }
                $valid=$model_details[$i]->validate() && $valid;
            }
            if($valid) {
                $model->save();
                foreach ($model_details as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_details, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionEditroomallocation() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = RoomAllocation::model()->findByPk($id); 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('editroom_allocation', array('model' => $model), false, true);
    }
    public function actiondeleteroomallocation(){
        $id = $_POST['id'];
        if($id>0){
            $model = new RoomAllocation();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiondeletebedspace(){
        $id = $_POST['id'];
        if($id>0){
            $model_allocation=RoomAllocation::model()->findAll(array('condition'=>'bedspace_id="'.$id.'"')); 
            if(empty($model_allocation)){
                RoomBedspace::model()->deleteByPk($id);
                $status['status'] = 'success';
            }else{
                $status['status'] = 'error';
            }
             
        }else{
            $status['status'] = 'error';
         }
         echo CJSON::encode($status);
     }
}
