<?php
class ReportsController extends Controller {
    public function accessRules() {
        return array(array('allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('login', 'error', 'logout'), 'users' => array('*'),), array('allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array('Index', 'LoadMasterReportFilter', 'PrintEOSPDF', 'PrintEmployeeAttendancePDF', 'PrintMonthlyAttendanceReportPDF', 'PrintEmployeeworkingHoursPDF', 'PrintEmpWeeklyWorkinhHoursPDF', 'PrintEmpMonthlyWorkingHoursPDF', 'PrintLeaveHistoryReportPDF', 'PrintEmployeeListReportPDF', 'PrintEmployeeBlockListReportPDF', 'PrintSalaryBeforeReportPDF', 'PrintEmployeeDesignationListReportPDF', 'PrintEmployeeLeavelistReportPDF', 'PrintEmployeeDepartmentListReportPDF', 'PrintEmployeeAssetReportPDF', 'PrintEmployeeDocumentListReportPDF', 'PrintbranchlistReportPDF', 'PrintEmployeeLeaveSettlementReportPDF', 'PrintEmployeeGratuityReportPDF', 'PrintInOutDocumentReportPDF', 'PrintEmployeeExpiredDocumentReportPDF', 'PrintEmployeeSalaryReportPDF', 'PrintEmployeeLoanReportPDF', 'PrintEmployeeTicketReportPDF', 'PrintSalarySlipReportPDF', 'PrintSalaryincrementReportPDF', 'PrintEmployeeNewHirelistReportPDF', 'PrintEOSReportPDF', 'PrintOvertimeReportPDF', 'Printgrosssalary', 'PrintEmployeeQualificationReportPdf', 'PrintEmployeeHierarchyListReportPDF', 'PrintEmployeeSettingsListReportPDF', 'PrintEmployeeTeamListReportPDF', 'PrintEmployeeBankdetailsReportPDF', 'PrintEmployeePunchHistoryReportPDF'), 'expression' => '$user->isMember()',), array('deny', // deny all users
        'users' => array('*'),),);
    }
    public function filters() {
        return array('accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
        $frm = Yii::app()->request->getParam('frm');
        $this->render('master_report', array('frm' => $frm));
    }
    public function actionLoadMasterReportFilter() {
        $report_from = Yii::app()->request->getparam('report_from');
        if ($report_from == 'attendanceList') {
            $this->renderPartial('filter_attendance_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendanceOverTimeList') {
            $this->renderPartial('filter_attendance_overtime_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendanceMonthlylist') {
            $this->renderPartial('filter_attendance_monthly_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'monthlyattendance') {
            $this->renderPartial('filter_monthlyattendance', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendanceWorkingHourslist') {
            $this->renderPartial('filter_attendance_workinghours_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendanceWeekendLeavelist') {
            $this->renderPartial('filter_attendance_weekend_leave_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendanceLogReport') {
            $this->renderPartial('filter_attendance_log_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendanceLeaveHistory') {
            $this->renderPartial('filter_attendance_leave_history', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showBusinessMeeting') {
            $this->renderPartial('filter_business_meeting_report', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'attendanceYearlyLeaveReport') {
            $this->renderPartial('filter_attendance_yearly_leave_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'leaveencashment') {
            $this->renderPartial('filter_leaveencashment', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployee') {
            $this->renderPartial('filter_employee_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeBranch') {
            $this->renderPartial('filter_employeebranch_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeBlock') {
            $this->renderPartial('filter_employee_blocklist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeDepartment') {
            $this->renderPartial('filter_employee_departmentlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeConsolidatedReport') {
            $this->renderPartial('filter_employee_consolidated', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeDocumentDetails') {
            $this->renderPartial('filter_employee_document_details', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeequalification') {
            $this->renderPartial('filter_employee_qualification', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeDesignation') {
            $this->renderPartial('filter_employee_designationlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeDocument') {
            $this->renderPartial('filter_employee_documentlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeExpireDocument') {
            $this->renderPartial('filter_employee_expiredocumentlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeAppraisal') {
            $this->renderPartial('filter_employee_appraisallist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeIndividualAppraisal') {
            $this->renderPartial('filter_employee_individualappraisallist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeasset') {
            $this->renderPartial('filter_employee_assetlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeesalary') {
            $this->renderPartial('filter_employee_salary', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeEOS') {
            $this->renderPartial('filter_employee_eoslist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeRecruitment') {
            $this->renderPartial('filter_employee_recruitment_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeloan') {
            $this->renderPartial('filter_employee_loan', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'employee_ticket') {
            $this->renderPartial('filter_employee_ticket', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'gratuity_list') {
            $this->renderPartial('filter_employee_gratuitylist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'leave_settlement_list') {
            $this->renderPartial('filter_employee_leavesettlement', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'new_hire_list') {
            $this->renderPartial('filter_new_hirelist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'branchList') {
            $this->renderPartial('filter_Branch_Report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'companydocument') {
            $this->renderPartial('filter_companydocument', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'inoutdocumentlist') {
            $this->renderPartial('filter_inout_Document', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'hierarchylist') {
            $this->renderPartial('filter_employee_hierarchy', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'salarybefore') {
            $this->renderPartial('filter_salary_before', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'salaryslip') {
            $this->renderPartial('filter_salary_slip', array('report_from' => $report_from), false, true);
        }
        // monthly report added by nisha on 27-01-2023
        else if ($report_from == 'employeemastersalary') {
            $this->renderPartial('filter_employee_master_salary', array('report_from' => $report_from), false, true);
        }
        //end code
        else if ($report_from == 'showemployeeweekend') {
            $this->renderPartial('filter_employee_weekend', array('report_from' => $report_from), false, true);
        }
        else if ($report_from == 'mastersalary') {
            $this->renderPartial('filter_master_salary', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'grosssalary') {
            $this->renderPartial('filter_gross_salary', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'salaryincrement') {
            $this->renderPartial('filter_salary_increment', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'new_eos_report') {
            $this->renderPartial('filter_eos_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeleavelist') {
            $this->renderPartial('filter_leavelist_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'leavehistorylist') {
            $this->renderPartial('filter_leavehistorylist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'leaveledgerlist') {
            $this->renderPartial('filter_leaveledgerlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'probationary_list') {
            $this->renderPartial('filter_probationarylist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'ticket_encashment') {
            $this->renderPartial('filter_ticket_encashment', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'ticket_entitlement') {
            $this->renderPartial('filter_ticket_entitlement', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'leaveledger') {
            $this->renderPartial('filter_leaveledger', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'salaryadvance') {
            $this->renderPartial('filter_salaryadvance_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'salaryadvancelist') {
            $this->renderPartial('filter_salaryadvancelist_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'leavebalance') {
            $this->renderPartial('filter_leavebalance_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showemployeetraining') {
            $this->renderPartial('filter_training_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showtrainingplan') {
            $this->renderPartial('filter_training_plan', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'annualleavereport') {
            $this->renderPartial('filter_annual_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showexpense') {
            $this->renderPartial('filter_expense_report', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeDependant') {
            $this->renderPartial('filter_nominee_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showemployeepurchase') {
            $this->renderPartial('filter_purchase_list', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showsettingslist') {
            $this->renderPartial('filter_employe_weekend_typewise', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeTeamlist') {
            $this->renderPartial('filter_employee_teamlist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'showEmployeeBankdetails') {
            $this->renderPartial('filter_employee_bankdetailslist', array('report_from' => $report_from), false, true);
        } else if ($report_from == 'attendancepunchhistoryList') {
            $this->renderPartial('filter_attendancepunch_history_list', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'monthlysalarystatement') {
             $this->renderPartial('filter_monthly_salary_details', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'showHierarchyDepartment') {
             $this->renderPartial('filter_department_hierarchy', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'ticket_ledger') {
             $this->renderPartial('filter_ticket_ledger', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'showEmployeeLevel') {
             $this->renderPartial('filter_employee_level', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'showEOSClearance') {
             $this->renderPartial('filter_eos_clearance', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'attendancenotpunchList') {
            $this->renderPartial('filter_notpunch_list', array('report_from' => $report_from), false, true);
        }else if ($report_from == 'showEmployeeResignation') {
            $this->renderPartial('filter_employee_resignation', array('report_from' => $report_from), false, true);
        }
    }
    //PDF
    public function actionPrintEOSPDF() {
        $id = Yii::app()->request->getParam('emp_id');
        $eos_id = Yii::app()->request->getparam("eos_id");
        $date_leave = Yii::app()->request->getParam('date_leave');
        $leaving_date = date("Y-m-d", strtotime(str_replace('/', '-', $date_leave)));
        $modelemployee = Employee::model()->findbyPK($id);
        $branch_or_sponsor_id = $modelemployee->branch_or_sponsor_id;
        $model_eos = EmployeeEOS::model()->findByPk($eos_id);
        $model_eos_details = EmployeeEOSDetails::model()->findAll(array('condition' => 'eos_id="' . $eos_id . '"'));
        $eos_clearance = HrEmployeeEosClearanceDetails::model()->findAll(array('condition' => 'eos_id="' . $eos_id . '"'));
        $date1 = new DateTime($modelemployee->date_join);
        $date2 = new DateTime($leaving_date);
        $dd = date_diff($date1, $date2);
        $service_period = "$dd->y Yrs $dd->m Month $dd->d Day";
        $join_date = $modelemployee->date_join;
        $d1 = strtotime($join_date);
        $d2 = strtotime($leaving_date);
        $datediff = $d2 - $d1;
        $service_days = $datediff / (60 * 60 * 24) + 1;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->SetWatermarkImage(Yii::app()->baseUrl . '/images/logo/200150_' . MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id)->company_logo);
        $mPDF1->showWatermarkImage = true;
        $mPDF1->watermarkImageAlpha = 0.09;
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_for_list.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial("application.modules.hr.views.pdf.Eos_details", array('service_days' => $service_days, 'model_eos' => $model_eos, 'service_period' => $service_period, 'model_eos_details' => $model_eos_details, 'model_eos' => $model_eos, 'modelemployee' => $modelemployee, 'branch_or_sponsor_id' => $branch_or_sponsor_id, 'emp_id' => $id, 'date_leave' => $date_leave, 'eos_clearance' => $eos_clearance), true));
        $mPDF1->Output('EOS.pdf', 'I');
    }
    public function actionPrintEmployeeAttendancePDF() {
        $model = new Employee();
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $emp_id = Yii::app()->request->getParam('emp_id');
        $attend_emp_sponsor = Yii::app()->request->getParam('attend_emp_sponsor');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_attendence_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor), true));
        $mPDF1->Output('Attendance Report.pdf', 'I');
    }
    public function actionPrintMonthlyAttendanceReportPDF() {
        $model = new Employee();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_monthlyattendence_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'year' => $year), true));
        $mPDF1->Output('Attendance Report.pdf', 'I');
    }
    public function actionPrintEmployeeworkingHoursPDF() {
        $model = new EmployeeAttendance();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $working_report_type = Yii::app()->request->getParam('working_report_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_workhours_daily_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'year' => $year, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), true));
        $mPDF1->Output('Working Hours Report.pdf', 'I');
    }
    public function actionPrintEmpWeeklyWorkinhHoursPDF() {
        $model = new EmployeeAttendance();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $working_report_type = Yii::app()->request->getParam('working_report_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_workhours_weekly_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'year' => $year, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), true));
        $mPDF1->Output('Working Hours Report.pdf', 'I');
    }
    public function actionPrintEmpMonthlyWorkingHoursPDF() {
        $model = new EmployeeAttendance();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $working_report_type = Yii::app()->request->getParam('working_report_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_workhours_monthly_list', array('model' => $model, 'branch_id' => $branch_id, 'month' => $month, 'year' => $year, 'employee_id' => $employee_id, 'working_report_type' => $working_report_type), true));
        $mPDF1->Output('Working Hours Report.pdf', 'I');
    }
    public function actionPrintLeaveHistoryReportPDF() {
        $model = new EmployeeLeaveDetail();
        $leave_id = Yii::app()->request->getParam('leave_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_leave_historypdf', array('model' => $model, 'leave_id' => $leave_id, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), true));
        $mPDF1->Output('Leave Report.pdf', 'I');
    }
    public function actionPrintEmployeeListReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $department_id = Yii::app()->request->getParam('department_id');
        $designation_id = Yii::app()->request->getParam('designation_id');
        $reportmanager_id = Yii::app()->request->getParam('reportmanager_id');
        $category_id = Yii::app()->request->getParam('category_id');
        $status = Yii::app()->request->getParam('status');
        $team_id = Yii::app()->request->getParam('team_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->AddPage('L'); // Set landscape orientation
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_list_pdf', array('category_id' => $category_id, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id, 'department_id' => $department_id, 'designation_id' => $designation_id, 'reportmanager_id' => $reportmanager_id, 'status' => $status, 'team_id' => $team_id), true));
        $mPDF1->Output('Employee List.pdf', 'D');
    }
    public function actionPrintEmployeeBlockListReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $department = Yii::app()->request->getParam('department');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_blocklist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id, 'date_from' => $date_from, 'date_to' => $date_to,'department'=>$department), true));
        $mPDF1->Output('Blocked Employee List.pdf', 'D');
    }
    public function actionPrintSalaryBeforeReportPDF() {
        $model = new SalarySlip();
        $branch = Yii::app()->request->getParam('branch');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.salarybefore_locked_pdf', array('model' => $model, 'branch' => $branch, 'month' => $month, 'year' => $year), true));
        $mPDF1->Output('Monthly Salary List.pdf', 'I');
    }
    public function actionPrintEmployeeDesignationListReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $designation_name = Yii::app()->request->getParam('designation_name');
        $report_id = Yii::app()->request->getParam('report_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_designationlist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'designation_name' => $designation_name, 'report_id' => $report_id), true));
        $mPDF1->Output('Designation List.pdf', 'D');
    }
    public function actionPrintEmployeeLeavelistReportPDF() {
        $model = new EmployeeLeaveDetail();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $department_name = Yii::app()->request->getParam('department_name');
        $designation_name = Yii::app()->request->getParam('designation_name');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $leave_name = Yii::app()->request->getParam('leave_name');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_leavelist_pdf', array('model' => $model, 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date, 'leave_name' => $leave_name), true));
        $mPDF1->Output('Leave List.pdf', 'D');
    }
    public function actionPrintEmployeeDepartmentListReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $department_name = Yii::app()->request->getParam('department_name');
        $reportman_id = Yii::app()->request->getParam('reportman_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_departmentlist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'department_name' => $department_name, 'reportman_id' => $reportman_id), true));
        $mPDF1->Output('Department List.pdf', 'D');
    }
    public function actionPrintEmployeeAssetReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_name');
        $asset_status = Yii::app()->request->getParam('asset_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_assetlist_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'asset_status' => $asset_status), true));
        $mPDF1->Output('assetlist.pdf', 'D');
    }
    public function actionPrintEmployeeDocumentListReportPDF() {
        $model = new MasDocument();
        $document_id = Yii::app()->request->getParam('document_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_documentlist_pdf', array('model' => $model, 'document_id' => $document_id, 'employee_id' => $employee_id), true));
        $mPDF1->Output('Document List.pdf', 'D');
    }
    public function actionPrintbranchlistReportPDF() {
        $model = new MasCompanyBranchSponsor();
        $branchname = Yii::app()->request->getParam('branchname');
        $location = Yii::app()->request->getParam('location');
        $currency = Yii::app()->request->getParam('currency');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.branch_list_pdf', array('model' => $model, 'branchname' => $branchname, 'location' => $location, 'currency' => $currency), true));
        $mPDF1->Output('Branch List.pdf', 'D');
    }
    public function actionPrintEmployeeLeaveSettlementReportPDF() {
        $model = new HrEmployeeLeavesettlement();
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_leavesettlment_pdf', array('model' => $model, 'employee_id' => $employee_id), true));
        $mPDF1->Output('Leave Settlement List.pdf', 'I');
    }
    public function actionPrintEmployeeGratuityReportPDF() {
        $model = new Employee();
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_gratuity_pdf', array('model' => $model, 'employee_id' => $employee_id), true));
        $mPDF1->Output('Gratuity List.pdf', 'I');
    }
    public function actionPrintInOutDocumentReportPDF() {
        $model = new EmployeeInoutDocument();
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.InOut_document_pdf', array('model' => $model, 'employee_id' => $employee_id,), true));
        $mPDF1->Output('In Out Document List.pdf', 'D');
    }
    public function actionPrintEmployeeExpiredDocumentReportPDF() {
        $model = new MasDocument();
        $document_id = Yii::app()->request->getParam('document_id');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_expireddocument_pdf', array('model' => $model, 'document_id' => $document_id, 'employee_name' => $employee_name), true));
        $mPDF1->Output('Expired Document List.pdf', 'D');
    }
    public function actionPrintEmployeeSalaryReportPDF() {
        $model = new EmployeeSalary();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_salary_pdf', array('model' => $model, 'branch_id' => $branch_id, 'employee_id' => $employee_id), true));
        $mPDF1->Output('Employee Salary List.pdf', 'D');
    }
    public function actionPrintEmployeeLoanReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $status = Yii::app()->request->getParam('status');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_loan_pdf', array('status' => $status, 'branch_id' => $branch_id, 'employee_id' => $employee_id), true));
        $mPDF1->Output('loandetails.pdf', 'D');
    }
    public function actionPrintEmployeeTicketReportPDF() {
        $model = new EmployeeTicket();
        $employee_id = Yii::app()->request->getParam('employee_id');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_ticket_pdf', array('year' => $year, 'employee_id' => $employee_id), true));
        $mPDF1->Output('ticketdetails.pdf', 'D');
    }
    public function actionPrintSalarySlipReportPDF() {
        $model = new SalarySlip();
        $branch = Yii::app()->request->getParam('branch');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.salaryslip_pdf', array('model' => $model, 'branch' => $branch, 'month' => $month, 'year' => $year), true));
        $mPDF1->Output('Salary List.pdf', 'I');
    }
    public function actionPrintSalaryincrementReportPDF() {
        $model = new EmployeeSalary();
        $branch = Yii::app()->request->getParam('branch');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $salary_type = Yii::app()->request->getParam('salary_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.salaryincrement_pdf', array('model' => $model, 'branch' => $branch, 'employee_id' => $employee_id, 'salary_type' => $salary_type), true));
        $mPDF1->Output('Salary List.pdf', 'D');
    }
    public function actionPrintEmployeeNewHirelistReportPDF() {
        $param = $_REQUEST;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_newhire_pdf', $param, true));
        $mPDF1->Output('Hire List.pdf', 'D');
    }
    public function actionPrintEOSReportPDF() {
        $model = new EmployeeEOS();
        $employee_id = Yii::app()->request->getParam('employee_id');
        $branch_id = Yii::app()->request->getParam('branch_id');
        $department_name = Yii::app()->request->getParam('department_name');
        $designation_name = Yii::app()->request->getParam('designation_name');
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.eos_report_pdf', array('model' => $model, 'employee_id' => $employee_id, 'branch_id' => $branch_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date), true));
        $mPDF1->Output('EOS.pdf', 'I');
    }
    public function actionPrintOvertimeReportPDF() {
        $model = new EmployeeEOS();
        $overtime_from_date = Yii::app()->request->getParam('overtime_from_date');
        $overtime_to_date = Yii::app()->request->getParam('overtime_to_date');
        $emp_id = Yii::app()->request->getParam('emp_id');
        $overtime_emp_sponsor = Yii::app()->request->getParam('overtime_emp_sponsor');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_overtime_report_pdf', array('model' => $model, 'overtime_from_date' => $overtime_from_date, 'overtime_to_date' => $overtime_to_date, 'emp_id' => $emp_id, 'overtime_emp_sponsor' => $overtime_emp_sponsor), true));
        $mPDF1->Output('Overtime.pdf', 'D');
    }
    public function actionPrintEmployeeQualificationReportPdf() {
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.print_employee_qualification_pdf', $_REQUEST, true));
        $mPDF1->Output("employee-qualification-details.pdf", 'D');
    }
    public function actionPrintEmployeeHierarchyListReportPDF() {
        //code added by rahul on 20-7-22//
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $department = Yii::app()->request->getParam('department');
        $functionality_id = Yii::app()->request->getParam('functionality_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_hierarchylist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id, 'functionality_id' => $functionality_id,'department'=>$department), true));
        $mPDF1->Output('Employee Hierarchy List.pdf', 'D');
    }
    public function actionPrintEmployeeSettingsListReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $report_type = Yii::app()->request->getParam('report_type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($report_type == "W") {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_weekend_list_pdf', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), true));
            $mPDF1->Output('Employee Weekend List.pdf', 'D');
        } elseif ($report_type == "B") {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_biometric_list_pdf', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), true));
            $mPDF1->Output('Employee Biometric List.pdf', 'D');
        } elseif ($report_type == "C") {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_contracttype_list_pdf', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), true));
            $mPDF1->Output('Employee Contract Type List.pdf', 'D');
        } elseif ($report_type == "O") {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_overtime_list_pdf', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), true));
            $mPDF1->Output('Employee Overtime List.pdf', 'D');
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_weekend_list_pdf', array('report_type' => $report_type, 'model' => $model, 'Branch' => $Branch, 'employee_id' => $employee_id), true));
            $mPDF1->Output('Employee Weekend List.pdf', 'D');
        }
    }
    public function actionPrintEmployeeTeamListReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $team_name = Yii::app()->request->getParam('team_name');
        $reportman_id = Yii::app()->request->getParam('reportman_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_teamlist_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'team_name' => $team_name, 'reportman_id' => $reportman_id), true));
        $mPDF1->Output('Team List.pdf', 'D');
    }
    public function actionPrintEmployeeBankdetailsReportPDF() {
        $model = new Employee();
        $Branch = Yii::app()->request->getParam('Branch');
        $employee_name = Yii::app()->request->getParam('employee_name');
        $bank_name = Yii::app()->request->getParam('bank_name');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_bankdetails_pdf', array('model' => $model, 'Branch' => $Branch, 'employee_name' => $employee_name, 'bank_name' => $bank_name), true));
        $mPDF1->Output('Bank Details.pdf', 'D');
    }
    public function actionPrintEmployeePunchHistoryReportPDF() {
        $attend_emp_sponsor = Yii::app()->request->getParam('attend_emp_sponsor');
        $emp_id = Yii::app()->request->getParam('emp_id');
        $from_date = Yii::app()->request->getParam('punch_from_date');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.reports.pdf.employee_punch_history_pdf', array('from_date' => $from_date, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor), true));
        $mPDF1->Output('Punch History Details.pdf', 'D');
    }
}
