<?php

class RecruitmentController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetRecruitmentDetails', 'Create', 'Upload', 'getNotesList', 'SaveRecruitment',
                    'deleteRecruitmentdetail', 'downloadDocument', 'GetquestionDetails', 'deleteDocument', 'deleteNote', 'EditNote',
                    'printinterviewletter', 'Printofferletter', 'convert', 'SaveEmployee', 'View', 'sendrecruitmentmail', 'UploadRecruitment',
                    'DownloadRecruitmentformat', 'SaveRecruitmentUpload', 'UploadEmployeecsv', 'PrintCertificate', 'codegenerate'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_recruitment = HrModules::model()->findByPK(13);
        if ($model_module_recruitment->grant_access == 1 && $model_module_recruitment->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_recruitmnt_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetRecruitmentDetails() {

        $model = new HrRecruitment();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'first_name',
            2 => 'email_id',
            3 => 'mobile_no',
            4 => 'post_applied',
            5 => 'years_experience',
            6 => 'expected_salary',
            7 => 'created_date_time',
            8 => 'created_date_time',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (first_name LIKE '%" . $searchString . "%' OR post_applied LIKE '%" . $searchString . "%' OR mobile_no LIKE '%" . $searchString . "%' OR  email_id LIKE '%" . $searchString . "%' OR last_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $model_general_setting = HrGenerelSettings::model()->find();
        foreach ($model as $row) {
            $button_string = "";
             $recruitment_edit =$recruitment_view=$recruitment_print_call=$recruitment_print_offer=$recruitment_convert=$recruitment_send_mail=$recruitment_delete=0;
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_recruitment_edit']) || Yii::app()->user->authorised_user == 1) && $row['convert_status'] == 'N') {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/recruitment/create&id=' . $row['id'] . '\',\'Edit Recruitment Detail \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $recruitment_edit =1;
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_recruitment_view']) || Yii::app()->user->authorised_user == 1)) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="View" onclick="loadPopupModal(\'hr/recruitment/view&id=' . $row['id'] . '\',\'View Recruitment Detail \',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
                $recruitment_view =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_recruitment_print']) || Yii::app()->user->authorised_user == 1) {
                if ($row['interview_date'] != '0000-00-00 00:00:00') {
                    $button_string .= '<a href ="' . Yii::app()->baseUrl . '/index.php?r=hr/recruitment/printinterviewletter&id=' . $this->ciphertext($row['id'], "e")  . '" class="btn btn-primary btn-xs" target="_blank" title="Print Call Letter"><i class="fa fa-print"></i></a>&nbsp;';
                    $recruitment_print_call=1;
                }
                if ($row['offer_letter_date'] != '0000-00-00') {
                    $button_string .= '<a href ="' . Yii::app()->baseUrl . '/index.php?r=hr/recruitment/printofferletter&id=' . $this->ciphertext($row['id'], "e")  . '" class="btn btn-primary btn-xs" target="_blank" title="Print Call Letter"><i class="fa fa-file-pdf-o"></i></a>&nbsp;';
                    $recruitment_print_offer =1;
                //    $button_string .= '<button class="btn btn-primary btn-xs" title="Print & Verify Offer Letter(PDF)" onclick="loadPopupModal(\'hr/recruitment/printcertificate&id=' . $row['id'] . '\',\'PRINT & VERIFY CERTIFICATE \',\'md\')"><i class="fa fa-file-pdf-o"></i></button> &nbsp;';
                    //$button_string .= '<a href ="'.Yii::app()->baseUrl.'/index.php?r=recruitment/printofferletter&id=' . $row['id'] .'" class="btn btn-primary btn-xs" target="_blank" title="Print Offer Letter"><i class="fa fa-print"></i></a>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_recruitment_convert']) || Yii::app()->user->authorised_user == 1) {
                if ($row['offer_letter_date'] != '0000-00-00' && $row['convert_status'] == 'N') {
                    $button_string .= '<button class="btn btn-primary btn-xs" title="Convert to Employee/Approve" onclick="loadPopupModal(\'hr/recruitment/convert&id=' . $row['id'] . '\',\'Convert To Employee \',\'xl\')"><i class="fa fa-retweet"></i></button>&nbsp;';
                    $recruitment_convert=1;
                    }
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_recruitment_send']) || Yii::app()->user->authorised_user == 1) && $row['mail_notifying_employee'] != '' && $row['notifying_status'] == 0 && $model_general_setting->enable_mail == 'Y') {
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="sendrecruitmentmail(' . $row['id'] . ')" title="Send mail to staff regarding interview"><i class="fa fa-mail-forward"></i></a>&nbsp;';
                $recruitment_send_mail =1;
                }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_recruitment_delete']) || Yii::app()->user->authorised_user == 1) && $row['convert_status'] == 'N') {
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleterecruitmentdetail(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
                $recruitment_delete =1;
            }
            $created_date_time = '';
            if ($row['created_date_time'] != '0000-00-00') {
                $created_date_time = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $branch_name = '';
            if ($row['branch_id'] > 0 && $row['convert_status'] == "Y") {
                $branch_name = $row['branch']['branch_or_sponsor_name'];
            }
            $rowData[] = array($m, $row['fullname'], $row['email_id'], $row['mobile_no'], $row['post_applied'], $row['years_experience'], $row['expected_salary'], $created_date_time, $branch_name, array("id"=>$row['id'],'en_id'=>$this->ciphertext($row['id'], "e"),'recruitment_edit'=>$recruitment_edit,'recruitment_view'=>$recruitment_view,'recruitment_print_call'=>$recruitment_print_call,'recruitment_print_offer'=>$recruitment_print_offer,'recruitment_convert'=>$recruitment_convert,'recruitment_send_mail'=>$recruitment_send_mail,'recruitment_delete'=>$recruitment_delete) );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrRecruitment();
        $model_analysis = array(new HrRecruitmentAnalysis());
        $model_documents = array(new HrRecruitmentDocuments());
        $model_note = new HrRecruitmentNote();
        $model_onboard = new HrRecruitmentOnboard();
        $question_count = array(new HrRecruitmentAnalysis());
        $model_onboard_details = new HrMasOnboarding();
        $model_salary = array(new HrRecruitmentSalary());
        $model_mark = new HrRecruitmentAnalysis();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis = HrRecruitmentAnalysis::model()->findAll(array('condition' => 'recruit_id="' . $id . '"'));
            if (empty($model_analysis)) {
                $model_analysis = array(new HrRecruitmentAnalysis());
            }
            $model_salary = HrRecruitmentSalary::model()->findAll(array('condition' => 'recruitment_id="' . $id . '"'));
            if(empty($model_salary)){
                $model_salary = array(new HrRecruitmentSalary());
            }
            $model_documents = HrRecruitmentDocuments::model()->findAll(array('condition' => 'recruit_id="' . $id . '"'));
            if (empty($model_documents)) {
                $model_documents = array(new HrRecruitmentDocuments());
            }
            $model_onboard_details = HrMasOnboarding::model()->findAll();
            $question_count = HrRecruitmentAnalysis::model()->count(array('condition' => 'recruit_id="' . $id . '"'));
            $model_mark = HrRecruitmentAnalysis::model()->find(array('select' => 'sum(score_secured) as score_secured', 'condition' => 'recruit_id="' . $id . '"'));
        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('question_count' => $question_count, 'model' => $model, 'model_onboard_details' => $model_onboard_details, 'model_onboard' => $model_onboard, 'model_analysis' => $model_analysis, 'model_documents' => $model_documents, 'model_note' => $model_note, 'id' => $id, 'model_settings' => $model_settings, 'model_mark' => $model_mark,'model_salary'=>$model_salary), false, true);
    }

    public function actionGetquestionDetails() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_questions = HrQuestions::model()->findAll(array('condition' => 'question_type_id="' . $id . '"'));
        $model_analysis = new HrRecruitmentAnalysis();
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('recruit_questions', array('model_questions' => $model_questions, 'model_analysis' => $model_analysis, 'model_settings' => $model_settings), false, true);
    }

    public function actionSaveRecruitment() {
        $model = new HrRecruitment();
        if (isset($_POST['HrRecruitment'])) {
            if ($_POST['HrRecruitment']['id'] > 0) {
                $id = (int) $_POST['HrRecruitment']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model_certificate_reference_no = HrRecruitment::model()->find(array('select' => 'max(reference_no) as reference_no'));
                if (empty($model_certificate_reference_no) || $model_certificate_reference_no->reference_no == '') {
                    $model_master_certificate = MasCertificate::model()->findByPk(9);
                    $model->reference_no = $model_master_certificate->reference_no;
                } else {
                    $model->reference_no = $model_certificate_reference_no->reference_no + 1;
                }
            }
            $model->attributes = $_POST['HrRecruitment'];
            if (isset($_POST['HrRecruitment']['employee_description'])) {
                $model->employee_description = $_POST['HrRecruitment']['employee_description'];
            }
            if ($_POST['HrRecruitment']['date_of_birth'] != '' && $_POST['HrRecruitment']['date_of_birth'] != '0000-00-00') {
                $model->date_of_birth = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrRecruitment']['date_of_birth'])));
            }
            if ((isset($_POST['HrRecruitment']['employee_rating'])) && ($_POST['HrRecruitment']['employee_rating'] != '')) {
                $model->employee_rating = $_POST['HrRecruitment']['employee_rating'];
            }
            if ($_POST['HrRecruitment']['interview_date'] != '' && $_POST['HrRecruitment']['interview_date'] != '0000-00-00') {
                $model->interview_date = date("Y-m-d H:i", strtotime(str_replace('/', '-', $_POST['HrRecruitment']['interview_date'])));
                $model->interview_call = 1;
                $model->interview_letter = $_POST['interview_letter'];
                if (isset($_POST['HrRecruitment']['mail_notifying_employee']) && count($_POST['HrRecruitment']['mail_notifying_employee']) > 0) {
                    $model->mail_notifying_employee = implode(',', $_POST['HrRecruitment']['mail_notifying_employee']);
                } else {
                    $model->mail_notifying_employee = "";
                }
            }
            if ($_POST['HrRecruitment']['offer_letter_date'] != '' && $_POST['HrRecruitment']['offer_letter_date'] != '0000-00-00') {
                $model->offer_letter_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrRecruitment']['offer_letter_date'])));
                $model->monthly_sales_target = $_POST['HrRecruitment']['monthly_sales_target'];
                $model->minimum_target_cards = $_POST['HrRecruitment']['minimum_target_cards'];
                $model->incentive_card = $_POST['HrRecruitment']['incentive_card'];
            }
            $valid = $model->validate();
            //Adding Analysis Data
            if ((isset($_POST['HrRecruitmentAnalysis'])) && ($_POST['HrRecruitmentAnalysis'][0]['question_id'] != '')) {
                $i = 0;
                foreach ($_POST['HrRecruitmentAnalysis'] as $m => $items) {
                    if ($items['question_id'] != '') {
                        if ($items['id'] > 0) {
                            $model_analysis[$i] = HrRecruitmentAnalysis::model()->findByPK($items['id']);
                            $model_analysis[$i]->updated_by = Yii::app()->user->id;
                            $model_analysis[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $model_analysis[$i] = new HrRecruitmentAnalysis();
                            $model_analysis[$i]->created_by = Yii::app()->user->id;
                            $model_analysis[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_analysis[$i]->question_id = $items['question_id'];
                        $model_analysis[$i]->question = $items['question'];
                        $model_analysis[$i]->answer = $items['answer'];
                        $model_analysis[$i]->score_secured = $items['score_secured'];
                        $valid = $model_analysis[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //End Analysis Data
            //Adding Documents Data
            if ((isset($_POST['HrRecruitmentDocuments'])) && ($_POST['HrRecruitmentDocuments'][0]['document_id'] > 0)) {
                $i = 0;
                foreach ($_POST['HrRecruitmentDocuments'] as $n => $items) {
                    if ($items['document_id'] > 0) {
                        if ($items['id'] > 0) {
                            $model_documents[$i] = HrRecruitmentDocuments::model()->findByPK($items['id']);
                            $model_documents[$i]->updated_by = Yii::app()->user->id;
                            $model_documents[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $model_documents[$i] = new HrRecruitmentDocuments();
                            $model_documents[$i]->created_by = Yii::app()->user->id;
                            $model_documents[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_documents[$i]->document_id = $items['document_id'];
                        $model_documents[$i]->document_no = $items['document_no'];
                        $model_documents[$i]->document_file = $items['document_file'];
                        $valid = $model_documents[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //End Documents Data
            //Adding Notes Data
            if ((isset($_POST['HrRecruitmentNote'])) && ($_POST['HrRecruitmentNote']['recruitment_note'] != '')) {
                $model_note = new HrRecruitmentNote();
                if ($_POST['HrRecruitmentNote']['id'] > 0) {
                    $id = (int) $_POST['HrRecruitmentNote']['id'];
                    $model_note = $model_note->findByPk($id);
                    $model_note->updated_by = Yii::app()->user->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model_note->created_by = Yii::app()->user->id;
                    $model_note->created_date_time = date('Y-m-d H:i:s');
                }
                $model_note->recruitment_note = $_POST['HrRecruitmentNote']['recruitment_note'];
                $model_note->validate() && $valid;
            }
            //End Notes Data
            //Adding boarding Data
            if ((isset($_POST['HrRecruitmentOnboard'][0]['onboard_id']) && isset($_POST['HrRecruitmentOnboard'])) && ($_POST['HrRecruitmentOnboard'][0]['onboard_id'] != '')) {
                $i = 0;
                foreach ($_POST['HrRecruitmentOnboard'] as $m => $items) {
                    if ($items['onboard_id'] != '') {
                        if (!empty($items['id']) && $items['id'] > 0) {
                            $model_onboard[$i] = HrRecruitmentOnboard::model()->findByPK($items['id']);
                            $model_onboard[$i]->updated_by = Yii::app()->user->id;
                            $model_onboard[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $model_onboard[$i] = new HrRecruitmentOnboard();
                            $model_onboard[$i]->created_by = Yii::app()->user->id;
                            $model_onboard[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_onboard[$i]->onboard_id = $items['onboard_id'];
                        $model_onboard[$i]->task = $items['task'];
                        if ($items['task_status'] == 1) {
                            $model_onboard[$i]->task_status = 'Y';
                        } else {
                            $model_onboard[$i]->task_status = 'N';
                        }
                        if ($items['task_done_date'] != '' && $items['task_done_date'] != '0000-00-00') {
                            $model_onboard[$i]->task_done_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['task_done_date'])));
                        }
                        $valid = $model_onboard[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //End On boarding Data
                 //Salary
            if ((isset($_POST['HrRecruitmentSalary'])) && ($_POST['HrRecruitmentSalary'][0]['salary_type'] != '')) {
                foreach ($_POST['HrRecruitmentSalary'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_salary[$i] = HrRecruitmentSalary::model()->findByPK($items['id']);
                        $model_salary[$i]->updated_by = Yii::app()->user->id;
                        $model_salary[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_salary[$i] = new HrRecruitmentSalary();
                        $model_salary[$i]->created_by = Yii::app()->user->id;
                        $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_salary[$i]->recruitment_id = $model->id;
                    $model_salary[$i]->salary_type = $items['salary_type'];
                    $model_salary[$i]->amount = $items['amount'];
                    $valid = $model_salary[$i]->validate() && $valid;
                }
            }
            //End Salary
            if ($valid) {
                $model->save();
                //Save Analysis
                if (!empty($model_analysis)) {
                    foreach ($model_analysis as $eachModel) {
                        $eachModel->recruit_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Save Documents
                if (!empty($model_documents)) {
                    foreach ($model_documents as $eachModel) {
                        $eachModel->recruit_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Adding Notes Data
                if ((isset($_POST['HrRecruitmentNote'])) && ($_POST['HrRecruitmentNote']['recruitment_note'] != '')) {
                    $model_note->recruit_id = $model->id;
                    $model_note->save();
                }
                //Save Documents
                if (!empty($model_onboard)) {
                    foreach ($model_onboard as $eachModel) {
                        $eachModel->recruit_id = $model->id;
                        $eachModel->save();
                    }
                }
                //salary
                if (!empty($model_salary)) {
                    foreach ($model_salary as $eachModel) {
                        $eachModel->recruitment_id = $model->id;
                        $eachModel->save();
                    }
                }
                //
                $jsonData['id'] = $model->id;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = $error3 = $error4 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_analysis) && $model_analysis[0]->question_id != '') {
                    $error2 = json_decode(CActiveForm::validateTabular($model_analysis, '', false), true);
                }
                if (isset($model_documents[0]['document_id']) && $model_documents[0]['document_id'] > 0) {
                    $error3 = json_decode(CActiveForm::validateTabular($model_documents, '', false), true);
                }
                if ((isset($_POST['HrRecruitmentNote'])) && ($_POST['HrRecruitmentNote']['recruitment_note'] != '')) {
                    $error4 = json_decode(CActiveForm::validate($model_note, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiondeletedocument() {
        $id = $_POST['id'];
        $model = HrRecruitmentDocuments::model()->findByPk($id);
        $doc_file = $model->document_file;
        $arr_doc_val = explode(',', $doc_file);
        $status = 0;
        if (count($arr_doc_val) > 1) {
            foreach ($arr_doc_val as $value) {
                $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
                if (unlink($path)) {
                    $status = 1;
                }
            }
            if ($status == 1) {
                HrRecruitmentDocuments::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            if ($doc_file != '') {
                $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $doc_file;
                if (unlink($path)) {
                    HrRecruitmentDocuments::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                } else {
                    $jsonData['status'] = 'error';
                }
            } else {
                HrRecruitmentDocuments::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            }
        }
        echo CJSON::encode($jsonData);
    }

    public function actiongetNotesList() {
        $model = new HrRecruitmentNote();
        $id = $_POST['id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'recruitment_note',
            2 => 'created_date_time',
            3 => 'created_by',
            4 => 'created_by'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "recruit_id = '" . $id . "'";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (recruitment_note LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $created_date_time = '';
            if ($row['created_date_time'] != '0000-00-00') {
                $created_date_time = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $button_string = '';
            $button_string .= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="editnote(' . $row['id'] . ')"><i class="fa fa-edit"></i></a>&nbsp;';
            $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletenote(' . $row['id'] . ')"><i class="fa fa-trash-o"></i></a>&nbsp;';
            $rowData[] = array($m, $row['recruitment_note'], $created_date_time, $row->userdetail->Fullname, $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actiondownloaddocument() {
        $id = Yii::app()->request->getParam('id');
        $document = HrRecruitmentDocuments::model()->findByPk($id);
        $file = $document->document_file;
        $arr_doc_val = explode(',', $file);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/document.zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }

    public function actiondeleteRecruitmentdetail() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = HrRecruitment::model()->findByPk($id);
            if ($model->id) {
                HrRecruitmentAnalysis::model()->deleteAll('recruit_id=:refer_id', array(':refer_id' => $model->id));
                HrRecruitmentNote::model()->deleteAll('recruit_id=:refer_id', array(':refer_id' => $model->id));
                $model_documents = HrRecruitmentDocuments::model()->findAll(array('condition' => 'recruit_id="' . $model->id . '"'));
                foreach ($model_documents as $key => $value) {
                    $doc_file = $value->document_file;
                    $arr_doc_val = explode(',', $doc_file);
                    $status = 0;
                    if (count($arr_doc_val) > 1) {
                        foreach ($arr_doc_val as $value) {
                            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
                            if (unlink($path)) {
                                $status = 1;
                            }
                        }
                        if ($status == 1) {
                            HrRecruitmentDocuments::model()->deleteByPk($value->id);
                        }
                    } else {
                        $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $doc_file;
                        if (unlink($path)) {
                            HrRecruitmentDocuments::model()->deleteByPk($value->id);
                            $jsonData['status'] = 'success';
                        }
                    }
                }
                //end document delete
                $model_analysis_exist = HrRecruitmentAnalysis::model()->findAll(array('condition' => 'recruit_id="' . $model->id . '"'));
                $model_documents_exist = HrRecruitmentDocuments::model()->findAll(array('condition' => 'recruit_id="' . $model->id . '"'));
                $model_note_exist = HrRecruitmentNote::model()->findAll(array('condition' => 'recruit_id="' . $model->id . '"'));
                if (empty($model_analysis_exist) && empty($model_documents_exist) && empty($model_note_exist)) {
                    HrRecruitment::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                } else {
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actiondeleteNote() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new HrRecruitmentNote();
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionEditNote() {
        $id = (int) Yii::app()->request->getParam('id');
        $model_note = HrRecruitmentNote::model()->findByPk($id);
        $jsonData['id'] = $model_note->id;
        $jsonData['note'] = $model_note->recruitment_note;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionPrintinterviewletter() {
        $en_id = Yii::app()->request->getParam('id');
        $id= $this->ciphertext($en_id, "d"); 
        $model = HrRecruitment::model()->findByPk($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.recruitment.interview_letter', array('model' => $model), true));
        $mPDF1->Output('interviewletter.pdf', 'I');
    }

    public function actionPrintofferletter() {
        $en_id = Yii::app()->request->getParam('id');
        $id= $this->ciphertext($en_id, "d"); 
        $model = HrRecruitment::model()->findByPk($id);
        $sign = '';
        if ($model->gender == 1) {
            $sign = 'Mr.';
        } else {
            $sign = 'Ms.';
        }
        $signature_array = array();
        if (isset($_POST['field'])) {
            $signature = $_POST['field'];
            foreach ($signature as $value) {
                $signature_array[] = $value;
            }
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($id > 0) {
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.recruitment.offer_letter_new', array('model' => $model, 'sign' => $sign, 'signature' => $signature_array), true));
        } else {
            $mPDF1->WriteHTML('Error in Printing');
        }
        $mPDF1->Output('offerletter.pdf', 'I');
    }

    public function actionConvert() {
        $model = new Employee();
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($id > 0) {
            $model_recruitment = HrRecruitment::model()->findByPk($id);
            $model_recruit_salary = HrRecruitmentSalary::model()->findAll(array('condition' => 'recruitment_id="' . $id . '"'));
            //Details
            $model->first_name = $model_recruitment->first_name;
            $model->middle_name = $model_recruitment->middle_name;
            $model->last_name = $model_recruitment->last_name;
            $model->gender = $model_recruitment->gender;
            $model->date_join = date("d/m/Y", strtotime($model_recruitment->offer_letter_date));
            $model->date_of_birth = date("d/m/Y", strtotime($model_recruitment->date_of_birth));
            $model->branch_or_sponsor_id = $model_recruitment->branch_id;
            $model->email2 = $model_recruitment->email_id;
            $model->mobile = $model_recruitment->mobile_no;
            $model_general_setting = HrGenerelSettings::model()->find();
            if ($model_general_setting->auto_increment_employee_code == 'Y') {
                $model->employee_code = $this->autoemployeecode($model_recruitment->branch_id);
            }
            $post_applied = $model_recruitment->post_applied;
            if ($post_applied != '') {
                $condition = '((REPLACE(`designation_name`, " ", "") LIKE "%' . str_replace(' ', '', $post_applied) . '%") AND isActive ="Y")';
                $model_designation = MasDesignation::model()->find(array('select' => 'id', 'condition' => $condition));
                $model->designation = $model_designation->id;
            }
            if(!empty($model_recruit_salary)){
                foreach ($model_recruit_salary as $i => $items) {
                    $model_salary[$i] = new EmployeeSalary();
                    $model_salary[$i]->salary_type= $items['salary_type'];
                    $model_salary[$i]->amount = $items['amount'];
                    $model_salary[$i]->valid_from = date("d/m/Y", strtotime($model_recruitment->offer_letter_date));
                    $model_salary[$i]->created_by = Yii::app()->user->id;
                    $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                }
            }
        }
        $this->renderPartial('create_employee', array('model' => $model, 'model_recruitment' => $model_recruitment, 'model_general_setting' => $model_general_setting,'model_salary'=>$model_salary), false, true);
    }

    public function actionSaveEmployee() {
        if (isset($_POST['Employee'])) {
            //Employee Details
            date_default_timezone_set("Asia/Dubai");
            $model = new Employee();
            $model->attributes = $_POST['Employee'];
            $model->scenario = 'add';
            $model->employee_code = $this->ciphertext(trim($_POST['Employee']['employee_code']), "e");
            $model->hr_code = trim($_POST['Employee']['employee_code']);
            $model->first_name = $this->ciphertext(trim($_POST['Employee']['first_name']), "e");
            $model->last_name = $this->ciphertext(trim($_POST['Employee']['last_name']), "e");
            $model->de_first_name = trim($_POST['Employee']['first_name']) . ' ' . trim($_POST['Employee']['last_name']);
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->user_name = $_POST['Employee']['employee_code'];
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $password = crypt($_POST['Employee']['employee_code'], $salt);
            $model->password = $password;
            if ($_POST['Employee']['date_join'] != '0000-00-00' && $_POST['Employee']['date_join'] != '') {
                $model->date_join = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Employee']['date_join'])));
            }
            if ($_POST['Employee']['date_of_birth'] != '0000-00-00' && $_POST['Employee']['date_of_birth'] != '') {
                $model->date_of_birth = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Employee']['date_of_birth'])));
            }
            $model->gender = $_POST['Employee']['gender'];
            $model->email2 = $_POST['Employee']['email2'];
            $model->mobile = $_POST['Employee']['mobile'];
            $valid =$model->validate();
            if ((isset($_POST['EmployeeSalary'])) && ($_POST['EmployeeSalary'][0]['salary_type'] != '')) {
                foreach ($_POST['EmployeeSalary'] as $i => $items) {
                    $model_salary[$i] = new EmployeeSalary();
                    $model_salary[$i]->created_by = Yii::app()->user->id;
                    $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                    $model_salary[$i]->employee_id = 0;
                    $model_salary[$i]->salary_type = $items['salary_type'];
                    $model_salary[$i]->amount = $items['amount'];
                    if ($items['valid_from'] != '' && $items['valid_from'] != '0000-00-00') {
                        $items['valid_from'] = str_replace('/', '-', $items['valid_from']);
                        $model_salary[$i]->valid_from = date("Y-m-d", strtotime($items['valid_from']));
                    }
                    $valid = $model_salary[$i]->validate() && $valid;
                }
            }
            if ($valid) {
                $model->save();
                $model_documents = HrRecruitmentDocuments::model()->findAll(array('condition' => 'recruit_id="' . $_POST['recruitment_id'] . '"'));
                if (!empty($model_documents)) {
                    foreach ($model_documents as $i => $items) {
                        $model_document[$i] = new EmployeeDocuments();
                        $model_document[$i]->scenario = 'add';
                        $model_document[$i]->document_id = $items['document_id'];
                        $model_document[$i]->document_number = $items['document_no'];
                        $model_document[$i]->document_file = $items['document_file'];
                        $model_document[$i]->employee_id = $model->id;
                        $model_document[$i]->save(false);
                    }
                }
                if (!empty($model_salary)) {
                    foreach ($model_salary as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Branch
                $model_branch = new EmployeeBranch();
                $model_branch->employee_id = $model->id;
                $model_branch->branch_id = $model->branch_or_sponsor_id;
                $model_branch->from_date = $model->date_join;
                $model_branch->save(false);
                //End Branch
                //Department
                $model_department = new EmployeeDepartment();
                $model_department->employee_id = $model->id;
                $model_department->department_id = $model->department;
                $model_department->from_date = $model->date_join;
                $model_department->save(false);
                //End Department
                //Designation
                $model_designation = new EmployeeDesignation();
                $model_designation->employee_id = $model->id;
                $model_designation->designation_id = $model->designation;
                $model_designation->from_date = $model->date_join;
                $model_designation->save(false);
                //End Designation
                $model_user = new User();
                $model_user->password = $model->password;
                $model_user->username = $model->user_name;
                $model_user->first_name = $_POST['Employee']['first_name'];
                $model_user->last_name = $_POST['Employee']['last_name'];
                $model_user->company_id = Yii::app()->user->master_user_company_id;
                $model_user->subledger_added = "N";
                $model_user->user_group_id = 37;
                $model_user->employee_id = $model->id;
                $model_user->designation = $model->designationdetail->designation_name;
                $model_user->level = 2;
//                $model_user->is_lead_owner = $model->is_lead_owner;
                $model_user->created_by = Yii::app()->user->id;
                $model_user->created_date_time = date('Y-m-d H:i:s');
                $model_user->save(false);
                HrRecruitment::model()->updateByPK($_POST['recruitment_id'], array('convert_status' => 'Y'));
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionView() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrRecruitment();
        $model_note = new HrRecruitmentNote();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_analysis = HrRecruitmentAnalysis::model()->findAll(array('condition' => 'recruit_id="' . $id . '"'));
            $model_documents = HrRecruitmentDocuments::model()->with('document')->findAll(array('condition' => 'recruit_id="' . $id . '"'));
            $model_mark = HrRecruitmentAnalysis::model()->find(array('select' => 'sum(score_secured) as score_secured', 'condition' => 'recruit_id="' . $id . '"'));
            $question_count = HrRecruitmentAnalysis::model()->count(array('condition' => 'recruit_id="' . $id . '"'));
            $model_recruit_salary = HrRecruitmentSalary::model()->findAll(array('condition' => 'recruitment_id="' . $id . '"'));

        }
        $model_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('view', array('question_count' => $question_count, 'model' => $model, 'model_analysis' => $model_analysis, 'model_documents' => $model_documents, 'model_note' => $model_note, 'id' => $id, 'model_settings' => $model_settings, 'model_mark' => $model_mark,'model_recruit_salary'=>$model_recruit_salary), false, true);
    }

    public function actionsendrecruitmentmail() {
        $id = (int) Yii::app()->request->getParam('id');
        //Mail Setting
        $model = HrRecruitment::model()->findByPK($id);
        $interview_date = '';
        if ($model->interview_date != '0000-00-00' && $model->interview_date != '') {
            $interview_date = date("d/m/Y H:i", strtotime($model->interview_date));
        }
        $notifying_employee = $model->mail_notifying_employee;
        $content = 'An interview is scheduled on ' . $interview_date . '.Please do the necessary arrangements.';
        $view = 'notification';
        $subject = 'Notification Regarding Interview Schedule';
        //start Mail Content
        $mailContent= '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">
                            <div>Dear Sir/Madam,</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Sub: Notification Regarding Interview Schedule</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">'
                . $content . '<br>
                            <br>
                            <br>
                            Thanking you,
                            <br>
                            <br>
                            Yours sincerely,
                            <br>
                            <br>
                            HR Department
                        </td>
                    </tr>
                </tbody>
            </table>';
        ////End Mail Content
        $notifyingemployee = array();
        $sent_mail_id=array();
        if ($notifying_employee != '') {
            $notifyingemployee = explode(',', $notifying_employee);
            $m = 0;
            foreach ($notifyingemployee as $emp_id) {
                $model_mail = Employee::model()->findByPK($emp_id);
                if (filter_var($model_mail->email, FILTER_VALIDATE_EMAIL)) {
                    $sent_mail_id[]=$model_mail->email;
                }
            }
        }
        if(count($sent_mail_id)>0){
            $model_general_setting = HrGenerelSettings::model()->find();
            $from=$model_general_setting->from_mail_id;
            $from_name=$model_general_setting->from_mail_name;
            $toRecipient = ['email' => array_shift($sent_mail_id)]; 
            $ccRecipients = [];
            if(!empty($sent_mail_id)){
                foreach ($sent_mail_id as $email_id) {
                    $ccRecipients[] = ['email' => $email_id];
                }
            }
            $mail_body = Yii::app()->controller->renderPartial('application.views.mail.'.$view, [
                'branch_id'=>0,
                'message' => $mailContent,
                'title'=>$subject   
            ], true);
            $response = Yii::app()->sendGrid->sendEmail(
                $toRecipient, // To Mail
                ['email' => $from, 'name' => $from_name],     // From
                $subject,  // Subject
                $mail_body, // Body
                $ccRecipients //CC MAil
            );
            if ($response) {
                HrRecruitment::model()->updateByPK($id, array('notifying_status' => 1));
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionUploadRecruitment() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_recruitment', array(), false, true);
    }

    public function actionDownloadRecruitmentformat() {
        $filename = 'recruitment_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'First Name *,Middle Name,Last Name,Gender,Date of Birth(YYYY-mm-dd)*,Email ID*,Mobile No*,Post Applied*,Expected Salary*,Experience*';
        Yii::app()->end();
    }

    public function readEmployeeCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    public function actionSaveRecruitmentUpload() {
        $file_name = Yii::app()->request->getParam('filename');
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/employee_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/employee_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate = TRUE;
        $error_list = array();
        $recruitment_list = $this->readEmployeeCSV("uploads/employee_csv/" . $file_name);
        foreach (array_slice($recruitment_list, 1) as $i => $data) {
            if (!empty($data[0]) || !empty($data[1]) || !empty($data[2]) || !empty($data[3]) || !empty($data[4]) || !empty($data[5]) || !empty($data[6]) || !empty($data[7]) || !empty($data[8]) || !empty($data[9])) {
                $model_recruitment[$i] = new HrRecruitment();
                $model_recruitment[$i]->scenario = "excelupload";
                $model_recruitment[$i]->first_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                $model_recruitment[$i]->middle_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                $model_recruitment[$i]->last_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                if (strtoupper(str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"')))) == "MALE" || $data[3] == 1) {
                    $gender[$i] = 1;
                } elseif (strtoupper(str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"')))) == "FEMALE" || $data[3] == 2) {
                    $gender[$i] = 2;
                } else {
                    $gender[$i] = 0;
                }
                $model_recruitment[$i]->gender = $gender[$i];
                if ($data[4] != '') {
                    $model_recruitment[$i]->date_of_birth = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[4]), '"'));
                } else {
                    $model_recruitment[$i]->date_of_birth = '';
                }
                $model_recruitment[$i]->email_id = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[5]), '"'));
                $model_recruitment[$i]->mobile_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[6]), '"'));
                $model_recruitment[$i]->post_applied = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[7]), '"'));
                $model_recruitment[$i]->expected_salary = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[8]), '"'));
                $model_recruitment[$i]->years_experience = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[9]), '"'));
                $model_recruitment[$i]->created_by = Yii::app()->user->id;
                $model_recruitment[$i]->created_date_time = date('Y-m-d H:i:s');
                $validate = $model_recruitment[$i]->validate() && $validate;
            }
        }
        if ($validate) {
            if (!empty($model_recruitment)) {
                foreach ($model_recruitment as $eachModel) {
                    $eachModel->save();
                }
                $jsonData['error'] = "";
            }
        } else {
            if (!empty($model_recruitment)) {
                foreach ($model_recruitment as $s => $data_model) {
                    $error_list[$s]['first_name'] = $data_model['first_name'];
                    $error_list[$s]['middle_name'] = $data_model['middle_name'];
                    $error_list[$s]['last_name'] = $data_model['last_name'];
                    if ($data_model['gender'] == 1) {
                        $error_list[$s]['gender'] = 'Male';
                    } else {
                        $error_list[$s]['gender'] = 'Female';
                    }
                    $error_list[$s]['date_of_birth'] = $data_model['date_of_birth'];
                    $error_list[$s]['email_id'] = $data_model['email_id'];
                    $error_list[$s]['mobile_no'] = $data_model['mobile_no'];
                    $error_list[$s]['post_applied'] = $data_model['post_applied'];
                    $error_list[$s]['expected_salary'] = $data_model['expected_salary'];
                    $error_list[$s]['years_experience'] = $data_model['years_experience'];
                    if ($data_model->validate()) {
                        $error_list[$s]['remarks'] = "correct";
                    } else {
                        $error_list[$s]['remarks'] = $data_model->getErrors();
                    }
                }
            }
        }

        $j = 0;
        fclose($file);
        $list = array();
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'First Name *,Middle Name,Last Name,Gender,Date of Birth(YYYY-mm-dd)*,Email ID*,Mobile No*,Post Applied*,Expected Salary*,Experience*';
            foreach ($error_list as $i => $error_detail) {


                if (!empty($error_detail)) {
                    if (!empty($error_detail['remarks'])) {
                        $error_view[$i] = '';
                        foreach ($error_detail['remarks'] as $p => $error_value) {
                            $error_view[$i] .= $error_value[0] . " / ";
                        }
                    } else {
                        $error_view[$i] .= '';
                    }
                    $list[$j++] = $error_detail['first_name'] . ',' . $error_detail['middle_name'] . ',' . $error_detail['last_name'] . ',' . $error_detail['gender'] . ',' . $error_detail['date_of_birth'] . ',' . $error_detail['email_id'] . ',' . $error_detail['mobile_no'] . ',' . $error_detail['post_applied'] . ',' . $error_detail['expected_salary'] . ',' . $error_detail['years_experience'] . ',' . $error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }


        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('employee/DownloadErrorCsv', 'id' => $file_name), array('target' => '_blank',
                    'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                    . ''
        ));
        echo CJSON::encode($jsonData);
    }

    public function actionPrintCertificate() {
        $id = Yii::app()->request->getParam('id');
        //id of offer letter in mascertificate
        $model = MasCertificate::model()->findByPk(9);
        $model_recruitment = HrRecruitment::model()->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('print_certificate', array('model' => $model, 'model_recruitment' => $model_recruitment), false, true);
    }

    public function actioncodegenerate() {
        $branch = (int) Yii::app()->request->getParam('branch');
        $new_employee_code = '';
        $model_general_setting = HrGenerelSettings::model()->find();
        if ($model_general_setting->use_hr_code_increment_employee_code == 'Y' && $model_general_setting->auto_increment_employee_code == 'Y') {
            $model_branch = MasCompanyBranchSponsor::model()->findbyPk($branch);
            $hr_code = $model_branch->hr_code;
            $code_len = strlen($hr_code);
            $next_len = $code_len + 1;
            $model_employee = Employee::model()->find(array('select' => 'MAX(CAST(SUBSTRING(hr_code,' . $next_len . ', length(hr_code)-' . $code_len . ') AS UNSIGNED)) as employee_code,MAX(hr_code) as hr_code', 'condition' => '(SUBSTRING(hr_code,1,' . $code_len . ') ="' . $hr_code . '")'));
            $new_no = '0001';
            if ($model_employee['employee_code'] != '') {
                if (!empty($model_employee) && $model_employee['hr_code'] != '' && preg_match('/^([A-Za-z]+)(\d+)$/', $model_employee->hr_code, $matches)) {
                    $prefix = $matches[1];
                    $current_no = $matches[2];
                    $no_count = strlen($current_no);
                }
                $new_no = $model_employee['employee_code'] + 1;
                $new_no_count = strlen($new_no);
                if ($new_no_count < $no_count) {
                    $new_no = str_pad($new_no, $no_count, '0', STR_PAD_LEFT);
                }
            }
            $new_employee_code = $hr_code . '' . $new_no;
        } else if ($model_general_setting->auto_increment_employee_code == 'Y') {
            $model_employee = Employee::model()->find(array('select' => 'MAX(CAST(hr_code AS UNSIGNED)) AS hr_code'));
            $new_no = '0001';
            if ($model_employee['hr_code'] != '') {
                $new_no = $model_employee['hr_code'] + 1;
            }
            if ((int) $new_no < 1000) {
                $new_no = str_pad($new_no, 4, '0', STR_PAD_LEFT);
            }
            $new_employee_code = $new_no;
        } else {
            $model_employee = Employee::model()->find(array('select' => 'MAX(hr_code) as hr_code', 'condition' => 'branch_or_sponsor_id="' . $branch . '"'));
            $new_no = '0001';
            $matches = array();
            if (!empty($model_employee) && $model_employee['hr_code'] != '' && preg_match('/^([A-Za-z]+)(\d+)$/', $model_employee->hr_code, $matches)) {
                $prefix = $matches[1];
                $current_no = $matches[2];
                $no_count = strlen($current_no);
                $num_current_no = (int) $current_no;
                $new_no = $num_current_no + 1;
                $new_no_count = strlen($new_no);
                if ($new_no_count < $no_count) {
                    $new_no = str_pad($new_no, $no_count, '0', STR_PAD_LEFT);
                }
                $new_employee_code = $prefix . $new_no;
            } else if (!empty($model_employee) && $model_employee['hr_code'] != '') {
                $no_count = strlen($model_employee['hr_code']);
                $num_current_no = (int) $model_employee['hr_code'];
                $new_no = $num_current_no + 1;
                $new_no_count = strlen($new_no);
                if ($new_no_count < $no_count) {
                    $new_no = str_pad($new_no, $no_count, '0', STR_PAD_LEFT);
                }
                $new_employee_code = $new_no;
            } else {
                $model_branch_or_sponsor = MasCompanyBranchSponsor::model()->findbyPK($branch);
                $prefix = $model_branch_or_sponsor->hr_code;
                $new_employee_code = $prefix . $new_no;
            }
        }
        $jsonData['code'] = $new_employee_code;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function autoemployeecode($branch) {
        $new_employee_code = '';
        $model_general_setting = HrGenerelSettings::model()->find();
        if ($model_general_setting->use_hr_code_increment_employee_code == 'Y' && $model_general_setting->auto_increment_employee_code == 'Y') {
            $model_branch = MasCompanyBranchSponsor::model()->findbyPk($branch);
            $hr_code = $model_branch->hr_code;
            $code_len = strlen($hr_code);
            $next_len = $code_len + 1;
            $model_employee = Employee::model()->find(array('select' => 'MAX(CAST(SUBSTRING(hr_code,' . $next_len . ', length(hr_code)-' . $code_len . ') AS UNSIGNED)) as employee_code,MAX(hr_code) as hr_code', 'condition' => '(SUBSTRING(hr_code,1,' . $code_len . ') ="' . $hr_code . '")'));
            $new_no = '0001';
            if ($model_employee['employee_code'] != '') {
                if (!empty($model_employee) && $model_employee['hr_code'] != '' && preg_match('/^([A-Za-z]+)(\d+)$/', $model_employee->hr_code, $matches)) {
                    $prefix = $matches[1];
                    $current_no = $matches[2];
                    $no_count = strlen($current_no);
                }
                $new_no = $model_employee['employee_code'] + 1;
                $new_no_count = strlen($new_no);
                if ($new_no_count < $no_count) {
                    $new_no = str_pad($new_no, $no_count, '0', STR_PAD_LEFT);
                }
            }
            $new_employee_code = $hr_code . '' . $new_no;
        } else if ($model_general_setting->auto_increment_employee_code == 'Y') {
            $model_employee = Employee::model()->find(array('select' => 'MAX(CAST(hr_code AS UNSIGNED)) AS hr_code'));
            $new_no = '0001';
            if ($model_employee['hr_code'] != '') {
                $new_no = $model_employee['hr_code'] + 1;
            }
            if ((int) $new_no < 1000) {
                $new_no = str_pad($new_no, 4, '0', STR_PAD_LEFT);
            }
            $new_employee_code = $new_no;
        } else {
            $model_employee = Employee::model()->find(array('select' => 'MAX(hr_code) as hr_code', 'condition' => 'branch_or_sponsor_id="' . $branch . '"'));
            $new_no = '0001';
            $matches = array();
            if (!empty($model_employee) && $model_employee['hr_code'] != '' && preg_match('/^([A-Za-z]+)(\d+)$/', $model_employee->hr_code, $matches)) {
                $prefix = $matches[1];
                $current_no = $matches[2];
                $no_count = strlen($current_no);
                $num_current_no = (int) $current_no;
                $new_no = $num_current_no + 1;
                $new_no_count = strlen($new_no);
                if ($new_no_count < $no_count) {
                    $new_no = str_pad($new_no, $no_count, '0', STR_PAD_LEFT);
                }
                $new_employee_code = $prefix . $new_no;
            } else if (!empty($model_employee) && $model_employee['hr_code'] != '') {
                $no_count = strlen($model_employee['hr_code']);
                $num_current_no = (int) $model_employee['hr_code'];
                $new_no = $num_current_no + 1;
                $new_no_count = strlen($new_no);
                if ($new_no_count < $no_count) {
                    $new_no = str_pad($new_no, $no_count, '0', STR_PAD_LEFT);
                }
                $new_employee_code = $new_no;
            } else {
                $model_branch_or_sponsor = MasCompanyBranchSponsor::model()->findbyPK($branch);
                $prefix = $model_branch_or_sponsor->hr_code;
                $new_employee_code = $prefix . $new_no;
            }
        }
        return $new_employee_code;
    }

}
