<?php

class PurchaseproductController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','ApprovepurchaseRequest','SaveApprovePurchase','Create','SaveProductRequest','viewrequest',
                    'CancelpurchaseRequest','SaveCancelPurchase','loadmasterbranch','getemployeedetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_purchase = HrModules::model()->findByPK(16);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_product_purchase_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_purchase->grant_access == 1 && $model_module_purchase->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch =$this->ciphertext($en_id,"d");
            if($branch!=''){
                $model = new EmployeePurchase();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model,'branch'=>$branch));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new EmployeePurchase();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
       // $status = $_POST['status'];
        $employee_id =$_POST['employee_id'];
        $branch_id=$_POST['branch_id'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'apply_date',
            4 => 'payment_mode',
            5 => 'grand_total',
            6 => 'status',
            7 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // if(isset($columns[$_POST['order'][1]['column']]) && $columns[$_POST['order'][1]['column']]!='' && $_POST['order'][1]['dir']!='' ){
        //     $filterColumn1 = $columns[$_POST['order'][1]['column']];
        //     $filterOrder1 = $_POST['order'][1]['dir'];
        //     $orderBy.=','.$filterColumn1 . " " . $filterOrder1;
        // }
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_purchase=EmployeePurchase::getPendingapproval($branch_id,1);
        $condition = "employeedetail.branch_or_sponsor_id='".$branch_id."'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' AND employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_purchase.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (status IN(".$status.") OR t.id IN(".$pending_purchase."))";
            }
        }
        if($employee_id!=''){
             $condition.= ' AND t.employee_id="'.$employee_id.'"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.= " AND (payment_mode LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $apply_date ="";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            $paymen_mode=array(1=>'Cash',2=>'From Salary');
            $button_string="";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($next_approval_level<=(!empty($row->max_level))){
                if($next_approval_level==1 && $row->approvelevel->level_1_type=='H' && $row->approvelevel->level_1_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && $row->approvelevel->level_2_type=='H' && $row->approvelevel->level_2_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && $row->approvelevel->level_3_type=='H' && $row->approvelevel->level_3_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && $row->approvelevel->level_4_type=='H' && $row->approvelevel->level_4_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && $row->approvelevel->level_5_type=='H' && $row->approvelevel->level_5_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if($next_approval_level==!empty($row->max_level)){
                $final_level='Y';
            }
            $approve_reject =$view_purchase=$cancel_purchase=$direct_approval=0;
            if($show_approve_button==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_product_purchase_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-success btn-xs" title="Approve/Reject Purchase Request" onclick="loadPopupModal(\'hr/purchaseproduct/approvepurchaserequest&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Purchase Request\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                    $approve_reject=1;
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_product_purchase_view'])  || Yii::app()->user->authorised_user == 1) {
                if ($row['status']!= 1) {
                    $button_string.= '<button class="btn btn-info btn-xs" title="View Purchase Details" onclick="loadPopupModal(\'hr/purchaseproduct/viewrequest&id=' . $row['id'] . '\',\'View Purchase Request\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';           
                    $view_purchase=1;
                }
            }
            if ($row['status']==12) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_product_purchase_cancel'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-danger btn-xs" title="Cancel Purchase Request" onclick="loadPopupModal(\'hr/purchaseproduct/cancelpurchaserequest&id=' . $row['id'] . '\',\'Cancel Purchase Request\',\'lg\')"><i class="fa fa-remove"></i></button>&nbsp;';       
                    $cancel_purchase=1;
                }
            }
            if ($row['status']==1 || $row['status']==2 || $row['status']==4 || $row['status']==6 || $row['status']==8 || $row['status']==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_admin_loan_details_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $last_level=$row['max_level'];
                      $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/purchaseproduct/approvepurchaserequest&final_level=Y&level='.$last_level.'&id=' . $row['id'] . '\',\'Approve/Reject Purchase Request\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                      $direct_approval =1;
                }
            }
            $rowData[] = array($m,$row['employeedetail']['employeecode'],$row['employeedetail']['employeefullname'],$apply_date,$paymen_mode[$row['payment_mode']],$row['grand_total'],EmployeePurchase::getStatus($row['status']),array('id'=>$row['id'],'final_level'=>$final_level,'level'=>$level_no,'approve_reject'=>$approve_reject,'view_purchase'=>$view_purchase,'cancel_purchase'=>$cancel_purchase,'direct_approval'=>$direct_approval));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionApprovepurchaseRequest() {
        $model = new EmployeePurchase();
        $id = (int) Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model=$model->findByPk($id);
            $model_detail= EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="'. $id.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_purchase_request_approve', array('model' => $model,'model_detail' => $model_detail,'level'=>$level,'final_level'=>$final_level));
    }
    public function actionSaveApprovePurchase() {
        if (isset($_POST['EmployeePurchase'])) {
            if ((int) @$_POST['EmployeePurchase']['id'] > 0) {
                $model = EmployeePurchase::model()->findByPK($_POST['EmployeePurchase']['id']);
                $model->id = (int) $_POST['EmployeePurchase']['id'];
                $model->scenario = 'update';
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                unset($_POST['EmployeePurchase']['id']);
                $model->scenario = 'add';
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->status = $_POST['EmployeePurchase']['status'];
            $model->last_approved_level = $_POST['EmployeePurchase']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            $level= $_POST['approval_level'];
            $final_level= $_POST['final_level']; 
            if($level==1 && $final_level=='N'){
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            }else if($level==2 && $final_level=='N'){
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            }else if($level==3 && $final_level=='N'){
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            }else if($level==4 && $final_level=='N'){
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            }else if($level==5 && $final_level=='N'){
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if($final_level=='Y'){
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="29"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController');
                         MailController::sendmail(29,$model->employee_id,$model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionCreate(){
        $id=(int) Yii::app()->request->getParam('id');
        $branch=(int) Yii::app()->request->getParam('branch');
        $model=new EmployeePurchase(); 
        $model_detail=array(new EmployeePurchaseDetail());  
        if($id>0){
            $model=$model->findByPk($id);
            $model_detail= EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="'. $id.'"'));
            if(empty($model_detail)){
                $model_detail=array(new EmployeePurchaseDetail()); 
            } 
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_detail' => $model_detail,'branch' => $branch), false, true);
    }
    public function actionGetproductdetails(){
        $product_id = $_POST['product_id'];
        $model_product=HrMasProduct::model()->findbyPK($product_id);
        $jsonData['cost_price'] = $model_product->cost_price;   
        $jsonData['selling_price'] = $model_product->selling_price;   
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);  
    }
    public function actionSaveProductRequest() {
        if (isset($_POST['EmployeePurchase'])) {
            $valid = true;
            $other = array();
            $model= new EmployeePurchase();  
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeePurchase']['id'] > 0) {                
                $model = EmployeePurchase::model()->findByPK($_POST['EmployeePurchase']['id']);
                $model->id = (int) $_POST['EmployeePurchase']['id'];         
                $model->scenario = 'update';
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date= date('Y-m-d');
                
            }
            $model->attributes = $_POST['EmployeePurchase'];   
            $model->status=$_POST['EmployeePurchase']['status'];   
            $model->function_type =$_POST['EmployeePurchase']['function_type'];
            $model->last_approved_level =$_POST['EmployeePurchase']['last_approved_level'];  
             //Employee ID
            $employee_id = $_POST['EmployeePurchase']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="8"'));
            if (!empty($model_master_approve_setting)) {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $status=$_POST['EmployeePurchase']['status'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            if($status==12){
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = 'Auto Approval';
                $model->approved_by =$approved_employee_id;//HR Login
            }
            $valid=$model->validate() && $valid;
            foreach ($_POST['EmployeePurchaseDetail'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model_detail[$i] = EmployeePurchaseDetail::model()->findByPK($items['id']);
                    $model_detail[$i]->updated_by = Yii::app()->user->id;
                    $model_detail[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model_detail[$i] = new EmployeePurchaseDetail();
                    $model_detail[$i]->created_by = Yii::app()->user->id;
                    $model_detail[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                $model_detail[$i]->product_id = $items['product_id'];
                $model_detail[$i]->quantity = $items['quantity'];
                $model_detail[$i]->cost = $items['cost'];
                $model_detail[$i]->amount = $items['amount'];
                $model_detail[$i]->total_amount = $items['total_amount'];
                $valid = $model_detail[$i]->validate() && $valid;
            }
            if ($valid) {
                $model->save();
                if (!empty($model_detail)) {
                    foreach ($model_detail as $eachModel) {
                        $eachModel->purchase_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Mail
                if($status==12){
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="29"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                             Yii::import('application.modules.hr.controllers.MailController');
                             MailController::sendmail(29,$model->employee_id,$model->id);
                        }
                    }
                }else{
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="28"'));
                    if(!empty($model_settings) && !empty($model_mail_settings)){
                        if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                             Yii::import('application.modules.hr.controllers.MailController');
                             MailController::sendmail(28,$model->employee_id,$model->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = json_decode(CActiveForm::validateTabular($model_detail, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionRemoveproductPurchase(){
        $id = $_POST['id'];
        if($id>0){
            EmployeePurchaseDetail::model()->deleteByPk($id);
            $status['status'] = 'success';
        }else{
           $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }
    public function actionViewRequest() {
        $id = Yii::app()->request->getparam("id");
        $model = EmployeePurchase::model()->findbyPk($id);
        $model_detail= EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="'. $id.'"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_request', array('model' => $model,'model_detail'=>$model_detail), false, true);
    }
    public function actionCancelpurchaseRequest() {
        $model = new EmployeePurchase();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model=$model->findByPk($id);
            $model_detail= EmployeePurchaseDetail::model()->findAll(array('condition' => 'purchase_id="'. $id.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('cancel_purchase_request', array('model' => $model,'model_detail' => $model_detail));
    }
    public function actionSaveCancelPurchase() {        
        if (isset($_POST['EmployeePurchase'])) {
            date_default_timezone_set("Asia/Dubai");
            EmployeePurchase::model()->updateByPK($_POST['EmployeePurchase']['id'], array('status' =>$_POST['EmployeePurchase']['status'],'cancel_reason' =>$_POST['EmployeePurchase']['cancel_reason'],'updated_by'=>Yii::app()->user->id,'updated_date_time'=>date('Y-m-d H:i:s')));            
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData); 
        }
    }
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
    public function actiongetemployeedetails() {
        $employee = Yii::app()->request->getparam("id");
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee.'" and functionality_id="8"'));
        $functiontype=$model_master_approve_setting->id;
        $jsonData['functiontype'] = $functiontype;
        $jsonData['maxlevel'] = $model_master_approve_setting->max_level;
        echo CJSON::encode($jsonData);
    }
}
