<?php
//created by DR on 6/10/2022
class PullattendanceController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('PullBiometricAttendance','UpdateAttendance','latemail'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(''),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionPullBiometricAttendance() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=cumulush_2022_hr_casio'; 
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        Yii::app()->db2->connectionString = 'mysql:host=sql366.main-hosting.eu;dbname=u574074885_hr_attendance;port=3306'; 
        Yii::app()->db2->setActive(true);
        $date_from=date('Y-m-d', strtotime('-1 days', strtotime(date("Y-m-d"))));
        for($ls=0;$ls<=1;$ls++){
            if($ls>0){
                $date_from=date('Y-m-d', strtotime('+1 day', strtotime($date_from)));
            }
            $weekvalue=date('w', strtotime($date_from)); 
            $weekvalue+=1;
            $day='';
            if ($weekvalue == 1) {
                $day = "Sunday";
            } else if ($weekvalue == 2) {
                $day = "Monday";
            } else if ($weekvalue == 3) {
                $day = "Tuesday";
            } else if ($weekvalue == 4) {
                $day = "Wednesday";
            } else if ($weekvalue == 5) {
                $day = "Thursday";
            } else if ($weekvalue == 6) {
                $day = "Friday";
            } else if ($weekvalue == 7) {
                $day = "Saturday";
            }
            $sql_query= "Select * from hr_attendance where DATE(punch_date)='".$date_from."' AND (device_serial='AEWU200260017' OR device_serial='AEWU193960024')";
            $model_attendance_pushed = Yii::app()->db2->createCommand($sql_query)->queryAll();
            foreach ($model_attendance_pushed as $key => $value) {
                $emp_no=$value['employee_id'];
                $in=date("H:i",strtotime($value['punch_date']));
                $out=date("H:i",strtotime($value['punch_date']));
                $model = Employee::model()->find(array('condition' => 'employee_biometric_code="' . $emp_no . '" and t.isActive!="B" ')); 
                if (!empty($model)) {
                    $weekend=0;
                    $weektype='';
                    $model_attendance_1 = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $model->id . '" and attendance_date="' . $date_from . '"'));
                    if ($model->weekend_off1 == $weekvalue) {
                        $weekend=1;
                        $weektype=$model->weekend_off1_type;
                    }
                    if ($model->weekend_off2 == $weekvalue) {
                        $weekend=1;
                        $weektype=$model->weekend_off2_type;
                    }
                    if ($model->weekend_off3 == $weekvalue) {
                        $weekend=1;
                        $weektype=$model->weekend_off3_type;
                    }
                    $order_manhours=0;
                    if (empty($model_attendance_1)) {
                        $model_attendance = new EmployeeAttendance();
                        $model_attendance->created_by = Yii::app()->user->id;
                        $model_attendance->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance->login_time ='00:00';
                        $model_attendance->logout_time ='00:00';
                        $order_manhours=0;
                    } else {
                        $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_1->id);
                        $model_attendance->updated_by = Yii::app()->user->id;
                        $model_attendance->updated_date_time = date('Y-m-d H:i:s');
                        $order_manhours=$model_attendance->order_manhours;
                    }

                    $model_attendance->employee_id = $model->id;
                    $model_attendance->attendance_via = "U";
                    $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                            OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                    if($model_shift->id>0){
                        if($model_shift->shiftdetails->shift_type=='N' && $value['status']==1){
                            $date_from=date('Y-m-d', strtotime('-1 days', strtotime(date("Y-m-d"))));
                        }
                    }
                    $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                    $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                    $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                    $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                    if($model_shift->shift_id==''){
                        $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                        $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                        $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                    }
                    if($weekend==1 && $weektype=='H'){
                        $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                        $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                        $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
                    }
                    //Attendance time
                    //Check if time already inserted
                    if ($in != '' && $in != '00:00' && $in != '0:00') {
                        if($model_attendance_1->id==''){
                            $model_attendance->login_time = $in;
                        }else if(strtotime($in)<strtotime($model_attendance_1->login_time) || $model_attendance_1->login_time=='00:00' || $model_attendance_1->login_time==''){
                            $model_attendance->login_time = $in;
                        }else{
                            $model_attendance->login_time =$model_attendance_1->login_time;
                        }
                    }
                    if ($out != '' && $out != '00:00' && $out != '0:00') {
                        if($model_attendance_1->id==''){
                            $model_attendance->logout_time = $out;
                        }else if(strtotime($out)>strtotime($model_attendance_1->logout_time) || $model_attendance_1->logout_time=='00:00' || $model_attendance_1->logout_time==''){
                            $model_attendance->logout_time = $out;
                        }else{
                            $model_attendance->logout_time =$model_attendance_1->logout_time;
                        }
                    }
                    if ($model->employee_exclude_biometric == 1) {
                        if ($in == '' || $in == '00:00' || $in == '0:00'){
                            if(strtotime($original_start_time)<strtotime($model_attendance_1->login_time)){
                                $model_attendance->login_time = $original_start_time;
                            }else{
                                $model_attendance->login_time =$model_attendance_1->login_time;
                            }
                        }
                        if ($out == '' || $out == '00:00' || $out == '0:00'){
                            if(strtotime($original_stop_time)>strtotime($model_attendance_1->logout_time)){
                                $model_attendance->logout_time = $original_stop_time;
                            }else{
                                $model_attendance->logout_time =$model_attendance_1->logout_time;
                            }
                        }

                    }
                    if($model_attendance->login_time!='00:00' && $model_attendance->login_time!='0:00' && $model_attendance->login_time!='' && $model_attendance->logout_time!='00:00' && $model_attendance->logout_time!='0:00' && $model_attendance->logout_time!=''){
                        $model_attendance->status = 1;
                    } else {
                        $model_attendance->status = 2;
                    }
                    //Working Details
                    $model_attendance->morning_late =$this->morninglate($model->id,$date_from,$model_attendance->login_time);
                    $model_attendance->total_working =$this->totalworking($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                    $model_attendance->variance_time_loss =$this->totaltimeloss($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                    $model_attendance->excess_time =$this->excesstime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                    $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                    if ($model_attendance->status == 1 && $model->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '' && $order_manhours==0) {
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                        if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                            $model_attendance->holiday_overtime = $this->holidayasworkingovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }else if(!empty($model_holiday)){
                            $model_attendance->holiday_overtime = $this->holidayovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }else if($model_master_shift->shift_type=='N'){
                            $model_attendance->night_shift_overtime=$this->nightshiftovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->holiday_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }else if($weekend==1) {
                            $model_attendance->weekend_overtime =$this->weekendovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->holiday_overtime = '00:00:00';
                        }else if(empty($model_holiday)) {
                            $model_attendance->normal_overtime = $this->normalovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->holiday_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }
                    } else {
                        $model_attendance->holiday_overtime = 0;
                        $model_attendance->normal_overtime = 0;
                        $model_attendance->weekend_overtime = 0;
                        $model_attendance->night_shift_overtime=0;
                    }
                    $model_attendance->branch_or_sponsor_id = $model->branch_or_sponsor_id;
                    $model_attendance->attendance_date = $date_from;
                    $model_attendance->week_day = $day;
                    $model_attendance->save(false);
                }
            }
            //Saving Attendance of All Employees
            $condition='t.isActive!="B" and date_join<="'.$date_from.'"';
            $modelemployee = Employee::model()->findAll(array('condition' =>$condition));
            foreach ($modelemployee as $j => $empdetail) {
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                if($model_shift->shift_id==''){
                    $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                    $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                }
                $status = 2;      // Absent
                $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $date_from . '" AND  leave_end_date >="' . $date_from . '" AND employee_id="' . $empdetail->id . '" and leave_status="12"'));
                if (!empty($arr_leave_details)) {
                    $status = 3;   // leave
                }
                $weekend=0;
                $weekend_type='';
                if ($empdetail->weekend_off1 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off1_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off2 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off2_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off3 == $weekvalue) {
                    $status = 5;  // Weekend
                   if($empdetail->weekend_off3_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $date_from . '"'));
                if (!empty($model_holiday)) {
                    $status = 4;  // Holiday
                }
                $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date_from . '" and employee_id="' . $empdetail->id . '"'));
                if (empty($model_attendance_detail)) {
                    if ($empdetail->employee_exclude_biometric==1 && $status==2) {
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        $model_attendance_add->shift_id = $model_shift->id;
                        $model_attendance_add->login_time = $original_start_time;
                        $model_attendance_add->logout_time = $original_stop_time;
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day = $day;
                        $model_attendance_add->status = 1;
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                        $model_attendance_add->save(false);
                    }else{
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        $model_attendance_add->shift_id = $model_shift->id;
                        $model_attendance_add->login_time ='00:00';
                        $model_attendance_add->logout_time = '00:00';
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day=$day;
                        $model_attendance_add->status=$status;
                        if ($status==3) {
                            $model_attendance_add->leave_id = $arr_leave_details->id;
                        }
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                        $model_attendance_add->save(false);
                    }
                }

            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    //Morning Late-Start
    //Morning Late-Start
    function morninglate($employee_id,$date,$login_time){
        $model_general_settings = HrGenerelSettings::model()->find();
        $cool_off_time=$model_general_settings->cool_off_time;
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue+=1;
        $weektype='';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off3_type;
        }
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        if($model_shift->shift_id>0){
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
        }else if($weekend==1 && $weektype=='H'){
            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
        }else{
            $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
        }
        $mor_late= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $weektype!='F' && $model_holiday->id==''){
            $from_time      = strtotime($login_time);
            $secs = strtotime($cool_off_time)-strtotime("00:00:00");
            $morning_start = date("H:i",strtotime($original_start_time)+$secs);
            $morning_shift_in_time  = strtotime($morning_start);
            $shift_in_time  = strtotime($original_start_time);
            $time_diff      = $from_time - $shift_in_time;
            if($morning_shift_in_time >=$from_time){
                $mor_late = '00:00';
            }else{              
                $mor_late = gmdate('H:i', $time_diff);
            }
        }
        return $mor_late;
    }
    //Morning Late-End
    //Total Working -Start
    function totalworking($employee_id,$date,$login_time,$logout_time){
        $total_working= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if($model_master_shift->shift_type=='N'){
                    $diff = ($working_start_time-$working_stop_time);
                }else{
                    if($working_stop_time>$working_start_time){
                        $diff = ($working_stop_time - $working_start_time);
                    }else{
                        $diff = ($working_start_time-$working_stop_time);
                    }
                }
            }else{
                if($working_stop_time>$working_start_time){
                    $diff = ($working_stop_time - $working_start_time);
                }else{
                    $diff = ($working_start_time-$working_stop_time);
                }
            }
            $total_working = gmdate('H:i', $diff); 
        }
        return $total_working;
    }
    //Total Working -End
    //Total Time Loss Per Day -Start
    function totaltimeloss($employee_id,$date,$login_time,$logout_time){
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue+=1;
        $weektype='';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours=$model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        if($model_shift->shift_id>0){
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        }else if($weekend==1 && $weektype=='H'){
            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
        }else{
            $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
        }
        
        $total_working=$total_timeloss= '00:00';
        if($model_holiday->id==''){
            if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
                $working_stop_time = strtotime($login_time);
                $working_start_time = strtotime($logout_time);
                if($working_stop_time>$working_start_time){
                    $diff = ($working_stop_time - $working_start_time);
                }else{
                    $diff = ($working_start_time-$working_stop_time);
                }
                $total_working = $this->totalworking($employee_id,$date,$login_time,$logout_time);
                if((strtotime($total_working)<strtotime($branch_working_hours)) && $weekend==0){
                    $timeloss_stop_time = strtotime($branch_working_hours);
                    $timeloss_start_time = strtotime($total_working);
                    $timeloss_diff = ($timeloss_stop_time - $timeloss_start_time);
                    $total_timeloss = gmdate('H:i', $timeloss_diff); 
                }
            }
        }
        return $total_timeloss;
    }
    //Total Time Loss Per Day -End
    //Total Excess Time Per Day -Start
    function excesstime($employee_id,$date,$login_time,$logout_time){
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue+=1;
        $weektype='';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend=1;
            $weektype=$model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours=$model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        if($model_shift->shift_id>0){
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        }else if($weekend==1 && $weektype=='H'){
            $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
        }else{
            $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
            $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
        }
        
        $total_working=$total_excess_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            if($working_stop_time>$working_start_time){
                $diff = ($working_stop_time - $working_start_time);
            }else{
                $diff = ($working_start_time-$working_stop_time);
            }
            $total_working = $this->totalworking($employee_id,$date,$login_time,$logout_time);
            if($weekend==1 || $model_holiday->id>0){
                $total_excess_time=$total_working;
            }else if(strtotime($total_working)>strtotime($branch_working_hours)){
                $stop_time = strtotime($total_working);
                $start_time = strtotime($branch_working_hours);;
                $time_excess = ($stop_time - $start_time);
                $total_excess_time = gmdate('H:i', $time_excess); 
            }
        }
        return $total_excess_time;
    }
    //Total Excess Time Per Day -End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayasworkingovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_holiday_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_holiday_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }
    //Holiday Overtime Calculation Beyond Working Time-End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_holiday_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_holiday_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($diff > 0) {
                $work_time_1 = gmdate('H:i', $diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $diff);
                }
            }
        }
        return $over_time;
    }
    //Holiday Overtime Calculation Beyond Working Time-End
    //Normal Overtime Calculation-Start
    function normalovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_normal_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_normal_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }
    //Normal Overtime Calculation-End
    //Weeekend Overtime Calculation-Start
    function weekendovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_weekend_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_weekend_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if($weektype=='F'){
                if ($diff > 0) {
                    $work_time_1 = gmdate('H:i', $diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $diff);
                    }
                }
            }else if($weektype=='H'){
                //Original time
                $original_start_time = strtotime($original_start_time);
                $original_stop_time = strtotime($original_stop_time);
                $original_diff = ($original_stop_time - $original_start_time);
                //Difference
                $overtime_diff = $diff - $original_diff;
                if ($overtime_diff > 0) {
                    $work_time_1 = gmdate('H:i', $overtime_diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $overtime_diff);
                    }
                }
            }
        }
        return $over_time;
    }
    //Weekend Overtime Calculation-End
    //Night Shift Overtime Calculation-Start
    function nightshiftovertime($employee_id,$date,$login_time,$logout_time){
        $over_time= '00:00';
        if($login_time!='' && $login_time!='0:00' && $login_time!='00:00' && $logout_time!='' && $logout_time!='0:00' && $logout_time!='00:00'){
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue+=1;
            $weektype='';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend=1;
                $weektype=$model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
            if($model_shift->shift_id>0){
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
            }else if($weekend==1 && $weektype=='H'){
                $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
            }else{
                $model_company_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time=date("H:i",strtotime($model_company_time->workstart_time));
                $original_stop_time=date("H:i",strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if($model_settings->start_time_night_ot=='P'){
                $working_start_time = strtotime($login_time);
            }else if($model_settings->start_time_night_ot=='C'){
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if($punch_start_time>$company_start_time){
                    $working_start_time=$punch_start_time;
                }else{
                    $working_start_time=$company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }
    //Night Shift Overtime Calculation-End
    function decimalHours($time)
    {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1]/60) + ($hms[2]/3600));
    }
    function shiftdetail($employee_id,$date){
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="'.$date.'" AND to_date>="'.$date.'") OR  (from_date BETWEEN  "'.$date.'" AND  "'.$date.'" OR to_date BETWEEN  "'.$date.'" AND  "'.$date.'")) AND employee_id="'.$employee_id.'"'));
        $shift_id=0;
        if($model_shift->shift_id>0){
            $shift_id=$model_shift->shift_id;
        }
        return $shift_id;
    }
    //End Functions
    public function actionUpdateAttendance() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=cumulush_2022_hr_casio'; 
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        Yii::app()->db2->connectionString = 'mysql:host=blueskytechno.com;dbname=u574074885_hr_attendance;port=3306'; 
        Yii::app()->db2->setActive(true);
        $start_date='2022-10-07';
        $end_date='2022-10-07';
        $d1 = strtotime($start_date);
        $d2 = strtotime($end_date);
        $datediff = $d2 - $d1;
        $total_days = $datediff / (60 * 60 * 24);
        $date_from='2022-10-07';
        for($ls=0;$ls<=$total_days;$ls++){
            if($ls>0){
                $date_from=date('Y-m-d', strtotime('+1 day', strtotime($date_from)));
            }
            echo $date_from;            echo '<br>';
            $weekvalue=date('w', strtotime($date_from)); 
            $weekvalue+=1;
            $day='';
            if ($weekvalue == 1) {
                $day = "Sunday";
            } else if ($weekvalue == 2) {
                $day = "Monday";
            } else if ($weekvalue == 3) {
                $day = "Tuesday";
            } else if ($weekvalue == 4) {
                $day = "Wednesday";
            } else if ($weekvalue == 5) {
                $day = "Thursday";
            } else if ($weekvalue == 6) {
                $day = "Friday";
            } else if ($weekvalue == 7) {
                $day = "Saturday";
            }
            $sql_query= "Select * from hr_attendance where DATE(punch_date)='".$date_from."' AND (device_serial='AEWU200260017' OR device_serial='AEWU193960024')";
            $model_attendance_pushed = Yii::app()->db2->createCommand($sql_query)->queryAll();
            foreach ($model_attendance_pushed as $key => $value) {
                $emp_no=$value['employee_id'];
                $in=date("H:i",strtotime($value['punch_date']));
                $out=date("H:i",strtotime($value['punch_date']));
                $model = Employee::model()->find(array('condition' => 'employee_biometric_code="' . $emp_no . '" and t.isActive!="B" ')); 
                if (!empty($model)) {
                    $weekend=0;
                    $weektype='';
                    $model_attendance_1 = EmployeeAttendance::model()->find(array('condition' => 'employee_id="' . $model->id . '" and attendance_date="' . $date_from . '"'));
                    if ($model->weekend_off1 == $weekvalue) {
                        $weekend=1;
                        $weektype=$model->weekend_off1_type;
                    }
                    if ($model->weekend_off2 == $weekvalue) {
                        $weekend=1;
                        $weektype=$model->weekend_off2_type;
                    }
                    if ($model->weekend_off3 == $weekvalue) {
                        $weekend=1;
                        $weektype=$model->weekend_off3_type;
                    }
                    $order_manhours=0;
                    if (empty($model_attendance_1)) {
                        $model_attendance = new EmployeeAttendance();
                        $model_attendance->created_by = Yii::app()->user->id;
                        $model_attendance->created_date_time = date('Y-m-d H:i:s');
                        $model_attendance->login_time ='00:00';
                        $model_attendance->logout_time ='00:00';
                        $order_manhours=0;
                    } else {
                        $model_attendance = EmployeeAttendance::model()->findByPK($model_attendance_1->id);
                        $model_attendance->updated_by = Yii::app()->user->id;
                        $model_attendance->updated_date_time = date('Y-m-d H:i:s');
                        $order_manhours=$model_attendance->order_manhours;
                    }

                    $model_attendance->employee_id = $model->id;
                    $model_attendance->attendance_via = "U";
                    $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                            OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                    if($model_shift->id>0){
                        if($model_shift->shiftdetails->shift_type=='N' && $value['status']==1){
                            $date_from=date('Y-m-d', strtotime('-1 days', strtotime(date("Y-m-d"))));
                        }
                    }
                    $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                    $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                    $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                    $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                    if($model_shift->shift_id==''){
                        $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                        $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                        $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                    }
                    if($weekend==1 && $weektype=='H'){
                        $model_branch_time= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                        $original_start_time=date("H:i",strtotime($model_branch_time->workstart_time));
                        $original_stop_time=date("H:i",strtotime($model_branch_time->workend_time));
                    }
                    //Attendance time
                    //Check if time already inserted
                    if ($in != '' && $in != '00:00' && $in != '0:00') {
                        if($model_attendance_1->id==''){
                            $model_attendance->login_time = $in;
                        }else if(strtotime($in)<strtotime($model_attendance_1->login_time) || $model_attendance_1->login_time=='00:00'){
                            $model_attendance->login_time = $in;
                        }else{
                            $model_attendance->login_time =$model_attendance_1->login_time;
                        }
                    }
                    if ($out != '' && $out != '00:00' && $out != '0:00') {
                        if($model_attendance_1->id==''){
                            $model_attendance->logout_time = $out;
                        }else if(strtotime($out)>strtotime($model_attendance_1->logout_time) || $model_attendance_1->logout_time=='00:00'){
                            $model_attendance->logout_time = $out;
                        }else{
                            $model_attendance->logout_time =$model_attendance_1->logout_time;
                        }
                    }
                    if ($model->employee_exclude_biometric == 1) {
                        if ($in == '' || $in == '00:00' || $in == '0:00'){
                            if(strtotime($original_start_time)<strtotime($model_attendance_1->login_time)){
                                $model_attendance->login_time = $original_start_time;
                            }else{
                                $model_attendance->login_time =$model_attendance_1->login_time;
                            }
                        }
                        if ($out == '' || $out == '00:00' || $out == '0:00'){
                            if(strtotime($original_stop_time)>strtotime($model_attendance_1->logout_time)){
                                $model_attendance->logout_time = $original_stop_time;
                            }else{
                                $model_attendance->logout_time =$model_attendance_1->logout_time;
                            }
                        }

                    }
                    if($model_attendance->login_time!='00:00' && $model_attendance->login_time!='0:00' && $model_attendance->login_time!='' && $model_attendance->logout_time!='00:00' && $model_attendance->logout_time!='0:00' && $model_attendance->logout_time!=''){
                        $model_attendance->status = 1;
                    } else {
                        $model_attendance->status = 2;
                    }
                    //Working Details
                    $model_attendance->morning_late =$this->morninglate($model->id,$date_from,$model_attendance->login_time);
                    $model_attendance->total_working =$this->totalworking($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                    $model_attendance->variance_time_loss =$this->totaltimeloss($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                    $model_attendance->excess_time =$this->excesstime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                    $model_attendance->shift_id = $this->shiftdetail($model->id,$date_from);
                    if ($model_attendance->status == 1 && $model->overtime == "Y" && $model_attendance->login_time != '' && $model_attendance->logout_time != '' && $order_manhours==0) {
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("'.$model->branch_or_sponsor_id.'",branch_id)  AND holiday_date="' . $date_from . '"'));
                        if(!empty($model_holiday) && $model_settings->holiday_ot_from=='O') {
                            $model_attendance->holiday_overtime = $this->holidayasworkingovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }else if(!empty($model_holiday)){
                            $model_attendance->holiday_overtime = $this->holidayovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }else if($model_master_shift->shift_type=='N'){
                            $model_attendance->night_shift_overtime=$this->nightshiftovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->holiday_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }else if($weekend==1) {
                            $model_attendance->weekend_overtime =$this->weekendovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->normal_overtime = '00:00:00';
                            $model_attendance->holiday_overtime = '00:00:00';
                        }else if(empty($model_holiday)) {
                            $model_attendance->normal_overtime = $this->normalovertime($model->id,$date_from,$model_attendance->login_time,$model_attendance->logout_time);
                            $model_attendance->night_shift_overtime ='00:00:00';
                            $model_attendance->holiday_overtime = '00:00:00';
                            $model_attendance->weekend_overtime = '00:00:00';
                        }
                    } else {
                        $model_attendance->holiday_overtime = 0;
                        $model_attendance->normal_overtime = 0;
                        $model_attendance->weekend_overtime = 0;
                        $model_attendance->night_shift_overtime=0;
                    }
                    $model_attendance->branch_or_sponsor_id = $model->branch_or_sponsor_id;
                    $model_attendance->attendance_date = $date_from;
                    $model_attendance->week_day = $day;
                    $model_attendance->save(false);
                }
            }
            //Saving Attendance of All Employees
            $condition='t.isActive!="B" and date_join<="'.$date_from.'"';
            $modelemployee = Employee::model()->findAll(array('condition' =>$condition));
            foreach ($modelemployee as $j => $empdetail) {
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->id . '"'));
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i",strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i",strtotime($model_master_shift->end_time));
                if($model_shift->shift_id==''){
                    $model_company_shift= MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                    $original_start_time=date("H:i",strtotime($model_company_shift->workstart_time));
                    $original_stop_time=date("H:i",strtotime($model_company_shift->workend_time));
                }
                $status = 2;      // Absent
                $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => 'leave_start_date <= "' . $date_from . '" AND  leave_end_date >="' . $date_from . '" AND employee_id="' . $empdetail->id . '" and leave_status="12"'));
                if (!empty($arr_leave_details)) {
                    $status = 3;   // leave
                }
                $weekend=0;
                $weekend_type='';
                if ($empdetail->weekend_off1 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off1_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off2 == $weekvalue) {
                    $status = 5;  // Weekend
                    if($empdetail->weekend_off2_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                if ($empdetail->weekend_off3 == $weekvalue) {
                    $status = 5;  // Weekend
                   if($empdetail->weekend_off3_type=='H'){
                        $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                        $original_start_time = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                        $original_stop_time = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                    }
                }
                $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $date_from . '"'));
                if (!empty($model_holiday)) {
                    $status = 4;  // Holiday
                }
                $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date_from . '" and employee_id="' . $empdetail->id . '"'));
                if (empty($model_attendance_detail)) {
                    if ($empdetail->employee_exclude_biometric==1 && $status==2) {
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        $model_attendance_add->shift_id = $model_shift->id;
                        $model_attendance_add->login_time = $original_start_time;
                        $model_attendance_add->logout_time = $original_stop_time;
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day = $day;
                        $model_attendance_add->status = 1;
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                        $model_attendance_add->save(false);
                    }else{
                        $model_attendance_add = new EmployeeAttendance;
                        $model_attendance_add->employee_id = $empdetail->id;
                        $model_attendance_add->shift_id = $model_shift->id;
                        $model_attendance_add->login_time ='00:00';
                        $model_attendance_add->logout_time = '00:00';
                        $model_attendance_add->normal_overtime = 0;
                        $model_attendance_add->holiday_overtime = 0;
                        $model_attendance_add->weekend_overtime = 0;
                        $model_attendance_add->attendance_date = $date_from;
                        $model_attendance_add->week_day=$day;
                        $model_attendance_add->status=$status;
                        if ($status==3) {
                            $model_attendance_add->leave_id = $arr_leave_details->id;
                        }
                        $model_attendance_add->branch_or_sponsor_id = $empdetail->branch_or_sponsor_id;
                        $model_attendance_add->save(false);
                    }
                }

            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionLateMail() {
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=cumulush_2022_hr_casio'; 
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        $model_settings = HrGenerelSettings::model()->find();
        $model_mail_setting=MailSettings::model()->find(array('condition'=>'mail_function="31"'));
        $current_date=date('Y-m-d');
        $subject='Morning Late Notification';          
        $view='send_notify';
        $applicant_name='HR Department'; 
//        $current_date='2022-10-27';
        if($model_settings->enable_mail=='Y' && $model_mail_setting->isActive=="Y"){
            $arr_punch = array('O' => 'Biometric','H' => 'System');
            $model_reporting_manager= ReportingManager::model()->with('reportingmanager')->findAll(array('condition' => 'reportingmanager.isActive="Y"'));
            foreach ($model_reporting_manager as $key => $value) {
                $message = new YiiMailMessage;
                $line_manager_name=ucwords(strtolower($this->ciphertext($value->reportingmanager->first_name, "d") . ' ' . $this->ciphertext($value->reportingmanager->middle_name, "d") . ' ' . $this->ciphertext($value->reportingmanager->last_name, "d")));
                $salutation='Dear '.$line_manager_name;
                $model_attendance = EmployeeAttendance::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.reporting_manager="'.$value->employee_id.'" AND attendance_date="'.$current_date.'" and morning_late!="00:00:00"  and morning_late>="00:10:00"'));
                if(!empty($model_attendance)){
                    $content='Kindly be informed that the below employee(s) has punched in late according to their working hours today.Please update HR in case any leave has to be applied.';
                    $content.="<br><br>";
                    $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 600px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                        <tbody>
                            <tr>
                                <th style="border: 1px solid #666;padding: 4px 5px;">No</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Employee Name</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Start Time</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Morning Late</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Punch In From</th>
                            </tr>';
                            $p=1;
                            foreach ($model_attendance as $key => $value_detail) {
                                $attendance_date='-';
                                if($value_detail->attendance_date!='' && $value_detail->attendance_date!='0000-00-00'){
                                    $attendance_date=date("d/m/Y", strtotime($value_detail->attendance_date));
                                }
                                $employee_name=ucwords(strtolower($this->ciphertext($value_detail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($value_detail->employeedetail->middle_name, "d") . ' ' . $this->ciphertext($value_detail->employeedetail->last_name, "d")));
                                $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.$p.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$employee_name.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px;">'.$attendance_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.$value_detail->login_time.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.date("H:i", strtotime($value_detail->morning_late)).'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: center">'.$arr_punch[$value_detail->login_punch_from].'</td>
                                    </tr>';
                                $p++;
                            }
                    $content.='</tbody>
                    </table>';
                    //Start Mail Content
                    $mailContent['body'] = '
                        <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 1200px;margin: 0 auto;text-align: inherit">
                            <tbody>
                                <tr style="vertical-align: top">
                                    <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                                        <div>'.$salutation.',</div>                                              
                                    </td>
                                </tr>                                      
                                <tr>
                                    <td height="30"></td>
                                </tr>
                                <tr style="vertical-align: top">
                                    <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                                        <strong style="font-size: 15px">Sub: '.$subject.'</strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td height="30"></td>
                                </tr>
                                <tr style="vertical-align: top">
                                    <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'                          
                                        .$content.'<br>
                                        <br>
                                        <br>
                                        Thanking you,
                                        <br>
                                        <br>
                                        Yours sincerely,
                                        <br>
                                        <br>
                                        '.$applicant_name.'
                                    </td>
                                </tr>
                            </tbody>
                        </table>';
                    //End Mail Content
                    //Mail sending-Start
                $message->view = $view;
                $message->setBody(array('mailContent' => $mailContent), 'text/html');
                $message->subject =$subject;    
                //Mail From Start       
                if($model_mail_setting->from_mail_id!=''){
                    if (filter_var($model_mail_setting->from_mail_id, FILTER_VALIDATE_EMAIL)) {
                        $from=$model_mail_setting->from_mail_id;
                    }
                }
                $message->from =$from;
                /*
                if($value->reportingmanager->email!=''){
                    if (filter_var($value->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $to=$value->reportingmanager->email;
                        $sent_mail_id[]=$value->reportingmanager->email;
                    }
                }
                $notifying_employee=$model_mail_setting->notifying_employee;
                //Notifying Employee-Start
                $notifyingemployee=array();
                if($notifying_employee!=''){
                    $notifyingemployee=explode(',', $notifying_employee);            
                    $m=0;
                    foreach (array_keys($notifyingemployee,$_id_to) as $key) {
                        unset($notifyingemployee[$key]);                                        
                        $notifyingemployee=array_values($notifyingemployee);
                    } 
                    foreach (array_keys($notifyingemployee,$attendance_manager_id) as $key) {
                        unset($notifyingemployee[$key]);                                        
                        $notifyingemployee=array_values($notifyingemployee);
                    } 
                    foreach (array_keys($notifyingemployee,$model_employee->reporting_manager) as $key) {
                        unset($notifyingemployee[$key]);                                        
                        $notifyingemployee=array_values($notifyingemployee);
                    } 
                    foreach (array_keys($notifyingemployee,$model_employee->id) as $key) {
                        unset($notifyingemployee[$key]);                                        
                        $notifyingemployee=array_values($notifyingemployee);
                    } 
                    foreach ($notifyingemployee as $emp_id) {
                       $model_mail=Employee::model()->findByPK($emp_id);
                       if (filter_var($model_mail->email, FILTER_VALIDATE_EMAIL)) { 
                           $sent_mail_id[]=$model_mail->email;
                           if($to=='' && $m==0){
                               $to=$model_mail->email;
                           }
                           $m++;
                       }
                    }
                }
                //Notifying Employee-End
                // Start Custom Mail
                if($model_mail_setting->custom_mail_id!=''){
                    $custom_mail=explode(',', $model_mail_setting->custom_mail_id); 
                    foreach ($custom_mail as $custom_mail_id) {
                        if (filter_var($custom_mail_id, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$custom_mail_id;
                            if($to==''){
                               $to=$custom_mail_id;
                            }
                        }
                    }
                } 
                // End Custom Mail
                $sent_mail_id = array_unique($sent_mail_id);
                if(count($sent_mail_id)>0){
                    $f=0;
                    foreach ($sent_mail_id as $value) {
                        if($f==0){
                            $message->addTo($value);
                        }else{
                            $message->addCC($value);
                        }
                        $f++;
                    }
                }*/
                $message->addTo('lynnm@casio.ae');
                $message->addBcc('dikson@mailbluesky.com');
                $message->addBcc('john@mailbluesky.com');
                Yii::app()->mail->send($message);  
                //Mail sending-End
                //Saving Mail Status
                date_default_timezone_set("Asia/Dubai");
                if(count($sent_mail_id)>0){
                    $sent_mails=  implode(',', $sent_mail_id);
                }
                $model_mail_status= new MailStatus();
                $model_mail_status->type =31;
                $model_mail_status->from_mail =$from;
                $model_mail_status->sent_mail_id =$sent_mails;
                $model_mail_status->content =$content;
                $model_mail_status->created_date_time =date('Y-m-d H:i:s');
                $model_mail_status->created_by =757;
                $model_mail_status->save(false);
                }
            }
        }
    }
}