<?php

class OvertimeController extends Controller {

//	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'deleteOverTime', 'SaveOverTime', 'GetList', 'DirectAdd', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_overtimetype_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
         }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {

        $model = new MasOverTime();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'type',
            1 => 'salary',
            2 => 'times',
            3 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition =" (t.type LIKE '%" . $searchString . "%' OR t.times LIKE '%" . $searchString . "%' OR salarytype.salary_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('salarytype')->count(array('condition' => $condition));
        $model = $model->with('salarytype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $salarytype="";
            $edit = $disable = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_overtimetype_edit'])  || Yii::app()->user->authorised_user == 1) {
                $edit = 1;
                //$button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/overtime/create&id=' . $row['id'] . '\',\'Edit Over Time Type  \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_sal_overtimetype_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable = 1;
            }
            $salary_type=explode(",",$row['salary']);
            $salary_name=array();
            foreach ($salary_type as $eachValue){
                $salaryTypeModel = MasSalarytype::model()->findbyPk($eachValue);
                if (!empty($salaryTypeModel)) {
                    $salary_name[] = $salaryTypeModel->salary_name;
                }
            }        
            if(!empty($salary_name)){
                $salarytype=implode(",",$salary_name);
            }
            $rowData[] = array(++$m, $row['type'], $salarytype, $row['times'], array("id" => $row->id, 'status' => $row->isActive, "edit" => $edit, "disable" => $disable));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasOverTime();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('over_time_form', array('model' => $model), false, true);
    }

    public function actionSaveOverTime() {
        $model = new MasOverTime();
        if (isset($_POST['MasOverTime'])) {
            $model->isActive = "Y";

            if ((int) @$_POST['MasOverTime']['id'] > 0) {
                $id = (int) @$_POST['MasOverTime']['id'];
                $model = $model->findByPk($id);
               $model->scenario = 'update'; 
            }else{
                 $model->scenario = 'add';
            }
            $model->attributes = $_POST['MasOverTime'];
            if(isset($_POST['MasOverTime']['salary']) && count($_POST['MasOverTime']['salary']) > 0){
                $model->salary = implode(',',$_POST['MasOverTime']['salary']);
            }else{
                $model->salary = "";
            }
            if ($model->save()) {
               
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteOverTime() {

        $id = $_POST['id'];
        if ($id > 0) {

            $model = new MasSalarytype();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasOverTime();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}
