<?php

class OrganizationchartController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'testmail'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


 
    public function actionIndex() {
        $model_module_org_chart = HrModules::model()->findByPK(35);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_organization_chart_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_org_chart->grant_access == 1 && $model_module_org_chart->isActive == 'Y')) {
            $this->render('chart');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
}
