<?php

class MasnoticeperiodController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetNoticeperiod', 'Save', 'Delete', 'DirectAdd', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_noticeperiod_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetNoticeperiod() {
        $model = new MasNoticeperiod();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'isActive',
            1 => 'period_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"'; // 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (period_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit = $disable = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_noticeperiod_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit = 1;
//                $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/Masnoticeperiod/create&id=' . $row['id'] . '\',\'Edit Notice period\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_noticeperiod_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable = 1;
            }
            $rowData[] = array(++$m, $row['period_name'], array('id' => $row->id, 'status' => $row->isActive, "edit" => $edit, "disable" => $disable));
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasNoticeperiod();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
        $model = new MasNoticeperiod();
        if (isset($_POST['MasNoticeperiod'])) {
            if ((int) @$_POST['MasNoticeperiod']['id'] > 0) {
                $id = (int) @$_POST['MasNoticeperiod']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['MasNoticeperiod'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDelete() {
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = new MasNoticeperiod();
            $model = $model->findByPk($id);
            $model->delete();
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasNoticeperiod();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N " : "Y";
        $model->save(false);
        echo json_encode(array("status" => "success", 'active' => $model->isActive));
    }

}
