<?php

class MasinoutController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','deleteInOut','SaveDocument','GetList','DirectAdd','Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_inout_doc_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
            }else{
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        }
         
        public function actionGetList()
         {
 
            $model=new MasInoutDocument();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                    0 =>'id',
                   1 =>'document_name',
                );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition  ="  (document_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $button_string="";
                    
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_inout_doc_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/masinout/create&id='.$row['id'].'\',\'Edit In-Out Document   \',\'lg\')"><i class="fa fa-edit"></i></button>';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_inout_doc_delete'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteInOut('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                    $rowData[]=array($m,$row['document_name'], array('id' => $row->id, 'status' => $row->isActive));
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasInoutDocument(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('in_out_form', array('model' => $model), false, true);
    }
    public function actionSaveDocument()
        {
            $model = new MasInoutDocument();
            if (isset($_POST['MasInoutDocument']))
            {
                $model->isActive = "Y";
    		
    		if ((int) @$_POST['MasInoutDocument']['id'] > 0)
                {
                    $id= (int) @$_POST['MasInoutDocument']['id'];
                    $model=$model->findByPk($id); 
                     $model->scenario = 'update';
                }
                else {
                $model->scenario="add";
            }
                $model->attributes=$_POST['MasInoutDocument'];
                if($model->save())
                {       
                        
                        $jsonData['status'] = 'success';
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
            }
        }
        public function actiondeleteInOut(){
        
            $id = $_POST['id'];
            if($id>0){
            
                $model = new MasInoutDocument();                
                $model->deleteByPk($id);
                echo "success";
            }
            else{
                echo "fail";
            }
        
        }
    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInoutDocument();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    } 
}