<?php

class MasexpirystatusController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteExpiryStatus','SaveExpiryStatusdetail','GetList','DirectAdd','DeleteMasExpiryData'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_expiry_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
         
        public function actionGetList()
         {
 
            $model=new MasExpiryStatus();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'document',
                   1 =>'stages',
                   2 =>'t.id',
                   3 =>'t.id'
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (doc.document_name LIKE '%".$searchString."%' OR t.stages LIKE '%".$searchString."%')";
                }
                $count = $model->with('doc')->count(array('condition'=>$condition));
                $model=$model->with('doc')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy,'group'=>'t.document'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=$offset;
                foreach ($model as $row)
                {
                    
                    $arr_stages  = array();
                    $model_stage = MasExpiryStatus::model()->findAll(array('condition'=>'document="'.$row['document'].'"'));
                    foreach($model_stage as $stage) {
                    //do something
                        $arr_stages[] = $stage->stages;
                    }
                    $stages =implode(',', $arr_stages);
                    
                    $button_string="";
                    $edit_button =$disable_button=0;
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_expiry_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/masexpirystatus/create&id='.$row['document'].'\',\'Edit Expiry Status  \',\'lg\')"><i class="fa fa-edit"></i></button>';
                        $edit_button=1;
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_expiry_delete'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteExpiryStatus('.$row['document'].')"><i class="fa fa-trash-o "></i></a>';
                        $disable_button=1;
                    }
                    $rowData[]=array(++$m,$row['doc']['document_name'],$stages,array('document'=>$row['document'],'edit_button'=>$edit_button,'disable_button'=>$disable_button));
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model = array(new MasExpiryStatus); 
        $id=Yii::app()->request->getParam('id');
            if($id>0){
                $model = MasExpiryStatus::model()->findAll(array('condition'=>'document="'.$id.'"'));
                if(empty($model)){
                    $model = array(new MasExpiryStatus); 
                }
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('expiry_status_form', array('model' => $model), false, true);
    }
    public function actionSaveExpiryStatusdetail() {
        
        if (isset($_POST['MasExpiryStatus'])) {
            $valid1=true;
            foreach ($_POST['MasExpiryStatus'] as $i => $items) {                           
                if($items['id']>0){
                   $model_processing[$i] = MasExpiryStatus::model()->findByPK($items['id']);
                   $model_processing[$i]->scenario='update';
                }else{
                   $model_processing[$i] = new MasExpiryStatus; 
                   $model_processing[$i]->scenario='add';
                }     
               $model_processing[$i]->document = $_POST['document'];
               $model_processing[$i]->stages = $items['stages'];
               $model_processing[$i]->processing_order = $items['processing_order'];                              
                $valid1 = $model_processing[$i]->validate() && $valid1;                                            
            } 
            if($valid1){
                foreach ($model_processing as $eachModel) { 
                    $eachModel->save(false);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
           }else{
             if (!isset($model_processing)){
                    $model_processing = new MasExpiryStatus;
                }
                $error_1 = json_decode(CActiveForm::validate($model_processing, '', false), true);
                $error = CJSON::encode($error_1);
                if ($error != '[]'){
                   echo $error;
                }     
            }
       }
    }
        public function actionDeleteExpiryStatus(){
        
            $id = $_POST['id'];
            if($id>0){
                MasExpiryStatus::model()->deleteAll('document=:refer_id', array(':refer_id' => $id));
                echo "success";
            }
            else{
                echo "fail";
            }
        
        }
        //function added by nisha on 08-02-2023
    public function actionDeleteMasExpiryData(){
        $id = $_POST['id'];
        if($id>0){
            $model_exp = MasExpiryStatus::model()->find(array('condition'=>'id="'.$id.'"'));  
            $model_inprocess = HrEmployeeInprocessDocument::model()->findAll(array('condition'=>'document_id="'.$model_exp->document.'" AND completed="N"'));  
            if(empty($model_inprocess)){            
                $model = new MasExpiryStatus();                
                $model->deleteByPk($id);
                $jsonData['status'] = 'success';
            }else{
               $jsonData['status'] = 'error'; 
            }
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}