<?php

class MasappraisalController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}
    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','deleteDocument','SaveDocument','GetList','DirectAdd', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
            $model=new HrMasAppraisal();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'period_name',
                   1 =>'approval_period',
                   2 =>'isActive',
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (period_name LIKE '%".$searchString."%' OR approval_period LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $button_string="";
                    /*
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisal_edit'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masappraisal/create&id='.$row['id'].'\',\'Edit Appraisal  \',\'md\')"><i class="fa fa-edit"></i></button>';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_appraisal_delete'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                     */
                        
                    $rowData[]=array($m,$row['period_name'],$row['approval_period'],$row['isActive'], array( 'id' => $row->id , 'status' => $row->isActive));
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new HrMasAppraisal(); 
        $id=(int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
                   
            
       Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('appraisal_form', array('model' => $model), false, true);
    }
    public function actionSaveDocument()
        {
			//var_dump($_POST['HrMasAppraisal']);
			//die();
			
            $model = new HrMasAppraisal();
			
            if (isset($_POST['HrMasAppraisal']))
            {
                $model->isActive = "Y";
    		
    		if ((int) @$_POST['HrMasAppraisal']['id'] > 0)
                {
                    $id= (int) @$_POST['HrMasAppraisal']['id'];
                    $model=$model->findByPk($id); 
                    $audit_type = 'UPDATED';
                }else{
                    $audit_type = 'CREATED';
                }
				if($_POST['HrMasAppraisal']['isActive'] == 'Y'){
                $SQL_current_year="UPDATE erp_hr_mas_appraisal SET isActive = 'N' WHERE isActive = 'Y' ";
    		
						$modelemployeedocument = Yii::app()->db->createCommand($SQL_current_year)->execute();
				}
				$model->attributes=$_POST['HrMasAppraisal'];
                if($model->save())
                {       
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                            'APPRAISAL',
                            Yii::app()->user->id,
                            $audit_type,
                            " with period name: - {$model->period_name}  "
                        );
                        // end audit log
                        
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['bank_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                       // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
            }
        }
        public function actiondeleteDocument(){
        
            $id = $_POST['id'];
            if($id>0){
            
                $model = new HrMasAppraisal(); 
                $del = $model->findByPk($id);               
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'APPRAISAL',
                    Yii::app()->user->id,
                    'DELETED',
                    " with period name: - {$del->period_name}  "
                );
                // end audit log 
                echo "success";
            }
            else{
                echo "fail";
            }
        
        }
      public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new HrMasAppraisal();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
   /* public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $status =  array();
           $drop = '';
           if($name != ''){
               $modelBank = new MasBank;
               $modelBank->bank_name = $name;
               if($modelBank->save()){
                    $status['status']= "success";
                    $data  = MasBank::getBanks();
                    if($from == 'vendor'){
                        $model = new Vendor;
                        $field_name = 'vendor_bank_name';
                    }
                    $model->$field_name = $modelBank->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bank'));  
                    $status['drop']= $drop;
                    echo CJSON::encode($status); 
               }else{
                    $error = CActiveForm::validate($modelBank, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
        }*/
        
        
  
}