<?php

class MailController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList','Create','SaveMailSettings','ChangeStatus'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_mail_settings = HrModules::model()->findByPK(28);
        if ($model_mail_settings->grant_access == 1 && $model_mail_settings->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_settings_mail_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new MailSettings();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $type= $_POST['type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'maildetails.mail_function_type',
            2 => 'from_mail_id',
            3 => 'self_mail',
            4 => 'reporting_manager',
            5 => 'notifying_employee',
            6 => 'custom_mail_id',
            7 => 'isActive',
            8 => 't.id',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if($type>0){
            $condition.= ' and mail_function="'.$type.'"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (mail_function LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('maildetails')->count(array('condition' => $condition));
        $model = $model->with('maildetails')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_mail=$disable_mail=$enable_mail=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_mail_setting_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/mail/create&id=' . $row['id'] . '\',\'Edit Mail Settings  \',\'lg\')"><i class="fa fa-edit"></i></button>';
                $edit_mail =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_mail_setting_enable'])  || Yii::app()->user->authorised_user == 1) {
                if($row['isActive']=="Y"){
                    $button_string .= ' <a href ="javascript:void(0);" title="Disable Mail" class="btn btn-danger btn-xs" onclick="disablemail(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                     $disable_mail =1;
                }else{
                    $button_string .= ' <a href ="javascript:void(0);" title="Enable Mail" class="btn btn-danger btn-xs" onclick="enablemail(' . $row['id'] . ')"><i class="fa fa-check-square-o"></i></a>';
                     $enable_mail =1;
                }
            }
            $notifying_employee =array();
            $notifyingemployee="";
            $employee_id=explode(',',$row['notifying_employee']);
            foreach ($employee_id as $value) {                            
                $model_employee=Employee::model()->findbyPk($value);
               if ($model_employee !== null) 
                {
                $notifying_employee[] = $this->ciphertext($model_employee->first_name, "d") . " " . $this->ciphertext($model_employee->last_name, "d");
            }
            }
            if(!empty($notifying_employee)){
                $notifyingemployee=  implode(',', $notifying_employee);
            }
            $arr = array ('Yes' => 'Y', 'No' => 'N', );
            $arr_1 = array ('Enabled' => 'Y', 'Disabled' => 'N', );
            $rowData[] = array($m, $row['maildetails']['mail_function_type'], $row['from_mail_id'],array_search ($row['self_mail'], $arr),array_search ($row['reporting_manager'], $arr), $notifyingemployee, $row['custom_mail_id'],array_search ($row['isActive'], $arr_1), array('id'=>$row['id'],'edit_mail'=>$edit_mail,'disable_mail'=>$disable_mail,'enable_mail'=>$enable_mail));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = new MailSettings();
        $id = (int) Yii::app()->request->getParam('id');
        $model_general_setting = HrGenerelSettings::model()->find();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model->from_mail_id=$model_general_setting->from_mail_id;
            $model->from_mail_name=$model_general_setting->from_mail_name;
        }else{
            $model->from_mail_id=$model_general_setting->from_mail_id;
            $model->from_mail_name=$model_general_setting->from_mail_name;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSaveMailSettings() {
        $model = new MailSettings();
        date_default_timezone_set("Asia/Dubai");
        if (isset($_POST['MailSettings'])) {
            if ((int) @$_POST['MailSettings']['id'] > 0) {
                $id = (int) @$_POST['MailSettings']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['MailSettings'];
            if(isset($_POST['MailSettings']['notifying_employee']) && count($_POST['MailSettings']['notifying_employee']) > 0){
                $model->notifying_employee = implode(',',$_POST['MailSettings']['notifying_employee']);
            }else{
                $model->notifying_employee = "";
            }
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }       
    }
    public function actionChangeStatus() {
        $id = $_POST['id'];
        $type= $_POST['type'];
        if($type==1){
            if(!empty($model))
            {
            $model->isActive="B";
           }
            MailSettings::model()->updateByPK($id, array('isActive' =>'N'));
        }else{
            MailSettings::model()->updateByPK($id, array('isActive' =>'Y'));
        }                                      
        echo "success";       
    }
    public static function sendmail($apply_from,$employee_id,$id) { 
        $view="template";
        $mailContent =$login_url=$subject=$from=$content=$applicant_name=$salutation='';
        $baseUrl = Yii::app()->getBaseUrl(true);
        $sent_mail_id=array();
        $master_branch_id=0;
        //Mail Setting
        $model_mail_setting=MailSettings::model()->find(array('condition'=>'mail_function="'.$apply_from.'"'));
        $model_general_setting = HrGenerelSettings::model()->find();
        $notifying_employee=$model_mail_setting->notifying_employee;
        if($employee_id>0){
            $model_employee=Employee::model()->findByPK($employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
        }
        $_id_to=0;
        $approval_type='ADM';//Admin Panel
        if($apply_from==1){ //Leave Application by Employee
            $model_leave=EmployeeLeaveDetail::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_leave->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Leave Application of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;           
            $content='I have applied for  ' . $model_leave->leavetype->leave_name . ' from ' . date("d/m/Y", strtotime($model_leave->leave_start_date)) . ' to ' . date("d/m/Y", strtotime($model_leave->leave_end_date)) . '. Kindly approve it.';
            $salutation='Dear Sir/Madam';
            //From Mail
            if(!empty($model_employee) && $model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if(!empty($model_mail_setting) && $model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_leave->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_leave->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_leave->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_leave->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_leave->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_leave->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_leave->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/leaveapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==2){ //Leave Approval/Rejection
            $model_leave=EmployeeLeaveDetail::model()->findByPK($id);
            $last_approved_level=$model_leave->last_approved_level;
            $max_level=$model_leave->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_leave->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Leave Application Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';        
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Type</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->leavetype->leave_name.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_leave->leave_start_date)) . '-' . date("d/m/Y", strtotime($model_leave->leave_end_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Days</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->no_days.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Reason</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->leave_reason.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeLeaveDetail::getmailStatus($model_leave->leave_status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
                        $next_level=$model_leave->last_approved_level+1;
                       //Level 1
                        if($model_leave->line_manager_approved_date!='' && $model_leave->line_manager_approved_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_leave->line_manager_approved_date!='' && $model_leave->line_manager_approved_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_leave->line_manager_approved_date)); 
                            }
                            if($model_leave->line_manager_id!=0){
                                $level_1_approval= $model_leave->linemanager->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->line_manager_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_leave->approve_level2_date!='' && $model_leave->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_leave->approve_level2_date!='' && $model_leave->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_leave->approve_level2_date)); 
                            }
                            if($model_leave->approve_level2_id!=0){
                                $level_2_approval= $model_leave->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_leave->approve_level3_date!='' && $model_leave->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_leave->approve_level3_date!='' && $model_leave->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_leave->approve_level3_date)); 
                            }
                            if($model_leave->approve_level3_id!=0){
                                $level_3_approval= $model_leave->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_leave->approve_level4_date!='' && $model_leave->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_leave->approve_level4_date!='' && $model_leave->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_leave->approve_level4_date)); 
                            }
                            if($model_leave->approve_level4_id!=0){
                                $level_4_approval= $model_leave->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_leave->approve_level5_date!='' && $model_leave->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_leave->approve_level5_date!='' && $model_leave->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_leave->approve_level5_date)); 
                            }
                            if($model_leave->approve_level5_id!=0){
                                $level_5_approval= $model_leave->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_leave->approved_date!='' && $model_leave->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_leave->approved_date!='' && $model_leave->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_leave->approved_date)); 
                            }
                            if($model_leave->approved_id!=0){
                                $approval= $model_leave->hradmin->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_leave->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->hr_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_leave->leave_status!=3 && $model_leave->leave_status!=5 && $model_leave->leave_status!=7 && $model_leave->leave_status!=9 && $model_leave->leave_status!=11 && $model_leave->leave_status!=12 && $model_leave->leave_status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_leave->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_leave->function_type,$model_leave->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_leave->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/leaveapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==3){ //Leave Cancel Request From Employee
            $model_leave=EmployeeLeaveDetail::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_leave->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Leave Cancellation request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;           
            $content='I request for the cancellation of  ' . $model_leave->leavetype->leave_name . ' from ' . date("d/m/Y", strtotime($model_leave->leave_start_date)) . ' to ' . date("d/m/Y", strtotime($model_leave->leave_end_date)) . '. Kindly approve it.';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_leave->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_leave->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_leave->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_leave->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_leave->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_leave->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_leave->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/leaveapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==4){ //Leave Cancellation Approval/Rejection
            $model_leave=EmployeeLeaveDetail::model()->findByPK($id);
            $last_approved_level=$model_leave->last_cancel_level;
            $max_level=$model_leave->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_leave->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Leave Cancellation Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name='HR Department';     
            $salutation='Dear Sir/Madam';
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Type</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->leavetype->leave_name.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_leave->leave_start_date)) . '-' . date("d/m/Y", strtotime($model_leave->leave_end_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Days</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->no_days.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Reason</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->leave_reason.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Cancellation Reason</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_reason_employee.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeLeaveDetail::getmailStatus($model_leave->leave_status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_leave->last_cancel_level+1;
                       //Level 1
                        if($model_leave->date_cancel_lm!='' && $model_leave->date_cancel_lm!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_leave->date_cancel_lm!='' && $model_leave->date_cancel_lm!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_leave->date_cancel_lm)); 
                            }
                            if($model_leave->cancel_level_1_id!=0){
                                $level_1_approval= $model_leave->cancellevel1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_comment_lm.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_leave->date_cancel_level_2!='' && $model_leave->date_cancel_level_2!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_leave->date_cancel_level_2!='' && $model_leave->date_cancel_level_2!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_leave->date_cancel_level_2)); 
                            }
                            if($model_leave->cancel_level_2_id!=0){
                                $level_2_approval= $model_leave->cancellevel2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_level_2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_leave->date_cancel_level_3!='' && $model_leave->date_cancel_level_3!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_leave->date_cancel_level_3!='' && $model_leave->date_cancel_level_3!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_leave->date_cancel_level_3)); 
                            }
                            if($model_leave->cancel_level_3_id!=0){
                                $level_3_approval= $model_leave->cancellevel3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_level_3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_leave->date_cancel_level_4!='' && $model_leave->date_cancel_level_4!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_leave->date_cancel_level_4!='' && $model_leave->date_cancel_level_4!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_leave->date_cancel_level_4)); 
                            }
                            if($model_leave->cancel_level_4_id!=0){
                                $level_4_approval= $model_leave->cancellevel4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_level_4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_leave->date_cancel_level_5!='' && $model_leave->date_cancel_level_5!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_leave->date_cancel_level_5!='' && $model_leave->date_cancel_level_5!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_leave->date_cancel_level_5)); 
                            }
                            if($model_leave->cancel_level_5_id!=0){
                                $level_5_approval= $model_leave->cancellevel5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_level_5_comment.'</td>
                                </tr>';
                        }
                        if($model_leave->date_cancel_hr!='' && $model_leave->date_cancel_hr!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_leave->date_cancel_hr!='' && $model_leave->date_cancel_hr!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_leave->date_cancel_hr)); 
                            }
                            if($model_leave->cancel_approved_id!=0){
                                $approval= $model_leave->cancelhradmin->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_leave->last_cancel_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave->cancel_comment_hr.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_leave->leave_status!=16 && $model_leave->leave_status!=18 && $model_leave->leave_status!=20 && $model_leave->leave_status!=22 && $model_leave->leave_status!=24 && $model_leave->leave_status!=25 && $model_leave->leave_status!=26){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_leave->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_leave->function_type,$model_leave->last_cancel_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_leave->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/leaveapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==5){ //Leave Encashment Application by Employee
            $model_leave_encashment=EmployeeLeaveEncashment::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_leave_encashment->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Leave Encashment Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;  
            $days='day';
            if($model_leave_encashment->encashable_leave>1){
                $days='days';
            }
            $content='I request for the encashment of  ' . $model_leave_encashment->leavetype->leave_name . ' of ' .$model_leave_encashment->encashable_leave. ' '.$days.'. Kindly approve it.';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_leave_encashment->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_leave_encashment->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_leave_encashment->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_leave_encashment->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_leave_encashment->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_leave_encashment->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_leave_encashment->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/indexencashmentapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/leaveencashmentapproval&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==6){ //Leave Encashment Approval/Rejection
            $model_leave_encashment=EmployeeLeaveEncashment::model()->findByPK($id);
            $last_approved_level=$model_leave_encashment->last_approved_level;
            $max_level=$model_leave_encashment->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_leave_encashment->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Leave Encashment Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Type</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->leavetype->leave_name.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Encashment Days</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->encashable_leave.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeLeaveEncashment::getStatus($model_leave_encashment->status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_leave_encashment->last_approved_level+1;
                       //Level 1
                        if($model_leave_encashment->approve_level1_date!='' && $model_leave_encashment->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_leave_encashment->approve_level1_date!='' && $model_leave_encashment->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_leave_encashment->approve_level1_date)); 
                            }
                            if($model_leave_encashment->approve_level1_id!=0){
                                $level_1_approval= $model_leave_encashment->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_leave_encashment->approve_level2_date!='' && $model_leave_encashment->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_leave_encashment->approve_level2_date!='' && $model_leave_encashment->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_leave_encashment->approve_level2_date)); 
                            }
                            if($model_leave_encashment->approve_level2_id!=0){
                                $level_2_approval= $model_leave_encashment->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_leave_encashment->approve_level3_date!='' && $model_leave_encashment->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_leave_encashment->approve_level3_date!='' && $model_leave_encashment->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_leave_encashment->approve_level3_date)); 
                            }
                            if($model_leave_encashment->approve_level3_id!=0){
                                $level_3_approval= $model_leave_encashment->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_leave_encashment->approve_level4_date!='' && $model_leave_encashment->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_leave_encashment->approve_level4_date!='' && $model_leave_encashment->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_leave_encashment->approve_level4_date)); 
                            }
                            if($model_leave_encashment->approve_level4_id!=0){
                                $level_4_approval= $model_leave_encashment->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_leave_encashment->approve_level5_date!='' && $model_leave_encashment->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_leave_encashment->approve_level5_date!='' && $model_leave_encashment->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_leave_encashment->approve_level5_date)); 
                            }
                            if($model_leave_encashment->approve_level5_id!=0){
                                $level_5_approval= $model_leave_encashment->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_leave_encashment->approve_date!='' && $model_leave_encashment->approve_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_leave_encashment->approve_date!='' && $model_leave_encashment->approve_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_leave_encashment->approve_date)); 
                            }
                            if($model_leave_encashment->approved_by!=0){
                                $approval= $model_leave_encashment->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_leave_encashment->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_encashment->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_leave_encashment->status!=3 && $model_leave_encashment->status!=5 && $model_leave_encashment->status!=7 && $model_leave_encashment->status!=9 && $model_leave_encashment->status!=11 && $model_leave_encashment->status!=12 && $model_leave_encashment->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_leave_encashment->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_leave_encashment->function_type,$model_leave_encashment->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_leave_encashment->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/indexencashmentapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/leave/leaveencashmentapproval&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==7){ //Ticket Encashment Request From Employee
            $model_airticket=EmployeeTicketEncashment::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_airticket->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Ticket Encashment Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;
            $content='I have applied for ticket encashment. Kindly approve it.';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_airticket->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_airticket->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_airticket->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_airticket->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_airticket->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_airticket->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_airticket->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/employeetickets/encashmentapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/employeetickets/encashmentindex&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }

        }else if($apply_from==8){ //Ticket Encashment Approval/Rejection
            $model_airticket=EmployeeTicketEncashment::model()->findByPK($id);
            $last_approved_level=$model_airticket->last_approved_level;
            $max_level=$model_airticket->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_airticket->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Ticket Encashment Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';  
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Leave Type</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->leavedetail->leave_name.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Apply Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_airticket->date_apply)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Year</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->year.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeTicketEncashment::getStatus($model_airticket->status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_airticket->last_approved_level+1;
                       //Level 1
                        if($model_airticket->approve_level1_date!='' && $model_airticket->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_airticket->approve_level1_date!='' && $model_airticket->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_airticket->approve_level1_date)); 
                            }
                            if($model_airticket->approve_level1_id!=0){
                                $level_1_approval= $model_airticket->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_airticket->approve_level2_date!='' && $model_airticket->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_airticket->approve_level2_date!='' && $model_airticket->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_airticket->approve_level2_date)); 
                            }
                            if($model_airticket->approve_level2_id!=0){
                                $level_2_approval= $model_airticket->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_airticket->approve_level3_date!='' && $model_airticket->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_airticket->approve_level3_date!='' && $model_airticket->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_airticket->approve_level3_date)); 
                            }
                            if($model_airticket->approve_level3_id!=0){
                                $level_3_approval= $model_airticket->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_airticket->approve_level4_date!='' && $model_airticket->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_airticket->approve_level4_date!='' && $model_airticket->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_airticket->approve_level4_date)); 
                            }
                            if($model_airticket->approve_level4_id!=0){
                                $level_4_approval= $model_airticket->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_airticket->approve_level5_date!='' && $model_airticket->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_airticket->approve_level5_date!='' && $model_airticket->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_airticket->approve_level5_date)); 
                            }
                            if($model_airticket->approve_level5_id!=0){
                                $level_5_approval= $model_airticket->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_airticket->approved_date!='' && $model_airticket->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_airticket->approved_date!='' && $model_airticket->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_airticket->approved_date)); 
                            }
                            if($model_airticket->approved_by!=0){
                                $approval= $model_airticket->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_airticket->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_airticket->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_airticket->status!=3 && $model_airticket->status!=5 && $model_airticket->status!=7 && $model_airticket->status!=9 && $model_airticket->status!=11 && $model_airticket->status!=12 && $model_airticket->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_airticket->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_airticket->function_type,$model_airticket->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_airticket->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/employeetickets/encashmentapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/employeetickets/encashmentindex&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==9){ //Expense Request by Employee
            $model_expense=EmployeeExpense::model()->findByPK($id);
            $model_expense_details=EmployeeExpenseDetails::model()->findAll(array('condition'=>'expense_id="'.$id.'"'));
            $model_employee=Employee::model()->findByPK($model_expense->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Expense Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;  
            $content='I have applied for  reimbursement of ' .$model_employee->currencydetails->currency_code. ' ' .Yii::app()->numberFormatter->formatCurrency($model_expense->total,"").'.Kind Approve it.The details is as follows:';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Date
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Particular
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Amount
                        </th>
                    </tr>';
                    foreach ($model_expense_details as $key => $value) {
                        $expense_date='-';
                        if($value->expense_date!='' && $value->expense_date!='0000-00-00'){
                            $expense_date=date("d/m/Y", strtotime($value->expense_date));
                        }
                        $content.='<tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">'.$expense_date.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left"">'.$value->expensedetail->expense_component.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left"">'.Yii::app()->numberFormatter->formatCurrency($value->amount,"").'</td>
                            </tr>';
                    }
            $content.='</tbody>
            </table>';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_expense->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_expense->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_expense->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_expense->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_expense->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_expense->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_expense->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/indexapproveexpense';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/hrexpense&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==10){ //Expense Request Approval/Rejection
            $model_expense=EmployeeExpense::model()->findByPK($id);
            $model_expense_details=EmployeeExpenseDetails::model()->findAll(array('condition'=>'expense_id="'.$id.'"'));
            $last_approved_level=$model_expense->last_approved_level;
            $max_level=$model_expense->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_expense->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Expense Request Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';   
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                Reimbursement Request Status-' .EmployeeExpense::getStatus($model_expense->status).'
                <br><br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Date
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Particular
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Amount
                        </th>
                    </tr>';
                    foreach ($model_expense_details as $key => $value) {
                        $expense_date='-';
                        if($value->expense_date!='' && $value->expense_date!='0000-00-00'){
                            $expense_date=date("d/m/Y", strtotime($value->expense_date));
                        }
                        $content.='<tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">'.$expense_date.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left"">'.$value->expensedetail->expense_component.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left"">'.Yii::app()->numberFormatter->formatCurrency($value->amount,"").'</td>
                            </tr>';
                    }
            $content.='</tbody>
            </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_expense->last_approved_level+1;
                       //Level 1
                        if($model_expense->approve_level1_date!='' && $model_expense->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_expense->approve_level1_date!='' && $model_expense->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_expense->approve_level1_date)); 
                            }
                            if($model_expense->approve_level1_id!=0){
                                $level_1_approval= $model_expense->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_expense->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_expense->approve_level2_date!='' && $model_expense->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_expense->approve_level2_date!='' && $model_expense->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_expense->approve_level2_date)); 
                            }
                            if($model_expense->approve_level2_id!=0){
                                $level_2_approval= $model_expense->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_expense->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_expense->approve_level3_date!='' && $model_expense->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_expense->approve_level3_date!='' && $model_expense->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_expense->approve_level3_date)); 
                            }
                            if($model_expense->approve_level3_id!=0){
                                $level_3_approval= $model_expense->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_expense->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_expense->approve_level4_date!='' && $model_expense->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_expense->approve_level4_date!='' && $model_expense->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_expense->approve_level4_date)); 
                            }
                            if($model_expense->approve_level4_id!=0){
                                $level_4_approval= $model_expense->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_expense->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_expense->approve_level5_date!='' && $model_expense->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_expense->approve_level5_date!='' && $model_expense->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_expense->approve_level5_date)); 
                            }
                            if($model_expense->approve_level5_id!=0){
                                $level_5_approval= $model_expense->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_expense->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_expense->approved_date!='' && $model_expense->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_expense->approved_date!='' && $model_expense->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_expense->approved_date)); 
                            }
                            if($model_expense->approved_by!=0){
                                $approval= $model_expense->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_expense->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_expense->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_expense->status!=3 && $model_expense->status!=5 && $model_expense->status!=7 && $model_expense->status!=9 && $model_expense->status!=11 && $model_expense->status!=12 && $model_expense->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_expense->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_expense->function_type,$model_expense->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_expense->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/indexapproveexpense';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/hrexpense&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==11){ //Resignation Request by Employee
            $model_resignation=EmployeeResignation::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_resignation->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Resignation Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Name</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_employee->employeefullname.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Apply Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_resignation->apply_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Reason</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->reason.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeResignation::getStatus($model_resignation->status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_resignation->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_resignation->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_resignation->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_resignation->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_resignation->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_resignation->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_resignation->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/approvelmresignation';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/hrresignation&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==12){ //Resignation Approval/Rejection
            $model_resignation=EmployeeResignation::model()->findByPK($id);
            $last_approved_level=$model_resignation->last_approved_level;
            $max_level=$model_resignation->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_resignation->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Resignation Request Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';    
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Name</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_employee->employeefullname.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Apply Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_resignation->apply_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Reason</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->reason.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeResignation::getStatus($model_resignation->status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_resignation->last_approved_level+1;
                       //Level 1
                        if($model_resignation->approve_level1_date!='' && $model_resignation->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_resignation->approve_level1_date!='' && $model_resignation->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_resignation->approve_level1_date)); 
                            }
                            if($model_resignation->approve_level1_id!=0){
                                $level_1_approval= $model_resignation->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_resignation->approve_level2_date!='' && $model_resignation->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_resignation->approve_level2_date!='' && $model_resignation->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_resignation->approve_level2_date)); 
                            }
                            if($model_resignation->approve_level2_id!=0){
                                $level_2_approval= $model_resignation->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_resignation->approve_level3_date!='' && $model_resignation->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_resignation->approve_level3_date!='' && $model_resignation->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_resignation->approve_level3_date)); 
                            }
                            if($model_resignation->approve_level3_id!=0){
                                $level_3_approval= $model_resignation->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_resignation->approve_level4_date!='' && $model_resignation->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_resignation->approve_level4_date!='' && $model_resignation->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_resignation->approve_level4_date)); 
                            }
                            if($model_resignation->approve_level4_id!=0){
                                $level_4_approval= $model_resignation->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_resignation->approve_level5_date!='' && $model_resignation->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_resignation->approve_level5_date!='' && $model_resignation->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_resignation->approve_level5_date)); 
                            }
                            if($model_resignation->approve_level5_id!=0){
                                $level_5_approval= $model_resignation->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_resignation->approved_date!='' && $model_resignation->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_resignation->approved_date!='' && $model_resignation->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_resignation->approved_date)); 
                            }
                            if($model_resignation->approved_by!=0){
                                $approval= $model_resignation->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_resignation->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_resignation->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_resignation->status!=3 && $model_resignation->status!=5 && $model_resignation->status!=7 && $model_resignation->status!=9 && $model_resignation->status!=11 && $model_resignation->status!=12 && $model_resignation->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_resignation->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_resignation->function_type,$model_resignation->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_resignation->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/approvelmresignation';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/hrresignation&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==13){//Complaint/Suggestion
            //Complaint/Suggestion
            $model_suggestion=ComplaintSuggestion::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_suggestion->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Complaint/Suggestion of ' .$model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;          
            $content=$model_suggestion->complaint_suggestion;   
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
        }else if($apply_from==14){ //Loan Request by Employee
            $model_loan=EmployeeLoanDetail::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_loan->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Loan Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;
            $content='I have requested for a loan amount of ' .$model_employee->currencydetails->currency_code. ' ' .Yii::app()->numberFormatter->formatCurrency($model_loan->loan_amount,""). '.Kindly approve it.';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_loan->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_loan->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_loan->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_loan->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_loan->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_loan->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_loan->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/loandetail/loanapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/loandetail/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==15){ //Loan Approval
            $model_loan=EmployeeLoanDetail::model()->findByPK($id);
            $last_approved_level=$model_loan->last_approved_level;
            $max_level=$model_loan->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_loan->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Loan Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';    
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Loan Amount</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_employee->currencydetails->currency_code. ' ' .Yii::app()->numberFormatter->formatCurrency($model_loan->loan_amount,"").'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Proposed Installment</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->proposed_installment.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Proposed Installment Amount</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_employee->currencydetails->currency_code. ' ' .Yii::app()->numberFormatter->formatCurrency($model_loan->proposed_monthly_installment,"").'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Apply Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_loan->apply_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeLoanDetail::getLoanStatus($model_loan->loan_status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_loan->last_approved_level+1;
                       //Level 1
                        if($model_loan->approve_level1_date!='' && $model_loan->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_loan->approve_level1_date!='' && $model_loan->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_loan->approve_level1_date)); 
                            }
                            if($model_loan->approve_level1_id!=0){
                                $level_1_approval= $model_loan->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_loan->approve_level2_date!='' && $model_loan->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_loan->approve_level2_date!='' && $model_loan->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_loan->approve_level2_date)); 
                            }
                            if($model_loan->approve_level2_id!=0){
                                $level_2_approval= $model_loan->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_loan->approve_level3_date!='' && $model_loan->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_loan->approve_level3_date!='' && $model_loan->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_loan->approve_level3_date)); 
                            }
                            if($model_loan->approve_level3_id!=0){
                                $level_3_approval= $model_loan->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_loan->approve_level4_date!='' && $model_loan->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_loan->approve_level4_date!='' && $model_loan->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_loan->approve_level4_date)); 
                            }
                            if($model_loan->approve_level4_id!=0){
                                $level_4_approval= $model_loan->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_loan->approve_level5_date!='' && $model_loan->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_loan->approve_level5_date!='' && $model_loan->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_loan->approve_level5_date)); 
                            }
                            if($model_loan->approve_level5_id!=0){
                                $level_5_approval= $model_loan->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_loan->approved_date!='' && $model_loan->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_loan->approved_date!='' && $model_loan->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_loan->approved_date)); 
                            }
                            if($model_loan->approved_by!=0){
                                $approval= $model_loan->hradmin->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_loan->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_loan->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_loan->loan_status!=3 && $model_loan->loan_status!=5 && $model_loan->loan_status!=7 && $model_loan->loan_status!=9 && $model_loan->loan_status!=11 && $model_loan->loan_status!=12 && $model_loan->loan_status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_loan->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        } 
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_loan->function_type,$model_loan->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_loan->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/loandetail/loanapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/loandetail/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==16){ //Salary Advance Request by Employee
            $model_advance=EmployeeSalaryAdvance::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_advance->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Salary Advance Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;
            $content='I have requested for a salary advance of ' .$model_employee->currencydetails->currency_code. ' ' .Yii::app()->numberFormatter->formatCurrency($model_advance->amount,""). '.Kindly approve it.'; 
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_advance->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_advance->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_advance->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_advance->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_advance->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_advance->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_advance->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/salaryadvance/advanceapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/salaryadvance/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==17){ //Salary Advance Approval
            $model_advance=EmployeeSalaryAdvance::model()->findByPK($id);
            $last_approved_level=$model_advance->last_approved_level;
            $max_level=$model_advance->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_advance->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Salary Advance Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Loan Amount</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_employee->currencydetails->currency_code. ' ' .Yii::app()->numberFormatter->formatCurrency($model_advance->amount,"").'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Apply Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_advance->apply_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeSalaryAdvance::getStatus($model_advance->advance_payment_status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_advance->last_approved_level+1;
                       //Level 1
                        if($model_advance->approve_level1_date!='' && $model_advance->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_advance->approve_level1_date!='' && $model_advance->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_advance->approve_level1_date)); 
                            }
                            if($model_advance->approve_level1_id!=0){
                                $level_1_approval= $model_advance->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_advance->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_advance->approve_level2_date!='' && $model_advance->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_advance->approve_level2_date!='' && $model_advance->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_advance->approve_level2_date)); 
                            }
                            if($model_advance->approve_level2_id!=0){
                                $level_2_approval= $model_advance->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_advance->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_advance->approve_level3_date!='' && $model_advance->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_advance->approve_level3_date!='' && $model_advance->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_advance->approve_level3_date)); 
                            }
                            if($model_advance->approve_level3_id!=0){
                                $level_3_approval= $model_advance->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_advance->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_advance->approve_level4_date!='' && $model_advance->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_advance->approve_level4_date!='' && $model_advance->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_advance->approve_level4_date)); 
                            }
                            if($model_advance->approve_level4_id!=0){
                                $level_4_approval= $model_advance->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_advance->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_advance->approve_level5_date!='' && $model_advance->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_advance->approve_level5_date!='' && $model_advance->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_advance->approve_level5_date)); 
                            }
                            if($model_advance->approve_level5_id!=0){
                                $level_5_approval= $model_advance->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_advance->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_advance->approved_date!='' && $model_advance->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_advance->approved_date!='' && $model_advance->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_advance->approved_date)); 
                            }
                            if($model_advance->approved_by!=0){
                                $approval= $model_advance->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_advance->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_advance->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_advance->advance_payment_status!=3 && $model_advance->advance_payment_status!=5 && $model_advance->advance_payment_status!=7 && $model_advance->advance_payment_status!=9 && $model_advance->advance_payment_status!=11 && $model_advance->advance_payment_status!=12 && $model_advance->advance_payment_status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_advance->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_advance->function_type,$model_advance->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_advance->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/salaryadvance/advanceapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/salaryadvance/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==18){ //Document Request by Employee
            $model_certificate=EmployeeCertificate::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_certificate->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Document Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;  
            $content='I have requested for '.$model_certificate->mascertificate->certificate_name.'.Kindly approve it.';  
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_certificate->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_certificate->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_certificate->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_certificate->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_certificate->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_certificate->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_certificate->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/certificateapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==19){ //Document Request Approval
            $model_certificate=EmployeeCertificate::model()->findByPK($id);
            $last_approved_level=$model_certificate->last_approved_level;
            $max_level=$model_certificate->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_certificate->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Document Request Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';        
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Document Name</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->mascertificate->certificate_name.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Apply Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_certificate->apply_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.EmployeeCertificate::getStatus($model_certificate->status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_certificate->last_approved_level+1;
                       //Level 1
                        if($model_certificate->approve_level1_date!='' && $model_certificate->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_certificate->approve_level1_date!='' && $model_certificate->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_certificate->approve_level1_date)); 
                            }
                            if($model_certificate->approve_level1_id!=0){
                                $level_1_approval= $model_certificate->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_certificate->approve_level2_date!='' && $model_certificate->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_certificate->approve_level2_date!='' && $model_certificate->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_certificate->approve_level2_date)); 
                            }
                            if($model_certificate->approve_level2_id!=0){
                                $level_2_approval= $model_certificate->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_certificate->approve_level3_date!='' && $model_certificate->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_certificate->approve_level3_date!='' && $model_certificate->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_certificate->approve_level3_date)); 
                            }
                            if($model_certificate->approve_level3_id!=0){
                                $level_3_approval= $model_certificate->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_certificate->approve_level4_date!='' && $model_certificate->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_certificate->approve_level4_date!='' && $model_certificate->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_certificate->approve_level4_date)); 
                            }
                            if($model_certificate->approve_level4_id!=0){
                                $level_4_approval= $model_certificate->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_certificate->approve_level5_date!='' && $model_certificate->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_certificate->approve_level5_date!='' && $model_certificate->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_certificate->approve_level5_date)); 
                            }
                            if($model_certificate->approve_level5_id!=0){
                                $level_5_approval= $model_certificate->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_certificate->approval_date!='' && $model_certificate->approval_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_certificate->approval_date!='' && $model_certificate->approval_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_certificate->approval_date)); 
                            }
                            if($model_certificate->approval_id!=0){
                                $approval= $model_certificate->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_certificate->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_certificate->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_certificate->status!=3 && $model_certificate->status!=5 && $model_certificate->status!=7 && $model_certificate->status!=9 && $model_certificate->status!=11 && $model_certificate->status!=12 && $model_certificate->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_certificate->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_certificate->function_type,$model_certificate->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_certificate->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/certificateapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrrequest/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==20){
            $model_leave_excuse=EmployeeLeaveExcuse::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_leave_excuse->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $request_type="Excuse";
            if($model_leave_excuse->type==1){
                $request_type="Meeting";
            }
            $subject=$request_type.' Request of '.$model_employee->employeefullname.' ('.$model_employee->employeecode.')';                      
            $applicant_name=$model_employee->employeefullname;
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_leave_excuse->request_date)).'</td>
                        </tr>';
                        if($model_leave_excuse->type==1){
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px;">Customer Name</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_excuse->customer_name.'</td>
                            </tr>';
                        }
                        $content.='<tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Start time</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_excuse->start_time.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">End time</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_excuse->end_time.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Reason</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_leave_excuse->excuse_reason.'</td>
                        </tr>
                    </tbody>
               </table>';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //End From Mail
        }else if($apply_from==21 || $apply_from==22){ //Indoor Circular,Outdoor Circular
            //Circular
            $model_circular=CompanyCircular::model()->findByPK($id);
            $subject='Circular';            
            $applicant_name='HR Department';
            $content=$model_circular->notes; 
            $salutation='Dear Sir/Madam';
            $master_branch_id=0;
            //From Mail
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (filter_var($model_user->email, FILTER_VALIDATE_EMAIL)) {
                $from=$model_user->email;
            }         
            //End From Mail
            //To mail-Start
            $condition='isActive="Y"';
            if($model_circular->branch_or_sponsor_id!=''){
                $condition.=' and branch_or_sponsor_id IN ('.$model_circular->branch_or_sponsor_id.')';
            }
            if($model_circular->employee_id!=''){
                $condition.=' and id IN ('.$model_circular->employee_id.')';
            }
            $model_branch_employees = Employee::model()->findAll(array('condition' =>$condition));
            foreach ($model_branch_employees as $key => $value) {
                if($value->email!=''){
                    if (filter_var($value->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$value->email;
                    }
                }
            }
            //To Mail-End
        }else if($apply_from==23){
            $model_appraisal=HrAppraisal::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_appraisal->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Appraisal for '.$model_appraisal->appraisal_for;            
            $applicant_name='HR Department';                   
            $content='Appraisal Evaluation Details added.Please evaluate and send feedback.';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_appraisal->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_appraisal->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_appraisal->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_appraisal->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_appraisal->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_appraisal->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_appraisal->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/appraisal/lmindex';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/appraisal/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==24){ //Appraisal Review
            $model_appraisal=HrAppraisal::model()->findByPK($id);
            $model_appraisal_details=HrAppraisalAnalysis::model()->findAll(array('condition' => 'appraisal_id="'. $id.'"'));
            $last_approved_level=$model_appraisal->last_approved_level;
            $next_level=$model_appraisal->last_approved_level+1;
            $max_level=$model_appraisal->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_appraisal->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Appraisal Review of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';      
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Question</th>';
                            if($next_level>=2 && $max_level>=1) {
                                $content.='<th style="border: 1px solid #666;padding: 4px 5px;">Level 1 Review</th>
                                         <th style="border: 1px solid #666;padding: 4px 5px;">Score</th>';
                            }
                            if($next_level>=3 && $max_level>=2) {
                                $content.='<th style="border: 1px solid #666;padding: 4px 5px;">Level 2 Review</th>
                                         <th style="border: 1px solid #666;padding: 4px 5px;">Score</th>';
                            }
                            if($next_level>=4 && $max_level>=3) {
                                $content.='<th style="border: 1px solid #666;padding: 4px 5px;">Level 3 Review</th>
                                         <th style="border: 1px solid #666;padding: 4px 5px;">Score</th>';
                            }
                            if($next_level>=5 && $max_level>=4) {
                                $content.='<th style="border: 1px solid #666;padding: 4px 5px;">Level 4 Review</th>
                                         <th style="border: 1px solid #666;padding: 4px 5px;">Score</th>';
                            }
                            if($next_level>=6 && $max_level>=5) {
                                $content.='<th style="border: 1px solid #666;padding: 4px 5px;">Level 5 Review</th>
                                         <th style="border: 1px solid #666;padding: 4px 5px;">Score</th>';
                            }
                       $content.='</tr>';
                       foreach ($model_appraisal_details as $i => $detail){
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$detail->question.'</td>';
                                if($next_level>=2 && $max_level>=1) {
                                    $content.='<td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level1_answer.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level1_score.'</td>';
                                }
                                if($next_level>=3 && $max_level>=2) {
                                    $content.='<td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level2_answer.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level2_score.'</td>';
                                }
                                if($next_level>=4 && $max_level>=3) {
                                    $content.='<td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level3_answer.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level3_score.'</td>';
                                }
                                if($next_level>=5 && $max_level>=4) {
                                    $content.='<td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level4_answer.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level4_score.'</td>';
                                }
                                if($next_level>=6 && $max_level>=5) {
                                    $content.='<td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level5_answer.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$detail->level5_score.'</td>';
                                }
                            $content.='</tr>';
                       }
                    $content.='</tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
                       //Level 1
                        if($model_appraisal->approve_level1_date!='' && $model_appraisal->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_appraisal->approve_level1_date!='' && $model_appraisal->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_appraisal->approve_level1_date)); 
                            }
                            if($model_appraisal->approve_level1_id!=0){
                                $level_1_approval= $model_appraisal->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Reviewed';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_appraisal->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_appraisal->approve_level2_date!='' && $model_appraisal->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_appraisal->approve_level2_date!='' && $model_appraisal->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_appraisal->approve_level2_date)); 
                            }
                            if($model_appraisal->approve_level2_id!=0){
                                $level_2_approval= $model_appraisal->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Reviewed';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_appraisal->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_appraisal->approve_level3_date!='' && $model_appraisal->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_appraisal->approve_level3_date!='' && $model_appraisal->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_appraisal->approve_level3_date)); 
                            }
                            if($model_appraisal->approve_level3_id!=0){
                                $level_3_approval= $model_appraisal->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Reviewed';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_appraisal->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_appraisal->approve_level4_date!='' && $model_appraisal->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_appraisal->approve_level4_date!='' && $model_appraisal->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_appraisal->approve_level4_date)); 
                            }
                            if($model_appraisal->approve_level4_id!=0){
                                $level_4_approval= $model_appraisal->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Reviewed';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_appraisal->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_appraisal->approve_level5_date!='' && $model_appraisal->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_appraisal->approve_level5_date!='' && $model_appraisal->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_appraisal->approve_level5_date)); 
                            }
                            if($model_appraisal->approve_level5_id!=0){
                                $level_5_approval= $model_appraisal->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Reviewed';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_appraisal->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_appraisal->approved_date!='' && $model_appraisal->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_appraisal->approved_date!='' && $model_appraisal->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_appraisal->approved_date)); 
                            }
                            if($model_appraisal->approved_by!=0){
                                $approval= $model_appraisal->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Reviewed';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_appraisal->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_appraisal->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_appraisal->status!=2 && $model_appraisal->status!=4 && $model_appraisal->status!=6 && $model_appraisal->status!=8 && $model_appraisal->status!=10 && $model_appraisal->status!=12){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_appraisal->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_appraisal->function_type,$model_appraisal->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_appraisal->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/appraisal/lmindex';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/appraisal/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==25){
            //Birthday Greetings
            $model_employee=Employee::model()->findByPK($employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            //From Mail
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (filter_var($model_user->email, FILTER_VALIDATE_EMAIL)) {
                $from=$model_user->email;
            }         
            //End From Mail
            $subject='Greetings';  
            $applicant_name='HR Department';  
            if($id==1){
                $content='Wishing you the best on your birthday and everything good in the year ahead.';
            }else{
                $content='All your co-workers wants to tell you that we are thankful for all your words of wisdom, all your kindness, and everything you have done to make our workspace gentler in so many ways. Happy anniversary.';
            }
            $salutation='Dear ' .$model_employee->employeefullname.',';

        }else if($apply_from==26){
            $model_documents=EmployeeDocuments::model()->findByPK($id);
            $model_employee=Employee::model()->findByPK($model_documents->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject=$model_documents->document->document_name.' expiry of ' .$model_employee->employeefullname.' ('.$model_employee->employeecode.')';                        
            $applicant_name='HR Department';
            $msg='expired on';
            if(strtotime($model_documents->validate_till_date)>  strtotime(date('Y-m-d'))){
                $msg='will be expired on';
            }
            $content='Your '.$model_documents->document->document_name.' '.$msg.' '.date("d/m/Y", strtotime($model_documents->validate_till_date)).'.Please renew it.';   
            $salutation='Dear ' .$model_employee->employeefullname;        
            //From Mail
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (filter_var($model_user->email, FILTER_VALIDATE_EMAIL)) {
                $from=$model_user->email;
            }      
        }else if($apply_from==27){
            $model_documents=CompanyDocument::model()->findByPK($id);
            $master_branch_id=0;
            $msg='Document Expired';
            $msg_1='expired on';
            if(strtotime($model_documents->validate_till_date)>  strtotime(date('Y-m-d'))){
                $msg='Document Expiry';
                $msg_1='will be expired on';
            }
            $subject=$msg;                       
            $applicant_name='HR Department';           
            $content=$model_documents->documentname->document_name.' '.$msg_1.' '.date("d/m/Y", strtotime($model_documents->validate_till_date)).'.Please renew it.';   
            $salutation='Dear Sir/Madam';       
            //From Mail
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (filter_var($model_user->email, FILTER_VALIDATE_EMAIL)) {
                $from=$model_user->email;
            }      
        }else if($apply_from==28){ //Purchase Request by Employee
            $model_purchase=EmployeePurchase::model()->findByPK($id);
            $model_purchase_details=EmployeePurchaseDetail::model()->findAll(array('condition'=>'purchase_id="'.$id.'"'));
            $model_employee=Employee::model()->findByPK($model_purchase->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Purchase Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;  
            $content='Purchase Request Details.<br><br>';
            $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Product
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Quantity
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Total Amount
                        </th>
                    </tr>';
                    foreach ($model_purchase_details as $key => $value) {
                        $content.='<tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">'.$value->productdetail->product_name.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left"">'.$value->quantity.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: right"">'.Yii::app()->numberFormatter->formatCurrency($value->amount,"").'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: right"">'.Yii::app()->numberFormatter->formatCurrency($value->total_amount,"").'</td>
                            </tr>';
                    }
            $content.='</tbody>
            </table>';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_purchase->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_purchase->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_purchase->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_purchase->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_purchase->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_purchase->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_purchase->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/productpurchase/purchaseapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/purchaseproduct/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==29){ //Expense Request Approval/Rejection
            $model_purchase=EmployeePurchase::model()->findByPK($id);
            $model_purchase_details=EmployeePurchaseDetail::model()->findAll(array('condition'=>'purchase_id="'.$id.'"'));
            $last_approved_level=$model_purchase->last_approved_level;
            $max_level=$model_purchase->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_purchase->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject='Purchase Request Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';          
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                Purchase Request Status-' .EmployeePurchase::getStatus($model_purchase->status).'
                <br><br>';
               $content.='<table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                <tbody>
                    <tr>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Product
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Quantity
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Rate
                        </th>
                        <th style="border: 1px solid #666;padding: 4px 5px;">
                        Total Amount
                        </th>
                    </tr>';
                    foreach ($model_purchase_details as $key => $value) {
                        $content.='<tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">'.$value->productdetail->product_name.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left"">'.$value->quantity.'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: right"">'.Yii::app()->numberFormatter->formatCurrency($value->amount,"").'</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: right"">'.Yii::app()->numberFormatter->formatCurrency($value->total_amount,"").'</td>
                            </tr>';
                    }
            $content.='</tbody>
            </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_purchase->last_approved_level+1;
                       //Level 1
                        if($model_purchase->approve_level1_date!='' && $model_purchase->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_purchase->approve_level1_date!='' && $model_purchase->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_purchase->approve_level1_date)); 
                            }
                            if($model_purchase->approve_level1_id!=0){
                                $level_1_approval= $model_purchase->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_purchase->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_purchase->approve_level2_date!='' && $model_purchase->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_purchase->approve_level2_date!='' && $model_purchase->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_purchase->approve_level2_date)); 
                            }
                            if($model_purchase->approve_level2_id!=0){
                                $level_2_approval= $model_purchase->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_purchase->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_purchase->approve_level3_date!='' && $model_purchase->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_purchase->approve_level3_date!='' && $model_purchase->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_purchase->approve_level3_date)); 
                            }
                            if($model_purchase->approve_level3_id!=0){
                                $level_3_approval= $model_purchase->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_purchase->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_purchase->approve_level4_date!='' && $model_purchase->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_purchase->approve_level4_date!='' && $model_purchase->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_purchase->approve_level4_date)); 
                            }
                            if($model_purchase->approve_level4_id!=0){
                                $level_4_approval= $model_purchase->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_purchase->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_purchase->approve_level5_date!='' && $model_purchase->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_purchase->approve_level5_date!='' && $model_purchase->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_purchase->approve_level5_date)); 
                            }
                            if($model_purchase->approve_level5_id!=0){
                                $level_5_approval= $model_purchase->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_purchase->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_purchase->approved_date!='' && $model_purchase->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_purchase->approved_date!='' && $model_purchase->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_purchase->approved_date)); 
                            }
                            if($model_purchase->approved_by!=0){
                                $approval= $model_purchase->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_purchase->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_purchase->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_purchase->status!=3 && $model_purchase->status!=5 && $model_purchase->status!=7 && $model_purchase->status!=9 && $model_purchase->status!=11 && $model_purchase->status!=12 && $model_purchase->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_purchase->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_purchase->function_type,$model_purchase->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_purchase->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/productpurchase/purchaseapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/purchaseproduct/index&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
        }else if($apply_from==30){
            //Staff Board
            $model_notification=HrNotification::model()->findByPK($id);
            $master_branch_id=0;
            $subject='Notification';            
            $applicant_name='HR Department';
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: center" colspan="2"><b>'.$model_notification->title.'</b></td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left" colspan="2">'.$model_notification->content.'</td>
                        </tr>
                    </tbody>
               </table>';
            $salutation='Dear All';

            //From Mail
            $model_user = User::model()->findByPk(Yii::app()->user->id);
            if (filter_var($model_user->email, FILTER_VALIDATE_EMAIL)) {
                $from=$model_user->email;
            }         
            //End From Mail
            //To mail-Start
            $condition='isActive="Y"';
            if($model_notification->branch!=''){
                $condition.=' and branch_or_sponsor_id IN ('.$model_notification->branch.')';
            }
            if($model_notification->department_id!=''){
                $condition.=' and department IN ('.$model_notification->department_id.')';
            }
            if($model_notification->designation!=''){
                $condition.=' and designation IN ('.$model_notification->designation.')';
            }
            if($model_notification->employee_id!=''){
                $condition.=' and id IN ('.$model_notification->employee_id.')';
            }
            $model_branch_employees = Employee::model()->findAll(array('condition' =>$condition));
            $d=0;
            foreach ($model_branch_employees as $key => $value) {
                if($value->email!=''){
                    if (filter_var($value->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$value->email;
                    }
                }
            }
            //To Mail-End
        }else if($apply_from==32){
            $model_attendance_clarification=HrEmployeeAttendanceExcuse::model()->findByPK($id);       
            $model_attendance_clarification_details= HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="'. $id.'"'));
            $model_employee=Employee::model()->findByPK($model_attendance_clarification->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject=' Meeting / Flexi Time Request of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';            
            $applicant_name=$model_employee->employeefullname;   
            $content.='Kindly approve the below request for Being Away from the Workplace:'; 
            $content.='<br>'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;max-width: 1200px;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Type</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Business Partner</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Start Time</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">End Time</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Reason / Purpose</th>
                       </tr>';
            foreach ($model_attendance_clarification_details as $i => $details){
                $excuse_date='';
                if ($details->excuse_date != '' && $details->excuse_date != '0000-00-00') {
                    $excuse_date = date('d/m/Y', strtotime($details->excuse_date));
                }
                $content.='<tr>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$details->typedetail->excuse_type.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$excuse_date.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->customer_name.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->start_time.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->end_time.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->excuse_reason.'</td>
                    </tr>';
            }
            $content.='</tbody>
            </table>';
            $salutation='Dear Sir/Madam';
            //From Mail
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $from=$model_employee->email;
                }
            }
            //To mail
            //To mail
            if($model_mail_setting->approval_authority=='Y'){
                //Reporting Manager
                if($model_attendance_clarification->approvelevel->level_1_type=='L'){
                    if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->reportingmanager->email;
                        $_id_to=$model_attendance_clarification->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Supervisor
                if($model_attendance_clarification->approvelevel->level_1_type=='S'){
                    if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_employee->attendancemanager->email;
                        $_id_to=$model_attendance_clarification->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
                //Other Employee
                if($model_attendance_clarification->approvelevel->level_1_type=='N'){
                    $model_authority=Employee::model()->findByPK($model_attendance_clarification->approvelevel->level_1_authority);
                    if (filter_var($model_authority->email, FILTER_VALIDATE_EMAIL)) {
                        $sent_mail_id[]=$model_authority->email;
                        $_id_to=$model_attendance_clarification->approvelevel->level_1_authority;
                    }
                    $approval_type='ESS';
                }
            }
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrattendanceexcuse/indexapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrattendanceexcuse/indexlist&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
            //End From Mail
        }else if($apply_from==33){ //Business Meeting / Market Visit / Flexi Time Request Approval/Rejection
            $model_attendance_clarification=HrEmployeeAttendanceExcuse::model()->findByPK($id);
            $model_attendance_clarification_details= HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="'. $id.'" and rejected_level="0"'));
            $last_approved_level=$model_attendance_clarification->last_approved_level;
            $max_level=$model_attendance_clarification->approvelevel->max_level;
            $model_employee=Employee::model()->findByPK($model_attendance_clarification->employee_id);
            $master_branch_id=$model_employee->branch_or_sponsor_id;
            $subject=' Meeting / Flexi Time Request Status of ' . $model_employee->employeefullname.' ('.$model_employee->employeecode.')';     
            $salutation='Dear Sir/Madam';
            $applicant_name='HR Department'; 
            $content.='
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;max-width: 800px;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Employee Name</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_employee->employeefullname.'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Applied Date</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.date("d/m/Y", strtotime($model_attendance_clarification->apply_date)).'</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #666;padding: 4px 5px;">Status</td>
                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.HrEmployeeAttendanceExcuse::getStatus($model_attendance_clarification->status).'</td>
                        </tr>
                    </tbody>
               </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto; max-width: 1200px;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Type</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Business Partner</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Start Time</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">End Time</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Reason / Purpose</th>
                       </tr>';
            foreach ($model_attendance_clarification_details as $i => $details){
                $excuse_date='';
                if ($details->excuse_date != '' && $details->excuse_date != '0000-00-00') {
                    $excuse_date = date('d/m/Y', strtotime($details->excuse_date));
                }
                $content.='<tr>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$details->typedetail->excuse_type.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$excuse_date.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->customer_name.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->start_time.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->end_time.'</td>
                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$details->excuse_reason.'</td>
                    </tr>';
            }
             $content.='</tbody>
            </table>';
            $content.='
                <br>
                <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Space Grotesk,sans-serif;">
                   <tbody>
                       <tr>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Level</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Date</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Authority</th>
                           <th style="border: 1px solid #666;padding: 4px 5px;">Comment</th>
                       </tr>';
            $next_level=$model_attendance_clarification->last_approved_level+1;
                       //Level 1
                        if($model_attendance_clarification->approve_level1_date!='' && $model_attendance_clarification->approve_level1_date!='0000-00-00'){
                            $level_1_date=$level_1_approval='';
                            if($model_attendance_clarification->approve_level1_date!='' && $model_attendance_clarification->approve_level1_date!='0000-00-00'){
                                $level_1_date= date("d/m/Y", strtotime($model_attendance_clarification->approve_level1_date)); 
                            }
                            if($model_attendance_clarification->approve_level1_id!=0){
                                $level_1_approval= $model_attendance_clarification->level1->employeefullname;
                            }else{
                                $level_1_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">1</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_1_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_attendance_clarification->approve_level1_comment.'</td>
                                </tr>';
                        }
                        //Level 2
                        if($model_attendance_clarification->approve_level2_date!='' && $model_attendance_clarification->approve_level2_date!='0000-00-00'){
                            $level_2_date=$level_2_approval='';
                            if($model_attendance_clarification->approve_level2_date!='' && $model_attendance_clarification->approve_level2_date!='0000-00-00'){
                                $level_2_date= date("d/m/Y", strtotime($model_attendance_clarification->approve_level2_date)); 
                            }
                            if($model_attendance_clarification->approve_level2_id!=0){
                                $level_2_approval= $model_attendance_clarification->level2->employeefullname;
                            }else{
                                $level_2_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">2</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_2_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_attendance_clarification->approve_level2_comment.'</td>
                                </tr>';
                        }
                        //Level 3
                        if($model_attendance_clarification->approve_level3_date!='' && $model_attendance_clarification->approve_level3_date!='0000-00-00'){
                            $level_3_date=$level_3_approval='';
                            if($model_attendance_clarification->approve_level3_date!='' && $model_attendance_clarification->approve_level3_date!='0000-00-00'){
                                $level_3_date= date("d/m/Y", strtotime($model_attendance_clarification->approve_level3_date)); 
                            }
                            if($model_attendance_clarification->approve_level3_id!=0){
                                $level_3_approval= $model_attendance_clarification->level3->employeefullname;
                            }else{
                                $level_3_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">3</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_3_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_attendance_clarification->approve_level3_comment.'</td>
                                </tr>';
                        }
                        //Level 4
                        if($model_attendance_clarification->approve_level4_date!='' && $model_attendance_clarification->approve_level4_date!='0000-00-00'){
                            $level_4_date=$level_4_approval='';
                            if($model_attendance_clarification->approve_level4_date!='' && $model_attendance_clarification->approve_level4_date!='0000-00-00'){
                                $level_4_date= date("d/m/Y", strtotime($model_attendance_clarification->approve_level4_date)); 
                            }
                            if($model_attendance_clarification->approve_level4_id!=0){
                                $level_4_approval= $model_attendance_clarification->level4->employeefullname;
                            }else{
                                $level_4_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">4</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_4_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_attendance_clarification->approve_level4_comment.'</td>
                                </tr>';
                        }
                        //Level 5
                        if($model_attendance_clarification->approve_level5_date!='' && $model_attendance_clarification->approve_level5_date!='0000-00-00'){
                            $level_5_date=$level_5_approval='';
                            if($model_attendance_clarification->approve_level5_date!='' && $model_attendance_clarification->approve_level5_date!='0000-00-00'){
                                $level_5_date= date("d/m/Y", strtotime($model_attendance_clarification->approve_level5_date)); 
                            }
                            if($model_attendance_clarification->approve_level5_id!=0){
                                $level_5_approval= $model_attendance_clarification->level5->employeefullname;
                            }else{
                                $level_5_approval= 'HR Approval';
                            }
                            $content.='<tr>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">5</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_date.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$level_5_approval.'</td>
                                <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_attendance_clarification->approve_level5_comment.'</td>
                                </tr>';
                        }
                        if($model_attendance_clarification->approved_date!='' && $model_attendance_clarification->approved_date!='0000-00-00'){
                            $approval_date=$approval='';
                            if($model_attendance_clarification->approved_date!='' && $model_attendance_clarification->approved_date!='0000-00-00'){
                                $approval_date= date("d/m/Y", strtotime($model_attendance_clarification->approved_date)); 
                            }
                            if($model_attendance_clarification->approved_by!=0){
                                $approval= $model_attendance_clarification->finalapprove->employeefullname;
                            }else{
                                $approval= 'HR Approval';
                            }
                            $content.='<tr>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align:center">'.$model_attendance_clarification->last_approved_level.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval_date.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$approval.'</td>
                                    <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$model_attendance_clarification->approval_comment.'</td>
                                    </tr>';
                        }
            $content.='</tbody>
            </table>';
            if($model_mail_setting->approval_authority=='Y'){
                if($model_attendance_clarification->status!=3 && $model_attendance_clarification->status!=5 && $model_attendance_clarification->status!=7 && $model_attendance_clarification->status!=9 && $model_attendance_clarification->status!=11 && $model_attendance_clarification->status!=12 && $model_attendance_clarification->status!=13){
                    $level_employee_id=HrEmployeeApproveLevel::getmailid($model_attendance_clarification->function_type,$next_level);
                    if($level_employee_id>0){
                        $model_approval_employee=Employee::model()->findByPK($level_employee_id);
                        if (filter_var($model_approval_employee->email, FILTER_VALIDATE_EMAIL)) {
                            $sent_mail_id[]=$model_approval_employee->email;
                            $_id_to=$level_employee_id;
                        }
                    }
                    $level_employee_id_1=HrEmployeeApproveLevel::getmailid($model_attendance_clarification->function_type,$model_attendance_clarification->last_approved_level);
                    if($level_employee_id_1>0){
                        $model_approval_employee_1=Employee::model()->findByPK($level_employee_id_1);
                        $applicant_name=$model_approval_employee_1->employeefullname;  
                    }
                }
            }
            $approval_type=HrEmployeeApproveLevel::getleveltype($model_attendance_clarification->function_type,$next_level);
            if($approval_type=='ESS'){
                $login_url=$baseUrl.'/index.php?r=hr/hrattendanceexcuse/indexapproval';
            }else if($approval_type=='ADM'){
                $login_url=$baseUrl.'/index.php?r=hr/hrattendanceexcuse/indexlist&id='.Yii::app()->controller->ciphertext($model_employee->branch_or_sponsor_id, "e");
            }
            //End From Mail
        }
        
        
        //Start Mail Content
        $mailContent= '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">
                            <div>'.$salutation.',</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Sub: '.$subject.'</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">'                          
                            .$content.'<br>
                            <br>
                            <br>
                            Thanking you,
                            <br>
                            <br>
                            Yours sincerely,
                            <br>
                            <br>
                            '.$applicant_name.'
                        </td>
                    </tr>
                </tbody>
            </table>';
        //End Mail Content
        //Mail sending-Start
        //Mail From Start       
        if($model_mail_setting->from_mail_id!=''){
            if (filter_var($model_mail_setting->from_mail_id, FILTER_VALIDATE_EMAIL)) {
                $from=$model_mail_setting->from_mail_id;
            }
        }
        //Supervisor-Start
        $attendance_manager_id=0;
        if($model_mail_setting->attendance_manager=='Y' && $_id_to!=$model_employee->attendance_manager){
            if($model_employee->id>0){
                $attendance_manager_id=$model_employee->attendance_manager;
                if (filter_var($model_employee->attendancemanager->email, FILTER_VALIDATE_EMAIL)) {
                    $sent_mail_id[]=$model_employee->attendancemanager->email;
                }
            }
        }
        //Supervisor-End
        //Reporting Manager-Start
        if($model_mail_setting->reporting_manager=='Y' && $_id_to!=$model_employee->reporting_manager && $attendance_manager_id!=$model_employee->reporting_manager){
            if($model_employee->id>0){
                if (filter_var($model_employee->reportingmanager->email, FILTER_VALIDATE_EMAIL)) {
                    $sent_mail_id[]=$model_employee->reportingmanager->email;
                }
            }
        }
        //Reporting Manager-End
        //Start Self Mail
        if($model_mail_setting->self_mail=='Y' && $_id_to!=$model_employee->id && $model_employee->reporting_manager!=$model_employee->id && $attendance_manager_id!=$model_employee->id){           
            if($model_employee->id>0){
                if (filter_var($model_employee->email, FILTER_VALIDATE_EMAIL)) {
                    $sent_mail_id[]=$model_employee->email;
                }
            }
        }
        //End Self Mail
        //Notifying Employee-Start
        $notifyingemployee=array();
        if($notifying_employee!=''){
            $notifyingemployee=explode(',', $notifying_employee);            
            $m=0;
            foreach (array_keys($notifyingemployee,$_id_to) as $key) {
                unset($notifyingemployee[$key]);                                        
                $notifyingemployee=array_values($notifyingemployee);
            } 
            foreach (array_keys($notifyingemployee,$attendance_manager_id) as $key) {
                unset($notifyingemployee[$key]);                                        
                $notifyingemployee=array_values($notifyingemployee);
            } 
            foreach (array_keys($notifyingemployee,$model_employee->reporting_manager) as $key) {
                unset($notifyingemployee[$key]);                                        
                $notifyingemployee=array_values($notifyingemployee);
            } 
            foreach (array_keys($notifyingemployee,$model_employee->id) as $key) {
                unset($notifyingemployee[$key]);                                        
                $notifyingemployee=array_values($notifyingemployee);
            } 
            foreach ($notifyingemployee as $emp_id) {
               $model_mail=Employee::model()->findByPK($emp_id);
               if (filter_var($model_mail->email, FILTER_VALIDATE_EMAIL)) { 
                   $sent_mail_id[]=$model_mail->email;
               }
            }
        }
        //Notifying Employee-End
        // Start Custom Mail
        if($model_mail_setting->custom_mail_id!=''){
            $custom_mail=explode(',', $model_mail_setting->custom_mail_id); 
            foreach ($custom_mail as $custom_mail_id) {
                if (filter_var($custom_mail_id, FILTER_VALIDATE_EMAIL)) {
                    $sent_mail_id[]=$custom_mail_id;
                }
            }
        } 
        // End Custom Mail
        $sent_mail_id =$arr_sent_mail_id= array_unique($sent_mail_id);
        if(count($sent_mail_id)>0){
            //To Email Address
            $toRecipient = ['email' => array_shift($sent_mail_id)]; 
            $ccRecipients = [];
            if(!empty($sent_mail_id)){
                foreach ($sent_mail_id as $email_id) {
                    $ccRecipients[] = ['email' => $email_id];
                }
            }
            $from_name=$model_general_setting->from_mail_name;
            $mail_body = Yii::app()->controller->renderPartial('application.views.mail.'.$view, [
                'branch_id'=>$master_branch_id,
                'message' => $mailContent,
                'login_url'=>$login_url,
                'title'=>$subject   
            ], true);
            $response = Yii::app()->sendGrid->sendEmail(
                $toRecipient, // To Mail
                ['email' => $from, 'name' => $from_name],     // From
                $subject,  // Subject
                $mail_body, // Body
                $ccRecipients //CC MAil
            );
            //Mail sending-End
            //Saving Mail Status
            if ($response) {
                date_default_timezone_set("Asia/Dubai");
                if(count($arr_sent_mail_id)>0){
                    $sent_mails=  implode(',', $arr_sent_mail_id);
                }
                $model_mail_status= new MailStatus();
                $model_mail_status->type =$apply_from;
                $model_mail_status->from_mail =$from;
                $model_mail_status->sent_mail_id =$sent_mails;
                $model_mail_status->content =$content;
                $model_mail_status->created_date_time =date('Y-m-d H:i:s');
                $model_mail_status->created_by =Yii::app()->user->id;
                $model_mail_status->save(false);
            }
        }
        return 'mailsuccess';
    }
}