<?php

class LeavemigrationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetEmployeeLeave', 'Create', 'Checkleavedate','SaveMigratedleave','upload','ViewLeavedetails',
                    'downloadDocument','deleteleave'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_leave = HrModules::model()->findByPK(3);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleavemigration_leavedetails_menu']) || Yii::app()->user->authorised_user == 1)&&($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')) {
            $model = new HrEmployeeLeaveMigrated();
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('index', array('model' => $model));
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeLeave() {
        $model = new HrEmployeeLeaveMigrated();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'leavetype.leave_name',
            4 => 'leave_start_date',
            5 => 'leave_end_date',
            6 => 'no_days',
            7 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if (!empty($_POST['employee_id'])) {
            $condition.= " And t.employee_id= '" . $_POST['employee_id'] . "'";
        }
        if (!empty($_POST['leavetype'])) {
            $condition.= " And t.leave_type= '" . $_POST['leavetype'] . "'";
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition.=" and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR leavetype.leave_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'leavetype')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' =>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $leave_start_date = "";
            $leave_end_date = "";
//            $button_string = "";
            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            $migration_view=$migration_delete=$migration_download=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_migration_view'])  || Yii::app()->user->authorised_user == 1) {
                $migration_view=1;
//                $button_string.= '<button class="btn btn-primary btn-xs" title="View Leave Details" onclick="loadPopupModal(\'hr/leavemigration/viewleavedetails&id=' . $row['id'] . '\',\'Employee Leave Details\',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_migration_cancel'])  || Yii::app()->user->authorised_user == 1) {
                $migration_delete=1;
//                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteleave(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_migration_download'])  || Yii::app()->user->authorised_user == 1) {
                $migration_download=1;
                if ($row['leave_approval_document'] != "") {
//                    $button_string.= '<a href="?r=hr/leavemigration/downloadDocument&frm=1&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
                }
                if ($row['medical_certificate'] != "") {
//                    $button_string.= '<a href="?r=hr/leavemigration/downloadDocument&frm=2&id=' . $row['id'] . '" title="Download Medical Certificate"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
                }
            }
            $rowData[] = array(++$m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $row->leavetype->leave_name, $leave_start_date, $leave_end_date, $row->no_days, array('id' => $row['id'],'migration_view'=>$migration_view,'migration_delete'=>$migration_delete,'migration_download'=>$migration_download));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new HrEmployeeLeaveMigrated();
        $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
        $payroll_month=0;
        $payroll_year='';
        $payroll_start_day =1;
        if(!empty($model_lock_month)){
        $payroll_month = $model_lock_month->payroll_month;
        $payroll_year = $model_lock_month->payroll_year;
        }
        if ($payroll_month == 12) {
            $payroll_year+=1;
        }
        $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
        if(!empty($model_lock_days)){
        $payroll_start_day = $model_lock_days->payroll_start_day;
        }
        $next_payroll_month = $payroll_month;
        if ($payroll_start_day > 1) {
            if ($payroll_month == 12) {
                $payroll_month = 1;
            }
            $next_payroll_month = $payroll_month + 1;
        }
        if ($payroll_start_day == 1) {
            if ($payroll_month == 12) {
                $payroll_month = 1;
            } else {
                $payroll_month+=1;
            }
            $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
            $start_date = date('Y-m-d', strtotime('-1 days', strtotime($start_date)));
            $start_date = date("d/m/Y", strtotime($start_date));
        } else {
            $start_date = $payroll_year . '-' . $payroll_month . '-' . $payroll_start_day;
            $start_date = date('Y-m-d', strtotime('-1 days', strtotime($start_date)));
            $start_date = date("d/m/Y", strtotime($start_date));
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('create', array('model' => $model, 'start_date' => $start_date));
    }

    public function actionCheckleavedate() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $start_date = Yii::app()->request->getparam("start_date");
        $end_date = Yii::app()->request->getparam("end_date");
        $checkbox = Yii::app()->request->getparam("checkbox");
        if ($start_date != '' && $end_date != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $start_date)));
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $end_date)));
            $model_setting = HrGenerelSettings::model()->find();
            $include_holiday = $model_setting->include_holiday;
            $model_employee_leave_exist = HrEmployeeLeaveMigrated::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and ((leave_start_date<="' . $start_date . '" AND leave_end_date>="' . $end_date . '") OR  (leave_start_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                        OR leave_end_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"))'));
            if (empty($model_employee_leave_exist)) {
                $model = Employee::model()->findbyPK($employee_id);
                $weekend_off1 = $model->weekend_off1;
                $weekend_off2 = $model->weekend_off2;
                $weekend_off3 = $model->weekend_off3;
                $weekend = $model->branch_sponsor->exclude_weekend;
                //Day Calculation
                $leave_days = 0;
                $d1 = strtotime($start_date);
                $d2 = strtotime($end_date);
                $total_days = $d2 - $d1;
                if ($weekend == 1) {
                    $datefrom = $start_date;
                    $diff = floor($total_days / (60 * 60 * 24));
                    for ($i = 0; $i <= $diff; $i++) {
                        $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $datefrom . '"'));
                        $weekvalue = date('w', strtotime($datefrom));
                        $weekvalue+=1;
                        if ($weekend_off1 == $weekvalue) {
                            if ($model->weekend_off1_type == 'H') {
                                $leave_days = $leave_days + 0.5;
                            }
                        } else if ($weekend_off2 == $weekvalue) {
                            if ($model->weekend_off2_type == 'H') {
                                $leave_days = $leave_days + 0.5;
                            }
                        } else if ($weekend_off3 == $weekvalue) {
                            if ($model->weekend_off3_type == 'H') {
                                $leave_days = $leave_days + 0.5;
                            }
                        } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                            $leave_days++;
                        } else if ($include_holiday == "N" && !empty($model_holiday)) {
                            
                        } else {
                            $leave_days++;
                        }
                        $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                    }
                    if ($checkbox == 1) {
                        $leave_days = $leave_days - 0.5;
                    }
                } else {
                    $datefrom = $start_date;
                    $diff = floor($total_days / (60 * 60 * 24));
                    for ($i = 0; $i <= $diff; $i++) {
                        if ($include_holiday == "Y" && !empty($model_holiday)) {
                            $leave_days++;
                        } else if ($include_holiday == "N" && !empty($model_holiday)) {
                            
                        } else {
                            $leave_days++;
                        }
                        $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                    }
                    //$leave_days = floor($total_days / (60 * 60 * 24) + 1);
                    if ($checkbox == 1) {
                        $leave_days = $leave_days - 0.5;
                    }
                }

                $jsonData['days'] = $leave_days;
                $jsonData['status'] = 'success';
            } else {
                $jsonData['dateerror'] = 3;    //Already Leave applied
                $jsonData['status'] = 'error';
            }
        } else {
            if ($start_date == '') {
                $jsonData['dateerror'] = 1; //Start Date Null
            } else if ($end_date == '') {
                $jsonData['dateerror'] = 2; //End Date Null
            }
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionSaveMigratedleave() {
        if (isset($_POST['HrEmployeeLeaveMigrated'])) {
            $model = new HrEmployeeLeaveMigrated();
            $model->attributes = $_POST['HrEmployeeLeaveMigrated'];
            if ($_POST['HrEmployeeLeaveMigrated']['leave_start_date'] != '0000-00-00' && $_POST['HrEmployeeLeaveMigrated']['leave_start_date'] != '') {
                $model->leave_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrEmployeeLeaveMigrated']['leave_start_date'])));
            }
            if ($_POST['HrEmployeeLeaveMigrated']['leave_end_date'] != '0000-00-00' && $_POST['HrEmployeeLeaveMigrated']['leave_end_date'] != '') {
                $model->leave_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrEmployeeLeaveMigrated']['leave_end_date'])));
            }
            if (isset($_POST['HrEmployeeLeaveMigrated']['medical_certificate']) && $_POST['HrEmployeeLeaveMigrated']['medical_certificate'] != '') {
                $model->medical_certificate = $_POST['HrEmployeeLeaveMigrated']['medical_certificate'];
            }
            if (isset($_POST['HrEmployeeLeaveMigrated']['leave_approval_document']) && $_POST['HrEmployeeLeaveMigrated']['leave_approval_document'] != '') {
                $model->leave_approval_document = $_POST['HrEmployeeLeaveMigrated']['leave_approval_document'];
            }
            $model->ticket_applied  = $_POST['HrEmployeeLeaveMigrated']['ticket_applied'];
            $model->leave_status = 'M';
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->created_by = Yii::app()->user->id;
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionViewLeavedetails() {
        $model = new HrEmployeeLeaveMigrated();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('leave_details_view', array('model' => $model, 'id' => $id), false, true);
    }
    public function actiondownloadDocument() {
        $frm = Yii::app()->request->getParam('frm');
        $id = Yii::app()->request->getParam('id');
        $arr_employee_document = HrEmployeeLeaveMigrated::model()->findByPk($id);
        $file = "";
        $arr_doc_val = array();
        if ($frm == 1) {
            $file = $arr_employee_document->leave_approval_document;
            $arr_doc_val = explode(',', $arr_employee_document->leave_approval_document);
        } else {
            $file = $arr_employee_document->medical_certificate;
            $arr_doc_val = explode(',', $arr_employee_document->medical_certificate);
        }

        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/leavedocument/document.zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/leavedocument/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/leavedocument/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actiondeleteleave() {
        $id = $_POST['id'];
        if ($id > 0) {
            HrEmployeeLeaveMigrated::model()->deleteByPk($id);
            $jsonData['status'] = 'success';                       
        } else {
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
