<?php

class LeaveController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('ChangeReportingManager', 'LoadEmployeeByReporting', 'SaveChangeEmployeeReportingmanager', 'Index', 'GetEmployeeLeave', 'leavesettlementsingle_settlement',
                    'create', 'MasterleaveType', 'Getleavedays', 'Leavedetails', 'leavesettlementsingle', 'downloadDocument', 'LeaveHistoryIndex', 'CheckleaveDate', 'SaveLeave',
                    'upload', 'AddLeave', 'LoademployeeDetails', 'Saveleavedetail', 'LeaveIndex', 'GetMasLeave', 'GetLeaveHistory', 'ApplyLeave', 'SaveAppliedLeave', 'leavesettlement', 'Getleavesettlement',
                    'CancelLeave', 'EditLeave', 'UploadLeaveDocument', 'Updateleave', 'UploadDocument', 'ApproveLeave', 'Checkleave', 'SaveApproveleave', 'ApplyLeaveEncashment',
                    'Leaveapprovalbylm', 'SaveLeaveApproveReject', 'CancelLeaves', 'LeaveApproval', 'GetLeaveforApproval', 'Saveleaveencashment', 'LeaveEncashmentApproval',
                    'GetEmployeeLeaveEncashment', 'encashmentApproval', 'saveApproveEncashment', 'CreateleaveEncashment', 'MasterEncashmentLeave', 'GetencashableDays',
                    'SaveApproveLeaveEncashment', 'printleavesettlement', 'leavesettlementdetail', 'getworkingperiod', 'saveLeavesettlement', 'leavesettlementindex',
                    'GetEmployeeLeaveSettlement', 'ApproveLeavesettlement', 'saveapproveleavesettlement', 'ViewLeavedetails', 'Leavecancelbylm', 'leavecancelrequest', 'SaveleaveCancel',
                    'SaveleavecancelbyLM', 'Leavecancelbyhr', 'SaveleavecancelbyHR', 'LeaveencashmentDetails', 'GetLeaveEncashment', 'Viewleaveencashmentdetails', 'EditApprovedLeave',
                    'CancelwholeLeave', 'GetDays', 'SaveEditleave', 'CheckleavedateinAdmin', 'ApprovalDocument', 'downloadapprovaldocument', 'LeaveApprovalDocument', 'checkattendancemarked',
                    'Saveabsentdetails', 'setleavestatus', 'loadmasterbranch', 'indexencashmentapproval', 'GetPendingEncashment', 'loadencashmentbranch', 'PrintLeavedetails', 'deleteuploadedfile', 'approvalhierarchy',
                    'SavemultipleleaveRequest', 'EmployeeMasterleaveType', 'SaveemployeeleaveRequest', 'CopyLeavedetails', 'CopyLeave', 'SaveleaveCopyRequest', 'loadmasterleavebranch', 'leavebalance', 'GetEmployeeLeaveBalance',
                    'GetLeaveApprovalHistory', 'leaveapprovalHistory', 'Lindex', 'GetMasterLeave', 'Leaveindex2', 'AppliedLeaveHistory'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    /*     * ***************   Reporting Manager Concept  **************************** */

    public function actionChangeReportingManager() {
        $model = new Employee;
        $model_employee = Employee::model()->findAll(array('condition' => 'reporting_manager="0" and isActive!="B"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('reporting_manager_change_form', array('model' => $model, 'model_employee' => $model_employee));
    }

    public function actionLoadEmployeeByReporting() {
        $reportingmanager = $_POST['reportingmanager'];
        $model_employee = Employee::model()->findAll(array('condition' => 'reporting_manager="' . $reportingmanager . '" and isActive!="B"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('reporting_manager_change_employee_list', array('model' => $model_employee, 'reportingmanager' => $reportingmanager), false, true);
    }

    public function actionSaveChangeEmployeeReportingmanager() {
        if (isset($_POST['Employee'])) {
            foreach ($_POST['Employee'] as $each) {
                if (in_array($each['id'], $_POST['arraycid'])) {
                    if ($each['id'] != '') {
                        $model_employee = Employee::model()->findByPK($each['id']);
                    }
                    $model_employee->reporting_manager = $_POST['reporting_manager'];
                    $model_employee->save(false);
                    $reporting_manager = $_POST['reporting_manager'];
                    $model_level_approval = HrEmployeeApproveLevel::model()->findAll(array('condition' => 'employee_id="' . $each['id'] . '"'));
                    foreach ($model_level_approval as $key => $value) {
                        $model_level = HrEmployeeApproveLevel::model()->findByPK($value->id);
                        $level_1 = $value->level_1_type;
                        if ($level_1 == 'L') {
                            $model_level->level_1_authority = $reporting_manager;
                        }
                        $level_2 = $value->level_2_type;
                        if ($level_2 == 'L') {
                            $model_level->level_2_authority = $reporting_manager;
                        }
                        $level_3 = $value->level_3_type;
                        if ($level_3 == 'L') {
                            $model_level->level_3_authority = $reporting_manager;
                        }
                        $level_4 = $value->level_4_type;
                        if ($level_4 == 'L') {
                            $model_level->level_4_authority = $reporting_manager;
                        }
                        $level_5 = $value->level_5_type;
                        if ($level_5 == 'L') {
                            $model_level->level_5_authority = $reporting_manager;
                        }
                        $model_level->save();
                    }
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    /*     * ***************  End Reporting Manager Concept  **************************** */

    //Dikson R
    public function actionIndex() {
        $model_module_leave = HrModules::model()->findByPK(3);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_leavedetails_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new EmployeeLeaveDetail();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeLeave() {
        $model = new EmployeeLeaveDetail();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'employee_id',
            2 => 'view_status',
            3 => 'apply_date',
            4 => 'leave_type',
            5 => 'leave_start_date',
            6 => 'leave_end_date',
            7 => 'no_days',
            8 => 'leave_status',
        );
        // $filterColumn = $columns[$_POST['order'][0]['column']];
        // $filterOrder = $_POST['order'][0]['dir'];
        // $orderBy = $filterColumn . " " . $filterOrder;
        $arr_status = $_POST['status'];
        $status = 'H';
        $pending_status_flag = 0;
        if (is_countable($arr_status) && count($arr_status) > 1) {
            if (in_array('H', $arr_status)) {
                $pending_status_flag = 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status = implode(',', $arr_status);
        } else {
            $status = $arr_status[0];
        }
        $employee_id = $_POST['employee_id'];
        $leavetype = $_POST['leavetype'];
        $branch_id = $_POST['branch_id'];
        $pending_leaves = EmployeeLeaveDetail::getPendingapproval($branch_id, 1);
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        $from_date = date('Y-m-d', strtotime($_POST['from_date']));
        $to_date = date('Y-m-d', strtotime($_POST['date_to']));

        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' AND employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if ($status == 'H') {
            $condition .= " AND t.id IN(" . $pending_leaves . ")";
        } else if ($status != '') {
            if ($status == '1') {
                $condition .= " AND (leave_status= '0' OR leave_status= '1')";
            } else if ($pending_status_flag == 0) {
                $condition .= " AND leave_status IN(" . $status . ")";
            } else if ($pending_status_flag == 1) {
                $condition .= " AND (leave_status IN(" . $status . ") OR t.id IN(" . $pending_leaves . "))";
            }
        }
        if ($employee_id != '') {
            $condition .= " AND t.employee_id= '" . $employee_id . "'";
        }
        if ($leavetype != '') {
            $condition .= " AND t.leave_type= '" . $leavetype . "'";
        }
        if ($from_date != '' && $to_date != '') {
            $condition .= ' AND ((leave_start_date<="' . $from_date . '" AND leave_end_date>="' . $to_date . '") OR  (leave_start_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"
                            OR leave_end_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"))';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " AND (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'leave_start_date desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $model_general_setting = HrGenerelSettings::model()->find();
        $lock_attendance_leave = $model_general_setting->lock_attendance_leave;
        $m = $offset;
        foreach ($model as $h => $row) {
            $apply_date = "";
            $leave_start_date = "";
            $leave_end_date = "";
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            $last_cancel_level = $row->last_cancel_level;
            $next_cancel_level = $last_cancel_level + 1;
            $show_cancel_button = 0;
            $cancel_level_no = 0;
            $cancel_final_level = 'N';
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }
            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            //if($row['type']=='Leave'){
            //Salary Locked
            $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $row->employee_id . '"'));
            $last_locked_date = "";
            if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
                $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
                $last_locked_date = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            } else {
                $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $row->employeedetail->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
                if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                    $last_locked_date = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                }
            }
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_leave = $download_leave_document = $leve_admin_approve = $leave_cancel_btn = $edit_leave = $cancel_leave_lock = $edit_approved_leave = $cancel_leave_no_lock_1 = $cancel_leave_no_lock_1 = $cancel_leave_no_lock = $print_leave = 0;
            $leave_view = $copy_leave = $hr_emp_leave_hierarchy_view = $leave_details_print = $leave_approval_document = $no_match_year = $match_year = $cancel_leave_lock_1 = 0;

            //cancel
            if ($next_cancel_level <= $row->max_level) {
                if ($next_cancel_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 1;
                } else if ($next_cancel_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 2;
                } else if ($next_cancel_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 3;
                } else if ($next_cancel_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 4;
                } else if ($next_cancel_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 5;
                }
            }
            if ($next_cancel_level == $row->max_level) {
                $cancel_final_level = 'Y';
            }
            if ($row->leave_status == 3 || $row->leave_status == 5 || $row->leave_status == 7 || $row->leave_status == 9 || $row->leave_status == 11 && $row->leave_status == 13 || $row->leave_status == 16 || $row->leave_status == 18 || $row->leave_status == 20 || $row->leave_status == 22 || $row->leave_status == 24 || $row->leave_status == 25 || $row->leave_status == 26 || $row->leave_status == 27) {
                $show_approve_button = $show_cancel_button = 0;
            }
            if ($show_approve_button == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_approve']) || Yii::app()->user->authorised_user == 1) {
                    $approve_leave = 1;
                    $button_string .= '<button class="btn btn-primary btn-xs" title="Approve Leave" onclick="loadPopupModal(\'hr/leave/approveleave&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Employee Leave\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_download']) || Yii::app()->user->authorised_user == 1) {
                    $download_leave_document = 1;
                    $button_string .= '<a href="?r=hr/leave/leaveapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document" target="_blank"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
                }
            }
            // Code updated by nisha on 21-12-2022 for direct admin approval /Copied by Dikson on 11/1/2023
            if ($row['leave_status'] == 1 || $row['leave_status'] == 2 || $row['leave_status'] == 4 || $row['leave_status'] == 6 || $row['leave_status'] == 8 || $row['leave_status'] == 10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_admin_leave_details_approve']) || Yii::app()->user->authorised_user == 1) {
                    $last_level = $row->max_level;
                    $leve_admin_approve = 1;
                    $button_string .= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/leave/approveleave&final_level=Y&level=' . $last_level . '&id=' . $row['id'] . '\',\'Employee Leave\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_cancel']) || Yii::app()->user->authorised_user == 1) {
                if ($show_cancel_button == 1) {
                    $leave_cancel_btn = 1;
                    $button_string .= '<button class="btn btn-primary btn-xs" title="Leave Cancellation Request" onclick="loadPopupModal(\'hr/leave/leavecancelbyhr&final_level=' . $cancel_final_level . '&level=' . $cancel_level_no . '&id=' . $row['id'] . '\',\'Leave Cancellation \',\'lg\')"><i class="fa fa-ban"></i></button>&nbsp;';
                }
            }
            if ($row['leave_status'] == 12) {
                $approved_year = date("Y", strtotime($row->approved_date));
                $leave_current_year = date("Y");
                $previous_year = date("Y") - 1;
                if ($approved_year == $leave_current_year) {
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_edit']) || Yii::app()->user->authorised_user == 1) {
                        $edit_leave = 1;
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Edit Approved Leave" onclick="loadPopupModal(\'hr/leave/editapprovedleave&id=' . $row['id'] . '\',\'Employee Leave\',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_cancel']) || Yii::app()->user->authorised_user == 1) {
                        if (strtotime($row['leave_start_date']) > strtotime($last_locked_date) && $lock_attendance_leave == "Y") {
                            $cancel_leave_lock = 1;
                            $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Cancel Leave" onclick="cancelwholeleave(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>&nbsp;';
                        } else if ($lock_attendance_leave == "N") {
                            $cancel_leave_no_lock = 1;
                            $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Cancel Leave" onclick="cancelwholeleave(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>&nbsp;';
                        }
                    }
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_print']) || Yii::app()->user->authorised_user == 1) {
                        $print_leave = 1;
                        $button_string .= ' <button class="btn btn-info btn-xs" onclick="window.open(\'index.php?r=hr/leave/PrintLeavedetails&id=' . $this->ciphertext($row['id'], "e") . '\')" title="Print Leave Details"><i class="fa fa-file-pdf-o"></i></button> ';
                    }
                } else {
                    if ($approved_year == $previous_year && $row->leavetype->carry_forward == 'Y' && $row->leavetype->carry_forward_limit == 'N') {
                        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_edit']) || Yii::app()->user->authorised_user == 1) {
                            $button_string .= '<button class="btn btn-primary btn-xs" title="Edit Approved Leave" onclick="loadPopupModal(\'hr/leave/editapprovedleave&id=' . $row['id'] . '\',\'Employee Leave\',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';
                            $edit_approved_leave = 1;
                        }
                        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_cancel']) || Yii::app()->user->authorised_user == 1) {
                            if (strtotime($row['leave_start_date']) > strtotime($last_locked_date) && $lock_attendance_leave == "Y") {
                                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Cancel Leave" onclick="cancelwholeleave(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>&nbsp;';
                                $cancel_leave_lock_1 = 1;
                            } else if ($lock_attendance_leave == "N") {
                                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Cancel Leave" onclick="cancelwholeleave(' . $row['id'] . ')"><i class="fa fa-trash"></i></a>&nbsp;';
                                $cancel_leave_no_lock_1 = 1;
                            }
                        }
                        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_print']) || Yii::app()->user->authorised_user == 1) {
                            $button_string .= ' <button class="btn btn-info btn-xs" onclick="window.open(\'index.php?r=hr/leave/PrintLeavedetails&id=' . $this->ciphertext($row['id'], "e") . '\')" title="Print Leave Details"><i class="fa fa-file-pdf-o"></i></button> ';
                            $leave_details_print = 1;
                        }
                    }
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_download']) || Yii::app()->user->authorised_user == 1) {
                $model_upload_leave_medical = HrMasterUpload::model()->findByPK(16);
                if ($row['leave_approval_document'] != "" && $model_upload_leave_medical->isActive == 'Y') {
                    $leave_approval_document = 1;
                    $button_string .= '<a href="?r=hr/leave/downloadDocument&frm=1&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_view']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-success btn-xs" title="View Leave Details" onclick="loadPopupModal(\'hr/leave/viewleavedetails&id=' . $row['id'] . '\',\'Employee Leave Details\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
                $leave_view = 1;
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_copy']) || Yii::app()->user->authorised_user == 1) && $row->leavetype->sub_type_leave == "N") {
               // $copy_leave = 1;
                $button_string .= ' <button class="btn btn-warning btn-xs" title="Copy Leave Details" onclick="loadPopupModal(\'hr/leave/copyleavedetails&id=' . $row['id'] . '\',\'Copy Leave Details\',\'xl\')"><i class="fa fa-copy"></i></button>&nbsp;';
            }
            if ($row['leave_status'] == 1 || $row['leave_status'] == 2 || $row['leave_status'] == 4 || $row['leave_status'] == 6 || $row['leave_status'] == 8 || $row['leave_status'] == 10 || $row['leave_status'] == 14 || $row['leave_status'] == 15 || $row['leave_status'] == 17 || $row['leave_status'] == 10 || $row['leave_status'] == 19 || $row['leave_status'] == 21 || $row['leave_status'] == 23) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_hierarchy_view']) || Yii::app()->user->authorised_user == 1) {
                    $button_string .= '<button class="btn btn-primary btn-xs" title="Approval Hierarchy" onclick="loadPopupModal(\'hr/leave/approvalhierarchy&function_type=1&employee_id=' . $row['employee_id'] . '\',\'Employee Hierarchy\',\'md\')"><i class="fa fa-book"></i></button>&nbsp;';
                    $hr_emp_leave_hierarchy_view = 1;
                }
            }
            /* }
              else if($row['type']=='Leave Migration'){
              $button_string.= '<button class="btn btn-success btn-xs" title="View Leave Details" onclick="loadPopupModal(\'leavemigration/viewleavedetails&id=' . $row['id'] . '\',\'Employee Leave Details\',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
              $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteleave(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
              if ($row['leave_approval_document'] != "") {
              $button_string.= '<a href="?r=leavemigration/downloadDocument&frm=1&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
              }
              if ($row['medical_certificate'] != "") {
              $button_string.= '<a href="?r=leavemigration/downloadDocument&frm=2&id=' . $row['id'] . '" title="Download Medical Certificate"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';
              }
              } */
//            $status='Migrated';
//            if($row->leave_status!='M'){
            $status = EmployeeLeaveDetail::getleavestatusbybranch($row->leave_status);
//            }

            $rowData[] = array(++$m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $apply_date, $row->leavetype->leave_name, $leave_start_date, $leave_end_date, $row->no_days, $status,
                array('approve_leave' => $approve_leave, 'download_leave_document' => $download_leave_document, 'leve_admin_approve' => $leve_admin_approve
                    , 'leave_cancel_btn' => $leave_cancel_btn, 'edit_leave' => $edit_leave, 'cancel_leave_lock' => $cancel_leave_lock,
                    'edit_approved_leave' => $edit_approved_leave, 'cancel_leave_no_lock_1' => $cancel_leave_no_lock_1, 'cancel_leave_no_lock_1' => $cancel_leave_no_lock_1, 'cancel_leave_lock_1' => $cancel_leave_lock_1,
                    'cancel_leave_no_lock' => $cancel_leave_no_lock, 'print_leave' => $print_leave, 'no_match_year' => $no_match_year, 'match_year' => $match_year,
                    'leave_view' => $leave_view, 'copy_leave' => $copy_leave, 'hr_emp_leave_hierarchy_view' => $hr_emp_leave_hierarchy_view,
                    'leave_details_print' => $leave_details_print, 'leave_approval_document' => $leave_approval_document, 'employee_id' => $row['employee_id'],
                    'id' => $row['id'], 'level_no' => $level_no, 'final_level' => $final_level, 'cancel_final_level' => $cancel_final_level, 'cancel_level_no' => $cancel_level_no, 'en_id' => $this->ciphertext($row['id'], "e"), 'last_level' => $last_level));
        }







        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $branch = Yii::app()->request->getparam("id");
        $model = new EmployeeLeaveDetail();
        $model_setting = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('create', array('model' => $model, 'model_setting' => $model_setting, 'branch' => $branch));
    }

    public function actionMasterleaveType() {
        $employee = Yii::app()->request->getparam("id");
        $models = MasLeave::getLeavebyemployee($employee);
        $model_employee = Employee::model()->findbyPK($employee);
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee . '" and functionality_id="1"'));
        $functiontype = $model_master_approve_setting->id;
        $model = new EmployeeLeaveDetail();
        $dropdownlist .= CHtml::activedropDownList($model, 'leave_type', $models, array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Type', 'empty' => 'Select', 'onchange' => 'getleavedays();'));
        $jsonData['leavetype'] = $dropdownlist;
        $jsonData['functiontype'] = $functiontype;
        $jsonData['maxlevel'] = $model_master_approve_setting->max_level;
        echo CJSON::encode($jsonData);
    }

    public function actionEmployeeMasterleaveType() {
        $employee = Yii::app()->request->getparam("id");
        $models = MasLeave::getLeavebyemployee($employee);
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee . '" and functionality_id="1"'));
        if (!empty($model_master_approve_setting)) {
            $functiontype = $model_master_approve_setting->id;
        }
        $dropdownlist = CHtml::dropDownList('employee_leave_type', '', $models, array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Type', 'empty' => 'Select', 'onchange' => 'getleavedays();'));
        $jsonData['leavetype'] = $dropdownlist;
        $jsonData['functiontype'] = $functiontype;
        $jsonData['maxlevel'] = $model_master_approve_setting->max_level;
        echo CJSON::encode($jsonData);
    }

    public function actionGetleavedays() {
        $leave_type = Yii::app()->request->getparam("leave_type");
        $id = Yii::app()->request->getparam("id");
        $model_general_setting = HrGenerelSettings::model()->find();
        $year = date("Y");
        $current_month = date("m");
        if ($current_month < $model_general_setting->leave_carry_forward_month) {
            $year = $year - 1;
        }
        $leave_current_balance = 0;
        $model_master_leave = MasLeave::model()->findbyPk($leave_type);
        if ($model_master_leave->sub_type_leave == "N") {
            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $year . '"'));
        } else if ($model_master_leave->sub_type_leave == "Y") {
            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
        }
        //$model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $id . '" AND leave_type="' . $leave_type . '"'));
        if (!empty($model_leave)) {
            $leave_current_balance += $model_leave->leave_current_balance;
        }
        //Deducting Applied Leave Details
        $pending_leave = 0;
        $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('select' => 'sum(no_days) as no_days', 'condition' => 't.employee_id="' . $id . '" AND (t.leave_type="' . $leave_type . '" OR leavetype.parent_id="' . $leave_type . '") and (leave_status IN (0,1,2,4,6,8,10))'));
        $model_leave_encashable = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $leave_type . '" and employee_id="' . $id . '"'));
        if (!empty($model_leave_applied) && $model_leave_applied->no_days > 0) {
            $pending_leave += $model_leave_applied->no_days;
        }
        if (!empty($model_leave_encashable) && $model_leave_encashable->encashable_leave > 0) {
            $pending_leave += $model_leave_encashable->encashable_leave;
        }
        if ($pending_leave > 0) {
            $leave_current_balance -= $pending_leave;
        }
        if ($model_master_leave->additional_leave > 0 && $model_leave->leave_current_balance >= 0) {
            $leave_current_balance += $model_master_leave->additional_leave;
        }
        $model_employee = Employee::model()->findbyPk($id);
//        if ($model_general_setting->leave_apply_permission=='Y' && $model_leave->leave_current_balance<0) {
//            $leave_current_balance+=$model_master_leave->additional_leave;
//        }
        $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $id . '"'));
        $last_locked_date = "";
        if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
            $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
            $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
        } else {
            $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $model_employee->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
            if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
            }
        }
        $jsonData['negative_leave'] = $model_master_leave->negative_leave_apply_permission;
        $jsonData['lock_attendance_leave'] = $model_general_setting->lock_attendance_leave;
        $jsonData['last_locked_date'] = $last_locked_date;
        $jsonData['leave'] = $leave_current_balance;
        $jsonData['ticket'] = $model_leave->leavetype->ticket_available;
        $jsonData['branch_ticket'] = $model_employee->branch_sponsor->ticket_provided;
        $jsonData['certificate'] = $model_leave->leavetype->document_medical_certificate_upload;
        $jsonData['min_day_upload'] = $model_leave->leavetype->min_day_upload;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionCheckleaveDate() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $available_leave = Yii::app()->request->getparam("available_leave");
        $leave_type = Yii::app()->request->getparam("leave_type");
        $start_date = Yii::app()->request->getparam("start_date");
        $end_date = Yii::app()->request->getparam("end_date");
        $checkbox = Yii::app()->request->getparam("checkbox");
        $model_setting = HrGenerelSettings::model()->find();
        $current_leave_year = date('Y');
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $current_leave_year = $current_leave_year - 1;
        }
        if ($start_date != '' && $end_date != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $start_date)));
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $end_date)));
            $current_date = date('Y-m-d');
            $date1_convert = strtotime($current_date);
            $date2_convert = strtotime($start_date);
            $apply_days = $date2_convert - $date1_convert;
            $applyday = floor($apply_days / (60 * 60 * 24));
            $model_master_leave = MasLeave::model()->findbyPk($leave_type);
            //$additional_leave=$model_master_leave->additional_leave;
            //$available_leave+=$additional_leave;
            $model_employee_dtl = Employee::model()->findbyPk($employee_id);
            //Check holiday deducted
            $model_branch_details = MasCompanyBranchSponsor::model()->findbyPK($model_employee_dtl->branch_or_sponsor_id);
            $include_holiday = '';
            if ($model_master_leave->exclude_holiday == 'Y') {
                $include_holiday = 'N';
            } else if ($model_master_leave->exclude_holiday == 'N') {
                $include_holiday = 'Y';
            }
            if ($model_setting->leave_apply_before_current_date == 'Y') {
                $model_master_leave->apply_before = 0;
            }
            if ($model_setting->consider_advance_leave == 'Y' && $model_master_leave->leave_type == 1) {
                $basic_increment = $model_master_leave->leave_days;
                $service_year = $this->getserviceyear($model_employee_dtl->date_join, $end_date);
                if ($service_year >= 10) {
                    $basic_increment = $model_master_leave->leave_days_above_10;
                } else if ($service_year >= 5) {
                    $basic_increment = $model_master_leave->leave_days_above_5;
                } else if ($service_year >= 1) {
                    $basic_increment = $model_master_leave->leave_days_above_1;
                }
                //Get Max Salary Details
                $model_max_id = SalarySlip::model()->with('processing')->find(array('select' => 'MAX(salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" AND employee_id="' . $employee_id . '"'));
                if ($model_max_id->salary_processing_id > 0) {
                    $model_salry_processing = SalaryProcessing::model()->findbyPk($model_max_id->salary_processing_id);
                    $payroll_dt = $model_salry_processing->payroll_enddate;
                    $date_for_advnc_1 = strtotime($payroll_dt);
                    $date_for_advnc_2 = strtotime($end_date);
                    $year11 = date('Y', $date_for_advnc_1);
                    $year12 = date('Y', $date_for_advnc_2);
                    $month11 = date('m', $date_for_advnc_1);
                    $month12 = date('m', $date_for_advnc_2);
                    $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                    $available_leave += $advance_leave_month * $basic_increment;
                } else {
                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                    if ($model_lock_month->id == '') {
                        $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                    }
                    $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                    if ($model_lock_days->id == '') {
                        $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                    }
                    $salary_last_date = $model_lock_month->payroll_year . '-' . $model_lock_month->payroll_month . '-' . $model_lock_days->payroll_start_day;
                    // $salary_last_date=date('Y-m-d', strtotime('+1 month', strtotime($salary_last_date)));
                    $date_for_advnc_1 = strtotime($salary_last_date);
                    $date_for_advnc_2 = strtotime($end_date);
                    $year11 = date('Y', $date_for_advnc_1);
                    $year12 = date('Y', $date_for_advnc_2);
                    $month11 = date('m', $date_for_advnc_1);
                    $month12 = date('m', $date_for_advnc_2);
                    $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                    $available_leave += $advance_leave_month * $basic_increment;
                }
            }
            $jsonData['tot_available_leave'] = $available_leave;
            if ($model_master_leave->sub_type_leave == "N") {
                $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $current_leave_year . '"'));
            } else if ($model_master_leave->sub_type_leave == "Y") {
                $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $current_leave_year . '"'));
            }
            if (!empty($model_leave_table_exist)) {
                //Attendance marked
                $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"', 'order' => 'attendance_date asc'));
                if (empty($model_attendance_present)) {
                    if ($applyday >= $model_master_leave->apply_before || $model_master_leave->apply_before == 0) {
                        $model_employee_leave_approved = EmployeeLeaveDetail::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and ((leave_start_date<="' . $start_date . '" AND leave_end_date>="' . $end_date . '") OR  (leave_start_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                                    OR leave_end_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '")) and (leave_status="0" or leave_status="1" or leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="12" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")'));
                        if (empty($model_employee_leave_approved)) {
                            $model = Employee::model()->findbyPK($employee_id);
                            $weekend_off1 = $model->weekend_off1;
                            $weekend_off2 = $model->weekend_off2;
                            $weekend_off3 = $model->weekend_off3;
                            $weekend = $model_master_leave->exclude_weekend;
                            //Day Calculation
                            $leave_days = 0;
                            $d1 = strtotime($start_date);
                            $d2 = strtotime($end_date);
                            $total_days = $d2 - $d1;
                            if ($weekend == 'Y') {
                                $datefrom = $start_date;
                                $diff = floor($total_days / (60 * 60 * 24));
                                for ($i = 0; $i <= $diff; $i++) {
                                    $model_holiday = MasHoliday::model()->find(array('condition' => 'is_Active="Y" AND holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_employee_dtl->branch_or_sponsor_id . '",branch_id)'));
                                    $weekvalue = date('w', strtotime($datefrom));
                                    $weekvalue += 1;
                                    if ($weekend_off1 == $weekvalue) {
                                        if ($model->weekend_off1_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($weekend_off2 == $weekvalue) {
                                        if ($model->weekend_off2_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($weekend_off3 == $weekvalue) {
                                        if ($model->weekend_off3_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                                        $leave_days++;
                                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                        
                                    } else {
                                        $leave_days++;
                                    }
                                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                }
                                if ($checkbox == 1) {
                                    $leave_days = $leave_days - 0.5;
                                }
                            } else {
                                $datefrom = $start_date;
                                $diff = floor($total_days / (60 * 60 * 24));
                                for ($i = 0; $i <= $diff; $i++) {
                                    if ($include_holiday == "Y" && !empty($model_holiday)) {
                                        $leave_days++;
                                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                        
                                    } else {
                                        $leave_days++;
                                    }
                                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                }
                                //$leave_days = floor($total_days / (60 * 60 * 24) + 1);
                                if ($checkbox == 1) {
                                    $leave_days = $leave_days - 0.5;
                                }
                            }
                            //check negative leave apply permission
                            if ($model_master_leave->negative_leave_apply_permission == 'B') {  //Leave limit condition when negative 
                                if ($leave_days <= $available_leave) {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 0;
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        $jsonData['days'] = $leave_days;
                                        $jsonData['normal_leave'] = $leave_days;
                                        $jsonData['salary_deduction_leave'] = 0.00;
                                        $jsonData['status'] = 'success';
                                        $jsonData['dateerror'] = 0;
                                    }
                                } else {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {   //Leave limit condition when negative salary deduction
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                $salary_deduction_leave = $leave_days - $available_leave;
                                                $jsonData['days'] = $leave_days;
                                                $jsonData['normal_leave'] = $available_leave;
                                                $jsonData['salary_deduction_leave'] = $salary_deduction_leave;
                                                $jsonData['status'] = 'success';
                                                $jsonData['dateerror'] = 8;
                                            } else {
                                                $jsonData['days'] = $leave_days;
                                                $jsonData['normal_leave'] = $leave_days;
                                                $jsonData['salary_deduction_leave'] = 0.00;
                                                $jsonData['status'] = 'success';
                                                $jsonData['dateerror'] = 0;
                                            }
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                            $salary_deduction_leave = $leave_days - $available_leave;
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $available_leave;
                                            $jsonData['salary_deduction_leave'] = $salary_deduction_leave;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 8;
                                        } else {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 0;
                                        }
                                    }
                                }
                            } else {
                                if ($leave_days > $available_leave) {
                                    $jsonData['dateerror'] = 4;    //Leave not available
                                    $jsonData['status'] = 'error';
                                    $jsonData['max_leave_available'] = $available_leave;
                                } else {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        $jsonData['days'] = $leave_days;
                                        $jsonData['normal_leave'] = $leave_days;
                                        $jsonData['salary_deduction_leave'] = 0.00;
                                        $jsonData['status'] = 'success';
                                    }
                                }
                            }
                        } else {
                            $jsonData['dateerror'] = 3;    //Already Leave applied
                            $jsonData['status'] = 'error';
                        }
                    } else {
                        $jsonData['applybefore'] = $model_master_leave->apply_before;
                        $jsonData['dateerror'] = 5;    //Apply before master set value
                        $jsonData['status'] = 'error';
                    }
                } else {
                    $date_array = array();
                    foreach ($model_attendance_present as $key => $value) {
                        $date_array[] = date("d/m/Y", strtotime($value->attendance_date));
                    }
                    $jsonData['attendancedate'] = implode(',', $date_array);
                    $jsonData['dateerror'] = 6;    //Attendance-Present added
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['dateerror'] = 7;    //Leave balance record error
                $jsonData['status'] = 'error';
            }
        } else {
            if ($start_date == '') {
                $jsonData['dateerror'] = 1; //Start Date Null
            } else if ($end_date == '') {
                $jsonData['dateerror'] = 2; //End Date Null
            }
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveLeave() {
        $model = new EmployeeLeaveDetail();
        if (isset($_POST['EmployeeLeaveDetail'])) {
            $scenario = '';
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeLeaveDetail']['id'];
                $model->scenario = 'update';
                $scenario = 'update';
                $model = EmployeeLeaveDetail::model()->findByPK($_POST['EmployeeLeaveDetail']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $scenario = 'add';
                $model->apply_date = date('Y-m-d');
                $model->apply_by = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeLeaveDetail'];
            //Employee ID
            $employee_id = $_POST['EmployeeLeaveDetail']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="1"'));
            $model->function_type = $model_master_approve_setting->id;
            $model->max_level = $model_master_approve_setting->max_level;
            $model->last_approved_level = $_POST['EmployeeLeaveDetail']['last_approved_level'];
            if ($_POST['EmployeeLeaveDetail']['leave_start_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['leave_start_date'] != '') {
                $model->leave_start_date = str_replace('/', '-', $_POST['EmployeeLeaveDetail']['leave_start_date']);
                $model->leave_start_date = date("Y-m-d", strtotime($model->leave_start_date));
            }
            if ($_POST['EmployeeLeaveDetail']['leave_end_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['leave_end_date'] != '') {
                $model->leave_end_date = str_replace('/', '-', $_POST['EmployeeLeaveDetail']['leave_end_date']);
                $model->leave_end_date = date("Y-m-d", strtotime($model->leave_end_date));
            }
            if (isset($_POST['EmployeeLeaveDetail']['medical_certificate']) && $_POST['EmployeeLeaveDetail']['medical_certificate'] != '') {
                $model->medical_certificate = $_POST['EmployeeLeaveDetail']['medical_certificate'];
            }
            if (isset($_POST['EmployeeLeaveDetail']['leave_approval_document']) && $_POST['EmployeeLeaveDetail']['leave_approval_document'] != '') {
                $model->leave_approval_document = $_POST['EmployeeLeaveDetail']['leave_approval_document'];
            }
            if (isset($_POST['EmployeeLeaveDetail']['hr_comment']) && $_POST['EmployeeLeaveDetail']['hr_comment'] != '') {
                $model->hr_comment = $_POST['EmployeeLeaveDetail']['hr_comment'];
            }
            $model->leave_status = $_POST['EmployeeLeaveDetail']['leave_status'];
            $model->normal_leave = $_POST['EmployeeLeaveDetail']['normal_leave'];
            $model->salary_deduction_leave = $_POST['EmployeeLeaveDetail']['salary_deduction_leave'];
            if ($model->scenario == 'add' && $model->leave_status == 12) {
                $model->approved_date = date('Y-m-d');
                $model_employee = User::model()->findbypk(Yii::app()->user->id);
                $approved_employee_id = 0;
                if ($model_employee->employee_id > 0) {
                    $approved_employee_id = $model_employee->employee_id;
                } else if ($model_employee->hr_connected_employee_id > 0) {
                    $approved_employee_id = $model_employee->hr_connected_employee_id;
                }
                $model->approved_id = $approved_employee_id;
            }
            $start_date = $model->leave_start_date;
            $end_date = $model->leave_end_date;
            //Ticket
            $ticket_applied = $_POST['EmployeeLeaveDetail']['ticket_applied'];
            if ($ticket_applied == 1) {
                $model->travel_destination = $_POST['EmployeeLeaveDetail']['travel_destination'];
                if ($_POST['EmployeeLeaveDetail']['travel_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['travel_date'] != '') {
                    $model->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeLeaveDetail']['travel_date'])));
                }
                $model->return_destination = $_POST['EmployeeLeaveDetail']['return_destination'];
                if ($_POST['EmployeeLeaveDetail']['return_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['return_date'] != '') {
                    $model->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeLeaveDetail']['return_date'])));
                }
            }
            if ($model->validate()) {
                $model->save();
                //Ticket
                if ($ticket_applied == 1) {
                    $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $model->id . '"'));
                    if (!empty($model_tkt)) {
                        $model_tkt_1 = EmployeeTicket::model()->findByPK($model_tkt->id);
                        $model_tkt_1->updated_date_time = date('Y-m-d H:i:s');
                        $model_tkt_1->updated_by = Yii::app()->user->id;
                        $model_tkt_1->save();
                    } else {
                        $model_tkt_1 = new EmployeeTicket();
                        $model_tkt_1->employee_id = $model->employee_id;
                        $model_tkt_1->travel_date = $model->travel_date;
                        $model_tkt_1->travel_destination = $model->travel_destination;
                        $model_tkt_1->return_date = $model->return_date;
                        $model_tkt_1->return_destination = $model->return_destination;
                        $model_tkt_1->leave_id = $model->id;
                        $model_tkt_1->leave_type = $model->leave_type;
                        $model_tkt_1->date_apply = date('Y-m-d');
                        $model_tkt_1->status = 1;
                        $model_tkt_1->year = date('Y', strtotime($model->leave_end_date));
                        $model_tkt_1->created_date_time = date('Y-m-d H:i:s');
                        $model_tkt_1->created_by = Yii::app()->user->id;
                        $model_tkt_1->save();
                    }
                } else {
                    $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $model->id . '"'));
                    if (!empty($model_tkt)) {
                        EmployeeTicket::model()->updateByPK($model_tkt->id, array('status' => 3, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                    }
                }
                //Leave Updation
                if ($scenario == 'add' && $model->leave_status == 12) {
                    $employee_id = $_POST['EmployeeLeaveDetail']['employee_id'];
                    $year = date("Y");
                    $model_setting = HrGenerelSettings::model()->find();
                    $current_month = date("m");
                    if ($current_month < $model_setting->leave_carry_forward_month) {
                        $year = $year - 1;
                    }
                    $leave_type = $_POST['EmployeeLeaveDetail']['leave_type'];
                    $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                    if ($model_master_leave->sub_type_leave == "N") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $year . '"'));
                    } else if ($model_master_leave->sub_type_leave == "Y") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                    }
                    //$model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $leave_type . '"'));
                    if ($model_leave->id > 0) {
                        $available_leave = $model_leave->leave_current_balance;
                        $leave_days = $model->normal_leave;
                        $balance_leave = $available_leave - $leave_days;
                        EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    } else {
                        $year = $year - 1;
                        $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                        if ($model_master_leave->sub_type_leave == "N") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $year . '"'));
                        } else if ($model_master_leave->sub_type_leave == "Y") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                        }
                        if (!empty($model_leave)) {
                            $available_leave = $model_leave->leave_current_balance;
                            $leave_days = $model->normal_leave;
                            $balance_leave = $available_leave - $leave_days;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        }
                    }
                    //Salary Deduction for leave
                    //Start Adding Normal Leaves
                    $normal_leaves = $model->normal_leave;
                    if ($model_master_leave->salary_deduction != 'N' && $normal_leaves > 0) {
                        $start_date_1 = $model->leave_start_date;
                        $normal_leaves = ceil($normal_leaves - 1);
                        for ($i = 0; $i <= $normal_leaves; $i++) {
                            $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                            $model_salary_deduction->employee_id = $model->employee_id;
                            $model_salary_deduction->leave_id = $model->id;
                            $model_salary_deduction->leave_type_id = $model->leave_type;
                            $model_salary_deduction->leave_date = $start_date_1;
                            $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction;
                            $model_salary_deduction->created_by = Yii::app()->user->id;
                            $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                            $model_salary_deduction->save();
                            $start_date_1 = date('Y-m-d', strtotime('+1 day', strtotime($start_date_1)));
                        }
                    }
                    //End Adding Normal Leaves
                    //Starting Adding Negative Leaves
                    $negative_leaves = $model->salary_deduction_leave;
                    if ($model_master_leave->salary_deduction_negative_leave != 'N' && $negative_leaves > 0) {
                        $normal_leaves = ceil($model->normal_leave);
                        $negative_deduction_start = date('Y-m-d', strtotime("+$normal_leaves days", strtotime($model->leave_start_date)));
                        $negative_leaves = ceil($model->salary_deduction_leave - 1);
                        for ($i = 0; $i <= $negative_leaves; $i++) {
                            $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                            $model_salary_deduction->employee_id = $model->employee_id;
                            $model_salary_deduction->leave_id = $model->id;
                            $model_salary_deduction->leave_type_id = $model->leave_type;
                            $model_salary_deduction->leave_date = $negative_deduction_start;
                            $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction_negative_leave;
                            $model_salary_deduction->created_by = Yii::app()->user->id;
                            $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                            $model_salary_deduction->save();
                            $negative_deduction_start = date('Y-m-d', strtotime('+1 day', strtotime($negative_deduction_start)));
                        }
                    }
                    //End Adding Negative Leaves
                    $d1 = strtotime($start_date);
                    $d2 = strtotime($end_date);
                    $datediff = $d2 - $d1;
                    $diff = floor($datediff / (60 * 60 * 24)) + 1;
                    $start = 0;
                    $end = $diff;
                    $date_from = $start_date;
                    for ($i = $start; $i < $end; $i++) {
                        //EMployee 
                        $model_emp = Employee::model()->findByPk($employee_id);
                        $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and status="2"';
                        if ($model_master_leave->exclude_weekend == 'N') {
                            $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and (status="2" OR status="5")';
                        }
                        if ($model_master_leave->exclude_holiday == 'N') {
                            $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and (status="2" OR status="4" OR status="5")';
                        }
                        $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                        if (!empty($model_attendance)) {
                            EmployeeAttendance::model()->updateByPK($model_attendance->id, array('status' => 3, 'leave_id' => $model->id));
                        }
                        $date_from = date('Y-m-d', strtotime($date_from . ' +1 day'));
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    //15/3/2018 by dikson
    public function actionAddLeave() {
        $model = new EmployeeLeaveLedger();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('add_leave', array('model' => $model));
    }

    public function actionLoademployeeDetails() {
        $branch = Yii::app()->request->getparam("branch");
        $leave_type = Yii::app()->request->getparam("leave_type");
        $model_mas_leave = MasLeave::model()->findbyPK($leave_type);
        $condition = 'branch_or_sponsor_id="' . $branch . '" AND isActive!="B"';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if ($model_mas_leave->gender == 1) {
            $condition .= ' and gender="1"';
        } else if ($model_mas_leave->gender == 2) {
            $condition .= ' and gender="2"';
        }
        $model_employee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value->id;
        }
        ksort($arr_employee);
        $model = new EmployeeLeaveLedger();
        $model_leave = new EmployeeLeave();
        $view_flag = 0;
        //CHecking Old Year leave existing for approval
        $model_setting = HrGenerelSettings::model()->find();
        $year = date("Y");
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $year = $year - 1;
        }
        $model_current_year_exist = EmployeeLeave::model()->findAll(array('condition' => 'leave_year="' . $year . '" and leave_type="' . $leave_type . '"'));
        if (empty($model_current_year_exist)) {
            $model_pending_leave_exist = EmployeeLeaveDetail::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" AND leave_type="' . $leave_type . '" AND (leave_status="1" or leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")'));
            if (!empty($model_pending_leave_exist)) {
                $view_flag = 1;
            }
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        if ($view_flag == 1) {
            $this->render('error', array());
        } else {
            $this->render('employee_details_leave', array('model' => $model, 'arr_employee' => $arr_employee, 'branch' => $branch, 'leave_type' => $leave_type, 'model_leave' => $model_leave));
        }
    }

    public function actionSaveleavedetail() {

        if ((isset($_POST['EmployeeLeave']))) {
            $arra_eid = array();
            $leave_type = $_POST['EmployeeLeaveLedger']['leave_type'];
            $s = 0;
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['EmployeeLeave'] as $i => $items) {
                $leave_count = $_POST['EmployeeLeaveLedger'][$i]['leave_count'];
                $leave_opening = $items['leave_opening'];
                $current_balance = $items['leave_current_balance'];
                if ($current_balance != '') {
                    $leave_reduce = $_POST['EmployeeLeaveLedger'][$i]['leave_reduce'];
                    if ($items['id'] > 0) {
                        $model_leave = EmployeeLeave::model()->findByPK($items['id']);
                        $model_leave->scenario = 'update';
                        $model_leave->updated_by = Yii::app()->user->id;
                        $model_leave->updated_date_time = date('Y-m-d H:i:s');
                        $model_leave->leave_current_balance = $items['leave_current_balance'];
                    } else {
                        $model_leave = new EmployeeLeave();
                        $model_leave->scenario = 'add';
                        $model_leave->created_by = Yii::app()->user->id;
                        $model_leave->created_date_time = date('Y-m-d H:i:s');
                        $model_leave->leave_current_balance = $items['leave_current_balance'];
                        $model_leave->employee_id = $items['employee_id'];
                        $model_leave->leave_type = $items['leave_type'];
                        $model_leave->leave_opening = $items['leave_opening'];
                        $model_leave->leave_year = date('Y');
                    }
                    $arra_eid[$s] = $items['employee_id'];
                    $model_leave->save(false);
                    if ($leave_count > 0) {
                        $model_leave_ledger = new EmployeeLeaveLedger();
                        $model_leave_ledger->employee_id = $items['employee_id'];
                        $model_leave_ledger->leave_type = $items['leave_type'];
                        $model_leave_ledger->leave_count = $_POST['EmployeeLeaveLedger'][$i]['leave_count'];
                        $model_leave_ledger->remarks = $_POST['EmployeeLeaveLedger'][$i]['remarks'];
                        $model_leave_ledger->created_by = Yii::app()->user->id;
                        $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                        $model_leave_ledger->save();
                    }
                    if ($leave_reduce > 0) {
                        $model_leave_ledger = new EmployeeLeaveLedger();
                        $model_leave_ledger->employee_id = $items['employee_id'];
                        $model_leave_ledger->leave_type = $items['leave_type'];
                        $model_leave_ledger->leave_reduce = $leave_reduce;
                        $model_leave_ledger->remarks = $_POST['EmployeeLeaveLedger'][$i]['remarks'];
                        $model_leave_ledger->created_by = Yii::app()->user->id;
                        $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                        $model_leave_ledger->save();
                    }
                    $s++;
                }
            }
            //Master Leave
            $model_master_leave = MasLeave::model()->findbypk($leave_type);
            if (!empty($model_master_leave) && $model_master_leave->employee_id != '') {
                $leave_employee_id = explode(',', $model_master_leave->employee_id);
            }
            $new_array_eid = array();
            $j = 0;
            if (!empty($leave_employee_id) && count($leave_employee_id) > 0) {
                for ($n = 0; $n < count($leave_employee_id); $n++) {
                    if (!(in_array($leave_employee_id[$n], $arra_eid))) {
                        $new_array_eid[$j] = $leave_employee_id[$n];
                        $j++;
                    }
                }
            }
            $new_array_eid = array_merge($new_array_eid, $arra_eid);
            $employee_id = implode(',', $new_array_eid);
            $model_master_leave->employee_id = $employee_id;
            $model_master_leave->save();

            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionLeaveIndex2() {
        $this->layout = "main";
        $model = new EmployeeLeave();
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('employee_leave_index', array('model' => $model));
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionLeaveIndex1() {
        $this->layout = "main";
        $model = new EmployeeLeave();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('leave_index', array('model' => $model));
    }

    public function actionLeaveHistoryIndex() {
        $this->layout = "main";
        $model = new EmployeeLeave();
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leave_historyindex', array('model' => $model));
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetMasLeave() {
        $model = new MasLeave();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'leave_name',
            2 => 'leave_type',
            3 => 'leave_days',
            4 => 'leave_days',
            5 => 'isActive'
        );
        $model_employee = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'isActive =  "Y" and FIND_IN_SET(' . $employee_id . ', employee_id)';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (leave_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'leave_name asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $model_general_setting = HrGenerelSettings::model()->find();
        foreach ($model as $row) {
            $year = date("Y");
            $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $row['id'] . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));
            $model_leave_details = EmployeeLeaveDetail::model()->find(array('select' => 'sum(no_days) as no_days', 'condition' => 'YEAR(leave_start_date)="' . $year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $row['id'] . '" and leave_status="4"'));
            $model_leave_applied = EmployeeLeaveDetail::model()->find(array('condition' => 'YEAR(leave_start_date)>="' . $year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $row['id'] . '" and (leave_status="1" OR leave_status="2" OR leave_status="12" OR leave_status="14")'));
            $model_leave_encashable = EmployeeLeaveEncashment::model()->findAll(array('condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $row['id'] . '" and employee_id="' . $employee_id . '"'));
            $model_leave_encashable_approved = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="12" OR status="14") and leave_type_id="' . $row['id'] . '" and encashment_year="' . $year . '" and employee_id="' . $employee_id . '"'));
            $balance_leave = 0.00;
            $leave_current_balance = $model_leave->leave_current_balance;
            if ($model_leave->leave_current_balance > 0) {
                $balance_leave = $model_leave->leave_current_balance;
            }
            $model_master_leave = MasLeave::model()->findbyPk($row['id']);
            if ($model_master_leave->additional_leave > 0 && $model_leave->leave_current_balance >= 0) {
                $balance_leave += $model_master_leave->additional_leave;
                $leave_current_balance += $model_master_leave->additional_leave;
            }
            if ($model_general_setting->leave_apply_permission == 'Y' && $model_leave->leave_current_balance < 0) {
                $balance_leave += $model_master_leave->additional_leave;
                $leave_current_balance += $model_master_leave->additional_leave;
            }
            $leave_taken = 0.00;
            if ($model_leave_details->no_days > 0) {
                $leave_taken = $model_leave_details->no_days;
            }
            $encashable_leave = 0.00;
            $message = "";
            if ($model_leave_encashable_approved->encashable_leave > 0) {
                $encashable_leave = $model_leave_encashable_approved->encashable_leave;
                $message = "<br/>Leave Encashed=" . $encashable_leave;
            }
            $available_leave = 0.00;
            if ($balance_leave > 0) {
                $available_leave = $balance_leave + $leave_taken + $encashable_leave;
            }
            $button_string = "";
            if ($balance_leave > 0 && empty($model_leave_applied) && (empty($model_leave_encashable))) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Apply Leave" onclick="loadPopupModal(\'hr/leave/applyleave&id=' . $row['id'] . '&eid=' . $employee_id . '&leave=' . $balance_leave . '\',\'Apply Leave \',\'lg\')"><i class="fa fa-external-link-square"></i></button>&nbsp;&nbsp;';
            } else if (!empty($model_leave_applied)) {
                $button_string .= 'Leave Applied';
            }
            if ($row->encashable == "Y" && $balance_leave > 0 && empty($model_leave_applied) && empty($model_leave_encashable)) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Apply Leave Encashment" onclick="loadPopupModal(\'hr/leave/applyleaveencashment&id=' . $row['id'] . '&eid=' . $employee_id . '&leave=' . $balance_leave . '\',\'Apply Leave Encashment\',\'xl\')"><i class="fa fa fa-money"></i></button>';
            } else if ($row->encashable == "Y" && !empty($model_leave_encashable)) {
                $button_string .= 'Leave Encashment Applied';
            }

            $model_leave_ledger = EmployeeLeaveLedger::model()->find(array('select' => 'sum(leave_reduce) as leave_reduce', 'condition' => 'leave_type="' . $row['id'] . '" and employee_id="' . $employee_id . '" and YEAR(created_date_time)="' . $year . '"'));
            if ($model_leave_ledger->leave_reduce > 0) {
                $leave_taken += $model_leave_ledger->leave_reduce;
            }
            $opening_leave_value = number_format($model_leave->leave_opening, 2);
            $current_leave_value = number_format($leave_current_balance, 2);
            if ($row['leave_count_employee_panel'] == 'N') {
                $opening_leave_value = number_format(0.00, 2);
                $current_leave_value = number_format(0.00, 2);
            }
            $rowData[] = array(++$m, $row['leave_name'], $opening_leave_value, number_format($leave_taken, 2) . ' ' . $message, $current_leave_value, $button_string);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetLeaveHistory() {
        $model = new EmployeeLeaveDetail();
        $status = $_POST['status'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'leave_name',
            2 => 'apply_date',
            3 => 'leave_start_date',
            4 => 'leave_end_date',
            5 => 'no_days',
            6 => 'half_day_leave',
            7 => 'half_day_time',
            8 => 'leave_status',
            9 => 'line_manager_comment',
            10 => 'hr_comment',
            11 => 'isActive',
        );
        $model_employee = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $from_date = date('Y-m-d', strtotime($_POST['from_date']));
        $to_date = date('Y-m-d', strtotime($_POST['date_to']));
        $condition = 'employee_id="' . $employee_id . '"';
        if ($status != '') {
            if ($status == '1') {
                $condition .= ' and (leave_status= "0" OR leave_status= "1")';
            } else {
                $condition .= ' and leave_status= "' . $status . '"';
            }
        }
        if ($from_date != '' && $to_date != '') {
            $condition .= ' AND ((leave_start_date<="' . $from_date . '" AND leave_end_date>="' . $to_date . '") OR  (leave_start_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"
                            OR leave_end_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"))';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (apply_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'apply_date desc'));
        //Updating Notification Status
        if ($status == 12 || $status == 13) {
            EmployeeLeaveDetail::model()->updateAll(array('view_status' => 1), 'employee_id="' . $employee_id . '" and view_status="0" and (leave_status="12" OR leave_status="13")');
        } else if ($status == 25 || $status == 26) {
            EmployeeLeaveDetail::model()->updateAll(array('hr_cancel_view_status' => 1), 'employee_id="' . $employee_id . '" and lm_cancel_view_status="0" and (leave_status="25" OR leave_status="26")');
        }
        //End Updation
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $model_general_setting = HrGenerelSettings::model()->find();
        $lock_attendance_leave = $model_general_setting->lock_attendance_leave;
        $arr_half_day_status = array('Y' => 'Yes', 'N' => 'No');
        foreach ($model as $row) {
            //Salary Locked
            $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $row->employee_id . '"'));
            $last_locked_date = "";
            if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
                $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
                $last_locked_date = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            } else {
                $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $row->employeedetail->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
                if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                    $last_locked_date = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                }
            }
            $apply_date = "";
            $leave_start_date = "";
            $leave_end_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }

            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            $button_string = "";
            if ($row['leave_status'] == 1) {
                // $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/leave/editleave&id=' . $row['id'] . '\',\'Edit Leave \',\'md\')"><i class="fa fa-edit"></i></button>&nbsp;';
            }
            $edit_button = $delete_button = $cancel_button = $cancel_button_1 = $view_button = $download_button = $download_certificate = $upload_certificate = $cancel_button_3 = $cancel_button_2 = $copy_leave = 0;
            if ($row['leave_status'] == 0) {
                $edit_button = 1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/leave/editleave&id=' . $row['id'] . '\',\'Edit Leave \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
//                $button_string.= '<a href="javascript:void(0);" class="btn btn-danger btn-xs" title="Cancel Leave" onclick="cancelleave(\'' . $row['id'] . '\')"><i class="fa fa-trash"></i></a>&nbsp;';
            }
            if ($row['leave_status'] == 1 || $row['leave_status'] == 0) {
                $delete_button = 1;
//                $button_string.= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/leave/editleave&id=' . $row['id'] . '\',\'Edit Leave \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $button_string .= '<a href="javascript:void(0);" class="btn btn-danger btn-xs" title="Cancel Leave" onclick="cancelleave(\'' . $row['id'] . '\')"><i class="fa fa-trash"></i></a>&nbsp;';
            }
//            if ($row['leave_status']!= 1) {
            $view_button = 1;
            $button_string .= '<button class="btn btn-success btn-xs" title="Leave Details" onclick="loadPopupModal(\'hr/leave/viewleavedetails&id=' . $row['id'] . '\',\'Leave Details\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
//            }
            $model_upload_leave_medical = HrMasterUpload::model()->findByPK(16);
            if ($row->leave_approval_document != '') {
                $download_button = 1;
                $button_string .= '<a href="?r=hr/leave/downloadDocument&frm=1&id=' . $row['id'] . '"><button class="btn btn-primary btn-xs" title="Download" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }
            if ($row->medical_certificate != '' && $model_upload_leave_medical->isActive == 'Y') {
                $download_certificate = 1;
                $button_string .= '<a href="?r=hr/leave/downloadDocument&frm=2&id=' . $row['id'] . '"><button class="btn btn-primary btn-xs" title="Download" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }

            if ($row->leavetype->document_medical_certificate_upload == 'Y' && $row->medical_certificate == '' && $row['leave_status'] == 1 && $model_upload_leave_medical->isActive == 'Y') {
                $upload_certificate = 1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Upload Document" onclick="loadPopupModal(\'hr/leave/uploadleavedocument&id=' . $row['id'] . '\',\'Upload Document \',\'lg\')"><i class="fa fa-upload"></i></button>&nbsp;';
            }
            if ($row->leave_status == 12) {
                $approved_year = date("Y", strtotime($row->approved_date));
                $leave_current_year = date("Y");
                $leave_previous_year = date("Y") - 1;
                if ($approved_year == $leave_current_year) {
                    if ($lock_attendance_leave == "Y" && strtotime($row->leave_start_date) > strtotime($last_locked_date) && strtotime($row->leave_start_date) >= strtotime(date("Y-m-d")) && $row->leave_status == 12 && $row->status_cancel == 0) {
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Request To Cancel Leave" onclick="loadPopupModal(\'hr/leave/leavecancelrequest&id=' . $row['id'] . '\',\'Leave Cancel Request\',\'lg\')"><i class="fa fa-ban"></i></button>&nbsp;';
                        $cancel_button = 1;
                        //$button_string.= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="cancelleaves(\'' . $row['id'] . '\');" title="Cancel Leave"><i class="fa fa-trash"></i> </a>&nbsp;';
                    } else if ($lock_attendance_leave == "N" && strtotime($row->leave_start_date) >= strtotime(date("Y-m-d")) && $row->leave_status == 12 && $row->status_cancel == 0) {
                        $cancel_button_1 = 1;
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Request To Cancel Leave" onclick="loadPopupModal(\'hr/leave/leavecancelrequest&id=' . $row['id'] . '\',\'Leave Cancel Request\',\'lg\')"><i class="fa fa-ban"></i></button>&nbsp;';
                        //$button_string.= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="cancelleaves(\'' . $row['id'] . '\');" title="Cancel Leave"><i class="fa fa-trash"></i> </a>&nbsp;';
                    }
                } else if ($approved_year == $leave_previous_year && $row->leavetype->carry_forward == 'Y' && $row->leavetype->carry_forward_limit == 'N') {
                    if ($lock_attendance_leave == "Y" && strtotime($row->leave_start_date) > strtotime($last_locked_date) && strtotime($row->leave_start_date) >= strtotime(date("Y-m-d")) && $row->leave_status == 12 && $row->status_cancel == 0) {
                        $cancel_button_2 = 1;
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Request To Cancel Leave" onclick="loadPopupModal(\'hr/leave/leavecancelrequest&id=' . $row['id'] . '\',\'Leave Cancel Request\',\'lg\')"><i class="fa fa-ban"></i></button>&nbsp;';
                        //$button_string.= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="cancelleaves(\'' . $row['id'] . '\');" title="Cancel Leave"><i class="fa fa-trash"></i> </a>&nbsp;';
                    } else if ($lock_attendance_leave == "N" && strtotime($row->leave_start_date) >= strtotime(date("Y-m-d")) && $row->leave_status == 12 && $row->status_cancel == 0) {
                        $cancel_button_3 = 1;
                        $button_string .= '<button class="btn btn-primary btn-xs" title="Request To Cancel Leave" onclick="loadPopupModal(\'hr/leave/leavecancelrequest&id=' . $row['id'] . '\',\'Leave Cancel Request\',\'lg\')"><i class="fa fa-ban"></i></button>&nbsp;';
                        //$button_string.= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="cancelleaves(\'' . $row['id'] . '\');" title="Cancel Leave"><i class="fa fa-trash"></i> </a>&nbsp;';
                    }
                }
            }
            //added by dikson on 9/1/2023
            if ($row->leavetype->sub_type_leave == "N") {
               // $copy_leave = 1;
//                $button_string.= '<button class="btn btn-warning btn-xs" title="Copy Leave Details" onclick="loadPopupModal(\'hr/leave/copyleave&id=' . $row['id'] . '\',\'Copy Leave Details \',\'xl\')"><i class="fa fa-copy"></i></button> &nbsp;';
            }
            $rowData[] = array(++$m, $row->leavetype->leave_name, $apply_date, $leave_start_date, $leave_end_date, $row->no_days, $arr_half_day_status[$row->half_day_leave], $row->half_day_time, EmployeeLeaveDetail::getleavestatusbybranch($row->leave_status, $row->employeedetail->branch_or_sponsor_id), $row['leave_reason'], $row['line_manager_comment'], $row['hr_comment'], array('id' => $row['id'], 'edit_button' => $edit_button, 'delete_button' => $delete_button, 'cancel_button' => $cancel_button, 'view_button' => $view_button, 'download_button' => $download_button, 'download_certificate' => $download_certificate, 'upload_certificate' => $upload_certificate, 'cancel_button_3' => $cancel_button_3, 'cancel_button_2' => $cancel_button_2, 'cancel_button_1' => $cancel_button_1, 'copy_leave' => $copy_leave));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actiondownloadDocument() {
        $frm = Yii::app()->request->getParam('frm');
        $id = Yii::app()->request->getParam('id');
        $arr_employee_document = EmployeeLeaveDetail::model()->findByPk($id);
        $file = "";
        $arr_doc_val = array();
        if ($frm == 1) {
            $file = $arr_employee_document->leave_approval_document;
            $arr_doc_val = explode(',', $arr_employee_document->leave_approval_document);
        } else {
            $file = $arr_employee_document->medical_certificate;
            $arr_doc_val = explode(',', $arr_employee_document->medical_certificate);
        }

        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/leavedocument/document.zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/leavedocument/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/leavedocument/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }

    public function actionApplyLeave() {
        $employee_id = (int) Yii::app()->request->getParam('eid');
        $leave_id = (int) Yii::app()->request->getParam('id');
        $model_master_leave = MasLeave::model()->findbypk($leave_id);
        $model_setting = HrGenerelSettings::model()->find();
        $current_leave_year = date('Y');
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $current_leave_year = $current_leave_year - 1;
        }
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $leave_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $current_leave_year . '"'));
        if ($model_master_leave->sub_type_leave == "Y") {
            $model_leave_count = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $model_master_leave->parent_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $current_leave_year . '"'));
            if (!empty($model_leave_count)) {
                if ($model_leave === null) {
                    $model_leave = new EmployeeLeave();
                }
                $model_leave->leave_current_balance = $model_leave_count->leave_current_balance;
            }
        }
        //Deducting Applied Leave Details
        $pending_leave = 0;
        $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('select' => 'sum(no_days) as no_days', 'condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $leave_id . '" OR leavetype.parent_id="' . $leave_id . '") and (leave_status IN (0,1,2,4,6,8,10))'));
        $model_leave_encashable = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $leave_id . '" and employee_id="' . $employee_id . '"'));
        if (!empty($model_leave_applied) && $model_leave_applied->no_days > 0) {
            $pending_leave += $model_leave_applied->no_days;
        }
        if (!empty($model_leave_encashable) && $model_leave_encashable->encashable_leave > 0) {
            $pending_leave += $model_leave_encashable->encashable_leave;
        }
        if ($pending_leave > 0) {
            $model_leave->leave_current_balance -= $pending_leave;
        }
        $model = new EmployeeLeaveDetail();
        $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $employee_id . '"'));
        $last_locked_date = "";
        $model_employee = Employee::model()->findbyPk($employee_id);
        if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
            $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
            $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
        } else {
            $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $model_employee->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
            if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
            }
        }
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="1"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('applyleave', array('model_employee' => $model_employee, 'model_master_approve_setting' => $model_master_approve_setting, 'last_locked_date' => $last_locked_date, 'model' => $model, 'model_leave' => $model_leave, 'model_setting' => $model_setting, 'model_master_leave' => $model_master_leave, 'leave_id' => $leave_id, 'employee_id' => $employee_id), false, true);
    }

    public function actionSaveAppliedLeave() {
        $model = new EmployeeLeaveDetail();
        if (isset($_POST['EmployeeLeaveDetail'])) {
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeLeaveDetail']['id'];
                $model->scenario = 'update';
                $model = EmployeeLeaveDetail::model()->findByPK($_POST['EmployeeLeaveDetail']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->apply_date = date('Y-m-d');
                $model->apply_by = Yii::app()->user->id;
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeLeaveDetail'];
            //Approval Level
            if (isset($_POST['EmployeeLeaveDetail']['function_type']) && $_POST['EmployeeLeaveDetail']['function_type'] != '') {
                $model->function_type = $_POST['EmployeeLeaveDetail']['function_type'];
            } else {
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['EmployeeLeaveDetail']['employee_id'] . '" and functionality_id="1"'));
                $model->function_type = $model_master_approve_setting->id;
            }
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['EmployeeLeaveDetail']['employee_id'] . '" and functionality_id="1"'));
            $model->max_level = $model_master_approve_setting->max_level;
            $model->last_approved_level = 0;
            $model->normal_leave = $_POST['EmployeeLeaveDetail']['normal_leave'];
            $model->salary_deduction_leave = $_POST['EmployeeLeaveDetail']['salary_deduction_leave'];
            if ($_POST['EmployeeLeaveDetail']['leave_start_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['leave_start_date'] != '') {
                $model->leave_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeLeaveDetail']['leave_start_date'])));
            }
            if ($_POST['EmployeeLeaveDetail']['leave_end_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['leave_end_date'] != '') {
                $model->leave_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeLeaveDetail']['leave_end_date'])));
            }
            if (isset($_POST['EmployeeLeaveDetail']['medical_certificate']) && $_POST['EmployeeLeaveDetail']['medical_certificate'] != '') {
                $model->medical_certificate = $_POST['EmployeeLeaveDetail']['medical_certificate'];
            }
            if (isset($_POST['EmployeeLeaveDetail']['half_day_leave']) && $_POST['EmployeeLeaveDetail']['half_day_leave'] == 'Y') {
                $model->half_day_time = $_POST['EmployeeLeaveDetail']['half_day_time'];
            } else {
                $model->half_day_time = '';
            }
            $model->half_day_leave = $_POST['EmployeeLeaveDetail']['half_day_leave'];
            $ticket_applied = $_POST['EmployeeLeaveDetail']['ticket_applied'];
            if ($ticket_applied == 1) {
                $model->travel_destination = $_POST['EmployeeLeaveDetail']['travel_destination'];
                if ($_POST['EmployeeLeaveDetail']['travel_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['travel_date'] != '') {
                    $model->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeLeaveDetail']['travel_date'])));
                }
                $model->return_destination = $_POST['EmployeeLeaveDetail']['return_destination'];
                if ($_POST['EmployeeLeaveDetail']['return_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['return_date'] != '') {
                    $model->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeLeaveDetail']['return_date'])));
                }
            }
            $model->leave_status = 1;
            if ($model->validate()) {
                $model->save();
                //Ticket
                if ($ticket_applied == 1) {
                    $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $model->id . '"'));
                    if (!empty($model_tkt)) {
                        $model_tkt_1 = EmployeeTicket::model()->findByPK($model_tkt->id);
                        $model_tkt_1->updated_date_time = date('Y-m-d H:i:s');
                        $model_tkt_1->updated_by = Yii::app()->user->id;
                        $model_tkt_1->save();
                    } else {
                        $model_tkt_1 = new EmployeeTicket();
                        $model_tkt_1->employee_id = $model->employee_id;
                        $model_tkt_1->travel_date = $model->travel_date;
                        $model_tkt_1->travel_destination = $model->travel_destination;
                        $model_tkt_1->return_date = $model->return_date;
                        $model_tkt_1->return_destination = $model->return_destination;
                        $model_tkt_1->leave_id = $model->id;
                        $model_tkt_1->leave_type = $model->leave_type;
                        $model_tkt_1->date_apply = date('Y-m-d');
                        $model_tkt_1->status = 1;
                        $model_tkt_1->year = date('Y', strtotime($model->leave_end_date));
                        $model_tkt_1->created_date_time = date('Y-m-d H:i:s');
                        $model_tkt_1->created_by = Yii::app()->user->id;
                        $model_tkt_1->save();
                    }
                } else {
                    $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $model->id . '"'));
                    if (!empty($model_tkt)) {
                        EmployeeTicket::model()->updateByPK($model_tkt->id, array('status' => 3, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
                    }
                }
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="1"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(1, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionleavesettlement() {
        $model_module_leave = HrModules::model()->findByPK(3);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_settlemntlist_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')) {
            $model = new Employee;
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leavesettlement', array('model' => $model));
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionCancelLeave() {
        $id = $_POST['id'];
        $model = EmployeeLeaveDetail::model()->findByPk($id);
        if ($model->leave_status == 12) {
            $jsonData['status'] = 'error';
        } else if ($model->leave_status == 1 || $model->leave_status == 0) {
            EmployeeLeaveDetail::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            EmployeeLeaveDetail::model()->updateByPK($model->id, array('leave_status' => 14, 'date_apply_cancel' => date('Y-m-d'), 'status_cancel' => 1, 'last_cancel_level' => 0));
            $jsonData['status'] = 'success';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionEditLeave() {
        $id = Yii::app()->request->getParam('id');
        $model = EmployeeLeaveDetail::model()->findByPk($id);
        $employee_id = $model->employee_id;
        $leave_id = $model->leave_type;
        $current_leave_year = date('Y');
        $model_setting = HrGenerelSettings::model()->find();
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $current_leave_year = $current_leave_year - 1;
        }
        $model_master_leave = MasLeave::model()->findbypk($leave_id);
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $leave_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $current_leave_year . '"'));
        $d1 = strtotime($model->leave_start_date);
        $d2 = strtotime($model->leave_end_date);
        $datediff = $d2 - $d1;
        $diff = floor($datediff / (60 * 60 * 24)) + 1;
        $checked = 1;
        if ($model->no_days == $diff) {
            $checked = 0;
        }
        $ticket_applied = 0;
        if ($model->ticket_applied == 1) {
            $ticket_applied = 1;
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->renderPartial('edit_leave_form', array('model' => $model, 'model_setting' => $model_setting, 'checked' => $checked, 'ticket_applied' => $ticket_applied, 'model_master_leave' => $model_master_leave, 'model_leave' => $model_leave), false, true);
    }

    public function actionUploadLeaveDocument() {
        $id = Yii::app()->request->getparam("id");
        $model = EmployeeLeaveDetail::model()->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false,);
        $this->renderPartial('employee_leave_document', array('model' => $model), false, true);
    }

    public function actionUpdateleave() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $id = $_POST['EmployeeLeaveDetail']['id'];
                if ($_POST['EmployeeLeaveDetail']['medical_certificate'] != '') {
                    $medical_certificate = $_POST['EmployeeLeaveDetail']['medical_certificate'];
                    EmployeeLeaveDetail::model()->updateByPK($id, array('medical_certificate' => $medical_certificate));
                    $data['status'] = 'success';
                }
            } else {
                $data['status'] = 'error';
            }
            echo CJSON::encode($data);
        }
    }

    public function actionApproveLeave() {
        $model = new EmployeeLeaveDetail();
        $id = (int) Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_leave_approve', array('model' => $model, 'level' => $level, 'final_level' => $final_level));
    }

    public function actionSaveApproveleave() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $model = EmployeeLeaveDetail::model()->findByPK($_POST['EmployeeLeaveDetail']['id']);
                $model->id = (int) $_POST['EmployeeLeaveDetail']['id'];
                $model->scenario = 'update';
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                unset($_POST['EmployeeLeaveDetail']['id']);
                $model->scenario = 'add';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            if (isset($_POST['EmployeeLeaveDetail']['leave_approval_document']) && $_POST['EmployeeLeaveDetail']['leave_approval_document'] != '') {
                $model->leave_approval_document = $_POST['EmployeeLeaveDetail']['leave_approval_document'];
            }
            $model->leave_status = $_POST['EmployeeLeaveDetail']['leave_status'];
            if (isset($_POST['approval_comment'])) {
                $model->hr_comment = $_POST['approval_comment'];
            }
            $model->last_approved_level = $_POST['EmployeeLeaveDetail']['last_approved_level'];
            //$model->approved_id = Yii::app()->user->id;
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $model->approved_id = $approved_employee_id;
            $model->approved_date = date('Y-m-d');
            $start_date = $model->leave_start_date;
            $end_date = $model->leave_end_date;
            if ($model->validate()) {
                $model->save();
                $model_settings = HrGenerelSettings::model()->find();
                $year = date("Y");
                $current_month = date("m");
                if ($current_month < $model_settings->leave_carry_forward_month) {
                    $year = $year - 1;
                }
                if ($model->leave_status == 12) {
                    $model_master_leave = MasLeave::model()->findbyPk($model->leave_type);
                    if ($model_master_leave->sub_type_leave == "N") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type = "' . $model->leave_type . '" and leave_year="' . $year . '"'));
                    } else if ($model_master_leave->sub_type_leave == "Y") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                    }
                    //$model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type="' . $model->leave_type . '" and leave_year="' . date('Y') . '"'));
                    if (!empty($model_leave)) {
                        $balance_leave = $model_leave->leave_current_balance - $model->normal_leave;
                        EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    } else {
                        $year = $year - 1;
                        $model_master_leave = MasLeave::model()->findbyPk($model->leave_type);
                        if ($model_master_leave->sub_type_leave == "N") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type = "' . $model->leave_type . '" and leave_year="' . $year . '"'));
                        } else if ($model_master_leave->sub_type_leave == "Y") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                        }
                        if (!empty($model_leave)) {
                            $balance_leave = $model_leave->leave_current_balance - $model->normal_leave;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        }
                    }
                    //Salary Deduction for leave
                    //Start Adding Normal Leaves
                    $normal_leaves = $model->normal_leave;
                    if ($model_master_leave->salary_deduction != 'N' && $normal_leaves > 0) {
                        $start_date_1 = $model->leave_start_date;
                        $normal_leaves = ceil($normal_leaves - 1);
                        for ($i = 0; $i <= $normal_leaves; $i++) {
                            $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                            $model_salary_deduction->employee_id = $model->employee_id;
                            $model_salary_deduction->leave_id = $model->id;
                            $model_salary_deduction->leave_type_id = $model->leave_type;
                            $model_salary_deduction->leave_date = $start_date_1;
                            $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction;
                            $model_salary_deduction->created_by = Yii::app()->user->id;
                            $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                            $model_salary_deduction->save();
                            $start_date_1 = date('Y-m-d', strtotime('+1 day', strtotime($start_date_1)));
                        }
                    }
                    //End Adding Normal Leaves
                    //Starting Adding Negative Leaves
                    $negative_leaves = $model->salary_deduction_leave;
                    if ($model_master_leave->salary_deduction_negative_leave != 'N' && $negative_leaves > 0) {
                        $normal_leaves = ceil($model->normal_leave);
                        $negative_deduction_start = date('Y-m-d', strtotime("+$normal_leaves days", strtotime($model->leave_start_date)));
                        $negative_leaves = ceil($model->salary_deduction_leave - 1);
                        for ($i = 0; $i <= $negative_leaves; $i++) {
                            $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                            $model_salary_deduction->employee_id = $model->employee_id;
                            $model_salary_deduction->leave_id = $model->id;
                            $model_salary_deduction->leave_type_id = $model->leave_type;
                            $model_salary_deduction->leave_date = $negative_deduction_start;
                            $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction_negative_leave;
                            $model_salary_deduction->created_by = Yii::app()->user->id;
                            $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                            $model_salary_deduction->save();
                            $negative_deduction_start = date('Y-m-d', strtotime('+1 day', strtotime($negative_deduction_start)));
                        }
                    }
                    //End Adding Negative Leaves
                    $d1 = strtotime($start_date);
                    $d2 = strtotime($end_date);
                    $datediff = $d2 - $d1;
                    $diff = floor($datediff / (60 * 60 * 24)) + 1;
                    $start = 0;
                    $end = $diff;
                    $date_from = $start_date;
                    for ($i = $start; $i < $end; $i++) {
                        $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $model->employee_id . '" and status="2"';
                        if ($model_master_leave->exclude_weekend == 'N') {
                            $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $model->employee_id . '" and (status="2" OR status="5")';
                        }
                        if ($model_master_leave->exclude_holiday == 'N') {
                            $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $model->employee_id . '" and (status="2" OR status="4" OR status="5")';
                        }
                        $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                        if (!empty($model_attendance)) {
                            EmployeeAttendance::model()->updateByPK($model_attendance->id, array('status' => 3, 'leave_id' => $model->id, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        }
                        $date_from = date('Y-m-d', strtotime($date_from . ' +1 day'));
                    }
                }
                //Mail
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="2"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(2, $model->employee_id, $model->id);
                    }
                }
                $model->refresh();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionCheckleave() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $available_leave = Yii::app()->request->getparam("available_leave");
        $leave_type = Yii::app()->request->getparam("leave_type");
        $start_date = Yii::app()->request->getparam("start_date");
        $end_date = Yii::app()->request->getparam("end_date");
        $checkbox = Yii::app()->request->getparam("checkbox");
        $model_setting = HrGenerelSettings::model()->find();
        $current_leave_year = date('Y');
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $current_leave_year = $current_leave_year - 1;
        }
        if ($start_date != '' && $end_date != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $start_date)));
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $end_date)));
            $current_date = date('Y-m-d');
            $date1_convert = strtotime($current_date);
            $date2_convert = strtotime($start_date);
            $apply_days = $date2_convert - $date1_convert;
            $applyday = floor($apply_days / (60 * 60 * 24));
            $model_master_leave = MasLeave::model()->findbyPk($leave_type);
            //$additional_leave=$model_master_leave->additional_leave;
            //$available_leave+=$additional_leave;
            $model_employee_dtl = Employee::model()->findbyPk($employee_id);
            //Check holiday deducted
            $model_branch_details = MasCompanyBranchSponsor::model()->findbyPK($model_employee_dtl->branch_or_sponsor_id);
            $include_holiday = '';
            if ($model_master_leave->exclude_holiday == 'Y') {
                $include_holiday = 'N';
            } else if ($model_master_leave->exclude_holiday == 'N') {
                $include_holiday = 'Y';
            }
            if ($model_setting->leave_apply_before_current_date == 'Y') {
                $model_master_leave->apply_before = 0;
            }
            if ($model_setting->consider_advance_leave == 'Y' && $model_master_leave->leave_type == 1) {
                $basic_increment = $model_master_leave->leave_days;
                $service_year = $this->getserviceyear($model_employee_dtl->date_join, $end_date);
                if ($service_year >= 10) {
                    $basic_increment = $model_master_leave->leave_days_above_10;
                } else if ($service_year >= 5) {
                    $basic_increment = $model_master_leave->leave_days_above_5;
                } else if ($service_year >= 1) {
                    $basic_increment = $model_master_leave->leave_days_above_1;
                }
                //Get Max Salary Details
                $model_max_id = SalarySlip::model()->with('processing')->find(array('select' => 'MAX(salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" AND employee_id="' . $employee_id . '"'));
                if ($model_max_id->salary_processing_id > 0) {
                    $model_salry_processing = SalaryProcessing::model()->findbyPk($model_max_id->salary_processing_id);
                    $payroll_dt = $model_salry_processing->payroll_enddate;
                    $date_for_advnc_1 = strtotime($payroll_dt);
                    $date_for_advnc_2 = strtotime($end_date);
                    $year11 = date('Y', $date_for_advnc_1);
                    $year12 = date('Y', $date_for_advnc_2);
                    $month11 = date('m', $date_for_advnc_1);
                    $month12 = date('m', $date_for_advnc_2);
                    $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                    $available_leave += $advance_leave_month * $basic_increment;
                } else {
                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                    if ($model_lock_month->id == '') {
                        $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                    }
                    $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                    if ($model_lock_days->id == '') {
                        $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                    }
                    $salary_last_date = $model_lock_month->payroll_year . '-' . $model_lock_month->payroll_month . '-' . $model_lock_days->payroll_start_day;
                    // $salary_last_date=date('Y-m-d', strtotime('+1 month', strtotime($salary_last_date)));
                    $date_for_advnc_1 = strtotime($salary_last_date);
                    $date_for_advnc_2 = strtotime($end_date);
                    $year11 = date('Y', $date_for_advnc_1);
                    $year12 = date('Y', $date_for_advnc_2);
                    $month11 = date('m', $date_for_advnc_1);
                    $month12 = date('m', $date_for_advnc_2);
                    $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                    $available_leave += $advance_leave_month * $basic_increment;
                }
            }
            $jsonData['tot_available_leave'] = $available_leave;
            if ($model_master_leave->sub_type_leave == "N") {
                $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $current_leave_year . '"'));
            } else if ($model_master_leave->sub_type_leave == "Y") {
                $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $current_leave_year . '"'));
            }
            if (!empty($model_leave_table_exist)) {
                //Attendance marked
                $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"', 'order' => 'attendance_date asc'));
                if (empty($model_attendance_present)) {
                    if ($applyday >= $model_master_leave->apply_before || $model_master_leave->apply_before == 0) {
                        $model_employee_leave_approved = EmployeeLeaveDetail::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and ((leave_start_date<="' . $start_date . '" AND leave_end_date>="' . $end_date . '") OR  (leave_start_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                                    OR leave_end_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '")) and (leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="12" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")'));
                        if (empty($model_employee_leave_approved)) {
                            $model = Employee::model()->findbyPK($employee_id);
                            $weekend_off1 = $model->weekend_off1;
                            $weekend_off2 = $model->weekend_off2;
                            $weekend_off3 = $model->weekend_off3;
                            $weekend = $model_master_leave->exclude_weekend;
                            //Day Calculation
                            $leave_days = 0;
                            $d1 = strtotime($start_date);
                            $d2 = strtotime($end_date);
                            $total_days = $d2 - $d1;
                            if ($weekend == 'Y') {
                                $datefrom = $start_date;
                                $diff = floor($total_days / (60 * 60 * 24));
                                for ($i = 0; $i <= $diff; $i++) {
                                    $model_holiday = MasHoliday::model()->find(array('condition' => 'is_Active="Y" AND holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_employee_dtl->branch_or_sponsor_id . '",branch_id)'));
                                    $weekvalue = date('w', strtotime($datefrom));
                                    $weekvalue += 1;
                                    if ($weekend_off1 == $weekvalue) {
                                        if ($model->weekend_off1_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($weekend_off2 == $weekvalue) {
                                        if ($model->weekend_off2_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($weekend_off3 == $weekvalue) {
                                        if ($model->weekend_off3_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                                        $leave_days++;
                                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                        
                                    } else {
                                        $leave_days++;
                                    }
                                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                }
                                if ($checkbox == 1) {
                                    $leave_days = $leave_days - 0.5;
                                }
                            } else {
                                $datefrom = $start_date;
                                $diff = floor($total_days / (60 * 60 * 24));
                                for ($i = 0; $i <= $diff; $i++) {
                                    if ($include_holiday == "Y" && !empty($model_holiday)) {
                                        $leave_days++;
                                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                        
                                    } else {
                                        $leave_days++;
                                    }
                                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                }
                                //$leave_days = floor($total_days / (60 * 60 * 24) + 1);
                                if ($checkbox == 1) {
                                    $leave_days = $leave_days - 0.5;
                                }
                            }
                            //check negative leave apply permission
                            if ($model_master_leave->negative_leave_apply_permission == 'B') {  //Leave limit condition when negative 
                                if ($leave_days <= $available_leave) {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 0;
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        $jsonData['days'] = $leave_days;
                                        $jsonData['normal_leave'] = $leave_days;
                                        $jsonData['salary_deduction_leave'] = 0.00;
                                        $jsonData['status'] = 'success';
                                        $jsonData['dateerror'] = 0;
                                    }
                                } else {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {   //Leave limit condition when negative salary deduction
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                $salary_deduction_leave = $leave_days - $available_leave;
                                                $jsonData['days'] = $leave_days;
                                                $jsonData['normal_leave'] = $available_leave;
                                                $jsonData['salary_deduction_leave'] = $salary_deduction_leave;
                                                $jsonData['status'] = 'success';
                                                $jsonData['dateerror'] = 8;
                                            } else {
                                                $jsonData['days'] = $leave_days;
                                                $jsonData['normal_leave'] = $leave_days;
                                                $jsonData['salary_deduction_leave'] = 0.00;
                                                $jsonData['status'] = 'success';
                                                $jsonData['dateerror'] = 0;
                                            }
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                            $salary_deduction_leave = $leave_days - $available_leave;
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $available_leave;
                                            $jsonData['salary_deduction_leave'] = $salary_deduction_leave;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 8;
                                        } else {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 0;
                                        }
                                    }
                                }
                            } else {
                                if ($leave_days > $available_leave) {
                                    $jsonData['dateerror'] = 4;    //Leave not available
                                    $jsonData['status'] = 'error';
                                    $jsonData['max_leave_available'] = $available_leave;
                                } else {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        $jsonData['days'] = $leave_days;
                                        $jsonData['normal_leave'] = $leave_days;
                                        $jsonData['salary_deduction_leave'] = 0.00;
                                        $jsonData['status'] = 'success';
                                    }
                                }
                            }
                        } else {
                            $jsonData['dateerror'] = 3;    //Already Leave applied
                            $jsonData['status'] = 'error';
                        }
                    } else {
                        $jsonData['applybefore'] = $model_master_leave->apply_before;
                        $jsonData['dateerror'] = 5;    //Apply before master set value
                        $jsonData['status'] = 'error';
                    }
                } else {
                    $date_array = array();
                    foreach ($model_attendance_present as $key => $value) {
                        $date_array[] = date("d/m/Y", strtotime($value->attendance_date));
                    }
                    $jsonData['attendancedate'] = implode(',', $date_array);
                    $jsonData['dateerror'] = 6;    //Attendance-Present added
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['dateerror'] = 7;    //Leave balance record error
                $jsonData['status'] = 'error';
            }
        } else {
            if ($start_date == '') {
                $jsonData['dateerror'] = 1; //Start Date Null
            } else if ($end_date == '') {
                $jsonData['dateerror'] = 2; //End Date Null
            }
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionApplyLeaveEncashment() {
        $employee_id = (int) Yii::app()->request->getParam('eid');
        $leave_id = (int) Yii::app()->request->getParam('id');
        $current_leave_year = date('Y');
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $leave_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $current_leave_year . '"'));
        $model = new EmployeeLeaveEncashment();
        $current_date = date('Y-m-d');
        $condition = 'employee_id="' . $employee_id . '" and isActive="Y" and consider_for_leave_payment="Y" AND valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"';
        $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
        $salary_amount = $model_salary->amount;
        $salary_per_day = ($salary_amount / 30);
        $model_master_leave = MasLeave::model()->findbyPk($leave_id);
        $additional_leave = $model_master_leave->additional_leave;
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="9"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false,);
        $this->render('applyleave_encashment', array('additional_leave' => $additional_leave, 'model' => $model, 'model_leave' => $model_leave, 'leave_id' => $leave_id, 'employee_id' => $employee_id, 'salary_per_day' => $salary_per_day, 'model_master_approve_setting' => $model_master_approve_setting), false, true);
    }

    public function actionLeaveApproval() {
        $this->layout = "main";
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leave_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetLeaveforApproval() {
        $model = new EmployeeLeaveDetail();
        $leavetype = $_POST['leavetype'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id',
            2 => 'leave_type',
            3 => 'apply_date',
            4 => 'leave_start_date',
            5 => 'leave_end_date',
            6 => 'leave_status',
            7 => 'no_days',
            8 => 'hr_comment',
            9 => 'line_manager_id',
            10 => 'approved_id',
            11 => 'employeedetail.isActive',
        );
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $model_employee_detail = Employee::model()->findByPk($employee_id);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $pending_leaves = EmployeeLeaveDetail::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND (last_approved_level<t.max_level OR last_cancel_level<t.max_level) And t.id IN(' . $pending_leaves . ')';
        if (!empty($leavetype)) {
            $condition .= ' AND leave_type="' . $leavetype . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (apply_date LIKE '%" . $searchString . "%' OR employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'apply_date asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }

            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            $last_cancel_level = $row->last_cancel_level;
            $next_cancel_level = $last_cancel_level + 1;
            $show_cancel_button = 0;
            $cancel_level_no = 0;
            $cancel_final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            //cancel
            if ($next_cancel_level <= $row->max_level) {
                if ($next_cancel_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 1;
                } else if ($next_cancel_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 2;
                } else if ($next_cancel_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 3;
                } else if ($next_cancel_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 4;
                } else if ($next_cancel_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_cancel_button = 1;
                    $cancel_level_no = 5;
                }
            }
            if ($next_cancel_level == $row->max_level) {
                $cancel_final_level = 'Y';
            }
            $approve_reject = $cancel_leave = $view_leave = 0;
            if ($show_approve_button == 1) { //For Approval
                $approve_reject = 1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Approve/Reject" onclick="loadPopupModal(\'hr/leave/leaveapprovalbylm&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Approve/Reject Leave \',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            if ($show_cancel_button == 1) { //For Cancellation
                $cancel_leave = 1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Leave Cancellation Request" onclick="loadPopupModal(\'hr/leave/leavecancelbylm&final_level=' . $cancel_final_level . '&level=' . $cancel_level_no . '&id=' . $row['id'] . '\',\'Leave Cancellation \',\'lg\')"><i class="fa fa-ban"></i></button>&nbsp;';
            }
            $button_string .= '<button class="btn btn-primary btn-xs" title="Leave Details" onclick="loadPopupModal(\'hr/leave/Leavedetails&id=' . $row['employee_id'] . '\',\'Leave Details \',\'lg\')"><i class="fa fa-tasks"></i></button>&nbsp;';
            if ($row['leave_status'] != 1) {
                $view_leave = 1;
                $button_string .= '<button class="btn btn-success btn-xs" title="View Leave Details" onclick="loadPopupModal(\'hr/leave/viewleavedetails&id=' . $row['id'] . '\',\'Leave Details\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            $employee_name = $this->ciphertext($row->employeedetail->first_name, "d") . " " . $this->ciphertext($row->employeedetail->last_name, "d");
            $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $row->leave_type . '" and employee_id="' . $row->employee_id . '" and leave_year="' . date('Y') . '"'));
            $rowData[] = array(++$m, $employee_name, $row->leavetype->leave_name, $apply_date, $leave_start_date, $leave_end_date, $row->no_days, $model_leave->leave_current_balance, EmployeeLeaveDetail::getleavestatusbybranch($row->leave_status, $row->employeedetail->branch_or_sponsor_id), $row['leave_reason'], array('id' => $row['id'], 'final_level' => $final_level, 'level_no' => $level_no, '$cancel_final_level' => $cancel_final_level, 'cancel_level_no' => $cancel_level_no, 'employee_id' => $row['employee_id'], 'approve_reject' => $approve_reject, 'cancel_leave' => $cancel_leave, 'view_leave' => $view_leave));
        }
        $data['data'] = $rowData;
        $data['condition'] = $condition;
        $data['user'] = Yii::app()->user->id;
        echo json_encode($data);
    }

    public function actionLeaveapprovalbylm() {
        $id = Yii::app()->request->getparam("id");
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = EmployeeLeaveDetail::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('approve_reject_form', array('model' => $model, 'level' => $level, 'final_level' => $final_level), false, true);
    }

    public function actionLeavedetails() {
        $id = Yii::app()->request->getparam("id");
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('leave_detail_form', array('id' => $id), false, true);
    }

    public function actionSaveLeaveApproveReject() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            $model = new EmployeeLeaveDetail();
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeLeaveDetail']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->leave_status = $_POST['EmployeeLeaveDetail']['leave_status'];
            $model->last_approved_level = $_POST['EmployeeLeaveDetail']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            if ($level == 1) {
                $model->line_manager_approved_date = date('Y-m-d');
                $model->line_manager_comment = $_POST['approval_comment'];
                $model->line_manager_id = $approved_employee_id;
            } else if ($level == 2) {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3) {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4) {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5) {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="2"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(2, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionCancelLeaves() {
        $id = $_POST['id'];
        $model = EmployeeLeaveDetail::model()->findByPk($id);
        if ($model->leave_status == 12) {
            $jsonData['status'] = 'error';
        } else if ($model->leave_status == 1) {
            EmployeeLeaveDetail::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            EmployeeLeaveDetail::model()->updateByPK($model->id, array('leave_status' => 14, 'date_apply_cancel' => date('Y-m-d'), 'status_cancel' => 1, 'last_cancel_level' => 0, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
            $jsonData['status'] = 'success';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveleaveencashment() {
        $model = new EmployeeLeaveEncashment;
        if (isset($_POST['EmployeeLeaveEncashment'])) {
            if ((int) @$_POST['EmployeeLeaveEncashment']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeLeaveEncashment']['id'];
                $model = EmployeeLeaveEncashment::model()->findByPK($_POST['EmployeeLeaveEncashment']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date = date("Y-m-d");
            }
            $model->attributes = $_POST['EmployeeLeaveEncashment'];
            $model->encashment_year = date("Y");
            //Employee ID
            $employee_id = $_POST['EmployeeLeaveEncashment']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="9"'));
            if (!empty($model_master_approve_setting)) {
                $model->max_level = $model_master_approve_setting->max_level;
            }
            if ($model->validate()) {
                $model->save();
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="5"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(5, $model->employee_id, $model->id);
                    }
                }
                $model->refresh();
                $jsonData['model'] = 'EmployeeLeaveEncashment';
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionLeaveEncashmentApproval() {
        $model_module_leave_encashment = HrModules::model()->findByPK(4);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_encash_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_leave_encashment->grant_access == 1 && $model_module_leave_encashment->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new EmployeeLeaveEncashment();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('leave_encashment', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeLeaveEncashment() {
        $model = new EmployeeLeaveEncashment();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        //$status = $_POST['status'];
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'leavetype.leave_name',
            4 => 'apply_date',
            5 => 'approve_date',
            6 => 'encashable_leave',
            7 => 'encashment_amount',
            8 => 'status',
            9 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        //$condition = 'YEAR(apply_date)="'.date('Y').'"';
        $arr_status = $_POST['status'];
        $status = 'H';
        $pending_status_flag = 0;
        if (is_countable($arr_status) && count($arr_status) > 1) {
            if (in_array('H', $arr_status)) {
                $pending_status_flag = 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status = implode(',', $arr_status);
        } else {
            $status = $arr_status[0];
        }
        $pending_ids = EmployeeLeaveEncashment::getPendingapproval($branch_id, 1);
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if ($status == 'H') {
            $condition .= " AND t.id IN(" . $pending_ids . ")";
        } else if ($status != '') {
            if ($pending_status_flag == 0) {
                $condition .= " AND status IN(" . $status . ")";
            } else if ($pending_status_flag == 1) {
                $condition .= " AND (status IN(" . $status . ") OR t.id IN(" . $pending_ids . "))";
            }
        }
        if ($employee_id > 0) {
            $condition .= ' and t.employee_id ="' . $employee_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $employee_code = $this->ciphertext($searchString, "d");
            $condition .= " and (employeedetail.first_name LIKE '%" . $employee_code . "%' OR employeedetail.last_name LIKE '%" . $employee_code . "%' OR employeedetail.employee_code LIKE '%" . $employee_code . "%' OR leavetype.leave_name LIKE '%" . $searchString . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail', 'leavetype')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'apply_date asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            if ($show_approve_button == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_encashment_approve']) || Yii::app()->user->authorised_user == 1) {
                    $button_string .= '<button class="btn btn-success btn-xs" title="Approve/Reject Leave Encashment" onclick="loadPopupModal(\'hr/leave/encashmentapproval&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Approve/Reject Leave Encashment\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                }
            }
            $approve_date = "";
            $apply_date = "";
            $encash_approve = $encash_view = $encash_direct_approve = 0;
            if ($show_approve_button == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_approve']) || Yii::app()->user->authorised_user == 1) {
                    $encash_approve = 1;
//                    $button_string.= '<button class="btn btn-primary btn-xs" title="Approve Leave Encashment" onclick="loadPopupModal(\'hr/leave/encashmentapproval&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Leave Encashment\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                }
                /* if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_encashment_download'])  || Yii::app()->user->authorised_user == 1) {
                  if($row['approval_document']!=""){
                  $button_string.= '<a href="?r=leave/downloadapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
                  }
                  } */
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_encashment_view']) || Yii::app()->user->authorised_user == 1) {
                $encash_view = 1;
//                $button_string.= '<button class="btn btn-info btn-xs" title="View Leave Encashment Details" onclick="loadPopupModal(\'hr/leave/viewleaveencashmentdetails&id=' . $row['id'] . '\',\'Leave Encashment Details\',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';           
            }
            /* if ($final_level=='Y') {
              if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_encashment_download'])  || Yii::app()->user->authorised_user == 1) {
              $button_string.= '<a href="?r=leave/approvaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
              }
              }
             */
            $last_level = 0;
            if ($row->status == 1 || $row->status == 2 || $row->status == 4 || $row->status == 6 || $row->status == 8 || $row->status == 10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_admin_leave_encashment_approve']) || Yii::app()->user->authorised_user == 1) {
                    $last_level = $row->max_level;
                    $encash_direct_approve = 1;
//                    $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/leave/encashmentapproval&final_level=Y&level='.$last_level.'&id=' . $row['id'] . '\',\'Approve/Reject Leave Encashment\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                }
            }
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            if ($row['approve_date'] != '' && $row['approve_date'] != '0000-00-00') {
                $approve_date = date("d/m/Y", strtotime($row['approve_date']));
            }
            $employee_code = $this->ciphertext($row->employeedetail->employee_code, "d");
            $employee_name = $this->ciphertext($row->employeedetail->first_name, "d") . " " . $this->ciphertext($row->employeedetail->last_name, "d");
            $rowData[] = array(++$m, $employee_code, $employee_name, $row['leavetype']['leave_name'] . ' Encashment', $apply_date, $approve_date, $row->encashable_leave, $row->encashment_amount, EmployeeLeaveEncashment::getStatus($row['status']), array('last_level' => $last_level, 'encash_approve' => $encash_approve, 'encash_view' => $encash_view, 'encash_direct_approve' => $encash_direct_approve, 'id' => $row['id'], 'level_no' => $level_no, 'final_level' => $final_level));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionEncashmentApproval() {
        $id = Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = EmployeeLeaveEncashment::model()->findByPk($id);
        $year = date("Y");
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND leave_type="' . $model->leave_type_id . '" and employee_id="' . $model->employee_id . '"'));
        $current_date = date('Y-m-d');
        $condition = 'employee_id="' . $model->employee_id . '" and t.isActive="Y" and salary.consider_leave_settlement="Y" AND valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"';
        $model_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
        $salary_amount = $model_salary->amount;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('leave_encashment_approval', array('model' => $model, 'salary_amount' => $salary_amount, 'model_leave' => $model_leave, 'level' => $level, 'final_level' => $final_level), false, true);
    }

    public function actionsaveApproveEncashment() {
        $model = new EmployeeLeaveEncashment;
        if (isset($_POST['EmployeeLeaveEncashment'])) {
            if ((int) @$_POST['EmployeeLeaveEncashment']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeLeaveEncashment']['id'];
                $model = EmployeeLeaveEncashment::model()->findByPK($_POST['EmployeeLeaveEncashment']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            if (isset($_POST['EmployeeLeaveEncashment']['approval_document'])) {
                $model->approval_document = $_POST['EmployeeLeaveEncashment']['approval_document'];
            }
            $model->status = $_POST['EmployeeLeaveEncashment']['status'];
            $status = $_POST['EmployeeLeaveEncashment']['status'];
            $model->last_approved_level = $_POST['EmployeeLeaveEncashment']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id = 0;
            if ($modelemployee->employee_id > 0) {
                $approved_employee_id = $modelemployee->employee_id;
            } else if ($modelemployee->hr_connected_employee_id > 0) {
                $approved_employee_id = $modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approve_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                if ($model->save()) {
                    $year = date("Y");
                    if ($status == 12) {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND leave_type="' . $model->leave_type_id . '" and employee_id="' . $model->employee_id . '"'));
                        $available_leave = $model_leave->leave_current_balance;
                        $leave_days = $model->encashable_leave;
                        $balance_leave = $available_leave - $leave_days;
                        EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    }
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="8"'));
                    if (!empty($model_settings) && !empty($model_mail_settings)) {
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(6, $model->employee_id, $model->id);
                        }
                    }
                    $model->refresh();
                    $jsonData['model'] = 'EmployeeLeaveEncashment';
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            } else {

                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionCreateleaveEncashment() {
        $branch = (int) Yii::app()->request->getParam('branch');
        $model = new EmployeeLeaveEncashment();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('create_leave_encashment', array('model' => $model, 'branch' => $branch));
    }

    public function actionMasterEncashmentLeave() {
        $employee = Yii::app()->request->getparam("id");
        $models = MasLeave::getEncashableleavetype($employee);
        $model = new EmployeeLeaveEncashment();
        $dropdownlist = CHtml::activedropDownList($model, 'leave_type_id', $models, array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Type', 'empty' => 'Select', 'onchange' => 'getleavedays();'));
        $jsonData['leavetype'] = $dropdownlist;
        echo CJSON::encode($jsonData);
    }

    public function actionGetencashableDays() {
        $leave_type = Yii::app()->request->getparam("leave_type");
        $id = Yii::app()->request->getparam("id");
        $year = date("Y");
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $id . '" AND leave_type="' . $leave_type . '"'));
        $model_master_leave = MasLeave::model()->findbyPk($leave_type);
        $leave_current_balance = $model_leave->leave_current_balance;
        if ($model_master_leave->additional_leave > 0) {
            $leave_current_balance += $model_master_leave->additional_leave;
        }
        //Deducting Applied Leave Details
        $pending_leave = 0;
        $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('select' => 'sum(no_days) as no_days', 'condition' => 't.employee_id="' . $id . '" AND (t.leave_type="' . $leave_type . '" OR leavetype.parent_id="' . $leave_type . '") and (leave_status IN (0,1,2,4,6,8,10))'));
        $model_leave_encashable = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $leave_type . '" and employee_id="' . $id . '"'));
        if (!empty($model_leave_applied) && $model_leave_applied->no_days > 0) {
            $pending_leave += $model_leave_applied->no_days;
        }
        if (!empty($model_leave_encashable) && $model_leave_encashable->encashable_leave > 0) {
            $pending_leave += $model_leave_encashable->encashable_leave;
        }
        if ($pending_leave > 0) {
            $leave_current_balance -= $pending_leave;
        }
        $jsonData['leave'] = $leave_current_balance;
        $current_date = date('Y-m-d');
        $condition = 'employee_id="' . $id . '" and isActive="Y" and consider_for_leave_payment="Y" AND valid_from <="' . $current_date . '" AND valid_to ="0000-00-00"';
        $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => $condition));
        $salary_amount = $model_salary->amount;
        $salary_per_day = ($salary_amount / 30);
        $jsonData['salary_per_day'] = $salary_per_day;
        echo CJSON::encode($jsonData);
    }

    public function actionSaveApproveLeaveEncashment() {
        $model = new EmployeeLeaveEncashment;
        if (isset($_POST['EmployeeLeaveEncashment'])) {
            if ((int) @$_POST['EmployeeLeaveEncashment']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeLeaveEncashment']['id'];
                $model = EmployeeLeaveEncashment::model()->findByPK($_POST['EmployeeLeaveEncashment']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->apply_date = date("Y-m-d");
            }
            $model->attributes = $_POST['EmployeeLeaveEncashment'];
            $model->encashment_year = date("Y");
            $model->status = 1;
            $employee_id = $_POST['EmployeeLeaveEncashment']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="9"'));
            if (!empty($model_master_approve_setting)) {
                $model->function_type = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
            }
            if ($model->validate()) {
                if ($model->save()) {
                    $year = date("Y");
                    if ($model->status == 12) {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND    leave_type="' . $model->leave_type_id . '" and employee_id="' . $model->employee_id . '"'));
                        $available_leave = $model_leave->leave_current_balance;
                        $leave_days = $model->encashable_leave;
                        $balance_leave = $available_leave - $leave_days;
                        EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    }
                    $model->refresh();
                    $jsonData['model'] = 'EmployeeLeaveEncashment';
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            } else {

                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionGetleavesettlement() {
        $model_employee = new Employee();
        $branch_id = $_POST['branch_id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id',
            2 => 'de_first_name',
            3 => 'date_join',
            4 => 'middle_name',
            5 => 'last_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $current_date = date('Y-m-d');
        $condition = ' t.isActive="Y"';
        if ($branch_id > 0) {
            $condition .= ' and branch_or_sponsor_id = "' . $branch_id . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (de_first_name LIKE '%" . $searchString . "%' OR employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model_employee->count(array('condition' => $condition));
        $model_employee = $model_employee->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'de_first_name asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeecode . ' ' . $value->employeefullname] = $value->id;
        }
        ksort($arr_employee);
        foreach ($arr_employee as $k => $id) {
            $row = Employee::model()->findbyPk($id);
            $salary_amount = 0.00;
            $leave_settlement_amount = 0.00;
            $leave_count = 0;
            $model_leave = EmployeeLeave::model()->with('leavetype')->find(array('select' => 'sum(leave_current_balance) as leave_current_balance', 'condition' => 't.employee_id="' . $row['id'] . '"  AND leave_year="' . date('Y') . '" and encashable="Y"'));
            if (!empty($model_leave)) {
                $leave_count = $model_leave->leave_current_balance;
            }
            $model_salary = EmployeeSalary::model()->with('salary')->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $row['id'] . '" AND salary.consider_leave_settlement="Y" AND (("' . $current_date . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $current_date . '" AND valid_to="0000-00-00"))'));
            if ($model_salary->amount > 0) {
                $salary_amount = $model_salary->amount;
                $employee_per_day_salary = round($salary_amount / 30, 2);
                $leave_settlement_amount = round($leave_count * $employee_per_day_salary, 2);
            }
            $rowData[] = array(++$m, $row['employeecode'], $row['employeefullname'], Yii::app()->numberFormatter->formatCurrency($salary_amount, ""), $leave_count, Yii::app()->numberFormatter->formatCurrency($leave_settlement_amount, ""));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionprintleavesettlement() {
        $branch_id = $_GET['branch_id'];
        $model = new Employee();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.leave_settlement', array('branch_id' => $branch_id, 'model' => $model), true));
        $mPDF1->Output('gratuity', 'I');
    }

    public function actionleavesettlementsingle() {
        $model = new EmployeeLeavesettlement;
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('leave_settlement', array('model' => $model));
    }

    public function actionleavesettlementdetail() {
        $emp_id = Yii::app()->request->getparam("emp_id");
        $modelemployee = Employee::model()->findbyPK($emp_id);
        $model_settlement = new EmployeeLeavesettlement;
        $this->render('employee_settlement_details', array('modelemployee' => $modelemployee, 'model_settlement' => $model_settlement, 'emp_id' => $emp_id), false, true);
    }

    public function actiongetworkingperiod() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $join_date = Yii::app()->request->getparam("join_date");
        $leaving_date = Yii::app()->request->getparam("leaving_date");
        $leaving_date = str_replace('/', '-', $leaving_date);
        $leaving_date = date("Y-m-d", strtotime($leaving_date));
        $d1 = strtotime($join_date);
        $d2 = strtotime($leaving_date);
        $datediff = $d2 - $d1;
        $service_days = $datediff / (60 * 60 * 24);
        $years = round($service_days / 365, 1);
        $date1 = new DateTime($join_date);
        $date2 = new DateTime($leaving_date);
        $dd = date_diff($date1, $date2);
        $service_period = "$dd->y Yrs $dd->m Month $dd->d Day";
        $leave_count = 0;
        $model_leave = EmployeeLeave::model()->with('leavetype')->find(array('select' => 'sum(leave_current_balance) as leave_current_balance', 'condition' => 'encashable="Y" and t.employee_id="' . $employee_id . '"  AND leave_year="' . date('Y') . '"'));
        if ($model_leave->leave_current_balance > 0) {
            $leave_count = $model_leave->leave_current_balance;
        }
        $employee_per_day_salary = 0.00;
        $model_salary = EmployeeSalary::model()->find(array('select' => 'sum(amount) as amount', 'condition' => 'employee_id="' . $employee_id . '" AND consider_for_leave_payment="Y" AND (("' . $leaving_date . '" BETWEEN valid_from AND valid_to) OR (valid_from <= "' . $leaving_date . '" AND valid_to="0000-00-00"))'));
        if ($model_salary->amount > 0) {
            $salary_amount = $model_salary->amount;
            $employee_per_day_salary = round($salary_amount / 30, 2);
        }
        $jsonData['available_leave'] = $leave_count;
        $jsonData['years'] = $years;
        $jsonData['service_period'] = $service_period;
        $jsonData['salary_per_day'] = $employee_per_day_salary;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionSaveLeavesettlement() {
        if (isset($_POST['EmployeeLeavesettlement'])) {
            $model = new EmployeeLeavesettlement();
            if ((int) @$_POST['EmployeeLeavesettlement']['id'] > 0) {
                $model = EmployeeLeavesettlement::model()->findByPK($_POST['EmployeeLeavesettlement']['id']);
                $model->id = (int) $_POST['EmployeeLeavesettlement']['id'];
                $model->scenario = 'update';
            } else {
                unset($_POST['EmployeeLeavesettlement']['id']);
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['EmployeeLeavesettlement'];
            if ($_POST['EmployeeLeavesettlement']['date_leave'] != '0000-00-00' && $_POST['EmployeeLeavesettlement']['date_leave'] != '') {
                $model->date_leave = str_replace('/', '-', $_POST['EmployeeLeavesettlement']['date_leave']);
                $model->date_leave = date("Y-m-d", strtotime($model->date_leave));
            }
            $model->prepared_by = Yii::app()->user->id;
            $model->other_payments = $_POST['EmployeeLeavesettlement']['other_payments'];
            $model->notes = $_POST['EmployeeLeavesettlement']['notes'];
            $model->status = 1;
            $model->date_applied = date('Y-m-d');
            if ($model->validate()) {
                $model->save();
                $model->refresh();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionleavesettlementindex() {
        $model_module_leave = HrModules::model()->findByPK(3);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_settlemnt_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')) {
            $model = new EmployeeLeavesettlement();
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leave_settlement_index', array('model' => $model));
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeLeaveSettlement() {

        $model = new EmployeeLeavesettlement();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id',
            2 => 'employeedetail.first_name',
            3 => 'date_applied',
            4 => 'date_leave',
            5 => 'employee_service_days',
            6 => 'available_leaves',
            7 => 'encashed_leaves',
            8 => 'balance_leave',
            9 => 'leave_salary',
            10 => 'other_payments',
            11 => 'settlement_amount',
            12 => 'status',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 'status="1"';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'date_applied asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $apply_date = '';
            if ($row['date_applied'] != '' && $row['date_applied'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->date_applied));
            }
            $date_leave = '';
            if ($row['date_leave'] != '' && $row['date_leave'] != '0000-00-00') {
                $date_leave = date("d/m/Y", strtotime($row->date_leave));
            }
            $status = '';
            if ($row['status'] == 1) {
                $status = 'Applied';
            } else if ($row['status'] == 2) {
                $status = 'Approved';
            }
//            $button_string = "";
            $settlement_approve = 0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_settlement_approve']) || Yii::app()->user->authorised_user == 1) {
                if ($row['status'] == 1) {
                    $settlement_approve = 1;
//                    $button_string.= '<button class="btn btn-primary btn-xs" title="Approve" onclick="loadPopupModal(\'hr/leave/approveleavesettlement&id=' . $row['id'] . '\',\'Approve Leave Settlement \',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                }
            }
            $rowData[] = array(++$m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $apply_date, $date_leave, $row->employee_service_period, $row->available_leaves, $row->encashed_leaves, $row->balance_leave, $row->leave_salary, $row->other_payments, $row->settlement_amount, $status, array('id' => $row['id'], 'settlement_approve' => $settlement_approve));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionApproveLeavesettlement() {
        $id = Yii::app()->request->getparam("id");
        $model = new EmployeeLeavesettlement();
        if ($id > 0) {
            $model = EmployeeLeavesettlement::model()->findByPK($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('leave_settlement_approval', array('model' => $model));
    }

    public function actionsaveapproveleavesettlement() {
        if (isset($_POST['EmployeeLeavesettlement'])) {
            $model = new EmployeeLeavesettlement();
            if ((int) @$_POST['EmployeeLeavesettlement']['id'] > 0) {
                $model = EmployeeLeavesettlement::model()->findByPK($_POST['EmployeeLeavesettlement']['id']);
                $model->id = (int) $_POST['EmployeeLeavesettlement']['id'];
                $model->scenario = 'update';
            }
            $model->status = $_POST['EmployeeLeavesettlement']['status'];
            $model->date_approved = date('Y-m-d');
            $model->checked_by = Yii::app()->user->id;
            $status = $_POST['EmployeeLeavesettlement']['status'];
            if ($model->validate()) {
                $model->save();
                if ($status == 2) {
                    $model_leave_type = MasLeave::model()->findAll(array('condition' => 'isActive =  "Y" and encashable="Y"'));
                    $leave_count = $model->encashed_leaves;
                    foreach ($model_leave_type as $key_1 => $value_1) {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model->employee_id . '" AND leave_type="' . $value_1->id . '" AND leave_year="' . date('Y') . '"'));
                        if ($leave_count > 0) {
                            $total_leave = $model_leave->leave_current_balance;
                            $leave_encashed = 0;
                            if ($total_leave > $leave_count) {
                                $leave_encashed = $total_leave - $leave_count;
                            } else {
                                $leave_encashed = $leave_count - $total_leave;
                            }
                            $leave_count = $leave_count - $leave_encashed;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $leave_encashed, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        }
                    }
                }
                $model->refresh();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionViewLeavedetails() {
        $model = new EmployeeLeaveDetail();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('leave_details_view', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionLeavecancelRequest() {
        $id = Yii::app()->request->getparam("id");
        $model = EmployeeLeaveDetail::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('leave_cancel_request', array('model' => $model), false, true);
    }

    public function actionLeavecancelbylm() {
        $id = Yii::app()->request->getparam("id");
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = EmployeeLeaveDetail::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('leave_cancel_lm', array('model' => $model, 'level' => $level, 'final_level' => $final_level), false, true);
    }

    public function actionSaveleaveCancel() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $id = $_POST['EmployeeLeaveDetail']['id'];
                $cancel_reason_employee = $_POST['EmployeeLeaveDetail']['cancel_reason_employee'];
                EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => 0, 'cancel_reason_employee' => $cancel_reason_employee, 'leave_status' => 14, 'date_apply_cancel' => date('Y-m-d'), 'status_cancel' => 1, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                //Mail
                $model = EmployeeLeaveDetail::model()->findbyPk($id);
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="3"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(3, $model->employee_id, $model->id);
                    }
                }
                $data['status'] = 'success';
            } else {
                $data['status'] = 'error';
            }
            echo CJSON::encode($data);
        }
    }

    public function actionSaveleavecancelbyLM() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $id = $_POST['EmployeeLeaveDetail']['id'];
                $leave_status = $_POST['EmployeeLeaveDetail']['leave_status'];
                $cancel_comment = $_POST['approval_comment_1'];
                $level = $_POST['approval_level_1'];
                $last_cancel_level = $_POST['EmployeeLeaveDetail']['last_cancel_level'];
                $modelemployee = User::model()->findByPK(Yii::app()->user->id);
                if ($level == 1) {
                    EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => $last_cancel_level, 'cancel_level_1_id' => $modelemployee->employee_id, 'cancel_comment_lm' => $cancel_comment, 'leave_status' => $leave_status, 'date_cancel_lm' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                } else if ($level == 2) {
                    EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => $last_cancel_level, 'cancel_level_2_id' => $modelemployee->employee_id, 'cancel_level_2_comment' => $cancel_comment, 'leave_status' => $leave_status, 'date_cancel_level_2' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                } else if ($level == 3) {
                    EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => $last_cancel_level, 'cancel_level_3_id' => $modelemployee->employee_id, 'cancel_level_3_comment' => $cancel_comment, 'leave_status' => $leave_status, 'date_cancel_level_3' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                } else if ($level == 4) {
                    EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => $last_cancel_level, 'cancel_level_4_id' => $modelemployee->employee_id, 'cancel_level_4_comment' => $cancel_comment, 'leave_status' => $leave_status, 'date_cancel_level_4' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                } else if ($level == 5) {
                    EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => $last_cancel_level, 'cancel_level_5_id' => $modelemployee->employee_id, 'cancel_level_5_comment' => $cancel_comment, 'leave_status' => $leave_status, 'date_cancel_level_5' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                }

                //Mail
                $model = EmployeeLeaveDetail::model()->findbyPk($id);
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="4"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(4, $model->employee_id, $model->id);
                    }
                }
                $data['status'] = 'success';
            } else {
                $data['status'] = 'error';
            }
            echo CJSON::encode($data);
        }
    }

    public function actionLeavecancelbyhr() {
        $id = Yii::app()->request->getparam("id");
        $model = EmployeeLeaveDetail::model()->findbyPk($id);
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('leave_cancel_hr', array('model' => $model, 'level' => $level, 'final_level' => $final_level), false, true);
    }

    public function actionSaveleavecancelbyHR() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $id = $_POST['EmployeeLeaveDetail']['id'];
                $leave_status = $_POST['EmployeeLeaveDetail']['leave_status'];
                $cancel_comment_hr = $_POST['EmployeeLeaveDetail']['cancel_comment_hr'];
                $last_cancel_level = $_POST['EmployeeLeaveDetail']['last_cancel_level'];
                $modelemployee = User::model()->findByPK(Yii::app()->user->id);
                EmployeeLeaveDetail::model()->updateByPK($id, array('last_cancel_level' => $last_cancel_level, 'cancel_approved_id' => $modelemployee->employee_id, 'cancel_comment_hr' => $cancel_comment_hr, 'leave_status' => $leave_status, 'date_cancel_hr' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                if ($leave_status == 25) {
                    $model_setting = HrGenerelSettings::model()->find();
                    $year = date("Y");
                    $current_month = date("m");
                    if ($current_month < $model_setting->leave_carry_forward_month) {
                        $year = $year - 1;
                    }
                    $model_leave_detail = EmployeeLeaveDetail::model()->findbyPk($id);
                    $model_master_leave = MasLeave::model()->findbyPk($model_leave_detail->leave_type);
                    if ($model_master_leave->sub_type_leave == "N") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_leave_detail->leave_type . '" and leave_year="' . $year . '"'));
                    } else if ($model_master_leave->sub_type_leave == "Y") {
                        $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                    }
                    if (empty($model_leave)) {
                        $prv_year = $year - 1;
                        if ($model_master_leave->sub_type_leave == "N") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_leave_detail->leave_type . '" and leave_year="' . $prv_year . '"'));
                        } else if ($model_master_leave->sub_type_leave == "Y") {
                            $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $prv_year . '"'));
                        }
                    }
                    //$model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $model_leave_detail->employee_id . '" AND leave_type="'.$model_leave_detail->leave_type. '"'));
                    if ($model_leave->id > 0) {
                        if ($model_leave_detail->approved_date != '0000-00-00') {
                            $available_leave = $model_leave->leave_current_balance;
                            $leave_days = $model_leave_detail->normal_leave;
                            $balance_leave = $available_leave + $leave_days;
                            EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                            $model_leave_ledger = new EmployeeLeaveLedger();
                            $model_leave_ledger->employee_id = $model_leave_detail->employee_id;
                            $model_leave_ledger->leave_type = $model_leave_detail->leave_type;
                            $model_leave_ledger->leave_count = $model_leave_detail->normal_leave;
                            $model_leave_ledger->remarks = "Leave added by cancellation of leave from " . date("d/m/Y", strtotime($model_leave_detail->leave_start_date)) . " to " . date("d/m/Y", strtotime($model_leave_detail->leave_end_date));
                            $model_leave_ledger->created_by = Yii::app()->user->id;
                            $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                            $model_leave_ledger->save();
                        }
                        //Mail
                        $model = EmployeeLeaveDetail::model()->findbyPk($id);
                        $model_settings = HrGenerelSettings::model()->find();
                        $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="4"'));
                        if (!empty($model_settings) && !empty($model_mail_settings)) {
                            if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                                Yii::import('application.modules.hr.controllers.MailController');
                                MailController::sendmail(4, $model->employee_id, $model->id);
                            }
                        }
                    }
                }
                $data['status'] = 'success';
            } else {
                $data['status'] = 'error';
            }
            echo CJSON::encode($data);
        }
    }

    public function actionLeaveencashmentDetails() {
        $this->layout = "main";
        $model_module_leave_encashment = HrModules::model()->findByPK(4);
        if ($model_module_leave_encashment->grant_access == 1 && $model_module_leave_encashment->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leave_encashment_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetLeaveEncashment() {
        $model = new EmployeeLeaveEncashment();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'leave_type_id',
            2 => 'apply_date',
            3 => 'approve_date',
            4 => 'encashable_leave',
            5 => 'encashment_amount',
            6 => 'status',
            7 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $model_employee = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $condition = 't.employee_id="' . $employee_id . '" and YEAR(apply_date)="' . date('Y') . '"';
        EmployeeLeaveEncashment::model()->updateAll(array('view_status' => 1), 'employee_id="' . $employee_id . '" and view_status="0" and (status="12" OR status="13")');
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (leavetype.leave_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('leavetype')->count(array('condition' => $condition));
        $model = $model->with('leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $download_button = 0;
            $button_string = '<button class="btn btn-success btn-xs" title="Leave Encashment Details" onclick="loadPopupModal(\'hr/leave/viewleaveencashmentdetails&id=' . $row['id'] . '\',\'Leave Encashment Details\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
            if ($row['approval_document'] != "") {
                $download_button = 1;
                $button_string .= '<a href="?r=hr/leave/downloadapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
            }
            $apply_date = "";
            $approve_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }
            if ($row['approve_date'] != '' && $row['approve_date'] != '0000-00-00') {
                $approve_date = date("d/m/Y", strtotime($row['approve_date']));
            }
            $rowData[] = array(++$m, $row['leavetype']['leave_name'], $apply_date, $approve_date, $row['encashable_leave'], $row['encashment_amount'], EmployeeLeaveEncashment::getStatus($row['status']), array('id' => $row['id'], 'download_button' => $download_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionViewleaveencashmentdetails() {
        $model = new EmployeeLeaveEncashment();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('leave_encashmentdetails_view', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionCancelwholeLeave() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model_setting = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_month = date("m");
            if ($current_month < $model_setting->leave_carry_forward_month) {
                $year = $year - 1;
            }
            $model_leave_detail = EmployeeLeaveDetail::model()->findbyPk($id);
            EmployeeLeaveDetail::model()->updateByPK($id, array('cancel_comment_hr' => "Cancelled by HR", 'leave_status' => 27, 'date_cancel_hr' => date('Y-m-d'), 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
            $model_master_leave = MasLeave::model()->findbyPk($model_leave_detail->leave_type);
            if ($model_master_leave->sub_type_leave == "N") {
                $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_leave_detail->leave_type . '" and leave_year="' . $year . '"'));
            } else if ($model_master_leave->sub_type_leave == "Y") {
                $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
            }
            if (empty($model_leave)) {
                $prv_year = $year - 1;
                if ($model_master_leave->sub_type_leave == "N") {
                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_leave_detail->leave_type . '" and leave_year="' . $prv_year . '"'));
                } else if ($model_master_leave->sub_type_leave == "Y") {
                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $prv_year . '"'));
                }
            }
            $model_attendance = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $model_leave_detail->employee_id . '" and attendance_date>="' . $model_leave_detail->leave_start_date . '" AND attendance_date<="' . $model_leave_detail->leave_end_date . '" AND status="3"'));
            if (!empty($model_attendance)) {
                EmployeeAttendance::model()->updateAll(array('status' => 2, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'employee_id="' . $model_leave_detail->employee_id . '" and attendance_date>="' . $model_leave_detail->leave_start_date . '" AND attendance_date<="' . $model_leave_detail->leave_end_date . '"');
            }
            //$model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $model_leave_detail->employee_id . '" AND leave_type="'.$model_leave_detail->leave_type. '"'));
            if ($model_leave->id > 0 && $model_leave_detail->approved_date != '0000-00-00') {
                $available_leave = $model_leave->leave_current_balance;
                $leave_days = $model_leave_detail->normal_leave;
                $balance_leave = $available_leave + $leave_days;
                EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                $model_leave_ledger = new EmployeeLeaveLedger();
                $model_leave_ledger->employee_id = $model_leave_detail->employee_id;
                $model_leave_ledger->leave_type = $model_leave_detail->leave_type;
                $model_leave_ledger->leave_count = $model_leave_detail->normal_leave;
                $model_leave_ledger->remarks = "Leave added by cancellation of leave from " . date("d/m/Y", strtotime($model_leave_detail->leave_start_date)) . " to " . date("d/m/Y", strtotime($model_leave_detail->leave_end_date));
                $model_leave_ledger->created_by = Yii::app()->user->id;
                $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                $model_leave_ledger->save();
            }
            $data['status'] = 'success';
        } else {
            $data['status'] = 'error';
        }
        echo CJSON::encode($data);
    }

    public function actionEditApprovedLeave() {
        $model = new EmployeeLeaveDetail();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('edit_employee_leave_approve', array('model' => $model));
    }

    public function actionGetDays() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $start_date = Yii::app()->request->getparam("start_date");
        $end_date = Yii::app()->request->getparam("end_date");
        $leave_type = Yii::app()->request->getparam("leave_type");
        $normal_leave = Yii::app()->request->getparam("normal_leave");
        $checkbox = Yii::app()->request->getparam("checkbox");
        if ($start_date != '' && $end_date != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $start_date)));
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $end_date)));
            $model_setting = HrGenerelSettings::model()->find();
            $model = Employee::model()->findbyPK($employee_id);
            $model_master_leave = MasLeave::model()->findbyPk($leave_type);
            //Check holiday deducted
            $model_branch_details = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $include_holiday = '';
            if ($model_master_leave->exclude_holiday == 'Y') {
                $include_holiday = 'N';
            } else if ($model_master_leave->exclude_holiday == 'N') {
                $include_holiday = 'Y';
            }
            $weekend_off1 = $model->weekend_off1;
            $weekend_off2 = $model->weekend_off2;
            $weekend_off3 = $model->weekend_off3;
            $weekend = $model_master_leave->exclude_weekend;
            //Day Calculation
            $leave_days = 0;
            $d1 = strtotime($start_date);
            $d2 = strtotime($end_date);
            $total_days = $d2 - $d1;
            if ($weekend == 'Y') {
                $datefrom = $start_date;
                $diff = floor($total_days / (60 * 60 * 24));
                for ($i = 0; $i <= $diff; $i++) {
                    $model_holiday = MasHoliday::model()->find(array('condition' => 'is_Active="Y" AND holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_branch_details->id . '",branch_id)'));
                    $weekvalue = date('w', strtotime($datefrom));
                    $weekvalue += 1;
                    if ($weekend_off1 == $weekvalue || $weekend_off2 == $weekvalue || $weekend_off3 == $weekvalue) {
                        
                    } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                        $leave_days++;
                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                        
                    } else {
                        $leave_days++;
                    }
                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                }
                if ($checkbox == 1) {
                    $leave_days = $leave_days - 0.5;
                }
            } else {
                $datefrom = $start_date;
                $diff = floor($total_days / (60 * 60 * 24));
                for ($i = 0; $i <= $diff; $i++) {
                    $model_holiday = MasHoliday::model()->find(array('condition' => 'is_Active="Y" AND holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_branch_details->id . '",branch_id)'));
                    if ($include_holiday == "Y" && !empty($model_holiday)) {
                        $leave_days++;
                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                        
                    } else {
                        $leave_days++;
                    }
                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                }
                if ($checkbox == 1) {
                    $leave_days = $leave_days - 0.5;
                }
                //$leave_days = floor($total_days / (60 * 60 * 24) + 1);
            }
            $new_normal_leave = $new_deducted_leave = 0;
            if ($normal_leave > 0) {
                if ($leave_days >= $normal_leave) {
                    $new_normal_leave = $normal_leave;
                    $new_deducted_leave = $leave_days - $normal_leave;
                } else if ($leave_days < $normal_leave) {
                    $new_normal_leave = $leave_days;
                    $new_deducted_leave = 0;
                }
            } else {
                $new_normal_leave = 0;
                $new_deducted_leave = $leave_days;
            }
            $jsonData['normal_leave_days'] = $new_normal_leave;
            $jsonData['deducted_leave_days'] = $new_deducted_leave;
            $jsonData['days'] = $leave_days;
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveEditleave() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeLeaveDetail']['id'] > 0) {
                $id = $_POST['EmployeeLeaveDetail']['id'];
                $no_days = $_POST['EmployeeLeaveDetail']['no_days'];
                $normal_leave = $_POST['EmployeeLeaveDetail']['normal_leave'];
                $salary_deduction_leave = $_POST['EmployeeLeaveDetail']['salary_deduction_leave'];
                $total_leave = $_POST['total_leave_days'];
                $leave_diff = $total_leave - $normal_leave;
                $model_leave_detail = EmployeeLeaveDetail::model()->findbyPk($id);
                $start_date = $model_leave_detail->leave_start_date;
                $end_date = $model_leave_detail->leave_end_date;
                $leave_start_date = "";
                $leave_end_date = "";
                if ($_POST['EmployeeLeaveDetail']['leave_start_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['leave_start_date'] != '') {
                    $leave_start_date = str_replace('/', '-', $_POST['EmployeeLeaveDetail']['leave_start_date']);
                    $leave_start_date = date("Y-m-d", strtotime($leave_start_date));
                }
                if ($_POST['EmployeeLeaveDetail']['leave_end_date'] != '0000-00-00' && $_POST['EmployeeLeaveDetail']['leave_end_date'] != '') {
                    $leave_end_date = str_replace('/', '-', $_POST['EmployeeLeaveDetail']['leave_end_date']);
                    $leave_end_date = date("Y-m-d", strtotime($leave_end_date));
                }
                $half_day_time = '';
                if (isset($_POST['EmployeeLeaveDetail']['half_day_leave']) && $_POST['EmployeeLeaveDetail']['half_day_leave'] == 'Y') {
                    $half_day_time = $_POST['EmployeeLeaveDetail']['half_day_time'];
                }
                $half_day_leave = $_POST['EmployeeLeaveDetail']['half_day_leave'];
                EmployeeLeaveDetail::model()->updateByPK($id, array('no_days' => $no_days, 'half_day_time' => $half_day_time, 'half_day_leave' => $half_day_leave, 'no_days' => $no_days, 'normal_leave' => $normal_leave, 'salary_deduction_leave' => $salary_deduction_leave, 'leave_start_date' => $leave_start_date, 'leave_end_date' => $leave_end_date, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                if ($leave_diff > 0) {
                    $model_setting = HrGenerelSettings::model()->find();
                    $year = date("Y");
                    $current_month = date("m");
                    if ($current_month < $model_setting->leave_carry_forward_month) {
                        $year = $year - 1;
                    }
                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $model_leave_detail->employee_id . '" AND leave_type="' . $model_leave_detail->leave_type . '"'));
                    if ($model_leave->id > 0) {
                        $available_leave = $model_leave->leave_current_balance;
                        $leave_days = $leave_diff;
                        $balance_leave = $available_leave + $leave_days;
                        EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        /*    $model_leave_ledger = new EmployeeLeaveLedger();
                          $model_leave_ledger->employee_id =$model_leave_detail->employee_id;
                          $model_leave_ledger->leave_type =$model_leave_detail->leave_type;
                          $model_leave_ledger->leave_count =$leave_diff;
                          $model_leave_ledger->remarks ="Leave from ".date("d/m/Y", strtotime($start_date))." to ".date("d/m/Y", strtotime($end_date))." changed to ".date("d/m/Y", strtotime($leave_start_date))." to ".date("d/m/Y", strtotime($leave_end_date));
                          $model_leave_ledger->created_by = Yii::app()->user->id;
                          $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                          $model_leave_ledger->save(); */
                    }
                }
                //Delete from Salary Deduction Table
                $model_updated_leave = EmployeeLeaveDetail::model()->findByPK($model_leave_detail->id);
                EmployeeSalaryDeductionLeave::model()->deleteAll(array('condition' => 'leave_id="' . $model_updated_leave->id . '" and leave_date>"' . $model_updated_leave->leave_end_date . '"'));
                EmployeeSalaryDeductionLeave::model()->deleteAll(array('condition' => 'leave_id="' . $model_updated_leave->id . '" and leave_date<"' . $model_updated_leave->leave_start_date . '"'));
                EmployeeAttendance::model()->updateAll(array('status' => 2, 'leave_id' => 0), 'employee_id="' . $model_leave_detail->employee_id . '" and leave_id="' . $model_leave_detail->id . '" and attendance_date<"' . $model_updated_leave->leave_start_date . '"');
                EmployeeAttendance::model()->updateAll(array('status' => 2, 'leave_id' => 0), 'employee_id="' . $model_leave_detail->employee_id . '" and leave_id="' . $model_leave_detail->id . '" and attendance_date>"' . $model_updated_leave->leave_end_date . '"');
                $data['status'] = 'success';
            } else {
                $data['status'] = 'error';
            }
            echo CJSON::encode($data);
        }
    }

    public function actionCheckleavedateinAdmin() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $available_leave = Yii::app()->request->getparam("available_leave");
        $leave_type = Yii::app()->request->getparam("leave_type");
        $start_date = Yii::app()->request->getparam("start_date");
        $end_date = Yii::app()->request->getparam("end_date");
        $checkbox = Yii::app()->request->getparam("checkbox");
        $current_leave_year = date('Y');
        if ($start_date != '' && $end_date != '') {
            $start_date = str_replace('/', '-', $start_date);
            $start_date = date("Y-m-d", strtotime($start_date));
            $end_date = str_replace('/', '-', $end_date);
            $end_date = date("Y-m-d", strtotime($end_date));
            $current_date = date('Y-m-d');
            $date1_convert = strtotime($current_date);
            $date2_convert = strtotime($start_date);
            $apply_days = $date2_convert - $date1_convert;
            $applyday = floor($apply_days / (60 * 60 * 24));
            $model_master_leave = MasLeave::model()->findbyPk($leave_type);
            //$additional_leave=$model_master_leave->additional_leave;
            //$available_leave+=$additional_leave;
            $model_setting = HrGenerelSettings::model()->find();
            $current_month = date("m");
            if ($current_month < $model_setting->leave_carry_forward_month) {
                $current_leave_year = $current_leave_year - 1;
            }
            $model_employee_dtl = Employee::model()->findbyPk($employee_id);
            //Check holiday deducted
            $model_branch_details = MasCompanyBranchSponsor::model()->findbyPK($model_employee_dtl->branch_or_sponsor_id);
            $include_holiday = '';
            if ($model_master_leave->exclude_holiday == 'Y') {
                $include_holiday = 'N';
            } else if ($model_master_leave->exclude_holiday == 'N') {
                $include_holiday = 'Y';
            }
            $leave_apply_permission = $model_setting->leave_apply_permission;
            if ($model_setting->leave_apply_before_current_date == 'Y') {
                $model_master_leave->apply_before = 0;
            }
            if ($model_setting->consider_advance_leave == 'Y' && $model_master_leave->leave_type == 1) {
                $basic_increment = $model_master_leave->leave_days;
                $service_year = $this->getserviceyear($model_employee_dtl->date_join, $end_date);
                if ($service_year >= 10) {
                    $basic_increment = $model_master_leave->leave_days_above_10;
                } else if ($service_year >= 5) {
                    $basic_increment = $model_master_leave->leave_days_above_5;
                } else if ($service_year >= 1) {
                    $basic_increment = $model_master_leave->leave_days_above_1;
                }
                //Get Max Salary Details
                $model_max_id = SalarySlip::model()->with('processing')->find(array('select' => 'MAX(salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" AND employee_id="' . $employee_id . '"'));
                if ($model_max_id->salary_processing_id > 0) {
                    $model_salry_processing = SalaryProcessing::model()->findbyPk($model_max_id->salary_processing_id);
                    $payroll_dt = $model_salry_processing->payroll_enddate;
                    $date_for_advnc_1 = strtotime($payroll_dt);
                    $date_for_advnc_2 = strtotime($end_date);
                    $year11 = date('Y', $date_for_advnc_1);
                    $year12 = date('Y', $date_for_advnc_2);
                    $month11 = date('m', $date_for_advnc_1);
                    $month12 = date('m', $date_for_advnc_2);
                    $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                    $available_leave += $advance_leave_month * $basic_increment;
                } else {
                    $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                    if ($model_lock_month->id == '') {
                        $model_lock_month = MasterSalaryLock::model()->find(array('condition' => 'payroll_branch=0'));
                    }
                    $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch="' . $model_employee_dtl->branch_or_sponsor_id . '"'));
                    if ($model_lock_days->id == '') {
                        $model_lock_days = MasterSalaryProcedure::model()->find(array('condition' => 'payroll_branch=0'));
                    }
                    $salary_last_date = $model_lock_month->payroll_year . '-' . $model_lock_month->payroll_month . '-' . $model_lock_days->payroll_start_day;
                    // $salary_last_date=date('Y-m-d', strtotime('+1 month', strtotime($salary_last_date)));
                    $date_for_advnc_1 = strtotime($salary_last_date);
                    $date_for_advnc_2 = strtotime($end_date);
                    $year11 = date('Y', $date_for_advnc_1);
                    $year12 = date('Y', $date_for_advnc_2);
                    $month11 = date('m', $date_for_advnc_1);
                    $month12 = date('m', $date_for_advnc_2);
                    $advance_leave_month = (($year12 - $year11) * 12) + ($month12 - $month11);
                    $available_leave += $advance_leave_month * $basic_increment;
                }
            }
            $jsonData['tot_available_leave'] = $available_leave;
            if ($model_master_leave->sub_type_leave == "N") {
                $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $current_leave_year . '"'));
            } else if ($model_master_leave->sub_type_leave == "Y") {
                $model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $current_leave_year . '"'));
            }
            //$model_leave_table_exist = EmployeeLeave::model()->find(array('condition' => 'employee_id="' .$employee_id. '" and leave_type = "' . $leave_type . '" and leave_year="'.$current_leave_year.'"'));
            if (!empty($model_leave_table_exist)) {
                //Attendance marked
                $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"', 'order' => 'attendance_date asc'));
                if (empty($model_attendance_present)) {
                    if ($applyday >= $model_master_leave->apply_before || $model_master_leave->apply_before == 0) {
                        $model_employee_leave_approved = EmployeeLeaveDetail::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and ((leave_start_date<="' . $start_date . '" AND leave_end_date>="' . $end_date . '") OR  (leave_start_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                                   OR leave_end_date BETWEEN  "' . $start_date . '" AND  "' . $end_date . '")) and (leave_status="0" OR leave_status="1" or leave_status="2" or leave_status="4" or leave_status="6" or leave_status="8" or leave_status="10" or leave_status="12" or leave_status="14" or leave_status="15" or leave_status="17" or leave_status="19" or leave_status="21")'));
                        if (empty($model_employee_leave_approved)) {
                            $model = Employee::model()->findbyPK($employee_id);
                            $weekend_off1 = $model->weekend_off1;
                            $weekend_off2 = $model->weekend_off2;
                            $weekend_off3 = $model->weekend_off3;
                            $weekend = $model_master_leave->exclude_weekend;
                            //Day Calculation
                            $leave_days = 0;
                            $d1 = strtotime($start_date);
                            $d2 = strtotime($end_date);
                            $total_days = $d2 - $d1;
                            if ($weekend == 'Y') {
                                $datefrom = $start_date;
                                $diff = floor($total_days / (60 * 60 * 24));
                                for ($i = 0; $i <= $diff; $i++) {
                                    $model_holiday = MasHoliday::model()->find(array('condition' => 'is_Active="Y" AND holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_employee_dtl->branch_or_sponsor_id . '",branch_id)'));
                                    $weekvalue = date('w', strtotime($datefrom));
                                    $weekvalue += 1;
                                    if ($weekend_off1 == $weekvalue) {
                                        if ($model->weekend_off1_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($weekend_off2 == $weekvalue) {
                                        if ($model->weekend_off2_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($weekend_off3 == $weekvalue) {
                                        if ($model->weekend_off3_type == 'H') {
                                            $leave_days = $leave_days + 0.5;
                                        }
                                    } else if ($include_holiday == "Y" && !empty($model_holiday)) {
                                        $leave_days++;
                                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                        
                                    } else {
                                        $leave_days++;
                                    }
                                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                }
                                if ($checkbox == 1) {
                                    $leave_days = $leave_days - 0.5;
                                }
                            } else {
                                $datefrom = $start_date;
                                $diff = floor($total_days / (60 * 60 * 24));
                                for ($i = 0; $i <= $diff; $i++) {
                                    $model_holiday = MasHoliday::model()->find(array('condition' => 'is_Active="Y" AND holiday_date="' . $datefrom . '" AND FIND_IN_SET("' . $model_employee_dtl->branch_or_sponsor_id . '",branch_id)'));
                                    if ($include_holiday == "Y" && !empty($model_holiday)) {
                                        $leave_days++;
                                    } else if ($include_holiday == "N" && !empty($model_holiday)) {
                                        
                                    } else {
                                        $leave_days++;
                                    }
                                    $datefrom = date('Y-m-d', strtotime($datefrom . ' +1 day'));
                                }
                                //$leave_days = floor($total_days / (60 * 60 * 24) + 1);
                                if ($checkbox == 1) {
                                    $leave_days = $leave_days - 0.5;
                                }
                            }
                            if ($model_master_leave->negative_leave_apply_permission != 'N') {
                                if ($leave_days <= $available_leave) {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 0;
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        $jsonData['days'] = $leave_days;
                                        $jsonData['normal_leave'] = $leave_days;
                                        $jsonData['salary_deduction_leave'] = 0.00;
                                        $jsonData['status'] = 'success';
                                        $jsonData['dateerror'] = 0;
                                    }
                                } else {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {   //Leave limit condition when negative salary deduction
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                                $salary_deduction_leave = $leave_days - $available_leave;
                                                $jsonData['days'] = $leave_days;
                                                $jsonData['normal_leave'] = $available_leave;
                                                $jsonData['salary_deduction_leave'] = $salary_deduction_leave;
                                                $jsonData['status'] = 'success';
                                                $jsonData['dateerror'] = 8;
                                            } else {
                                                $jsonData['days'] = $leave_days;
                                                $jsonData['normal_leave'] = $leave_days;
                                                $jsonData['salary_deduction_leave'] = 0.00;
                                                $jsonData['status'] = 'success';
                                                $jsonData['dateerror'] = 0;
                                            }
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        if ($model_master_leave->salary_deduction_negative_leave != 'N') {
                                            $salary_deduction_leave = $leave_days - $available_leave;
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $available_leave;
                                            $jsonData['salary_deduction_leave'] = $salary_deduction_leave;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 8;
                                        } else {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                            $jsonData['dateerror'] = 0;
                                        }
                                    }
                                }
                            } else {
                                if ($leave_days > $available_leave) {
                                    $jsonData['dateerror'] = 4;    //Leave not available
                                    $jsonData['status'] = 'error';
                                    $jsonData['max_leave_available'] = $available_leave;
                                } else {
                                    if ($model_master_leave->leave_apply_limit == 'Y') {
                                        if ($model_master_leave->max_leave_apply >= $leave_days) {
                                            $jsonData['days'] = $leave_days;
                                            $jsonData['normal_leave'] = $leave_days;
                                            $jsonData['salary_deduction_leave'] = 0.00;
                                            $jsonData['status'] = 'success';
                                        } else {
                                            $jsonData['dateerror'] = 9;    //Leave apply limit error
                                            $jsonData['status'] = 'error';
                                            $jsonData['max_leave_available'] = $model_master_leave->max_leave_apply;
                                        }
                                    } else {
                                        $jsonData['days'] = $leave_days;
                                        $jsonData['normal_leave'] = $leave_days;
                                        $jsonData['salary_deduction_leave'] = 0.00;
                                        $jsonData['status'] = 'success';
                                    }
                                }
                            }
                            /* if($leave_apply_permission=="N"){
                              if ($leave_days > $available_leave) {
                              $jsonData['dateerror'] = 4;    //Leave not available
                              $jsonData['status'] = 'error';
                              $jsonData['max_leave_available'] =$available_leave;
                              } else {
                              $jsonData['days'] = $leave_days;
                              $jsonData['status'] = 'success';
                              }
                              }else if($leave_apply_permission=="Y"){
                              //                               $jsonData['days'] = $leave_days;
                              //                               $jsonData['status'] = 'success';
                              if ($leave_days > $available_leave) {
                              $jsonData['dateerror'] = 4;    //Leave not available
                              $jsonData['status'] = 'error';
                              $jsonData['max_leave_available'] =$available_leave;
                              } else {
                              $jsonData['days'] = $leave_days;
                              $jsonData['status'] = 'success';
                              }
                              } */
                        } else {
                            $jsonData['dateerror'] = 3;    //Already Leave applied
                            $jsonData['status'] = 'error';
                        }
                    } else {
                        $jsonData['applybefore'] = $model_master_leave->apply_before;
                        $jsonData['dateerror'] = 5;    //Apply before master set value
                        $jsonData['status'] = 'error';
                    }
                } else {
                    $date_array = array();
                    foreach ($model_attendance_present as $key => $value) {
                        $date_array[] = date("d/m/Y", strtotime($value->attendance_date));
                    }
                    $jsonData['attendancedate'] = implode(',', $date_array);
                    $jsonData['dateerror'] = 6;    //Attendance-Present added
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['dateerror'] = 7;    //Record not available
                $jsonData['status'] = 'error';
            }
        } else {
            if ($start_date == '') {
                $jsonData['dateerror'] = 1; //Start Date Null
            } else if ($end_date == '') {
                $jsonData['dateerror'] = 2; //End Date Null
            }
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionApprovalDocument() {
        $id = Yii::app()->request->getParam('id');
        $model_leave_encashment = EmployeeLeaveEncashment::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.encashment_approval_document', array('id' => $id, 'model_leave_encashment' => $model_leave_encashment), true));
        $mPDF1->Output('Leave Enchashment Request.pdf', 'D');
    }

    public function actiondownloadapprovaldocument() {
        $id = Yii::app()->request->getParam('id');
        $document = EmployeeLeaveEncashment::model()->findByPk($id);
        $file = $document->approval_document;
        $path = Yii::getPathOfAlias('webroot') . "/uploads/leaveencashment/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    public function actionLeaveApprovalDocument() {
        $id = Yii::app()->request->getParam('id');
        $model_leave = EmployeeLeaveDetail::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.leave_approval_document', array('id' => $id, 'model_leave' => $model_leave), true));
        $mPDF1->Output('Vacation Form.pdf', 'I');
    }

    public function actionCheckAttendancemarked() {
        $employee_id = Yii::app()->request->getParam('id');
        $start_date = Yii::app()->request->getParam('startdate');
        $end_date = Yii::app()->request->getParam('enddate');
        $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"'));
        if (empty($model_attendance_present)) {
            $jsonData['status'] = 'success';
        } else {
            $date_array = array();
            foreach ($model_attendance_present as $key => $value) {
                $date_array[] = date("d/m/Y", strtotime($value->attendance_date));
            }
            $jsonData['attendancedate'] = implode(',', $date_array);
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveabsentdetails() {
        $employee_id = Yii::app()->request->getParam('id');
        $start_date = Yii::app()->request->getParam('startdate');
        $end_date = Yii::app()->request->getParam('enddate');
        $model_attendance_present = EmployeeAttendance::model()->findAll(array('condition' => 'employee_id="' . $employee_id . '" and attendance_date>="' . $start_date . '" AND attendance_date<="' . $end_date . '" and status="1"'));
        foreach ($model_attendance_present as $key => $value) {
            EmployeeAttendance::model()->updateByPK($value->id, array('status' => 2, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionsetleavestatus() {
        $model = new EmployeeLeaveDetail();
        $dropdownlist .= CHtml::activedropDownList($model, 'leave_status', array(4 => 'Approved', 5 => 'Rejected'), array('options' => array(5 => array('selected' => true)), 'class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Type', 'empty' => 'Select', 'onchange' => 'checkattendancemarked(this.value);'));
        $jsonData['leave_status'] = $dropdownlist;
        echo CJSON::encode($jsonData);
    }

    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch_leave', array());
    }

    public function actionloadmasterleavebranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch_leave_balance', array());
    }

    public function actionindexencashmentapproval() {
        $this->layout = "main";
        $model_module_leave_encashment = HrModules::model()->findByPK(4);
        if ($model_module_leave_encashment->grant_access == 1 && $model_module_leave_encashment->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('encashment_approval_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetPendingEncashment() {
        $model = new EmployeeLeaveEncashment();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $status = '';
        if (isset($_POST['status'])) {
            $status = $_POST['status'];
        }
        $columns = array(
            0 => 't.id',
            1 => 'employee_id',
            2 => 'employee_id',
            3 => 'leave_type_id',
            4 => 'apply_date',
            5 => 'encashable_leave',
            6 => 'encashment_amount',
            6 => 'status',
            8 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_id = Yii::app()->user->id;
        $modelemployee = User::model()->findByPK($user_id);
        $employee_id = $modelemployee->employee_id;
        $pending_encashment = EmployeeLeaveEncashment::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN(' . $pending_encashment . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            if ($show_approve_button == 1) { //For Approval
                $approve_reject = 1;
                $button_string .= '<button class="btn btn-success btn-xs" title="Approve/Reject Leave Encashment" onclick="loadPopupModal(\'hr/leave/encashmentapproval&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Approve/Reject Leave Encashment\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            $apply_date = "";
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row['apply_date']));
            }

            $rowData[] = array($m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], $row['leavetype']['leave_name'], $apply_date, $row['encashable_leave'], $row['encashment_amount'], EmployeeLeaveEncashment::getStatus($row['status']), array('id' => $row['id'], 'approve_reject' => $approve_reject, 'final_level' => $final_level, 'level_no' => $level_no));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionloadencashmentbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_encash_leave', array());
    }

    public function actionPrintLeavedetails() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_leave_details_print']) || Yii::app()->user->authorised_user == 1) {
            $en_id = Yii::app()->request->getParam('id');
            $id = $this->ciphertext($en_id, "d");
            $model = EmployeeLeaveDetail::model()->findbyPK($id);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            if (!empty($model)) {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.leave.employee_leave_details', array('id' => $id, 'model' => $model), true));
            } else {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.error', array(), true));
            }
            $mPDF1->Output('Leave Details.pdf', 'I');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actiondeleteuploadedfile() {
        $id = $_POST['id'];
        $model = EmployeeLeaveDetail::model()->findByPk($id);
        EmployeeLeaveDetail::model()->updateByPK($id, array('medical_certificate' => '', 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
        $path = Yii::getPathOfAlias('webroot') . "/uploads/leavedocument/" . $model->medical_certificate;
        if (unlink($path)) {
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo json_encode($jsonData);
    }

    public function actionSavemultipleleaveRequest() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            $validate = true;
            foreach ($_POST['EmployeeLeaveDetail'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = EmployeeLeaveDetail::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new EmployeeLeaveDetail();
                    $model[$i]->apply_date = date('Y-m-d');
                    $model[$i]->apply_by = Yii::app()->user->id;
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                //Approval Level
                if (isset($items['function_type']) && $items['function_type'] != '') {
                    $model[$i]->function_type = $items['function_type'];
                } else {
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $items['employee_id'] . '" and functionality_id="1"'));
                    if (!empty($model_master_approve_setting)) {
                        $model[$i]->function_type = $model_master_approve_setting->id;
                    }
                }
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $items['employee_id'] . '" and functionality_id="1"'));
                $model[$i]->max_level = $model_master_approve_setting->max_level;
                $model[$i]->employee_id = $items['employee_id'];
                $model[$i]->leave_type = $items['leave_type'];
                $model[$i]->last_approved_level = 0;
                if (isset($items['half_day_leave']) && $items['half_day_leave'] == 'Y') {
                    $model[$i]->half_day_time = $items['half_day_time'];
                } else {
                    $model[$i]->half_day_time = '';
                }
                $model[$i]->half_day_leave = $items['half_day_leave'];
                $model[$i]->no_days = $items['no_days'];
                $model[$i]->leave_reason = $items['leave_reason'];
                $model[$i]->ticket_applied = $items['ticket_applied'];
                $model[$i]->normal_leave = $items['normal_leave'];
                $model[$i]->salary_deduction_leave = $items['salary_deduction_leave'];
                if ($items['leave_start_date'] != '0000-00-00' && $items['leave_start_date'] != '') {
                    $model[$i]->leave_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['leave_start_date'])));
                }
                if ($items['leave_end_date'] != '0000-00-00' && $items['leave_end_date'] != '') {
                    $model[$i]->leave_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['leave_end_date'])));
                }
                if (isset($items['medical_certificate']) && $items['medical_certificate'] != '') {
                    $model[$i]->medical_certificate = $items['medical_certificate'];
                }
                $ticket_applied = $items['ticket_applied'];
                if ($ticket_applied == 1) {
                    $model[$i]->travel_destination = $_POST['travel_destination'];
                    if ($_POST['travel_date'] != '0000-00-00' && $_POST['travel_date'] != '') {
                        $model[$i]->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['travel_date'])));
                    }
                    $model[$i]->return_destination = $_POST['return_destination'];
                    if ($_POST['return_date'] != '0000-00-00' && $_POST['return_date'] != '') {
                        $model[$i]->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['return_date'])));
                    }
                }
                if (isset($_POST['leave_status']) && $_POST['leave_status'] != '') {
                    $model[$i]->leave_status = $_POST['leave_status'];
                } else {
                    $model[$i]->leave_status = 0;
                }
                $validate = $model[$i]->validate() && $validate;
            }
            if ($validate) {
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                        if ($eachModel->leave_status == 1) {
                            //Mail
                            $model_settings = HrGenerelSettings::model()->find();
                            $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="1"'));
                            if (!empty($model_settings) && !empty($model_mail_settings)) {
                                if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                                    Yii::import('application.modules.hr.controllers.MailController');
                                    MailController::sendmail(1, $eachModel->employee_id, $eachModel->id);
                                }
                            }
                        }
                        //Ticket
                        if ($eachModel->ticket_applied == 1) {
                            $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $eachModel->id . '"'));
                            if (!empty($model_tkt)) {
                                $model_tkt_1 = EmployeeTicket::model()->findByPK($model_tkt->id);
                                $model_tkt_1->updated_date_time = date('Y-m-d H:i:s');
                                $model_tkt_1->updated_by = Yii::app()->user->id;
                                $model_tkt_1->save();
                            } else {
                                $model_tkt_1 = new EmployeeTicket();
                                $model_tkt_1->employee_id = $eachModel->employee_id;
                                $model_tkt_1->travel_date = $eachModel->travel_date;
                                $model_tkt_1->travel_destination = $eachModel->travel_destination;
                                $model_tkt_1->return_date = $eachModel->return_date;
                                $model_tkt_1->return_destination = $eachModel->return_destination;
                                $model_tkt_1->leave_id = $eachModel->id;
                                $model_tkt_1->leave_type = $eachModel->leave_type;
                                $model_tkt_1->date_apply = date('Y-m-d');
                                $model_tkt_1->status = 1;
                                $model_tkt_1->year = date('Y', strtotime($eachModel->leave_end_date));
                                $model_tkt_1->created_date_time = date('Y-m-d H:i:s');
                                $model_tkt_1->created_by = Yii::app()->user->id;
                                $model_tkt_1->save();
                            }
                        } else {
                            $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $eachModel->id . '"'));
                            if (!empty($model_tkt)) {
                                EmployeeTicket::model()->deleteByPk($model_tkt->id);
                            }
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSaveemployeeleaveRequest() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            $validate = true;
            foreach ($_POST['EmployeeLeaveDetail'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = EmployeeLeaveDetail::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new EmployeeLeaveDetail();
                    $model[$i]->apply_date = date('Y-m-d');
                    $model[$i]->apply_by = Yii::app()->user->id;
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                //Approval Level
                if (isset($_POST['emp_function_type']) && $_POST['emp_function_type'] != '') {
                    $model[$i]->function_type = $_POST['emp_function_type'];
                } else {
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['leave_employee_id'] . '" and functionality_id="1"'));
                    $model[$i]->function_type = $model_master_approve_setting->id;
                }
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['leave_employee_id'] . '" and functionality_id="1"'));
                $model[$i]->max_level = $model_master_approve_setting->max_level;
                $model[$i]->employee_id = $_POST['leave_employee_id'];
                $model[$i]->leave_type = $_POST['employee_leave_type'];
                $model[$i]->last_approved_level = $_POST['emp_last_approved_level'];
                if (isset($items['half_day_leave']) && $items['half_day_leave'] == 'Y') {
                    $model[$i]->half_day_time = $items['half_day_time'];
                } else {
                    $model[$i]->half_day_time = '';
                }
                $model[$i]->half_day_leave = $items['half_day_leave'];
                $model[$i]->no_days = $items['no_days'];
                $model[$i]->leave_reason = $items['leave_reason'];
                $model[$i]->ticket_applied = $items['ticket_applied'];
                $model[$i]->normal_leave = $items['normal_leave'];
                $model[$i]->salary_deduction_leave = $items['salary_deduction_leave'];
                if ($items['leave_start_date'] != '0000-00-00' && $items['leave_start_date'] != '') {
                    $model[$i]->leave_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['leave_start_date'])));
                }
                if ($items['leave_end_date'] != '0000-00-00' && $items['leave_end_date'] != '') {
                    $model[$i]->leave_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['leave_end_date'])));
                }
                if (isset($items['medical_certificate']) && $items['medical_certificate'] != '') {
                    $model[$i]->medical_certificate = $items['medical_certificate'];
                }
                if (isset($items['leave_approval_document']) && $items['leave_approval_document'] != '') {
                    $model[$i]->leave_approval_document = $items['leave_approval_document'];
                }
                $ticket_applied = $items['ticket_applied'];
                if ($ticket_applied == 1) {
                    $model[$i]->travel_destination = $_POST['travel_destination'];
                    if ($_POST['travel_date'] != '0000-00-00' && $_POST['travel_date'] != '') {
                        $model[$i]->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['travel_date'])));
                    }
                    $model[$i]->return_destination = $_POST['return_destination'];
                    if ($_POST['return_date'] != '0000-00-00' && $_POST['return_date'] != '') {
                        $model[$i]->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['return_date'])));
                    }
                }
                if (isset($_POST['leave_status']) && $_POST['leave_status'] != '') {
                    $model[$i]->leave_status = $_POST['leave_status'];
                    if ($_POST['leave_status'] == 12) {
                        $model[$i]->approved_date = date('Y-m-d');
                        $model_employee = User::model()->findbypk(Yii::app()->user->id);
                        if ($model_employee->employee_id > 0) {
                            $model[$i]->approved_id = $model_employee->employee_id;
                        } else if ($model_employee->hr_connected_employee_id > 0) {
                            $model[$i]->approved_id = $model_employee->hr_connected_employee_id;
                        }
                    }
                } else {
                    $model[$i]->leave_status = 0;
                }
                if (isset($_POST['hr_comment']) && $_POST['hr_comment'] != '') {
                    $model[$i]->hr_comment = $_POST['hr_comment'];
                }
                $validate = $model[$i]->validate() && $validate;
            }
            if ($validate) {
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                        //Ticket
                        if ($eachModel->ticket_applied == 1) {
                            $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $eachModel->id . '"'));
                            if (!empty($model_tkt)) {
                                $model_tkt_1 = EmployeeTicket::model()->findByPK($model_tkt->id);
                                $model_tkt_1->updated_date_time = date('Y-m-d H:i:s');
                                $model_tkt_1->updated_by = Yii::app()->user->id;
                                $model_tkt_1->save();
                            } else {
                                $model_tkt_1 = new EmployeeTicket();
                                $model_tkt_1->employee_id = $eachModel->employee_id;
                                $model_tkt_1->travel_date = $eachModel->travel_date;
                                $model_tkt_1->travel_destination = $eachModel->travel_destination;
                                $model_tkt_1->return_date = $eachModel->return_date;
                                $model_tkt_1->return_destination = $eachModel->return_destination;
                                $model_tkt_1->leave_id = $eachModel->id;
                                $model_tkt_1->leave_type = $eachModel->leave_type;
                                $model_tkt_1->date_apply = date('Y-m-d');
                                $model_tkt_1->status = 1;
                                $model_tkt_1->year = date('Y', strtotime($eachModel->leave_end_date));
                                $model_tkt_1->created_date_time = date('Y-m-d H:i:s');
                                $model_tkt_1->created_by = Yii::app()->user->id;
                                $model_tkt_1->save();
                            }
                        } else {
                            $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $eachModel->id . '"'));
                            if (!empty($model_tkt)) {
                                EmployeeTicket::model()->deleteByPk($model_tkt->id);
                            }
                        }
                        //Leave Updation
                        if ($eachModel->leave_status == 12) {
                            $employee_id = $_POST['leave_employee_id'];
                            $year = date("Y");
                            $model_setting = HrGenerelSettings::model()->find();
                            $current_month = date("m");
                            if ($current_month < $model_setting->leave_carry_forward_month) {
                                $year = $year - 1;
                            }
                            $leave_type = $_POST['employee_leave_type'];
                            $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                            if ($model_master_leave->sub_type_leave == "N") {
                                $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $year . '"'));
                            } else if ($model_master_leave->sub_type_leave == "Y") {
                                $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                            }
                            //$model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_year="' . $year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $leave_type . '"'));
                            if ($model_leave->id > 0) {
                                $available_leave = $model_leave->leave_current_balance;
                                $leave_days = $eachModel->normal_leave;
                                $balance_leave = $available_leave - $leave_days;
                                EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                            } else {
                                $year = $year - 1;
                                $model_master_leave = MasLeave::model()->findbyPk($leave_type);
                                if ($model_master_leave->sub_type_leave == "N") {
                                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $leave_type . '" and leave_year="' . $year . '"'));
                                } else if ($model_master_leave->sub_type_leave == "Y") {
                                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and leave_type = "' . $model_master_leave->parent_id . '" and leave_year="' . $year . '"'));
                                }
                                if (!empty($model_leave)) {
                                    $available_leave = $model_leave->leave_current_balance;
                                    $leave_days = $eachModel->normal_leave;
                                    $balance_leave = $available_leave - $leave_days;
                                    EmployeeLeave::model()->updateByPK($model_leave->id, array('leave_current_balance' => $balance_leave, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                                }
                            }
                            //Salary Deduction for leave
                            //Start Adding Normal Leaves
                            $normal_leaves = $eachModel->normal_leave;
                            if ($model_master_leave->salary_deduction != 'N' && $normal_leaves > 0) {
                                $start_date_1 = $eachModel->leave_start_date;
                                $normal_leaves = ceil($normal_leaves - 1);
                                for ($i = 0; $i <= $normal_leaves; $i++) {
                                    $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                                    $model_salary_deduction->employee_id = $eachModel->employee_id;
                                    $model_salary_deduction->leave_id = $eachModel->id;
                                    $model_salary_deduction->leave_type_id = $eachModel->leave_type;
                                    $model_salary_deduction->leave_date = $start_date_1;
                                    $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction;
                                    $model_salary_deduction->created_by = Yii::app()->user->id;
                                    $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                                    $model_salary_deduction->save();
                                    $start_date_1 = date('Y-m-d', strtotime('+1 day', strtotime($start_date_1)));
                                }
                            }
                            //End Adding Normal Leaves
                            //Starting Adding Negative Leaves
                            $negative_leaves = $eachModel->salary_deduction_leave;
                            if ($model_master_leave->salary_deduction_negative_leave != 'N' && $negative_leaves > 0) {
                                $normal_leaves = ceil($eachModel->normal_leave);
                                $negative_deduction_start = date('Y-m-d', strtotime("+$normal_leaves days", strtotime($eachModel->leave_start_date)));
                                $negative_leaves = ceil($eachModel->salary_deduction_leave - 1);
                                for ($i = 0; $i <= $negative_leaves; $i++) {
                                    $model_salary_deduction = new EmployeeSalaryDeductionLeave();
                                    $model_salary_deduction->employee_id = $eachModel->employee_id;
                                    $model_salary_deduction->leave_id = $eachModel->id;
                                    $model_salary_deduction->leave_type_id = $eachModel->leave_type;
                                    $model_salary_deduction->leave_date = $negative_deduction_start;
                                    $model_salary_deduction->salary_deduction_type = $model_master_leave->salary_deduction_negative_leave;
                                    $model_salary_deduction->created_by = Yii::app()->user->id;
                                    $model_salary_deduction->created_date_time = date('Y-m-d H:i:s');
                                    $model_salary_deduction->save();
                                    $negative_deduction_start = date('Y-m-d', strtotime('+1 day', strtotime($negative_deduction_start)));
                                }
                            }
                            //End Adding Negative Leaves
                            $start_date = $eachModel->leave_start_date;
                            $end_date = $eachModel->leave_end_date;
                            $d1 = strtotime($start_date);
                            $d2 = strtotime($end_date);
                            $datediff = $d2 - $d1;
                            $diff = floor($datediff / (60 * 60 * 24)) + 1;
                            $start = 0;
                            $end = $diff;
                            $date_from = $start_date;
                            for ($i = $start; $i < $end; $i++) {
                                //EMployee 
                                $model_emp = Employee::model()->findByPk($employee_id);
                                $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and status="2"';
                                if ($model_master_leave->exclude_weekend == 'N') {
                                    $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and (status="2" OR status="5")';
                                }
                                if ($model_master_leave->exclude_holiday == 'N') {
                                    $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $employee_id . '" and (status="2" OR status="4" OR status="5")';
                                }
                                $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                                if (!empty($model_attendance)) {
                                    EmployeeAttendance::model()->updateByPK($model_attendance->id, array('status' => 3, 'leave_id' => $eachModel->id, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                                }
                                $date_from = date('Y-m-d', strtotime($date_from . ' +1 day'));
                            }
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionCopyLeavedetails() {
        $model = new EmployeeLeaveDetail();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model_details = $model->findByPk($id);
        }
        $employee_id = $model_details->employee_id;
        $model_master_leave = MasLeave::model()->findbypk($model_details->leave_type);
        $model_setting = HrGenerelSettings::model()->find();
        $current_leave_year = date('Y');
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $current_leave_year = $current_leave_year - 1;
        }
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $model_details->leave_type . '" and employee_id="' . $model_details->employee_id . '" and leave_year="' . $current_leave_year . '"'));
        if ($model_master_leave->sub_type_leave == "Y") {
            $model_leave_count = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $model_master_leave->parent_id . '" and employee_id="' . $model_details->employee_id . '" and leave_year="' . $current_leave_year . '"'));
            $model_leave->leave_current_balance = $model_leave_count->leave_current_balance;
        }
        $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $employee_id . '"'));
        $last_locked_date = "";
        $model_employee = Employee::model()->findbyPk($employee_id);
        if (!empty($model_lock) && $model_lock->salary_processing_id > 0) {
            $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
            $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
        } else {
            $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $model_employee->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
            if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
            }
        }
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="1"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('copy_leave_details', array('model_employee' => $model_employee, 'model_master_approve_setting' => $model_master_approve_setting, 'last_locked_date' => $last_locked_date, 'model' => $model, 'model_details' => $model_details, 'model_leave' => $model_leave, 'model_setting' => $model_setting, 'model_master_leave' => $model_master_leave, 'employee_id' => $employee_id), false, true);
    }

    //added by Dikson on 9/1/2023 to copy leave in ESS Portal
    public function actionCopyLeave() {
        $model = new EmployeeLeaveDetail();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model_details = $model->findByPk($id);
        }
        $employee_id = $model_details->employee_id;
        $model_master_leave = MasLeave::model()->findbypk($model_details->leave_type);
        $model_setting = HrGenerelSettings::model()->find();
        $current_leave_year = date('Y');
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $current_leave_year = $current_leave_year - 1;
        }
        $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $model_details->leave_type . '" and employee_id="' . $model_details->employee_id . '" and leave_year="' . $current_leave_year . '"'));
        if ($model_master_leave->sub_type_leave == "Y") {
            $model_leave_count = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $model_master_leave->parent_id . '" and employee_id="' . $model_details->employee_id . '" and leave_year="' . $current_leave_year . '"'));
            $model_leave->leave_current_balance = $model_leave_count->leave_current_balance;
        }
        $model_lock = SalarySlip::model()->with('processing')->find(array('select' => 'max(t.salary_processing_id) as salary_processing_id', 'condition' => 'processing.payroll_status="2" and employee_id="' . $employee_id . '"'));
        $last_locked_date = "";
        $model_employee = Employee::model()->findbyPk($employee_id);
        if (!empty($model_lock) && ($model_lock->salary_processing_id > 0)) {
            $model_last_locked = SalaryProcessing::model()->findbypk($model_lock->salary_processing_id);
            $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_last_locked->payroll_enddate)));
            $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
        } else {
            $model_lock_branch = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate', 'condition' => 'payroll_status="2" and (payroll_branch_or_sponsor_id="' . $model_employee->branch_or_sponsor_id . '" OR payroll_branch_or_sponsor_id="0")'));
            if ($model_lock_branch->payroll_enddate != '' && $model_lock_branch->payroll_enddate != '0000-00-00') {
                $payroll_enddate = date('Y-m-d', strtotime('+1 days', strtotime($model_lock_branch->payroll_enddate)));
                $last_locked_date = date('d/m/Y', strtotime($payroll_enddate));
            }
        }
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="1"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('copy_leave', array('model_employee' => $model_employee, 'model_master_approve_setting' => $model_master_approve_setting, 'last_locked_date' => $last_locked_date, 'model' => $model, 'model_details' => $model_details, 'model_leave' => $model_leave, 'model_setting' => $model_setting, 'model_master_leave' => $model_master_leave, 'employee_id' => $employee_id), false, true);
    }

    //Save Copy Request
    public function actionSaveleaveCopyRequest() {
        if (isset($_POST['EmployeeLeaveDetail'])) {
            $validate = true;
            foreach ($_POST['EmployeeLeaveDetail'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = EmployeeLeaveDetail::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model[$i] = new EmployeeLeaveDetail();
                    $model[$i]->apply_date = date('Y-m-d');
                    $model[$i]->apply_by = Yii::app()->user->id;
                    $model[$i]->created_by = Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }
                //Approval Level
                if (isset($_POST['emp_function_type']) && $_POST['emp_function_type'] != '') {
                    $model[$i]->function_type = $_POST['emp_function_type'];
                } else {
                    $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['leave_employee_id'] . '" and functionality_id="1"'));
                    $model[$i]->function_type = $model_master_approve_setting->id;
                }
                $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['leave_employee_id'] . '" and functionality_id="1"'));
                $model[$i]->max_level = $model_master_approve_setting->max_level;
                $model[$i]->employee_id = $_POST['leave_employee_id'];
                $model[$i]->leave_type = $_POST['employee_leave_type'];
                $model[$i]->last_approved_level = 0;
                if (isset($items['half_day_leave']) && $items['half_day_leave'] == 'Y') {
                    $model[$i]->half_day_time = $items['half_day_time'];
                } else {
                    $model[$i]->half_day_time = '';
                }
                $model[$i]->half_day_leave = $items['half_day_leave'];
                $model[$i]->no_days = $items['no_days'];
                $model[$i]->leave_reason = $items['leave_reason'];
                $model[$i]->ticket_applied = $items['ticket_applied'];
                $model[$i]->normal_leave = $items['normal_leave'];
                $model[$i]->salary_deduction_leave = $items['salary_deduction_leave'];
                if ($items['leave_start_date'] != '0000-00-00' && $items['leave_start_date'] != '') {
                    $model[$i]->leave_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['leave_start_date'])));
                }
                if ($items['leave_end_date'] != '0000-00-00' && $items['leave_end_date'] != '') {
                    $model[$i]->leave_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['leave_end_date'])));
                }
                if (isset($items['medical_certificate']) && $items['medical_certificate'] != '') {
                    $model[$i]->medical_certificate = $items['medical_certificate'];
                }
                $ticket_applied = $items['ticket_applied'];
                if ($ticket_applied == 1) {
                    $model[$i]->travel_destination = $_POST['travel_destination'];
                    if ($_POST['travel_date'] != '0000-00-00' && $_POST['travel_date'] != '') {
                        $model[$i]->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['travel_date'])));
                    }
                    $model[$i]->return_destination = $_POST['return_destination'];
                    if ($_POST['return_date'] != '0000-00-00' && $_POST['return_date'] != '') {
                        $model[$i]->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['return_date'])));
                    }
                }
                if (isset($_POST['leave_status']) && $_POST['leave_status'] != '') {
                    $model[$i]->leave_status = $_POST['leave_status'];
                } else {
                    $model[$i]->leave_status = 0;
                }
                $validate = $model[$i]->validate() && $validate;
            }
            if ($validate) {
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                        if ($eachModel->leave_status == 1) {
                            //Mail
                            $model_settings = HrGenerelSettings::model()->find();
                            $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="1"'));
                            if (!empty($model_settings) && !empty($model_mail_settings)) {
                                if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                                    Yii::import('application.modules.hr.controllers.MailController');
                                    MailController::sendmail(1, $eachModel->employee_id, $eachModel->id);
                                }
                            }
                        }
                        //Ticket
                        if ($eachModel->ticket_applied == 1) {
                            $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $eachModel->id . '"'));
                            if (!empty($model_tkt)) {
                                $model_tkt_1 = EmployeeTicket::model()->findByPK($model_tkt->id);
                                $model_tkt_1->updated_date_time = date('Y-m-d H:i:s');
                                $model_tkt_1->updated_by = Yii::app()->user->id;
                                $model_tkt_1->save();
                            } else {
                                $model_tkt_1 = new EmployeeTicket();
                                $model_tkt_1->employee_id = $eachModel->employee_id;
                                $model_tkt_1->travel_date = $eachModel->travel_date;
                                $model_tkt_1->travel_destination = $eachModel->travel_destination;
                                $model_tkt_1->return_date = $eachModel->return_date;
                                $model_tkt_1->return_destination = $eachModel->return_destination;
                                $model_tkt_1->leave_id = $eachModel->id;
                                $model_tkt_1->leave_type = $eachModel->leave_type;
                                $model_tkt_1->date_apply = date('Y-m-d');
                                $model_tkt_1->status = 1;
                                $model_tkt_1->year = date('Y', strtotime($eachModel->leave_end_date));
                                $model_tkt_1->created_date_time = date('Y-m-d H:i:s');
                                $model_tkt_1->created_by = Yii::app()->user->id;
                                $model_tkt_1->save();
                            }
                        } else {
                            $model_tkt = EmployeeTicket::model()->find(array('condition' => 'leave_id="' . $eachModel->id . '"'));
                            if (!empty($model_tkt)) {
                                EmployeeTicket::model()->deleteByPk($model_tkt->id);
                            }
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionleavebalance() {
        $model_module_leave = HrModules::model()->findByPK(3);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_empleave_leavebalance_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new EmployeeLeave();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('leave_balance', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeLeaveBalance() {

        $model = new EmployeeLeave();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id',
            2 => 'employeedetail.first_name',
            3 => 'leave_type',
            4 => 'leave_opening',
            5 => 'leave_current_balance',
        );
        // $filterColumn = $columns[$_POST['order'][0]['column']];
        // $filterOrder = $_POST['order'][0]['dir'];
        // $orderBy = $filterColumn . " " . $filterOrder;
        $employee_id = $_POST['employee_id'];
        $leavetype = $_POST['leavetype'];
        $branch_id = $_POST['branch_id'];
        $year = date("Y");
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $year = $year - 1;
        }
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "' AND leave_year='" . $year . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and employeedetail.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if ($employee_id != '') {
            $condition .= " AND t.employee_id= '" . $employee_id . "'";
        }
        if ($leavetype != '') {
            $condition .= " AND t.leave_type= '" . $leavetype . "'";
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        $count = $model->with('employeedetail', 'leavetype')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'leavetype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $rowData[] = array(++$m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $row->leavetype->leave_name, $row->leave_opening, $row->leave_current_balance);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionleaveapprovalHistory() {
        $this->layout = 'main';
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('leave_approval_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetLeaveApprovalHistory() {
        $model = new EmployeeLeaveDetail();
        $leavetype = $_POST['leavetype'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'employee_id',
            2 => 'leave_type',
            3 => 'apply_date',
            4 => 'leave_start_date',
            5 => 'leave_end_date',
            6 => 'leave_status',
            7 => 'no_days',
            8 => 'hr_comment',
            9 => 'line_manager_id',
            10 => 'approved_id',
            11 => 'employeedetail.isActive',
        );
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $model_employee_detail = Employee::model()->findByPk($employee_id);
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $from_date = date('Y-m-d', strtotime($_POST['date_from']));
        $to_date = date('Y-m-d', strtotime($_POST['date_to']));
        $condition = 'employeedetail.isActive="Y" AND (t.line_manager_id="' . $employee_id . '"|| t.approve_level2_id="' . $employee_id . '" || t.approve_level3_id="' . $employee_id . '" || t.approve_level4_id="' . $employee_id . '" ||t.approve_level5_id="' . $employee_id . '" ||t.approved_id="' . $employee_id . '") AND leave_status="12"';
        if ($from_date != '' && $to_date != '') {
            $condition .= ' AND ((leave_start_date<="' . $from_date . '" AND leave_end_date>="' . $to_date . '") OR  (leave_start_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"
                            OR leave_end_date BETWEEN  "' . $from_date . '" AND  "' . $to_date . '"))';
        }
        if (!empty($leavetype)) {
            $condition .= ' AND leave_type="' . $leavetype . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (apply_date LIKE '%" . $searchString . "%' OR employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%')";
        }

        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'apply_date desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            if ($row['apply_date'] != '' && $row['apply_date'] != '0000-00-00') {
                $apply_date = date("d/m/Y", strtotime($row->apply_date));
            }

            if ($row['leave_start_date'] != '' && $row['leave_start_date'] != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($row->leave_start_date));
            }
            if ($row['leave_end_date'] != '' && $row['leave_end_date'] != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($row->leave_end_date));
            }
            $button_string = "";
            if ($row['leave_status'] != 1) {
                $view_button = 1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="View Leave Details" onclick="loadPopupModal(\'hr/leave/viewleavedetails&id=' . $row['id'] . '\',\'Leave Details\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            $employee_name = $this->ciphertext($row->employeedetail->first_name, "d") . " " . $this->ciphertext($row->employeedetail->last_name, "d");
            $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $row->leave_type . '" and employee_id="' . $row->employee_id . '" and leave_year="' . date('Y') . '"'));
            $rowData[] = array(++$m, $employee_name, $row->leavetype->leave_name, $apply_date, $leave_start_date, $leave_end_date, $row->no_days, $model_leave->leave_current_balance, EmployeeLeaveDetail::getLeaveStatus($row->leave_status), $row['leave_reason'], array('id' => $row['id'], 'view_button)' => $view_button));
        }
        $data['data'] = $rowData;
        $data['condition'] = $condition;
        $data['user'] = Yii::app()->user->id;
        echo json_encode($data);
    }

    function getserviceyear($joining_date, $payroll_start) {
        $date1 = new DateTime($joining_date);
        $date2 = new DateTime($payroll_start);
        $dd = date_diff($date1, $date2);
        $service_yr = $dd->y;
        return $service_yr;
    }

    public function actionapprovalhierarchy() {
        $employee_id = Yii::app()->request->getparam("employee_id");
        $function_type = Yii::app()->request->getparam("function_type");
        $model_level = HrEmployeeApproveLevel::model()->with('employeedetail')->find(array("condition" => 'employee_id ="' . $employee_id . '" AND functionality_id="' . $function_type . '"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('approve_hierarchy', array('model_level' => $model_level, 'employee_id' => $employee_id));
    }

    public function actionLeaveindex() {
        $this->layout = "main";
        $model = new EmployeeLeave();
        $model_module_leave = HrModules::model()->findByPK(3);
        if ($model_module_leave->grant_access == 1 && $model_module_leave->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('leave_index', array('model' => $model));
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetMasterLeave() {
        $model = new MasLeave();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'leave_name',
            2 => 'leave_type',
            3 => 'leave_days',
            4 => 'leave_days',
            5 => 'isActive'
        );
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $model_master_employee = Employee::model()->findByPk($employee_id);
        $gender = $model_master_employee->gender;
        $branch_id = $model_master_employee->branch_or_sponsor_id;

        $model_general_setting = HrGenerelSettings::model()->find();
        $current_year = date("Y");
        $current_month = date("m");
        $year = ($current_month < $model_general_setting->leave_carry_forward_month) ? $current_year - 1 : $current_year;

        $service_days = 0;
        if ($model_master_employee->date_join && $model_master_employee->date_join != '0000-00-00') {
            $join_date = strtotime($model_master_employee->date_join);
            $today = strtotime(date('Y-m-d'));
            $service_days = floor(($today - $join_date) / (60 * 60 * 24)) + 1;
        }

        $searchString = isset($_POST['search']['value']) ? $_POST['search']['value'] : "";
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        $rowData = array();
        $m = $offset;

        $leave_condition = 'isActive="Y" and sub_type_leave="N" and branch_id="' . $branch_id . '" 
                            AND (visible_portal="Y" OR visible_portal="E") 
                            AND (employee_can_apply="0" OR employee_can_apply<="' . $service_days . '")';

        if ($searchString != "") {
            $leave_condition .= " AND (leave_name LIKE '%" . $searchString . "%')";
        }

        $master_leaves = MasLeave::model()->findAll(array('condition' => $leave_condition, 'order' => $filterColumn . ' ' . $filterOrder, 'limit' => $limit, 'offset' => $offset));
        $count = MasLeave::model()->count(array('condition' => $leave_condition));

        foreach ($master_leaves as $row) {
            if ($row->gender == 0 || $row->gender == $gender) {
                $sub_leaves = MasLeave::model()->findAll(array(
                    'condition' => 'isActive="Y" and (parent_id="' . $row->id . '" OR id="' . $row->id . '") and branch_id="' . $branch_id . '" AND (visible_portal="Y" OR employee_can_apply="E")',
                    'order' => 'leave_name asc'
                ));

                foreach ($sub_leaves as $sub_row) {
                    $target_leave_id = ($sub_row->sub_type_leave == 'Y') ? $sub_row->parent_id : $sub_row->id;

                    $leave_taken = $leave_current_balance = $encashable_leave = 0.00;
                    $message = "";

                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $target_leave_id . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));

                    if (!empty($model_leave)) {
                        $leave_current_balance = $model_leave->leave_current_balance;
                    }

                    $balance_leave = ($leave_current_balance > 0) ? $leave_current_balance : 0;
                    $model_master_leave = MasLeave::model()->findByPk($target_leave_id);

                    if ($model_master_leave->additional_leave > 0 && $leave_current_balance >= 0) {
                        $balance_leave += $model_master_leave->additional_leave;
                        $leave_current_balance += $model_master_leave->additional_leave;
                    }

                    $model_leave_details = EmployeeLeaveDetail::model()->find(array('select' => 'sum(normal_leave) as normal_leave', 'condition' => 'YEAR(leave_start_date)="' . $current_year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $target_leave_id . '" and leave_status="12"'));
                    if ($model_leave_details->normal_leave > 0) {
                        $leave_taken = $model_leave_details->normal_leave;
                    }

                    $model_leave_ledger = EmployeeLeaveLedger::model()->find(array('select' => 'sum(leave_reduce) as leave_reduce', 'condition' => 'leave_type="' . $target_leave_id . '" and employee_id="' . $employee_id . '" and YEAR(created_date_time)="' . $current_year . '"'));
                    if ($model_leave_ledger->leave_reduce > 0) {
                        $leave_taken += $model_leave_ledger->leave_reduce;
                    }

                    $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $sub_row->id . '" OR leavetype.parent_id="' . $sub_row->id . '") and (leave_status IN (0,1,2,4,6,8,10))'));
                    $model_leave_encashable = EmployeeLeaveEncashment::model()->findAll(array('condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $sub_row->id . '" and employee_id="' . $employee_id . '"'));
                    $model_leave_encashable_approved = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="12" OR status="14") and leave_type_id="' . $sub_row->id . '" and encashment_year="' . $year . '" and employee_id="' . $employee_id . '"'));
                    //Deducting Applied Leave Details
                    $pending_leave = 0;
                    $model_leave_applied_deduct = EmployeeLeaveDetail::model()->with('leavetype')->find(array('select' => 'sum(no_days) as no_days', 'condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $sub_row->id . '" OR leavetype.parent_id="' . $sub_row->id . '") and (leave_status IN (0,1,2,4,6,8,10))'));
                    $model_leave_encashable_deduct = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => '(status="1" OR status="2" OR status="4" OR status="6" OR status="8" OR status="10") and leave_type_id="' . $sub_row->id . '" and employee_id="' . $employee_id . '"'));
                    if (!empty($model_leave_applied_deduct) && $model_leave_applied_deduct->no_days > 0) {
                        $pending_leave += $model_leave_applied_deduct->no_days;
                    }
                    if (!empty($model_leave_encashable_deduct) && $model_leave_encashable_deduct->encashable_leave > 0) {
                        $pending_leave += $model_leave_encashable_deduct->encashable_leave;
                    }
                    if ($pending_leave > 0) {
                        $balance_leave -= $pending_leave;
                    }
                    if ($model_leave_encashable_approved->encashable_leave > 0) {
                        $encashable_leave = $model_leave_encashable_approved->encashable_leave;
                        $message = "<br/>Leave Encashed=" . $encashable_leave;
                    }

                    $opening_leave_value = number_format($model_leave->leave_opening ?? 0.00, 2);
                    $current_leave_value = number_format($leave_current_balance, 2);
                    if ($sub_row->leave_count_employee_panel == 'N') {
                        $opening_leave_value = number_format(0.00, 2);
                        $current_leave_value = number_format(0.00, 2);
                    }

                    $apply_leave = $apply_encash = $apply_status = $leave_history = 0;
                    if ($balance_leave > 0) {
                        $apply_leave = 1;
                    }
                    if (!empty($model_leave_applied)) {
                        $apply_status = 1;
                        $leave_history = 1;
                    }

                    if ($model_master_employee->branch_sponsor->leave_encashment_provided == 'Y') {
                        if ($sub_row->encashable == "Y" && $balance_leave > 0 && empty($model_leave_applied) && empty($model_leave_encashable)) {
                            $apply_encash = 1;
                        } else if (!empty($model_leave_encashable)) {
                            $apply_status = 1;
                        }
                    }
                    $rowData[] = array(++$m, $sub_row->leave_name, $opening_leave_value, number_format($leave_taken, 2) . ' ' . $message, $current_leave_value, array('id' => $sub_row->id, 'eid' => $employee_id, 'balance_leave' => $balance_leave, 'apply_status' => $apply_status, 'apply_leave' => $apply_leave, 'apply_encash' => $apply_encash, 'leave_history' => $leave_history));
                }
            }
        }

        echo json_encode(array(
            'draw' => $draw,
            'recordsTotal' => count($rowData),
            'recordsFiltered' => count($rowData),
            'data' => $rowData
        ));
    }

    public function actionGetMasterLeavesub() {
        $model = new MasLeave();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 'leave_name',
            2 => 'leave_type',
            3 => 'leave_days',
            4 => 'leave_days',
            5 => 'isActive'
        );
        $model_employee = User::model()->findByPk(Yii::app()->user->id);
        $employee_id = $model_employee->employee_id;
        $model_master_employee = Employee::model()->findByPk($employee_id);
        $gender = $model_master_employee->gender;
        $branch_id = $model_master_employee->branch_or_sponsor_id;

        $model_general_setting = HrGenerelSettings::model()->find();
        $current_year = date("Y");
        $current_month = date("m");
        $year = ($current_month < $model_general_setting->leave_carry_forward_month) ? $current_year - 1 : $current_year;

        $service_days = 0;
        if ($model_master_employee->date_join && $model_master_employee->date_join != '0000-00-00') {
            $join_date = strtotime($model_master_employee->date_join);
            $today = strtotime(date('Y-m-d'));
            $service_days = floor(($today - $join_date) / (60 * 60 * 24)) + 1;
        }

        $draw = $_POST['draw'];
        $searchString = isset($_POST['search']['value']) ? $_POST['search']['value'] : "";
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];

        $rowData = array();
        $m = $offset;

        $leave_condition = 'isActive="Y" and sub_type_leave="N" and branch_id="' . $branch_id . '" 
                            AND (visible_portal="Y" OR visible_portal="E") 
                            AND (employee_can_apply="0" OR employee_can_apply<="' . $service_days . '")';

        if ($searchString != "") {
            $leave_condition .= " AND (leave_name LIKE '%" . $searchString . "%')";
        }

        $master_leaves = MasLeave::model()->findAll(array('condition' => $leave_condition, 'order' => $filterColumn . ' ' . $filterOrder, 'limit' => $limit, 'offset' => $offset));
        $count = MasLeave::model()->count(array('condition' => $leave_condition));

        foreach ($master_leaves as $row) {
            if ($row->gender == 0 || $row->gender == $gender) {
                $sub_leaves = MasLeave::model()->findAll(array(
                    'condition' => 'isActive="Y" and (parent_id="' . $row->id . '" OR id="' . $row->id . '") and branch_id="' . $branch_id . '" AND (visible_portal="Y" OR employee_can_apply="E")',
                    'order' => 'leave_name asc'
                ));

                foreach ($sub_leaves as $sub_row) {
                    $leave_taken = $leave_current_balance = $encashable_leave = 0.00;
                    $message = "";

                    $model_leave = EmployeeLeave::model()->find(array('condition' => 'leave_type="' . $sub_row->id . '" and employee_id="' . $employee_id . '" and leave_year="' . $year . '"'));

                    if (!empty($model_leave)) {
                        $leave_current_balance = $model_leave->leave_current_balance;
                    }

                    $balance_leave = ($leave_current_balance > 0) ? $leave_current_balance : 0;
                    $model_master_leave = MasLeave::model()->findByPk($sub_row->id);

                    if ($model_master_leave->additional_leave > 0 && $leave_current_balance >= 0) {
                        $balance_leave += $model_master_leave->additional_leave;
                        $leave_current_balance += $model_master_leave->additional_leave;
                    }

                    $model_leave_details = EmployeeLeaveDetail::model()->find(array('select' => 'sum(normal_leave) as normal_leave', 'condition' => 'YEAR(leave_start_date)="' . $current_year . '" AND employee_id="' . $employee_id . '" AND leave_type="' . $sub_row->id . '" and leave_status="12"'));
                    if ($model_leave_details->normal_leave > 0) {
                        $leave_taken = $model_leave_details->normal_leave;
                    }

                    $model_leave_ledger = EmployeeLeaveLedger::model()->find(array('select' => 'sum(leave_reduce) as leave_reduce', 'condition' => 'leave_type="' . $sub_row->id . '" and employee_id="' . $employee_id . '" and YEAR(created_date_time)="' . $current_year . '"'));
                    if ($model_leave_ledger->leave_reduce > 0) {
                        $leave_taken += $model_leave_ledger->leave_reduce;
                    }

                    $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->find(array('condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $sub_row->id . '" OR leavetype.parent_id="' . $sub_row->id . '") and (leave_status IN (0,1,2,4,6,8,10))'));
                    $model_leave_encashable = EmployeeLeaveEncashment::model()->findAll(array('condition' => 'status="1" and leave_type_id="' . $sub_row->id . '" and employee_id="' . $employee_id . '"'));
                    $model_leave_encashable_approved = EmployeeLeaveEncashment::model()->find(array('select' => 'sum(encashable_leave) as encashable_leave', 'condition' => 'status="2" and leave_type_id="' . $sub_row->id . '" and encashment_year="' . $year . '" and employee_id="' . $employee_id . '"'));

                    if ($model_leave_encashable_approved->encashable_leave > 0) {
                        $encashable_leave = $model_leave_encashable_approved->encashable_leave;
                        $message = "<br/>Leave Encashed=" . $encashable_leave;
                    }

                    $opening_leave_value = number_format($model_leave->leave_opening ?? 0.00, 2);
                    $current_leave_value = number_format($leave_current_balance, 2);
                    if ($sub_row->leave_count_employee_panel == 'N') {
                        $opening_leave_value = number_format(0.00, 2);
                        $current_leave_value = number_format(0.00, 2);
                    }

//                    $button_string = "";
                    $apply_leave = $apply_encash = $apply_status = 0;
                    if ($balance_leave > 0 && empty($model_leave_applied) && empty($model_leave_encashable)) {
                        $apply_leave = 1;
//                        $button_string .= '<button class="btn btn-success btn-xs" title="Apply Leave" onclick="loadPopupModal(\'hr/leave/applyleave&id=' . $sub_row->id . '&eid=' . $employee_id . '&leave=' . $balance_leave . '\',\'Apply Leave\',\'xl\')"><i class="fa fa-external-link-square"></i></button>&nbsp;&nbsp;';
                    } else if (!empty($model_leave_applied)) {
//                        $button_string .= 'Leave Applied';
                        $apply_status = 1;
                    }

                    if ($model_master_employee->branch_sponsor->leave_encashment_provided == 'Y') {
                        if ($sub_row->encashable == "Y" && $balance_leave > 0 && empty($model_leave_applied) && empty($model_leave_encashable)) {
                            $apply_encash = 1;
//                            $button_string .= '<button class="btn btn-warning btn-xs" title="Apply Leave Encashment" onclick="loadPopupModal(\'hr/leave/applyleaveencashment&id=' . $sub_row->id . '&eid=' . $employee_id . '&leave=' . $balance_leave . '\',\'Apply Leave Encashment\',\'xl\')"><i class="fa fa-money"></i></button>';
                        } else if (!empty($model_leave_encashable)) {
//                            $button_string .= 'Leave Encashment Applied';
                            $apply_status = 1;
                        }
                    }
                    $rowData[] = array(++$m, $sub_row->leave_name, $opening_leave_value, number_format($leave_taken, 2) . ' ' . $message, $current_leave_value, array('id' => $sub_row->id, 'eid' => $employee_id, 'balance_leave' => $balance_leave, 'apply_status' => $apply_status, 'apply_leave' => $apply_leave, 'apply_encash' => $apply_encash));
                }
            }
        }

        echo json_encode(array(
            'draw' => $draw,
            'recordsTotal' => count($rowData),
            'recordsFiltered' => count($rowData),
            'data' => $rowData
        ));
    }

    public function actionAppliedLeaveHistory() {
        $id = Yii::app()->request->getparam("id");
        $employee_id = Yii::app()->request->getparam("eid");
        $model_leave_applied = EmployeeLeaveDetail::model()->with('leavetype')->findAll(array('condition' => 't.employee_id="' . $employee_id . '" AND (t.leave_type="' . $id . '" OR leavetype.parent_id="' . $id . '") and (leave_status="0" OR leave_status="1" OR leave_status="2" OR leave_status="4" OR leave_status="6" OR leave_status="8" OR leave_status="10")'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('appled_leave_history', array('model_applied_leaves' => $model_leave_applied, 'employee_id' => $employee_id));
    }
}
