<?php

class InprocessController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('changestatus', 'CompanyInprocessdocument', 'GetStageDate', 'SaveInprocessDocument', 'GetStageDate',
                    'employeechangestatus', 'Emplyeeinprocessdocument', 'saveEmployeeInprocess','GetDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionChangeStatus() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = CompanyDocument::model()->findByPk($id);
            $model_renewal = MasExpiryStatus::model()->findAll(array('condition' => 'document="' . $model->document_id . '"'));
            if(!empty($model_renewal)){
                CompanyDocument::model()->updateByPK($id, array('status' => 1, 'inprocess_date' => date('Y-m-d')));
                foreach ($model_renewal as $value) {
                    $model_inprocess = new CompanyInprocessDocument();
                    $model_inprocess->document_id = $model->document_id;
                    $model_inprocess->stage_id = $value->id;
                    $model_inprocess->save(false);
                }
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'expiry';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionCompanyInprocessdocument() {
        $id = Yii::app()->request->getparam('id');
        $model = CompanyDocument::model()->findbyPK($id);
        $model_inprocess = CompanyInprocessDocument::model()->find(array('condition' => 'document_id="' . $model->document_id.'" and completed="N"'));
        if (empty($model_inprocess)) {
            $model_inprocess = new CompanyInprocessDocument();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('company_inprocess_document_form', array('id' => $id, 'model' => $model, 'model_inprocess' => $model_inprocess), false, true);
    }
    public function actionGetStageDate() {
        $doc_id = Yii::app()->request->getparam('doc_id');
        $stage_id = Yii::app()->request->getparam('stage_id');
        $model_inprocess = CompanyInprocessDocument::model()->find(array('condition' => 'stage_id="'.$stage_id .'" and document_id="'.$doc_id .'" and completed="N"'));
        $start_date=$end_date='';
        if($model_inprocess->start_date!='' && $model_inprocess->start_date!='0000-00-00'){
            $start_date=date("d/m/Y",strtotime($model_inprocess->start_date));
        }
        if($model_inprocess->end_date!='' && $model_inprocess->end_date!='0000-00-00'){
            $end_date=date("d/m/Y",strtotime($model_inprocess->end_date));
        }
        $jsonData['start_date'] = $start_date;
        $jsonData['end_date'] = $end_date;
        $jsonData['id'] = $model_inprocess->id;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionSaveInprocessDocument() {
        $model = new CompanyInprocessDocument();
        if (isset($_POST['CompanyInprocessDocument'])) {
            if ((int) @$_POST['CompanyInprocessDocument']['id'] > 0) {
                $model->id = (int) $_POST['CompanyInprocessDocument']['id'];
                $model = $model->findByPK($model->id);
            }
            $model->stage_id = $model->stage_id;
            if (isset($_POST['CompanyInprocessDocument']['start_date']) && ($_POST['CompanyInprocessDocument']['start_date'] != '00/00/0000') && $_POST['CompanyInprocessDocument']['start_date'] != '') {
               $model->start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['CompanyInprocessDocument']['start_date'])));
            }
            if (isset($_POST['CompanyInprocessDocument']['end_date']) && ($_POST['CompanyInprocessDocument']['end_date'] != '00/00/0000') && $_POST['CompanyInprocessDocument']['end_date'] != '') {
                $model->end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['CompanyInprocessDocument']['end_date'])));
                $model->completed = 'Y';
            }

            if ($model->validate()) {
                $model->save();
                $processing_id = $model->pro_stage->processing_order;
                $model_expiry = MasExpiryStatus::model()->findAll(array('condition' => 'processing_order<"' . $processing_id . '" and document="' . $_POST['document_id'] . '"'));
                foreach ($model_expiry as $key => $value) {
                    Yii::app()->db
                            ->createCommand("UPDATE erp_hr_company_inprocess_document SET completed = 'Y' WHERE document_id='" . $_POST['CompanyInprocessDocument']['document_id'] . "' AND  stage_id='" . $value->id . "'")
                            ->execute();
                }
                $model_doc = CompanyInprocessDocument::model()->findAll(array('condition' => 'completed="N" and document_id="' . $_POST['CompanyInprocessDocument']['document_id'] . '"'));
                if (empty($model_doc)) {
                    CompanyDocument::model()->updateByPK($_POST['master_doc_id'], array('status' => 2));
                    $jsonData['process'] = 'completed';
                    $jsonData['did'] = $_POST['CompanyInprocessDocument']['document_id'];
                }
                $model->refresh();
                $jsonData['model'] = $model;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionemployeechangestatus() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = EmployeeDocuments::model()->findByPk($id);
            $model_renewal = MasExpiryStatus::model()->findAll(array('condition' => 'document="' . $model->document_id . '"'));
            if(!empty($model_renewal)){
                EmployeeDocuments::model()->updateByPK($id, array('status' => 1, 'inprocess_date' => date('Y-m-d')));
                foreach ($model_renewal as $value) {
                    $model_inprocess = new HrEmployeeInprocessDocument();
                    $model_inprocess->document_id = $model->document_id;
                    $model_inprocess->employee_id = $model->employee_id;
                    $model_inprocess->stage_id = $value->id;
                    $model_inprocess->save(false);
                }
                $jsonData['status'] = 'success';
            }else{
                $jsonData['status'] = 'expiry';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionEmplyeeinprocessdocument() {
        $id = Yii::app()->request->getparam('id');
        $model = EmployeeDocuments::model()->findbyPK($id);
        $model_inprocess = HrEmployeeInprocessDocument::model()->find(array('condition' => 'document_id="' . $model->document_id . '" and completed="N"'));
        if (empty($model_inprocess)) {
            $model_inprocess = new HrEmployeeInprocessDocument();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('employee_inprocess_document_form', array('id' => $id, 'model' => $model, 'model_inprocess' => $model_inprocess), false, true);
    }

    public function actionsaveEmployeeInprocess() {
        if (isset($_POST['EmployeeDocuments'])) {
            $model = new HrEmployeeInprocessDocument();
            if (!empty($_POST['HrEmployeeInprocessDocument']['id'])) {
                $model = HrEmployeeInprocessDocument::model()->findByPK($_POST['HrEmployeeInprocessDocument']['id']);
            }
            if (isset($_POST['HrEmployeeInprocessDocument']['start_date']) && ($_POST['HrEmployeeInprocessDocument']['start_date'] != '00/00/0000') && $_POST['HrEmployeeInprocessDocument']['start_date'] != '') {
                $model->start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrEmployeeInprocessDocument']['start_date'])));
            }
            if (isset($_POST['HrEmployeeInprocessDocument']['end_date']) && ($_POST['HrEmployeeInprocessDocument']['end_date'] != '00/00/0000') && $_POST['HrEmployeeInprocessDocument']['end_date'] != '') {
                $model->end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrEmployeeInprocessDocument']['end_date'])));
                $model->completed = 'Y';
            }
            if ($model->save()) {
                $processing_id = $model->pro_stage->processing_order;
                $model_expiry = MasExpiryStatus::model()->findAll(array('condition' => 'processing_order<"' . $processing_id . '" and document="' . $_POST['doc_id'] . '"'));
                foreach ($model_expiry as $key => $value) {
                    Yii::app()->db
                            ->createCommand("UPDATE erp_hr_employee_inprocess_document SET completed = 'Y' WHERE document_id='".$_POST['doc_id']."' AND  stage_id='" . $value->id . "' AND  employee_id='" .$_POST['emp_id']. "'")
                            ->execute();
                }
                $model_doc = HrEmployeeInprocessDocument::model()->findAll(array('condition' => 'completed="N" and document_id="' . $model->document_id . '" AND  employee_id="'.$_POST['emp_id'].'"'));
                if (empty($model_doc)) {
                    EmployeeDocuments::model()->updateByPK($_POST['master_id'], array('status' => 2));
                    $jsonData['process'] = 'completed';
                    $jsonData['did'] = $_POST['doc_id'];
                }
                $model->refresh();
                $jsonData['model'] = $model;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetDetails() {
        $doc_id = Yii::app()->request->getparam('doc_id');
        $emp_id = Yii::app()->request->getparam('emp_id');
        $stage_id = Yii::app()->request->getparam('stage_id');
        $model_inprocess = HrEmployeeInprocessDocument::model()->find(array('condition' => 'stage_id="'.$stage_id .'" and employee_id="'.$emp_id .'" and document_id="'.$doc_id .'" and completed="N"'));
        $start_date=$end_date='';
        if($model_inprocess->start_date!='' && $model_inprocess->start_date!='0000-00-00'){
            $start_date=date("d/m/Y",strtotime($model_inprocess->start_date));
        }
        if($model_inprocess->end_date!='' && $model_inprocess->end_date!='0000-00-00'){
            $end_date=date("d/m/Y",strtotime($model_inprocess->end_date));
        }
        $jsonData['start_date'] = $start_date;
        $jsonData['end_date'] = $end_date;
        $jsonData['id'] = $model_inprocess->id;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

}
