<?php

class HrtrainingController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetTrainingDetails','Create','SaveDetails','deletetrainingdetail','deletedetail','sendtrainingmail',
                    'gettrainingmodule','Trainingmatrix','downloaddocument'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $model_module_training = HrModules::model()->findByPK(15);
        if ($model_module_training->grant_access == 1 && $model_module_training->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_training_details']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetTrainingDetails() {
        $model = new HrTraining();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'coursedetail.course_name',
            2 => 'subcoursedetail.training_course',
            3 => 'provider_name',
            4 => 'course_date',
            5 => 'fee_per_head',
            6 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .=" and (coursedetail.course_name LIKE '%" . $searchString . "%' OR subcoursedetail.training_course LIKE '%" . $searchString . "%' OR provider_name LIKE '%" . $searchString . "%')";
        }
        /*if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }*/
        $count = $model->with('coursedetail','subcoursedetail')->count(array('condition' => $condition));
        $model = $model->with('coursedetail','subcoursedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_training =$delete_training=$sendmail_training=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_training_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/hrtraining/create&id=' . $row['id'] . '\',\'Edit Training Detail \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $edit_training =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_training_delete'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletetrainingdetail(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
                $delete_training=1;
                
            }
            //edit amd mail have  same permission
            $get_mail_status=HrTraining::getmailstatus($row['id']);
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_training_send'])  || Yii::app()->user->authorised_user == 1) && $get_mail_status==1) {
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-primary btn-xs" onclick="sendtrainingmail(' . $row['id'] . ')" title="Send mail to staff regarding training"><i class="fa fa-mail-forward"></i></a>&nbsp;';
                $sendmail_training=1;
            }
            /*if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_training_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<a href="?r=hr/hrtraining/downloaddocument&from=1" title="Training effectiveness assesment - Employee" target="_blank"><button class="btn btn-primary btn-xs" title="Training effectiveness assesment - Employee" ><i class="fa fa-download"></i></button></a>&nbsp;';                    
                $button_string.= '<a href="?r=hr/hrtraining/downloaddocument&from=2" title="Training effectiveness assesment - Manager" target="_blank"><button class="btn btn-primary btn-xs" title="Training effectiveness assesment - Manager" ><i class="fa fa-download"></i></button></a>&nbsp;';                    
                $button_string.= '<a href="?r=hr/hrtraining/downloaddocument&from=3" title="Training Feedback" target="_blank"><button class="btn btn-primary btn-xs" title="Training Feedback" ><i class="fa fa-download"></i></button></a>&nbsp;';                    
            }*/
            $course_date='';
            if ($row['course_date'] != '0000-00-00') {
                $course_date = date("d/m/Y", strtotime($row['course_date']));
            }
            $rowData[] = array($m, $row['coursedetail']['course_name'], $row['subcoursedetail']['training_course'], $row['provider_name'],$course_date, $row['fee_per_head'],array('id'=>$row['id'],'edit_training'=>$edit_training,'delete_training' =>$delete_training,'sendmail_training'=>$sendmail_training));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
  
    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrTraining();
        $model_details=array(new HrTrainingDetails()); 
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details= HrTrainingDetails::model()->findAll(array('condition' => 'training_id="'. $id.'"'));
            if(empty($model_details)){
                $model_details=array(new HrTrainingDetails()); 
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_details' => $model_details), false, true);
    }
    public function actionSaveDetails() {
        $model = new HrTraining();
        if (isset($_POST['HrTraining'])) {
            if ($_POST['HrTraining']['id'] > 0) {
                $id = (int) $_POST['HrTraining']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['HrTraining'];
            $model->location = $_POST['HrTraining']['location'];
            if ($_POST['HrTraining']['course_date'] != '' && $_POST['HrTraining']['course_date'] != '0000-00-00') {
                $model->course_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['HrTraining']['course_date'])));
            }
            $valid=$model->validate();
            //Adding Training Data
            if ((isset($_POST['HrTrainingDetails'])) && ($_POST['HrTrainingDetails'][0]['employee_id']!='')){
                $i=0;
                foreach ($_POST['HrTrainingDetails'] as $m => $items) {
                    if($items['employee_id']!=''){
                        if($items['id']>0){
                            $model_details[$i] = HrTrainingDetails::model()->findByPK($items['id']); 
                            $model_details[$i]->updated_by= Yii::app()->user->id;
                            $model_details[$i]->updated_date_time = date('Y-m-d h:i:s');
                        }else{
                            $model_details[$i] = new HrTrainingDetails(); 
                            $model_details[$i]->created_by= Yii::app()->user->id;
                            $model_details[$i]->created_date_time = date('Y-m-d h:i:s');
                        }   
                        $model_details[$i]->employee_id = $items['employee_id'];
                        $model_details[$i]->days_attended = $items['days_attended'];
                        $model_details[$i]->training_status = $items['training_status'];
                        $valid=$model_details[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }else{
                $valid=false;
            }
            //End Training Data
            if ($valid) {
                $model->save();
                //Save Details
                if (!empty($model_details)) {
                    foreach ($model_details as $eachModel) {
                        $eachModel->training_id = $model->id;
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_details) && $model_details[0]->employee_id!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                }else{
                   $error2[]='Please add atleast one employee in this course';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }    
    public function actiondeletetrainingdetail() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model =HrTraining::model()->findByPk($id);
            if($model->id){
                HrTrainingDetails::model()->deleteAll('training_id=:refer_id', array(':refer_id' => $model->id));
                $model_details_exist= HrTrainingDetails::model()->findAll(array('condition' => 'training_id="'. $model->id.'"'));
                if(empty($model_details_exist)){
                    HrTraining::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                }else{
                    $jsonData['status'] = 'error';
                }
            }else{
                $jsonData['status'] = 'error';
            }
        } else {
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiondeletedetail(){
        $id = $_POST['id'];
        if($id>0){
            HrTrainingDetails::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    
    public function actionsendtrainingmail() {
        $id = (int) Yii::app()->request->getParam('id');
        $subject="Notification Regarding Training Program";
        //Mail Setting
        $model=HrTraining::model()->findByPK($id);
        $course_date='';
        if ($model->course_date != '0000-00-00' && $model->course_date != '') {
            $course_date = date("d/m/Y", strtotime($model->course_date));
        }
        $content='It is to announce that we would be conducting a training session on the course '.$model->coursedetail->course_name.'.The training programme is scheduled on '.$course_date.' and it is compulsory for everyone to be present.';
        $view='notification';
        //start Mail Content
        $mailContent= '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;max-width: 500px;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <div>Dear Sir/Madam,</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Space Grotesk,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Sub: Notification Regarding Interview Schedule</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: justify;font-family: Space Grotesk,sans-serif;font-size: 13px">'                          
                            .$content.'<br>
                            As suggested by the management, everyone is requested to join this training programme seriously and utilize the time during the training sessions efficiently.I assure you that this training would be very helpful to you and to our organisation is near future.
                            <br>
                            I will appreciate if you gain maximum out of these sessions. You are requested not to take any leaves during this one month of training tenure. For any kind of information regarding the training, contact Training Department.
                            <br>
                            <br>
                            Sincerely,
                            <br>
                            <br>
                            Yours sincerely,
                            <br>
                            <br>
                            Training Department
                        </td>
                    </tr>
                </tbody>
            </table>';
        ////End Mail Content
        //Start Notifying Employee     
        $notifyingemployee=HrTraining::getstaff($id);
        $notifying_id=implode(',', $notifyingemployee);   
        if(!empty($notifyingemployee)){  
            $sent_mail_id=array();
            foreach ($notifyingemployee as $emp_id) {
               $model_mail=Employee::model()->findByPK($emp_id);
               if (filter_var($model_mail->email, FILTER_VALIDATE_EMAIL)) { 
                   $sent_mail_id[]=$model_mail->email;
               }
            }
            if(count($sent_mail_id)>0){
                $model_general_setting = HrGenerelSettings::model()->find();
                $from=$model_general_setting->from_mail_id;
                $from_name=$model_general_setting->from_mail_name;
                $toRecipient = ['email' => array_shift($sent_mail_id)]; 
                $ccRecipients = [];
                if(!empty($sent_mail_id)){
                    foreach ($sent_mail_id as $email_id) {
                        $ccRecipients[] = ['email' => $email_id];
                    }
                }
                $mail_body = Yii::app()->controller->renderPartial('application.views.mail.'.$view, [
                    'branch_id'=>0,
                    'message' => $mailContent,
                    'title'=>$subject   
                ], true);
                $response = Yii::app()->sendGrid->sendEmail(
                    $toRecipient, // To Mail
                    ['email' => $from, 'name' => $from_name],     // From
                    $subject,  // Subject
                    $mail_body, // Body
                    $ccRecipients //CC MAil
                );
                if ($response) {
                    HrTraining::model()->updateByPK($id, array('mail_sent_ids' =>$notifying_id));
                }
            }
        }
        //End Notifying Employee 
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actiongettrainingmodule() {
        $course_id = $_POST['course_id'];
        $model = new HrTraining();
        $model_training_days = HrMasTrainingCourse::model()->findByPK($course_id); 
        $drop['training_days'] = $model_training_days->training_days;
        $drop['drop'] = CHtml::activedropdownlist($model, "sub_course_id", HrMasTrainingCourseDetail::gettrainingCourse($course_id), array('data-label'=>'Training Module <span style="color:red;">*</span>','empty'=>'Select','data-search'=>true));
        echo CJSON::encode($drop);
    }
    public function actionTrainingmatrix() {       
        $filename = 'Training Matrix.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('matrix_excel', array(), false, true);
        Yii::app()->end();
    }
    public function actiondownloaddocument() {
        $from = Yii::app()->request->getParam('from');
        if($from==1){
            $file ='Training effectiveness assesment - Employee.docx';  
        }else if($from==2){
            $file ='Training effectiveness assesment - Manager.docx';  
        }else if($from==3){
            $file ='Training Feedback.docx';  
        }
        
        $path = Yii::getPathOfAlias('webroot') . "/uploads/masterdocuments/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }
}
