<?php

class HrtimesheetController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Uploadtimesheet', 'UploadEmployeecsv', 'SaveUploadCsv', 'DownloadSampleCsv', 'DownloadErrorCsv', 'Updatetimesheet', 'loademployee', 'Updateovertimesheet',
                    'OvertimeDetails', 'GetUploadOvertimeList', 'edituploadovertime', 'viewuploadovertimesheet', 'deleteovertimedetails', 'Addovertime', 'SaveOtDetails','excelOverTimeSheetDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionUploadtimesheet() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_overtimesheet', array(), false, true);
    }

    public function actionDownloadSampleCsv() {
        $filename = 'Overtime Sheet.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee Code,Employee Name,Holiday OT Hours,Normal OT Hours ,Night OT Hours,Weekend OT Hours';
        Yii::app()->end();
    }

    public function readEmployeeCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/overtime/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/overtime/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate = TRUE;
        $error_list = array();
        $employeecode_error = array();
        $employee_list = $this->readEmployeeCSV("uploads/overtime/" . $file_name);
        foreach (array_slice($employee_list, 1) as $i => $data) {
            if (!empty($data[0]) || !empty($data[3]) || !empty($data[2]) || !empty($data[3]) || !empty($data[4]) || !empty($data[5])) {
                $employee_model[$i] = new HrOutsourceOvertime();
                $employee_model[$i]->scenario = "excelupload";
                $employee_code = '';
                if ($data[0] != '') {
                    $employee_code = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"')), "e");
                    $model_employee_details[$i] = Employee::model()->find(array('select' => 'id', 'condition' => 'employee_code="' . $employee_code . '"'));
                    $employee_model[$i]->employee_id = $model_employee_details[$i]->id;
                } else {
                    $employee_model[$i]->employee_id = '';
                }
                $employeecode_error[$i] = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                $employee_model[$i]->overtime_month = $month;
                $employee_model[$i]->overtime_year = $year;
                $employee_model[$i]->employee_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                $employee_model[$i]->employee_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                $employee_model[$i]->holiday_overtime = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                $employee_model[$i]->normal_overtime = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"'));
                $employee_model[$i]->night_overtime = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[4]), '"'));
                $employee_model[$i]->weekend_overtime = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[5]), '"'));
                $employee_model[$i]->created_by = Yii::app()->user->id;
                $employee_model[$i]->created_date_time = date('Y-m-d H:i:s');
                $validate = $employee_model[$i]->validate() && $validate;
            }
        }

        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);

            $old_key = NULL;
            $old_value = NULL;
            foreach ($raw_array as $key => $value) {
                if ($value === NULL) {
                    continue;
                }
                if ($old_value != NULL) {
                    if (strcasecmp($old_value, $value) === 0) {
                        $dupes[$old_key] = $old_value;
                        $dupes[$key] = $value;
                    }
                }
                $old_value = $value;
                $old_key = $key;
            }
            return $dupes;
        }

        $empcode_common = array_not_unique($employeecode_error);
        if ($validate && empty($empcode_common)) {
            if (!empty($employee_model)) {
                foreach ($employee_model as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['error'] = "";
            }
        } else {
            if (!empty($employee_model)) {
                foreach ($employee_model as $s => $data_model) {
                    $error_list[$s]['employee_code'] = $data_model['employee_code'];
                    $error_list[$s]['employee_name'] = $data_model['employee_name'];
                    $error_list[$s]['holiday_overtime'] = $data_model['holiday_overtime'];
                    $error_list[$s]['normal_overtime'] = $data_model['normal_overtime'];
                    $error_list[$s]['night_overtime'] = $data_model['night_overtime'];
                    $error_list[$s]['weekend_overtime'] =$data_model['weekend_overtime'];
                    if ($data_model->validate()) {
                        $error_list[$s]['remarks'] = "correct";
                    } else {
                        $error_list[$s]['remarks'] = $data_model->getErrors();
                    }
                }
            }
        }

        $j = 0;
        fclose($file);
        $list = array();
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Employee Code,Employee Name, Holiday OT Hours,Normal OT Hours ,Night OT Hours,Weekend OT Hours,Remarks';
            foreach ($error_list as $i => $error_detail) {
                if (!empty($error_detail)) {
                    if (!empty($error_detail['remarks'])) {
                        $error_view[$i] = '';
                        foreach ($error_detail['remarks'] as $p => $error_value) {
                            $error_view[$i] .= $error_value[0] . " / ";
                        }
                    } else {
                        $error_view[$i] .= '';
                    }
                    if (in_array($error_detail['employee_code'], $empcode_common)) {
                        $error_view[$i] .= " Employee code duplication in CSV /";
                    } else {
                        $error_view[$i] .= '';
                    }
                    $list[$j++] = $error_detail['employee_code'] . ',' . $error_detail['employee_name'] . ',' . $error_detail['holiday_overtime'] . ',' . $error_detail['normal_overtime'] . ',' . $error_detail['night_overtime']. ',' . $error_detail['weekend_overtime'] . ',' . $error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }


        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('hrtimesheet/DownloadErrorCsv', 'id' => $file_name), array('target' => '_blank',
                    'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                    . ''
        ));
        echo CJSON::encode($jsonData);
    }

    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/overtime/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }

    public function actionUpdatetimesheet() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('update_overtimesheet', array(), false, true);
    }

    public function actionloademployee() {
        $branch = Yii::app()->request->getparam('branch');
        $month = Yii::app()->request->getparam('month');
        $year = Yii::app()->request->getparam('year');
        $model_employee = HrOutsourceOvertime::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and overtime_month="' . $month . '" and overtime_year="' . $year . '"'));
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeedetail->employeefullname . ' ' . $value->employeedetail->employeecode] = $value['employee_id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('timesheet_list', array('branch' => $branch, 'month' => $month, 'year' => $year, 'arr_employee' => $arr_employee), false, true);
    }

    public function actionUpdateovertimesheet() {
        if (isset($_POST['HrOutsourceOvertime'])) {
            foreach ($_POST['HrOutsourceOvertime'] as $i => $items) {
                if ($items['id'] > 0) {
                    $model[$i] = HrOutsourceOvertime::model()->findByPK($items['id']);
                    $model[$i]->updated_by = Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                    $model[$i]->normal_overtime = $items['normal_overtime'];
                    $model[$i]->night_overtime = $items['night_overtime'];
                    $model[$i]->holiday_overtime = $items['holiday_overtime'];
                    $model[$i]->weekend_overtime = $items['weekend_overtime'];
                    $model[$i]->save();
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionOvertimeDetails() {
        $model_module_payroll= HrModules::model()->findByPK(7);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_overtime_sheet_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')) {
            $this->render('upload_overtime_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetUploadOvertimeList() {
        $model_overtime = new HrOutsourceOvertime();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $columns = array(0 => 't.id', 1 => 'branch_sponsor.branch_or_sponsor_name', 2 => 't.overtime_month', 3 => 't.overtime_year', 4 => 't.id');
        $condition = '1=1';
        if ($branch_id > 0) {
            $condition .= ' and employeedetail.branch_or_sponsor_id="' . $branch_id . '"';
        } else {
            if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
            }
        }
        if ($month > 0) {
            $condition .= ' AND t.overtime_month = "' . $month . '"';
        }
        if ($year > 0) {
            $condition .= ' AND t.overtime_year = "' . $year . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.overtime_month LIKE '%" . $searchString . "%' OR employeedetail.branch_or_sponsor_id LIKE '%" . $searchString . "%' OR overtime_year LIKE '%" . $searchString . "%')";
        }
        $count = $model_overtime->with('employeedetail')->count(array('condition' => $condition, 'group' => 'overtime_month,overtime_year, employeedetail.branch_or_sponsor_id'));
        $model_overtime = $model_overtime->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'group' => 'overtime_month,overtime_year, employeedetail.branch_or_sponsor_id'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model_overtime as $row) {
            $div = '';
            $model_salary_already_locked = SalaryProcessing::model()->find(array('condition' => 'payroll_branch_or_sponsor_id="' . $row['employeedetail']['branch_or_sponsor_id'] . '" AND MONTH(payroll_enddate)="' . $row['overtime_month'] . '" AND YEAR(payroll_enddate)="' . $row['overtime_year'] . '"'));
            $edit_upload=$delete_upload=$view_upload=0;
            if (empty($model_salary_already_locked)) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_upload_overtimesheet_edit']) || Yii::app()->user->authorised_user == 1) {
                    $div .= '<a class="btn btn-primary btn-xs" title="Edit Upload Overtime Sheet" onclick="loadPopupModal(\'hr/hrtimesheet/edituploadovertime&branch=' . $row['employeedetail']['branch_or_sponsor_id'] . '&month=' . $row['overtime_month'] . '&year=' . $row['overtime_year'] . '\',\'Edit Upload Overtime Sheet\',\'xl\');"><i class="fa fa-edit"></i></a>';
                    $edit_upload=1;
                    
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_upload_overtimesheet_delete']) || Yii::app()->user->authorised_user == 1) {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete" onclick="deleteovertimedetails(' . $row['id'] . ')"><i class="fa fa-trash "></i></a>';
                    $delete_upload=1;
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_upload_overtimesheet_view']) || Yii::app()->user->authorised_user == 1) {
                $div .= ' <a class="btn btn-primary btn-xs" title="View Upload Overtime Sheet" onclick="loadPopupModal(\'hr/hrtimesheet/viewuploadovertimesheet&branch=' . $row['employeedetail']['branch_or_sponsor_id'] . '&month=' . $row['overtime_month'] . '&year=' . $row['overtime_year'] . '\',\'View Upload Overtime Sheet\',\'lg\');"><i class="fa fa-eye"></i></a>&nbsp;';
                $view_upload =1;
            }
            $month = '-';
            if ($row['overtime_month'] > 0) {
                $month = str_pad($row['overtime_month'], 2, '0', STR_PAD_LEFT);
                $month = HrGenerelSettings::getMonthName($month);
            }

            $rowData[] = array(++$m, $row['employeedetail']['branch_sponsor']['branch_or_sponsor_name'], $month, $row['overtime_year'],array('id'=>$row['id'],'branch'=>$row['employeedetail']['branch_or_sponsor_id'],'month'=>$row['overtime_month'],'year'=>$row['overtime_year'],'edit_upload'=>$edit_upload,'delete_upload'=>$delete_upload,'view_upload'=>$view_upload));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionedituploadovertime() {
        $branch = Yii::app()->request->getparam('branch');
        $month = Yii::app()->request->getparam('month');
        $year = Yii::app()->request->getparam('year');
        $model_employee = HrOutsourceOvertime::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and overtime_month="' . $month . '" and overtime_year="' . $year . '"', 'order' => 'employeedetail.de_first_name asc'));

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('overtime_sheet_list', array('branch' => $branch, 'month' => $month, 'year' => $year, 'arr_employee' => $model_employee), false, true);
    }

    public function actionviewuploadovertimesheet() {
        $branch = Yii::app()->request->getparam('branch');
        $month = Yii::app()->request->getparam('month');
        $year = Yii::app()->request->getparam('year');
        $model_employee = HrOutsourceOvertime::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.branch_or_sponsor_id="' . $branch . '" and overtime_month="' . $month . '" and overtime_year="' . $year . '"', 'order' => 'employeedetail.de_first_name asc'));
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('view_overtime_sheet_list', array('branch' => $branch, 'month' => $month, 'year' => $year, 'arr_employee' => $model_employee), false, true);
    }

    public function actiondeleteovertimedetails() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = HrOutsourceOvertime::model()->findByPk($id);
            if ($model->id) {
                $branch_id = $model->employeedetail->branch_or_sponsor_id;
                $ot_month = $model->overtime_month;
                $ot_year = $model->overtime_year;
                $model_salary_already_locked = SalaryProcessing::model()->find(array('condition' => 'payroll_branch_or_sponsor_id="' . $branch_id . '" AND MONTH(payroll_enddate)="' . $ot_month . '" AND YEAR(payroll_enddate)="' . $ot_year . '"'));
                if (empty($model_salary_already_locked)) {
                    $model_ot = HrOutsourceOvertime::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.branch_or_sponsor_id="' . $branch_id . '" AND overtime_month="' . $ot_month . '" AND overtime_year="' . $ot_year . '"'));
                    if (!empty($model_ot)) {
                        foreach ($model_ot as $key => $value) {
                            HrOutsourceOvertime::model()->deleteByPk($value->id);
                        }
                    }
                    $model_ot_exist = HrOutsourceOvertime::model()->with('employeedetail')->findAll(array('condition' => 'employeedetail.branch_or_sponsor_id="' . $branch_id . '" AND overtime_month="' . $ot_month . '" AND overtime_year="' . $ot_year . '"'));
                    if (empty($model_ot_exist)) {
                        $jsonData['status'] = 'success';
                    } else {
                        $jsonData['status'] = 'error';
                    }
                } else {
                    $jsonData['status'] = 'error';
                }
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    //Added by Dr on 3/8/2024
    public function actionAddovertime() {
        $model = new HrOutsourceOvertime();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('add_overtime', array('model' => $model), false, true);
    }

    public function actionSaveOtDetails() {
        if (isset($_POST['HrOutsourceOvertime'])) {
            $validate = true;
            foreach ($_POST['HrOutsourceOvertime'] as $i => $items) {
                $model[$i] = new HrOutsourceOvertime();
                $model[$i]->scenario = 'excelupload';
                $model[$i]->created_by = Yii::app()->user->id;
                $model[$i]->created_date_time = date('Y-m-d H:i:s');
                $model[$i]->employee_id = $items['employee_id'];
                $model[$i]->overtime_month = $_POST['o_time_month'];
                $model[$i]->overtime_year = $_POST['o_time_year'];
                $model[$i]->normal_overtime = $items['normal_overtime'];
                $model[$i]->night_overtime = $items['night_overtime'];
                $model[$i]->holiday_overtime = $items['holiday_overtime'];
                $model[$i]->weekend_overtime = $items['weekend_overtime'];
                $validate = $model[$i]->validate() && $validate;
            }
            if ($validate) {
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    //Download Overtime Sheet
    public function actionexcelOverTimeSheetDetails()
    {
        $branch = Yii::app()->request->getparam('branch');
        $month = Yii::app()->request->getparam('month');
        $year = Yii::app()->request->getparam('year');
        
        $condition = 'overtime_month="' . $month . '" AND overtime_year="' . $year . '"';
        
        if (!empty($branch)) {
            $condition .= ' AND employeedetail.branch_or_sponsor_id="' . $branch . '"';
        }
        
        $model_employee = HrOutsourceOvertime::model()->with('employeedetail')->findAll(array(
            'condition' => $condition,
            'order' => 'employeedetail.de_first_name ASC'
        ));
        
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        
        // Set column widths
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(45);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        
        // Set headers
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'No')
                    ->setCellValue('B1', 'Branch')
                    ->setCellValue('C1', 'Employee Code')
                    ->setCellValue('D1', 'Employee Name')
                    ->setCellValue('E1', 'Normal Overtime')
                    ->setCellValue('F1', 'Holiday Overtime')
                    ->setCellValue('G1', 'Night Overtime')
                    ->setCellValue('H1', 'Weekend Overtime')
                    ->setCellValue('I1', 'Total Overtime');
    
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true)->setSize(12);
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFill()->getStartColor()->setARGB('FFCCCCCC'); // Light gray background for headers
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->getColor()->setARGB('FF000000'); // Black font color
        $objPHPExcel->getActiveSheet()->getStyle('E:I')->getNumberFormat()->setFormatCode('0.00' );
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->applyFromArray($styleArray);
        $rowCount = 2;
        $start=$rowCount;
        $number = 1;
        $total_normal_overtime = 0.00;
        $total_holiday_overtime = 0.00;
        $total_night_overtime = 0.00;
        $total_weekend_overtime = 0.00;
        
        foreach ($model_employee as $each) {
            $each_overtime = 0.00;
            $total_normal_overtime += $each->normal_overtime;
            $total_holiday_overtime += $each->holiday_overtime;
            $total_night_overtime += $each->night_overtime;
            $total_weekend_overtime += $each->weekend_overtime;
            
            $each_overtime = $each->normal_overtime + $each->holiday_overtime + $each->night_overtime + $each->weekend_overtime;
            
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, $number);
            $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            $objPHPExcel->getActiveSheet()->setCellValue('B' . $rowCount, $each->employeedetail->branch_sponsor->branch_or_sponsor_name);
            $objPHPExcel->getActiveSheet()->setCellValue('C' . $rowCount, $each->employeedetail->employeecode);
            $objPHPExcel->getActiveSheet()->getStyle('C' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            $objPHPExcel->getActiveSheet()->setCellValue('D' . $rowCount, $each->employeedetail->employeefullname);
            $objPHPExcel->getActiveSheet()->setCellValue('E' . $rowCount, $each->normal_overtime);
            $objPHPExcel->getActiveSheet()->setCellValue('F' . $rowCount, $each->holiday_overtime);
            $objPHPExcel->getActiveSheet()->setCellValue('G' . $rowCount, $each->night_overtime);
            $objPHPExcel->getActiveSheet()->setCellValue('H' . $rowCount, $each->weekend_overtime);
            $objPHPExcel->getActiveSheet()->setCellValue('I' . $rowCount, number_format($each_overtime, 2));
          
            $rowCount++;
            $number++;
        }
        
        // Add totals row
        $objPHPExcel->getActiveSheet()->mergeCells('A' . $rowCount . ':D' . $rowCount); 
        $objPHPExcel->getActiveSheet()->setCellValue('A' . $rowCount, 'Total');

        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':I' . $rowCount)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':I' . $rowCount)->getFill()->getStartColor()->setARGB('FFCEE5CF'); 
     
        
        // Set the text "Total" right-aligned in the merged cell
        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':D' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    
        $objPHPExcel->getActiveSheet()->setCellValue('E' . $rowCount, $total_normal_overtime);
        $objPHPExcel->getActiveSheet()->setCellValue('F' . $rowCount, $total_holiday_overtime);
        $objPHPExcel->getActiveSheet()->setCellValue('G' . $rowCount, $total_night_overtime);
        $objPHPExcel->getActiveSheet()->setCellValue('H' . $rowCount, $total_weekend_overtime);
        $objPHPExcel->getActiveSheet()->setCellValue('I' . $rowCount, number_format(
            $total_normal_overtime + $total_holiday_overtime + $total_night_overtime + $total_weekend_overtime,
            2
        ));
        
        
        $objPHPExcel->getActiveSheet()->getStyle('I' . $rowCount)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        
       
        for ($i = 2; $i <= $rowCount; $i++) {
            $objPHPExcel->getActiveSheet()->getStyle('I' . $i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
            $objPHPExcel->getActiveSheet()->getStyle('I' . $i)->getFill()->getStartColor()->setARGB('FFCEE5CF'); 
        }
    
        $objPHPExcel->getActiveSheet()->getStyle('A' . $rowCount . ':I' . $rowCount)->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->getStyle('A' . $start . ':I' . $rowCount  . '')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->setTitle('Overtime Details');
        $objPHPExcel->setActiveSheetIndex(0);
        
        // Set response headers for the download
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="over_time_details.xls"');
        header('Cache-Control: max-age=0');
        header('Cache-Control: max-age=1');
        header('Cache-Control: cache, must-revalidate');
        header('Pragma: public');
        
        // Save the Excel file to output
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
    

}
