<?php

class HrsaletargetController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetList', 'Create','LoademployeeDetails','Savesaletarget','deleteincentive','getincentiveamount','MasterIncentive','saveincentivemaster','deletePercentage',
                    'TargetDetails','loadtargetlist','Savetargetdetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_incentive_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetList() {
        $model = new HrSaleTarget();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'branch.branch_or_sponsor_name',
            2 => 'month',
            3 => 'year',
            4 => 'target_type',
            5 => 't.id',
            6 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "1=1";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (branch.branch_or_sponsor_name LIKE '%".$searchString."%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and t.branch_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('branch','departmentdetail')->count(array('condition' => $condition));
        $model = $model->with('branch','departmentdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset,'order' => $orderBy));        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $target_type= array('B'=>'Booking','C'=>'Card');
        foreach ($model as $row) {
            $button_string = "";
            $dept_name ="";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_incentive_edit'])  || Yii::app()->user->authorised_user == 1){
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/hrsaletarget/create&id=' . $row['id'] . '\',\'Edit Incentive Detail \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_incentive_delete'])  || Yii::app()->user->authorised_user == 1){
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteincentive(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
            }
            if(!empty($row['departmentdetail'])){
                $dept_name = $row['departmentdetail']['department_name'];
            }
            $rowData[] = array($m,$row['branch']['branch_or_sponsor_name'],$dept_name,HrGenerelSettings::getMonthName1($row['month']), $row['year'],$target_type[$row['target_type']], $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrSaleTarget();
        $model_details=array(new HrSaleTargetDetails()); 
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details= HrSaleTargetDetails::model()->findAll(array('condition' => 'target_id="'. $id.'"'));
            if(empty($model_details)){
                $model_details=array(new HrSaleTargetDetails()); 
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_details' => $model_details), false, true);
    }
    public function actionLoademployeeDetails() {
        $branch = Yii::app()->request->getparam("branch");
        $department_id = Yii::app()->request->getparam("department_id");
        $month = Yii::app()->request->getparam("month");
        $year = Yii::app()->request->getparam("year");
        $target_type = Yii::app()->request->getparam("target_type");
        $condition='branch_or_sponsor_id="' . $branch . '" AND isActive!="B"';
        if($department_id!=''){
            $condition.=' AND department="'.$department_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d"). ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        $model_setting = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        if($target_type=='B'){ //For Booking Target
            $this->render('employee_booking_incentive', array('arr_employee' => $arr_employee, 'branch' => $branch, 'month' => $month, 'year' => $year,'model_setting'=>$model_setting,'target_type'=>$target_type));
        }else if($target_type=='C'){ //For Card Target
            $this->render('employee_details_incentive', array('arr_employee' => $arr_employee, 'branch' => $branch, 'department_id' => $department_id,'month' => $month, 'year' => $year,'model_setting'=>$model_setting,'target_type'=>$target_type));
        }
    }
    public function actionSavesaletarget() {
        if (isset($_POST['HrSaleTarget'])) {
            $model= new HrSaleTarget();  
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['HrSaleTarget']['id'] > 0) {                
                $model = HrSaleTarget::model()->findByPK($_POST['HrSaleTarget']['id']);
                $model->id = (int) $_POST['HrSaleTarget']['id'];     
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrSaleTarget']; 
            if(isset($_POST['HrSaleTarget']['incentive_per_card'])){
                $model->incentive_per_card = $_POST['HrSaleTarget']['incentive_per_card']; 
            }
            $valid=$model->validate();
            $i=0;
            if (isset($_POST['HrSaleTargetDetails'])){
                foreach ($_POST['HrSaleTargetDetails'] as $k => $items) {
                    if($items['incentive_amount']>0 || $items['net_incentive_amount']>0 || $items['target_card_count']>0 || $items['sold_card_count']>0){
                        if($items['id']>0){
                            $model_details[$i] = HrSaleTargetDetails::model()->findByPK($items['id']);   
                        }else{
                            $model_details[$i] = new HrSaleTargetDetails();   
                        }   
                        $model_details[$i]->attributes = $_POST['HrSaleTargetDetails'][$k];
                        $valid=$model_details[$i]->validate() && $valid;
                        $i++;
                    }
                    
                }
            }
           if(empty($model_details)){
              $valid=false; 
           }
            if($valid){
                $model->save();
                if (!empty($model_details)) {
                    foreach ($model_details as $eachModel) {
                        $eachModel->target_id = $model->id;
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_details)){
                   $error2 = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                }else{
                    $error2[]='Please enter incentive details in atleast one row';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
    public function actiondeleteincentive() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model =HrSaleTarget::model()->findByPk($id);
            if($model->id){
                HrSaleTargetDetails::model()->deleteAll('target_id=:refer_id', array(':refer_id' => $model->id));
                $model_details_exist= HrSaleTargetDetails::model()->findAll(array('condition' => 'target_id="'. $model->id.'"'));
                if(empty($model_details_exist)){
                    HrSaleTarget::model()->deleteByPk($id);
                    $jsonData['status'] = 'success';
                }else{
                    $jsonData['status'] = 'error';
                }
            }else{
                $jsonData['status'] = 'error';
            }
        } else {
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiongetincentiveamount() {
        $target_card_count= $_POST['target_card_count'];
        $booking_amount = $_POST['booking_amount'];
        if ($booking_amount > 0) {
            if($target_card_count==0){
                $amount=($booking_amount*1)/100;
                $jsonData['incentive'] =$amount;
            }else{
                $model_structure = HrMasIncentiveStructure::model()->find(array('condition' => '((amount_from<="' . $booking_amount . '" AND amount_to>="' . $booking_amount . '") OR  (amount_from BETWEEN  "' . $booking_amount . '" AND  "' . $booking_amount . '"
                                    OR amount_to BETWEEN  "' . $booking_amount . '" AND  "' . $booking_amount . '"))'));
                if($model_structure->id>0){
                    $percentage=$model_structure->percentage_val;
                    $amount=($booking_amount*$percentage)/100;
                    $jsonData['incentive'] =$amount;
                }else{
                    $jsonData['incentive'] =0.00;
                }
            }
        } else {
           $jsonData['incentive'] =0.00;
        }
        echo CJSON::encode($jsonData);
    }
    public function actionMasterIncentive() {
        $model_details= HrMasIncentiveStructure::model()->findAll();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('master_incentive', array('model_details' => $model_details), false, true);
    }
    public function actionsaveincentivemaster() {
        if (isset($_POST['HrMasIncentiveStructure'])) {           
            $valid=true;
            if ((isset($_POST['HrMasIncentiveStructure']))){			
                foreach ($_POST['HrMasIncentiveStructure'] as $i => $items) {
                    if($items['id']>0){
                        $model[$i] = HrMasIncentiveStructure::model()->findByPK($items['id']);   
                        $model[$i]->updated_by= Yii::app()->user->id;
                        $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                        $model[$i]->scenario = 'update'; 
                    }else{
                        $model[$i] = new HrMasIncentiveStructure();   
                        $model[$i]->created_by= Yii::app()->user->id;
                        $model[$i]->created_date_time = date('Y-m-d H:i:s');
                        $model[$i]->scenario = 'add';
                    }   
										
                    $model[$i]->attributes =$_POST['HrMasIncentiveStructure'][$i];	
                    $valid=$model[$i]->validate() && $valid;
                    
                }
            }
            if($valid){
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);        
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
    public function actiondeletePercentage(){
        $id = $_POST['id'];
        if($id>0){
            HrMasIncentiveStructure::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionTargetDetails() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('target_detail_form');
    }
    public function actionloadtargetlist() {
        $branch =Yii::app()->request->getparam('branch'); 
        $department_id =Yii::app()->request->getparam('department_id'); 
        $type =Yii::app()->request->getparam('type'); 
        $condition='branch_or_sponsor_id="' . $branch . '" AND isActive!="B"';
        if($department_id!=''){
            $condition.=' AND department="'.$department_id.'"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value['employeefullname']. ' ' . $value['employeecode']]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('employee_target_list', array('arr_employee'=>$arr_employee,'type'=>$type), false, true); 
    }  
    public function actionSavetargetdetails() {
        if (isset($_POST['HrEmployeeTarget'])) {           
            $valid=true;
            if ((isset($_POST['HrEmployeeTarget']))){	
                $i=0;
                foreach ($_POST['HrEmployeeTarget'] as $j => $items) {
                    if($items['id']>0 || $items['target_amount']>0){
                        if($items['id']>0){
                            $model[$i] = HrEmployeeTarget::model()->findByPK($items['id']);   
                            $model[$i]->updated_by= Yii::app()->user->id;
                            $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                        }else{
                            $model[$i] = new HrEmployeeTarget();   
                            $model[$i]->created_by= Yii::app()->user->id;
                            $model[$i]->created_date_time = date('Y-m-d H:i:s');
                        }   

                        $model[$i]->attributes =$_POST['HrEmployeeTarget'][$i];
                        $model[$i]->target_type =$_POST['target_type'];
                        $valid=$model[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            if($valid){
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);        
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
}
