<?php

class HrrepresentationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','EmployeeList','FilterEmployeeList','Documentlist','FilterDocumentlist','FilterdocumentbyStatus','IncrementSalary','getbranchemployee','getbranchmultipleemployee','Assetlist','Worklocationlist','Filterlocationlist','Leavelist','leavedetails','Attendancelist','DailyAttendancelist','DailyLeavelist',
                    'DailyLatelist','MonthlyAbsentlist','Targetlist','Salarylist','AdvanceSalary','FilterAdvance','getsalesperson','MonthlyPayable','AllowanceChanges','filterallowancechange','leavehistory','filterleavehistory','leavebalance','loadleavegraphbymonth','loadleavebalancegraphbyemployee','loadleavebalancegraphbyleave',
                    'FilterAssetDetails','FilterAssetList','loadPayableMontlyGraph','NoticeofCoduct','DailyMeetingDetails','loadvisitgraphbymonth','loadvisitgraphbydate'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() { 
        $model_module_snapshot= HrModules::model()->findByPK(34);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_representation_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_snapshot->grant_access == 1 && $model_module_snapshot->isActive == 'Y')) {
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
     //Start employee dropdown
    public function actiongetbranchemployee() {
        $branch = $_POST['branch'];
        $status = $_POST['status'];
        $field = $_POST['field'];
        if($branch==''){
            $branch=0;
        }
        $jsonData['employee'] = CHtml::dropdownlist($field, '', Employee::getEmployeedetails($branch,$status), array('empty' => 'All', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actiongetbranchmultipleemployee() {
        $branch = $_POST['branch'];
        $status = $_POST['status'];
        $field = $_POST['field'];
        if($branch==''){
            $branch=0;
        }
        $jsonData['employee'] = CHtml::dropdownlist($field, '', Employee::getEmployeedetails($branch,$status), array('title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true,'multiple'=>true));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    //End employee dropdown
    //Employee List
    public function actionEmployeeList(){
        $year=(int) Yii::app()->request->getParam('year');
        $branch_id=(int) Yii::app()->request->getParam('branch_id');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        $status=Yii::app()->request->getParam('status');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $gender=(int) Yii::app()->request->getParam('gender');
        $worker_type=Yii::app()->request->getParam('worker_type');
        $visa_type=Yii::app()->request->getParam('visa_type');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_employee_list', array('year' => $year,'branch_id' => $branch_id,'reset_year' => $reset_year,'status' => $status,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'gender' => $gender,'worker_type' => $worker_type,'visa_type' => $visa_type), false, true);
    }
    public function actionFilterEmployeeList(){
        $status=Yii::app()->request->getParam('status');
        $branch_id=(int) Yii::app()->request->getParam('branch_id');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $gender=(int) Yii::app()->request->getParam('gender');
        $worker_type=Yii::app()->request->getParam('worker_type');
        $visa_type=Yii::app()->request->getParam('visa_type');
        $year=(int) Yii::app()->request->getParam('year');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_filter_employee_list', array('year' => $year,'status' => $status,'branch_id' => $branch_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'gender' => $gender,'worker_type' => $worker_type,'visa_type' => $visa_type), false, true);
    }
    //Work Location
    public function actionWorklocationlist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $status=Yii::app()->request->getParam('status');
        $location_id=(int) Yii::app()->request->getParam('location_id');
        $year=(int) Yii::app()->request->getParam('year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        $sort_order=Yii::app()->request->getParam('sort_order');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_worklocation_employee_list', array('year' => $year,'reset_year' => $reset_year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'location_id' => $location_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_worklocation_list', array('year' => $year,'reset_year' => $reset_year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'location_id' => $location_id,'sort' => $sort_order), false, true);
        }
    }
     public function actionFilterlocationlist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $status=Yii::app()->request->getParam('status');
        $location_id=(int) Yii::app()->request->getParam('location_id');
        $year=(int) Yii::app()->request->getParam('year');
        $sort_order=Yii::app()->request->getParam('sort_order');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_filter_worklocation_employee_list', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'location_id' => $location_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_filter_worklocation_list', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'location_id' => $location_id,'sort' => $sort_order), false, true);
        }
    }
    //ENd Location
    //Start Document
    public function actionDocumentlist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $upload_status=Yii::app()->request->getParam('upload_status');
        $status=Yii::app()->request->getParam('status');
        $document_id=(int) Yii::app()->request->getParam('document_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $year=(int) Yii::app()->request->getParam('year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_document_employee_list', array('year' => $year,'reset_year' => $reset_year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'upload_status' => $upload_status,'document_id' => $document_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_document_list', array('year' => $year,'reset_year' => $reset_year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'upload_status' => $upload_status,'document_id' => $document_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'sort' => $sort_order), false, true);
        }
    }
    public function actionFilterDocumentlist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $upload_status=Yii::app()->request->getParam('upload_status');
        $status=Yii::app()->request->getParam('status');
        $document_id=(int) Yii::app()->request->getParam('document_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $year=(int) Yii::app()->request->getParam('year');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_filter_document_employee_list', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'upload_status' => $upload_status,'document_id' => $document_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_filter_document_list', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'upload_status' => $upload_status,'document_id' => $document_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'sort' => $sort_order), false, true);
        }
    }
    public function actionFilterdocumentbyStatus(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $upload_status=Yii::app()->request->getParam('upload_status');
        $status=Yii::app()->request->getParam('status');
        $document_id=(int) Yii::app()->request->getParam('document_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $department_id=(int) Yii::app()->request->getParam('department');
        $designation_id=(int) Yii::app()->request->getParam('designation');
        $nationality_id=(int) Yii::app()->request->getParam('nationality');
        $year=(int) Yii::app()->request->getParam('year');
        $health_status=Yii::app()->request->getParam('health_status');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_filter_document_employee_list_status', array('health_status' => $health_status,'year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'upload_status' => $upload_status,'document_id' => $document_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_filter_document_list_status', array('health_status' => $health_status,'year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'upload_status' => $upload_status,'document_id' => $document_id,'department_id' => $department_id,'designation_id' => $designation_id,'nationality_id' => $nationality_id,'sort' => $sort_order), false, true);
        }
    }
    //End Document
    //Target Start
    public function actionTargetlist(){
        $month=Yii::app()->request->getParam('target_month');
        $year=Yii::app()->request->getParam('target_year');
        $sort_order=Yii::app()->request->getParam('sort_order');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        if($sort_order==''){
            $sort_order=1;
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==1){
            $this->renderPartial('_target_list', array('month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort' => $sort_order), false, true);
        }else if($sort_order==2){
            $this->renderPartial('_target_sales_acheived_list', array('month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort' => $sort_order), false, true);
        }
    }
    //Traget End
    //Salary Details Start
    //Salary Increment-Start
    public function actionIncrementSalary(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $year=Yii::app()->request->getParam('inc_year');
        $month=Yii::app()->request->getParam('inc_month');
        $status=Yii::app()->request->getParam('status');
        $page=Yii::app()->request->getParam('page');
        if($year==''){
            $year=date('Y');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($page=='' || $page=='S'){
            $this->renderPartial('_increment_salary_graph', array('branch_id' => $branch_id,'employee_id' => $employee_id,'year'=>$year,'status' => $status,'page' => $page), false, true);
        }else if($page=='M'){
            if($month==''){
                $month=date('m');
            }
            $start_date=$year.'-'.$month.'-01';
            $end_date= date("Y-m-t", strtotime($start_date));
            $this->renderPartial('_increment_salary_list', array('branch_id' => $branch_id,'employee_id' => $employee_id,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'status' => $status,'month' => $month,'page' => $page), false, true);
        }
    }
    public static function getmonthlysalarydetail($empid,$month,$year){
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        $model_salary_master=MasSalarytype::model()->findAll(array('condition' => 'salary_type="1"'));
        $amount=0.00;
        foreach ($model_salary_master as $key => $value) {
            $model_salary_details = EmployeeSalary::model()->find(array('condition' => '((valid_from<="' . $start_date . '" AND valid_to>="' . $end_date . '") OR  (valid_from BETWEEN  "' . $start_date . '" AND  "' . $end_date . '"
                                OR valid_to BETWEEN  "' . $start_date . '" AND  "' . $end_date . '")) AND employee_id="' . $empid. '" AND t.salary_type="'.$value->id.'"'));
            if(!empty($model_salary_details) && $model_salary_details->amount>0){  
                $amount+=$model_salary_details->amount;
            }else{
                $model_salary_details = EmployeeSalary::model()->with('salary')->find(array('condition' => 't.salary_type="'.$value->id.'" AND employee_id="'.$empid.'" AND (valid_from<= "'.$start_date.'" OR valid_from<="'.$end_date.'") AND valid_to="0000-00-00"','order'=>'t.id desc'));
                if(!empty($model_salary_details) && $model_salary_details->amount>0){
                    $amount+=$model_salary_details->amount;
                }
            }
            
        }
        return $amount;
    }
    //Salary Increment-End
    //Advance Salary-Start
    public function actionAdvanceSalary(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('advance_month');
        $year=Yii::app()->request->getParam('advance_year');
        $status=Yii::app()->request->getParam('status');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_advance_salary_list', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'reset_year' => $reset_year,'start_date'=>$start_date,'end_date'=>$end_date,'status' => $status), false, true);
    }
    public function actionFilterAdvance(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('advance_month');
        $year=Yii::app()->request->getParam('advance_year');
        $status=Yii::app()->request->getParam('status');
        $status_val=Yii::app()->request->getParam('status_val');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_filter_advance_salary_list', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'status' => $status,'status_val' => $status_val), false, true);
    }
    //Advance Salary-End
    //Monthly Payable-start
    public function actiongetsalesperson() {
        $branch = $_POST['branch'];
        $status = $_POST['status'];
        $field = $_POST['field'];
        if($branch==''){
            $branch=0;
        }
        $jsonData['employee'] = CHtml::dropdownlist($field, '', User::getemployeeconnectedsalesperson($branch,$status), array('empty' => 'All', 'title' => 'Sales Person', 'data-label' => 'Sales Person', 'data-search' => true));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionMonthlyPayable(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('payable_month');
        $year=Yii::app()->request->getParam('payable_year');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $status=Yii::app()->request->getParam('status');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        if($sort_order==''){
            $sort_order=2;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==1){
            $this->renderPartial('_monthly_payable_sales_person', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status), false, true);
        }else if($sort_order==2){
            $this->renderPartial('_monthly_payable', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status), false, true);
        }
    }
    //Monthly Payable-ENd
    //Allowance Payable-Start
    public function actionAllowanceChanges(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('allowance_month');
        $year=Yii::app()->request->getParam('allowance_year');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $status=Yii::app()->request->getParam('status');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        if($sort_order==''){
            $sort_order=2;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==1){
            $this->renderPartial('_allowance_payable_sales_person', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status,'reset_year' => $reset_year), false, true);
        }else if($sort_order==2){
            $this->renderPartial('_allowance_payable', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status,'reset_year' => $reset_year), false, true);
        }
    }
    public function actionfilterallowancechange(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('allowance_month');
        $year=Yii::app()->request->getParam('allowance_year');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $status=Yii::app()->request->getParam('status');
        $salary_id=Yii::app()->request->getParam('salary_id');
        $salary_value=Yii::app()->request->getParam('salary_value');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        if($sort_order==''){
            $sort_order=1;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==1){
            $this->renderPartial('_filter_allowance_payable_sales_person', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status,'salary_id' => $salary_id,'salary_value' => $salary_value), false, true);
        }else if($sort_order==2){
            $this->renderPartial('_filter_allowance_payable', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status,'salary_id' => $salary_id,'salary_value' => $salary_value), false, true);
        }
    }
    //Allowance Payable-End
    //Start Leave
    public function actionleavehistory(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('leave_year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        $month=Yii::app()->request->getParam('leave_month');
        if($month==''){
            $month=date('m');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_leave_history_list', array('year' => $year,'reset_year' => $reset_year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'month'=>$month), false, true);
    }
    public function actionfilterleavehistory(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('leave_year');
        $status_val=Yii::app()->request->getParam('status_val');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_filter_leave_history_list', array('year' => $year,'status_val' => $status_val,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id), false, true);
    }
    public function actionloadleavegraphbymonth(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('year');
        $month=Yii::app()->request->getParam('month');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_leave_graph_month', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'month'=>$month), false, true);
    }
    public function actionleavebalance(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('leave_year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_leave_balance_list', array('year' => $year,'reset_year' => $reset_year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id), false, true);
    }
    public function actionloadleavebalancegraphbyemployee(){
        $employee_id=Yii::app()->request->getParam('employee_id');
        $year=(int) Yii::app()->request->getParam('year');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_leave_balance_graph_employee', array('year' => $year,'employee_id' => $employee_id), false, true);
    }
    public function actionloadleavebalancegraphbyleave(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('year');
        $leave_id=Yii::app()->request->getParam('leave_type');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_leave_balance_graph_leave', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'leave_id' => $leave_id), false, true);
    }
    //End Leave
    //Asset-Start
    public function actionAssetlist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $asset_id=(int) Yii::app()->request->getParam('asset_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_asset_employee_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_asset_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order), false, true);
        }
    }
    public function actionFilterAssetDetails(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $asset_id=(int) Yii::app()->request->getParam('asset_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_filter_asset_employee_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_filter_asset_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order), false, true);
        }
    }
    public function actionFilterAssetList(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $asset_id=(int) Yii::app()->request->getParam('asset_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        $distribution_status=Yii::app()->request->getParam('distribution_status');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($distribution_status=='D'){
            if($sort_order==2){
                $this->renderPartial('_filter_asset_employee_list_status', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order,'availability'=>$distribution_status), false, true);
            }else{
                $this->renderPartial('_filter_asset_list_status', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order,'availability'=>$distribution_status), false, true);
            }
        }else if($distribution_status=='N'){
            $this->renderPartial('_filter_available_asset_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'asset_id' => $asset_id,'sort' => $sort_order,'availability'=>$distribution_status), false, true);
        }
    }
    //End Assetlist
    //Start Attendance
    //Absent List
    public function actionMonthlyAbsentlist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('month');
        $year=(int) Yii::app()->request->getParam('year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        $status=Yii::app()->request->getParam('status');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_monthly_absent_list', array('status' => $status,'branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year' => $year,'reset_year' => $reset_year,'start_date'=>$start_date,'end_date'=>$end_date), false, true);
    }
    public function actionDailyLatelist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('month');
        $year=(int) Yii::app()->request->getParam('year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        $status=Yii::app()->request->getParam('status');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_daily_late_list', array('status' => $status,'branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year' => $year,'reset_year' => $reset_year,'start_date'=>$start_date,'end_date'=>$end_date), false, true);
    }
    public function actionDailyLeavelist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $month=Yii::app()->request->getParam('month');
        $year=(int) Yii::app()->request->getParam('year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        $status=Yii::app()->request->getParam('status');
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_daily_leave_list', array('status' => $status,'branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year' => $year,'reset_year' => $reset_year,'start_date'=>$start_date,'end_date'=>$end_date), false, true);
    }
    public function actionDailyAttendancelist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $date_from=Yii::app()->request->getParam('date_from');
        $date_to=Yii::app()->request->getParam('date_to');
        if($date_from==''){
           $date_from=date('01/m/Y'); 
           $date_to=date('d/m/Y');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_daily_attendance_list', array('status' => $status,'branch_id' => $branch_id,'employee_id' => $employee_id,'date_from'=>$date_from,'date_to'=>$date_to), false, true);
    }
    //End Attendance
    
    
    
    
    
    
    
    public function actionLeavelist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $leave_id=(int) Yii::app()->request->getParam('leave_id');
        $sort_order=Yii::app()->request->getParam('sort_order');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($sort_order==2){
            $this->renderPartial('_leave_employee_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'leave_id' => $leave_id,'sort' => $sort_order), false, true);
        }else{
            $this->renderPartial('_leave_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'leave_id' => $leave_id,'sort' => $sort_order), false, true);
        }
    }
    public function actionleavedetails(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $leave_id=(int) Yii::app()->request->getParam('leave_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if($leave_id>0){
            $this->renderPartial('_leave_balance_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'leave_id' => $leave_id), false, true);
        }else{
            $this->renderPartial('_leave_history_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'leave_id' => $leave_id), false, true);
        }
    }
    public function actionAttendancelist(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_attendance_list', array('branch_id' => $branch_id,'employee_id' => $employee_id), false, true);
    }
    
    
    
    
    public function actionSalaryList(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_salary_list', array('branch_id' => $branch_id,'employee_id' => $employee_id), false, true);
    }

    public function actionloadPayableMontlyGraph(){
        $month=Yii::app()->request->getParam('month');
        $year=Yii::app()->request->getParam('payable_year');
        $branch_id='';
        $sort_order='';
        $employee_id='';
        $status='';
        if($month==''){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        $start_date=$year.'-'.$month.'-01';
        $end_date= date("Y-m-t", strtotime($start_date));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
     
            $this->renderPartial('_monthly_sal_payable', array('branch_id' => $branch_id,'employee_id' => $employee_id,'month' => $month,'year'=>$year,'start_date'=>$start_date,'end_date'=>$end_date,'sort'=>$sort_order,'status' => $status), false, true);
    }
    public function actionNoticeofCoduct(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        if(empty($month)){
            $month=date('m');
        }
        if(empty($year)){
            $year=date('Y');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->renderPartial('_noticeconduct_employee_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'year'=>$year), false, true);
    }

    public function actionDailyMeetingDetails(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('visit_year');
        $reset_year=(int) Yii::app()->request->getParam('r_year');
        if(empty($month)){
            $month=date('m');
        }
        if($year==''){
            $year=date('Y');
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->renderPartial('_dailymeeting_employee_list', array('branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'month'=>$month,'year'=>$year,'reset_year' => $reset_year,), false, true);
    }
    public function actionloadvisitgraphbymonth(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('year');
        $month=Yii::app()->request->getParam('month');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_visit_graph_month', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'month'=>$month), false, true);
    }
    public function actionloadvisitgraphbydate(){
        $branch_id=Yii::app()->request->getParam('branch_id');
        $employee_id=Yii::app()->request->getParam('employee_id');
        $status=Yii::app()->request->getParam('status');
        $year=(int) Yii::app()->request->getParam('year');
        $date_req=Yii::app()->request->getParam('date_from');
        $date_req = str_replace('/', '-', $date_req);
        $date_from = date("Y-m-d", strtotime($date_req));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('_visit_graph_date', array('year' => $year,'branch_id' => $branch_id,'status' => $status,'employee_id' => $employee_id,'date_from'=>$date_from), false, true);
    }
}
