<?php

class HrreportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('PrintAttendanceList', 'TicketEncashment',
                    'PrintAttendanceOverTimeList', 'PrintMonthlyAttendanceReport', 'PrintEmployeeWorkingHoursReport', 'Probationarylist',
                    'PrintWeekendLeaves', 'PrintAuditLog', 'PrintAttendanceYearlyLeaveList', 'PrintLeaveLedgerlist',
                    'PrintLeaveLedgerReportPDF', 'PrintLeaveEncashmentReportPDF', 'PrintLeaveEncashmentExcel', 'Probationarylist', 'ProbationarylistExcel', 'probationarylistPDF',
                    'PrintEmployeeLeavelistYearlyReportPDF', 'TicketEncashmentPDF', 'TicketEncashmentExcel','PrintEncashmentDetails','TicketEntitlement','TicketEntitlementPDF',
                    'TicketEntitlementExcel','PrintYearLeavedetails','PrintYearLeavedetailsPDF','PrintLeaveBalancelist','PrintLeaveBalancelist','PrinLeaveBalancePDF',
                    'PrintAdvancelist','PrintAdvanceReportPDF','PrintCompanyDocument','PrintCompanyDocumentReportPDF','PrintMonthlyAttendance','PrintNomineeList',
                    'PrintNomineeReportPDF','PrintPurchaseList','PrintPurchaseReportPDF','PrintTrainingList','PrintTrainingListPDF','PrintAnnualList',
                    'PrintAnnualListPDF','PrintTrainingPlan','PrintTrainingPlanPDF','getbranchmasterleave','getbranchemployee','getemployeeleave',
                    'getemployee','getmasterleave','getbranchbyemployee','getemployeebybranch','PrintExpenseList','PrintExpenseReportPDF','getemployeebydepartment', 'PrintBranchReport', 
                    'PrintinoutDocumentReport', 'PrintEosReport', 'Printleavehistorylist', 'PrintAttendanceOverTimeList','PrintEosClearanceList',
                    'PrintEmployeeLeaveListReport', 'Printsalarybefore', 'Printsalaryslip', 'Printsalaryincrement','getbranchemployeeforloan','employeedetailbydepartment','GetEmployeeList','getbranchmasterleaveformultiselect',
                    'employeedocumentdetailbydepartment','getbranchemployeedetails','PrintAttendancePunchHistoryList','ViewexpenseHRApproveView','TicketLedger','PrintAttendancenotPunchList',
                    'DownloadDocument','PrintsalaryAdvancelist','PrintMeetingList','ViewempCoordinates','Viewgeomap','getbranchadvemployee','PrintEmployeeWeekendList','PrintMonthlySalaryStatement','GetPrintMonthlyAttendanceReportList','getblockedbranchemployeedetails','PrintDepartmentHierarchyList'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionPrintAttendanceList() {

        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $attend_emp_sponsor = $_POST['branch_id'];
        $emp_id = trim($_POST['employee_id']);
        $department_id= $_POST['department_id'];
        if (isset($_POST['status'])) {
        $status = $_POST['status'];}
        else
        {
           $status=''; 
        }
       // $status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_attendance_list', array('status' => $status,'department_id' => $department_id, 'from_date' => $from_date,'to_date' => $to_date, 'attend_emp_sponsor' => $attend_emp_sponsor, 'emp_id' => $emp_id), false, true);
        if ($status == '') {
            //$this->renderPartial('//reports/print_employee_attendance_list', array('model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'attend_code' => $attend_code, 'month_id' => $month_id, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
        } else {
            //$this->renderPartial('//reports/print_employee_attendance_status_list', array('status'=>$status,'model' => $model, 'from_date' => $from_date, 'to_date' => $to_date, 'attend_code' => $attend_code, 'month_id' => $month_id, 'emp_id' => $emp_id, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
        }
    }

//    public function actionPrintAttendanceOverTimeList() {
//        $overtime_from_date = $_POST['from_date'];
//        $overtime_to_date = $_POST['to_date'];
//        $overtime_emp_sponsor = $_POST['branch_id'];
//        $emp_id = $_POST['employee_id'];
//        $overtime_type = $_POST['status'];
//        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
//        $this->renderPartial('//reports/print_employee_overtime_list', array('model' => $model, 'overtime_from_date' => $overtime_from_date,
//            'overtime_to_date' => $overtime_to_date, 'overtime_emp_sponsor' => $overtime_emp_sponsor, 'overtime_type' => $overtime_type, 'emp_id' => $emp_id), false, true);
//    }

    public function actionPrintMonthlyAttendanceReport() {


        $attend_emp_sponsor = $_POST['branch_id'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $model = '';
        $title = '';
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_monthly_attendance_list', array('model' => $model, 'year' => $year, 'month' => $month, 'attend_emp_sponsor' => $attend_emp_sponsor, 'title' => $title), false, true);
    }

    public function actionPrintEmployeeWorkingHoursReport() {

        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        $year = $_POST['year'];
        $month = $_POST['month'];
        $report_type = $_POST['type'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if ($report_type == 1) {
            $this->renderPartial('print_employee_daily_workingreport', array('model' => $model, 'employee_id' => $employee_id, 'branch_id' => $branch_id, 'month' => $month, 'year' => $year), false, true);
        } else if ($report_type == 2) {
            $this->renderPartial('print_employee_weekly_workingreport', array('model' => $model, 'employee_id' => $employee_id,'branch_id' => $branch_id, 'month' => $month, 'year' => $year), false, true);
        } else if ($report_type == 3) {
            $this->renderPartial('print_employee_monthly_workingreport', array('model' => $model, 'employee_id' => $employee_id,'branch_id' => $branch_id, 'month' => $month, 'year' => $year), false, true);
        }
    }

    public function actionPrintWeekendLeaves() {

        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        $year = $_POST['year'];
        $month = $_POST['month'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_weekendleave_report', array('model' => $model, 'employee_id' => $employee_id, 'branch_id' => $branch_id, 'month' => $month, 'year' => $year), false, true);
    }

    public function actionPrintAuditLog() {

        $date_from = $_POST['date_from'];
        $date_to = $_POST['date_to'];
        $branch_id = $_POST['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_auditlog_report', array('model' => $model, 'date_from' => $date_from, 'date_to' => $date_to, 'branch_id' => $branch_id), false, true);
    }

    public function actionPrintAttendanceYearlyLeaveList() {

        $employee_id = $_POST['employee_id'];
        $leave_type = $_POST['leave_type'];
        $year = $_POST['year'];
        $branch_id = $_POST['branch'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_leave_yearly_report', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'leavetype' => $leave_type, 'year' => $year), false, true);
    }

    public function actionPrintLeaveLedgerlist() {
        $leave_id = $_POST['leave_id'];
        $employee_id = $_POST['employee_id'];
        $year = $_POST['year'];
        $branch	 = $_POST['branch'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_leaveledgerlist', array('leave_id' => $leave_id, 'employee_id' => $employee_id, 'year' => $year,'branch'=>$branch), false, true);
    }

    public function actionPrintLeaveLedgerReportPDF() {
        $leave_id = Yii::app()->request->getParam('leave_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $branch = Yii::app()->request->getParam('branch');
        
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_leave_ledgerpdf', array('branch' => $branch, 'leave_id' => $leave_id, 'employee_id' => $employee_id, 'year' => $year), true));
        $mPDF1->Output('LeaveLedger.pdf', 'D');
    }
    public function actionPrintLeaveEncashmentReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.leave_enhancementpdf', array('model' => $model, 'branch_id' => $branch_id, 'employee_id' => $employee_id, 'year' => $year), true));
        $mPDF1->Output('leaveencashment.pdf', 'D');
    }
public function actionPrintLeaveEncashmentExcel() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        
        //echo $branch_id;
        $employee_id = Yii::app()->request->getParam('employee_id');
        $year = Yii::app()->request->getParam('year');
        $param = array(
            'branch_id' => $branch_id,
            'employee_id' => $employee_id,
            'year' => $year
        );
        $filename = 'LeaveEncashmentlist.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_leave_encashment_excel', array( 'branch_id' => $branch_id,'employee_id' => $employee_id,'year' => $year));
        Yii::app()->end();
    }
    /* public function actionPrintAttendanceYearlyLeaveList() {
      //$model = new Employeeleave();
      $branch_id=$_POST['branch_id'];
      $employee_id = $_POST['employee_id'];
      $leave_type= $_POST['leave_id'];
      $year = $_POST['year'];

      Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
      $this->renderPartial('//reports/print_leave_yearly_report', array('model' => $model,'branch_id'=>$branch_id,'employee_id' => $employee_id, 'leave_type' => $leave_type, 'year' => $year), false, true);

      } */

    public function actionProbationarylist() {

        $branch_id = $_POST['branch_id'];
        $to = $_POST['to'];
        $from = $_POST['from'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('probationary_list', array('branch_id' => $branch_id, 'to_date' => $to, 'from_date' => $from), false, true);
    }

    public function actionProbationarylistPDF() {
        $branch_id = $_GET['branch_id'];
        $to = $_GET['to_date'];
        $from = $_GET['from_date'];
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.probationary_list', array('branch_id' => $branch_id, 'to_date' => $to, 'from_date' => $from), true));
        $mPDF1->Output($htmlTemplate, 'D');
    }
    public function actionProbationarylistExcel(){
         $branch_id = $_GET['branch_id'];
        $to = $_GET['to_date'];
        $from = $_GET['from_date'];
         $filename = 'ProbationaryList.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/probationary_list', array('branch_id' => $branch_id, 'to_date' => $to, 'from_date' => $from));
        Yii::app()->end();


    }
    public function actionPrintEmployeeLeavelistYearlyReportPDF() {
        //$model = new Employeeleave();

        $branch_id = Yii::app()->request->getParam('branch_id');

        $leave_type = Yii::app()->request->getParam('leave_type');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.print_employee_leavelist_reportpdf', array('model' => $model, 'branch_id' => $branch_id, 'leave_type' => $leave_type, 'employee_id' => $employee_id, 'year' => $year), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }
     public function actionTicketEncashment() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $status_id = Yii::app()->request->getParam('status_id');
        $year = Yii::app()->request->getParam('year');
        $param = array(
            'branch_id' => $branch_id,
            'status_id' => $status_id,
            'year' => $year
        );
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('ticket_encashment', $param, false, true);
    }

    public function actionTicketEncashmentPDF() {
        //$model = new Employeeleave();
        $branch_id = Yii::app()->request->getParam('branch_id');
        $status_id = Yii::app()->request->getParam('status_id');
        $year = Yii::app()->request->getParam('year');
        $param = array(
            'branch_id' => $branch_id,
            'status_id' => $status_id,
            'year' => $year
        );
        ;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.ticket_encashment', $param, true));
        $mPDF1->Output('ticketencashment.pdf', 'D');
    }
    public function actionTicketEncashmentExcel() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $status_id = Yii::app()->request->getParam('status_id');
        $year = Yii::app()->request->getParam('year');
        $filename = 'ticketencashment.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('ticket_encashment_excel', array( 'branch_id' => $branch_id,'status_id' => $status_id,'year' => $year));
        Yii::app()->end();
    }
    public function actionPrintEncashmentDetails() {

        $employee_id = $_POST['employee_id'];
        $year = $_POST['year'];
        $branch_id = $_POST['branch'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_leave_encashment_report', array('branch_id' => $branch_id, 'employee_id' => $employee_id,'year' => $year), false, true);
    }
    public function actionTicketEntitlement() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $param = array(
            'branch_id' => $branch_id,
            'employee_id' =>$employee_id,
        );
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('ticket_entitlement', $param, false, true);
    }

    public function actionTicketEntitlementPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id= Yii::app()->request->getParam('employee_id');
        $param = array(
            'branch_id' => $branch_id,
            'employee_id' => $employee_id
        );
        ;
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.ticket_entitlement', $param, true));
        $mPDF1->Output('ticketdetails.pdf', 'D');
    }

    public function actionTicketEntitlementExcel() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $filename = 'ticketentitlement.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('ticket_entitlement_excel', array( 'branch_id' => $branch_id,'employee_id' => $employee_id));
        Yii::app()->end();
    }
    public function actionPrintYearLeavedetails() {

        $employee_id = $_POST['employee_id'];
        $year = $_POST['year'];
        $leavetype= $_POST['leavetype'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_leave_yearledger_report', array('leavetype' => $leavetype, 'employee_id' => $employee_id,'year' => $year), false, true);
    }
    public function actionPrintYearLeavedetailsPDF() {
        $leavetype = Yii::app()->request->getParam('leavetype');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.print_leave_yeardetails_report', array('leavetype' => $leavetype, 'employee_id' => $employee_id, 'year' => $year), true));
        $mPDF1->Output('leavedetails.pdf', 'D');
    }
    public function actionPrintLeaveBalancelist() {

        $employee_id = $_POST['employee_id'];
        $branch = $_POST['branch'];
        $leavetype= $_POST['leave_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_leave_balance_report', array('leavetype' => $leavetype, 'employee_id' => $employee_id,'branch' => $branch), false, true);
    }
    public function actionPrinLeaveBalancePDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $leavetype = Yii::app()->request->getParam('leavetype');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_leavebalance_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'leavetype' => $leavetype), true));
        $mPDF1->Output('leavereport.pdf', 'D');
    }
    public function actionPrintAdvancelist() {

        $employee_id = $_POST['employee_name'];
        $branch = $_POST['branch'];
        $status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_advance_report', array('status' => $status, 'employee_id' => $employee_id,'branch' => $branch), false, true);
    }
    public function actionPrintsalaryAdvancelist() {
        $employee_id = $_POST['employee_name'];
        $branch=''; 
        if(isset($_POST['branch_id']))
        {
        $branch = $_POST['branch_id'];
        }

        $status= $_POST['status'];
        $from_date= $_POST['from_date'];
        $to_date= $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_salary_advance_report', array('status' => $status, 'employee_id' => $employee_id,'branch' => $branch,'from_date' => $from_date,'to_date' => $to_date), false, true);
    }
    public function actionPrintAdvanceReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $status = Yii::app()->request->getParam('status');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_advance_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), true));
        $mPDF1->Output('advancereport.pdf', 'I');
    }
    public function actionPrintCompanyDocument() {
        $doc_id = $_POST['doc_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_companydocument', array('doc_id' => $doc_id), false, true);
    }
    public function actionPrintCompanyDocumentReportPDF() {
        $doc_id = Yii::app()->request->getParam('doc_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.company_document_pdf', array('doc_id' => $doc_id), true));
        $mPDF1->Output('company_document.pdf', 'D');
    }
    public function actionPrintMonthlyAttendance() {
        $branch_id = $_POST['branch_id'];
        $attendance_date = $_POST['attendance_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_monthly_attendance', array('branch_id' => $branch_id, 'attendance_date' =>$attendance_date), false, true);
    }
    public function actionPrintNomineeList() {

        $employee_id = $_POST['employee_id'];
        $branch = $_POST['branch_id'];
        $status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_nominee_report', array('status' => $status, 'employee_id' => $employee_id,'branch_id' => $branch), false, true);
    }
    public function actionPrintNomineeReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $status = Yii::app()->request->getParam('status');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_nominee_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'status' => $status), true));
        $mPDF1->Output('nomineereport.pdf', 'D');
    }
    public function actionPrintPurchaseList() {

        $employee_id = $_POST['employee_id'];
        $branch = $_POST['branch_id'];
        $date_from= $_POST['date_from'];
        $date_to= $_POST['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_purchase_report', array('date_to' => $date_to,'date_from' => $date_from, 'employee_id' => $employee_id,'branch_id' => $branch), false, true);
    }
    public function actionPrintPurchaseReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_purchase_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id,'date_to' => $date_to,'date_from' => $date_from), true));
        $mPDF1->Output('purchasereport.pdf', 'D');
    }
    public function actionPrintTrainingList() {

        $employee_id = $_POST['employee_id'];
        $course_id = $_POST['course_id'];
        $type= $_POST['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        if($type=='T'){
            $this->renderPartial('print_training_report', array('course_id' => $course_id), false, true);
        }else{
            $this->renderPartial('print_competency_report', array('employee_id' => $employee_id,'course_id' => $course_id), false, true);
        }
    }
    public function actionPrintTrainingListPDF() {
        $course_id = Yii::app()->request->getParam('course_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $type = Yii::app()->request->getParam('type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if($type=='T'){
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_training_pdf', array('course_id' => $course_id), true));
            $mPDF1->Output('traininglist.pdf', 'D');
        }else{
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_compentency_pdf', array('employee_id' => $employee_id,'course_id' => $course_id), true));
            $mPDF1->Output('competency_list.pdf', 'D');
        }
    }
    public function actionPrintAnnualList() {
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_annual_leave_report', array('employee_id' => $employee_id,'branch_id' => $branch_id), false, true);
    }
    public function actionPrintAnnualListPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_annual_leave', array('employee_id' => $employee_id,'branch_id' => $branch_id), true));
        $mPDF1->Output('competency_list.pdf', 'I');
    }
    public function actionPrintTrainingPlan() {

        $year = $_POST['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_training_plan', array('year' => $year), false, true);
        
    }
    public function actionPrintTrainingPlanPDF() {
        $year = Yii::app()->request->getParam('year');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_training_plan', array('year' => $year), true));
        $mPDF1->Output('traininglist.pdf', 'D');
    }
    public function actiongetbranchemployee() {
        $branch = $_POST['branch'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist("employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiongetbranchadvemployee() {
        $branch = $_POST['branch'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist("adv_employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiongetbranchmasterleave() {
       $branch = $_POST['branch'];
       $dropdownlist.=CHtml::dropdownlist('leave_name','',MasLeave::getParentLeave($branch), array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Name', 'empty' => 'Select', 'data-search' => true));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetemployeeleave() {
       $id = $_POST['id'];
       $branch=0;
       if($id>0){
            $model = Employee::model()->findByPk($id);
            $branch=$model->branch_or_sponsor_id;
       }
      
       $dropdownlist=CHtml::dropdownlist('leaveledger_type','',MasLeave::getLeavebytype($branch), array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Name', 'empty' => 'Select', 'data-search' => true));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetemployee() {
        $branch = $_POST['branch'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist("yearly_leave_employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiongetmasterleave() {
       $branch = $_POST['branch'];
      
       $dropdownlist=CHtml::dropdownlist('yearly_leave_type_id','',MasLeave::getParentLeave($branch), array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Name', 'empty' => 'Select', 'data-search' => true));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    public function actiongetbranchbyemployee() {
        $branch = $_POST['branch'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist("annual_employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiongetemployeebybranch() {
        $branch = $_POST['branch'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist("annual_employee_id", '', Employee::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    
    public function actionPrintExpenseList() {

        $employee_id = $_POST['employee_id'];
        $branch = $_POST['branch_id'];
        $date_from= $_POST['date_from'];
        $date_to= $_POST['date_to'];
        $status= $_POST['status'];
        $sort_field= $_POST['sort_field'];
        $sort_order= $_POST['sort_order'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_expense_report', array('date_to' => $date_to,'date_from' => $date_from, 'employee_id' => $employee_id,'branch_id' => $branch,'status' => $status,'sort_field' => $sort_field,'sort_order' => $sort_order), false, true);
    }
    
    public function actionDownloadDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_document = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
        $arr_doc_val = array();
        $total_docs=0;
        if (!empty($arr_employee_document)) {
            foreach ($arr_employee_document as $row) {
                $files= explode(',', $row->file);
                $arr_doc_val[] =$files;
                $total_docs += count($files);
                }
            }
        if ($total_docs >1) {
            $zip = new ZipArchive();
            $expense = EmployeeExpense::model()->findByPk($id);
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $this->ciphertext($expense['employeedetail']['first_name'], "d") . "_" . date('d-m-Y') . ".zip";
            if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                //for ($i = 0; $i < count($arr_doc_val); $i++) {
                foreach ($arr_doc_val as $key => $array) {
                    foreach ($array as $key2 => $value) {
                        $path = "uploads/expense/" . $value;
                        // Add the files to the .zip file
                        $zip->addFile($path, $value);
                    }
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
//            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $employeeexpensedetails = EmployeeExpenseDetails::model()->find(array('condition' => 'expense_id="' . $id . '" AND file!=""'));
            $file = $employeeexpensedetails->file;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/expense/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }

    public function actionPrintExpenseReportPDF() {
        $branch_id = Yii::app()->request->getParam('branch_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        $status= Yii::app()->request->getParam('status');
        $sort_field = Yii::app()->request->getParam('sort_field');
        $sort_order= Yii::app()->request->getParam('sort_order');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrreports.pdf.employee_expense_pdf', array('branch_id' => $branch_id, 'employee_id' => $employee_id,'date_to' => $date_to,'date_from' => $date_from,'status' => $status,'sort_field'=>$sort_field,'sort_order'=>$sort_order), true));
        $mPDF1->Output('expensereport.pdf', 'D');
    }
    public function actiongetemployeebydepartment() {
       $branch = $_POST['branch_id'];
       $department_id = $_POST['department_id'];
       $sql = "SELECT id, first_name,last_name,employee_code FROM erp_hr_employee WHERE isActive!='B'";
        if ($branch != "") {
            $sql.= " AND branch_or_sponsor_id IN(" . $branch . ")";
        }
        if (is_countable($department_id) && count($department_id) >= 1) {
            $department_id = implode(',', $department_id);
            $sql .= " AND department IN(" . $department_id . ")";
        }
        $model = Yii::app()->db->createCommand($sql)->queryAll();
        $arr_employee = array();
        $employee_details = array();
        if(!empty($model)){
            foreach ($model as $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). '-' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
        }
       $dropdownlist=CHtml::dropdownlist('employee_id','',CHtml::listData($employee_details, 'id', 'name'), array('class' => 'tooltipster', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true,'multiple'=>true));
       $jsonData['employee'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
    function decimalHours($time)
    {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1]/60) + ($hms[2]/3600));
    }
    public function actionPrintBranchReport() {
        $branchname = $_POST['branchname'];
        $location = $_POST['location'];
        $currency = $_POST['currency'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_branch_report', array('branchname' => $branchname, 'location' => $location, 'currency' => $currency), false, true);
    }

    public function actionPrintinoutDocumentReport() {
        $employee_id = $_POST['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_inout_document', array('employee_id' => $employee_id), false, true);
    }

    public function actionPrintEosReport() {
        $branch_id = $_POST['branch_id'];
        $employee_id = $_POST['employee_id'];
        $department_name = $_POST['department_name'];
        $designation_name = $_POST['designation_name'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('Print_eos_report', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_name' => $department_name, 'designation_name' => $designation_name, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintleavehistorylist() {
        $leave_id = $_POST['leave_id'];
        $employee_id = $_POST['employee_id'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_leavehistorylist', array('leave_id' => $leave_id, 'employee_id' => $employee_id, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintAttendanceOverTimeList() {
        $overtime_from_date = $_POST['from_date'];
        $overtime_to_date = $_POST['to_date'];
        $overtime_emp_sponsor = $_POST['branch_id'];
        $emp_id = $_POST['employee_id'];
        if (isset($_POST['status'])) {
       $overtime_type = $_POST['status'];}
        else
        {
           $overtime_type=''; 
        }
        
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_overtime_list', array('emp_id' => $emp_id, 'overtime_from_date' => $overtime_from_date, 'overtime_to_date' => $overtime_to_date, 'overtime_emp_sponsor' => $overtime_emp_sponsor, 'overtime_type' => $overtime_type), false, true);
    }

    public function actionPrintEmployeeLeaveListReport() {
        $branch_id = $_POST['branch_id'];
        $employee_id = $_POST['employee_id'];
        $leave_name = $_POST['leave_name'];
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('Print_employee_leavelist_report', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'leave_name' => $leave_name, 'from_date' => $from_date, 'to_date' => $to_date), false, true);
    }

    public function actionPrintsalarybefore() {
        $branch = $_POST['branch'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $category = $_POST['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('Print_salary_before', array('branch' => $branch, 'month' => $month, 'year' => $year, 'category' => $category), false, true);
    }

    public function actionPrintsalaryslip() {
        $branch = $_POST['branch'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $category = $_POST['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('Print_salary_slip', array('branch' => $branch, 'month' => $month, 'year' => $year, 'category' => $category), false, true);
    }

    public function actionPrintgrosssalary() {
        $branch = $_POST['branch'];
        $year = $_POST['year'];
        $category = $_POST['category'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_gross_salary', array('branch' => $branch, 'year' => $year, 'category' => $category), false, true);
    }

    public function actionPrintsalaryincrement() {
        $branch = $_POST['branch'];
        $employee_id = $_POST['employee_id'];
        $salary_type = $_POST['salary_type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('Print_salary_increment', array('branch' => $branch, 'employee_id' => $employee_id, 'salary_type' => $salary_type), false, true);
    }
    public function actiongetbranchemployeeforloan() {
        $branch = $_POST['branch'];
        if($branch==''){
            $branch=0;
        }
        $jsonData['employee'] = CHtml::dropdownlist("hr_report_employee_id_loan", '', EmployeeLoanDetail::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
    public function actionemployeedetailbydepartment() {
       $branch = $_POST['branch_id'];
       $department_id = $_POST['department_id'];
       $field_name = $_POST['field_name'];
       if(is_countable($department_id) && count($department_id)>0){
           $department_id=implode(',',$department_id);
       }
       $sql = "SELECT id, first_name,last_name,employee_code FROM erp_hr_employee WHERE isActive!='B'";
        if ($branch != "") {
            $sql.= " AND branch_or_sponsor_id IN(" . $branch . ")";
        }
        if ($department_id != "") {
            $sql.= " AND department IN(" . $department_id . ")";
        }
//        echo $sql;
        $model = Yii::app()->db->createCommand($sql)->queryAll();
        $arr_employee = array();
        $employee_details = array();
        if(!empty($model)){
            foreach ($model as $value) {
                $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). '-' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
            }
            ksort($arr_employee);
            $m = 0;
            foreach ($arr_employee as $k => $id) {
                $employee_details[$m]['id'] = $id;
                $employee_details[$m]['name'] = $k;
                $m++;
            }
        }
       $dropdownlist.=CHtml::dropdownlist($field_name,'',CHtml::listData($employee_details, 'id', 'name'), array('class' => 'tooltipster', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true,'multiple'=>true));
       $jsonData['employee'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }

    public function actionemployeedocumentdetailbydepartment() {
        $branch = $_POST['branch_id'];
        $department_id = $_POST['department_id'];
        $field_name = $_POST['field_name'];
        if(is_countable($department_id) && count($department_id)>0){
            $department_id=implode(',',$department_id);
        }
        $sql = "SELECT id, first_name,last_name,employee_code FROM erp_hr_employee WHERE isActive!='B'";
         if ($branch != "") {
             $sql.= " AND branch_or_sponsor_id IN(" . $branch . ")";
         }
         if ($department_id != "") {
             $sql.= " AND department IN(" . $department_id . ")";
         }
         $model = Yii::app()->db->createCommand($sql)->queryAll();
         $arr_employee = array();
         $employee_details = array();
         if(!empty($model)){
             foreach ($model as $value) {
                 $arr_employee[Yii::app()->controller->ciphertext($value['first_name'], "d") . ' ' . Yii::app()->controller->ciphertext($value['last_name'], "d"). '-' . Yii::app()->controller->ciphertext($value['employee_code'], "d")] = $value['id'];
             }
             ksort($arr_employee);
             $m = 0;
             foreach ($arr_employee as $k => $id) {
                 $employee_details[$m]['id'] = $id;
                 $employee_details[$m]['name'] = $k;
                 $m++;
             }
         }
        $dropdownlist.=CHtml::dropdownlist($field_name,'',CHtml::listData($employee_details, 'id', 'name'), array('class' => 'tooltipster', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true,'empty'=>'select'));
        $jsonData['employee'] = $dropdownlist;
        echo CJSON::encode($jsonData);
     }
 public function actiongetbranchemployeedetails() {
        //code added by rahul on 12-7-22//
        $branch = $_POST['branch_id'];
        $field_name = $_POST['field_name'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist($field_name, '', Employee::getEmployee($branch), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actiongetblockedbranchemployeedetails() {
        //code added by rahul on 12-7-22//
        $branch = $_POST['branch_id'];
        $department = $_POST['department_name'];
        $field_name = $_POST['field_name'];
        if ($branch > 0) {
            $jsonData['employee'] = CHtml::dropdownlist($field_name, '', Employee::getBlockedEmployee($branch,$department), array('empty' => 'Select', 'title' => 'Employee', 'data-label' => 'Employee', 'data-search' => true));
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
     public function actionPrintAttendancePunchHistoryList() {

        $from_date = $_POST['from_date'];
       
        $attend_emp_sponsor = $_POST['branch_id'];
        $emp_id = trim($_POST['employee_id']);
       
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_punch_history_list', array('from_date' => $from_date, 'attend_emp_sponsor' => $attend_emp_sponsor, 'emp_id' => $emp_id), false, true);
        
    }
    //view geocordinates added by nisha on 12-06-2023
      public function actionViewempCoordinates() {
        $id =Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_coordnintes_details', array('id'=>$id), false, true);
    }
    public function actionViewgeomap() {
        $latitude =Yii::app()->request->getParam('latitude');
        $longitude =Yii::app()->request->getParam('longitude');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_map_details', array('latitude'=>$latitude,'longitude'=>$longitude), false, true);
    }
    public function actionPrintMeetingList() {

        $employee_id = $_POST['employee_id'];
        $branch = $_POST['branch_id'];
        $date_from= $_POST['date_from'];
        $date_to= $_POST['date_to'];
        $status= $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_meeting_report', array('date_to' => $date_to,'date_from' => $date_from, 'employee_id' => $employee_id,'branch_id' => $branch,'status' => $status), false, true);
    }

    public function actionPrintEmployeeWeekendList() {
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_weekend_report', array('employee_id' => $employee_id, 'branch_id' => $branch_id), false, true);
    }
    public function actionPrintMonthlySalaryStatement() {
        $branch = $_POST['branch'];
        $month = $_POST['month'];
        $year = $_POST['year'];
        $payment_mode = $_POST['payment_mode'];
        $type = $_POST['type'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_monthly_salary_details', array('branch' => $branch, 'month' => $month, 'year' => $year, 'payment_mode' => $payment_mode, 'type' => $type), false, true);
    }

    public function actionGetPrintMonthlyAttendanceReportList() {
        $attend_emp_sponsor = (int) Yii::app()->request->getParam('branch_id');
        $month = Yii::app()->request->getParam('month');
        $year = Yii::app()->request->getParam('year');
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $condition = 't.isActive="Y" AND branch_or_sponsor_id="' . $attend_emp_sponsor . '"';
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.de_first_name asc'));
        $recordsTotal = $count;  // Total records without any filter
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $date = $year . '-' . $month . '-01';
        $month_start_date=$date;
        $lastday = date('t', strtotime($date));
        $last_date = $year . '-' . $month . '-' . $lastday;
        $date_fm = $year . '-' . $month . '-01';
        $days = cal_days_in_month(CAL_GREGORIAN, $month, $year);
        if (!empty($model)) {
            foreach ($model as $empdetail) {
                $total_present = 0;
                $total_medical = 0;
                $total_weekend = 0;
                $total_annual = 0;
                $total_complementary_leave = 0;
                $total_maternity_leave = 0;
                $total_holiday = 0;
                $total_absent = 0;
                $total_emergency = 0;
                $total = 0;
                $total_var = 0;
                $total_leave = 0;
                $employee_code = $empdetail->employeecode;
                $employee_name = $empdetail->employeefullname;
                $personal_file_no = $empdetail->personal_file_no;
                $str_attendance = array();
                if (($empdetail->date_blocked!='0000-00-00' && $empdetail->date_unblocked=='0000-00-00')?(strtotime($month_start_date) <= strtotime($empdetail->date_blocked)):true){
                    for ($i = 1; $i <= $days; $i++) {
                        $date = $year . '-' . $month . '-' . $i;
                        if (strtotime($date) >= strtotime($empdetail->date_join) && (($empdetail->date_blocked!='0000-00-00' && $empdetail->date_unblocked=='0000-00-00')?(strtotime($date) <= strtotime($empdetail->date_blocked)):true)) {
                            $model_attendance_detail = EmployeeAttendance::model()->find(array('condition' => 'attendance_date="' . $date . '" and employee_id="' . $empdetail->id . '"'));
                            $attendance = '';
                            $tr_class = '';
                            $varience = '';
                            if (!empty($model_attendance_detail)) {
                                if ($model_attendance_detail->status == 1) {
                                    $attendance = "P";
                                    $tr_class = 'class="bg-present"';
                                    $total_present++;
                                    $start = '-:-';
                                    $end = '-:-';
                                    if ($model_attendance_detail->shift_id > 0) {
                                        $model_shift = EmployeeShift::model()->findByPK($model_attendance_detail->shift_id);
                                        $emp_shift = MasShift::model()->findByPk($model_shift->shift_id);
                                        $start = $emp_shift->start_time;
                                        $end = $emp_shift->end_time;
                                    } else {
                                        $model_company_shift = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                                        $start = date("H:i", strtotime($model_company_shift->workstart_time));
                                        $end = date("H:i", strtotime($model_company_shift->workend_time));
                                    }
                                    $weekvalue = date('w', strtotime($date));
                                    $weekvalue += 1;
                                    if ($empdetail->weekend_off1 == $weekvalue) {
                                        if ($empdetail->weekend_off1_type == 'H') {
                                            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                                            $start = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                                            $end = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                                        }
                                    }
                                    if ($empdetail->weekend_off2 == $weekvalue) {
                                        if ($empdetail->weekend_off2_type == 'H') {
                                            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                                            $start = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                                            $end = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                                        }
                                    }
                                    if ($empdetail->weekend_off3 == $weekvalue) {
                                        if ($empdetail->weekend_off3_type == 'H') {
                                            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($empdetail->branch_or_sponsor_id);
                                            $start = date("H:i", strtotime($model_branch_time->weekend_work_starttime));
                                            $end = date("H:i", strtotime($model_branch_time->weekend_work_endtime));
                                        }
                                    }
                                    if ($start != '-:-') {
                                        $shift_in_time = strtotime($start);
                                        $shift_out_time = strtotime($end);
                                        $from_time = strtotime($model_attendance_detail->login_time);
                                        $to_time = strtotime($model_attendance_detail->logout_time);
                                        $actual_diff = $to_time - $from_time;
                                        $shift_diff = $shift_out_time - $shift_in_time;
                                        //varience
                                        if ($shift_diff < $actual_diff) {
                                            $time_variance = $actual_diff - $shift_diff;
                                            $varience = '+' . gmdate('H:i', $time_variance);
                                            $total_var += $time_variance;
                                        }
                                        if ($shift_diff > $actual_diff) {
                                            $time_variance = $shift_diff - $actual_diff;
                                            $varience = '-' . gmdate('H:i', $time_variance);
                                            $total_var -= $time_variance;
                                        }
                                    } else {
                                        $varience = '00:00';
                                        $total_var += 0;
                                    }
                                } else if ($model_attendance_detail->status == 2) {

                                    $attendance = "AB";
                                    $tr_class = 'class="bg-absent text-bold"';
                                    $total_absent++;
                                } else if ($model_attendance_detail->status == 3) {
                                    //$attendance="L";
                                    $total_leave++;
                                    $tr_class = 'class="bg-medical"';
                                    $attendance = $model_attendance_detail->leave->leavetype->leave_abbreviation;
                                    /* $leave_type      = MasLeave::model()->findbypk($model_attendance_detail->leave_id);

                                      if(!empty($leave_type->leave_name)){
                                      $attendance_type.= "( ".$leave_type->leave_name." )";
                                      } */
                                } else if ($model_attendance_detail->status == 4) {

                                    $attendance = "HD";
                                    $tr_class = 'class="bg-holiday"';
                                    $total_holiday++;
                                } else if ($model_attendance_detail->status == 5) {

                                    $attendance = "FW";
                                    $tr_class = 'class="bg-weekend"';
                                    $total_weekend++;
                                }
                            } else if (strtotime($date) >= strtotime($empdetail->date_join)) {
                                $model_holiday = MasHoliday::model()->find(array('condition' => 'holiday_date="' . $date . '"'));
                                if (!empty($model_holiday)) {
                                    $attendance = "HD";
                                    $tr_class = 'class="bg-holiday"';
                                    $total_holiday++;
                                } //End holiday
                                if ($attendance == '') {
                                    $arr_leave_details = EmployeeLeaveDetail::model()->find(array('condition' => '(leave_start_date <="' . $date . '" and leave_end_date >="' . $date . '") AND employee_id="' . $empdetail->id . '" and leave_status="4"'));
                                    //MasLeave::model()->findbypk($arr_leave_details->leave_type);

                                    if (!empty($arr_leave_details)) {
                                        $total_leave++;
                                        $attendance = $arr_leave_details->leavetype->leave_abbreviation;
                                        $tr_class = 'class="bg-medical"';
                                        $title = $arr_leave_details->leavetype->leave_name;
                                    } else {
                                        $title = '';
                                    }
                                }
                                if ($attendance == '') {
                                    $weekvalue = date('w', strtotime($date));
                                    $weekvalue += 1;
                                    if ($empdetail->weekend_off1 == $weekvalue) {
                                        if ($empdetail->weekend_off1_type == 'H') {
                                            $attendance = "HW";
                                        } else if ($empdetail->weekend_off1_type == 'F') {
                                            $attendance = "FW";
                                        }
                                        $tr_class = 'class="bg-weekend"';
                                        $total_weekend++;
                                    }
                                    if ($empdetail->weekend_off2 == $weekvalue) {
                                        if ($empdetail->weekend_off2_type == 'H') {
                                            $attendance = "HW";
                                        } else if ($empdetail->weekend_off2_type == 'F') {
                                            $attendance = "FW";
                                        }
                                        $tr_class = 'class="bg-weekend"';
                                        $total_weekend++;
                                    }
                                    if ($empdetail->weekend_off3 == $weekvalue) {
                                        if ($empdetail->weekend_off3_type == 'H') {
                                            $attendance = "HW";
                                        } else if ($empdetail->weekend_off3_type == 'F') {
                                            $attendance = "FW";
                                        }
                                        $tr_class = 'class="bg-weekend"';
                                        $total_weekend++;
                                    }
                                }
                                if ($attendance == '') {
                                    $current_date = date('Y-m-d');
                                    if (strtotime($date) <> strtotime($current_date)) {
                                        $attendance = "AB";
                                        $tr_class = 'class="bg-absent text-bold"';
                                        $total_absent++;
                                    } else {
                                        $attendance = "AB";
                                        $tr_class = 'class="bg-absent text-bold"';
                                        $total_absent++;
                                    }
                                }
                            }
                            $str_attendance[] = '<span ' . $tr_class . '>' . $attendance . '</span>';
                        }else{
                            $str_attendance[] = '<span ' . $tr_class . '>-</span>';
                        }
                    }
                    $total += $total_present;
                    $total += $total_holiday;
                    $total += $total_absent;
                    $total += $total_weekend;
                    $total += $total_leave;
                    if ($total_var >= 0) {
                        $total_varience = '+' . gmdate('H:i', $total_var);
                    } else {
                        $total_varience = '-' . gmdate('H:i', abs($total_var));
                    }
                    $arr_data = array();
                    $arr_data[] = $employee_code;
                    $arr_data[] = $employee_name;
                    $arr_data[] = $personal_file_no;
                    foreach ($str_attendance as $eachAttendance) {
                        $arr_data[] = $eachAttendance;
                    }
                    $arr_data[] = $total_present;
                    $arr_data[] = $total_absent;
                    $arr_data[] = $total_holiday;
                    $arr_data[] = $total_weekend;
                    $arr_data[] = $total_leave;
                    $arr_data[] = $total;
                    $arr_data[] = $total_varience;
                    $rowData[] = $arr_data;
                }
            }

             $data['data'] = $rowData;
             $data['draw'] = $draw;
             $data['recordsTotal'] = $recordsTotal;
             $data['recordsFiltered'] = $recordsFiltered;
            echo json_encode($data);
        }
    }
    
    public function actionPrintDepartmentHierarchyList() {
        $department = $_POST['department'];
        $functionality_id = $_POST['functionality_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_departement_hierarchylist', array('department' => $department, 'functionality_id' => $functionality_id), false, true);
    }
    public function actionTicketLedger() {
        $employee_id = $_POST['employee_id'];
        $year = $_POST['year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_ticketledger', array('employee_id' => $employee_id, 'year' => $year), false, true);
    }
    public function actionPrintEosClearanceList() {
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_eos_clearance', array('employee_id' => $employee_id, 'branch_id' => $branch_id), false, true);
    }
     public function actionPrintAttendancenotPunchList() {
        $from_date = $_POST['from_date'];
        $attend_emp_sponsor = $_POST['branch_id'];
        $employee_id = trim($_POST['employee_id']);
        $sort_type = trim($_POST['sort_type']);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_not_punch_list', array('from_date' => $from_date, 'attend_emp_sponsor' => $attend_emp_sponsor, 'employee_id' => $employee_id,'sort_type'=>$sort_type), false, true);
        
    }
    public function actionGetEmployeeList() {
        $field_name = $_POST['field_name'];
        $branch = $_POST['branch_id'];
        $department_id = $_POST['department_id'];
        $designation_id = $_POST['designation_id'];
        $team_id = $_POST['team_id'];
        $condition = '1=1';
        if ($branch != "") {
            if (is_countable($branch)&& count($branch) > 0) {
                $branch = implode(',', $branch);
            }
            $condition .= " AND branch_or_sponsor_id IN(" . $branch . ")";
        }
        if(is_countable($department_id) && count($department_id)>0){
           $department_id=implode(',',$department_id);
       }
        if ($department_id != "") {
            $condition.= " AND department IN(" . $department_id . ")";
        }
        if ($designation_id > 0) {
            $condition .= ' AND designation="' . $designation_id . '"';
        }
        if ($team_id > 0) {
            $condition .= ' AND team_id="' . $team_id . '"';
        }
        $model = Employee::model()->findAll(array('condition' => $condition, 'order' => 'de_first_name asc'));
        $dropdownlist= CHtml::dropdownlist($field_name, '', CHtml::listData($model, 'id', 'employeefullname'), array('class' => 'tooltipster', 'title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true, 'multiple' => true));
        $jsonData['employee'] = $dropdownlist;
        echo CJSON::encode($jsonData);
    }
    public function actiongetbranchmasterleaveformultiselect() {
        $field_name = $_POST['field_name'];
        $branch = $_POST['branch_id'];
        if ($branch != "") {
            if (count($branch) > 0) {
                $branch = implode(',', $branch);
            }
        }
        $dropdownlist .= CHtml::dropdownlist($field_name, '', MasLeave::getLeavebybranchnameformultiselect($branch), array('class' => 'tooltipster', 'title' => 'Leave Type', 'data-label' => 'Leave Name', 'empty' => 'Select', 'data-search' => true));
        $jsonData['leave'] = $dropdownlist;
        echo CJSON::encode($jsonData);
    }
}
