<?php

class HronboardingController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Savedetails','deletetask','OffIndex','Saveoffdetails','deleteofftask','loadbranch','offboardindex','GetEmployeeList','OffCreate','Saveoffboarddetails',
                    'Editoffboard'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        $model= HrMasOnboarding::model()->findAll();
        if(empty($model)){
            $model=array(new HrMasOnboarding()); 
        }            
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSavedetails() {
        if (isset($_POST['HrMasOnboarding'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");		
            foreach ($_POST['HrMasOnboarding'] as $i => $items) {
                if($items['id']>0){
                    $model[$i] = HrMasOnboarding::model()->findByPK($items['id']); 
                    $model[$i]->scenario = 'update';
                    $model[$i]->updated_by= Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model[$i] = new HrMasOnboarding(); 
                    $model[$i]->scenario = 'add';
                    $model[$i]->created_by= Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }   		
                $model[$i]->task_description = $items['task_description'];	
                $valid=$model[$i]->validate() && $valid;

            }
            if($valid){
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actiondeletetask(){
        $id = $_POST['id'];
        if($id>0){
            HrMasOnboarding::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionOffIndex()
    {
        $model= HrMasOffboarding::model()->findAll();
        if(empty($model)){
            $model=array(new HrMasOffboarding()); 
        }            
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('index_off', array('model' => $model), false, true);
    }
    public function actionSaveoffdetails() {
        if (isset($_POST['HrMasOffboarding'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");		
            foreach ($_POST['HrMasOffboarding'] as $i => $items) {
                if($items['id']>0){
                    $model[$i] = HrMasOffboarding::model()->findByPK($items['id']); 
                    $model[$i]->scenario = 'update';
                    $model[$i]->updated_by= Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model[$i] = new HrMasOffboarding();  
                    $model[$i]->scenario = 'add';
                    $model[$i]->created_by= Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }   		
                $model[$i]->task_description = $items['task_description'];	
                $valid=$model[$i]->validate() && $valid;

            }
            if($valid){
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
    public function actiondeleteofftask(){
        $id = $_POST['id'];
        if($id>0){
            HrMasOffboarding::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionloadbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
    public function actionoffboardindex() {
         if (isset(Yii::app()->user->haveHrPermissionOn['hr_off_boarding_menu']) || Yii::app()->user->authorised_user == 1) {
            $en_id = Yii::app()->request->getParam('id');
            $branch =$this->ciphertext($en_id,"d");
            if($branch!=''){
                $model = new HrMasOffboarding();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('off_board', array('model' => $model,'branch'=>$branch));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEmployeeList(){
        $model=new HrEmployeeOffboard();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $branch_id = $_POST['branch_id'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'t.id',
            1 =>'employeedetail.employee_code',
            2 =>'employeedetail.first_name',
            3 =>'created_date_time',
            4=>''
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $searchString_en=$this->ciphertext($searchString,"e");
          $condition.=" and (employeedetail.id LIKE '%".$searchString."%' OR employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR middle_name LIKE '%".$searchString_en."%' OR last_name LIKE '%".$searchString_en."%')";
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition,'group'=>'employee_id'));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'group'=>'employee_id','order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_off_boarding_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/hronboarding/editoffboard&id='.$row['employee_id'].'\',\''.$row['employeedetail']['employeecode'].'-Edit Offboarding \',\'xl\')"><i class="fa fa-edit"></i></button>';
            }
            $created_date_time="";
            if($row['created_date_time']!='' && $row['created_date_time']!='0000-00-00'){
                $created_date_time=date("d/m/Y",strtotime($row->created_date_time));
            }
            $rowData[]=array($m,$row['employeedetail']['employeecode'],$row['employeedetail']['employeefullname'],$created_date_time,$button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionOffCreate(){
        $branch = Yii::app()->request->getparam("branch");
        $model_master= HrMasOffboarding::model()->findAll();
        $model_dtl=new HrEmployeeOffboard(); 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('off_board_create', array('model_master'=>$model_master,'model_dtl'=>$model_dtl,'branch'=>$branch), false, true);                                    
    }
    public function actionEditoffboard(){
        $id=(int) Yii::app()->request->getParam('id');
        $model_master= HrMasOffboarding::model()->findAll();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('off_board_edit', array('model_master'=>$model_master,'id'=>$id), false, true);                                    
    }
    public function actionSaveoffboarddetails() {
        if (isset($_POST['HrEmployeeOffboard'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");		
            foreach ($_POST['HrEmployeeOffboard'] as $i => $items) {
                if($items['id']>0){
                    $model[$i] = HrEmployeeOffboard::model()->findByPK($items['id']);   
                    $model[$i]->updated_by= Yii::app()->user->id;
                    $model[$i]->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model[$i] = new HrEmployeeOffboard();   
                    $model[$i]->created_by= Yii::app()->user->id;
                    $model[$i]->created_date_time = date('Y-m-d H:i:s');
                }   		
                $model[$i]->employee_id = $_POST['employee_id'];
                $model[$i]->task_id = $items['task_id'];
                $model[$i]->task = $items['task'];
                if (isset($items['notes'])) {
                $model[$i]->notes = $items['notes'];
                  }
                if ($items['task_status'] == 1) {
                    $model[$i]->task_status = 'Y';
                } else {
                    $model[$i]->task_status = 'N';
                }
                if ($items['task_done_date']!= '0000-00-00' && $items['task_done_date']!= '') {
                     $model[$i]->task_done_date = date("Y-m-d", strtotime(str_replace('/', '-',$items['task_done_date'])));
                }
                $valid=$model[$i]->validate() && $valid;

            }
            if($valid){
                if (!empty($model)) {
                    foreach ($model as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error1 = json_decode(CActiveForm::validateTabular($model, '', false), true);
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
}
