<?php

class HrnotificationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'create', 'GetList', 'Save', 'deletenotification', 'GetEmployee','NoticeIndex','NoticeDocument',
                                    'GetNoticeList','CreateconductNotice','SaveConduct','UploadconductNotice','SaveNoticeDocument','UploadDocument',
                                    'downloadnoticedocument','ConductIndex','GetConductNoticeList','uploadsignedconductNotice','SavesignedNoticeDocument','DeleteSignednoticeDocument',
                                    'downloadsignednoticedocument','PrintCertificate'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    
    public function actionIndex() {
        $model_module_staffboard = HrModules::model()->findByPK(22);
        if ($model_module_staffboard->grant_access == 1 && $model_module_staffboard->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_notification_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionCreate() {
        $model = new HrNotification();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model));
    }

    public function actionSave() {        
        if (isset($_POST['HrNotification'])) {        
            $model = new HrNotification();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['HrNotification']['id'] > 0) {
                $model = HrNotification::model()->findByPK($_POST['HrNotification']['id']);
                $model->id = (int) $_POST['HrNotification']['id'];
            }
            $model->attributes = $_POST['HrNotification'];
            if (isset($_POST['HrNotification']['department_id']) && is_array($_POST['HrNotification']['department_id'])) {
                $model->department_id = implode(',', $_POST['HrNotification']['department_id']);
            } else {
                $model->department_id = '';//$_POST['HrNotification']['department_id'];
            }
            $model->designation = (isset($_POST['HrNotification']['designation']) && is_array($_POST['HrNotification']['designation']))?implode(',', $_POST['HrNotification']['designation']):'';//$_POST['HrNotification']['designation'];
            $model->branch = (isset($_POST['HrNotification']['branch']) && is_array($_POST['HrNotification']['branch']))?implode(',', $_POST['HrNotification']['branch']):'';//$_POST['HrNotification']['branch'];
            $model->employee_id = (isset($_POST['HrNotification']['employee_id']) && is_array($_POST['HrNotification']['employee_id']))?implode(',', $_POST['HrNotification']['employee_id']):'';//$_POST['HrNotification']['employee_id'];
            $model->date = date('Y-m-d H:i:s');
            $model->from_user = Yii::app()->user->id;
            if ($model->save()) {
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="30"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController'); 
                         MailController::sendmail(30,0,$model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetList() {
        $model = new HrNotification();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'date',
            2 => 'branch',
            3 => 'department_id',
            4 => 'employee_id',
            5 => 'designation',
            6 => 'title',
            7 => 'content',
            8=> 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1'; 
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (content LIKE '%" . $searchString . "%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and t.branch IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $edit_button=$delete_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_notification_edit'])  || Yii::app()->user->authorised_user == 1) {
                $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/hrnotification/create&id=' . $row['id'] . '\',\'Edit Notifications \',\'lg\')"><i class="fa fa-pencil"></i></button>';
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_notification_delete'])  || Yii::app()->user->authorised_user == 1) {
                $div .= '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletnotification(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                $delete_button=1;
            }
            $branch = '';
            $Department = '';
            $employee = '';
            $Designation = '';
            if ($row->branch != '') {
                $branch_array = MasCompanyBranchSponsor::model()->findAll(array('condition' => 't.id IN(' . $row->branch . ')'));
                foreach ($branch_array as $value) {
                    if ($branch != '') {
                        $branch .=", ";
                    }
                    $branch .= $value->branch_or_sponsor_name;
                }
            }
            if ($row->department_id != '') {
                $department_array = MasDepartment::model()->findAll(array('condition' => 't.id IN(' . $row->department_id . ')'));
                foreach ($department_array as $value) {
                    if ($Department != '') {
                        $Department .=", ";
                    }
                    $Department .= $value->department_name;
                }
            }


            if ($row->designation != '') {
                $Designation_array = MasDesignation::model()->findAll(array('condition' => 't.id IN(' . $row->designation . ')'));
                foreach ($Designation_array as $value) {
                    if ($Designation != '') {
                        $Designation .=", ";
                    }
                    $Designation .= $value->designation_name;
                }
            }

            if ($row->employee_id != '') {
                $employee_array = Employee::model()->findAll(array('condition' => 't.id IN(' . $row->employee_id . ')', 'limit' => '4'));

                $limiting = 0;
                foreach ($employee_array as $value) {
                    $limiting++;
                    if ($employee != '') {
                        $employee .=", ";
                    }
                    $employee .=$this->ciphertext($value->first_name, 'd');
                    $employee .=" " . $this->ciphertext($value->middle_name, "d");
                    $employee .=" " . $this->ciphertext($value->last_name, "d");
                    if ($limiting == 2)
                        break;                     
                    }
                if (count($employee_array) > 2) {
                    $employee .= ",....";
                }
            }
            
            $rowData[] = array(
                                $m,
                                date("d/m/Y", strtotime($row['date'])),
                                $branch,
                                $Department,
                                $employee,
                                $Designation,
                                substr($row['title'], 0, 30) . '...',
                                substr($row['content'], 0, 50) . '...',
                                array('id'=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button)
                        );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionDeleteNotification() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new HrNotification();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }
    public function actionGetEmployee(){
        $department = Yii::app()->request->getParam('department');
        $branch = Yii::app()->request->getParam('branch');
        $designation = Yii::app()->request->getParam('designation');
        $model_n = new HrNotification();
        echo '<div id="emp_id">' . CHtml::activedropdownlist($model_n, 'employee_id', Employee::getEmployeebyfilter($branch,$department,$designation), array('data-search' => 'true','class'=>'notifyEmp', 'selected' => 'selected', 'data-label' => 'Employee <span style="color:red">*</span>', 'multiple' => 'multiple'));
        echo "</div>";
    }

    //Notice of Conduct
    public function actionNoticeIndex() {
        $model_module_notice_conduct = HrModules::model()->findByPK(24);
        if ($model_module_notice_conduct->grant_access == 1 && $model_module_notice_conduct->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_noticeofconduct_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('notice_index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetNoticeList() {
        $model = new EmployeeNoticeConduct();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.branch_or_sponsor_id',
            2 => 'type',
            3 => 'employeedetail.employee_code',
            4 => 'employeedetail.first_name',
            5 => 'employeedetail.department',
            6 => 'employeedetail.designation',
            7 => 't.id',
            8 => 'reason',
            9=>'t.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1'; 
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $type=array(1=>'Notice of Conduct',2=>'Warning(Non Performance)',3=>'Warning Letter');
        foreach ($model as $row) {
            $button_string = '';
            $conduct_signed_download=$conduct_edit=$conduct_notice_print=$conduct_print=$conduct_upload=$conduct_download=$conduct_signed_download=0;
            if($row->notice_document==''){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_notice_conduct_edit'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/hrnotification/createconductnotice&id=' . $row['id'] . '\',\'Edit Notifications \',\'lg\')"><i class="fa fa-pencil"></i></button>&nbsp;';
                    $conduct_edit=1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_notice_conduct_print'])  || Yii::app()->user->authorised_user == 1) {
                    if ($row->type==1){
                        $button_string.= '<a href="?r=hr/hrnotification/noticedocument&id=' . $row['id'] . '" title="Print Notice of Conduct" target="_blank"><button class="btn btn-primary btn-xs" title="Print Notice of Conduct" ><i class="fa fa-print"></i></button></a>&nbsp;';                     
                        $conduct_notice_print=1;
                    }else{
                        $button_string.= '<button class="btn btn-primary btn-xs" title="Print & Verify Certificate(PDF)" onclick="loadPopupModal(\'hr/hrnotification/printcertificate&id=' . $row['id'] . '\',\'PRINT & VERIFY Document \',\'md\')"><i class="fa fa-file-pdf-o"></i></button> &nbsp;';
                        $conduct_print=1;
                    }
                }
                $model_upload_conduct = HrMasterUpload::model()->findByPK(29);
                if($model_upload_conduct->isActive=='Y'){ 
                    if (isset(Yii::app()->user->haveHrPermissionOn['hr_notice_conduct_upload'])  || Yii::app()->user->authorised_user == 1) {
                        $button_string .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/hrnotification/uploadconductNotice&id=' . $row['id'] . '\',\'Upload \',\'lg\')" title="Upload Notice of Conduct Document"><i class="fa fa-upload"></i></button>&nbsp;';
                        $conduct_upload=1;
                    }
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_notice_conduct_download'])  || Yii::app()->user->authorised_user == 1) {
                if($row->notice_document!=''){
                    $button_string.= '<a href="?r=hr/hrnotification/downloadnoticedocument&id=' . $row['id'] . '" title="Download" target="_blank"><button class="btn btn-primary btn-xs" title="Download Document" ><i class="fa fa-download"></i></button></a>&nbsp;';        
                    $conduct_download =1;
                }
                if($row->signed_notice_document!=''){
                    $button_string.= '<a href="?r=hr/hrnotification/downloadsignednoticedocument&id=' . $row['id'] . '" title="Download Signed Document" target="_blank"><button class="btn btn-primary btn-xs" title="Download Signed Document" ><i class="fa fa-download"></i></button></a>&nbsp;';        
                    $conduct_signed_download =1;
                }
            }
            
            $rowData[] = array($m,$row->employeedetail->branch_sponsor->branch_or_sponsor_name,$type[$row->type],$this->ciphertext($row->employeedetail->employee_code, "d"), $this->ciphertext($row->employeedetail->first_name, "d") . ' ' . $this->ciphertext($row->employeedetail->last_name, "d"),
                                $row->employeedetail->departmentdetail->department_name,$row->employeedetail->designationdetail->designation_name,date("d/m/Y", strtotime($row['created_date_time'])),
                                substr($row['reason'], 0, 50) . '...',
                                array('id'=>$row['id'],'conduct_signed_download'=>$conduct_signed_download,'conduct_edit'=>$conduct_edit,'conduct_notice_print'=>$conduct_notice_print,'conduct_print'=>$conduct_print,'conduct_upload'=>$conduct_upload,'conduct_download'=>$conduct_download,'conduct_signed_download'=>$conduct_signed_download)
                        );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateconductNotice() {
        $model = new EmployeeNoticeConduct();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_conduct_notice', array('model' => $model));
    }
    public function actionSaveConduct() {  
        $other=array();
        if (isset($_POST['EmployeeNoticeConduct'])) {        
            $model = new EmployeeNoticeConduct();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeNoticeConduct']['id'] > 0) {
                $model = EmployeeNoticeConduct::model()->findByPK($_POST['EmployeeNoticeConduct']['id']);
                $model->id = (int) $_POST['EmployeeNoticeConduct']['id'];
            }
            $model->attributes = $_POST['EmployeeNoticeConduct'];
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->created_by = Yii::app()->user->id;
            $type = $_POST['EmployeeNoticeConduct']['type'];
            if($type!=1){
                if($type==2){
                   if($_POST['EmployeeNoticeConduct']['month'] ==''){
                       $other[]='Please select a month';
                   }
                }else if($type==3){
                    if($_POST['EmployeeNoticeConduct']['month_1_amount'] ==0&&$_POST['EmployeeNoticeConduct']['month_2_amount'] ==0&&$_POST['EmployeeNoticeConduct']['month_2_amount'] ==0){
                       $other[]='Please add any amount';
                   }
                }
                $model_notice_reference_no = EmployeeNoticeConduct::model()->find(array('select' => 'max(reference_no) as reference_no', 'condition' => 'type!="1"'));
                if (empty($model_notice_reference_no) && $model_notice_reference_no->reference_no == '') {
                    $model_master_certificate = MasCertificate::model()->findByPk(7);
                    $ref_no = $model_master_certificate->reference_no;
                } else {
                    $ref_no = $model_notice_reference_no->reference_no + 1;
                }
                $model->reference_no=$ref_no;
            }else{
                $model->warning_type = $_POST['EmployeeNoticeConduct']['warning_type'];
                $model->signed_notice_document = $_POST['EmployeeNoticeConduct']['signed_notice_document'];
                if ($_POST['EmployeeNoticeConduct']['issued_date'] != '' && $_POST['EmployeeNoticeConduct']['issued_date'] != '0000-00-00') {
                     $model->issued_date = str_replace('/', '-', $_POST['EmployeeNoticeConduct']['issued_date']);
                    $model->issued_date = date('Y-m-d', strtotime($model->issued_date ));
                }else{
                    $model->issued_date = date('Y-m-d');  
                }
            }
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1,$other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionNoticeDocument() {
        $id= Yii::app()->request->getParam('id');        
        if($id==''){
            $id = $_POST['EmployeeNoticeConduct']['id'];
            $model_master_certificate = MasCertificate::model()->findByPk(7);                
            $signature_array = array();
            if (isset($_POST['field'])) {
                $signature = $_POST['field'];
                foreach ($signature as $value) {
                    $signature_array[] = $value;
                }
            }
        }
        $model_notice=EmployeeNoticeConduct::model()->findbyPK($id);
        $ref_no =$model_notice->reference_no;
        if(isset($_POST['EmployeeNoticeConduct']['subject'])){
        $model_notice->subject =$_POST['EmployeeNoticeConduct']['subject'];
        }
        $model_notice->warning_field_1 =$_POST['EmployeeNoticeConduct']['warning_field_1'];
        if(isset($_POST['EmployeeNoticeConduct']['warning_field_2'])){
        $model_notice->warning_field_2 =$_POST['EmployeeNoticeConduct']['warning_field_2'];
        }
        $model_notice->save(false);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if($model_notice->type==3){
          //  $mPDF1->SetWatermarkImage('uploads/logo/'.$model_notice->employeedetail->branch_sponsor->watermark_logo,0.2,'','F');
          //  $mPDF1->showWatermarkImage = true;
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.warning_letter', array('id'=>$id,'model_notice'=>$model_notice,  'ref_no' => $ref_no,'signature' => $signature_array,'model_master_certificate'=>$model_master_certificate), true));
            $mPDF1->Output('Warning Letter.pdf', 'I');
        }else if($model_notice->type==2){
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.warning_letter_unauthorized', array('id'=>$id,'model_notice'=>$model_notice, 'ref_no' => $ref_no,'signature' => $signature_array,'model_master_certificate'=>$model_master_certificate), true));
           // $mPDF1->SetWatermarkImage('uploads/logo/'.$model_notice->employeedetail->branch_sponsor->watermark_logo,0.2,'','F');
          //  $mPDF1->showWatermarkImage = true;
            $mPDF1->Output('Warning Letter-Performance.pdf', 'I');            
        }else{
            $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.notice_conduct', array('id'=>$id,'model_notice'=>$model_notice), true));
            $mPDF1->Output('Notice Of Conduct.pdf', 'I');
        }
    }
    public function actionUploadconductNotice() {
        $model = new EmployeeNoticeConduct();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_conduct_notice', array('model' => $model));
    }
    public function actionSaveNoticeDocument() {        
        if (isset($_POST['EmployeeNoticeConduct'])) {        
            $model = new EmployeeNoticeConduct();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeNoticeConduct']['id'] > 0) {
                $model = EmployeeNoticeConduct::model()->findByPK($_POST['EmployeeNoticeConduct']['id']);
                $model->id = (int) $_POST['EmployeeNoticeConduct']['id'];
                $model->updated_date_time = date('Y-m-d H:i:s');
                $model->updated_by = Yii::app()->user->id;
            }
            $model->notice_document = $_POST['EmployeeNoticeConduct']['notice_document'];
            $model->issued_date = date('Y-m-d');
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDownloadnoticeDocument() {
        $id = Yii::app()->request->getParam('id');
        $document = EmployeeNoticeConduct::model()->findByPk($id);
        $file =$document->notice_document;  
        $path = Yii::getPathOfAlias('webroot') . "/uploads/noticeconduct/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }
    public function actionConductIndex() {
        $this->layout='main';
        $model_module_notice_conduct = HrModules::model()->findByPK(24);
        if ($model_module_notice_conduct->grant_access == 1 && $model_module_notice_conduct->isActive == 'Y') {
            $this->render('conduct_index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetConductNoticeList() {
        $model = new EmployeeNoticeConduct();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'created_date_time',
            2 => 'reason',
            3=>''
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $user_login_id = Yii::app()->user->id;
        $employee_id = User::model()->findbypk($user_login_id);
        $model_emp = Employee::model()->findByPk($employee_id->employee_id);
        $condition = 't.employee_id = "' . $model_emp->id . '" and issued_date!="0000-00-00" and signed_date="0000-00-00"';
        EmployeeNoticeConduct::model()->updateAll(array('view_status' =>1), 'employee_id="'.$model_emp->id.'" and view_status="0"');
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $type=array(1=>'Notice of Conduct',2=>'Warning(Non Performance)',3=>'Warning Letter');
        foreach ($model as $row) {
            $button_string = '';   
            $download_notice =$download_signed_notice=$upload_document=0;
            if($row->notice_document!='' && $row->signed_notice_document==''){
                $download_notice =1;
                $button_string.= '<a href="?r=hr/hrnotification/downloadnoticedocument&id=' . $row['id'] . '" title="Download Unsigned Document" target="_blank"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';        
            }
            if($row->signed_notice_document!=''){
                $button_string.= '<a href="?r=hr/hrnotification/downloadsignednoticedocument&id=' . $row['id'] . '" title="Download Signed Document" target="_blank"><button class="btn btn-primary btn-xs"><i class="fa fa-download"></i></button></a>&nbsp;';        
                $download_signed_notice =1;
            }
            $issued_date="";
            $days=0;
            $current_date=date('Y-m-d');
            if($row['issued_date']!='' && $row['issued_date']!='0000-00-00'){
                $issued_date=date("d/m/Y", strtotime($row['issued_date']));
                $issued_date_1 = strtotime($row['issued_date']);
                $current_date_1 = strtotime($current_date);
                $datediff = $current_date_1-$issued_date_1 ;
                $days = $datediff / (60 * 60 * 24)+1;  
            }
            if($days<=5 && $row->signed_notice_document==''){
                $upload_document =1;
                $button_string .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/hrnotification/uploadsignedconductNotice&id=' . $row['id'] . '\',\'Upload \',\'lg\')" title="Upload Signed Document"><i class="fa fa-upload"></i></button>&nbsp;';
            }
            $rowData[] = array($m,$type[$row->type],$issued_date, substr($row['reason'], 0, 50) . '...',array('id'=>$row['id'],'download_notice'=>$download_notice,'download_signed_notice' =>$download_signed_notice,'upload_document'=>$upload_document));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionuploadsignedconductNotice() {
        $model = new EmployeeNoticeConduct();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_signed_conduct_notice', array('model' => $model));
    }
    public function actionSavesignedNoticeDocument() {        
        if (isset($_POST['EmployeeNoticeConduct'])) {        
            $model = new EmployeeNoticeConduct();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeNoticeConduct']['id'] > 0) {
                $model = EmployeeNoticeConduct::model()->findByPK($_POST['EmployeeNoticeConduct']['id']);
                $model->id = (int) $_POST['EmployeeNoticeConduct']['id'];
                $model->updated_date_time = date('Y-m-d H:i:s');
                $model->updated_by = Yii::app()->user->id;
            }
            $model->signed_notice_document = $_POST['EmployeeNoticeConduct']['signed_notice_document'];
            $model->signed_date = date('Y-m-d');
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
        public function actiondownloadsignednoticedocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_document = EmployeeNoticeConduct::model()->findByPk($id);
        $file = $arr_employee_document->signed_notice_document;
        $arr_doc_val = explode(',', $arr_employee_document->signed_notice_document);
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/noticeconduct/" . $arr_employee_document->employeedetail->employeecode . "_" . date('d-m-Y') . ".zip";
           if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/noticeconduct/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            $file = $arr_employee_document->signed_notice_document;
            $path = Yii::getPathOfAlias('webroot') . "/uploads/noticeconduct/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actionPrintCertificate() {
        $id = Yii::app()->request->getParam('id');
        //id of warning letter in mascertificate
        $model = MasCertificate::model()->findByPk(7);
        $model_notice = EmployeeNoticeConduct::model()->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('print_certificate', array('model' => $model,'model_notice'=>$model_notice), false, true);
    }
    public function actionDeleteSignednoticeDocument() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $document_detail = new EmployeeNoticeConduct();
        $model_documents = EmployeeNoticeConduct::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->signed_notice_document);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files = '';
            if (!empty($document_file_array)) {
                $files = implode(',', $document_file_array);
            }
            EmployeeNoticeConduct::model()->updateByPK($id, array('signed_notice_document' => $files));
            unlink(Yii::getPathOfAlias('webroot') . "/uploads/noticeconduct/" . $file_name);
            $div_file = '<span id="spannoticefile_' . $i . '">';
            if (!empty($document_file_array)) {
                foreach ($document_file_array as $value_file) {
                    $f_name = "'" . $value_file . "'";
                    $div_file .= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deletesignednoticedocument(this.id,' . $id . ',' . $f_name . ');" id="delete_notice_file_' . $i . '"><i class="fa fa-trash"></i></a><br>';
                }
            }
            $div_file .= '</span>';
            $div_file .= CHtml::activeHiddenField($document_detail, "signed_notice_document", array('value' => $files));
            echo $div_file;
        }
    }
}
