<?php

class HrnotesController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('index', 'create', 'GetList', 'Save', 'deletenote', 'viewnote'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    
    public function actionIndex() {
        $model_module_notes = HrModules::model()->findByPK(23);
        if ($model_module_notes->grant_access == 1 && $model_module_notes->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_notes_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    
    public function actionCreate() {
        $model = new EmployeeNotes();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model));
    }

    public function actionSave() {        
        if (isset($_POST['EmployeeNotes'])) {        
            $model = new EmployeeNotes();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeNotes']['id'] > 0) {
                $model = EmployeeNotes::model()->findByPK($_POST['EmployeeNotes']['id']);
                $model->id = (int) $_POST['EmployeeNotes']['id'];
            }
            $model->attributes = $_POST['EmployeeNotes'];
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->created_by = Yii::app()->user->id;
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetList() {
        $model = new EmployeeNotes();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'notes',
            4 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1'; 
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%' OR t.notes LIKE '%".$searchString."%')";                                      
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            $edit_button=$view_button=$delete_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_notes_edit'])  || Yii::app()->user->authorised_user == 1) {
                $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/hrnotes/create&id=' . $row['id'] . '\',\'Edit\',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_notes_view'])  || Yii::app()->user->authorised_user == 1) {
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/hrnotes/viewnote&id=' . $row['id'] . '\',\'View\',\'lg\')"><i class="fa fa-eye"></i></button>';
                $view_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_notes_delete'])  || Yii::app()->user->authorised_user == 1) {
                $div .= '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletnote(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>';           
                $delete_button =1;
            }
            $rowData[] = array($m,$this->ciphertext($row->employeedetail->employee_code, "d"), $this->ciphertext($row->employeedetail->first_name, "d") . ' ' . $this->ciphertext($row->employeedetail->last_name, "d"),substr($row['notes'], 0, 30) . '...',array('id'=>$row['id'],'edit_button'=>$edit_button,'view_button'=>$view_button,'delete_button'=>$delete_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionDeleteNote() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = new EmployeeNotes();
            $model->deleteByPk($id);
            echo "success";
        } else {
            echo "fail";
        }
    }
    public function actionViewNote() {
        $model = new EmployeeNotes();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view_note', array('model' => $model));
    }
}
