<?php

class HrmascolorcodeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getlist', 'Create', 'Save', 'Disable', 'CreateColor', 'SaveColor'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

        public function actionIndex() {
           if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_color_scheme_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {

        $model = new HrMasColorCode();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'functionality',
            2 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = 'functionality';
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (functionality LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $div = '';
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_calendar_color_edit'])  || Yii::app()->user->authorised_user == 1) { 
                $edit_button=1;
                $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'hr/hrmascolorcode/CreateColor&id=' . $row['id'] . '\',\' Edit \',\'md\')"><i class="fa fa-pencil"></i></button>';
            }
            $rowData[] = array(++$m,$row['functionality'],array('id'=>$row['id'],'edit_button'=>$edit_button));
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array(), false, true);
    }

    public function actionCreateColor() {
        $model = new HrMasColorCode();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('edit_color', array('model' => $model), false, true);
    }

    public function actionSave() {
        if (isset($_POST['HrMasColorCode'])) {
            $valid = true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['HrMasColorCode'])) && ($_POST['HrMasColorCode'][0]['id'] != '')) {
                foreach ($_POST['HrMasColorCode'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_color_code[$i] = HrMasColorCode::model()->findByPK($items['id']);
                        $model_color_code[$i]->updated_by = Yii::app()->user->id;
                        $model_color_code[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_color_code[$i] = new HrMasColorCode();
                        $model_color_code[$i]->created_by = Yii::app()->user->id;
                        $model_color_code[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_color_code[$i]->attributes = $items;
                    $valid = $model_color_code[$i]->validate() && $valid;
                }
            }
            if ($valid) {
                if (!empty($model_color_code)) {
                    foreach ($model_color_code as $eachModel) {
                        $eachModel->save();
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            } else {
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_color_code, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionSaveColor() {
        $model = new HrMasColorCode();
        if (isset($_POST['HrMasColorCode'])) {
            if ((int) @$_POST['HrMasColorCode']['id'] > 0) {
                $id = (int) @$_POST['HrMasColorCode']['id'];
                $model = $model->findByPk($id);
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date("Y-m-d H:i:s");
            }
            $model->attributes = $_POST['HrMasColorCode'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
