<?php

class HrmasassetdetailsController extends Controller
{
	 public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DeleteAssetDetails','SaveAssetDetails','GetList','Edit','SaveEditDetails','getAvailability','UploadAssetDetails','DownloadSampleCsv','DownloadErrorCsv','readAssetCSV','SaveAssetDetailsUploadCsv','UploadEmployeecsv'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
    public function actionIndex() {
        $model_module_asset = HrModules::model()->findByPK(30);
        if (($model_module_asset->grant_access == 1 && $model_module_asset->isActive == 'Y')) {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_asset_details_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList(){
        $model=new HrMasAssetDetails();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
            0 =>'t.id',
            1 =>'asset.asset_name',
          
            2 =>'asset_detail',
            3 =>'asset_value',
            4 =>'asset_status',
            5=> 'availability_status ',
           );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition='1=1';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition.=" and (asset.asset_name LIKE '%".$searchString."%' OR asset_detail LIKE '%".$searchString."%')";
        }
        $count = $model->with('asset')->count(array('condition'=>$condition));
        $model=$model->with('asset')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        $asset_status= array('G'=>'Good','D'=>'Damaged','R'=>'Repair');
        $availability_status= array('Y'=>'Yes','N'=>'No');
        foreach ($model as $row)
        {
            $edit=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_asset_details_edit']) || Yii::app()->user->authorised_user == 1) {
              $edit=1;  
            }
            $rowData[]=array(++$m,$row['asset']['asset_name'],$row['asset_detail'],$row['asset_value'],$asset_status[$row['asset_status']],$availability_status[$row['availability_status']],array('id'=>$row['id'],'edit'=>$edit));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model_assetDetails=array(new HrMasAssetDetails()); 
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('assetdetails_form', array('model_assetDetails' => $model_assetDetails), false, true);
    }
     public function actionSaveAssetDetails() {
        if (isset($_POST['HrMasAssetDetails'])) {           
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['HrMasAssetDetails'])) && ($_POST['HrMasAssetDetails'][0]['asset_id']!='')){	
            $valid=true;		
                foreach ($_POST['HrMasAssetDetails'] as $i => $items) {
                    if($items['id']>0){
                        $model_asset_details[$i] = HrMasAssetDetails::model()->findByPK($items['id']);   
                       
                        $model_asset_details[$i]->updated_by= Yii::app()->user->id;
                        $model_asset_details[$i]->updated_date_time = date('Y-m-d H:i:s');
                    }else{
                        $model_asset_details[$i] = new HrMasAssetDetails();   
                      
                        $model_asset_details[$i]->created_by= Yii::app()->user->id;
                        $model_asset_details[$i]->created_date_time = date('Y-m-d H:i:s');
                    }   
                    $model_asset_details[$i]->attributes = $items;			
                    $valid=$model_asset_details[$i]->validate() && $valid;
                    
                }
            }else{
                $valid=false;        
            }
            if($valid){
                if (!empty($model_asset_details)) {
                    foreach ($model_asset_details as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
				Yii::app()->end();
            }else{
                $error1=$error2=array();
                if(!empty($model_asset_details)){
                    if ($model_asset_details[0]->asset_id > 0){
                       $error1 = json_decode(CActiveForm::validateTabular($model_asset_details, '', false), true);
                    }
            }else{
                    $error2[]='Please enter details in atleast one row';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actionDeleteAssetDetails(){
        $id = $_POST['id'];
        if($id>0){

            $model = new HrMasAssetDetails();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
     public function actionEdit() {
        $model = new HrMasAssetDetails();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('edit_assetdetails_form', array('model' => $model), false, false);
    }
     public function actionSaveEditDetails() {
        $model = new HrMasAssetDetails();
        if (isset($_POST['HrMasAssetDetails'])) {
            if ((int) @$_POST['HrMasAssetDetails']['id'] > 0) {
                $id = (int) @$_POST['HrMasAssetDetails']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d H:i:s');
            } 
            $model->attributes = $_POST['HrMasAssetDetails'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actiongetAvailability() {
       //code added by rahul on 14-9-22//MODIFIED BY Dikson
        $id = Yii::app()->request->getparam("id");
        $model_employee_asset= EmployeeAsset::model()->find(array('condition'=>'asset_id="'.$id.'" AND asset_status="1"'));
        if (empty($model_employee_asset)) {
            $status['available'] = 'Y';
            $status['status'] = 'success';
        } else {           
            $status['available'] = 'N';
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionUploadAssetDetails(){
        //added by nisha on 09-03-2023
        $model=new HrMasAssetDetails();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_asset_details', array('model' => $model), false, true);
    }
    public function actionDownloadSampleCsv() {
        $filename = 'asset_details_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Asset Name*,Reference No/Description*, Asset Value, Repaircost/Extra Payment, Status(Good/Damaged/Repair)*, Availability(Yes/No)*';
        Yii::app()->end();
    } 
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/asset_details_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function readAssetCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveAssetDetailsUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');  
        $url = Yii::app()->basePath . '/../uploads/asset_details_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/asset_details_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $asset_error = array();
        $asset_list = $this->readAssetCSV("uploads/asset_details_csv/" . $file_name);
        $linecount = count(file("uploads/asset_details_csv/" . $file_name))-1;
            foreach (array_slice($asset_list, 1) as $i => $data) {
                if(!empty($data[0])){
                $asset_model[$i] = new HrMasAssetDetails();
                $asset_model[$i]->scenario="excelupload";

                if(!empty($data[0])){
                $condition = '((REPLACE(`asset_name`, " ", "") LIKE "%'.str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'))).'%"  OR id LIKE "%'.$data[0].'%" ) AND isActive ="Y")';        
                $model_masasset[$i] = HrMasAsset::model()->find(array('select' =>'id','condition' => $condition));
                if(!empty($model_masasset[$i])){
                $asset_model[$i]->asset_id = $model_masasset[$i]->id;
                }
                }else{
                    $asset_model[$i]->asset_id = '0';
                }
                if($data[1]!=''){
                $asset_model[$i]->asset_detail = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
                }else{                    
                    $asset_model[$i]->asset_detail = '';
                }
                if($data[2]!=''){
                $asset_model[$i]->asset_value = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
                }else{                    
                    $asset_model[$i]->asset_value = '';
                }
                if($data[3]!=''){
                $asset_model[$i]->repair_cost_extra = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'));
                }else{                    
                    $asset_model[$i]->repair_cost_extra = '';
                }
                if($data[4]!=''){
                $asset_model[$i]->asset_status = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));
                }else{                    
                    $asset_model[$i]->asset_status = '';
                }
                if($data[4]!=''){
                    $asset_status=trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));
                    $asset_status =strtolower($asset_status);
                    if($asset_status=='good'){
                      $asset_model[$i]->asset_status="G";   
                    }else if($asset_status=='damaged'){
                        $asset_model[$i]->asset_status = "D";
                    }
                    else if($asset_status=='repair'){
                        $asset_model[$i]->asset_status = "R";
                    }
                }
                if($data[5]!=''){
                    $availability_status =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[5]), '"'));
                    $availability_status = strtolower($availability_status);
                    if($availability_status=='yes'){
                        $asset_model[$i]->availability_status="Y";
                    }else{
                        $asset_model[$i]->availability_status="N";
                    }
                }
                $asset_error[$i] = $asset_model[$i]->asset_id;   
                $asset_model[$i]->isActive = 'Y';
                $asset_model[$i]->created_by  =Yii::app()->user->id;
                $asset_model[$i]->created_date_time = date('Y-m-d H:i:s');
                $validate = $asset_model[$i]->validate() && $validate;
                }
            }
            //echo '<pre>';  print_r($asset_model);      die();
            function array_not_unique($raw_array) {
                $dupes = array();
                natcasesort($raw_array);
                reset($raw_array);

                $old_key   = NULL;
                $old_value = NULL;
                foreach ($raw_array as $key => $value) {
                    if ($value === NULL) { continue; }
                    if (strcasecmp($old_value, $value) === 0) {
                        $dupes[$old_key] = $old_value;
                        $dupes[$key]     = $value;
                    }
                    $old_value = $value;
                    $old_key   = $key;
                }
                return $dupes;
            }
               

            $des_common = array_not_unique($asset_error);
            if ($validate) {                    
                if (!empty($asset_model)) {
                    foreach ($asset_model as $eachModel) { 
                        $eachModel->save();
                    }
                    $jsonData['error'] =""; 
                }   
            } else {            
                if (!empty($asset_model)) {
                    foreach ($asset_model as $s => $data_model) {
                        
                            $error_list[$s]['asset_name'] =$data_model->asset->asset_name; 
                            $error_list[$s]['asset_detail'] =$data_model->asset_detail;
                            $error_list[$s]['asset_value'] =$data_model->asset_value;
                            $error_list[$s]['repair_cost_extra'] =$data_model->repair_cost_extra;
                            $error_list[$s]['asset_status'] =$data_model->asset_status;
                            $error_list[$s]['availability_status'] =$data_model->availability_status;
                            
                            if($data_model->validate()){
                            $error_list[$s]['remarks']     ="correct";
                            }else{
                            $error_list[$s]['remarks']     =$data_model->getErrors();   
                            }
                    }
                }   
            }               

            $j=0;
            fclose($file);
            $list = array(); 
            if(!empty($error_list)){
                $file_error = fopen($error_url, "w+");
                $list[$j++] = 'Asset Name*,Reference No*, Asset Value, Repaircost/Extra Payment, Status*, Availability*,Remarks';
                foreach ($error_list as $i => $error_detail) {
                    if(!empty($error_detail)){
                        if(!empty($error_detail['remarks'])){
                                $error_view[$i] = '';
                            foreach($error_detail['remarks'] as $p => $error_value){                        
                                    $error_view[$i] .= $error_value[0]." / ";   

                            }
                        }else{
                            $error_view[$i] .= '';
                        }
                        if (in_array($error_detail['asset_name'], $des_common)){
                            $error_view[$i] .= " Asset name duplication in CSV /";
                        }   else {
                            $error_view[$i] .= '';
                        }
                        
                        $list[$j++] = $error_detail['asset_name'].  ','.$error_detail['asset_detail'].  ','.$error_detail['asset_value'].  ','.$error_detail['repair_cost_extra'].  ','.$error_detail['asset_status'].  ','.$error_detail['availability_status'].  ',' .$error_view[$i];
                    }
                }
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                fclose($file_error);
            }
            $jsonData['status'] = "success";
            $jsonData['error_url'] = $error_url;
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download log', array('hrmasassetdetails/DownloadErrorCsv', 'id'=>$file_name), array('target' => '_blank',
                'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                . ''
                ));
        
        echo CJSON::encode($jsonData);
    }
}