<?php

class HrexpenseController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'saveexpense','deleteexpense','deleteexpensedetail','CopyExpense','CopyExpenseDetail'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $model_company_expense = HrModules::model()->findByPK(19);
        if ($model_company_expense->grant_access == 1 && $model_company_expense->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_expense_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new HrExpense();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.first_name',
            2 => 'expense_description',
            3 => 'expense_year',
            4 => 'duration',
            5 => '',
            6 => '',
            7 => 'amount',
            8 => '',
            9 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (expense_description LIKE '%" . $searchString . "%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $edit_btn=$delete_btn=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_expense_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/hrexpense/create&id=' . $row['id'] . '\',\'Edit Expense Detail \',\'xl\')"><i class="fa fa-edit"></i></button>&nbsp;';
                $edit_btn=1;
            }
            if ((isset(Yii::app()->user->haveHrPermissionOn['hr_expense_delete'])  || Yii::app()->user->authorised_user == 1)) {
                $button_string .= '<a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deleteexpense(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>&nbsp;';
                $delete_btn=1;
            }
            $per_month_amt=$paid_amount=$balance_amount=0.00;
            $model_total_amt = HrExpenseDetail::model()->find(array('select'=>'sum(amount) as amount','condition' =>'expense_id="'.$row->id.'"'));
            if($model_total_amt->amount>0){
                $per_month_amt=number_format((float)($model_total_amt->amount/$row->duration), 2, '.', '');
            }
            $start_date = $row->expense_year.'-'.$row->expense_month.'-01';
            $current_month_last_date = date('Y-m-d');
            $last_date= date('Y-m-t', strtotime('+'.$row->duration.' months', strtotime($start_date)));
            //Upto Current Month
            $date1 = new DateTime($start_date);
            $date2 = new DateTime($current_month_last_date); 
            $dd = date_diff($date1,$date2);
            $current_yr=$dd->y*12;
            $current_mnth=$dd->m+$current_yr;
            if($current_mnth>$row->duration){
                $current_mnth=$row->duration;
            }
            $paid_amount=number_format((float)($per_month_amt*$current_mnth), 2, '.', '');
            //After current month
            $date3 = new DateTime($current_month_last_date);
            $date4 = new DateTime($last_date); 
            $dd1 = date_diff($date3,$date4);
            $after_current_yr=$dd1->y*12;
            $after_current_mnth=$dd1->m+$after_current_yr;       
            $balance_amount=number_format((float)($per_month_amt*$after_current_mnth), 2, '.', '');
            $month=str_pad($row->expense_month,2, '0', STR_PAD_LEFT);
            $rowData[] = array($m, $row->employeedetail->employeefullname,$row->expense_description,HrGenerelSettings::getMonthName($month).'/'.$row->expense_year,$row->duration,'<div class="text-right">'.$per_month_amt.'</div>','<div class="text-right">'.$paid_amount.'</div>','<div class="text-right">'.$balance_amount.'</div>','<div class="text-right">'.$model_total_amt->amount.'</div>',array('id'=>$row->id,'edit_btn'=>$edit_btn,'delete_btn'=>$delete_btn));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new HrExpense();
        $model_details = array(new HrExpenseDetail());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = HrExpenseDetail::model()->findAll(array('condition' =>'expense_id="'.$id.'"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model,'model_details' => $model_details), false, true);
    }

    public function actionsaveexpense() {
        if (isset($_POST['HrExpense'])) {
            $model = new HrExpense();
            date_default_timezone_set("Asia/Dubai");
             if ($_POST['HrExpense']['id'] > 0) {
                $id = (int) $_POST['HrExpense']['id'];
                $model = $model->findByPk($id);
                $model->updated_by= Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by= Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['HrExpense'];
            $valid=$model->validate();
            if (isset($_POST['HrExpenseDetail'])){			
                foreach ($_POST['HrExpenseDetail'] as $i => $items) {
                    if($items['id']>0){
                        $model_detail[$i] = HrExpenseDetail::model()->findByPK($items['id']); 
                        $model_detail[$i]->updated_by= Yii::app()->user->id;
                        $model_detail[$i]->updated_date_time = date('Y-m-d H:i:s');
                    }else{
                        $model_detail[$i] = new HrExpenseDetail();   
                        $model_detail[$i]->created_by= Yii::app()->user->id;
                        $model_detail[$i]->created_date_time = date('Y-m-d H:i:s');
                    }   
										
                    $model_detail[$i]->expense_type_id = $items['expense_type_id'];
                    $model_detail[$i]->amount = $items['amount'];		
                    $valid=$model_detail[$i]->validate() && $valid;
                    
                }
            }
            if($valid){
                $model->save();
                if (!empty($model_detail)) {
                    foreach ($model_detail as $eachModel) {
                        $eachModel->expense_id = $model->id;
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{
                $error2=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($model_detail[0]->expense_type_id!=''){
                   $error2 = json_decode(CActiveForm::validateTabular($model_detail, '', false), true);
                }else{
                    $error2[]='Please add atleast one item';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }
    public function actiondeleteexpensedetail(){
        $id = $_POST['id'];
        if($id>0){
            HrExpenseDetail::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actiondeleteexpense(){
        $id = $_POST['id'];
        if($id>0){
            HrExpenseDetail::model()->deleteAll('expense_id=:refer_id', array(':refer_id' => $id));
            HrExpense::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    
    //Employee Expense Copy added by DIkson 5/12/2022
    public function actionCopyExpense() {
        $model = new EmployeeExpense;
        $id = Yii::app()->request->getparam('id');
        $model_details = array(new EmployeeExpenseDetails);
        $model_additional_details = array();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"','order'=>'id asc'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
            $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)'));
            if (empty($model_additional_details)) {
                $model_additional_details = array();
            }
        }
        $user_id = Yii::app()->user->id; 				
        $modelemployee = User::model()->findByPK($user_id);
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$modelemployee->employee_id.'" and functionality_id="7"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('copy_expense', array('model' => $model, 'model_details' => $model_details, 'model_additional_details' => $model_additional_details, 'expense_id' => $id,'model_master_approve_setting'=>$model_master_approve_setting));
    }
    //Expense Copy added by DIkson 5/12/2022
    public function actionCopyExpenseDetails1() {
        $model = new EmployeeExpense;
        $id = Yii::app()->request->getparam('id');
        $model_details = array(new EmployeeExpenseDetails);
        $model_additional_details = array();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"','order'=>'id asc'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
            $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)'));
            if (empty($model_additional_details)) {
                $model_additional_details = array();
            }
        }
        $user_id = Yii::app()->user->id; 				
        $modelemployee = User::model()->findByPK($user_id);
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$modelemployee->employee_id.'" and functionality_id="7"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('copy_expense_details', array('model' => $model, 'model_details' => $model_details, 'model_additional_details' => $model_additional_details, 'expense_id' => $id,'model_master_approve_setting'=>$model_master_approve_setting));
    }
    public function actionCopyExpenseDetail() {
        $model = new EmployeeExpense;
        $id = Yii::app()->request->getparam('id');
        $model_details = array(new EmployeeExpenseDetails);
        $model_additional_details = array();
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new EmployeeExpenseDetails);
            }
            $model_additional_details = EmployeeExpenseDetails::model()->findAll(array('condition' => 'expense_id="' . $id . '" AND (expense_component_id=21 OR expense_component_id=22)'));
            if (empty($model_additional_details)) {
                $model_additional_details = array();
            }
            $branch=$model->employeedetail->branch_or_sponsor_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('copy_expense_details', array('model' => $model, 'model_details' => $model_details,'branch'=>$branch, 'model_additional_details' => $model_additional_details, 'expense_id' => $id));
    }
}
