<?php

class HrexcelController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('MonthlyAttendanceReport','excelCompanyDocument','MonthlyAttendance','DownloadConsolidatedReport','DownloadDocumentReport','DownloadDocumentverticalReport','leavesettlementexceldownload','PrintEmployeeTeamAttendenceExcel','PrintEmployeeresignationListExcel'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionMonthlyAttendanceReport() {
        $attend_emp_sponsor = $_GET['attend_emp_sponsor'];
        $attendance_date='';
        $month='';
        $year='';

        if(isset($_GET['attendance_date']))
        {
        $attendance_date = $_GET['attendance_date'];
        }
        if(isset($_GET['month']))
        {
        $month = $_GET['month'];
        }

        if(isset($_GET['year']))
        {
        $year = $_GET['year'];
        }

            $filename = 'MonthlyAttendance.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('employee_monthly_attendance_list', array('attendance_date' => $attendance_date, 'attend_emp_sponsor' => $attend_emp_sponsor,'month' => $month,'year' => $year), false, true);
        Yii::app()->end();
    }
    public function actionexcelCompanyDocument() {
        $doc_id= $_GET['doc_id'];
        $filename = 'company_document.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('company_document', array('doc_id' => $doc_id), false, true);
        Yii::app()->end();
    }
    public function actionMonthlyAttendance() {
        $branch_id = $_GET['branch_id'];
        $attendance_date = $_GET['attendance_date']; 
        $filename = 'attendance_report.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('employee_monthly_attendance', array('branch_id' => $branch_id, 'attendance_date' =>$attendance_date), false, true);
        Yii::app()->end();
    }
    public function actionDownloadConsolidatedReport()
    {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $department_id = $_GET['department_id'];
        $status = $_GET['status'];
        $condition = '1=1';
        if ($status=='Y') {
            $condition.= ' AND isActive!= "B"';
        }else if ($status=='B') {
            $condition.= ' AND isActive= "B"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if ($branch_id!='') {
            $condition .= ' AND t.branch_or_sponsor_id = "' . $branch_id . '"';
        } else if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        if ($employee_id !='' && $employee_id !=null && $employee_id !='null') {
            $condition .= ' and t.id IN (' .$employee_id. ')';
        }

        if ($department_id != '' && $department_id !=null && $department_id !='null') {
            $condition .= ' and t.department IN (' .$department_id. ')';
        }
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $modelemployee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($modelemployee as $key => $value) {
            $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
        }
        ksort($arr_employee); 
        //Salary Master
        $model_master_salary=array();
        $model_usergroup_master = MasUserGroup::model()->findbyPK($model_user->user_group_id);
        $cond_br_sal=$cond_br_doc=$cond_br_leave='';
        if($branch_id!=''){
            $cond_br_sal='id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",salary_tab_permission)';
            $cond_br_doc='id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",document_tab_permission)';
            $cond_br_leave='id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",leave_tab_permission)';
        }else if(!empty($model_usergroup_master)){
            if($model_usergroup_master->salary_tab_permission!=''){
                $cond_br_sal='id="'.$model_user->user_group_id.'" and salary_tab_permission IN ('.$model_usergroup_master->salary_tab_permission.')';
            }else{
                $cond_br_sal='id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",salary_tab_permission)';
            }
            if($model_usergroup_master->document_tab_permission!=''){
                $cond_br_doc='id="'.$model_user->user_group_id.'" and document_tab_permission IN ('.$model_usergroup_master->document_tab_permission.')';
            }else{
                $cond_br_doc='id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",document_tab_permission)';
            }
            if($model_usergroup_master->leave_tab_permission!=''){
                $cond_br_leave='id="'.$model_user->user_group_id.'" and leave_tab_permission IN ('.$model_usergroup_master->leave_tab_permission.')';
            }else{
                $cond_br_leave='id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",leave_tab_permission)';
            }
        }
        $model_usergroup_sal = MasUserGroup::model()->find(array('condition' =>$cond_br_sal ));
        if (!empty($model_usergroup_sal) && $model_usergroup_sal->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_salary = EmployeeSalary::model()->with('salary')->findAll(array('group'=>'t.salary_type','order' => 'salary.salary_name ASC'));
        }
        //Document Master
        $model_master_document=array();
        $model_usergroup_doc = MasUserGroup::model()->find(array('condition' => $cond_br_doc));
        if (!empty($model_usergroup_doc) && $model_usergroup_doc->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_document = EmployeeDocuments::model()->with('document')->findAll(array('group'=>'document_id','order' => 'document.document_name ASC'));
        }
        //Leave Master
        $model_master_leave=array();
        $model_usergroup_leave = MasUserGroup::model()->find(array('condition' =>$cond_br_leave));
        if (!empty($model_usergroup_doc) && $model_usergroup_leave->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_leave = EmployeeLeave::model()->with('leavetype')->findAll(array('condition' => 'leavetype.branch_id="'.$branch_id.'" and t.leave_year="'.date('Y').'"','group'=>'t.leave_type','order' => 'leavetype.leave_name ASC'));
        }
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(25);
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'No')
            ->setCellValue('B1', 'Branch')
            ->setCellValue('C1', 'Employee Code')
            ->setCellValue('D1', 'Biometric Code')
            ->setCellValue('E1', 'Employee Name')
            ->setCellValue('F1', 'Official Number')
            ->setCellValue('G1', 'Personal Number')
            ->setCellValue('H1', 'Email ID')
            ->setCellValue('I1', 'Team')
            ->setCellValue('J1', 'Department')
            ->setCellValue('K1', 'Designation')
            ->setCellValue('L1', 'Joining Date')
            ->setCellValue('M1', 'Confirmation Date')
            ->setCellValue('N1', 'Reporting Manager')
            ->setCellValue('O1', 'MOL ID(14 Digits)')
            ->setCellValue('P1', 'IBAN No(23 Digits)')
            ->setCellValue('Q1', 'Bank')
            ->setCellValue('R1', 'Routing Code')
            ->setCellValue('S1', 'Account Number')
            ->setCellValue('T1', 'WPS Entity')
            ->setCellValue('U1', 'Contract')
            ->setCellValue('V1', 'Have OT')
            ->setCellValue('W1', 'Shift')
            ->setCellValue('X1', 'Weekend')
            ->setCellValue('X2', '1')
            ->setCellValue('Y2', '2')
            ->setCellValue('Z2', '3');
        //sTYLE
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        //Salary Head
        $head_row=1;
        $head_col=26;
        if(!empty($model_master_salary)){
            foreach ($model_master_salary as $key => $salary_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $salary_id->salary->salary_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
                $head_col++;
            }
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Total Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Payment Mode');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(20);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Visa Profession');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Nationality');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells('' . $row_alphabet . '1:' . $row_alphabet . '2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Date Of Birth');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Gender');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Golden Visa');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        //End Salary Head
        //Document Start
        if(!empty($model_master_document)){
            foreach ($model_master_document as $key => $doc_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $doc_id->document->document_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
                $head_col++;
            }
        }
        //End Document Head
        //Leave Start
        if(!empty($model_master_leave)){
            foreach ($model_master_leave as $key => $leave_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $leave_id->leavetype->leave_name);
                $first_cell=$head_col;
    //            $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet_1=$this->cellsToMergeByColsRow($head_col); 
                $head_col++;
                $second_cell=$head_col;
                $row_alphabet_2=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet_1.'1:'.$row_alphabet_2.'1');
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($first_cell, 2, 'Open Bal');
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($second_cell, 2, 'Cur Bal');
                $head_col++;
            }
        }
        if(empty($model_master_leave)){
            $row_alphabet_2=$row_alphabet;
        }
        $objPHPExcel->getActiveSheet()->getStyle('Y2:'.$row_alphabet_2.'2')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('V2:'.$row_alphabet_2.'2')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('V2:'.$row_alphabet_2.'2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        //End Leave Head
        $adjustment = +($head_col-25);
        $currentColumn = 'Y';
        $columnIndex = PHPExcel_Cell::columnIndexFromString($currentColumn);
        $adjustedColumnIndex = $columnIndex + $adjustment;
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($adjustedColumnIndex - 1);
        $objPHPExcel->getActiveSheet()->getStyle('A1:'.$adjustedColumn.'1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A1:'.$adjustedColumn.'1')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()
        ->getStyle('A1:'.$adjustedColumn.'2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D3D3D3')
                )
            )
        );
        //MERGE CELLS
        $objPHPExcel->getActiveSheet()->mergeCells("A1:A2");
        $objPHPExcel->getActiveSheet()->mergeCells('B1:B2');
        $objPHPExcel->getActiveSheet()->mergeCells('C1:C2');
        $objPHPExcel->getActiveSheet()->mergeCells('D1:D2');
        $objPHPExcel->getActiveSheet()->mergeCells('E1:E2');
        $objPHPExcel->getActiveSheet()->mergeCells('F1:F2');
        $objPHPExcel->getActiveSheet()->mergeCells('G1:G2');
        $objPHPExcel->getActiveSheet()->mergeCells('H1:H2');
        $objPHPExcel->getActiveSheet()->mergeCells('I1:I2');
        $objPHPExcel->getActiveSheet()->mergeCells('J1:J2');
        $objPHPExcel->getActiveSheet()->mergeCells('K1:K2');
        $objPHPExcel->getActiveSheet()->mergeCells('L1:L2');
        $objPHPExcel->getActiveSheet()->mergeCells('M1:M2');
        $objPHPExcel->getActiveSheet()->mergeCells('N1:N2');
        $objPHPExcel->getActiveSheet()->mergeCells('O1:O2');
        $objPHPExcel->getActiveSheet()->mergeCells('P1:P2');
        $objPHPExcel->getActiveSheet()->mergeCells('Q1:Q2');
        $objPHPExcel->getActiveSheet()->mergeCells('R1:R2');
        $objPHPExcel->getActiveSheet()->mergeCells('S1:S2');
        $objPHPExcel->getActiveSheet()->mergeCells('T1:T2');
        $objPHPExcel->getActiveSheet()->mergeCells('U1:U2');
        $objPHPExcel->getActiveSheet()->mergeCells('V1:V1');
        $objPHPExcel->getActiveSheet()->mergeCells('W1:W1');
        $objPHPExcel->getActiveSheet()->mergeCells('X1:Z1');
        
        $objPHPExcel->getActiveSheet()->getStyle('A1:'.$adjustedColumn.'1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('A2:W2')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('X2:Z2')->applyFromArray($styleArray);
//        $objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
        $rowCount = 3;
        $start=$rowCount; $end=0;
        $gender_array = array('1' => 'Male', '2' => 'Female');
        $status_value=array('Y'=>'Yes','N'=>'No');
        $contract=array(1=>'Limited',2=>'Unlimited');
        $payment_mode=array(0=>'All',1=>'Cash',2=>'Cheque',3=>'WPS',4=>'Exchange',5=>'Bank');
        $weekend_days=array(1=>'Sunday',2=>'Monday',3=>'Tuesday',4=>'Wednesday',5=>'Thursday',6=>'Friday',7=>'Saturday');
        $date_from=date('Y-m-d');
        $j=1;
        foreach ($arr_employee as $emp_val) {
            $empdetail = Employee::model()->findbyPK($emp_val);
            $wps_company=$date_join=$date_confirmation='';
            if(strlen(trim($empdetail->personal_file_no))!=14){
            }
            if(strlen(trim($empdetail->employee_iban_no))!=23 || substr($empdetail->employee_iban_no, 0, 2)!='AE'){
            }
            if($empdetail->employee_wps_company>0){
                $model_wps_company=MasCompanyWpsDetails::model()->findByPK($empdetail->employee_wps_company);
                $wps_company=$model_wps_company->company_name; 
            }else{
            }
            if($empdetail->date_join!='' & $empdetail->date_join!='0000-00-00'){
                $date_join= date("d/m/Y", strtotime($empdetail->date_join));
            }
            if($empdetail->probation_date!='' & $empdetail->probation_date!='0000-00-00'){
                $date_confirmation= date("d/m/Y", strtotime($empdetail->probation_date));
             }
            $shift_detail='-';
            if($empdetail->isActive!='B'){
                //Shift Details
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $empdetail->id . '"'));
                if(!empty($model_shift) && $model_shift->id>0){
                    $shift_detail=$model_shift->shiftdetails->shift_name.'('.$model_shift->shiftdetails->start_time.'-'.$model_shift->shiftdetails->end_time.')';
                }
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $j);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employee_biometric_code, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$empdetail->phone, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$empdetail->mobile, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$empdetail->email, PHPExcel_Cell_DataType::TYPE_STRING);

            if($empdetail->team_id>0)
                                {
                                $team_name_var = $empdetail->teamdetail->team_name;
                                }else{
                                  $team_name_var ='';
                                }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('I'.$rowCount,$team_name_var, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('J'.$rowCount,$empdetail->departmentdetail->department_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('K'.$rowCount,$empdetail->designationdetail->designation_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('L'.$rowCount, $date_join);
            $objPHPExcel->getActiveSheet()->SetCellValue('M'.$rowCount, $date_confirmation);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('N'.$rowCount,$empdetail->reportingmanager->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('O'.$rowCount,$empdetail->personal_file_no, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('P'.$rowCount,$empdetail->employee_iban_no, PHPExcel_Cell_DataType::TYPE_STRING);

            if($empdetail->employee_bankname>0)
                                {
                        $bank_name_var = $empdetail->bankdetail->bank_name;
                                }else{
                                   $bank_name_var =''; 
                                }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('Q'.$rowCount,$bank_name_var, PHPExcel_Cell_DataType::TYPE_STRING);
                 if($empdetail->employee_bankname>0)
                                {
                        $routing_code_var = $empdetail->bankdetail->routing_code;
                                }else{
                                   $routing_code_var =''; 
                                }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('R'.$rowCount,$routing_code_var, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('S'.$rowCount,$empdetail->employee_accountno, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('T'.$rowCount,$wps_company, PHPExcel_Cell_DataType::TYPE_STRING);
             if (isset($contract[$empdetail->employee_type])) {

                $employee_type_var = $contract[$empdetail->employee_type];

            }else{
                $employee_type_var = '';
            }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('U'.$rowCount,$employee_type_var, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('V'.$rowCount,$status_value[$empdetail->overtime], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('W'.$rowCount,$shift_detail, PHPExcel_Cell_DataType::TYPE_STRING);
            if (isset($weekend_days[$empdetail->weekend_off1])) {

                $weekend_off1_var = $weekend_days[$empdetail->weekend_off1];

            }else{
                $weekend_off1_var = '';
            }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('X'.$rowCount,$weekend_off1_var, PHPExcel_Cell_DataType::TYPE_STRING);
            if (isset($weekend_days[$empdetail->weekend_off2])) {

                $weekend_off2_var = $weekend_days[$empdetail->weekend_off2];

            }else{
                $weekend_off2_var = '';
            }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('Y'.$rowCount,$weekend_off2_var, PHPExcel_Cell_DataType::TYPE_STRING);
            if (isset($weekend_days[$empdetail->weekend_off3])) {

                $weekend_off3_var = $weekend_days[$empdetail->weekend_off3];

            }else{
                $weekend_off3_var = '';
            }
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('Z'.$rowCount,$weekend_off3_var, PHPExcel_Cell_DataType::TYPE_STRING);
            $total_salary=0.00;
            $col_index=26;
            $row_alphabet_3=$this->cellsToMergeByColsRow($col_index); 
            foreach ($model_master_salary as $key_3 => $salary_id) {
                $model_salary_details = EmployeeSalary::model()->find(array('condition' => 'salary_type="'.$salary_id->salary_type.'" and employee_id="'.$empdetail->id.'" and valid_to="0000-00-00"'));
                $salary_amount='0.00';
                if(!empty($model_salary_details) && $model_salary_details->id>0){
                    $salary_amount=$model_salary_details->amount;
                    $total_salary+=$salary_amount;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$salary_amount);
                $col_index++;
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$total_salary);
            $row_alphabet_4=$this->cellsToMergeByColsRow($col_index); 
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_3.''.$rowCount.':'.$row_alphabet_4.''.$rowCount.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_4.''.$rowCount.':'.$row_alphabet_4.''.$rowCount.'')->getFont()->setSize(12)->setBold( true );
            $objPHPExcel->getActiveSheet()
            ->getStyle(''.$row_alphabet_3.''.$rowCount.':'.$row_alphabet_4.''.$rowCount.'')
            ->getNumberFormat()
            ->setFormatCode('#,##0.00');
            $col_index++;
            $row_alphabet_5=$this->cellsToMergeByColsRow($col_index); 
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$payment_mode[$empdetail->payment_type]);
            $col_index++;
            if($empdetail->visa_profession >0 )
                                {
                                $designation_name_var = $empdetail->visaprofessiondetail->designation_name;
                                } else{
                                    $designation_name_var ='';

                                }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$designation_name_var);
            $col_index++;
            if ($empdetail->nationality > 0) {
                $nationality = $empdetail->employeenationality->nationality;
            } else {
                $nationality = '';
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $nationality);
            $col_index++;
            $date_birth='';
            if ($empdetail->date_of_birth != '' & $empdetail->date_of_birth != '0000-00-00') {
                $date_birth= date("d/m/Y", strtotime($empdetail->date_of_birth));
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $date_birth);
            $col_index++;
            $row_alphabet_6=$this->cellsToMergeByColsRow($col_index); 
          
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $gender_array[$empdetail->gender]);
            $col_index++;
            $row_alphabet_6=$this->cellsToMergeByColsRow($col_index); 
          
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount, $status_value[$empdetail->golden_visa_availed]);
            $col_index++;
            //sALRY eND
            foreach ($model_master_document as $key_1 => $doc_id) {
                $model_document_number = EmployeeDocuments::model()->find(array('condition' => 'document_id="'.$doc_id->document_id.'" and employee_id="'.$empdetail->id.'"'));
                $document_number='-';
                if(!empty($model_document_number) && $model_document_number->id>0){
                    $document_number=$model_document_number->document_number;
                }
               // $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$document_number);
                $objPHPExcel->getActiveSheet()->getCellByColumnAndRow($col_index, $rowCount)->setValueExplicit($document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                $col_index++;
            }
            //lEAVE
            foreach ($model_master_leave as $key_2 => $leave_id) {
                $model_leave_bal = EmployeeLeave::model()->find(array('condition' => 'leave_type="'.$leave_id->leave_type.'" and employee_id="'.$empdetail->id.'" and leave_year="'.date('Y').'"'));
                $opening_bal= $current_bal='0.00';
                if((!empty($model_leave_bal)) && $model_leave_bal->id>0){
                    $opening_bal=$model_leave_bal->leave_opening;
                    $current_bal=$model_leave_bal->leave_current_balance;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$opening_bal);
                $col_index++;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$current_bal);
                $col_index++;
            }
            $row_alphabet_7=$this->cellsToMergeByColsRow($col_index-1); 
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_5.''.$rowCount.':'.$row_alphabet_7.''.$rowCount.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_6.''.$rowCount.':'.$row_alphabet_6.''.$rowCount.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount.':'.$row_alphabet_7.''.$rowCount.'')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(18);
            $j++;
            $end=$rowCount;
            $rowCount++;
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public function actionDownloadConsolidatedReportOriginal()
    {
        $branch_id = $_GET['branch_id'];
        $employee_id = $_GET['employee_id'];
        $department_id = $_GET['department_id'];
        $status = $_GET['status'];
        $condition = '1=1';
        if ($status=='Y') {
            $condition.= ' AND isActive!= "B"';
        }else if ($status=='B') {
            $condition.= ' AND isActive= "B"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if ($branch_id!='') {
            $condition .= ' AND t.branch_or_sponsor_id = "' . $branch_id . '"';
        } else if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        if ($employee_id !='' && $employee_id !=null && $employee_id !='null') {
            $condition .= ' AND t.id = "' . $employee_id . '"';
        }

        if ($department_id != '' && $department_id !=null && $department_id !='null') {
            $condition .= ' AND t.department = "' . $department_id . '"';
        }
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $modelemployee = Employee::model()->findAll(array('condition' => $condition));
        $arr_employee = array();
        foreach ($modelemployee as $key => $value) {
            $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
        }
        ksort($arr_employee); 
        //Salary Master
        $model_master_salary=array();
        $model_usergroup_sal = MasUserGroup::model()->find(array('condition' => 'id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",salary_tab_permission)'));
        if ($model_usergroup_sal->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_salary = EmployeeSalary::model()->with('salary')->findAll(array('group'=>'t.salary_type','order' => 'salary.salary_name ASC'));
        }
        //Document Master
        $model_master_document=array();
        $model_usergroup_doc = MasUserGroup::model()->find(array('condition' => 'id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",document_tab_permission)'));
        if ($model_usergroup_doc->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_document = EmployeeDocuments::model()->with('document')->findAll(array('group'=>'document_id','order' => 'document.document_name ASC'));
        }
        //Leave Master
        $model_master_leave=array();
        $model_usergroup_leave = MasUserGroup::model()->find(array('condition' => 'id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",leave_tab_permission)'));
        if ($model_usergroup_leave->id>0 || Yii::app()->user->authorised_user == 1) {
            $model_master_leave = EmployeeLeave::model()->with('leavetype')->findAll(array('condition' => 'leavetype.branch_id="'.$branch_id.'" and t.leave_year="'.date('Y').'"','group'=>'t.leave_type','order' => 'leavetype.leave_name ASC'));
        }
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(25);
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'No')
            ->setCellValue('B1', 'Branch')
            ->setCellValue('C1', 'Employee Code')
            ->setCellValue('D1', 'Biometric Code')
            ->setCellValue('E1', 'Employee Name')
            ->setCellValue('F1', 'Official Number')
            ->setCellValue('G1', 'Personal Number')
            ->setCellValue('H1', 'Email ID')
            ->setCellValue('I1', 'Division')
            ->setCellValue('J1', 'Designation')
            ->setCellValue('K1', 'Joining Date')
            ->setCellValue('L1', 'Reporting Manager')
            ->setCellValue('M1', 'MOL ID(14 Digits)')
            ->setCellValue('N1', 'IBAN No(23 Digits)')
            ->setCellValue('O1', 'Bank')
            ->setCellValue('P1', 'Routing Code')
            ->setCellValue('Q1', 'Account Number')
            ->setCellValue('R1', 'WPS Entity')
            ->setCellValue('S1', 'Contract')
            ->setCellValue('T1', 'Have OT')
            ->setCellValue('U1', 'Shift')
            ->setCellValue('V1', 'Weekend')
            ->setCellValue('V2', '1')
            ->setCellValue('W2', '2')
            ->setCellValue('X2', '3');
        //sTYLE
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        //Salary Head
        $head_row=1;
        $head_col=24;
        if(!empty($model_master_salary)){
            foreach ($model_master_salary as $key => $salary_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $salary_id->salary->salary_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
                $head_col++;
            }
        }
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Total Salary');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(25);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, 'Payment Mode');
        $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(20);
        $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
        $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
        $head_col++;
        //End Salary Head
        //Document Start
        if(!empty($model_master_document)){
            foreach ($model_master_document as $key => $doc_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $doc_id->document->document_name);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet.'1:'.$row_alphabet.'2');
                $head_col++;
            }
        }
        //End Document Head
        //Leave Start
        if(!empty($model_master_leave)){
            foreach ($model_master_leave as $key => $leave_id) {
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $leave_id->leavetype->leave_name);
                $first_cell=$head_col;
    //            $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet_1=$this->cellsToMergeByColsRow($head_col); 
                $head_col++;
                $second_cell=$head_col;
                $row_alphabet_2=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$row_alphabet_1.'1:'.$row_alphabet_2.'1');
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($first_cell, 2, 'Open Bal');
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($second_cell, 2, 'Cur Bal');
                $head_col++;
            }
        }
        if(empty($model_master_leave)){
            $row_alphabet_2=$row_alphabet;
        }
        $objPHPExcel->getActiveSheet()->getStyle('Y2:'.$row_alphabet_2.'2')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('V2:'.$row_alphabet_2.'2')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('V2:'.$row_alphabet_2.'2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        //End Leave Head
        $adjustment = +($head_col-24);
        $currentColumn = 'X';
        $columnIndex = PHPExcel_Cell::columnIndexFromString($currentColumn);
        $adjustedColumnIndex = $columnIndex + $adjustment;
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($adjustedColumnIndex - 1);
        $objPHPExcel->getActiveSheet()->getStyle('A1:'.$adjustedColumn.'1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('A1:'.$adjustedColumn.'1')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()
        ->getStyle('A1:'.$adjustedColumn.'2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D3D3D3')
                )
            )
        );
        //MERGE CELLS
        $objPHPExcel->getActiveSheet()->mergeCells("A1:A2");
        $objPHPExcel->getActiveSheet()->mergeCells('B1:B2');
        $objPHPExcel->getActiveSheet()->mergeCells('C1:C2');
        $objPHPExcel->getActiveSheet()->mergeCells('D1:D2');
        $objPHPExcel->getActiveSheet()->mergeCells('E1:E2');
        $objPHPExcel->getActiveSheet()->mergeCells('F1:F2');
        $objPHPExcel->getActiveSheet()->mergeCells('G1:G2');
        $objPHPExcel->getActiveSheet()->mergeCells('H1:H2');
        $objPHPExcel->getActiveSheet()->mergeCells('I1:I2');
        $objPHPExcel->getActiveSheet()->mergeCells('J1:J2');
        $objPHPExcel->getActiveSheet()->mergeCells('K1:K2');
        $objPHPExcel->getActiveSheet()->mergeCells('L1:L2');
        $objPHPExcel->getActiveSheet()->mergeCells('M1:M2');
        $objPHPExcel->getActiveSheet()->mergeCells('N1:N2');
        $objPHPExcel->getActiveSheet()->mergeCells('O1:O2');
        $objPHPExcel->getActiveSheet()->mergeCells('P1:P2');
        $objPHPExcel->getActiveSheet()->mergeCells('Q1:Q2');
        $objPHPExcel->getActiveSheet()->mergeCells('R1:R2');
        $objPHPExcel->getActiveSheet()->mergeCells('S1:S2');
        $objPHPExcel->getActiveSheet()->mergeCells('T1:T2');
        $objPHPExcel->getActiveSheet()->mergeCells('U1:U2');
        $objPHPExcel->getActiveSheet()->mergeCells('V1:X1');
        
        $objPHPExcel->getActiveSheet()->getStyle('A1:'.$adjustedColumn.'1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('A2:U2')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('V2:X2')->applyFromArray($styleArray);
//        $objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
        $rowCount = 3;
        $start=$rowCount; $end=0;
        $status_value=array('Y'=>'Yes','N'=>'No');
        $contract=array(1=>'Limited',2=>'Unlimited');
        $payment_mode=array(0=>'All',1=>'Cash',2=>'Cheque',3=>'WPS',4=>'Exchange',5=>'Bank');
        $weekend_days=array(1=>'Monday',2=>'Tuesday',3=>'Wednesday',4=>'Thursday',5=>'Friday',6=>'Saturday',7=>'Sunday');
        $date_from=date('Y-m-d');
        $j=1;
        foreach ($arr_employee as $emp_val) {
            $empdetail = Employee::model()->findbyPK($emp_val);
            $wps_company=$date_join='';
            if(strlen(trim($empdetail->personal_file_no))!=14){
            }
            if(strlen(trim($empdetail->employee_iban_no))!=23 || substr($empdetail->employee_iban_no, 0, 2)!='AE'){
            }
            if($empdetail->employee_wps_company>0){
                $model_wps_company=MasCompanyWpsDetails::model()->findByPK($empdetail->employee_wps_company);
                $wps_company=$model_wps_company->company_name; 
            }else{
            }
            if($empdetail->date_join!='' & $empdetail->date_join!='0000-00-00'){
                $date_join= date("d/m/Y", strtotime($empdetail->date_join));
            }
            $shift_detail='-';
            if($empdetail->isActive!='B'){
                //Shift Details
                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $empdetail->id . '"'));
                if($model_shift->id>0){
                    $shift_detail=$model_shift->shiftdetails->shift_name.'('.$model_shift->shiftdetails->start_time.'-'.$model_shift->shiftdetails->end_time.')';
                }
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $j);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employee_biometric_code, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$empdetail->phone, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$empdetail->mobile, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$empdetail->email, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('I'.$rowCount,$empdetail->departmentdetail->department_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('J'.$rowCount,$empdetail->designationdetail->designation_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('K'.$rowCount, $date_join);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('L'.$rowCount,$empdetail->reportingmanager->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('M'.$rowCount,$empdetail->personal_file_no, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('N'.$rowCount,$empdetail->employee_iban_no, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('O'.$rowCount,$empdetail->bankdetail->bank_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('P'.$rowCount,$empdetail->bankdetail->routing_code, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('Q'.$rowCount,$empdetail->employee_accountno, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('R'.$rowCount,$wps_company, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('S'.$rowCount,$contract[$empdetail->employee_type], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('T'.$rowCount,$status_value[$empdetail->overtime], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('U'.$rowCount,$shift_detail, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('V'.$rowCount,$weekend_days[$empdetail->weekend_off1], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('W'.$rowCount,$weekend_days[$empdetail->weekend_off2], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('X'.$rowCount,$weekend_days[$empdetail->weekend_off3], PHPExcel_Cell_DataType::TYPE_STRING);
            $total_salary=0.00;
            $col_index=24;
            $row_alphabet_3=$this->cellsToMergeByColsRow($col_index); 
            foreach ($model_master_salary as $key_3 => $salary_id) {
                $model_salary_details = EmployeeSalary::model()->find(array('condition' => 'salary_type="'.$salary_id->salary_type.'" and employee_id="'.$empdetail->id.'" and valid_to="0000-00-00"'));
                $salary_amount='0.00';
                if($model_salary_details->id>0){
                    $salary_amount=$model_salary_details->amount;
                    $total_salary+=$salary_amount;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,Yii::app()->numberFormatter->formatCurrency($salary_amount," "));
                $col_index++;
            }
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,Yii::app()->numberFormatter->formatCurrency($total_salary," "));
            $row_alphabet_4=$this->cellsToMergeByColsRow($col_index); 
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_3.''.$rowCount.':'.$row_alphabet_4.''.$rowCount.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_4.''.$rowCount.':'.$row_alphabet_4.''.$rowCount.'')->getFont()->setSize(12)->setBold( true );
            $col_index++;
            $row_alphabet_5=$this->cellsToMergeByColsRow($col_index); 
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$payment_mode[$empdetail->payment_type]);
            $col_index++;
            //sALRY eND
            foreach ($model_master_document as $key_1 => $doc_id) {
                $model_document_number = EmployeeDocuments::model()->find(array('condition' => 'document_id="'.$doc_id->document_id.'" and employee_id="'.$empdetail->id.'"'));
                $document_number='-';
                if($model_document_number->id>0){
                    $document_number=$model_document_number->document_number;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$document_number);
                $col_index++;
            }
            //lEAVE
            foreach ($model_master_leave as $key_2 => $leave_id) {
                $model_leave_bal = EmployeeLeave::model()->find(array('condition' => 'leave_type="'.$leave_id->leave_type.'" and employee_id="'.$empdetail->id.'" and leave_year="'.date('Y').'"'));
                $opening_bal= $current_bal='0.00';
                if($model_leave_bal->id>0){
                    $opening_bal=$model_leave_bal->leave_opening;
                    $current_bal=$model_leave_bal->leave_current_balance;
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$opening_bal);
                $col_index++;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($col_index, $rowCount,$current_bal);
                $col_index++;
            }
            $row_alphabet_6=$this->cellsToMergeByColsRow($col_index-1); 
            $objPHPExcel->getActiveSheet()->getStyle(''.$row_alphabet_5.''.$rowCount.':'.$row_alphabet_6.''.$rowCount.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rowCount.':'.$row_alphabet_6.''.$rowCount.'')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(18);
            $j++;
            $end=$rowCount;
            $rowCount++;
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    function cellsToMergeByColsRow($head_col){
        $head_col++;
        $adjustment = +($head_col-25);
        $currentColumn = 'Y';
        $columnIndex = PHPExcel_Cell::columnIndexFromString($currentColumn);
        $adjustedColumnIndex = $columnIndex + $adjustment;
        $adjustedColumn = PHPExcel_Cell::stringFromColumnIndex($adjustedColumnIndex - 1);
        return $adjustedColumn;
    }

   

//---------------------------document------------------------------------

public function actionDownloadDocumentReport()
{
    $branch_id = $_GET['branch_id'];
    $employee_id = $_GET['employee_id'];
    $department_id = $_GET['department_id'];
    $doc_document_id = $_GET['doc_document_id'];
    $status = $_GET['status'];
    $model_user = User::model()->findByPk(Yii::app()->user->id);
    $condition = '1=1';
                    if ($status=='Y') {
                        $condition.= ' AND isActive!= "B"';
                    }else if ($status=='B') {
                        $condition.= ' AND isActive= "B"';
                    }
                    if ($branch_id!='') {
                        $condition .= ' AND t.branch_or_sponsor_id = "' . $branch_id . '"';
                    } else if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                        $condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
                    }
                    if ($employee_id !='' && $employee_id !=null && $employee_id !='null') {
                        $condition .= ' and t.id IN (' .$employee_id. ')';
                    }
                    /*
                    if ($department_id != '' && $department_id !=null && $department_id !='null') {
                        $condition .= ' and t.department IN (' .$department_id. ')';
                    }
                    */
                    if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                        $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
                    }
                    $modelemployee = Employee::model()->findAll(array('condition' => $condition));
                    //Document Master
    $model_master_document=array();
    $model_usergroup_doc = MasUserGroup::model()->find(array('condition' => 'id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",document_tab_permission)'));
    if (!empty($model_usergroup_doc) && $model_usergroup_doc->id>0 || Yii::app()->user->authorised_user == 1) {
        $model_master_document = MasDocument::getEmployeeDocument();


    }

   
                    $arr_employee = array();
                    foreach ($modelemployee as $key => $value) {
                        $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
                    }
                    ksort($arr_employee);

                   
    $i=0;
    Yii::import('ext.PHPExcel.PHPExcel');
    $objPHPExcel = new PHPExcel();
    // Add some data
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
    
    $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'No')
        ->setCellValue('B1', 'Branch')
        ->setCellValue('C1', 'Employee Code')
        ->setCellValue('D1', 'Profile Photo')
        ->setCellValue('E1', 'Employee Name');

        $head_row=1;
        $head_col=5;
       
        foreach ($model_master_document as $key => $doc_id) { 
            $i=$i+1;

           if ($doc_document_id!='')
           {
            if ($doc_document_id==$key){
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $doc_id);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $initital_row=$this->cellsToMergeByColsRow($head_col);
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, 2, "No");
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet=$this->cellsToMergeByColsRow($head_col); 
                $head_col=$head_col+1;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, 2, "Expiry Date");
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $end_row=$this->cellsToMergeByColsRow($head_col); 
                $head_col=$head_col+1;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, 2, "Attachment");
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $end_row=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->mergeCells(''.$initital_row.'1:'.$end_row.'1');
           
            }

            }else{

                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, $head_row, $doc_id);
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $initital_row=$this->cellsToMergeByColsRow($head_col); 
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, 2, "No");
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $row_alphabet=$this->cellsToMergeByColsRow($head_col);
                $head_col=$head_col+1;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, 2, "Expiry Date");
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $end_row=$this->cellsToMergeByColsRow($head_col);
                $head_col=$head_col+1;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($head_col, 2, "Attachment");
                $objPHPExcel->getActiveSheet()->getColumnDimensionByColumn($head_col)->setWidth(30);
                $end_row=$this->cellsToMergeByColsRow($head_col);
                $head_col=$head_col+1;
                $objPHPExcel->getActiveSheet()->mergeCells(''.$initital_row.'1:'.$end_row.'1');
           }
        }       
    
    //sTYLE
    $styleArray = array(
    'borders' => array(
        'allborders' => array(
          'style' => PHPExcel_Style_Border::BORDER_THIN
        )
      )
    );
   
    //MERGE CELLS
    $objPHPExcel->getActiveSheet()->mergeCells("A1:A2");
    $objPHPExcel->getActiveSheet()->mergeCells('B1:B2');
    $objPHPExcel->getActiveSheet()->mergeCells('C1:C2');
    $objPHPExcel->getActiveSheet()->mergeCells('D1:D2');
    $objPHPExcel->getActiveSheet()->mergeCells('E1:E2');
   

   $first_row="A";

    $objPHPExcel->getActiveSheet()->getStyle(''.$first_row.'1:'.$end_row.'2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle(''.$first_row.'1:'.$end_row.'2')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()
        ->getStyle(''.$first_row.'1:'.$end_row.'2');

    $objPHPExcel->getActiveSheet()
        ->getStyle(''.$first_row.'1:'.$end_row.'2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D3D3D3')
                )
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle(''.$first_row.'1:'.$end_row.'2')->applyFromArray($styleArray);
   
    $rowCount = 3;
    $start=$rowCount; $end=0;
   
    $date_from=date('Y-m-d');
    $j=1;
    foreach ($arr_employee as $emp_val) {
        $empdetail = Employee::model()->findbyPK($emp_val);
        if($empdetail->profile_photo!="")
        {
            $profilephoto="Yes";
        }
        else{
            $profilephoto="No";
        }

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $j);
        $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
        $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
        $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$profilephoto, PHPExcel_Cell_DataType::TYPE_STRING);
        $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
        $new_head_col=5;
        $style = array(
            'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,           
            )
            );
            
            $objPHPExcel->getDefaultStyle()->applyFromArray($style);                                
        foreach ($model_master_document as $key_1 => $doc_id) {
            $expiry_date="";
            $dfile="";
            if ($doc_document_id!='')
           {
           if ($doc_document_id==$key_1){

            $model_document_number = EmployeeDocuments::model()->find(array('condition' => 'document_id="'.$key_1.'" and employee_id="'.$empdetail->id.'"'));
            $document_number='-';
            
            if(!empty($model_document_number) && $model_document_number->id>0){
                
                $document_number=$model_document_number->document_number;
                $expiry_date=$model_document_number->validate_till_date;
                $expiry_date=date("d/m/Y",strtotime($expiry_date));
                $doc_file=$model_document_number->document_file;
                
                if($doc_file)
            {
                $dfile="Yes";
            }
            else{

                $dfile="No";
            }
                
            }
            else{
                $document_number="";
                $expiry_date="";
                $dfile="";
              

            }
           $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($new_head_col, $rowCount,$document_number);           
           $new_head_col=$new_head_col+1;
           $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($new_head_col, $rowCount,$expiry_date);
           $new_head_col=$new_head_col+1;
           $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($new_head_col, $rowCount,$dfile);
          }

            }else{
                $model_document_number = EmployeeDocuments::model()->find(array('condition' => 'document_id="'.$key_1.'" and employee_id="'.$empdetail->id.'"'));
                $document_number='-';
                if(!empty($model_document_number) && $model_document_number->id>0){
                    $document_number=$model_document_number->document_number;
                    $expiry_date=$model_document_number->validate_till_date;
                    $expiry_date=date("d/m/Y",strtotime($expiry_date));
                    $doc_file=$model_document_number->document_file;
                    if($doc_file)
                        {
                            $dfile="Yes";
                        }
                        else{

                            $dfile="No";
                        }
                    
                }
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($new_head_col, $rowCount,$document_number);                
                $new_head_col=$new_head_col+1;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($new_head_col, $rowCount,$expiry_date);
                $new_head_col=$new_head_col+1;
                $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($new_head_col, $rowCount,$dfile);
                $new_head_col=$new_head_col+1;
            }
        
        }
        $j++;
        $end=$rowCount;
        $rowCount++;
    }
    // Rename worksheet
    $objPHPExcel->getActiveSheet()->setTitle('Employee Document Details');
    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $objPHPExcel->setActiveSheetIndex(0);
    header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
    header('Content-Disposition: attachment;filename="Employee Document Details.xls"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');
    // If you're serving to IE over SSL, then the following may be needed
    header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header ('Pragma: public'); // HTTP/1.0
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    $objWriter->save('php://output');
}



//---------------------------document vertical report------------------------------------

public function actionDownloadDocumentverticalReport()
{
    $branch_id = $_GET['branch_id'];
    $employee_id = $_GET['employee_id'];
    $department_id = $_GET['department_id'];
    $doc_document_id = $_GET['doc_document_id'];
    $status = $_GET['status'];
    $document_status = $_GET['document_status'];
    $model_user = User::model()->findByPk(Yii::app()->user->id);
    $condition = '1=1';
                    if ($status=='Y') {
                        $condition.= ' AND isActive!= "B"';
                    }else if ($status=='B') {
                        $condition.= ' AND isActive= "B"';
                    }
                    if ($branch_id!='') {
                        $condition .= ' AND t.branch_or_sponsor_id = "' . $branch_id . '"';
                    } else if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                        $condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
                    }
                    if ($employee_id !='' && $employee_id !=null && $employee_id !='null') {
                        $condition .= ' and t.id IN (' .$employee_id. ')';
                    }
                    /*
                    if ($department_id != '' && $department_id !=null && $department_id !='null') {
                        $condition .= ' and t.department IN (' .$department_id. ')';
                    }
                    */
                    if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
                        $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
                    }
                    $modelemployee = Employee::model()->findAll(array('condition' => $condition));
                
                    //Document Master
    $model_master_document=array();
    $model_usergroup_doc = MasUserGroup::model()->find(array('condition' => 'id="'.$model_user->user_group_id.'" and FIND_IN_SET("'.$branch_id.'",document_tab_permission)'));
    if ((!empty($model_usergroup_doc) && $model_usergroup_doc->id>0) || Yii::app()->user->authorised_user == 1) {
        $model_master_document = MasDocument::getEmployeeDocument();

    }
                    $arr_employee = array();
                    foreach ($modelemployee as $key => $value) {
                        $arr_employee[$value->employeefullname . ' ' . $value->employeecode] = $value['id'];
                    }
                    ksort($arr_employee);
    $i=0;
    Yii::import('ext.PHPExcel.PHPExcel');
    $objPHPExcel = new PHPExcel();
    // Add some data
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(35);
    
    $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'No')
        ->setCellValue('B1', 'Branch')
        ->setCellValue('C1', 'Employee Code')       
        ->setCellValue('D1', 'Employee Name')
        ->setCellValue('E1', 'Document Name')
        ->setCellValue('F1', 'Document ID')
        ->setCellValue('G1', 'Document Expiry')
        ->setCellValue('H1', 'Document Attached');

        $head_row=1;
        $head_col=5;
       
       
    //sTYLE
    $styleArray = array(
    'borders' => array(
        'allborders' => array(
          'style' => PHPExcel_Style_Border::BORDER_THIN
        )
      )
    );
   
    //MERGE CELLS
    $objPHPExcel->getActiveSheet()->mergeCells("A1:A2");
    $objPHPExcel->getActiveSheet()->mergeCells('B1:B2');
    $objPHPExcel->getActiveSheet()->mergeCells('C1:C2');
    $objPHPExcel->getActiveSheet()->mergeCells('D1:D2');
    $objPHPExcel->getActiveSheet()->mergeCells('E1:E2');
    $objPHPExcel->getActiveSheet()->mergeCells('F1:F2');
    $objPHPExcel->getActiveSheet()->mergeCells('G1:G2');
    $objPHPExcel->getActiveSheet()->mergeCells('H1:H2');
    //$objPHPExcel->getActiveSheet()->mergeCells('I1:I2');
   

   $first_row="A";
   $end_row="H";

    $objPHPExcel->getActiveSheet()->getStyle(''.$first_row.'1:'.$end_row.'2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle(''.$first_row.'1:'.$end_row.'2')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()
        ->getStyle(''.$first_row.'1:'.$end_row.'2');

    $objPHPExcel->getActiveSheet()
        ->getStyle(''.$first_row.'1:'.$end_row.'2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D3D3D3')
                )
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle(''.$first_row.'1:'.$end_row.'2')->applyFromArray($styleArray);
   
    $rowCount = 3;
    $start=$rowCount; $end=0;
   
    $date_from=date('Y-m-d');
    $k=1;
    foreach ($arr_employee as $emp_val) {
        $empdetail = Employee::model()->findbyPK($emp_val);

        if($empdetail->profile_photo!="")
                            {

                                $profilephoto="Yes";
                            }
                            else{

                                $profilephoto="No";
                            }


                            if ($doc_document_id=='' || $doc_document_id=='P')
                            {
                                if ($document_status=='1')
                                {
                                    if($profilephoto=="Yes")
                                    {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);                
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,"Profile Photo", PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,"-", PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,"-", PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$profilephoto, PHPExcel_Cell_DataType::TYPE_STRING);
                $k=$k+1;
                $rowCount=$rowCount+1;
                                }
                            }


                           else if ($document_status=='2')
                            {
                                if($profilephoto=="No")
                                {
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);            
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,"Profile Photo", PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,"-", PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,"-", PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$profilephoto, PHPExcel_Cell_DataType::TYPE_STRING);
            $k=$k+1;
            $rowCount=$rowCount+1;
                         
                            }
                        }
                        else 
                        {

            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);            
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,"Profile Photo", PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,"-", PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,"-", PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$profilephoto, PHPExcel_Cell_DataType::TYPE_STRING);
            $k=$k+1;
            $rowCount=$rowCount+1; 

                        }
                            }else{

                               // $k=$k+1;
                            }

                            foreach ($model_master_document as $key_1 => $doc_id)
                                 {
                                    $expiry_date="";
                                    $dfile="";
                                    if ($doc_document_id!='')
                                   {
                                   if ($doc_document_id==$key_1){
                                    $model_document_number = EmployeeDocuments::model()->find(array('condition' => 'document_id="'.$key_1.'" and employee_id="'.$empdetail->id.'"'));
                                    $document_number='-';
                                    $expiry_date='-';
                                                if(!empty($model_document_number) && $model_document_number->id>0)
                                                {
                                                    $document_id=$model_document_number->document_id;
                                                    $document_number=$model_document_number->document_number;
                                                    $expiry_date=$model_document_number->validate_till_date;
                                                    $expiry_date=date("d/m/Y",strtotime($expiry_date));
                                                    $doc_file=$model_document_number->document_file;
                                                                if($doc_file)
                                                            {
                                                                $dfile="Yes";
                                                            }
                                                            else{

                                                                $dfile="No";
                                                            }

                                            // $k=$k+1;
                                                    
                                                }else{
                                                    $document_id=$key_1;
                                                    $dfile="No";
                                                // $k=$k+1;

                                                }

                                    if($document_status=="1")
                                    {
                                   
                                    if(!empty($model_document_number) && $model_document_number->document_number)
                                   {
                                    $document_master = MasDocument::model()->find(array('condition' => 'id="'.$document_id.'"'));
                                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$document_master->document_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$expiry_date, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$dfile, PHPExcel_Cell_DataType::TYPE_STRING);
                                    
                                       $k=$k+1;
                                       $rowCount=$rowCount+1;
                                   }
                                }
                                else  if($document_status=="2"){

                                    if($model_document_number->document_number=="")
                                    {

                                    $document_master = MasDocument::model()->find(array('condition' => 'id="'.$document_id.'"'));
                                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$document_master->document_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$expiry_date, PHPExcel_Cell_DataType::TYPE_STRING);
                                    $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$dfile, PHPExcel_Cell_DataType::TYPE_STRING);        
                                   $k=$k+1;
                                   $rowCount=$rowCount+1;

                                    }

                                }

                                    else  {

                                        $document_master = MasDocument::model()->find(array('condition' => 'id="'.$document_id.'"'));
                                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$document_master->document_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$expiry_date, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$dfile, PHPExcel_Cell_DataType::TYPE_STRING);        
                                       $k=$k+1;
                                       $rowCount=$rowCount+1;
                                }
                                   
                              
                                  }
        
                                    }else{
                                        $model_document_number = EmployeeDocuments::model()->find(array('condition' => 'document_id="'.$key_1.'" and employee_id="'.$empdetail->id.'"'));
                                        $document_number='-';
                                        $expiry_date='-';
                                        if(!empty($model_document_number) && $model_document_number->id>0){
                                            $document_id=$model_document_number->document_id;
                                            $document_number=$model_document_number->document_number;
                                            $expiry_date=$model_document_number->validate_till_date;
                                            $expiry_date=date("d/m/Y",strtotime($expiry_date));
                                            $doc_file=$model_document_number->document_file;
                                            if($doc_file)
                                                {
                                                    $dfile="Yes";
                                                }
                                                else{

                                                    $dfile="No";
                                                }
                                            
                                        }else{
                                            $document_id=$key_1;
                                            $dfile="No";
                                        }

                                        $document_master = MasDocument::model()->find(array('condition' => 'id="'.$document_id.'"'));
    
                                        if($document_status=="1")
                                        {
                                        if(!empty($model_document_number) && $model_document_number->document_number)
                                       {               
                                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$document_master->document_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$expiry_date, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$dfile, PHPExcel_Cell_DataType::TYPE_STRING);
                                        
                                        $k=$k+1;
                                        $rowCount=$rowCount+1;
                                       }

                                    }

                                    else  if($document_status=="2"){

                                        if($model_document_number->document_number=="")
                                        { 
                                            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$document_master->document_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$expiry_date, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$dfile, PHPExcel_Cell_DataType::TYPE_STRING);
                                            $k=$k+1;
                                            $rowCount=$rowCount+1;
                                        }

                                    }
                                    else {
                                       
                                        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount, $k);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('B'.$rowCount,$empdetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('C'.$rowCount,$empdetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('D'.$rowCount,$empdetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('E'.$rowCount,$document_master->document_name, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('F'.$rowCount,$document_number, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('G'.$rowCount,$expiry_date, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $objPHPExcel->getActiveSheet()->setCellValueExplicit('H'.$rowCount,$dfile, PHPExcel_Cell_DataType::TYPE_STRING);
                                        $k=$k+1;
                                        $rowCount=$rowCount+1;
                                        }

                                    }
       
       
        $style = array(
            'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,           
            )
            );            
            $objPHPExcel->getDefaultStyle()->applyFromArray($style);              
            $document_id="";
            $expiry_date="";
            $document_number="";
        }
        //$k++;
        $end=$rowCount;
        $rowCount;
        
    }
    // Rename worksheet
    $objPHPExcel->getActiveSheet()->setTitle('Employee Document Details');
    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $objPHPExcel->setActiveSheetIndex(0);
    header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
    header('Content-Disposition: attachment;filename="Employee Document Details vertcal.xls"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');
    // If you're serving to IE over SSL, then the following may be needed
    header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header ('Pragma: public'); // HTTP/1.0
    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
    $objWriter->save('php://output');
}
public function actionleavesettlementexceldownload()
    {
        $branch_id= (int)Yii::app()->request->getParam('branch_id');
        $condition ='t.isActive="Y"';
        if($branch_id>0){
            $condition.=' and branch_or_sponsor_id = "'.$branch_id.'"';
        }  
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeecode.' '.$value->employeefullname]=$value->id;
        }
        ksort($arr_employee); 
        $current_date=date('Y-m-d');
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->mergeCells('A1:F1');
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'LEAVE SETTLEMENT LIST');
        $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(45);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A2', 'NO')
            ->setCellValue('B2', 'CODE')
            ->setCellValue('C2', 'EMPLOYEE NAME')
            ->setCellValue('D2', 'SALARY')
            ->setCellValue('E2', 'DUE DAYS')
            ->setCellValue('F2', 'AMOUNT');
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        $objPHPExcel->getActiveSheet()->getStyle('A2:I2')->applyFromArray($styleArray);
        $objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()
        ->getStyle('A2:F2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D1D2D4')
                )
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle('A2:F2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle("A2:F2")->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('F')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        
        $rowCount = 3;
        $start=$rowCount; $end=0;
        $j=1;
        $total_gratuity=0.00;
         if(!empty($arr_employee)){      
            $n=1;
            $total_leave_settlement_amount=0.00;
            foreach ($arr_employee as $k => $id){
                $model = Employee::model()->findbyPk($id);
                $salary_amount=0.00;       
                $leave_settlement_amount=0.00;
                $leave_count=0;
                $model_leave = EmployeeLeave::model()->with('leavetype')->find(array('select'=>'leave_current_balance','condition' => 't.employee_id="'.$model['id'].'" and encashable="Y" AND leave_year="'.date('Y').'"'));
                if(!empty($model_leave)){
                    $leave_count=$model_leave->leave_current_balance;
                }
                
                $model_salary = EmployeeSalary::model()->with('salary')->find(array('select'=>'sum(amount) as amount','condition' => 'employee_id="'.$model['id'].'" AND salary.consider_leave_settlement="Y" AND (("'.$current_date.'" BETWEEN valid_from AND valid_to) OR (valid_from <= "'.$current_date.'" AND valid_to="0000-00-00"))'));
                if($model_salary->amount>0){
                    $salary_amount=$model_salary->amount;
                    $employee_per_day_salary =round($salary_amount/30, 2);
                    $leave_settlement_amount = round($leave_count * $employee_per_day_salary,2);
                }   
                $total_leave_settlement_amount+=$leave_settlement_amount;                
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount,$j);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $model->employeecode);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $model->employeefullname);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, Yii::app()->numberFormatter->formatCurrency($salary_amount,""));
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $leave_count);
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, Yii::app()->numberFormatter->formatCurrency($leave_settlement_amount,""));
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
            $end=$rowCount;
            $rowCount++;
            $j++;
        }
         }
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':c'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$start.':D'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('F'.$start.':F'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':F'.$end.'')->getFont()->setSize(10);
        $footer_line=$end+1;
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$footer_line.':E'.$footer_line);
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$footer_line, 'TOTAL');
        $objPHPExcel->getActiveSheet()->SetCellValue('F'.$footer_line,$total_leave_settlement_amount);
        $objPHPExcel->getActiveSheet()->getRowDimension($footer_line)->setRowHeight(22);
       $objPHPExcel->getActiveSheet()->getStyle('A'.$footer_line.':F'.$footer_line.'')->getFont()->setSize(12)->setBold( true );

        $objPHPExcel->getActiveSheet()
        ->getStyle('A'.$footer_line.':F'.$footer_line.'')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D1D2D4')
                )
            )
        );
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('LEAVE SETTLEMENT LIST');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Leave Settlement List.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
public function actionPrintEmployeeTeamAttendenceExcel() {
    $status = $_GET['status'];
    $from_date = $_GET['from_date'];
    $to_date = $_GET['to_date'];
    $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
    $condition = 'employeedetail.isActive="Y" AND reporting_manager="' . $empid . '" ';
    /*$arr_employees=$this->getSubordinates($empid);
    $employee_ids=0;
    if(!empty($arr_employees)){
        $employee_ids=implode(',',$arr_employees);
    }
    $condition.= ' and employeedetail.id IN ('.$employee_ids.')';*/
    if ($from_date != '') {
        $from_date = date('Y-m-d', strtotime(str_replace('/', '-', $from_date)));
        $condition.= ' AND t.attendance_date >="' . $from_date . '"';
    }
    if ($to_date != '') {
        $to_date = date('Y-m-d', strtotime(str_replace('/', '-', $to_date)));
        $condition.= ' AND t.attendance_date <="' . $to_date . '"';
    }
    if (isset($_GET['branch']) && $_GET['branch'] > 0) {
            $condition .= ' AND t.branch_or_sponsor_id="' . $_GET['branch'] . '"';
        }
        if ($status != '' && $status > 0) {
            $condition .= ' AND t.status="' . $status . '"';
        }
    $model = new EmployeeAttendance();
    $model = $model->with('employeedetail')->findAll(array('condition'=>$condition,'order'=>'t.attendance_date  ASC'));
    Yii::import('ext.PHPExcel.PHPExcel');
    $objPHPExcel = new PHPExcel();
        // Add some data
    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(13);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(35);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(10);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(10);
    $objPHPExcel->setActiveSheetIndex(0)
    ->setCellValue('A1', 'No')
    ->setCellValue('B1', 'Branch')
    ->setCellValue('C1', 'Date')
    ->setCellValue('D1', 'Code')
    ->setCellValue('E1', 'Name')
    ->setCellValue('F1', 'Login')
    ->setCellValue('G1', 'Logout')
    ->setCellValue('H1', 'Status');
    $objPHPExcel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true)->setSize(12);
    $rowCount = 2;
    $number = 1;
    $objPHPExcel->getActiveSheet()
    ->getStyle('A1:H1')
    ->applyFromArray(
        array(
            'fill' => array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'color' => array('rgb' => 'D3D3D3')
            )
        )
    );
    
    if (!empty($model)) {
        foreach ($model as $row) {
            if ($row['status'] == '1') {
                $status = "Present";
            } else if ($row['status'] == '2') {
                $status = "Absent";
            } else if ($row['status'] == '3') {
                $status = "Leave";
            } else if ($row['status'] == '4') {
                $status = "Holiday";
            } else if ($row['status'] == '5') {
                $status = "Weekend";
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
            $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $row['branch_sponsor']['branch_or_sponsor_name'], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, date('d/m/Y',strtotime($row['attendance_date'])));
            $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $row['employeedetail']['employeecode'], PHPExcel_Cell_DataType::TYPE_STRING);
            $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $row['employeedetail']['employeefullname']);
            $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $row['login_time']);
            $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $row['logout_time']);
            $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $status);
            $end=$rowCount;
            $rowCount++;
            $number++;
        }
    }
        // Rename worksheet
    $objPHPExcel->getActiveSheet()->setTitle('Team Attendance');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $objPHPExcel->setActiveSheetIndex(0);
    header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
    header('Content-Disposition: attachment;filename="Team Attendance.xls"');
    header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

public function getSubordinates($managerId) {
        $employees = [];
        $subordinates = Employee::model()->findAll(array('condition' => 'reporting_manager="' . $managerId . '" AND isActive="Y"'));
        foreach ($subordinates as $subordinate) {
            $employees[] = $subordinate->id;
            $model_reporting_mngr = ReportingManager::model()->find(array('condition' => 'employee_id="' . $subordinate->id . '"'));
            if (!empty($model_reporting_mngr)) {
                $employees = array_merge($employees, $this->getSubordinates($subordinate->id));
            }
        }
        return $employees;
    }
    
    public function actionPrintEmployeeresignationListExcel() {
        $model_resignation = new EmployeeResignation();
        $employee_id = $_GET['employee_id'];
        $date_from = $_GET['date_from'];
        $date_to = $_GET['date_to'];
        $branch = $_GET['branch'];
        $condition = '1=1';
        if ($date_from != '0000-00-00' && $date_from != '') {
            $date_from = str_replace('/', '-', $date_from);
            $date_from = date("Y-m-d", strtotime($date_from));
            $condition .= ' AND apply_date >="' . $date_from . '"';
        }
        if ($date_to != '0000-00-00' && $date_to != '') {
            $date_to = str_replace('/', '-', $date_to);
            $date_to = date("Y-m-d", strtotime($date_to));
            $condition .= ' AND apply_date <="' . $date_to . '"';
        }

        if ($branch != '') {
            $condition .= ' AND employeedetail.branch_or_sponsor_id = "' . $branch . '"';
        } else {
            if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
            }
        }
        if ($employee_id != '') {
            $condition .= ' AND id = "' . $employee_id . '"';
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        $model_resignation = $model_resignation->with('employeedetail', 'noticeperioddetail')->findAll(array('condition' => $condition));
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(35);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(45);
        $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'No')
                ->setCellValue('B1', 'Branch')
                ->setCellValue('C1', 'Employee code')
                ->setCellValue('D1', 'Employee Name')
                ->setCellValue('E1', 'Apply Date')
                ->setCellValue('F1', 'Approved Date')
                ->setCellValue('G1', 'Last Working day')
                ->setCellValue('H1', 'Notice Period')
                ->setCellValue('I1', 'Status');
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true)->setSize(12);
        $startRow=$rowCount = 2;
        $number = 1;
        $objPHPExcel->getActiveSheet()
                ->getStyle('A1:I1')
                ->applyFromArray(
                        array(
                            'fill' => array(
                                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                                'color' => array('rgb' => 'D3D3D3')
                            )
                        )
        );
        
         if (!empty($model_resignation)) {
                foreach ($model_resignation as $empdetail) {
                    $last_date=$apply_date=$approval_date='';
                            if ($empdetail->apply_date != '0000-00-00' && $empdetail->apply_date != '') {
                                $apply_date = date("d/m/Y", strtotime($empdetail->apply_date));
                            }
                            if ($empdetail->approved_date != '0000-00-00' && $empdetail->approved_date != '') {
                                $approval_date = date("d/m/Y", strtotime($empdetail->approved_date));
                            }
                            if ($empdetail->employeedetail->date_leaving != '0000-00-00' && $empdetail->employeedetail->date_leaving != '') {
                                $last_date = date("d/m/Y", strtotime($empdetail->employeedetail->date_leaving));
                            } else if ($empdetail->last_date!= '0000-00-00' && $empdetail->last_date != '') {
                                $last_date = date("d/m/Y", strtotime($empdetail->last_date));
                            }
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $number);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $empdetail->employeedetail->branch_sponsor->branch_or_sponsor_name, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $empdetail->employeedetail->employeecode, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $empdetail->employeedetail->employeefullname, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $apply_date, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $approval_date, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $last_date, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $empdetail->noticeperioddetail->period_name, PHPExcel_Cell_DataType::TYPE_STRING);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, EmployeeResignation::getStatus($empdetail->status), PHPExcel_Cell_DataType::TYPE_STRING);
                $end = $rowCount;
                $rowCount++;
                $number++;
            }
        }
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Employee Resignation Details');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Employee Resignation Details.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
}
