<?php

class HrdatarepresentationController extends Controller {

    //public $layout = 'main';
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetGraph'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() { 
        $this->render('index');
    }
    public function actionGetGraph(){
        
        $graph_from = Yii::app()->request->getparam("graph_from");  
        $branch = Yii::app()->request->getparam("branch");  
        $year = Yii::app()->request->getparam("year"); 
        if($graph_from=='emp_gender'){
            $this->render('graph_by_gender',array('branch'=>$branch));
        }else if($graph_from=='emp_dept'){
            $this->render('graph_by_department',array('branch'=>$branch));
        }else if($graph_from=='emp_desg'){
            $this->render('graph_by_designation',array('branch'=>$branch));
        }else if($graph_from=='emp_document'){
            $this->render('graph_by_document',array('branch'=>$branch));
        }else if($graph_from=='emp_salary'){
            $this->render('graph_by_salary',array('branch'=>$branch,'year'=>$year));
        }else if($graph_from=='employee_graph_month'){
            $this->render('graph_by_month',array('branch'=>$branch,'year'=>$year));
        }
    }
}
