<?php

class HrcompanytemplateController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create','Upload', 'SaveTemplate', 'DeleteTemplate','DownloadTemplate'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $model_module_template = HrModules::model()->findByPK(26);
        if ($model_module_template->grant_access == 1 && $model_module_template->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_template_view']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new HrCompanyTemplates();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $type="";
        if(!empty($_POST['type'])){
        $type= $_POST['type'];
        }
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'branch_detail.branch_or_sponsor_name',
            2 => 'document_title',
            3 => 'document_name',
            4 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (t.document_title LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('branch_detail')->count(array('condition' => $condition));
        $model = $model->with('branch_detail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = '';
            $edit_button=$delete_button=$download_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_template_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/hrcompanytemplate/create&id=' . $row['id'] . '\',\'Edit Template \',\'lg\')"><i class="fa fa-edit"></i></button>';
                $edit_button =1;
                
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_template_delete'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletetemplate(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                $delete_button =1;
                
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_template_download'])  || Yii::app()->user->authorised_user == 1) {
                if($row['document_name']!=''){
                    $button_string.= ' <a href="?r=hr/hrcompanytemplate/downloadtemplate&id=' . $row['id'] . '" title="Download"><button class="btn btn-primary btn-xs" title="Download" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                    $download_button=1;
                }
            }
            $rowData[] = array($m,$row['branch_detail']['branch_or_sponsor_name'],$row['document_title'], array('id'=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button,'download_button'=>$download_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new HrCompanyTemplates();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSaveTemplate() {
        if (isset($_POST['HrCompanyTemplates'])) {
            $model = new HrCompanyTemplates();
            if ((int) @$_POST['HrCompanyTemplates']['id'] > 0) {
                $model->id = (int) $_POST['HrCompanyTemplates']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['HrCompanyTemplates'];
            if ($model->validate()) {
                $model->save();      
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteTemplate() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id != 0) {
            HrCompanyTemplates::model()->updateByPK($id, array('isActive' => 'N','updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')));
            echo CJSON::encode(array('status' => 'success'));
        }
    }   
    public function actionDownloadTemplate() {
        $id = Yii::app()->request->getParam('id');
        $model = HrCompanyTemplates::model()->findByPk($id);
        $file = $model->document_name;
        if ($model->document_name!='') {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/upload_template/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
}
