<?php

class HrattendanceexcuseController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('employeeindex', 'GetEmployeeClarificationList', 'Create', 'SaveDetails', 'viewdetails', 'IndexApproval', 'GetRequestList', 'approvalbylevels', 'saveApproveRequest',
                    'loadmasterbranch', 'Indexlist', 'GetIndexList', 'deleteRequest', 'CreateExcuse', 'Upload', 'DownloadDocument', 'deleteexcusefile', 'SaveexcuseDetails', 'GetEmployeeApprovedList', 'reviewapprovedindex'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl');
    }

    public function actionemployeeindex() {
        $this->layout = 'main';
        $model_module_flexitime = HrModules::model()->findByPK(32);
        if ($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index_employee');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeClarificationList() {
        $model = new HrEmployeeAttendanceExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'apply_date',
            2 => 'status',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        HrEmployeeAttendanceExcuse::model()->updateAll(array('view_status' => 1), 'employee_id="' . $empid . '" and view_status="0" and (status="12" OR status="13")');
        $condition = 't.employee_id="' . $empid . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR apply_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = '';
            $edit_button=$delete_button=0;
            if ($row['status'] == 0 || $row['status'] == 1) {
                $edit_button =1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit  Meeting / Flexi Time Request" onclick="loadPopupModal(\'hr/hrattendanceexcuse/create&id=' . $row['id'] . '\',\'Edit  Meeting / Flexi Time Request \',\'xl\')"><i class="fa fa-pencil"></i></button>&nbsp;';
            }
            $button_string .= '<button class="btn btn-primary btn-xs" title="View  Meeting / Flexi Time Request" onclick="loadPopupModal(\'hr/hrattendanceexcuse/viewdetails&id=' . $row['id'] . '\',\'View Meeting / Flexi Time Request \',\'xl\')"><i class="fa fa-eye"></i></button>';
            if ($row['status'] == 0) {
                $delete_button =1;
                $button_string .= ' <a href="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete  Meeting / Flexi Time Request" onclick="deleteexcuse(\'' . $row['id'] . '\')"><i class="fa fa-trash"></i></a>&nbsp;';
            }
            $rowData[] = array(++$m, date('d/m/Y', strtotime($row['apply_date'])), HrEmployeeAttendanceExcuse::getStatus($row->status), array('id'=>$row['id'],'edit_button'=>$edit_button,'delete_button'=>$delete_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $id = Yii::app()->request->getparam('id');
        $model = new HrEmployeeAttendanceExcuse;
        $model_details = array(new HrEmployeeAttendanceExcuseDetails());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new HrEmployeeAttendanceExcuseDetails());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model, 'model_details' => $model_details));
    }

    public function actionSaveDetails() {
        if (isset($_POST['HrEmployeeAttendanceExcuse'])) {
            $model = new HrEmployeeAttendanceExcuse();
            if ((int) @$_POST['HrEmployeeAttendanceExcuse']['id'] > 0) {
                $model->id = (int) $_POST['HrEmployeeAttendanceExcuse']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_date_time = date('Y-m-d H:i:s');
                $model->updated_by = Yii::app()->user->id;
            } else {
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_by = Yii::app()->user->id;
            }
            $model->attributes = $_POST['HrEmployeeAttendanceExcuse'];
            $model->apply_date = date('Y-m-d');
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $_POST['HrEmployeeAttendanceExcuse']['employee_id'] . '" and functionality_id="12"'));
            if (!empty($model_master_approve_setting)) {
                $model->function_type = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $model->last_approved_level = 0;
            if (isset($_POST['excuse_status']) && $_POST['excuse_status'] != '') {
                $model->status = $_POST['excuse_status'];
            } else {
                $model->status = 0;
            }
            $valid = $model->validate();
            if (isset($_POST['HrEmployeeAttendanceExcuseDetails'])) {
                foreach ($_POST['HrEmployeeAttendanceExcuseDetails'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_details[$i] = HrEmployeeAttendanceExcuseDetails::model()->findByPK($items['id']);
                    } else {
                        $model_details[$i] = new HrEmployeeAttendanceExcuseDetails();
                    }

                    $model_details[$i]->type = $items['type'];
                    if ($items['excuse_date'] != '' && $items['excuse_date'] != '0000-00-00') {
                        $model_details[$i]->excuse_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['excuse_date'])));
                    }
                    //$model_details[$i]->customer_name = $items['customer_name'];
                    if (isset($items['customer_name']) && $items['customer_name'] != '') {
                        $model_details[$i]->customer_name = $items['customer_name'];
                    } else {
                        $model_details[$i]->customer_name = '';
                    }
                    if (isset($items['visit_area']) && $items['visit_area'] != '') {
                        $model_details[$i]->visit_area = $items['visit_area'];
                    } else {
                        $model_details[$i]->visit_area = '';
                    }
                    if ($model->id > 0) {
                        $model_details[$i]->excuse_id = $model->id;
                    }
                    $model_details[$i]->start_time = $items['start_time'];
                    $model_details[$i]->end_time = $items['end_time'];
                    $model_details[$i]->excuse_reason = $items['excuse_reason'];
                    $model_details[$i]->attendance_status = $items['attendance_status'];
                    $model_details[$i]->document = $items['document'];
                    $model_details[$i]->emp_id = $_POST['HrEmployeeAttendanceExcuse']['employee_id'];
                    $valid = $model_details[$i]->validate() && $valid;
                }
            }
            if (empty($model_details)) {
                $valid = false;
            }
            if ($valid) {
                $model->save();
                if (!empty($model_details)) {
                    foreach ($model_details as $eachModel) {
                        $eachModel->excuse_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="32"'));
                if (!empty($model_settings) && !empty($model_mail_settings)) {
                    if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                        Yii::import('application.modules.hr.controllers.MailController');
                        MailController::sendmail(32, $model->employee_id, $model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_details)) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                } else {
                    $error2[] = 'Please enter details in atleast one row';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionviewdetails() {

        $id = Yii::app()->request->getparam('id');
        $model = new HrEmployeeAttendanceExcuse;
        $model_details = array(new HrEmployeeAttendanceExcuseDetails());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('view_details', array('model' => $model, 'model_details' => $model_details), false, true);
    }

    public function actiondeleteRequest() {
        $id = $_POST['id'];
        if ($id > 0) {
            HrEmployeeAttendanceExcuseDetails::model()->deleteAll('excuse_id=:refer_id', array(':refer_id' => $id));
            HrEmployeeAttendanceExcuse::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionIndexApproval() {
        $this->layout = "main";
        $model_module_flexitime = HrModules::model()->findByPK(32);
        if ($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
            $this->render('index_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetRequestList() {
        $model = new HrEmployeeAttendanceExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'apply_date',
            4 => 'status',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $model_user = User::model()->findbypk(Yii::app()->user->id);
        $employee_id = $model_user->employee_id;
        $pending_excuse = HrEmployeeAttendanceExcuse::getintermediateapproval($employee_id, 1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN(' . $pending_excuse . ')';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR apply_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'approvelevel')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'approvelevel')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && (($row->approvelevel->level_1_type == 'L' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'S' && $row->approvelevel->level_1_authority == $employee_id) || ($row->approvelevel->level_1_type == 'N' && $row->approvelevel->level_1_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && (($row->approvelevel->level_2_type == 'L' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'S' && $row->approvelevel->level_2_authority == $employee_id) || ($row->approvelevel->level_2_type == 'N' && $row->approvelevel->level_2_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && (($row->approvelevel->level_3_type == 'L' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'S' && $row->approvelevel->level_3_authority == $employee_id) || ($row->approvelevel->level_3_type == 'N' && $row->approvelevel->level_3_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && (($row->approvelevel->level_4_type == 'L' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'S' && $row->approvelevel->level_4_authority == $employee_id) || ($row->approvelevel->level_4_type == 'N' && $row->approvelevel->level_4_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && (($row->approvelevel->level_5_type == 'L' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'S' && $row->approvelevel->level_5_authority == $employee_id) || ($row->approvelevel->level_5_type == 'N' && $row->approvelevel->level_5_authority == $employee_id))) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $approve_button=0;
            if ($show_approve_button == 1) { //For Approval
                $approve_button =1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Approve/Reject Meeting / Flexi Time Request" onclick="loadPopupModal(\'hr/hrattendanceexcuse/approvalbylevels&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Approve/Reject Meeting / Flexi Time Request\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
            }
            $rowData[] = array(++$m, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, date('d/m/Y', strtotime($row['apply_date'])), HrEmployeeAttendanceExcuse::getStatus($row->status), array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'approve_button'=>$approve_button));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionapprovalbylevels() {
        $id = Yii::app()->request->getParam('id');
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = HrEmployeeAttendanceExcuse::model()->findByPk($id);
        $model_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '" AND rejected_level="0"'));
        $model_rejected_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '" AND rejected_level="1"'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('clarification_approval', array('model' => $model, 'model_details' => $model_details, 'model_rejected_details' => $model_rejected_details, 'level' => $level, 'final_level' => $final_level), false, true);
    }

    public function actionsaveApproveRequest() {
        $model = new HrEmployeeAttendanceExcuse;
        $id = 0;
        $valid = true;
        if (isset($_POST['HrEmployeeAttendanceExcuse'])) {
            if ((int) @$_POST['HrEmployeeAttendanceExcuse']['id'] > 0) {
                $model->id = (int) $_POST['HrEmployeeAttendanceExcuse']['id'];
                $id = (int) $_POST['HrEmployeeAttendanceExcuse']['id'];
                $model = HrEmployeeAttendanceExcuse::model()->findByPK($_POST['HrEmployeeAttendanceExcuse']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $model->status = $_POST['HrEmployeeAttendanceExcuse']['status'];
            $status = $_POST['HrEmployeeAttendanceExcuse']['status'];

            if (isset($_POST['HrEmployeeAttendanceExcuse']['employee_id'])) {
                $employee_id = $_POST['HrEmployeeAttendanceExcuse']['employee_id'];
            }
            $model->last_approved_level = $_POST['HrEmployeeAttendanceExcuse']['last_approved_level'];
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            $level = $_POST['approval_level'];
            $final_level = $_POST['final_level'];
            if ($level == 1 && $final_level == 'N') {
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            } else if ($level == 2 && $final_level == 'N') {
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            } else if ($level == 3 && $final_level == 'N') {
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            } else if ($level == 4 && $final_level == 'N') {
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            } else if ($level == 5 && $final_level == 'N') {
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if ($final_level == 'Y') {
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if (isset($_POST['HrEmployeeAttendanceExcuseDetails'])) {
                foreach ($_POST['HrEmployeeAttendanceExcuseDetails'] as $i => $items) {
                    $model_details[$i] = HrEmployeeAttendanceExcuseDetails::model()->findByPK($items['id']);
                    if (count($_POST['arraycid']) > 0) {
                        if (isset($each) && in_array($each['id'], $_POST['arraycid'])) {
                            
                        }
                        $valid = $model_details[$i]->validate() && $valid;
                    }
                }
            }
            if ($model->validate()) {
                if ($model->save()) {
                    $model_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '"'));
                    foreach ($_POST['HrEmployeeAttendanceExcuseDetails'] as $i => $items) {
                        if (count($_POST['arraycid']) > 0) {
                            if (in_array($items['id'], $_POST['arraycid'])) {
                                HrEmployeeAttendanceExcuseDetails::model()->updateByPK($items['id'], array('excuse_status' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                            } else {
                                HrEmployeeAttendanceExcuseDetails::model()->updateByPK($items['id'], array('excuse_status' => 'N', 'rejected_level' => $level, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                            }
                        } else {
                            HrEmployeeAttendanceExcuseDetails::model()->updateAll(array('excuse_status' => 'N', 'rejected_level' => $level, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')), 'excuse_status="' . $id . '" and excuse_status="N" and rejected_level="0"');
                        }
                    }
                    //Updating Attendance Table
                    if ($status == 12 && $final_level == 'Y') {
                        $model_details_approved = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '" and excuse_status="Y"'));
                        foreach ($model_details_approved as $i => $items) {
                            $date_from = $items->excuse_date;
                            $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $model->employee_id . '"';
                            $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                            if (!empty($model_attendance)) {
                                $model_attendance_details = EmployeeAttendance::model()->findByPK($model_attendance->id);
                                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->employee_id . '"'));
                                if (!empty($model_shift)) {
                                    $model_attendance_details->shift_id = $model_shift->id;
                                }
                                $model_attendance_details->updated_by = Yii::app()->user->id;
                                $model_attendance_details->updated_date_time = date('Y-m-d H:i:s');
                                $model_attendance_details->excuse_reason = $items->excuse_reason;
                                if ($items->attendance_status == 1) {
                                    $model_attendance_details->status = 1;
                                    if (strtotime($items->start_time) < strtotime($model_attendance_details->login_time)) {
                                        $model_attendance_details->login_time = $items->start_time;
                                    }
                                    if (strtotime($items->end_time) > strtotime($model_attendance_details->logout_time)) {
                                        $model_attendance_details->logout_time = $items->end_time;
                                    }
                                    $model_attendance_details->login_punch_from = 'H';
                                    $model_attendance_details->logout_punch_from = 'H';
                                } else {
                                    $model_attendance_details->status = $model_attendance->status;
                                }
                                $model_attendance_details->morning_late = $this->morninglate($model_attendance->employee_id, $date_from, $model_attendance_details->login_time);
                                $model_attendance_details->total_working = $this->totalworking($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                $model_attendance_details->variance_time_loss = $this->totaltimeloss($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                $model_attendance_details->excess_time = $this->excesstime($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                $model_attendance_details->shift_id = $this->shiftdetail($model_attendance->employee_id, $date_from);
                                $model_attendance_details->save();
                            } else {
                                $weekvalue = date('w', strtotime($date_from));
                                $weekvalue += 1;
                                $day = '';
                                if ($weekvalue == 1) {
                                    $day = "Sunday";
                                } else if ($weekvalue == 2) {
                                    $day = "Monday";
                                } else if ($weekvalue == 3) {
                                    $day = "Tuesday";
                                } else if ($weekvalue == 4) {
                                    $day = "Wednesday";
                                } else if ($weekvalue == 5) {
                                    $day = "Thursday";
                                } else if ($weekvalue == 6) {
                                    $day = "Friday";
                                } else if ($weekvalue == 7) {
                                    $day = "Saturday";
                                }
                                $model_attendance_details = new EmployeeAttendance();
                                $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                                OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->employee_id . '"'));
                                if (!empty($model_shift)) {
                                    $model_attendance_details->shift_id = $model_shift->id;
                                }
                                $model_attendance_details->employee_id = $model->employee_id;
                                $model_attendance_details->created_by = Yii::app()->user->id;
                                $model_attendance_details->created_date_time = date('Y-m-d H:i:s');
                                if ($items->attendance_status == 1) {
                                    $model_attendance_details->status = 1;
                                    $model_attendance_details->login_time = $items->start_time;
                                    $model_attendance_details->logout_time = $items->end_time;
                                    $model_attendance_details->login_punch_from = 'H';
                                    $model_attendance_details->logout_punch_from = 'H';
                                } else {
                                    $model_attendance_details->status = 2;
                                    $model_attendance_details->login_time = '';
                                    $model_attendance_details->logout_time = '';
                                }
                                $model_attendance_details->excuse_reason = $items->excuse_reason;
                                $model_attendance_details->branch_or_sponsor_id = $model->employeedetail->branch_or_sponsor_id;
                                $model_attendance_details->attendance_date = $date_from;
                                $model_attendance_details->week_day = $day;
                                $model_attendance_details->attendance_via = 'H';
                                $model_attendance_details->morning_late = $this->morninglate($model->employee_id, $date_from, $model_attendance_details->login_time);
                                $model_attendance_details->total_working = $this->totalworking($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                $model_attendance_details->variance_time_loss = $this->totaltimeloss($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                $model_attendance_details->excess_time = $this->excesstime($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                                $model_attendance_details->shift_id = $this->shiftdetail($model->employee_id, $date_from);
                                $model_attendance_details->save();
                            }
                        }
                    }
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="33"'));
                    if (!empty($model_settings) && !empty($model_mail_settings)) {
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(33, $model->employee_id, $model->id);
                        }
                    }
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            } else {

                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }

    public function actionIndexlist() {
        $model_module_flexitime = HrModules::model()->findByPK(32);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_attendance_excuse_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch = $this->ciphertext($en_id, "d");
            if ($branch != '') {
                $model = new HrEmployeeAttendanceExcuse();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('index_list', array('model' => $model, 'branch' => $branch));
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }

    public function actionGetIndexList() {
        $model = new HrEmployeeAttendanceExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
        //$status=$_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'apply_date',
            4 => 'status',
            5 => ''
        );
        $arr_status = $_POST['status'];
        $status = 'H';
        $pending_status_flag = 0;
        if (is_countable($arr_status) && count($arr_status) > 1) {
            if (in_array('H', $arr_status)) {
                $pending_status_flag = 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status = implode(',', $arr_status);
        } else {
            $status = $arr_status[0];
        }
        $pending_excuse = HrEmployeeAttendanceExcuse::getPendingapproval($branch_id, 1);
        $condition = "employeedetail.branch_or_sponsor_id='" . $branch_id . "'";
        if ($status == 'H') {
            $condition .= " AND t.id IN(" . $pending_excuse . ")";
        } else if ($status != '') {
            if ($pending_status_flag == 0) {
                $condition .= " AND status IN(" . $status . ")";
            } else if ($pending_status_flag == 1) {
                $condition .= " AND (status IN(" . $status . ") OR t.id IN(" . $pending_excuse . "))";
            }
        }
        if ($employee_id > 0) {
            $condition .= ' and t.employee_id ="' . $employee_id . '"';
        }
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR apply_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee = $model_user->hr_connected_employee_id;
        foreach ($model as $row) {
            $button_string = "";
            $last_approved_level = $row->last_approved_level;
            $next_approval_level = $last_approved_level + 1;
            $show_approve_button = 0;
            $level_no = 0;
            $final_level = 'N';
            if ($next_approval_level <= $row->max_level) {
                if ($next_approval_level == 1 && $row->approvelevel->level_1_type == 'H' && $row->approvelevel->level_1_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 1;
                } else if ($next_approval_level == 2 && $row->approvelevel->level_2_type == 'H' && $row->approvelevel->level_2_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 2;
                } else if ($next_approval_level == 3 && $row->approvelevel->level_3_type == 'H' && $row->approvelevel->level_3_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 3;
                } else if ($next_approval_level == 4 && $row->approvelevel->level_4_type == 'H' && $row->approvelevel->level_4_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 4;
                } else if ($next_approval_level == 5 && $row->approvelevel->level_5_type == 'H' && $row->approvelevel->level_5_authority == $hr_connected_employee) {
                    $show_approve_button = 1;
                    $level_no = 5;
                }
            }
            if ($next_approval_level == $row->max_level) {
                $final_level = 'Y';
            }
            $last_level = $row->max_level;
            $approve_excuse=$view_excuse=$delete_excuse=$direct_approve_excuse=0;
            if ($show_approve_button == 1 && $row['status'] > 0 && $row['status'] < 12) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_attendance_excuse_approve']) || Yii::app()->user->authorised_user == 1) {
                    $approve_excuse=1;
//                    $button_string .= '<button class="btn btn-primary btn-xs" title="Approve/Reject  Meeting / Flexi Time Request" onclick="loadPopupModal(\'hr/hrattendanceexcuse/approvalbylevels&final_level=' . $final_level . '&level=' . $level_no . '&id=' . $row['id'] . '\',\'Approve Meeting / Flexi Time Request\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_attendance_excuse_view']) || Yii::app()->user->authorised_user == 1) {
                $view_excuse=1;
//                $button_string .= '<button class="btn btn-primary btn-xs" title="View  Meeting / Flexi Time Request" onclick="loadPopupModal(\'hr/hrattendanceexcuse/viewdetails&id=' . $row['id'] . '\',\' Meeting / Flexi Time Request\',\'xl\')"><i class="fa fa-eye"></i></button>&nbsp;';
            }
            if ($row->status == 1) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_attendance_excuse_delete']) || Yii::app()->user->authorised_user == 1) {
                    $delete_excuse=1;
//                    $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete Meeting / Flexi Time Request" onclick="deleteRequest(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>&nbsp;';
                }
            }
            if ($row->status == 1 || $row->status == 2 || $row->status == 4 || $row->status == 6 || $row->status == 8 || $row->status == 10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_attendance_admin_excuse_approve']) || Yii::app()->user->authorised_user == 1) {
                    $direct_approve_excuse=1;
//                    $button_string .= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/hrattendanceexcuse/approvalbylevels&final_level=Y&level=' . $last_level . '&id=' . $row['id'] . '\',\'Approve Meeting / Flexi Time Request\',\'xl\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';
                }
            }
            $rowData[] = array(++$m, $this->ciphertext($row['employeedetail']['employee_code'], "d"), $row['employeedetail']['employeefullname'], date('d/m/Y', strtotime($row['apply_date'])), HrEmployeeAttendanceExcuse::getStatus($row->status), array('id' => $row['id'], 'last_level' => $last_level, 'status' => $row['status'], 'final_leve1' => $final_level, 'level_no' => $level_no, 'approve_excuse' => $approve_excuse, 'view_excuse' => $view_excuse, 'delete_excuse' => $delete_excuse, 'direct_approve_excuse' => $direct_approve_excuse));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateExcuse() {
        $id = Yii::app()->request->getparam('id');
        $branch = Yii::app()->request->getparam('branch');
        $model = new HrEmployeeAttendanceExcuse;
        $model_details = array(new HrEmployeeAttendanceExcuseDetails());
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_details = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $id . '"'));
            if (empty($model_details)) {
                $model_details = array(new HrEmployeeAttendanceExcuseDetails());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create_excuse', array('model' => $model, 'model_details' => $model_details, 'branch' => $branch));
    }

    public function actionDownloadDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_document = HrEmployeeAttendanceExcuseDetails::model()->findByPk($id);
        $file = $arr_document->document;
        $path = Yii::getPathOfAlias('webroot') . "/uploads/excuse/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    //Function Start
    function morninglate($employee_id, $date, $login_time) {
        $weekend = '';
        $model_general_settings = HrGenerelSettings::model()->find();
        $cool_off_time = $model_general_settings->cool_off_time;
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }
        $mor_late = '00:00';
        if (!empty($model_holiday) && $login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $weektype != 'F' && $model_holiday->id == '') {
            $from_time = strtotime($login_time);
            $secs = strtotime($cool_off_time) - strtotime("00:00:00");
            $morning_start = date("H:i", strtotime($original_start_time) + $secs);
            $morning_shift_in_time = strtotime($morning_start);
            $shift_in_time = strtotime($original_start_time);
            $time_diff = $from_time - $shift_in_time;
            if ($morning_shift_in_time >= $from_time) {
                $mor_late = '00:00';
            } else {
                $mor_late = gmdate('H:i', $time_diff);
            }
        }
        return $mor_late;
    }

    //Morning Late-End
    //Total Working -Start
    function totalworking($employee_id, $date, $login_time, $logout_time) {
        $total_working = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if (!empty($model_shift) && $model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                if ($model_master_shift->shift_type == 'N') {
                    $diff = ($working_start_time - $working_stop_time);
                } else {
                    if ($working_stop_time > $working_start_time) {
                        $diff = ($working_stop_time - $working_start_time);
                    } else {
                        $diff = ($working_start_time - $working_stop_time);
                    }
                }
            } else {
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
            }
            $total_working = gmdate('H:i', $diff);
        }
        return $total_working;
    }

    //Total Working -End
    //Total Time Loss Per Day -Start
    function totaltimeloss($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        $weekend = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_timeloss = '00:00';
        if (!empty($model_holiday) && $model_holiday->id == '') {
            if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
                $working_stop_time = strtotime($login_time);
                $working_start_time = strtotime($logout_time);
                if ($working_stop_time > $working_start_time) {
                    $diff = ($working_stop_time - $working_start_time);
                } else {
                    $diff = ($working_start_time - $working_stop_time);
                }
                $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
                if ((strtotime($total_working) < strtotime($branch_working_hours)) && $weekend == 0) {
                    $timeloss_stop_time = strtotime($branch_working_hours);
                    $timeloss_start_time = strtotime($total_working);
                    $timeloss_diff = ($timeloss_stop_time - $timeloss_start_time);
                    $total_timeloss = gmdate('H:i', $timeloss_diff);
                }
            }
        }
        return $total_timeloss;
    }

    //Total Time Loss Per Day -End
    //Total Excess Time Per Day -Start
    function excesstime($employee_id, $date, $login_time, $logout_time) {
        $model = Employee::model()->findbyPK($employee_id);
        $weekvalue = date('w', strtotime($date));
        $weekvalue += 1;
        $weektype = '';
        $weekend = '';
        //Weekend
        if ($model->weekend_off1 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off1_type;
        }
        if ($model->weekend_off2 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off2_type;
        }
        if ($model->weekend_off3 == $weekvalue) {
            $weekend = 1;
            $weektype = $model->weekend_off3_type;
        }
        //Branch Working Hours
        $model_branch = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
        $branch_working_hours = $model_branch->branch_working_hours;
        //Holiday
        $model_holiday = MasHoliday::model()->find(array('condition' => 'FIND_IN_SET("' . $model->branch_or_sponsor_id . '",branch_id)  AND holiday_date="' . $date . '"'));
        //Shift
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
            $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
            $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            //Shift time total Hrs
            $shift_working_stop_time = strtotime($original_stop_time);
            $shift_working_start_time = strtotime($original_start_time);
            $shift_working_diff = ($shift_working_stop_time - $shift_working_start_time);
            $branch_working_hours = gmdate('H:i', $shift_working_diff);
        } else if ($weekend == 1 && $weektype == 'H') {
            $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
        } else {
            $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
            $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
            $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
        }

        $total_working = $total_excess_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $working_stop_time = strtotime($login_time);
            $working_start_time = strtotime($logout_time);
            if ($working_stop_time > $working_start_time) {
                $diff = ($working_stop_time - $working_start_time);
            } else {
                $diff = ($working_start_time - $working_stop_time);
            }
            $total_working = $this->totalworking($employee_id, $date, $login_time, $logout_time);
            if (!empty($model_holiday) && ($weekend == 1 || $model_holiday->id > 0)) {
                $total_excess_time = $total_working;
            } else if (strtotime($total_working) > strtotime($branch_working_hours)) {
                $stop_time = strtotime($total_working);
                $start_time = strtotime($branch_working_hours);
                ;
                $time_excess = ($stop_time - $start_time);
                $total_excess_time = gmdate('H:i', $time_excess);
            }
        }
        return $total_excess_time;
    }

    //Total Excess Time Per Day -End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayasworkingovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_holiday_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_holiday_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

    //Holiday Overtime Calculation Beyond Working Time-End
    //Holiday Overtime Calculation Beyond Working Time-Start
    function holidayovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_holiday_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_holiday_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($diff > 0) {
                $work_time_1 = gmdate('H:i', $diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $diff);
                }
            }
        }
        return $over_time;
    }

    //Holiday Overtime Calculation Beyond Working Time-End
    //Normal Overtime Calculation-Start
    function normalovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_normal_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_normal_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

    //Normal Overtime Calculation-End
    //Weeekend Overtime Calculation-Start
    function weekendovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_weekend_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_weekend_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            if ($weektype == 'F') {
                if ($diff > 0) {
                    $work_time_1 = gmdate('H:i', $diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $diff);
                    }
                }
            } else if ($weektype == 'H') {
                //Original time
                $original_start_time = strtotime($original_start_time);
                $original_stop_time = strtotime($original_stop_time);
                $original_diff = ($original_stop_time - $original_start_time);
                //Difference
                $overtime_diff = $diff - $original_diff;
                if ($overtime_diff > 0) {
                    $work_time_1 = gmdate('H:i', $overtime_diff);
                    $overtime_diff_1 = strtotime($work_time_1);
                    if ($overtime_diff_1 >= $min_over_time) {
                        $over_time = gmdate('H:i', $overtime_diff);
                    }
                }
            }
        }
        return $over_time;
    }

    //Weekend Overtime Calculation-End
    //Night Shift Overtime Calculation-Start
    function nightshiftovertime($employee_id, $date, $login_time, $logout_time) {
        $over_time = '00:00';
        if ($login_time != '' && $login_time != '0:00' && $login_time != '00:00' && $logout_time != '' && $logout_time != '0:00' && $logout_time != '00:00') {
            $model_settings = HrGenerelSettings::model()->find();
            $min_over_time = strtotime(date("H:i", strtotime($model_settings->overtime_hours)));
            $model = Employee::model()->findbyPK($employee_id);
            $weekvalue = date('w', strtotime($date));
            $weekvalue += 1;
            $weektype = '';
            //Weekend
            if ($model->weekend_off1 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off1_type;
            }
            if ($model->weekend_off2 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off2_type;
            }
            if ($model->weekend_off3 == $weekvalue) {
                $weekend = 1;
                $weektype = $model->weekend_off3_type;
            }
            //Shift
            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
            if ($model_shift->shift_id > 0) {
                $model_master_shift = MasShift::model()->findByPK($model_shift->shift_id);
                $original_start_time = date("H:i", strtotime($model_master_shift->start_time));
                $original_stop_time = date("H:i", strtotime($model_master_shift->end_time));
            } else if ($weekend == 1 && $weektype == 'H') {
                $model_branch_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_branch_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_branch_time->workend_time));
            } else {
                $model_company_time = MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                $original_start_time = date("H:i", strtotime($model_company_time->workstart_time));
                $original_stop_time = date("H:i", strtotime($model_company_time->workend_time));
            }
            //Working Time
            $working_stop_time = strtotime($logout_time);
            if ($model_settings->start_time_night_ot == 'P') {
                $working_start_time = strtotime($login_time);
            } else if ($model_settings->start_time_night_ot == 'C') {
                $punch_start_time = strtotime($login_time);
                $company_start_time = strtotime($original_start_time);
                if ($punch_start_time > $company_start_time) {
                    $working_start_time = $punch_start_time;
                } else {
                    $working_start_time = $company_start_time;
                }
            }
            $diff = ($working_stop_time - $working_start_time);
            //Original time
            $original_start_time = strtotime($original_start_time);
            $original_stop_time = strtotime($original_stop_time);
            $original_diff = ($original_stop_time - $original_start_time);
            //Difference
            $overtime_diff = $diff - $original_diff;
            if ($overtime_diff > 0) {
                $work_time_1 = gmdate('H:i', $overtime_diff);
                $overtime_diff_1 = strtotime($work_time_1);
                if ($overtime_diff_1 >= $min_over_time) {
                    $over_time = gmdate('H:i', $overtime_diff);
                }
            }
        }
        return $over_time;
    }

    //Night Shift Overtime Calculation-End
    function decimalHours($time) {
        $hms = explode(":", $time);
        return ($hms[0] + ($hms[1] / 60) + ($hms[2] / 3600));
    }

    function shiftdetail($employee_id, $date) {
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date . '" AND to_date>="' . $date . '") OR  (from_date BETWEEN  "' . $date . '" AND  "' . $date . '" OR to_date BETWEEN  "' . $date . '" AND  "' . $date . '")) AND employee_id="' . $employee_id . '"'));
        $shift_id = 0;
        if (!empty($model_shift) && $model_shift->shift_id > 0) {
            $shift_id = $model_shift->shift_id;
        }
        return $shift_id;
    }

    //End Functions
    public function actiondeleteexcusefile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $model_excuse_detail = new HrEmployeeAttendanceExcuseDetails();
        $path = Yii::getPathOfAlias('webroot') . "/uploads/excuse/" . $file_name;
        if (file_exists($path)) {
            unlink($path);
        }
        HrEmployeeAttendanceExcuseDetails::model()->updateByPK($id, array('document' => ''));
        $div_file = '<span id=spanexcusefile_' . $i . '></span>';
        $div_file .= CHtml::activeHiddenField($model_excuse_detail, "[" . $i . "]document", array('value' => ''));
        echo $div_file;
    }

    public function actionSaveexcuseDetails() {
        $model = new HrEmployeeAttendanceExcuse;
        if (isset($_POST['HrEmployeeAttendanceExcuse'])) {
            if ((int) @$_POST['HrEmployeeAttendanceExcuse']['id'] > 0) {
                $model->id = (int) $_POST['HrEmployeeAttendanceExcuse']['id'];
                $model = HrEmployeeAttendanceExcuse::model()->findByPK($_POST['HrEmployeeAttendanceExcuse']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->created_date_time = date('Y-m-d H:i:s');
                $model->created_by = Yii::app()->user->id;
            }
            $model->attributes = $_POST['HrEmployeeAttendanceExcuse'];
            $model->apply_date = date('Y-m-d');
            $employee_id = $_POST['HrEmployeeAttendanceExcuse']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="' . $employee_id . '" and functionality_id="12"'));

            if (!empty($model_master_approve_setting)) {
                $model->function_type = $model_master_approve_setting->id;
                $model->max_level = $model_master_approve_setting->max_level;
            }
            $model->status = $_POST['HrEmployeeAttendanceExcuse']['status'];
            $status = $_POST['HrEmployeeAttendanceExcuse']['status'];
            $model_user = User::model()->findByPK(Yii::app()->user->id);
            if ($status == 12) {
                $model->last_approved_level = $model_master_approve_setting->max_level;
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = 'Auto Approval';
                if ($model_user->employee_id > 0) {
                    $model->approved_by = $model_user->employee_id;
                }else if($model_user->hr_connected_employee_id>0){
                    $model->approved_by=$model_user->hr_connected_employee_id;
                } else {
                    $model->approved_by = 0;
                }
            } else {
                $model->last_approved_level = 0;
            }
            $valid = $model->validate();
            if (isset($_POST['HrEmployeeAttendanceExcuseDetails'])) {
                foreach ($_POST['HrEmployeeAttendanceExcuseDetails'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_details[$i] = HrEmployeeAttendanceExcuseDetails::model()->findByPK($items['id']);
                    } else {
                        $model_details[$i] = new HrEmployeeAttendanceExcuseDetails();
                    }

                    $model_details[$i]->type = $items['type'];
                    if ($items['excuse_date'] != '' && $items['excuse_date'] != '0000-00-00') {
                        $model_details[$i]->excuse_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['excuse_date'])));
                    }
                    $customer_name = '';
                    if (!empty($items['customer_name'])) {
                        $customer_name = $items['customer_name'];
                    }
                    $model_details[$i]->customer_name = $customer_name;
                    if (isset($items['customer_name']) && $items['customer_name'] != '') {
                        $model_details[$i]->customer_name = $items['customer_name'];
                    } else {
                        $model_details[$i]->customer_name = '';
                    }
                    if ($model->id > 0) {
                        $model_details[$i]->excuse_id = $model->id;
                    }
                    $model_details[$i]->start_time = $items['start_time'];
                    $model_details[$i]->end_time = $items['end_time'];
                    $model_details[$i]->excuse_reason = $items['excuse_reason'];
                    $model_details[$i]->attendance_status = $items['attendance_status'];
                    $model_details[$i]->document = $items['document'];
                    $model_details[$i]->emp_id = $_POST['HrEmployeeAttendanceExcuse']['employee_id'];
                    if ($status == 12) {
                        $model_details[$i]->excuse_status = 'Y';
                    } else {
                        $model_details[$i]->excuse_status = 'N';
                    }
                    $valid = $model_details[$i]->validate() && $valid;
                }
            }
            if (empty($model_details)) {
                $valid = false;
            }
            if ($valid) {
                $model->save();
                if (!empty($model_details)) {
                    foreach ($model_details as $eachModel) {
                        $eachModel->excuse_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Updating Attendance Table
                if ($status == 12) {
                    $model_details_approved = HrEmployeeAttendanceExcuseDetails::model()->findAll(array('condition' => 'excuse_id="' . $model->id . '" and excuse_status="Y"'));
                    foreach ($model_details_approved as $i => $items) {
                        $date_from = $items->excuse_date;
                        $con = 'attendance_date="' . $date_from . '" AND employee_id="' . $model->employee_id . '"';
                        $model_attendance = EmployeeAttendance::model()->find(array('condition' => $con));
                        if (!empty($model_attendance)) {
                            $model_attendance_details = EmployeeAttendance::model()->findByPK($model_attendance->id);
                            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                            OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->employee_id . '"'));
                            $model_attendance_details->shift_id = $model_shift->id;
                            $model_attendance_details->updated_by = Yii::app()->user->id;
                            $model_attendance_details->updated_date_time = date('Y-m-d H:i:s');
                            $model_attendance_details->excuse_reason = $items->excuse_reason;
                            if ($items->attendance_status == 1) {
                                $model_attendance_details->status = 1;
                                $model_attendance_details->login_time = $items->start_time;
                                $model_attendance_details->logout_time = $items->end_time;
                                $model_attendance_details->login_punch_from = 'H';
                                $model_attendance_details->logout_punch_from = 'H';
                            } else {
                                $model_attendance_details->status = $model_attendance->status;
                            }
                            $model_attendance_details->morning_late = $this->morninglate($model_attendance->employee_id, $date_from, $model_attendance_details->login_time);
                            $model_attendance_details->total_working = $this->totalworking($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                            $model_attendance_details->variance_time_loss = $this->totaltimeloss($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                            $model_attendance_details->excess_time = $this->excesstime($model_attendance->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                            $model_attendance_details->shift_id = $this->shiftdetail($model_attendance->employee_id, $date_from);
                            $model_attendance_details->save();
                        } else {
                            $weekvalue = date('w', strtotime($date_from));
                            $weekvalue += 1;
                            $day = '';
                            if ($weekvalue == 1) {
                                $day = "Sunday";
                            } else if ($weekvalue == 2) {
                                $day = "Monday";
                            } else if ($weekvalue == 3) {
                                $day = "Tuesday";
                            } else if ($weekvalue == 4) {
                                $day = "Wednesday";
                            } else if ($weekvalue == 5) {
                                $day = "Thursday";
                            } else if ($weekvalue == 6) {
                                $day = "Friday";
                            } else if ($weekvalue == 7) {
                                $day = "Saturday";
                            }
                            $model_attendance_details = new EmployeeAttendance();
                            $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $date_from . '" AND to_date>="' . $date_from . '") OR  (from_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '"
                            OR to_date BETWEEN  "' . $date_from . '" AND  "' . $date_from . '")) AND employee_id="' . $model->employee_id . '"'));
                            $model_attendance_details->shift_id = $model_shift->id;
                            $model_attendance_details->employee_id = $model->employee_id;
                            $model_attendance_details->created_by = Yii::app()->user->id;
                            $model_attendance_details->created_date_time = date('Y-m-d H:i:s');
                            if ($items->attendance_status == 1) {
                                $model_attendance_details->status = 1;
                                $model_attendance_details->login_time = $items->start_time;
                                $model_attendance_details->logout_time = $items->end_time;
                                $model_attendance_details->login_punch_from = 'H';
                                $model_attendance_details->logout_punch_from = 'H';
                            } else {
                                $model_attendance_details->status = 2;
                                $model_attendance_details->login_time = '';
                                $model_attendance_details->logout_time = '';
                            }
                            $model_attendance_details->excuse_reason = $items->excuse_reason;
                            $model_attendance_details->branch_or_sponsor_id = $model->employeedetail->branch_or_sponsor_id;
                            $model_attendance_details->attendance_date = $date_from;
                            $model_attendance_details->week_day = $day;
                            $model_attendance_details->attendance_via = 'H';
                            $model_attendance_details->morning_late = $this->morninglate($model->employee_id, $date_from, $model_attendance_details->login_time);
                            $model_attendance_details->total_working = $this->totalworking($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                            $model_attendance_details->variance_time_loss = $this->totaltimeloss($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                            $model_attendance_details->excess_time = $this->excesstime($model->employee_id, $date_from, $model_attendance_details->login_time, $model_attendance_details->logout_time);
                            $model_attendance_details->shift_id = $this->shiftdetail($model->employee_id, $date_from);
                            $model_attendance_details->save();
                        }
                    }
                } else {
                    //Mail
                    $model_settings = HrGenerelSettings::model()->find();
                    $model_mail_settings = MailSettings::model()->find(array('condition' => 'mail_function="32"'));
                    if (!empty($model_settings) && !empty($model_mail_settings)) {
                        if ($model_settings->enable_mail == 'Y' && $model_mail_settings->isActive == "Y") {
                            Yii::import('application.modules.hr.controllers.MailController');
                            MailController::sendmail(32, $model->employee_id, $model->id);
                        }
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_details)) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_details, '', false), true);
                } else {
                    $error2[] = 'Please enter details in atleast one row';
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionreviewapprovedindex() {
        $this->layout = 'main';
        $model_module_flexitime = HrModules::model()->findByPK(32);
        if ($model_module_flexitime->grant_access == 1 && $model_module_flexitime->isActive == 'Y') {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('approved_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeApprovedList() {
        $model = new HrEmployeeAttendanceExcuse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $filter_employee_id = $_POST['employee_id'];
        $filter_status = $_POST['status'];
        $columns = array(
            0 => 't.id',
            1 => 'employeedetail.employee_code',
            2 => 'employeedetail.first_name',
            3 => 'apply_date',
            4 => 'approved_date',
            5 => 'status',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $employee_id = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 'employeedetail.isActive="Y" AND (t.approve_level1_id="' . $employee_id . '" OR t.approve_level2_id="' . $employee_id . '" OR t.approve_level3_id="' . $employee_id . '" OR t.approve_level4_id="' . $employee_id . '" OR t.approve_level5_id="' . $employee_id . '"  OR t.approved_by="' . $employee_id . '")';
        if ($filter_employee_id > 0) {
            $condition .= ' AND t.employee_id="' . $filter_employee_id . '"';
        }
        if ($filter_status > 0) {
            $condition .= ' AND t.status="' . $filter_status . '"';
        } else {
            $condition .= ' AND (t.status="12" OR t.status="13")';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (employeedetail.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR apply_date LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = '';
            $approval_date = '';
            if ($row['approved_date'] != '0000-00-00' && $row['approved_date'] != '') {
                $approval_date = date("d/m/Y", strtotime($row['approved_date']));
            }
            $button_string .= '<button class="btn btn-primary btn-xs" title="View  Meeting  / Flexi Time Request" onclick="loadPopupModal(\'hr/hrattendanceexcuse/viewdetails&id=' . $row['id'] . '\',\'View  Meeting / Flexi Time Request \',\'xl\')"><i class="fa fa-eye"></i></button>';
            $rowData[] = array(++$m, $row['employeedetail']['employeecode'], $row['employeedetail']['employeefullname'], date('d/m/Y', strtotime($row['apply_date'])), $approval_date, HrEmployeeAttendanceExcuse::getStatus($row->status),array('id'=>$row['id']));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

}
