<?php
class GraphController extends Controller
{
    

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            
array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index','GetListIban','GetListMolid','GetListRoutingid','GetListWpscid'),
                'expression' => '$user->isMember()',
            ),


            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

 public function actionGetListIban()
    {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
            
            
        );
        
      $emp_id = $_POST['myData'];
      $idArray = explode(',', $emp_id);
      $rowData = array();
      $m = 1;
      foreach ($idArray as $id) {
        $div = '';
        
$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $id . '\',' . $id . ',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
$model_iban = Employee::model()->find(array('condition' => 'id=' . $id));
$employee_id   = $model_iban->id;
$employee_name = $model_iban->de_first_name;
$employee_iban_no  = $model_iban->employee_iban_no;
$employee_iban_no_len = strlen($employee_iban_no);

if($employee_iban_no_len!='23'){
    $err_len="Length of IBAN Should be 23"."<font color=red>;</font> &nbsp;&nbsp;&nbsp;";
}else{
  $err_len="";  
}
if ( preg_match('/\s/',$employee_iban_no) ){
    $err_space="IBAN Contains SPACE"."<font color=red>;</font>  &nbsp;&nbsp;&nbsp;";
    }else{
       $err_space=""; 
    }

    $ae = substr($employee_iban_no, 0, 2);
                                   if($ae!='AE'){
                                     $err_ae="IBAN Should Starts with AE"."<font color=red>;</font>  &nbsp;&nbsp;&nbsp;";
                                     }else {

                                       $err_ae=""; 
                                     }

            $rowData[] = array(
                $m,
                $employee_id,
                $employee_name,
                $employee_iban_no,
                $err_len.$err_space.$err_ae,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                
                array('id' => $row->id, 'code' => $row->id, 'status' => $row->isActive)
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    

public function actionGetListMolid()
    {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
            
            
        );
        
      $emp_id = $_POST['myData'];
      $idArray = explode(',', $emp_id);
      $rowData = array();
      $m = 1;
      foreach ($idArray as $id) {
        $div = '';
        
$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $id . '\',' . $id . ',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
$model_molid = Employee::model()->find(array('condition' => 'id=' . $id));
$employee_id   = $model_molid->id;
$employee_name = $model_molid->de_first_name;
$employee_molid  = $model_molid->personal_file_no;
$employee_modelid_len = strlen($employee_molid);

if($employee_modelid_len!='14'){
    $err_len="Length of MOLID Should be 14";
}else{
    $err_len="";

}
if ( preg_match('/\s/',$employee_molid) ){
    $err_space="MOLID Contains SPACE";
    }else{
    $err_space="";

    }

    

            $rowData[] = array(
                $m,
                $employee_id,
                $employee_name,
                $employee_molid,
                
                $err_len.",".$err_space,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                
                array('id' => $row->id, 'code' => $row->id, 'status' => $row->isActive)
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionGetListRoutingid()
    {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
            
            
        );
        
      $emp_id = $_POST['myData'];
      $idArray = explode(',', $emp_id);
      $rowData = array();
      $m = 1;
      foreach ($idArray as $id) {
        $div = '';
        
$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $id . '\',' . $id . ',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
$model_molid = Employee::model()->find(array('condition' => 'id=' . $id));
$employee_id   = $model_molid->id;
$employee_name = $model_molid->de_first_name;
$employee_routingid  = $model_molid->employee_wpscode;
$employee_routingid_len = strlen($employee_routingid);

if($employee_routingid == "")
{
    $err_blank="Routing ID should not blank";
}else if($employee_routingid != ""){
    $err_blank="";
}
if($employee_routingid_len!='9'){
    $err_len="Length of ROUTING ID Should be 9";

}else{
    $err_len="";

}
if ( preg_match('/\s/',$employee_routingid) ){
    $err_space="ROUTING ID Contains SPACE";
    }else{
    $err_space="";

    }
if (is_numeric($employee_routingid)){
                                 $err_nun="";
                                 }else{
                                 $err_nun="ROUTING ID shoud be numeric";
                                 }
    

            $rowData[] = array(
                $m,
                $employee_id,
                $employee_name,
                $employee_routingid,
                
                $err_len.",".$err_space.",".$err_blank.",".$err_nun,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                
                array('id' => $row->id, 'code' => $row->id, 'status' => $row->isActive)
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }


public function actionGetListWpscid()
    {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'id',
            
            
        );
        
      $emp_id = $_POST['myData'];
      $idArray = explode(',', $emp_id);
      $rowData = array();
      $m = 1;
      foreach ($idArray as $id) {
        $div = '';
        
$div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/employeechecker/create&id=' . $id . '\',' . $id . ',\'xl\')"><i class="fa fa-pencil" title="Edit"></i></button>';
$model_wpscid = Employee::model()->find(array('condition' => 'id=' . $id));
$employee_id   = $model_wpscid->id;
$employee_name = $model_wpscid->de_first_name;
$employee_wpscompany  = $model_wpscid->employee_wps_company;


if($employee_wpscompany == "" || $employee_wpscompany == "0")
{
    $err_blank="WPS Company should not blank";
}else if($employee_routingid != ""){
    $err_blank="";
}

    

            $rowData[] = array(
                $m,
                $employee_id,
                $employee_name,
                $employee_wpscompany,
                $err_blank,
                '<div class="btn-wrap text-center">' . $div . '</div>',
                
                array('id' => $row->id, 'code' => $row->id, 'status' => $row->isActive)
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
}
