<?php

class EmployeeticketsController extends Controller
{ 

public $layout = 'layout';   
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','GetEmployeeticketList','ApproveRequest','saveApproveEmployeetickets','EmployeeIndex','encashmentindex',
                                        'GetEncashmentticketList','CreateEncashment','getticketencashed','SaveticketEncashment','ApproveEncashmentRequest',
                                        'ApprovalDocument','downloadapprovaldocument','saveApproveEncashmenttickets','UploadDocument','viewencashmentdetails',
                                        'GetEmployeeEncashmentList','EmployeeCreateEncashment','SaveEncashmentDetails','checkticketencashed','TicketapprovalDocument',
                                        'ViewticketDetails','downloadticketapprovaldocument','ApplyTicket','saveticketdetails','AddticketDetail','LoademployeeDetails',
                                        'Saveticketdetail','Initializeticketdetail','LoademployeeDetail','Saveticketsetting','TicketIndex','GetFamilyTicket','familytkt',
                                        'savefamilyticket','flytktindex','GetFamilyticketList','approvefamilytkt','saveApproveflytickets'
                        ,'viewfamilyticketdetails','deleteticket','ApplyflyTicket','checkfamilyticket','saveflyticketdetails','encashmentapproval','GetEncashmentList','loadmasterbranch','getbranchleave'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }


    public function actionIndex() {
        $model_module_ticket= HrModules::model()->findByPK(8);
        if ($model_module_ticket->grant_access == 1 && $model_module_ticket->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_ticket_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEmployeeticketList(){
        $model=new EmployeeTicket();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $status=$_POST['status'];
        $employee_id=$_POST['employee_id'];
        $year=$_POST['year'];
        $columns = array(
            0 =>'t.id',
            1 =>'employeedetail.employee_code',
            2 =>'employeedetail.first_name',
            3 =>'date_apply',
            4 =>'payment_date',
            5 =>'ticket_amt',
            6 =>'year',
            7 =>'status',
            8 =>'',

        );
        $arr_status=$_POST['status'];
        $status =1;
        if(is_countable($arr_status) && count($arr_status)>1){
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
         $condition = "ticket_type='E'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
       
        if($status!=''){
            $condition.= " AND status IN(".$status.")";
        }
        if($employee_id>0){
             $condition.= ' and t.employee_id ="'.$employee_id.'"';
        }
        if($year>0){
             $condition.= ' and t.year ="'.$year.'"';
        }
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {                    
            $button_string="";
            $approve_reject =$ticket_print=$ticket_approval_download=$ticket_view=0;
            if($row['status']==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Approve/Reject Request" onclick="loadPopupModal(\'hr/employeetickets/approverequest&id='.$row['id'].'\',\'Employee Tickets \',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';                  
                    $approve_reject =1;
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_print'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<a href="?r=hr/employeetickets/ticketapprovaldocument&id=' . $row['id'] . '" title="Approval Document" target="_blank"><button class="btn btn-primary btn-xs" title="Approval Document" ><i class="fa fa-print"></i></button></a>&nbsp;';
                    $ticket_print =1;
                    
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_download'])  || Yii::app()->user->authorised_user == 1) {
                if($row['approval_document']!=""){
                    $button_string.= '<a href="?r=hr/employeetickets/downloadticketapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-primary btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                    $ticket_approval_download=1;
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_view'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="View Details" onclick="loadPopupModal(\'hr/employeetickets/viewticketdetails&id='.$row['id'].'\',\'Employee Ticket Encashment \',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';                 
                $ticket_view=1;
            }
            $date_apply="";
            $date_approved="";
            if($row['date_apply']!='' && $row['date_apply']!='0000-00-00'){
                $date_apply=date("d/m/Y",strtotime($row->date_apply));
            }  
            if($row['date_approved']!='' && $row['date_approved']!='0000-00-00'){
                $date_approved=date("d/m/Y",strtotime($row->date_approved));
            }     
            $rowData[]=array($m,$this->ciphertext($row->employeedetail->employee_code, "d"), $this->ciphertext($row->employeedetail->first_name, "d") . ' ' . $this->ciphertext($row->employeedetail->last_name, "d"),$date_apply,$date_approved,$row['ticket_amt'],$row['year'],EmployeeTicket::getStatus($row->status),array('id'=>$row->id,'approve_reject'=>$approve_reject,'ticket_print'=>$ticket_print,'ticket_approval_download'=>$ticket_approval_download,'ticket_view'=>$ticket_view));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionApproveRequest()
    {
        $id = Yii::app()->request->getparam("id");      
        $model = EmployeeTicket::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('request_form', array('model' => $model), false, true);                                        
    }
	 
    public function actionCreate()
    {
        $id = Yii::app()->request->getparam("id");      
        $model = EmployeeTicket::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('employee_ticket_form', array('model' => $model), false, true);                                        
    }
    public function actionsaveApproveEmployeetickets() {           
        if (isset($_POST['EmployeeTicket'])) {           
            $model=new EmployeeTicket();        
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicket']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicket']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }       
            $employee_id=$model->employee_id;
            $model->status = $_POST['EmployeeTicket']['status']; 
            $status=$_POST['EmployeeTicket']['status']; 
            $model->ticket_amt = $_POST['EmployeeTicket']['ticket_amt']; 
            $model->approval_document = $_POST['EmployeeTicket']['approval_document']; 
            $model->notes = $_POST['EmployeeTicket']['notes']; 
            $model->date_approved= date('Y-m-d');
            if ($model->validate()){                     
                $model->save(); 
                if($status==2){
                    $model_ticket_entitlement= EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and ticket_year="'.date('Y').'"'));
                    if(!empty($model_ticket_entitlement)){
                        $ticket_balance=$model_ticket_entitlement->ticket_balance-100;
                        EmployeeTicketEntitlement::model()->updateByPK($model_ticket_entitlement->id, array('ticket_balance' => $ticket_balance,'updated_by'=> Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')));
                    }else{
                        $model_entitlement = new EmployeeTicketEntitlement();
                        $model_entitlement->created_by = Yii::app()->user->id;
                        $model_entitlement->created_date_time = date('Y-m-d h:i:s');
                        $model_entitlement->employee_id =$employee_id;
                        $model_entitlement->ticket_balance=-100;   
                        $model_entitlement->ticket_year=date('Y');  
                        $model_entitlement->branch_id=$model->employeedetail->branch_or_sponsor_id;  
                        $model_entitlement->save();             
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                echo $error;
            }            
        }
    }
    public function actionEmployeeIndex() {
        $this->layout = 'main';
        $model_module_ticket_encashment = HrModules::model()->findByPK(9);
        if ($model_module_ticket_encashment->grant_access == 1 && $model_module_ticket_encashment->isActive == 'Y') {
            $this->render('employee_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    //Ticket Encashment
    public function actionEncashmentIndex() {
        $model_module_ticket_encashment= HrModules::model()->findByPK(9);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_ticket_encash_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_ticket_encashment->grant_access == 1 && $model_module_ticket_encashment->isActive == 'Y')) {
            $en_id = Yii::app()->request->getParam('id');
            $branch =$this->ciphertext($en_id,"d");
            if($branch!=''){
                $model = new EmployeeTicketEncashment();
                Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
                $this->render('encashment_index', array('model' => $model,'branch'=>$branch));
            }else{
                throw new CHttpException(404, 'Page not found.');
            }
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEncashmentticketList(){
        $model=new EmployeeTicketEncashment();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
       // $status=$_POST['status'];
        $employee_id=$_POST['employee_id'];
        $year=$_POST['year'];
        $branch_id=$_POST['branch_id'];
        $columns = array(
            0 =>'t.id',
            1 =>'employeedetail.employee_code',
            2 =>'employeedetail.first_name',
            3 =>'date_apply',
            4 =>'payment_date',
            5 =>'ticket_amt',
            6 =>'year',
            7 =>'status',
            8 =>'',

        );
        $arr_status=$_POST['status'];
        $status='H';
        $pending_status_flag=0;
        if(is_countable($arr_status) && count($arr_status)>1){
            if (in_array('H', $arr_status)) {
                $pending_status_flag= 1;
            }
            $arr_status = array_diff($arr_status, ['H']);
            if (in_array('1', $arr_status)) {
                $arr_status[] = 0;
            }
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $pending_tktencashment=EmployeeTicketEncashment::getPendingapproval($branch_id,1);
        $condition = "employeedetail.branch_or_sponsor_id='".$branch_id."'";
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        $hr_connected_employee=$model_user->hr_connected_employee_id;
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if($status=='H'){
            $condition.= " AND t.id IN(".$pending_tktencashment.")";
        }else if($status!=''){
            if($pending_status_flag==0){
                $condition.= " AND status IN(".$status.")";
            }else if($pending_status_flag==1){
                $condition.= " AND (status IN(".$status.") OR t.id IN(".$pending_tktencashment."))";
            }
        } 
        if($employee_id>0){
             $condition.= ' and t.employee_id ="'.$employee_id.'"';
        }
        if($year>0){
             $condition.= ' and t.year ="'.$year.'"';
        }
		
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {                    
            $button_string="";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($next_approval_level<=$row->max_level){
                if($next_approval_level==1 && $row->approvelevel->level_1_type=='H' && $row->approvelevel->level_1_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && $row->approvelevel->level_2_type=='H' && $row->approvelevel->level_2_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && $row->approvelevel->level_3_type=='H' && $row->approvelevel->level_3_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && $row->approvelevel->level_4_type=='H' && $row->approvelevel->level_4_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && $row->approvelevel->level_5_type=='H' && $row->approvelevel->level_5_authority == $hr_connected_employee){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if($next_approval_level==$row->max_level){
                $final_level='Y';
            }
            $approve_reject =$print_document=$download_document=$view_ticket=$direct_approval=0;
            if($show_approve_button==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_encash_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-success btn-xs" title="Approve/Reject Ticket Encashment" onclick="loadPopupModal(\'hr/employeetickets/approveencashmentrequest&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Ticket Encashment\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                    $approve_reject =1;
                }
            }
            if($final_level=='Y'){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_encash_print'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<a href="?r=hr/employeetickets/approvaldocument&id=' . $this->ciphertext($row['id'],"e"). '" title="Download Approval Document" target="_blank"><button class="btn btn-warning btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';
                    $print_document =1;
                    
                }                
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_encash_download'])  || Yii::app()->user->authorised_user == 1) {
                if($row['approval_document']!=""){
                    $button_string.= '<a href="?r=hr/employeetickets/downloadapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-warning btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                    $download_document =1;
                    
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_encash_view'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-info btn-xs" title="View Details" onclick="loadPopupModal(\'hr/employeetickets/viewencashmentdetails&id='.$row['id'].'\',\'Employee Ticket Encashment \',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';                 
                $view_ticket =1;
            }
            if ($row->status==1 || $row->status==2 || $row->status==4 || $row->status==6 || $row->status==8 || $row->status==10) {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_ticket_encash_admin_approve'])  || Yii::app()->user->authorised_user == 1) {
                        $last_level=$row->max_level;
                        $button_string.= '<button class="btn btn-warning btn-xs" title="Direct Approval by Special Privilege" onclick="loadPopupModal(\'hr/employeetickets/approveencashmentrequest&final_level=Y&level='.$last_level.'&id=' . $row['id'] . '\',\'Approve/Reject Ticket Encashment\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';       
                        $direct_approval =1;
                        
                }
            }
            $date_apply="";
            $payment_date="";
            $approve_date="";
            if($row['date_apply']!='' && $row['date_apply']!='0000-00-00'){
                $date_apply=date("d/m/Y",strtotime($row->date_apply));
            } 
            if($row['approved_date']!='' && $row['approved_date']!='0000-00-00'){
                $approve_date=date("d/m/Y",strtotime($row->approved_date));
            } 
            if($row['payment_date']!='' && $row['payment_date']!='0000-00-00'){
                $payment_date=date("d/m/Y",strtotime($row->payment_date));
            }                         
            $rowData[]=array($m,$row->employeedetail->employeecode,$row->employeedetail->employeefullname,$date_apply,$approve_date,$payment_date,$row['ticket_amt'],$row['year'],EmployeeTicketEncashment::getStatus($row->status),array('id'=>$row['id'],'final_level'=>$final_level,'level_no'=>$level_no,'en_id'=>$this->ciphertext($row['id'],"e"),'last_level'=>$last_level,'approve_reject'=>$approve_reject,'print_document'=>$print_document,'download_document'=>$download_document,'view_ticket'=>$view_ticket,'direct_approval'=>$direct_approval));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreateEncashment()
    {
        $model = new EmployeeTicketEncashment();
        $id = (int) Yii::app()->request->getParam('id');
        $branch=(int) Yii::app()->request->getParam('branch');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('ticket_encashment', array('model' => $model,'branch'=>$branch), false, true);                                        
    }
    public function actiongetticketencashed() {

        $leavetype= $_POST['leavetype'];
        $year= $_POST['year'];
        $id= $_POST['id'];
        $model_ticket = EmployeeTicket::model()->find(array('condition'=>'employee_id="'.$id.'" and leave_type="'.$leavetype.'" and year="'.$year.'" and status!="3" AND ticket_type="E"'));
        $model_ticket_encashed = EmployeeTicketEncashment::model()->find(array('condition'=>'employee_id="'.$id.'" and leave_id="'.$leavetype.'" and year="'.$year.'" and (status!="3" OR status!="5" OR status!="7" OR status!="9" OR status!="11" OR status!="13")'));
        if(empty($model_ticket) && empty($model_ticket_encashed)){
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionSaveticketEncashment() {
        $model = new EmployeeTicketEncashment();
        if (isset($_POST['EmployeeTicketEncashment'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicketEncashment']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicketEncashment']['id'];
                $model->scenario = 'update';
                $model = EmployeeTicketEncashment::model()->findByPK($_POST['EmployeeTicketEncashment']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->date_apply = date('Y-m-d');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeTicketEncashment'];          
            $model->ticket_amt= $_POST['EmployeeTicketEncashment']['ticket_amt'];  
            $model->status = 1;
            $employee_id= $_POST['EmployeeTicketEncashment']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="10"'));
            if(!empty($model_master_approve_setting))
            {
                $model->function_type=$model_master_approve_setting->id;
                $model->max_level=$model_master_approve_setting->max_level;
            }
            if ($model->validate()) {
                $model->save();               
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionApproveEncashmentRequest()
    {
        $id = Yii::app()->request->getparam("id");   
        $level = Yii::app()->request->getparam("level");
        $final_level = Yii::app()->request->getparam("final_level");
        $model = EmployeeTicketEncashment::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('encashment_request_form', array('model' => $model,'level'=>$level,'final_level'=>$final_level), false, true);                                        
    }
    public function actionApprovalDocument() {
        $id= Yii::app()->request->getParam('id');
        $model_encashment= EmployeeTicketEncashment::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.airticket_encashment_document', array('id'=>$id,'model_encashment'=>$model_encashment), true));
        $mPDF1->Output('Air Ticket Encashment Request Form.pdf', 'I');
    }
    public function actiondownloadapprovaldocument() {
        $id = Yii::app()->request->getParam('id');
        $document = EmployeeTicketEncashment::model()->findByPk($id);
        $file =$document->approval_document;  
        $path = Yii::getPathOfAlias('webroot') . "/uploads/ticketencashment/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }
    public function actionsaveApproveEncashmenttickets() {
        $model = new EmployeeTicketEncashment();
        if (isset($_POST['EmployeeTicketEncashment'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicketEncashment']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicketEncashment']['id'];
                $model->scenario = 'update';
                $model = EmployeeTicketEncashment::model()->findByPK($_POST['EmployeeTicketEncashment']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }
            $employee_id=$model->employee_id;
            if(isset($_POST['EmployeeTicketEncashment']['ticket_amt']))
            {
            $model->ticket_amt = $_POST['EmployeeTicketEncashment']['ticket_amt']; 
            }
            $model->last_approved_level = $_POST['EmployeeTicketEncashment']['last_approved_level'];
            $model->status = $_POST['EmployeeTicketEncashment']['status'];  
            $status=$_POST['EmployeeTicketEncashment']['status'];  
            if(isset($_POST['EmployeeTicketEncashment']['approval_document']) && $_POST['EmployeeTicketEncashment']['approval_document']!=''){
                $model->approval_document = $_POST['EmployeeTicketEncashment']['approval_document'];  
            }
            $modelemployee = User::model()->findByPK(Yii::app()->user->id);
            $approved_employee_id=0;
            if($modelemployee->employee_id>0){
                $approved_employee_id=$modelemployee->employee_id;
            }else if($modelemployee->hr_connected_employee_id>0){
                $approved_employee_id=$modelemployee->hr_connected_employee_id;
            }
            $level= $_POST['approval_level'];
            $final_level= $_POST['final_level']; 
            if($level==1 && $final_level=='N'){
                $model->approve_level1_date = date('Y-m-d');
                $model->approve_level1_comment = $_POST['approval_comment'];
                $model->approve_level1_id = $approved_employee_id;
            }else if($level==2 && $final_level=='N'){
                $model->approve_level2_date = date('Y-m-d');
                $model->approve_level2_comment = $_POST['approval_comment'];
                $model->approve_level2_id = $approved_employee_id;
            }else if($level==3 && $final_level=='N'){
                $model->approve_level3_date = date('Y-m-d');
                $model->approve_level3_comment = $_POST['approval_comment'];
                $model->approve_level3_id = $approved_employee_id;
            }else if($level==4 && $final_level=='N'){
                $model->approve_level4_date = date('Y-m-d');
                $model->approve_level4_comment = $_POST['approval_comment'];
                $model->approve_level4_id = $approved_employee_id;
            }else if($level==5 && $final_level=='N'){
                $model->approve_level5_date = date('Y-m-d');
                $model->approve_level5_comment = $_POST['approval_comment'];
                $model->approve_level5_id = $approved_employee_id;
            }
            if($final_level=='Y'){
                $model->approved_date = date('Y-m-d');
                $model->approval_comment = $_POST['approval_comment'];
                $model->approved_by = $approved_employee_id;
            }
            if ($model->validate()) {
                $model->save();               
                if($status==12){
                    $model_ticket_entitlement= EmployeeTicketEntitlement::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and ticket_year="'.date('Y').'"'));
                    if(!empty($model_ticket_entitlement)){
                        $ticket_balance=$model_ticket_entitlement->ticket_balance-100;
                        EmployeeTicketEntitlement::model()->updateByPK($model_ticket_entitlement->id, array('ticket_balance' => $ticket_balance,'updated_by'=> Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')));
                    }else{
                        $model_entitlement = new EmployeeTicketEntitlement();
                        $model_entitlement->created_by = Yii::app()->user->id;
                        $model_entitlement->created_date_time = date('Y-m-d h:i:s');
                        $model_entitlement->employee_id =$employee_id;
                        $model_entitlement->ticket_balance=-100;  
                        $model_entitlement->ticket_year=date('Y');  
                        $model_entitlement->branch_id=$model->employeedetail->branch_or_sponsor_id;  
                        $model_entitlement->save();             
                    }
                }
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="8"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController');
                         MailController::sendmail(8,$model->employee_id,$model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionViewEncashmentDetails()
    {
        $id = Yii::app()->request->getparam("id");      
        $model = EmployeeTicketEncashment::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_encashment_details', array('model' => $model), false, true);                                        
    }
    public function actionGetEmployeeEncashmentList(){
        $model=new EmployeeTicketEncashment();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'t.id',
            1 =>'leave_id',
            2 =>'date_apply',
            3 =>'approve_date',
            4 =>'payment_date',
            5 =>'ticket_amt',
            6 =>'year',
            7 =>'status',
            8 =>'',

        );
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 't.employee_id="' . $empid . '"';
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {                    
            $button_string="";
            $approve_document=0;
            if($row['approval_document']!=""){
                $approve_document=1;
                $button_string.= '<a href="?r=hr/employeetickets/downloadapprovaldocument&id=' . $row['id'] . '" title="Download Approval Document"><button class="btn btn-success btn-xs" title="Download Approval Document" ><i class="fa fa-download"></i></button></a>&nbsp;';           
            }
            $button_string.= '<button class="btn btn-info btn-xs" title="View Details" onclick="loadPopupModal(\'hr/employeetickets/viewencashmentdetails&id='.$row['id'].'\',\'Employee Ticket Encashment \',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';                 
            $date_apply="";
            $payment_date="";
            $approve_date="";
            if($row['date_apply']!='' && $row['date_apply']!='0000-00-00'){
                $date_apply=date("d/m/Y",strtotime($row->date_apply));
            } 
            if($row['approved_date']!='' && $row['approved_date']!='0000-00-00'){
                $approve_date=date("d/m/Y",strtotime($row->approved_date));
            } 
            if($row['payment_date']!='' && $row['payment_date']!='0000-00-00'){
                $payment_date=date("d/m/Y",strtotime($row->payment_date));
            }                         
            $rowData[]=array($m,$row->leavedetail->leave_name,$date_apply,$approve_date,$payment_date,$row['ticket_amt'],$row['year'],EmployeeTicketEncashment::getStatus($row->status),array("id"=>$row['id'],'approve_document'=>$approve_document));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionEmployeeCreateEncashment()
    {
        $model = new EmployeeTicketEncashment();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $user_id = Yii::app()->user->id; 				
        $modelemployee = User::model()->findByPK($user_id);
        $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$modelemployee->employee_id.'" and functionality_id="10"'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('create_ticket_encashment', array('model' => $model,'model_master_approve_setting'=>$model_master_approve_setting), false, true);                                        
    }
    public function actionSaveEncashmentDetails() {
        $model = new EmployeeTicketEncashment();
        if (isset($_POST['EmployeeTicketEncashment'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicketEncashment']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicketEncashment']['id'];
                $model->scenario = 'update';
                $model = EmployeeTicketEncashment::model()->findByPK($_POST['EmployeeTicketEncashment']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->date_apply = date('Y-m-d');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeTicketEncashment'];          
            $model->status = 1;
            $employee_id= $_POST['EmployeeTicketEncashment']['employee_id'];
            $model_master_approve_setting = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$employee_id.'" and functionality_id="10"'));
            if(!empty($model_master_approve_setting))
            {
                $model->max_level=$model_master_approve_setting->max_level;
            }
            if ($model->validate()) {
                $model->save();        
                //Mail
                $model_settings = HrGenerelSettings::model()->find();
                $model_mail_settings = MailSettings::model()->find(array('condition'=>'mail_function="7"'));
                if(!empty($model_settings) && !empty($model_mail_settings)){
                    if($model_settings->enable_mail=='Y' && $model_mail_settings->isActive=="Y"){
                         Yii::import('application.modules.hr.controllers.MailController');
                         MailController::sendmail(7,$model->employee_id,$model->id);
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
   
    public function actioncheckticketencashed() {

        $leavetype= $_POST['leavetype'];
        $startdate= $_POST['startdate'];
        $year= date('Y',strtotime($startdate));
        $id= $_POST['id'];
        $model_ticket = EmployeeTicket::model()->find(array('condition'=>'employee_id="'.$id.'" and leave_type="'.$leavetype.'" and year="'.$year.'" and status!="3"'));
        $model_ticket_encashed = EmployeeTicketEncashment::model()->find(array('condition'=>'employee_id="'.$id.'" and leave_id="'.$leavetype.'" and year="'.$year.'" and status!="3"'));
        if(empty($model_ticket) && empty($model_ticket_encashed)){
            $jsonData['status'] = 'success';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionTicketapprovalDocument() {
        $id= Yii::app()->request->getParam('id');
        $model_ticket= EmployeeTicket::model()->findbyPK($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.hrdocuments.airticket_approval_document', array('id'=>$id,'model_ticket'=>$model_ticket), true));
        $mPDF1->Output('Air Ticket Booking Request.pdf', 'I');
    }
    public function actionViewticketDetails()
    {
        $id = Yii::app()->request->getparam("id");      
        $model = EmployeeTicket::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_ticket_details', array('model' => $model), false, true);                                        
    }
    public function actiondownloadticketapprovaldocument() {
        $id = Yii::app()->request->getParam('id');
        $document = EmployeeTicket::model()->findByPk($id);
        $file =$document->approval_document;  
        $path = Yii::getPathOfAlias('webroot') . "/uploads/ticketdocument/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }
    public function actionApplyTicket()
    {
        $model = new EmployeeTicket();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('create_ticket', array('model' => $model), false, true);                                        
    }
    public function actionsaveticketdetails() {
        $model = new EmployeeTicket();
        if (isset($_POST['EmployeeTicket'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicket']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicket']['id'];
                $model->scenario = 'update';
                $model = EmployeeTicket::model()->findByPK($_POST['EmployeeTicket']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->date_apply = date('Y-m-d');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['EmployeeTicket'];          
            $model->ticket_amt= $_POST['EmployeeTicket']['ticket_amt'];  
            $model->status = 1;
            if ($model->validate()) {
                $model->save();               
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionAddticketDetail() {
        $model = new EmployeeTicketEntitlement();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('add_ticket_detail', array('model' => $model));
    }
    public function actionLoademployeeDetails() {
        $branch = Yii::app()->request->getparam("branch");
        $condition='branch_or_sponsor_id="' . $branch . '" AND travel_allowance>0 AND isActive="Y"';
        $model_employee = Employee::model()->findAll(array('condition' =>$condition,'order'=>'de_first_name asc'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_details_ticket', array('model_employee' => $model_employee, 'branch' => $branch));
    }
    public function actionSaveticketdetail() {
if ((isset($_POST['EmployeeTicketEntitlement']))) {
            date_default_timezone_set("Asia/Dubai");
            foreach ($_POST['EmployeeTicketEntitlement'] as $i => $items) {
                $current_balance = $items['ticket_balance'];
                if ($current_balance!='') {
                    $tkt_reduce=$_POST['HrEmployeeTicketLedger'][$i]['ticket_percentage_deducted'];
                    $tkt_count = $_POST['HrEmployeeTicketLedger'][$i]['ticket_percentage'];
                    if ($items['id'] > 0) {
                        $model = EmployeeTicketEntitlement::model()->findByPK($items['id']);
                        $model->updated_by = Yii::app()->user->id;
                        $model->updated_date_time = date('Y-m-d H:i:s');
                        $model->ticket_balance = $items['ticket_balance'];
                    } else {
                        $model = new EmployeeTicketEntitlement();
                        $model->created_by = Yii::app()->user->id;
                        $model->created_date_time = date('Y-m-d H:i:s');
                        $model->ticket_balance = $items['ticket_balance'];
                        $model->opening_balance = $items['opening_balance'];
                        $model->employee_id = $items['employee_id'];
                        $model->branch_id = $items['branch_id'];
                        $model->ticket_year = $items['ticket_year'];
                    }              
                    $model->save();
                    if ($tkt_count > 0) {
                        $model_ticket_ledger = new HrEmployeeTicketLedger();
                        $model_ticket_ledger->employee_id = $items['employee_id'];
                        $model_ticket_ledger->ticket_percentage = $_POST['HrEmployeeTicketLedger'][$i]['ticket_percentage'];
                        $model_ticket_ledger->remarks = $_POST['HrEmployeeTicketLedger'][$i]['remarks'];
                        $model_ticket_ledger->created_by = Yii::app()->user->id;
                        $model_ticket_ledger->created_date_time = date('Y-m-d H:i:s');
                        $model_ticket_ledger->save();
                    }
                    if ($tkt_reduce > 0) {
                        $model_ticket_ledger = new HrEmployeeTicketLedger();
                        $model_ticket_ledger->employee_id = $items['employee_id'];
                        $model_ticket_ledger->ticket_percentage_deducted = $_POST['HrEmployeeTicketLedger'][$i]['ticket_percentage_deducted'];
                        $model_ticket_ledger->remarks = $_POST['HrEmployeeTicketLedger'][$i]['remarks'];
                        $model_ticket_ledger->created_by = Yii::app()->user->id;
                        $model_ticket_ledger->created_date_time = date('Y-m-d H:i:s');
                        $model_ticket_ledger->save();
                    }
                }
                
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionInitializeticketdetail() {
        $model = new EmployeeTicketSetting();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('initialize_ticket_detail', array('model' => $model));
    }
    public function actionLoademployeeDetail() {
        $branch = Yii::app()->request->getparam("branch");
        $condition='t.branch_or_sponsor_id="' . $branch . '" AND t.isActive!="B"';      
        $model_employee = Employee::model()->with('employeeticketdetails')->findAll(array('condition' =>$condition));//with('employeeticketdetails')->
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        $model = new EmployeeTicketSetting();
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('employee_details_ticketsetting', array('model' => $model, 'arr_employee' => $arr_employee, 'branch' => $branch));
    }
    public function actionSaveticketsetting() {
       if ((isset($_POST['EmployeeTicketSetting']))) {
           $ticket_date = $_POST['ticket_date'];
           date_default_timezone_set("Asia/Dubai");
           foreach ($_POST['EmployeeTicketSetting'] as $i => $items) {
               $ticket_pending = $items['ticket_pending'];
               if ($ticket_pending>0) {
                   if ($items['id'] > 0) {
                       $model_ticket = EmployeeTicketSetting::model()->findByPK($items['id']);
                       $model_ticket->scenario = 'update';
                       $model_ticket->updated_by = Yii::app()->user->id;
                       $model_ticket->updated_date_time = date('Y-m-d h:i:s');
                   } else {
                       $model_ticket = new EmployeeTicketSetting();
                       $model_ticket->scenario = 'add';
                       $model_ticket->created_by = Yii::app()->user->id;
                       $model_ticket->created_date_time = date('Y-m-d h:i:s');
                   }
                   $model_ticket->employee_id = $items['employee_id'];    
                   $model_ticket->ticket_available = $items['ticket_available'];    
                   $model_ticket->ticket_given = $items['ticket_given'];    
                   $model_ticket->ticket_pending = $items['ticket_pending'];
                   if ($ticket_date!= '0000-00-00' && $ticket_date!= '') {
                        $ticket_date= str_replace('/', '-', $ticket_date);
                        $model_ticket->first_intialized_date= date("Y-m-d", strtotime($ticket_date));
                    }
                   $model_ticket->save();
               }

           }        
           $jsonData['status'] = 'success';
           echo CJSON::encode($jsonData);
       }
   }
   public function actionTicketIndex() {
        $this->layout = 'main';
        $model_module_ticket = HrModules::model()->findByPK(8);
        if ($model_module_ticket->grant_access == 1 && $model_module_ticket->isActive == 'Y') {
            $this->render('ticket_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetFamilyTicket(){
        $model=new EmployeeTicket();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $status=$_POST['status'];
        $columns = array(
            0 =>'t.id',
            1 =>'date_apply',
            2 =>'approve_date',
            3 =>'year',
            4 =>'status',
            5 =>'',

        );
        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $condition = 't.employee_id="' . $empid . '" AND ticket_type="F"';
        if($status>0){
            $condition.= ' and t.status="'.$status.'"';
        }
		
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {                    
            $button_string="";
            $button_string.= '<button class="btn btn-primary btn-xs" title="View Details" onclick="loadPopupModal(\'hr/employeetickets/viewfamilyticketdetails&id='.$row['id'].'\',\'Family Ticket\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';                 
            //if($row['status']!==1){
                $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete" onclick="deleteticket(' . $row['id'] . ')"><i class="fa fa-trash "></i></a>' ;
            //}
            $date_apply="";
            $approve_date="";
            if($row['date_apply']!='' && $row['date_apply']!='0000-00-00'){
                $date_apply=date("d/m/Y",strtotime($row->date_apply));
            } 
            if($row['date_approved']!='' && $row['date_approved']!='0000-00-00'){
                $approve_date=date("d/m/Y",strtotime($row->date_approved));
            }                   
            $rowData[]=array($m,$date_apply,$approve_date,$row['year'],EmployeeTicket::getStatus($row->status),array('id'=>$row['id']));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionfamilytkt()
    {
        $model = new EmployeeTicket();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('family_ticket', array('model' => $model), false, true);                                        
    }
    public function actionsavefamilyticket() {
        $model = new EmployeeTicket();
        if (isset($_POST['EmployeeTicket'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicket']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicket']['id'];
                $model->scenario = 'update';
                $model = EmployeeTicket::model()->findByPK($_POST['EmployeeTicket']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->date_apply = date('Y-m-d');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->employee_id = $_POST['EmployeeTicket']['employee_id']; 
            $model->family_member = $_POST['EmployeeTicket']['family_member']; 
            $model->travel_destination = $_POST['EmployeeTicket']['travel_destination'];
            if ($_POST['EmployeeTicket']['travel_date'] != '0000-00-00' && $_POST['EmployeeTicket']['travel_date'] != '') {
                $model->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeTicket']['travel_date'])));
            }
            $model->return_destination = $_POST['EmployeeTicket']['return_destination'];
            if ($_POST['EmployeeTicket']['return_date'] != '0000-00-00' && $_POST['EmployeeTicket']['return_date'] != '') {
                $model->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeTicket']['return_date'])));
            }
            $model->leave_id =0;
            $model->leave_type =0;
            $model->year =date('Y');
            $model->ticket_amt=0.00;  
            $model->status = 1;
            $model->ticket_type = 'F';
            if ($model->validate()) {
                $model->save();               
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionflytktindex() {
        $model_module_ticket= HrModules::model()->findByPK(8);
        if ($model_module_ticket->grant_access == 1 && $model_module_ticket->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_emp_family_ticket_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('fly_tkt_index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetFamilyticketList(){
        $model=new EmployeeTicket();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
       // $status=$_POST['status'];
        $employee_id=$_POST['employee_id'];
        $year=$_POST['year'];
        $columns = array(
            0 =>'t.id',
            1 =>'employeedetail.employee_code',
            2 =>'employeedetail.first_name',
            3 =>'date_apply',
            4 =>'payment_date',
            5 =>'ticket_amt',
            6 =>'year',
            7 =>'status',
            8 =>'',

        );
        $arr_status=$_POST['status'];
        $status =1;
        if(is_countable($arr_status) && count($arr_status)>1){
            $status=implode(',',$arr_status);
        }else{
            $status=$arr_status[0];
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and employeedetail.reporting_manager="'.$model_user->department_head_id.'"';
        }
        $condition = "ticket_type='F'";
        if($status!=''){
            $condition.= " AND status IN(".$status.")";
        }
        if($employee_id>0){
             $condition.= ' and t.employee_id ="'.$employee_id.'"';
        }
        if($year>0){
             $condition.= ' and t.year ="'.$year.'"';
        }
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";                    
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->with('employeedetail')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {                    
            $button_string="";
            $approve_reject =$view_ticket=1;
            if($row['status']==1){
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_family_ticket_approve'])  || Yii::app()->user->authorised_user == 1) {
                    $button_string.= '<button class="btn btn-primary btn-xs" title="Approve/Reject Request" onclick="loadPopupModal(\'hr/employeetickets/approvefamilytkt&id='.$row['id'].'\',\'Family Ticket \',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';                  
                    $approve_reject =1;
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_family_ticket_view'])  || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="View Details" onclick="loadPopupModal(\'hr/employeetickets/viewfamilyticketdetails&id='.$row['id'].'\',\'Family Ticket\',\'lg\')"><i class="fa fa-eye"></i></button>&nbsp;';                 
                $view_ticket =1;
            }
            $date_apply="";
            $date_approved="";
            if($row['date_apply']!='' && $row['date_apply']!='0000-00-00'){
                $date_apply=date("d/m/Y",strtotime($row->date_apply));
            }  
            if($row['date_approved']!='' && $row['date_approved']!='0000-00-00'){
                $date_approved=date("d/m/Y",strtotime($row->date_approved));
            }  
            $rowData[]=array($m,$this->ciphertext($row->employeedetail->employee_code, "d"), $this->ciphertext($row->employeedetail->first_name, "d") . ' ' . $this->ciphertext($row->employeedetail->last_name, "d"),$date_apply,$date_approved,$row['ticket_amt'],$row['year'],EmployeeTicket::getStatus($row->status),array('id'=>$row->id,'approve_reject'=>$approve_reject,'view_ticket'=>$view_ticket));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionapprovefamilytkt()
    {
        $id = Yii::app()->request->getparam("id");      
        $model = EmployeeTicket::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('flytkt_request_form', array('model' => $model), false, true);                                        
    }
    public function actionsaveApproveflytickets() {           
        if (isset($_POST['EmployeeTicket'])) {           
            $model=new EmployeeTicket();        
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicket']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicket']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }       
            $model->status = $_POST['EmployeeTicket']['status'];  
            $model->ticket_amt = $_POST['EmployeeTicket']['ticket_amt']; 
            $model->notes = $_POST['EmployeeTicket']['notes']; 
            $model->date_approved= date('Y-m-d');
            if ($model->validate()){                     
                $model->save(); 
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                echo $error;
            }            
        }
    }
    public function actionviewfamilyticketdetails()
    {
        $id = Yii::app()->request->getparam("id");      
        $model = EmployeeTicket::model()->findbyPk($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_fly_ticket_details', array('model' => $model), false, true);                                        
    }
    public function actiondeleteticket(){
        $id = $_POST['id'];
        if($id>0){
             EmployeeTicket::model()->deleteByPk($id);
             $status['status'] = 'success';
        }else{
            $status['status'] = 'error';
         }
         echo CJSON::encode($status);
     }
     public function actionApplyflyTicket()
    {
        $model = new EmployeeTicket();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('create_fly_ticket', array('model' => $model), false, true);                                        
    }
    public function actioncheckfamilyticket() {
        $year= $_POST['year'];
        $id= $_POST['id'];
        $model_employee = Employee::model()->findbyPK($id);
        $model_ticket = EmployeeTicket::model()->find(array('condition'=>'employee_id="'.$id.'"and year="'.$year.'" and status!="3" AND ticket_type="F"'));
        if(empty($model_ticket) && $model_employee->branch_sponsor->ticket_provided=='Y' && $model_employee->family_ticket=='Y'){
            $jsonData['status'] = 'success';
        }else if($model_employee->branch_sponsor->ticket_provided=='N'){
            $jsonData['status'] = 'notavailable';
        }else if($model_employee->family_ticket=='N'){
            $jsonData['status'] = 'notprovided';
        }else{
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionsaveflyticketdetails() {
        $model = new EmployeeTicket();
        if (isset($_POST['EmployeeTicket'])) {
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['EmployeeTicket']['id'] > 0) {
                $model->id = (int) $_POST['EmployeeTicket']['id'];
                $model->scenario = 'update';
                $model = EmployeeTicket::model()->findByPK($_POST['EmployeeTicket']['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->date_apply = date('Y-m-d');
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->employee_id = $_POST['EmployeeTicket']['employee_id']; 
            $model->year = $_POST['EmployeeTicket']['year']; 
            $model->ticket_amt = $_POST['EmployeeTicket']['ticket_amt']; 
            $model->family_member = $_POST['EmployeeTicket']['family_member']; 
            $model->travel_destination = $_POST['EmployeeTicket']['travel_destination'];
            if ($_POST['EmployeeTicket']['travel_date'] != '0000-00-00' && $_POST['EmployeeTicket']['travel_date'] != '') {
                $model->travel_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeTicket']['travel_date'])));
            }
            $model->return_destination = $_POST['EmployeeTicket']['return_destination'];
            if ($_POST['EmployeeTicket']['return_date'] != '0000-00-00' && $_POST['EmployeeTicket']['return_date'] != '') {
                $model->return_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeTicket']['return_date'])));
            }
            $model->leave_id =0;
            $model->leave_type =0;
            $model->status = 1;
            $model->ticket_type = 'F';
            if ($model->validate()) {
                $model->save();               
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionencashmentapproval() {
        $this->layout = 'main';
        $model_module_ticket_encashment = HrModules::model()->findByPK(9);
        if ($model_module_ticket_encashment->grant_access == 1 && $model_module_ticket_encashment->isActive == 'Y') {
            $this->render('encashment_approval');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetEncashmentList(){
        $model=new EmployeeTicketEncashment();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'t.id',
            1 =>'leave_id',
            2 =>'date_apply',
            3 =>'year',
            4 =>'status',
            5 =>'',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $user_id = Yii::app()->user->id; 
	$modelemployee = User::model()->findByPK($user_id);
	$employee_id = $modelemployee->employee_id;
        $pending_encashment=EmployeeTicketEncashment::getintermediateapproval($employee_id,1);
        $condition = 'employeedetail.isActive="Y" AND last_approved_level<t.max_level AND t.id IN('.$pending_encashment.')';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";       
        }
        $count = $model->with('employeedetail','approvelevel')->count(array('condition'=>$condition));
        $model=$model->with('employeedetail','approvelevel')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string = $date_apply="";
            $last_approved_level=$row->last_approved_level;
            $next_approval_level=$last_approved_level+1;
            $show_approve_button=0;
            $level_no=0;
            $final_level='N';
            if($next_approval_level<=$row->max_level){
                if($next_approval_level==1 && (($row->approvelevel->level_1_type=='L' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='S' && $row->approvelevel->level_1_authority==$employee_id) || ($row->approvelevel->level_1_type=='N' && $row->approvelevel->level_1_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=1;
                }else if($next_approval_level==2 && (($row->approvelevel->level_2_type=='L' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='S' && $row->approvelevel->level_2_authority==$employee_id) || ($row->approvelevel->level_2_type=='N' && $row->approvelevel->level_2_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=2;
                }else if($next_approval_level==3 && (($row->approvelevel->level_3_type=='L' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='S' && $row->approvelevel->level_3_authority==$employee_id) || ($row->approvelevel->level_3_type=='N' && $row->approvelevel->level_3_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=3;
                }else if($next_approval_level==4 && (($row->approvelevel->level_4_type=='L' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='S' && $row->approvelevel->level_4_authority==$employee_id) || ($row->approvelevel->level_4_type=='N' && $row->approvelevel->level_4_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=4;
                }else if($next_approval_level==5 && (($row->approvelevel->level_5_type=='L' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='S' && $row->approvelevel->level_5_authority==$employee_id) || ($row->approvelevel->level_5_type=='N' && $row->approvelevel->level_5_authority==$employee_id))){
                    $show_approve_button=1;
                    $level_no=5;
                }
            }
            if($next_approval_level==$row->max_level){
                $final_level='Y';
            }
            $approve_button =0;
            if($show_approve_button==1){ //For Approval
                $approve_button =1;
                $button_string.= '<button class="btn btn-success btn-xs" title="Approve/Reject Ticket Encashment" onclick="loadPopupModal(\'hr/employeetickets/approveencashmentrequest&final_level='.$final_level.'&level='.$level_no.'&id=' . $row['id'] . '\',\'Approve/Reject Ticket Encashment\',\'lg\')"><i class="fa fa-thumbs-up"></i></button>&nbsp;';           
            }
            if($row['date_apply']!='' && $row['date_apply']!='0000-00-00'){
                $date_apply=date("d/m/Y",strtotime($row->date_apply));
            } 
            $rowData[]=array($m,$row['employeedetail']['employeefullname'],$date_apply,$row['year'],EmployeeTicketEncashment::getStatus($row->status),array('final_level'=>$final_level,'level_no'=>$level_no,'id'=>$row['id'],'approve_button'=>$approve_button));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    } 
    public function actionloadmasterbranch() {
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('master_branch', array());
    }
    public function actiongetbranchleave() {
       $model = new EmployeeTicket();
       $id = Yii::app()->request->getparam('id');
       $model_emp = Employee::model()->findbyPk($id);
       $branch=$model_emp->branch_or_sponsor_id;
       $dropdownlist=CHtml::activedropDownList($model, 'leave_type',MasLeave::getticketleavetype($branch), array('data-label'=>'Leave Type','empty'=>'Select'));
       $jsonData['leave'] = $dropdownlist;
       echo CJSON::encode($jsonData);
    }
}