<?php

class EmployeereportsController extends Controller {

    public function accessRules() {

        return array(
            array('allow',
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow',
                'actions' => array('PrintEmployeeList', 'PrintEmployeeBlockList', 'print_employee_salary', 'PrintEmployeeNewhire', 
                                    'PrintEmployeeSettlement', 'print_employee_expiredocumentlist', 'print_employee_documentlist',
                                    'print_employee_assetlist', 'Print_employee_gratuitylist', 'PrintEmployeeDepartmentList', 
                                    'PrintEmployeeDesignationList', 'print_employee_ticket', 'print_employee_loan','PrintEmployeeBranchList',
                                    'PrintEmployeeBranchPDF','Print_Employee_AppraisalList','Print_Employee_AppraisalIndividualList','print_employee_eoslist','Print_Employee_RecruitmentList',
                                    'PrintConsolidatedReports','PrintEmployeeQualificationList','PrintEmployeeDocumentDetails','PrintEmployeeDocumentverticalDetails','PrintEmployeeHierarchyList','PrintEmployeeWeekendReportList','PrintEmployeeBiometricReportList','PrintEmployeeContractTypeReportList','PrintEmployeeOverTimeReportList','PrintEmployeeTeamList',
                                    'PrintEmployeeBankdetailsList','PrintEmployeeResignationList'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny',
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl',
        );
    }

    public function actionPrintEmployeeList() {
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $department_id = $_POST['department_name'];
        $designation_id = $_POST['designation_name'];
        $reportmanager_id = $_POST['report_manager'];
        $status = $_POST['status'];
        $category_id = $_POST['category_id'];
        $team_id = $_POST['team_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_list', 
            array(
                'Branch' => $Branch, 
                'employee_id' => $employee_id, 
                'department_id' => $department_id, 
                'designation_id' => $designation_id, 
                'reportmanager_id' => $reportmanager_id,
                'category_id' => $category_id,
                'status' => $status,
                'team_id' =>$team_id
                ), false, true);
    }
     public function actionPrintEmployeeBlockList() {
        $branch = $_POST['branch_id'];
        $employee_id = $_POST['employee_id'];
        $from_date = $_POST['date_from'];
        $to_date = $_POST['date_to'];
        $department = $_POST['department'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_blocklist', array(
            'branch' => $branch, 'employee_id' => $employee_id, 'date_from' => $from_date, 'date_to' => $to_date,'department'=>$department), false, true);
    }

    public function actionPrintEmployeeSettlement() {


        $Branch = $_POST['Branch'];

        $employee_id = $_POST['employee_name'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_leave_settlement', array('model' => $model,
            'Branch' => $Branch, 'employee_id' => $employee_id), false, true);
    }
    public function actionPrintEmployeeNewhire() {
        $param = $_REQUEST;
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('printNewhirelist', $param, false, true);
    }

    public function actionPrintEmployeeDepartmentList() {


        $Branch = $_POST['Branch'];

        $employee_id = $_POST['employee_name'];

        $department_name = $_POST['department_name'];

        $reportman_id = $_POST['reportman_id'];

        //echo "ok".$reportman_id;
        //die();

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $model='';
        $this->renderPartial('print_employee_departmentlist', array('model' => $model,
            'Branch' => $Branch, 'employee_id' => $employee_id, 'department_name' => $department_name, 'reportman_id' => $reportman_id), false, true);
    }
	
	

    public function actionPrintEmployeeDesignationList() {


        $Branch = $_POST['Branch'];

        $employee_id = $_POST['employee_name'];

        $designation_name = $_POST['designation_name'];
        $report_id = $_POST['report_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $model='';
        $this->renderPartial('print_employee_designationlist', array('model' => $model,
            'Branch' => $Branch, 'employee_id' => $employee_id, 'designation_name' => $designation_name, 'report_id' => $report_id), false, true);
    }
    public function actionprint_employee_documentlist() {

        $model='';
        $document_id = $_POST['document_id'];

        $employee_id = $_POST['employee_name'];


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_documentlist', array('model' => $model,
            'document_id' => $document_id, 'employee_id' => $employee_id), false, true);
    }

    public function actionprint_employee_expiredocumentlist() {

        $model='';
        $document_id = $_POST['document_id'];

        $employee_id = $_POST['employee_name'];


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_expiredocumentlist', array('model' => $model,
            'document_id' => $document_id, 'employee_id' => $employee_id), false, true);
    }

    public function actionprint_employee_assetlist() {


        $branch_id = $_POST['branch_id'];

        $employee_id = $_POST['employee_name'];

        $asset_id = $_POST['asset_status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $model='';
        $this->renderPartial('print_employee_assetlist', array('model' => $model,
            'branch_id' => $branch_id, 'asset_id' => $asset_id, 'employee_id' => $employee_id), false, true);
    }

    public function actionprint_employee_salary() {


        $branch_id = $_POST['branch_id'];

        $employee_id = $_POST['employee_name'];
        $model='';


        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_salary', array('model' => $model,
            'branch_id' => $branch_id, 'employee_id' => $employee_id), false, true);
    }

    public function actionprint_employee_loan() {
        $branch_id = $_POST['branch_id'];
        $status = $_POST['status'];
        $employee_id = $_POST['employee_name'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_loan', array(
            'status' =>$status, 'branch_id' => $branch_id, 'employee_id' => $employee_id), false, true);
    }
    public function actionprint_employee_ticket() {

         $employee_id=''; 
        if (isset($_POST['employee_id']))  
        {
         $employee_id = $_POST['employee_id'];
         }
       
        $year = $_POST['ticket_year'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_ticket', array('year' => $year, 'employee_id' => $employee_id), false, true);
    }

    public function actionPrint_employee_gratuitylist() {

        $employee_id = $_POST['employee_id'];

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_gratuitylist', array('model' => $model, 'employee_id' => $employee_id), false, true);
    }
    public function actionPrintEmployeeBranchList() {
        $branch= $_POST['branch'];
        $employee_id= $_POST['employee_id'];
        $date_from= $_POST['date_from'];
        $date_to= $_POST['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employeebranch_list', 
            array('branch' => $branch,
                'employee_id' => $employee_id,
                'date_from' => $date_from,
                'date_to' => $date_to
                ), false, true);
    }
    public function actionPrintEmployeeBranchPDF() {
        $branch = Yii::app()->request->getParam('branch');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $date_from = Yii::app()->request->getParam('date_from');
        $date_to = Yii::app()->request->getParam('date_to');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.employeereports.pdf.employee_branch_pdf', array('date_to'=>$date_to,'date_from'=>$date_from,'branch' => $branch, 'employee_id' => $employee_id, 'title' => $title), true));
        $mPDF1->Output('employeebranchdetails.pdf', 'D');
    }
    public function actionPrint_Employee_AppraisalList() {
        $branch_id = $_POST['branch_id'];
        $analysis_period = $_POST['analysis_period'];
        $employee_id = $_POST['employee_name'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_appraisallist', array('branch_id' => $branch_id,'analysis_period' => $analysis_period, 'employee_id' => $employee_id), false, true);
    }
    public function actionPrint_Employee_AppraisalIndividualList() {
        $branch_id = $_POST['branch_id'];
        $analysis_period = $_POST['analysis_period'];
        $employee_id = $_POST['employee_name'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_individualappraisallist', array('branch_id' => $branch_id,'analysis_period' => $analysis_period, 'employee_id' => $employee_id), false, true);
    }
    public function actionPrint_Employee_EOSlist() {
        $from_date = $_POST['from_date'];
        $to_date   = $_POST['to_date'];
        $employee_id = $_POST['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_eoslist', array('from_date' => $from_date,'to_date'=>$to_date, 'employee_id' => $employee_id), false, true);
    }
    public function actionPrint_Employee_RecruitmentList() {
        $from_date = $_POST['from_date'];
        $to_date   = $_POST['to_date'];
        $employee_id = $_POST['employee_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_recruitment_list', array('from_date' => $from_date,'to_date'=>$to_date, 'employee_id' => $employee_id), false, true);
    }
    public function actionPrintConsolidatedReports() {
        $branch_id = $_POST['branch_id'];
        $employee_id = $_POST['employee_id'];
        $department_id = $_POST['department_id'];
        $status = $_POST['status'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_consolidatedreport', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_id' => $department_id, 'status' => $status), false, true);
    }

    public function actionPrintEmployeeDocumentDetails() {
        $branch_id = $_POST['branch_id'];
        $employee_id = $_POST['employee_id'];
        $department_id = $_POST['department_id'];
        $status = $_POST['status'];
        $doc_document_id = $_POST['doc_document_id'];
        $document_status = $_POST['document_status'];
        $document_attachment = $_POST['document_attachment'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_document_details', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_id' => $department_id, 'status' => $status, 'doc_document_id' => $doc_document_id, 'document_status' => $document_status, 'document_attachment' => $document_attachment), false, true);
    }

    public function actionPrintEmployeeDocumentverticalDetails() {
        $branch_id = $_POST['branch_id'];
        $employee_id = $_POST['employee_id'];
        $department_id = $_POST['department_id'];
        $status = $_POST['status'];
        $doc_document_id = $_POST['doc_document_id'];
        $document_status = $_POST['document_status'];
        $document_attachment = $_POST['document_attachment'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_document_vertical_details', array('branch_id' => $branch_id, 'employee_id' => $employee_id, 'department_id' => $department_id, 'status' => $status, 'doc_document_id' => $doc_document_id, 'document_status' => $document_status, 'document_attachment' => $document_attachment), false, true);
    }


    
	
    public function actionPrintEmployeeQualificationList() {
   	$employee_id = $_POST['employee_id'];
        $branch_id = $_POST['branch_id'];
   	Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_qualification_list',array('employee_id' => $employee_id,  'branch_id' => $branch_id, ), false, true);
               
    }
     public function actionPrintEmployeeHierarchyList() {
         //code added by rahul on 20-7-22//
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $department_name = $_POST['department'];
        $functionality_id = $_POST['functionality_id'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_hierarchylist', array('Branch' => $Branch, 'employee_id' => $employee_id, 'functionality_id' => $functionality_id,'department_name'=>$department_name), false, true);
    }
     public function actionPrintEmployeeWeekendReportList() {
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $report_type = $_POST['report_type'];
      
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_weekend_list', 
            array(
                'Branch' => $Branch, 
                'employee_id' => $employee_id, 
                'report_type' => $report_type), false, true);
    }
    public function actionPrintEmployeeBiometricReportList() {
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $report_type = $_POST['report_type'];
      
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_biometric_list', 
            array(
                'Branch' => $Branch, 
                'employee_id' => $employee_id, 
                'report_type' => $report_type), false, true);
    }
     public function actionPrintEmployeeContractTypeReportList() {
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $report_type = $_POST['report_type'];
      
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_contract_type_list', 
            array(
                'Branch' => $Branch, 
                'employee_id' => $employee_id, 
                'report_type' => $report_type), false, true);
    }
     public function actionPrintEmployeeOverTimeReportList() {
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $report_type = $_POST['report_type'];
      
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_over_time_list', 
            array(
                'Branch' => $Branch, 
                'employee_id' => $employee_id, 
                'report_type' => $report_type), false, true);
    }
    public function actionPrintEmployeeTeamList() {


        $Branch = $_POST['Branch'];

        $employee_id = $_POST['employee_name'];

        $team_name = $_POST['team_name'];

        $reportman_id = $_POST['reportman_id'];

        //echo "ok".$reportman_id;
        //die();

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_teamlist', array('Branch' => $Branch, 'employee_id' => $employee_id, 'team_name' => $team_name, 'reportman_id' => $reportman_id), false, true);
            
    }
    public function actionPrintEmployeeBankdetailsList() {


        $Branch = $_POST['Branch'];

        $employee_id = $_POST['employee_name'];

        $bank_name = $_POST['bank_name'];

        if (isset($_POST['reportman_id'])) 
        {
        $reportman_id = $_POST['reportman_id'];
        }
        //echo "ok".$reportman_id;
        //die();

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->renderPartial('print_employee_bankdetailslist', array('Branch' => $Branch, 'employee_id' => $employee_id, 'bank_name' => $bank_name), false, true);
            
    }
     public function actionPrintEmployeeResignationList() {
        $Branch = $_POST['Branch'];
        $employee_id = $_POST['employee_name'];
        $department = $_POST['department'];
        $date_from = $_POST['from_date'];
        $date_to = $_POST['date_to'];
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('print_employee_resignationlist', array(
            'Branch' => $Branch, 'employee_id' => $employee_id, 'date_from' => $date_from, 'date_to' => $date_to,'department'=>$department), false, true);
    }
}
