<?php

class EmployeegratuitylistController extends Controller
{    
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('index','GetGratuityDetails','PrintGratuityListReportPDF','gratuityexceldownload'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function actionIndex() {
        $model_module_eos = HrModules::model()->findByPK(17);
        if ($model_module_eos->grant_access == 1 && $model_module_eos->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_empeos_gratuity_list_menu']) || Yii::app()->user->authorised_user == 1) {
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetGratuityDetails(){
		
        $model_employee=new Employee();		
        $branch_id    = $_POST['branch_id'];
        $gratuity_date    = $_POST['gratuity_date'];
        $gratuity_rule    = $_POST['gratuity_rule'];
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'id',
            1 =>'employee_code',
            2 =>'first_name',
            3 =>'date_join',
            4 =>'middle_name',
            5 =>'last_name',
            6 =>'employee_type',
            7 =>'gratuity',
            8 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        if($gratuity_date!=''){
            $current_date= date("Y-m-d", strtotime(str_replace('/', '-', $gratuity_date)));
        }else{
            $current_date=date('Y-m-d');
        }
        $condition = ' t.isActive="Y"';	
        if($branch_id>0){
            $condition.= ' and branch_or_sponsor_id = "'.$branch_id.'"';	
        }
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if(Yii::app()->user->authorised_user != 1 && $model_user->department_head_id>0) {
            $condition.= ' and t.reporting_manager="'.$model_user->department_head_id.'"';
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employee_code LIKE '%".$searchString_en."%' OR first_name LIKE '%".$searchString_en."%' OR middle_name LIKE '%".$searchString_en."%' OR last_name LIKE '%".$searchString_en."%')";
        }				
        $count = $model_employee->count(array('condition'=>$condition));
        $model_employee=$model_employee->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value->first_name,"d").' '.$this->ciphertext($value->last_name,"d").'-'.$this->ciphertext($value->employee_code,"d")]=$value->id;
        }
        ksort($arr_employee); 
        foreach ($arr_employee as $k => $id){
            $row = Employee::model()->findbyPk($id);
            $current_date=date('Y-m-d');
            $service_period="-";
            $years="";
            $date_join="-";
            $service_days=0;
            $service_period_1="";
            $service_period_2 =0;
            if($row['date_join']!='0000-00-00' && $row['date_join']!=''){
                $date_join = date("d/m/Y", strtotime($row['date_join']));
                $d1 = strtotime($row['date_join']);
                $d2 = strtotime($current_date);
                $datediff = $d2 - $d1;
                $service_days = $datediff / (60 * 60 * 24)+1;
                $years= round($service_days/365,1);	 
                $date1 = new DateTime($row['date_join']);
                $date2 = new DateTime($current_date); 
                $dd = date_diff($date1,$date2);
                $service_period= "$dd->y Yrs $dd->m Month $dd->d Day";
                $service_period_1="$dd->y Yrs";
                $service_period_2=$dd->y;
            }	
            Yii::import('application.modules.hr.controllers.EosdetailsController'); 
            $gratuityamount=EosdetailsController::geteos($row->id,$gratuity_date,$gratuity_rule);
            if($gratuityamount==0 && $service_period_2==0){
                $gratuityamount=$this->geteoslessthanone($row->id,$gratuity_date,$gratuity_rule);
            }
            $basic=0.00;
            $total_amount=0.00;
            $model_total_salary = EmployeeSalary::model()->find(array('select'=>'sum(amount) as amount','condition' => 'employee_id="'.$row['id'].'" AND (("'.$current_date.'" BETWEEN valid_from AND valid_to) OR (valid_from <= "'.$current_date.'" AND valid_to="0000-00-00"))'));
            if($model_total_salary->amount>0){
                $total_amount=$model_total_salary->amount;
            }
            $model_basic_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="'.$row['id'].'" AND salary_type="1" AND (("'.$current_date.'" BETWEEN valid_from AND valid_to) OR (valid_from <= "'.$current_date.'" AND valid_to="0000-00-00"))'));
            $basic=0.00;
            if(!empty($model_basic_salary))
            {
                $basic=$model_basic_salary->amount;
            }
            $contract_type='';
            if($row->employee_type>0){
                $contract_type=$row->contract->contract_type;
            }
            $rowData[]=array($m,$row->employeecode,$row->employeefullname,$date_join,$service_period_1,$contract_type,Yii::app()->numberFormatter->formatCurrency($basic,""),Yii::app()->numberFormatter->formatCurrency($total_amount,""),Yii::app()->numberFormatter->formatCurrency($gratuityamount,""));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
      
    public function actionPrintGratuityListReportPDF() {
        $branch_id    = $_GET['branch_id'];
        $gratuity_date    = $_GET['gratuity_date'];
        $gratuity_rule    = $_GET['gratuity_rule'];
        $model=new Employee();
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.gratuity_list_individual', array('branch_id'=>$branch_id,'gratuity_date'=>$gratuity_date,'gratuity_rule'=>$gratuity_rule,'model' => $model),true));
        $mPDF1->Output('gratuity', 'I');
    }
    public function actiongratuityexceldownload()
    {
        $branch_id= (int)Yii::app()->request->getParam('branch_id');
        $gratuity_date= Yii::app()->request->getParam('gratuity_date');
        $gratuity_rule    = Yii::app()->request->getParam('gratuity_rule');
        
        $condition ='t.isActive="Y"';
        if($branch_id>0){
            $condition.=' and branch_or_sponsor_id = "'.$branch_id.'"';
        }  
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$value->employeecode.'-'.$value->employeefullname]=$value->id;
        }
        ksort($arr_employee); 
        Yii::import('ext.PHPExcel.PHPExcel');
        $objPHPExcel = new PHPExcel();
        // Add some data
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->mergeCells('A1:H1');
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'GRATUITY AS OF '.$gratuity_date);
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('A1:I1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(45);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(15);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A2', 'NO')
            ->setCellValue('B2', 'CODE')
            ->setCellValue('C2', 'EMPLOYEE NAME')
            ->setCellValue('D2', 'DATE OF JOINING')
            ->setCellValue('E2', 'SERVICE(YRS)')
            ->setCellValue('F2', 'CONTRACT')
            ->setCellValue('G2', 'BASIC SALARY')
            ->setCellValue('H2', 'TOTAL SALARY')
            ->setCellValue('I2', 'GRATUITY');
        $styleArray = array(
        'borders' => array(
            'allborders' => array(
              'style' => PHPExcel_Style_Border::BORDER_THIN
            )
          )
        );
        $objPHPExcel->getActiveSheet()->getStyle('A2:I2')->applyFromArray($styleArray);
        $objPHPExcel->getDefaultStyle()->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()
        ->getStyle('A2:I2')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D1D2D4')
                )
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle('A2:I2')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle("A2:I2")->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('G')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        $objPHPExcel->getActiveSheet()->getStyle('H')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        $objPHPExcel->getActiveSheet()->getStyle('I')
            ->getNumberFormat()
            ->setFormatCode(
                '0.00'
        );
        $rowCount = 3;
        $start=$rowCount; $end=0;
        $j=1;
        $total_gratuity=0.00;
        if($gratuity_date!=''){
            $current_date= date("Y-m-d", strtotime(str_replace('/', '-', $gratuity_date)));
        }else{
            $current_date=date('Y-m-d');
        }
        foreach ($arr_employee as $emp_id) {
            $model = Employee::model()->findbyPk($emp_id);
            $service_period="-";
            $years="-";
            $date_join="-";		
            $service_days=0;
            $service_period_1="";
            $service_period_2 =0;
            if($model->date_join!='0000-00-00' && $model->date_join!=''){
                $date_join = date("d/m/Y", strtotime($model->date_join));
                $datediff = strtotime($current_date) - strtotime($model->date_join);
                $service_days = $datediff / (60 * 60 * 24)+1;
                $years= round($service_days/365,1);	 
                $date1 = new DateTime($model->date_join);
                $date2 = new DateTime($current_date); 
                $dd = date_diff($date1,$date2);
                $service_period= "$dd->y Yrs $dd->m Month $dd->d Day";
                $service_period_1="$dd->y Yrs";
                $service_period_2=$dd->y;
            }	
                Yii::import('application.modules.hr.controllers.EosdetailsController'); 
                $gratuityamount=EosdetailsController::geteos($emp_id,$gratuity_date,$gratuity_rule);
                if($gratuityamount==0 && $service_period_2==0){
                    $gratuityamount=$this->geteoslessthanone($model->id,$gratuity_date,$gratuity_rule);
                }
                $total_gratuity+=$gratuityamount;
                $total_amount=0.00;
                $model_total_salary = EmployeeSalary::model()->find(array('select'=>'sum(amount) as amount','condition' => 'employee_id="'.$model->id.'" AND (("'.$current_date.'" BETWEEN valid_from AND valid_to) OR (valid_from <= "'.$current_date.'" AND valid_to="0000-00-00"))'));
                if($model_total_salary->amount>0){
                    $total_amount=$model_total_salary->amount;
                }
                $basic = EmployeeSalary::model()->find(array('condition' => 'employee_id="'.$model->id.'" AND salary_type="1" AND (("'.$current_date.'" BETWEEN valid_from AND valid_to) OR (valid_from <= "'.$current_date.'" AND valid_to="0000-00-00"))'))->amount;
                
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount,$j);
            $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount, $model->employeecode);
            $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount, $model->employeefullname);
            $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount, $date_join);
            $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount, $service_period);
            $contract_type ='';
            if(!empty($model->employee_type > 0))
            {
                $contract_type = $model->contract->contract_type; 
            }
            $objPHPExcel->getActiveSheet()->SetCellValue('F'.$rowCount, $contract_type);
            $objPHPExcel->getActiveSheet()->SetCellValue('G'.$rowCount, Yii::app()->numberFormatter->formatCurrency($basic,""));
            $objPHPExcel->getActiveSheet()->SetCellValue('H'.$rowCount, Yii::app()->numberFormatter->formatCurrency($total_amount,""));
            $objPHPExcel->getActiveSheet()->SetCellValue('I'.$rowCount, Yii::app()->numberFormatter->formatCurrency($gratuityamount,""));
            $objPHPExcel->getActiveSheet()->getRowDimension($rowCount)->setRowHeight(20);
            $end=$rowCount;
            $rowCount++;
            $j++;
        }
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':B'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$start.':F'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $objPHPExcel->getActiveSheet()->getStyle('G'.$start.':I'.$end.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$start.':I'.$end.'')->getFont()->setSize(10);
        $footer_line=$end+1;
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$footer_line.':H'.$footer_line);
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$footer_line, 'TOTAL');
        $objPHPExcel->getActiveSheet()->SetCellValue('I'.$footer_line,$total_gratuity);
        $objPHPExcel->getActiveSheet()->getStyle('A'.$footer_line.':I'.$footer_line.'')->getFont()->setSize(12)->setBold( true );
        $objPHPExcel->getActiveSheet()->getStyle('A'.$footer_line.':I'.$footer_line.'')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $objPHPExcel->getActiveSheet()->getRowDimension($footer_line)->setRowHeight(22);
        $objPHPExcel->getActiveSheet()
        ->getStyle('A'.$footer_line.':I'.$footer_line.'')
        ->applyFromArray(
            array(
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'color' => array('rgb' => 'D1D2D4')
                )
            )
        );
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('GRATUITY LIST');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        header('Content-Type: application/vnd.ms-excel; charset=UTF-8');
        header('Content-Disposition: attachment;filename="Gratuity List.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }
    public static function geteoslessthanone($id,$gratuity_date,$rule_type) {
        if($gratuity_date!=''){
            $date_leave= date("Y-m-d", strtotime(str_replace('/', '-', $gratuity_date)));
        }else{
            $date_leave=date('Y-m-d');
}
        $modelemployee = Employee::model()->findbyPK($id);
        //Service Period
        $d1 = strtotime($modelemployee->date_join);
        $d2 = strtotime($date_leave);
        $datediff = $d2 - $d1;
        $service_days = $datediff / (60 * 60 * 24); 
        $eos_service_days=$service_days/365;
        $years= round($service_days/365,1);
        $date1 = new DateTime($modelemployee->date_join);
        $date2 = new DateTime($date_leave); 
        $dd = date_diff($date1,$date2);
        $eos_year=$dd->y;
        $eos_month=$dd->m/12;
        $eos_days=$dd->d/365;
        $model_gratuity = MasGratuity::model()->find(array('condition' =>'rule_type="'.$rule_type.'" and gratuity_period_from="1" AND gratuity_period_to="5"'));
        $days = $model_gratuity->gratuity_provision_days;
        $salary_types = explode(',', $model_gratuity->salary_type);			
        $salaryamount = 0.00;
        $gratuity = 0.00;
        for ($i = 0; $i < count($salary_types); $i++) {
            $model_salary = EmployeeSalary::model()->find(array('condition' => 'employee_id="'.$id.'" and salary_type="'.$salary_types[$i].'" AND (("'.$date_leave.'" BETWEEN valid_from AND valid_to) OR (valid_from <= "'.$date_leave.'" AND valid_to="0000-00-00"))'));
            $salaryamount += $model_salary->amount;      
        }			
        $salary_per_day = ($salaryamount/30); 
        //$gratuityamount=$days*$salary_per_day*$eos_service_days;
        $gross_amount=($days*$salary_per_day*$eos_year)+($days*$salary_per_day*$eos_month)+($days*$salary_per_day*$eos_days);
        $gratuityamount =ceil($gross_amount);
        return $gratuityamount;
    }
}