<?php

class EmployeeController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'GetEmployeeList', 'removedocumentRow', 'Create', 'Getdroutingcode', 'SaveEmployee', 'EmployeeDocument', 'Getdocumenttype', 'UpdateEmployee', 'Uploademployee',
                    'SearchEmployee', 'Upload', 'DownloadDocument', 'ViewProfile', 'PrintEmployeeSnapshotPDF', 'SearchStaff', 'getmaxsalarydate', 'UploadEmployeecsv', 'SaveUploadCsv', 'DownloadSampleCsv', 'DownloadErrorCsv',
                    'getemployeegratuityamount', 'Block', 'UnBlock', 'readEmployeeCSV', 'StaffBoard', 'deleteuploadedfile', 'removedependant', 'deletedependantfile', 'UploadSalary', 'Downloadsalaryformat', 'SaveSalaryUploadCsv',
                    'changeprofilepic', 'SaveProfilepic', 'codegenerate', 'View', 'removequalification', 'downloadqualification', 'EmployeebyBranch', 'checkassetalreadyallocated', 'removeasset', 'DownloadAssetDocument', 'Printletter', 'UndertakingPrintletter', 'deleteuploadedassetfile', 'uploademployeedocuments', 'DownloadDocumentSampleCsv', 'DownloadDocumentErrorCsv', 'SaveEmpDocumentCsv', 'UploadEmployeeLeave', 'DownloadLeaveSampleCsv', 'DownloadLeaveErrorCsv', 'SaveEmpLeaveCsv',
                    'leaveinitialize','salaryinitialize','levelinitialize','listdetaillevel','leveldetailsdata'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    //Code added by Dikson on 7/3/2018
    public function actionIndex() {
        $model_module_employee = HrModules::model()->findByPK(1);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_emp_details_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y')) {
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }

    public function actionStaffBoard() {
        $this->layout = 'main';
        $this->render('/site/employee');
    }

    public function actionGetEmployeeList() {
        $model = new Employee();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $id = $_POST['id'];
        $department = $_POST['dept'];
        $designation = $_POST['desg'];
        $branch_id = $_POST['branch_id'];
        $status = $_POST['status'];
        $team = $_POST['team'];
        $report_id = $_POST['report_id'];
        $columns = array(
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'employee_code',
            3 => 'first_name',
            4 => 'department',
            5 => 'designation',
            6 => 'date_join',
            7 => 'reporting_manager',
            8 => 't.id',
            9 => 'isActive'
        );
        // $filterColumn = $columns[$_POST['order'][0]['column']];
        // $filterOrder  = $_POST['order'][0]['dir'];
        // $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        $condition = '1=1';
        $model_user = User::model()->findByPk(Yii::app()->user->id);
        if (Yii::app()->user->authorised_user != 1 && $model_user->department_head_id > 0) {
            $condition .= ' and t.reporting_manager="' . $model_user->department_head_id . '"';
        }
        if ($status == "Y") {
            $condition .= ' AND t.isActive!="B"';
        } else if ($status == "N") {
            $condition .= ' AND t.isActive="B"';
        }
        if ($branch_id > 0) {
            $condition .= ' and t.branch_or_sponsor_id="' . $branch_id . '"';
        } else {
            if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
                $condition .= ' and t.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
            }
        }
        if ($id > 0) {
            $condition .= ' and t.id="' . $id . '"';
        }
        if ($department > 0) {
            $condition .= ' and t.department="' . $department . '"';
        }
        if ($designation > 0) {
            $condition .= ' and t.designation="' . $designation . '"';
        }
        if ($team > 0) {
            $condition .= ' and t.team_id="' . $team . '"';
        }
        if ($report_id > 0) {
            $condition .= ' and t.reporting_manager="' . $report_id . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and (id LIKE '%" . $searchString . "%' OR employee_biometric_code='" . $searchString . "' OR employee_code LIKE '%" . $searchString_en . "%' OR first_name LIKE '%" . $searchString_en . "%' OR middle_name LIKE '%" . $searchString_en . "%' OR last_name LIKE '%" . $searchString_en . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'id asc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        $model_general_setting = HrGenerelSettings::model()->find();
        foreach ($model as $row) {
//            $button_string = "";
            $edit_employee=$view_employee=$block_employee=$reset_sent_password=$snapshot=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_employee=1;
//                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit Employee Details" onclick="loadPopupModal(\'hr/employee/create&id=' . $row['id'] . '\',\'' . $row['employeefullname'] . ' \',\'xl\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_view']) || Yii::app()->user->authorised_user == 1) {
                $view_employee=1;
//                $button_string .= ' <button class="btn btn-success btn-xs" title="View Employee Details" onclick="loadPopupModal(\'hr/employee/view&id=' . $row['id'] . '\',\'' . $row['employeefullname'] . ' \',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_details_block_unblock']) || Yii::app()->user->authorised_user == 1) {
                $block_employee=1;
                /*if ($row['isActive'] != 'B') {
                    $button_string .= ' <a href ="javascript:void(0);" title="Block Employee Details" class="btn btn-danger btn-xs" title="Block" onclick="BlockEmployee(' . $row['id'] . ')"><i class="fa fa-ban "></i></a>';
                } else {
                    $button_string .= ' <a href ="javascript:void(0);" title="Unblock Employee Details" class="btn btn-success btn-xs" title="UnBlock" onclick="UnBlockEmployee(' . $row['id'] . ')"><i class="fa fa-retweet"></i></a>';
                }*/
            }
            if ($model_general_setting->enable_mail == 'Y') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_send_password']) || Yii::app()->user->authorised_user == 1) {
                    $reset_sent_password=1;
//                    $button_string .= ' <a href ="javascript:void(0);" class="btn btn-warning btn-xs" title="Reset & Send Employee Password" onclick="resetpassword(' . $row['id'] . ')"><i class="fa fa-lock"></i></a>';
                }
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_snapshot_tab']) || Yii::app()->user->authorised_user == 1) {
                $snapshot=1;
//                $button_string .= ' <a href="?r=hr/employee/printemployeesnapshotpdf&id=' . $this->ciphertext($row['id'], "e") . '" title="Print Snapshot" target="_blank"><button class="btn btn-default btn-xs" title="Print Snapshot" ><i class="fa fa-print"></i></button></a>';
            }
            $joining_date = "";
            if ($row['date_join'] != '' && $row['date_join'] != '0000-00-00') {
                $joining_date = date("d/m/Y", strtotime($row->date_join));
            }
            if ($row->reporting_manager > 0) {
                $employeefullname = $row->reportingmanager->employeefullname;
            } else {
                $employeefullname = '';
            }
            $en_id = $this->ciphertext($row['id'], "e");
            $rowData[] = array(++$m, $row['branch_sponsor']['branch_or_sponsor_name'], $this->ciphertext($row['employee_code'], "d"), $this->ciphertext($row['first_name'], "d") . ' ' . $this->ciphertext($row['last_name'], "d"), $row->departmentdetail->department_name, $row->designationdetail->designation_name, $joining_date, $employeefullname,
                array('id'=>$row['id'],'isActive'=>$row['isActive'],'en_id'=>$en_id,'snapshot' => $snapshot,'edit_employee' => $edit_employee,'view_employee' => $view_employee,'block_employee' => $block_employee,'reset_sent_password' => $reset_sent_password));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionUploademployee() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_employee', array('model' => $model), false, true);
    }

    public function actionCreate() {
        $model = new Employee();
        $model_asset = array(new EmployeeAsset());
        $model_leave = array(new EmployeeLeave());
        $emp_wps = new EmployeewpsCompany();
        $model_inoutdocument = array(new EmployeeInoutDocument());
        $model_documents = array(new EmployeeDocuments());
        $model_salary = array(new EmployeeSalary());
        $model_employee_salary = array(new EmployeeSalary());
        $model_notes = array(new EmployeeNotes());
        $model_dependants = array(new EmployeeDependants());
        $model_qualification = array(new HrEmployeeQualification());
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_qualification = HrEmployeeQualification::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_qualification)) {
                $model_qualification = array(new HrEmployeeQualification());
            }
            $model_dependants = EmployeeDependants::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_dependants)) {
                $model_dependants = array(new EmployeeDependants());
            }
            $model_asset = EmployeeAsset::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $emp_wps = EmployeewpsCompany::model()->find(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_asset)) {
                $model_asset = array(new EmployeeAsset());
            }
            $model_setting = HrGenerelSettings::model()->find();
            $year = date("Y");
            $current_month = date("m");
            if ($current_month < $model_setting->leave_carry_forward_month) {
                $year = $year - 1;
            }
            $model_leave = EmployeeLeave::model()->findAll(array('condition' => 'employee_id="' . $id . '" and leave_year="' . $year . '"'));
//            if(empty($model_leave)){
//                $model_leave=array(new EmployeeLeave()); 
//            }   
            $model_inoutdocument = array(new EmployeeInoutDocument());
            $model_inoutdocument_details = EmployeeInoutDocument::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $model_documents = EmployeeDocuments::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_documents)) {
                $model_documents = array(new EmployeeDocuments());
            }
            $model_salary = EmployeeSalary::model()->findAll(array('condition' => 'employee_id="' . $id . '" and isActive="Y"'));
            if (empty($model_salary)) {
                $model_salary = array(new EmployeeSalary());
            }
            $model_salary_details_employee = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'employee_id="' . $id . '" and t.isActive="N"', 'order' => 'salary.salary_name asc'));
            if (empty($model_salary_details_employee)) {
                $model_salary_details_employee = array(new EmployeeSalary());
            }
            $model_employee_salary = array(new EmployeeSalary());
            $model_loan = EmployeeLoanDetail::model()->findAll(array('condition' => 'employee_id="' . $id . '" and loan_status!=0'));
            $model_issued_certificates = EmployeeCertificate::model()->findAll(array('condition' => 'employee_id="' . $id . '" and (status="12" OR status="14")'));
            $model_warning_notice = EmployeeAttendanceWarning::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $model_notes = EmployeeNotes::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $model_contact = EmployeeContacts::model()->find(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_contact->id)) {
                $model_contact = new EmployeeContacts();
            }
            $model_training_details = HrTrainingDetails::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $this->renderPartial('create_employee', array('model' => $model, 'model_contact' => $model_contact, 'model_qualification' => $model_qualification, 'model_training_details' => $model_training_details, 'model_dependants' => $model_dependants, 'model_notes' => $model_notes, 'model_warning_notice' => $model_warning_notice, 'model_inoutdocument_details' => $model_inoutdocument_details, 'model_employee_salary' => $model_employee_salary, 'emp_wps' => $emp_wps, 'model_asset' => $model_asset, 'model_leave' => $model_leave, 'model_inoutdocument' => $model_inoutdocument, 'model_issued_certificates' => $model_issued_certificates, 'model_documents' => $model_documents, 'model_salary' => $model_salary, 'model_loan' => $model_loan, 'model_salary_details_employee' => $model_salary_details_employee), false, true);
        } else {
            $model_mas_company = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
            $total_employee_count = Employee::model()->count();
            if ($total_employee_count < $model_mas_company->total_employees_allowed) {
                $this->renderPartial('create', array('model' => $model), false, true);
            } else {
                throw new CHttpException(404, 'Page not found.');
            }
        }
    }

    public function actionSaveEmployee() {
        if (isset($_POST['Employee'])) {
            //Employee Details
            $valid =true;
            date_default_timezone_set("Asia/Dubai");
            $model = new Employee();
            $model->attributes = $_POST['Employee'];
            $model->scenario = 'add';
            $model->employee_code = $this->ciphertext(trim($_POST['Employee']['employee_code']), "e");
            $model->hr_code = trim($_POST['Employee']['employee_code']);
            $first_name = preg_replace('/[~!@#\$%\^&\*\(\)_\+\`\-=\{\}\[\]\|\\\:;"\'<>,\.\?\/]/', '', trim($_POST['Employee']['first_name']));
            $last_name = preg_replace('/[~!@#\$%\^&\*\(\)_\+\`\-=\{\}\[\]\|\\\:;"\'<>,\.\?\/]/', '', trim($_POST['Employee']['last_name']));
            $model->de_first_name = $first_name . ' ' . $last_name;
            $model->first_name = $this->ciphertext($first_name, "e");
            $model->last_name = $this->ciphertext($last_name, "e");
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d H:i:s');
            $model->user_name = $_POST['Employee']['employee_code'];
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $password = crypt($_POST['Employee']['employee_code'], $salt);
            $model->password = $password;
            if ($_POST['Employee']['date_join'] != '0000-00-00' && $_POST['Employee']['date_join'] != '') {
                $model->date_join = str_replace('/', '-', $_POST['Employee']['date_join']);
                $model->date_join = date("Y-m-d", strtotime($model->date_join));
                $model->probation_date = date('Y-m-d', strtotime('+180 days', strtotime($model->date_join)));
            }
            if ($_POST['Employee']['date_of_birth'] != '0000-00-00' && $_POST['Employee']['date_of_birth'] != '') {
                $model->date_of_birth = str_replace('/', '-', $_POST['Employee']['date_of_birth']);
                $model->date_of_birth = date("Y-m-d", strtotime($model->date_of_birth));
            }
            // visa_profession added by nisha on 20-07-2023
            $model->visa_profession = $_POST['Employee']['visa_profession'];
            //
            //Weekend
            $branch = $_POST['Employee']['branch_or_sponsor_id'];
            $model_weekend = WorkingHours::model()->findAll(array('condition' => 'company_branch_or_sponsor_id="' . $branch . '" and weekend="0"'));
            if (!empty($model_weekend) && count($model_weekend) >= 1 && $model_weekend[0]['week_id'] > 0) {
                $model->weekend_off1 = $model_weekend[0]['week_id'];
                $model->weekend_off1_type = 'F';
            } else {
                $model->weekend_off1_type = '';
            }
            if (!empty($model_weekend) && count($model_weekend) >= 2 && $model_weekend[1]['week_id'] > 0) {
                $model->weekend_off2 = $model_weekend[1]['week_id'];
                $model->weekend_off2_type = 'F';
            } else {
                $model->weekend_off2_type = '';
            }
            if (!empty($model_weekend) && count($model_weekend) >= 3 && $model_weekend[2]['week_id'] > 0) {
                $model->weekend_off3 = $model_weekend[2]['week_id'];
                $model->weekend_off3_type = 'F';
            } else {
                $model->weekend_off3_type = '';
            }
            $valid =$model->validate();
            if ((isset($_POST['EmployeeSalary'])) && ($_POST['EmployeeSalary'][0]['salary_type'] != '')) {
                foreach ($_POST['EmployeeSalary'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_salary[$i] = EmployeeSalary::model()->findByPK($items['id']);
                        $model_salary[$i]->updated_by = Yii::app()->user->id;
                        $model_salary[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_salary[$i] = new EmployeeSalary();
                        $model_salary[$i]->created_by = Yii::app()->user->id;
                        $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_salary[$i]->employee_id = $model->id;
                    $model_salary[$i]->salary_type = $items['salary_type'];
                    $model_salary[$i]->amount = $items['amount'];
                    $model_salary[$i]->consider_for_leave_payment = $items['consider_for_leave_payment'];
                    if ($items['valid_from'] != '' && $items['valid_from'] != '0000-00-00') {
                        $items['valid_from'] = str_replace('/', '-', $items['valid_from']);
                        $model_salary[$i]->valid_from = date("Y-m-d", strtotime($items['valid_from']));
                    }
                    if (isset($items['valid_to']) && $items['valid_to'] != '' && $items['valid_to'] != '0000-00-00') {
                        $items['valid_to'] = str_replace('/', '-', $items['valid_to']);
                        $model_salary[$i]->valid_to = date("Y-m-d", strtotime($items['valid_to']));
                    }
                    $valid = $model_salary[$i]->validate() && $valid;
                }
            }
            //Level
            if ((isset($_POST['HrEmployeeApproveLevel'])) && ($_POST['HrEmployeeApproveLevel'][0]['functionality_id'] != '')) {
                $i = 0;
                foreach ($_POST['HrEmployeeApproveLevel'] as $j => $items) {
                    if ($items['max_level'] > 0) {
                        if ($items['id'] > 0) {
                            $model_level[$i] = HrEmployeeApproveLevel::model()->findByPK($items['id']);
                            $model_level[$i]->updated_by = Yii::app()->user->id;
                            $model_level[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $model_level[$i] = new HrEmployeeApproveLevel();
                            $model_level[$i]->created_by = Yii::app()->user->id;
                            $model_level[$i]->created_date_time = date('Y-m-d H:i:s');
                            
                        }
                        $model_level[$i]->attributes = $_POST['HrEmployeeApproveLevel'][$j];
                        if ($_POST['flag_reporting_manager'] == "Y" || $_POST['flag_supervisor'] == "Y") {
                            for ($level = 1; $level <= $items['max_level']; $level++) {
                                $typeKey = "level_{$level}_type";
                                $authorityKey = "level_{$level}_authority";
                                if (!empty($items[$typeKey])) {
                                    if ($items[$typeKey] == 'L' && $_POST['flag_reporting_manager'] == "Y") {
                                        $model_level[$i]->$authorityKey = $_POST['Employee']['reporting_manager'];
                                    } else if ($items[$typeKey] == 'S' && $_POST['flag_supervisor'] == "Y") {
                                        $model_level[$i]->$authorityKey = $_POST['Employee']['attendance_manager'];
                                    }
                                }
                            }
                        }
                        $model_level[$i]->employee_id =0;
                        $valid = $model_level[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
        //End Level
            if ($valid) {
                $model->save();
                //Branch
                $model_branch = new EmployeeBranch();
                $model_branch->employee_id = $model->id;
                $model_branch->branch_id = $model->branch_or_sponsor_id;
                $model_branch->from_date = $model->date_join;
                $model_branch->save(false);
                //End Branch
                //Department
                $model_department = new EmployeeDepartment();
                $model_department->employee_id = $model->id;
                $model_department->department_id = $model->department;
                $model_department->from_date = $model->date_join;
                $model_department->save(false);
                //End Department
                //Designation
                $model_designation = new EmployeeDesignation();
                $model_designation->employee_id = $model->id;
                $model_designation->designation_id = $model->designation;
                $model_designation->from_date = $model->date_join;
                $model_designation->save(false);
                //End Designation
                //Ticket Initilization
                $model_branch_details= MasCompanyBranchSponsor::model()->findbyPK($model->branch_or_sponsor_id);
                if(!empty($model_branch_details) && $model_branch_details->ticket_provided=='Y'){
                    $model_entitlement = new EmployeeTicketEntitlement();
                    $model_entitlement->created_by = Yii::app()->user->id;
                    $model_entitlement->created_date_time = date('Y-m-d h:i:s');
                    $model_entitlement->employee_id =$model->id;
                    $model_entitlement->ticket_balance=0;  
                    $model_entitlement->ticket_year=date('Y');  
                    $model_entitlement->branch_id=$model->branch_or_sponsor_id;
                    $model_entitlement->save(); 
                }
                //leave initiaize
                foreach ($_POST['EmployeeLeave'] as $i => $items) {
                    if (isset($_POST['arraycid']) && is_array($_POST['arraycid'])) {
                        if (in_array($items['leave_type'], $_POST['arraycid'])) {
                            $leave_count = $_POST['EmployeeLeaveLedger'][$i]['leave_count'];
                            $leave_opening = $items['leave_opening'];
                            $current_balance = $items['leave_current_balance'];
                            if ($current_balance != '') {
                                $leave_reduce = 0.00;
                                $model_leave = new EmployeeLeave();
                                $model_leave->scenario = 'add';
                                $model_leave->created_by = Yii::app()->user->id;
                                $model_leave->created_date_time = date('Y-m-d H:i:s');
                                $model_leave->leave_current_balance = $items['leave_current_balance'];
                                $model_leave->employee_id = $model->id;
                                $model_leave->leave_type = $items['leave_type'];
                                $model_leave->leave_opening = $items['leave_opening'];
                                $model_leave->leave_year = date('Y');
                               $model_leave->save(false);
                                if ($leave_count > 0) {
                                    $model_leave_ledger = new EmployeeLeaveLedger();
                                    $model_leave_ledger->employee_id = $model->id;
                                    $model_leave_ledger->leave_type = $items['leave_type'];
                                    $model_leave_ledger->leave_count = $_POST['EmployeeLeaveLedger'][$i]['leave_count'];
                                    $model_leave_ledger->remarks = $_POST['EmployeeLeaveLedger'][$i]['remarks'];
                                    $model_leave_ledger->created_by = Yii::app()->user->id;
                                    $model_leave_ledger->created_date_time = date('Y-m-d H:i:s');
                                    $model_leave_ledger->save();
                                }
                            }
                            //Master Leave
                            $leave_employee_id =array();
                            $model_master_leave = MasLeave::model()->findByPk($items['leave_type']);
                            if (!empty($model_master_leave) && $model_master_leave->employee_id != '') {
                                $leave_employee_id = explode(',', $model_master_leave->employee_id);
                                $leave_employee_id[]=$model->id;
                               
                            }
                            $new_array_eid = array();
                            $j = 0;
                            if (!empty($leave_employee_id) && count($leave_employee_id) > 0) {
                                for ($n = 0; $n < count($leave_employee_id); $n++) {
                                    if (!(in_array($leave_employee_id[$n], $_POST['arraycid']))) {
                                        $new_array_eid[$j] = $leave_employee_id[$n];
                                        $j++;
                                    }
                                }
                            }
                            $employee_id = implode(',', $new_array_eid);
                            $model_master_leave->employee_id = $employee_id;
                            $model_master_leave->save();
                         
                        }
                    }
                }
                //end leave
                
                //salary
                if (!empty($model_salary)) {
                    foreach ($model_salary as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }
                //end salary

                if (!empty($model_level)) {
                    foreach ($model_level as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        if($eachModel->functionality_id==6 && ($eachModel->level_1_authority==0 || $eachModel->level_1_authority=='')){
                            $eachModel->level_1_authority = $model->id;
                        }
                        $eachModel->save();
                    }
                }
                $model_module_ess = HrModules::model()->findByPK(33);
                if(!empty($model_module_ess) && $model_module_ess->grant_access==1 && $model_module_ess->isActive='Y'){
                    $model_user = new User();
                    $model_user->password = $model->password;
                    $model_user->username = $model->user_name;
                    $model_user->first_name = $_POST['Employee']['first_name'];
                    $model_user->last_name = $_POST['Employee']['last_name'];
                    $model_user->company_id = Yii::app()->user->master_user_company_id;
                    $model_user->subledger_added = "N";
                    $model_user->user_group_id = 37;
                    $model_user->employee_id = $model->id;
                    $model_user->designation = $model->designationdetail->designation_name;
                    $model_user->level = 2;
                    $model_user->is_lead_owner = $model->is_lead_owner;
                    $model_user->created_by = Yii::app()->user->id;
                    $model_user->created_date_time = date('Y-m-d H:i:s');
                    $model_user->save(false);
                }
                $jsonData['id'] = $model->id;
                $jsonData['employeefullname'] = $model->employeefullname;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            
        } else {
                $error1 = $error2 = $error3=array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_salary) && $model_salary[0]->salary_type > 0) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_salary, '', false), true);
                }
                if (!empty($model_level) && $model_level[0]->max_level > 0) {
                    $error3 = json_decode(CActiveForm::validateTabular($model_level, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2,$error3));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionEmployeeDocument() {
        $model_documents = array(new EmployeeDocuments());
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($id > 0) {
            $model_documents = EmployeeDocuments::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_documents)) {
                $model_documents = array(new EmployeeDocuments());
            }
        }
        $this->renderPartial('employee_document', array('model_documents' => $model_documents), false, true);
    }

    public function actionGetdocumenttype() {
        $id = Yii::app()->request->getparam('id');
        $model = MasDocument::model()->findByPk($id);
        $data['document'] = $model->document_type;
        $data['expiry'] = $model->renewal_remainder;
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionUpdateEmployee() {
        if (isset($_POST['Employee'])) {
            $model = new Employee();
            date_default_timezone_set("Asia/Dubai");
            if ((int) @$_POST['Employee']['id'] > 0) {
                $model = Employee::model()->findByPK($_POST['Employee']['id']);
                $model->id = (int) $_POST['Employee']['id'];
                $model->scenario = 'update';
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            } else {
                $model->scenario = 'add';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['Employee'];
            $model->employee_code = $this->ciphertext(trim($_POST['Employee']['employee_code']), "e");
            $model->hr_code = trim($_POST['Employee']['employee_code']);
            $model->de_first_name = $_POST['Employee']['first_name'] . ' ' . $_POST['Employee']['last_name'];
            $model->first_name = $this->ciphertext($_POST['Employee']['first_name'], "e");
            $model->last_name = $this->ciphertext($_POST['Employee']['last_name'], "e");
            $model->middle_name = $this->ciphertext($_POST['Employee']['middle_name'], "e");
            $model->employee_type = $_POST['Employee']['employee_type'];
            $model->employee_grade = $_POST['Employee']['employee_grade'];
            $model->update_contact_ess = $_POST['Employee']['update_contact_ess'];
            $model->update_nominee_ess = $_POST['Employee']['update_nominee_ess'];
            $model->golden_visa_availed = $_POST['Employee']['golden_visa_availed'];
            $model->employee_cost = $_POST['Employee']['employee_cost'];
            if($model->have_pension ==0){
                $model->employee_pension_scheme =0;
            }
            if ($_POST['Employee']['date_of_birth'] != '0000-00-00' && $_POST['Employee']['date_of_birth'] != '') {
                $model->date_of_birth = str_replace('/', '-', $_POST['Employee']['date_of_birth']);
                $model->date_of_birth = date("Y-m-d", strtotime($model->date_of_birth));
            }
            if ($_POST['Employee']['date_join'] != '0000-00-00' && $_POST['Employee']['date_join'] != '') {
                $model->date_join = str_replace('/', '-', $_POST['Employee']['date_join']);
                $model->date_join = date("Y-m-d", strtotime($model->date_join));
            }
            if ($_POST['Employee']['probation_date'] != '0000-00-00' && $_POST['Employee']['probation_date'] != '') {
                $model->probation_date = str_replace('/', '-', $_POST['Employee']['probation_date']);
                $model->probation_date = date("Y-m-d", strtotime($model->probation_date));
            }
            if ($_POST['Employee']['anniversary_date'] != '0000-00-00' && $_POST['Employee']['anniversary_date'] != '') {
                $model->anniversary_date = str_replace('/', '-', $_POST['Employee']['anniversary_date']);
                $model->anniversary_date = date("Y-m-d", strtotime($model->anniversary_date));
            }
            if ($_POST['Employee']['date_leaving'] != '0000-00-00' && $_POST['Employee']['date_leaving'] != '') {
                $model->date_leaving = str_replace('/', '-', $_POST['Employee']['date_leaving']);
                $model->date_leaving = date("Y-m-d", strtotime($model->date_leaving));
            }
            //visa_profession added by nisha on 20-07-2023
            $model->visa_profession = $_POST['Employee']['visa_profession'];
            //end
            $model->employee_duties = $_POST['Employee']['employee_duties'];
            $model->present_address = $_POST['Employee']['present_address'];
            $model->permanent_address = $_POST['Employee']['permanent_address'];
            $model->gratuity = $_POST['Employee']['gratuity'];
            $model->threshold_salary = $_POST['Employee']['threshold_salary'];
            $model->employee_iban_no = str_replace(" ", "", trim($_POST['Employee']['employee_iban_no']));
            $model->personal_file_no = str_replace(" ", "", trim($_POST['Employee']['personal_file_no']));
            $valid = $model->validate();
            $model_contact = new EmployeeContacts();
            if (isset($_POST['EmployeeContacts'])) {
                if ((int) @$_POST['EmployeeContacts']['id'] > 0) {
                    $model_contact = EmployeeContacts::model()->findByPK($_POST['EmployeeContacts']['id']);
                    $model_contact->id = (int) $_POST['EmployeeContacts']['id'];
                    $model_contact->updated_by = Yii::app()->user->id;
                    $model_contact->updated_date_time = date('Y-m-d H:i:s');
                } else {
                    $model_contact->created_by = Yii::app()->user->id;
                    $model_contact->created_date_time = date('Y-m-d H:i:s');
                }
                $model_contact->attributes = $_POST['EmployeeContacts'];
                $model_contact->address = $_POST['EmployeeContacts']['address'];
            }
            //Document 
            if ((isset($_POST['EmployeeDocuments'])) && ($_POST['EmployeeDocuments'][0]['document_id'] != '')) {
                foreach ($_POST['EmployeeDocuments'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_document[$i] = EmployeeDocuments::model()->findByPK($items['id']);
                        $model_document[$i]->scenario = 'add';
                    } else {
                        $model_document[$i] = new EmployeeDocuments();
                        $model_document[$i]->scenario = 'update';
                    }
                    $model_document[$i]->document_id = $items['document_id'];
                    $model_document[$i]->document_number = $items['document_number'];
                    $model_document[$i]->document_file = $items['document_file'];
                    if ($items['validate_till_date'] != '' && $items['validate_till_date'] != '0000-00-00') {
                        $items['validate_till_date'] = str_replace('/', '-', $items['validate_till_date']);
                        $valid_date = date("Y-m-d", strtotime($items['validate_till_date']));
                        $model_document[$i]->validate_till_date = $valid_date;
                        $current_date = date("Y-m-d");
                        if (strtotime($valid_date) > strtotime($current_date)) {
                            $model_document[$i]->status = 0;
                            $model_document[$i]->expiry_notify = 0;
                        }
                    }
                    if ($items['renew_on'] != '' && $items['renew_on'] != '0000-00-00') {
                        $items['renew_on'] = str_replace('/', '-', $items['renew_on']);
                        $model_document[$i]->renew_on = date("Y-m-d", strtotime($items['renew_on']));
                    }
                    $valid = $model_document[$i]->validate() && $valid;
                }
            }

            //Asset
            if ((isset($_POST['EmployeeAsset'])) && ($_POST['EmployeeAsset'][0]['asset_id'] > 0)) {
                foreach ($_POST['EmployeeAsset'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_asset[$i] = EmployeeAsset::model()->findByPK($items['id']);
                        $model_asset[$i]->updated_by = Yii::app()->user->id;
                        $model_asset[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_asset[$i] = new EmployeeAsset();
                        $model_asset[$i]->created_by = Yii::app()->user->id;
                        $model_asset[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_asset[$i]->asset_id = $items['asset_id'];
                    if ($items['asset_id'] > 0) {
                        $model_asset[$i]->master_asset_id = HrMasAssetDetails::model()->findByPK($items['asset_id'])->asset_id;
                    }
                    $model_asset[$i]->asset_status = $items['asset_status'];
                    $model_asset[$i]->asset_description = $items['asset_description'];
                    $model_asset[$i]->asset_undertaking_letter = $items['asset_undertaking_letter'];
                    if ($items['asset_date_issue'] != '' && $items['asset_date_issue'] != '0000-00-00') {
                        $items['asset_date_issue'] = str_replace('/', '-', $items['asset_date_issue']);
                        $model_asset[$i]->asset_date_issue = date("Y-m-d", strtotime($items['asset_date_issue']));
                    }
                    if ($items['asset_date_return'] != '' && $items['asset_date_return'] != '0000-00-00') {
                        $items['asset_date_return'] = str_replace('/', '-', $items['asset_date_return']);
                        $model_asset[$i]->asset_date_return = date("Y-m-d", strtotime($items['asset_date_return']));
                    }
                    $valid = $model_asset[$i]->validate() && $valid;
                }
            }
            //Asset
            if ((isset($_POST['HrEmployeeQualification'])) && ($_POST['HrEmployeeQualification'][0]['qualification'] != '')) {
                foreach ($_POST['HrEmployeeQualification'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_qualification[$i] = HrEmployeeQualification::model()->findByPK($items['id']);
                        $model_qualification[$i]->updated_by = Yii::app()->user->id;
                        $model_qualification[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_qualification[$i] = new HrEmployeeQualification();
                        $model_qualification[$i]->created_by = Yii::app()->user->id;
                        $model_qualification[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_qualification[$i]->qualification = $items['qualification'];
                    $model_qualification[$i]->certificate_document = $items['certificate_document'];
                    if ($items['certificate_validity'] != '' && $items['certificate_validity'] != '0000-00-00') {
                        $model_qualification[$i]->certificate_validity = date("Y-m-d", strtotime(str_replace('/', '-', $items['certificate_validity'])));
                    }
                    $valid = $model_qualification[$i]->validate() && $valid;
                }
            }

            //Salary
            if ((isset($_POST['EmployeeSalary'])) && ($_POST['EmployeeSalary'][0]['salary_type'] != '')) {
                foreach ($_POST['EmployeeSalary'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_salary[$i] = EmployeeSalary::model()->findByPK($items['id']);
                        $model_salary[$i]->updated_by = Yii::app()->user->id;
                        $model_salary[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_salary[$i] = new EmployeeSalary();
                        $model_salary[$i]->created_by = Yii::app()->user->id;
                        $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_salary[$i]->employee_id = $model->id;
                    $model_salary[$i]->salary_type = $items['salary_type'];
                    $model_salary[$i]->amount = $items['amount'];
                    $model_salary[$i]->consider_for_leave_payment = $items['consider_for_leave_payment'];
                    if ($items['valid_from'] != '' && $items['valid_from'] != '0000-00-00') {
                        $items['valid_from'] = str_replace('/', '-', $items['valid_from']);
                        $model_salary[$i]->valid_from = date("Y-m-d", strtotime($items['valid_from']));
                    }
                    if (isset($items['valid_to']) && $items['valid_to'] != '' && $items['valid_to'] != '0000-00-00') {
                        $items['valid_to'] = str_replace('/', '-', $items['valid_to']);
                        $model_salary[$i]->valid_to = date("Y-m-d", strtotime($items['valid_to']));
                    }

                    $valid = $model_salary[$i]->validate() && $valid;
                }
            }
            //End Salary
            //Dependants
            if ((isset($_POST['EmployeeDependants'])) && ($_POST['EmployeeDependants'][0]['relationship'] != '')) {
                foreach ($_POST['EmployeeDependants'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_dependants[$i] = EmployeeDependants::model()->findByPK($items['id']);
                        $model_dependants[$i]->updated_by = Yii::app()->user->id;
                        $model_dependants[$i]->updated_date_time = date('Y-m-d H:i:s');
                    } else {
                        $model_dependants[$i] = new EmployeeDependants();
                        $model_dependants[$i]->created_by = Yii::app()->user->id;
                        $model_dependants[$i]->created_date_time = date('Y-m-d H:i:s');
                    }
                    $model_dependants[$i]->dependant_name = $items['dependant_name'];
                    $model_dependants[$i]->relationship = $items['relationship'];
                    $model_dependants[$i]->nationality = $items['nationality'];
                    $model_dependants[$i]->document_upload = $items['document_upload'];
                    $model_dependants[$i]->document_id = $items['document_id'];
                    if ($items['date_of_birth'] != '' && $items['date_of_birth'] != '0000-00-00') {
                        $model_dependants[$i]->date_of_birth = date("Y-m-d", strtotime(str_replace('/', '-', $items['date_of_birth'])));
                    }
                    if ($items['document_id'] != '') {
                        if ($items['renewal_date'] != '' && $items['renewal_date'] != '0000-00-00') {
                            $model_dependants[$i]->renewal_date = date("Y-m-d", strtotime(str_replace('/', '-', $items['renewal_date'])));
                        }
                    }
                    $valid = $model_dependants[$i]->validate() && $valid;
                }
            }
            //Inout Document
            //  if ((isset($_POST['EmployeeInoutDocument'])) && ($_POST['EmployeeInoutDocument'][0]['in_out_type'])) {
            if ((isset($_POST['EmployeeInoutDocument'])) && ($_POST['EmployeeInoutDocument'][0]['in_out_type'])) {
                foreach ($_POST['EmployeeInoutDocument'] as $i => $items) {
                    if ($items['id'] > 0) {
                        $model_inoutdocument[$i] = EmployeeInoutDocument::model()->findByPK($items['id']);
                    } else {
                        $model_inoutdocument[$i] = new EmployeeInoutDocument();
                    }
                    $model_inoutdocument[$i]->in_out_type = $items['in_out_type'];
                    $model_inoutdocument[$i]->in_out_document_id = $items['in_out_document_id'];
                    $model_inoutdocument[$i]->in_out_remarks = $items['in_out_remarks'];

                    $model_inoutdocument[$i]->updated_date_time = date('Y-m-d H:i:s');
                    if ($items['in_out_date'] != '' && $items['in_out_date'] != '0000-00-00') {
                        $items['in_out_date'] = str_replace('/', '-', $items['in_out_date']);
                        $model_inoutdocument[$i]->in_out_date = date("Y-m-d", strtotime($items['in_out_date']));
                    }
                    $valid = $model_inoutdocument[$i]->validate() && $valid;
                }
            }
            //Level
            if ((isset($_POST['HrEmployeeApproveLevel'])) && ($_POST['HrEmployeeApproveLevel'][0]['functionality_id'] != '')) {
                $i = 0;
                foreach ($_POST['HrEmployeeApproveLevel'] as $j => $items) {
                    if ($items['max_level'] > 0) {
                        if ($items['id'] > 0) {
                            $model_level[$i] = HrEmployeeApproveLevel::model()->findByPK($items['id']);
                            $model_level[$i]->updated_by = Yii::app()->user->id;
                            $model_level[$i]->updated_date_time = date('Y-m-d H:i:s');
                        } else {
                            $model_level[$i] = new HrEmployeeApproveLevel();
                            $model_level[$i]->created_by = Yii::app()->user->id;
                            $model_level[$i]->created_date_time = date('Y-m-d H:i:s');
                        }
                        $model_level[$i]->attributes = $_POST['HrEmployeeApproveLevel'][$j];
                        $valid = $model_level[$i]->validate() && $valid;
                        $i++;
                    }
                }
            }
            //End Level
            if($valid) {
                $model->save();
                //Contact Saving
                if ($model_contact->contact_person_name != '' || $model_contact->id != '') {
                    $model_contact->employee_id = $model->id;
                    $model_contact->save();
                }
                //Biometric Exclude
                if ($model->employee_exclude_biometric == 1) {
                    $model_biometric_exclude = new BiometricExclude();
                    $model_biometric_exclude->branch = $model->branch_or_sponsor_id;
                    $model_biometric_exclude->employee_id = $model->id;
                    $model_biometric_exclude->save();
                } else {
                    BiometricExclude::model()->deleteAll('employee_id=:refer_id', array(':refer_id' => $model->id));
                }

                $model_user = User::model()->find(array("condition" => 'company_id="' . Yii::app()->user->master_user_company_id . '" and employee_id ="' . $model->id . '" and level="2"'));
                User::model()->updateByPK($model_user->id, array('is_lead_owner' => $model->is_lead_owner));
                //Save Level
                if (!empty($model_level)) {
                    foreach ($model_level as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Save Document
                if (!empty($model_document)) {
                    foreach ($model_document as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }

                //updated by nisha on 27-01-2023
                //Save Asset
                if (!empty($model_asset)) {
                    foreach ($model_asset as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                        //Asset master
                        $availability_status = 'Y';
                        if ($eachModel->asset_status == 1) {
                            $availability_status = 'N';
                        } else if ($eachModel->asset_status == 2) {
                            $availability_status = 'Y';
                        }
                        HrMasAssetDetails::model()->updateByPK($eachModel->asset_id, array('availability_status' => $availability_status, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                    }
                }
                //Save Qualification
                if (!empty($model_qualification)) {
                    foreach ($model_qualification as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Save Dependant
                if (!empty($model_dependants)) {
                    foreach ($model_dependants as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Save Salary
                if (!empty($model_salary)) {
                    foreach ($model_salary as $eachModel) {
                        $model_salary_details = EmployeeSalary::model()->find(array('condition' => 'employee_id="' . $model->id . '" and salary_type="' . $eachModel->salary_type . '"', 'order' => 'id desc'));
                        if (!empty($model_salary_details) && $model_salary_details->id > 0) {
                            $last_salary_date = date('Y-m-d', strtotime('-1 days', strtotime($eachModel->valid_from)));
                            EmployeeSalary::model()->updateByPK($model_salary_details->id, array('valid_to' => $last_salary_date, 'isActive' => "N", 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                        }
                        $eachModel->employee_id = $model->id;
                        //Updating salary master
                        MasSalarytype::model()->updateByPK($eachModel->salary_type, array('editable' => 1));
                        $eachModel->save();

//                        $model_salary_detail= EmployeeSalary::model()->find(array('select'=>'max(valid_from) as valid_from,count(id) as id','condition'=>'salary_type="'.$eachModel->salary_type.'" and employee_id="'.$model->id.'"'));
//                        if($model_salary_detail->id>1){
//                            EmployeeSalary::model()->updateAll(array('isActive' =>"N"),'valid_from<"'.$model_salary_detail->valid_from.'" and salary_type="'.$eachModel->salary_type.'"');
//                        }
                    }
                }

                //Save InoutDocument
                if (!empty($model_inoutdocument)) {
                    foreach ($model_inoutdocument as $eachModel) {
                        $eachModel->employee_id = $model->id;
                        $eachModel->save();
                    }
                }
                //Updating Approve level details
                $model_level_approval = HrEmployeeApproveLevel::model()->findAll(array('condition' => 'employee_id="' . $model->id . '"'));
                foreach ($model_level_approval as $key => $value) {
                    $model_level = HrEmployeeApproveLevel::model()->findByPK($value->id);
                    $level_1 = $value->level_1_type;
                    if ($level_1 == 'L' && $model->reporting_manager > 0) {
                        $model_level->level_1_authority = $model->reporting_manager;
                    } else if ($level_1 == 'S' && $model->attendance_manager > 0) {
                        $model_level->level_1_authority = $model->attendance_manager;
                    }
                    $level_2 = $value->level_2_type;
                    if ($level_2 == 'L' && $model->reporting_manager > 0) {
                        $model_level->level_2_authority = $model->reporting_manager;
                    } else if ($level_2 == 'S' && $model->attendance_manager > 0) {
                        $model_level->level_2_authority = $model->attendance_manager;
                    }
                    $level_3 = $value->level_3_type;
                    if ($level_3 == 'L' && $model->reporting_manager > 0) {
                        $model_level->level_3_authority = $model->reporting_manager;
                    } else if ($level_3 == 'S' && $model->attendance_manager > 0) {
                        $model_level->level_3_authority = $model->attendance_manager;
                    }
                    $level_4 = $value->level_4_type;
                    if ($level_4 == 'L' && $model->reporting_manager > 0) {
                        $model_level->level_4_authority = $model->reporting_manager;
                    } else if ($level_4 == 'S' && $model->attendance_manager > 0) {
                        $model_level->level_4_authority = $model->attendance_manager;
                    }
                    $level_5 = $value->level_5_type;
                    if ($level_5 == 'L' && $model->reporting_manager > 0) {
                        $model_level->level_5_authority = $model->reporting_manager;
                    } else if ($level_5 == 'S' && $model->attendance_manager > 0) {
                        $model_level->level_5_authority = $model->attendance_manager;
                    }
                    $model_level->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error2 = $error3 = $error4 = $error5 = $error6 = $error7 = array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if (!empty($model_document) && $model_document[0]->document_id > 0) {
                    $error2 = json_decode(CActiveForm::validateTabular($model_document, '', false), true);
                }
                if (!empty($model_inoutdocument) && $model_inoutdocument[0]->in_out_document_id > 0) {
                    $error3 = json_decode(CActiveForm::validateTabular($model_inoutdocument, '', false), true);
                }
                if (!empty($model_asset) && $model_asset[0]->asset_id > 0) {
                    $error4 = json_decode(CActiveForm::validateTabular($model_asset, '', false), true);
                }
                if (!empty($model_salary) && $model_salary[0]->salary_type > 0) {
                    $error5 = json_decode(CActiveForm::validateTabular($model_salary, '', false), true);
                }
                if (!empty($model_dependants) && $model_dependants[0]->relationship > 0) {
                    $error6 = json_decode(CActiveForm::validateTabular($model_dependants, '', false), true);
                }
                if (!empty($model_level) && $model_level[0]->max_level > 0) {
                    $error7 = json_decode(CActiveForm::validateTabular($model_level, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $error5, $error6, $error7));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionremovedocumentRow() {

        $id = $_POST['id'];
        $jsonData=array();
        if ($id > 0) {
            $model = new EmployeeDocuments();
            $model->deleteByPk($id);
             $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSearchEmployee() {
        $from = $_GET['frm'];
        $searchTerm = $this->ciphertext(trim(strtoupper($_GET['term'])), "e");
        if (!empty($searchTerm)) {
            $condition = '(first_name LIKE "%' . $searchTerm . '%"  OR middle_name LIKE "%' . $searchTerm . '%" OR last_name LIKE "%' . $searchTerm . '%" OR employee_code LIKE "%' . $searchTerm . '%") AND isActive!="B"';
        }
        $model = Employee::model()->findAll(array('select' => 'id,employee_code,first_name,date_join,gender', 'condition' => $condition));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $this->ciphertext($eachModel->employee_code, "d") . " : " . $this->ciphertext($eachModel->first_name, "d") . " " . $this->ciphertext($eachModel->last_name, "d");
            $data[$i]['employee_code'] = $this->ciphertext($eachModel->employee_code, "d");
            $data[$i]['fname'] = $this->ciphertext($eachModel->first_name, "d");
            $data[$i]['lname'] = $this->ciphertext($eachModel->last_name, "d");
            $data[$i]['gender'] = $eachModel->gender;
            $data[$i]['designation'] = $eachModel->designationdetail->designation_name;
            $data[$i]['date_join'] = $eachModel->date_join;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionDownloadDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $type = (int) Yii::app()->request->getParam('type');
        if($type==2){
            $arr_employee_document = EmployeeDependants::model()->findByPk($id);
            $file = $arr_employee_document->document_upload;
            $arr_doc_val = explode(',', $arr_employee_document->document_upload);
        }else{
            $arr_employee_document = EmployeeDocuments::model()->findByPk($id);
            $file = $arr_employee_document->document_file;
            $arr_doc_val = explode(',', $arr_employee_document->document_file);
        }
        if (count($arr_doc_val) > 1) {
            $zip = new ZipArchive();
            $zip_file_path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $arr_employee_document->document->document_name . "_" . date('d-m-Y') . ".zip";
           if ($zip->open($zip_file_path, ZipArchive::CREATE) === TRUE) {
                for ($i = 0; $i < count($arr_doc_val); $i++) {
                    $path = "uploads/documents/" . $arr_doc_val[$i];
                    // Add the files to the .zip file
                    $zip->addFile($path, $arr_doc_val[$i]);
                }
                // Closing the zip file
                $zip->close();
            }
            header("Content-type:application/zip"); //for pdf file
            header('Content-Disposition: attachment; filename="' . basename($zip_file_path) . '"');
            header('Content-Length: ' . filesize($zip_file_path));
            readfile($zip_file_path);
            unlink($zip_file_path);
            Yii::app()->end();
        } else {
            if($type==2){
                $file = $arr_employee_document->document_upload;
            }else{
                $file = $arr_employee_document->document_file;
            }
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }

    public function actionViewProfile() {

        $this->layout = 'main';

        $empid = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $model = Employee::model()->findByPk($empid);
        $service_period = '-';
        if ($model->date_join != '0000-00-00' && $model->date_join != '') {
            $current_date = date('Y-m-d');
            $date1 = new DateTime($model->date_join);
            $date2 = new DateTime($current_date);
            $dd = date_diff($date1, $date2);
            $service_period = "$dd->y Yrs $dd->m Month $dd->d Days";
        }
        $this->render('view_profile', array("model" => $model, 'service_period' => $service_period));
    }

    public function actionGetdroutingcode() {
        $id = Yii::app()->request->getparam('id');
        $model = MasBank::model()->findByPk($id);
        $data['routing_code'] = $model->routing_code;

        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionSearchStaff() {
        $from = $_GET['frm'];
        $branch = $_GET['branch'];
        $searchTerm = $this->ciphertext(trim(strtoupper($_GET['term'])), "e");
        $condition = "1=1";
        if ($branch > 0) {
            $condition .= ' AND (branch_or_sponsor_id="' . $branch . '")';
        }
        if (!empty($searchTerm)) {
            $condition .= ' AND (first_name LIKE "%' . $searchTerm . '%"  OR middle_name LIKE "%' . $searchTerm . '%" OR last_name LIKE "%' . $searchTerm . '%" OR employee_code LIKE "%' . $searchTerm . '%") AND isActive!="B"';
        }
        $model = Employee::model()->findAll(array('select' => 'id,employee_code,first_name,date_join,gender', 'condition' => $condition));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $this->ciphertext($eachModel->employee_code, "d") . " : " . $this->ciphertext($eachModel->first_name, "d") . " " . $this->ciphertext($eachModel->last_name, "d");
            $data[$i]['employee_code'] = $this->ciphertext($eachModel->employee_code, "d");
            $data[$i]['fname'] = $this->ciphertext($eachModel->first_name, "d");
            $data[$i]['lname'] = $this->ciphertext($eachModel->last_name, "d");
            $data[$i]['gender'] = $eachModel->gender;
            $data[$i]['date_join'] = $eachModel->date_join;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actiongetmaxsalarydate() {
        $id = $_POST['id'];
        $salarytype = $_POST['salarytype'];
        $date_join = $_POST['date_join'];
        $min_date = "";
        //Employee Salary already calculated
        $model_last_process = SalarySlip::model()->find(array('select' => 'max(salary_processing_id) as salary_processing_id', 'condition' => 'employee_id="' . $id . '"'));
        if ($model_last_process->salary_processing_id > 0) {
            $model_salary_processing = SalaryProcessing::model()->findbyPK($model_last_process->salary_processing_id);
            if ($model_salary_processing->payroll_enddate != '0000-00-00' && $model_salary_processing->payroll_enddate != '') {
                $min_date = date('Y-m-d', strtotime('+1 days', strtotime($model_salary_processing->payroll_enddate)));
                $data['min_date'] = date("d/m/Y", strtotime($min_date));
            }
        } else {
            $model_salary = EmployeeSalary::model()->find(array('select' => 'max(valid_from) as valid_from,max(valid_to) as valid_to', 'condition' => 'employee_id="' . $id . '" and salary_type="' . $salarytype . '"'));
            if ($model_salary->valid_to != '0000-00-00' && $model_salary->valid_to != '') {
                $model_salary->valid_to = date('Y-m-d', strtotime('+1 days', strtotime($model_salary->valid_to)));
                $min_date = $model_salary->valid_to;
                $data['min_date'] = date("d/m/Y", strtotime($model_salary->valid_to));
            } else if ($model_salary->valid_from != '0000-00-00' && $model_salary->valid_from != '') {
                $model_salary->valid_from = date('Y-m-d', strtotime('+1 days', strtotime($model_salary->valid_from)));
                $min_date = $model_salary->valid_from;
                $data['min_date'] = date("d/m/Y", strtotime($model_salary->valid_from));
            }
            if ($min_date == '') {
                if ($date_join != '') {
                    $date_join = str_replace('/', '-', $date_join);
                    $min_date = date("Y-m-d", strtotime($date_join));
                    $data['min_date'] = date("d/m/Y", strtotime($min_date));
                } else {
                    $model_salary_processing = SalaryProcessing::model()->find(array('select' => 'max(payroll_enddate) as payroll_enddate'));
                    if ($model_salary_processing->payroll_enddate != '0000-00-00' && $model_salary_processing->payroll_enddate != '') {
                        $min_date = date('Y-m-d', strtotime('+1 days', strtotime($model_salary_processing->payroll_enddate)));
                        $data['min_date'] = date("d/m/Y", strtotime($min_date));
                    }
                }
            }
        }
        $data['status'] = 'success';
        echo CJSON::encode($data);
    }

    public function actionPrintEmployeeSnapshotPDF() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_snapshot_tab']) || Yii::app()->user->authorised_user == 1) {
            $en_id = $_GET['id'];
            $id = $this->ciphertext($en_id, "d");
            $model = Employee::model()->findbyPK($id);
            $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            if (!empty($model)) {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.employee_details_individual', array('id' => $id, 'model' => $model), true));
            } else {
                $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.pdf.error', array(), true));
            }
            $mPDF1->Output('snapshot', 'I');
        }
    }

    public function actiongetemployeegratuityamount() {
        $id = $_POST['id'];
        $current_date = date('Y-m-d');
        $service_days = 0.00;
        if ($id > 0) {
            $model_employee = Employee::model()->findbyPk($id);
            Yii::import('application.modules.hr.controllers.EosdetailsController');
            $gratuity_amt = EosdetailsController::geteos($model_employee->id, $current_date, 1);
            $data['gratuityamount'] = $gratuity_amt;
            $data['status'] = 'success';
        } else {
            $data['gratuityamount'] = 0.00;
            $data['status'] = 'error';
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionDownloadSampleCsv() {
        $filename = 'employee_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Branch*,Employee Code *,Biometric Code *,First Name *,Last Name *,Department *,Designation *,Currency *,Gender *,Mobile *,Email *,Personal File No *, Nationality *, Joining Date *(YYYY-mm-dd),IBAN No,Bank Routing Code,Contract Type(1-Limited 2-Unlimited),Marital Status(1-Single 2-Married),Date of birth*(YYYY-mm-dd)';
        Yii::app()->end();
    }

    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/employee_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }

    public function readEmployeeCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }

    public function actionSaveUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $url = Yii::app()->basePath . '/../uploads/employee_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/employee_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate = TRUE;
        $error_list = array();
        $employeecode_error = array();
        $biometriccode_error = array();
        $employee_list = $this->readEmployeeCSV("uploads/employee_csv/" . $file_name);
        $model_tb_count = Employee::model()->count();
        $linecount = count(file("uploads/employee_csv/" . $file_name)) - 1;
        $total_employee_count = $model_tb_count + $linecount;
        $model_mas_company = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        if ($total_employee_count < $model_mas_company->total_employees_allowed) {
            foreach (array_slice($employee_list, 1) as $i => $data) {
                if (!empty($data[0]) || !empty($data[1]) || !empty($data[2]) || !empty($data[3]) || !empty($data[4]) || !empty($data[5]) || !empty($data[6]) || !empty($data[7]) || !empty($data[8]) || !empty($data[9]) || !empty($data[10]) || !empty($data[11]) || !empty($data[12]) || !empty($data[13]) || !empty($data[14]) || !empty($data[15]) || !empty($data[16]) || !empty($data[18])) {
                    $employee_model[$i] = new Employee();
                    $employee_model[$i]->scenario = "excelupload";
                    if (!empty($data[0])) {
                        $condition = '((REPLACE(`branch_or_sponsor_name`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'))) . '%"  OR id LIKE "%' . $data[0] . '%")  AND isActive ="Y")';
                        $model_branch_or_sponsor_id[$i] = MasCompanyBranchSponsor::model()->find(array('select' => 'id', 'condition' => $condition));
                        $employee_model[$i]->branch_or_sponsor_id = $model_branch_or_sponsor_id[$i]->id;
                    } else {
                        $employee_model[$i]->branch_or_sponsor_id = 0;
                    }
                    if (!empty($data[1])) {
                        $employee_model[$i]->employee_code = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"')), "e");
                        $employee_model[$i]->hr_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                    } else {
                        $employee_model[$i]->employee_code = '';
                    }
                    $employeecode_error[$i] = $employee_model[$i]->employee_code;
                    if (!empty($data[2])) {
                        $employee_model[$i]->employee_biometric_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                    } else {
                        $employee_model[$i]->employee_biometric_code = '';
                    }
                    $biometriccode_error[$i] = $employee_model[$i]->employee_biometric_code;
                    if (!empty($data[3])) {
                        $employee_model[$i]->first_name = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"')), "e");
                    } else {
                        $employee_model[$i]->first_name = '';
                    }
                    if (!empty($data[4])) {
                        $employee_model[$i]->last_name = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[4]), '"')), "e");
                    } else {
                        $employee_model[$i]->last_name = '';
                    }
                    $employee_model[$i]->de_first_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"')) . ' ' . trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[4]), '"'));
                    if (!empty($data[5])) {
                        $department_name= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[5]), '"'));
                        $condition = 'department_name="'.$department_name.'" AND isActive ="Y"';   
                        //$condition = '((REPLACE(`department_name`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[5]), '"'))) . '%"  OR id LIKE "%' . $data[5] . '%" ) AND isActive ="Y")';
                        $model_department[$i] = MasDepartment::model()->find(array('select' => 'id', 'condition' => $condition));
                        $employee_model[$i]->department = $model_department[$i]->id;
                    } else {
                        $employee_model[$i]->department = '0';
                    }
                    if (!empty($data[6])) {
                        $designation_name= trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[6]), '"'));
                        $condition = 'designation_name="'.$designation_name.'" AND isActive ="Y"';  
                        // $condition = '((REPLACE(`designation_name`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[6]), '"'))) . '%"  OR id LIKE "%' . $data[6] . '%" ) AND isActive ="Y")';
                        $model_designation[$i] = MasDesignation::model()->find(array('select' => 'id', 'condition' => $condition));
                        if(!empty($model_designation[$i])){
                            $employee_model[$i]->designation = $model_designation[$i]->id;
                        }
                    } else {
                        $employee_model[$i]->designation = '0';
                    }
                    if (!empty($data[7])) {
                        $condition = '((REPLACE(`currency`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[7]), '"'))) . '%" OR REPLACE(`currency_code`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[7]), '"'))) . '%" OR id LIKE "%' . $data[7] . '%") AND isActive ="Y")';
                        $model_currency[$i] = MasCurrency::model()->find(array('select' => 'id', 'condition' => $condition));
                        $employee_model[$i]->currency = $model_currency[$i]->id;
                    } else {
                        $employee_model[$i]->currency = '0';
                    }
                    if (strtoupper(str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[8]), '"')))) == "MALE" || $data[8] == 1) {
                        $gender[$i] = 1;
                    } elseif (strtoupper(str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[8]), '"')))) == "FEMALE" || $data[8] == 2) {
                        $gender[$i] = 2;
                    } else {
                        $gender[$i] = 0;
                    }
                    $employee_model[$i]->gender = $gender[$i];
                    $employee_model[$i]->mobile = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[9]), '"'));
                    $employee_model[$i]->email = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[10]), '"'));
                    $employee_model[$i]->personal_file_no = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[11]), '"'));
                    $employee_model[$i]->isActive = 'Y';
                    if (!empty($data[12])) {
                        $condition = '((REPLACE(`country_name`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[12]), '"'))) . '%" OR REPLACE(`country_code`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[12]), '"'))) . '%" OR id LIKE "%' . $data[12] . '%") AND isActive ="Y")';
                        $model_nationaliy[$i] = MasCountry::model()->find(array('select' => 'id', 'condition' => $condition));
                        $employee_model[$i]->nationality = $model_nationaliy[$i]->id;
                    } else {
                        $employee_model[$i]->nationality = '';
                    }
                    if (!empty($data[13])) {
                        $employee_model[$i]->date_join = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[13]), '"'));
                        $employee_model[$i]->probation_date = date('Y-m-d', strtotime('+180 days', strtotime($employee_model[$i]->date_join)));
                    } else {
                        $employee_model[$i]->date_join = '';
                    }
                    $employee_model[$i]->employee_iban_no = str_replace(" ", "", trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[14]), '"')));
                    if (!empty($data[15])) {
                        $model_bank[$i] = MasBank::model()->find(array('select' => 'id', 'condition' => 'routing_code="' . trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[15]), '"')) . '"'));
                        if (isset($model_bank[$i])) {
                            $employee_model[$i]->employee_bankname = $model_bank[$i]->id;
                        }
                        $employee_model[$i]->employee_wpscode = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[15]), '"'));
                    } else {
                        $employee_model[$i]->employee_bankname = '0';
                        $employee_model[$i]->employee_wpscode = '';
                    }
                    if (!empty($data[16])) {
                        $employee_model[$i]->employee_type = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[16]), '"'));
                    } else {
                        $employee_model[$i]->employee_type = 2;
                    }
                    if (!empty($data[17])) {
                        $employee_model[$i]->marital_status = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[17]), '"'));
                    } else {
                        $employee_model[$i]->marital_status = 0;
                    }

                    if (!empty($data[18])) {
                        $employee_model[$i]->date_of_birth = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[18]), '"'));
                    } else {
                        $employee_model[$i]->date_of_birth = '';
                    }
                    $employee_model[$i]->created_date_time = date('Y-m-d H:i:s');
                    $validate = $employee_model[$i]->validate() && $validate;
                }
            }

            //echo '<pre>';  print_r($employee_model);      die();
            function array_not_unique($raw_array) {
                $dupes = array();
                natcasesort($raw_array);
                reset($raw_array);

                $old_key = NULL;
                $old_value = NULL;
                foreach ($raw_array as $key => $value) {
                    if ($value === NULL) {
                        continue;
                    }
                    if ($old_value != NULL) {
                        if (strcasecmp($old_value, $value) === 0) {
                            $dupes[$old_key] = $old_value;
                            $dupes[$key] = $value;
                        }
                    }
                    $old_value = $value;
                    $old_key = $key;
                }
                return $dupes;
            }

            $empcode_common = array_not_unique($employeecode_error);
            $biocode_common = array_not_unique($biometriccode_error);
            if ($validate && empty($empcode_common) && empty($biocode_common)) {
                if (!empty($employee_model)) {
                    foreach ($employee_model as $eachModel) {
                        //Weekend
                        $branch = $eachModel->branch_or_sponsor_id;
                        $model_weekend = WorkingHours::model()->findAll(array('condition' => 'company_branch_or_sponsor_id="' . $branch . '" and weekend="0"'));
                        if (isset($model_weekend[0]['week_id']) && $model_weekend[0]['week_id'] > 0) {
                            $eachModel->weekend_off1 = $model_weekend[0]['week_id'];
                            $eachModel->weekend_off1_type = 'F';
                        } else {
                            $eachModel->weekend_off1_type = '';
                        }
                        if (isset($model_weekend[1]['week_id']) && $model_weekend[1]['week_id'] > 0) {
                            $eachModel->weekend_off2 = $model_weekend[1]['week_id'];
                            $eachModel->weekend_off2_type = 'F';
                        } else {
                            $eachModel->weekend_off2_type = '';
                        }
                        if (isset($model_weekend[2]['week_id']) && $model_weekend[2]['week_id'] > 0) {
                            $eachModel->weekend_off3 = $model_weekend[2]['week_id'];
                            $eachModel->weekend_off3_type = 'F';
                        } else {
                            $eachModel->weekend_off3_type = '';
                        }
                        $eachModel->save();
                        $model_module_ess = HrModules::model()->findByPK(33);
                        if(!empty($model_module_ess) && $model_module_ess->grant_access==1 && $model_module_ess->isActive='Y'){
                            //User Login creation
                            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
                            $emp_code = $this->ciphertext($eachModel->employee_code, "d");
                            $password = crypt(trim($emp_code), $salt);
                            $model_user = new User();
                            $model_user->password = $password;
                            $model_user->username = $this->ciphertext($eachModel->employee_code, "d");
                            $model_user->first_name = $this->ciphertext($eachModel->first_name, "d");
                            $model_user->last_name = $this->ciphertext($eachModel->last_name, "d");
                            $model_user->company_id = Yii::app()->user->master_user_company_id;
                            $model_user->subledger_added = "N";
                            $model_user->user_group_id = 37;
                            $model_user->employee_id = $eachModel->id;
                            $model_user->designation = $eachModel->designationdetail->designation_name;
                            $model_user->is_lead_owner = $eachModel->is_lead_owner;
                            $model_user->level = 2;
                            $model_user->created_by = Yii::app()->user->id;
                            $model_user->created_date_time = date('Y-m-d H:i:s');
                            $model_user->save(false);
                        }
                        //Branch details
                        $model_branch = new EmployeeBranch();
                        $model_branch->employee_id = $eachModel->id;
                        $model_branch->branch_id = $eachModel->branch_or_sponsor_id;
                        $model_branch->from_date = $eachModel->date_join;
                        $model_branch->save();
                        //Department
                        $model_department = new EmployeeDepartment();
                        $model_department->employee_id = $eachModel->id;
                        $model_department->department_id = $eachModel->department;
                        $model_department->from_date = $eachModel->date_join;
                        $model_department->save();
                        //dESIGNATION
                        $model_designation = new EmployeeDesignation();
                        $model_designation->employee_id = $eachModel->id;
                        $model_designation->designation_id = $eachModel->designation;
                        $model_designation->from_date = $eachModel->date_join;
                        $model_designation->save();
                    }
                    $jsonData['error'] = "";
                }
            } else {
                if (!empty($employee_model)) {
                    foreach ($employee_model as $s => $data_model) {
                        $error_list[$s]['branch_or_sponsor_id'] = $data_model['branch_or_sponsor_id'];
                        $error_list[$s]['employee_code'] = $data_model['employee_code'];
                        $error_list[$s]['employee_biometric_code'] = $data_model['employee_biometric_code'];
                        $error_list[$s]['first_name'] = $data_model['first_name'];
                        $error_list[$s]['last_name'] = $data_model['last_name'];
                        $error_list[$s]['department'] = $data_model['department'];
                        $error_list[$s]['designation'] = $data_model['designation'];
                        $error_list[$s]['currency'] = $data_model['currency'];
                        $error_list[$s]['gender'] = $data_model['gender'];
                        $error_list[$s]['mobile'] = $data_model['mobile'];
                        $error_list[$s]['email'] = $data_model['email'];
                        $error_list[$s]['personal_file_no'] = $data_model['personal_file_no'];
                        $error_list[$s]['nationality'] = $data_model['nationality'];
                        $error_list[$s]['date_join'] = $data_model['date_join'];
                        $error_list[$s]['employee_iban_no'] = $data_model['employee_iban_no'];
                        $error_list[$s]['employee_wpscode'] = $data_model['employee_wpscode'];
                        $error_list[$s]['employee_type'] = $data_model['employee_type'];
                        $error_list[$s]['marital_status'] = $data_model['marital_status'];
                        $error_list[$s]['date_of_birth'] = $data_model['date_of_birth'];
                        if ($data_model->validate()) {
                            $error_list[$s]['remarks'] = "correct";
                        } else {
                            $error_list[$s]['remarks'] = $data_model->getErrors();
                        }
                    }
                }
            }

            $j = 0;
            fclose($file);
            $list = array();
            if (!empty($error_list)) {
                $file_error = fopen($error_url, "w+");
                $list[$j++] = 'Branch*,Employee Code *,Biometric Code *,First Name *,Last Name *,Department *,Designation *,Currency *, Gender *, Mobile*,Email*,Personal File No*,Nationaity *,Date of Join *,IBAN No,Bank Routing Code,Contract Type(1-Limited 2-Unlimited),Marital Status(1-Single 2-Married),Date of birth *,Remarks';
                foreach ($error_list as $i => $error_detail) {
                    $error_view[$i] = '';
                    if (!empty($error_detail)) {
                        if (!empty($error_detail['remarks'])) {
                            foreach ($error_detail['remarks'] as $p => $error_value) {
                                $error_view[$i] .= $error_value[0] . " / ";
                            }
                        } else {
                            $error_view[$i] .= '';
                        }
                        if (in_array($error_detail['employee_code'], $empcode_common)) {
                            $error_view[$i] .= " Employee code duplication in CSV /";
                        } else {
                            $error_view[$i] .= '';
                        }
                        if (in_array($error_detail['employee_biometric_code'], $biocode_common)) {
                            $error_view[$i] .= " Biometric code duplication in CSV /";
                        } else {
                            $error_view[$i] .= '';
                        }
                        $list[$j++] = $error_detail['branch_or_sponsor_id'] . ',' . $this->ciphertext($error_detail['employee_code'], "d") . ',' . $error_detail['employee_biometric_code'] . ',' . $this->ciphertext($error_detail['first_name'], "d") . ',' . $this->ciphertext($error_detail['last_name'], "d") . ',' . $error_detail['department'] . ',' . $error_detail['designation'] . ',' . $error_detail['currency'] . ',' . $error_detail['gender'] . ',' . $error_detail['mobile'] . ',' . $error_detail['email'] . ',' . $error_detail['personal_file_no'] . ',' . $error_detail['nationality'] . ',' . $error_detail['date_join'] . ',' . $error_detail['employee_iban_no'] . ',' . $error_detail['employee_wpscode'] . ',' . $error_detail['employee_type'] . ',' . $error_detail['marital_status'] . ',' . $error_detail['date_of_birth'] . ',' . $error_view[$i];
                    }
                }
                //$jsonData['link'] = CHtml::link('Download Status', array('hr/employee/DownloadErrorCsv', 'id'=>$file_name), array('class'=>'btn btn-theme','target' => '_blank', ));
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                fclose($file_error);
            }
            $jsonData['status'] = "success";
            $jsonData['error_url'] = $error_url;
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download log', array('employee/DownloadErrorCsv', 'id' => $file_name), array('target' => '_blank',
                        'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                        . ''
            ));
        } else {
            $jsonData['status'] = "error";
        }
        echo CJSON::encode($jsonData);
    }

    public function actionBlock() {
        $id = $_POST['id'];
        $flag=0;
        $model_level = new HrEmployeeApproveLevel();
        //Level 1 
        $model_level_1 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$id. '" and max_level="1" AND level_1_authority="'.$id.'"'));
        //Level 2 
        $model_level_2 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$id. '" and max_level="2" AND (level_1_authority="'.$id.'" OR level_2_authority="'.$id.'")'));
        //Level 1 
        $model_level_3 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$id. '" and max_level="3" AND (level_1_authority="'.$id.'" OR level_2_authority="'.$id.'" OR level_3_authority="'.$id.'")'));
        //Level 1 
        $model_level_4 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$id. '" and max_level="4" AND (level_1_authority="'.$id.'" OR level_2_authority="'.$id.'" OR level_3_authority="'.$id.'" OR level_4_authority="'.$id.'")'));
        //Level 1 
        $model_level_5 = $model_level->with('employeedetail')->findAll(array('condition' => 'employeedetail.isActive="Y" and employee_id!="'.$id. '" and max_level="5" AND (level_1_authority="'.$id.'" OR level_2_authority="'.$id.'" OR level_3_authority="'.$id.'" OR level_4_authority="'.$id.'" OR level_5_authority="'.$id.'")'));
        $jsonData= array();
        if(!empty($model_level_1) || !empty($model_level_2) || !empty($model_level_3) || !empty($model_level_4) || !empty($model_level_5) ){
            $flag=1;
            $jsonData['status'] = 'error';
            $jsonData['message'] = 'Exist as Approver in Level';
        }
        if($flag==0){
            $model = Employee::model()->findByPk($id);
            $model->date_blocked = date('Y-m-d');
            $model->isActive = "B";
            $model->save(false);
            User::model()->updateAll(array('isActive' => "N"), array('condition' => 'employee_id="' . $id . '" and company_id ="' . Yii::app()->user->master_user_company_id . '"'));
            $jsonData['status'] = 'success';
            $jsonData['message'] = 'Employee Blocked SuccessFully!';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionUnBlock() {
        $id = $_POST['id'];
        $model = Employee::model()->findByPk($id);
        $model->date_unblocked = date('Y-m-d');
        $model->isActive = "Y";
        $model->save(false);
        User::model()->updateAll(array('isActive' => "Y"), array('condition' => 'employee_id="' . $id . '" and company_id ="' . Yii::app()->user->master_user_company_id . '"'));
        echo "success";
    }

    public function actiondeleteuploadedfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $document_detail = new EmployeeDocuments();
        $model_documents = EmployeeDocuments::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->document_file);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files='';
            if(!empty($document_file_array)){
                $files = implode(',', $document_file_array);
            }
            EmployeeDocuments::model()->updateByPK($id, array('document_file' => $files));
            unlink(Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file_name);
            $div_file = '<span id="spanfile_' . $i . '">';
            if(!empty($document_file_array)){
                foreach ($document_file_array as $value_file) {
                    $f_name = "'" . $value_file . "'";
                    $div_file .= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedfile(this.id,' . $id . ',' . $f_name . ');" id="delete_file_'.$i.'"><i class="fa fa-trash"></i></a><br>';
                }
            }
            $div_file .= '</span>';
            $div_file .= CHtml::activeHiddenField($document_detail, "[" . $i . "]document_file", array('value' => $files));
            echo $div_file;
        }
    }

    public function actionremovedependant() {
        $id = $_POST['id'];
        if ($id > 0) {
            EmployeeDependants::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actiondeletedependantfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $document_detail = new EmployeeDependants();
        $model_documents = EmployeeDependants::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->document_upload);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files = implode(',', $document_file_array);
            EmployeeDependants::model()->updateByPK($id, array('document_upload' => $files));
            unlink(Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file_name);
            $div_file = '<span id="spandependentantfile_' . $i . '">';
            foreach ($document_file_array as $value_file) {
                $f_name = "'" . $value_file . "'";
                $div_file .= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deletedependantfile(this.id,' . $id . ',' . $f_name . ');" id="deletedp_file_'.$i.'"><i class="fa fa-trash"></i></a><br>';
            }
            $div_file .= '</span>';
            $div_file .= CHtml::activeHiddenField($document_detail, "[" . $i . "]document_upload", array('value' => $files));
            echo $div_file;
        }
    }

    public function actionUploadSalary() {
        $model = new EmployeeSalary();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_salary', array('model' => $model), false, true);
    }

    public function actionDownloadsalaryformat() {
        $filename = 'salary_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee Code *,Salary Type *,Start Date (YYYY-mm-dd)*,Amount*';
        Yii::app()->end();
    }

    public function actionSaveSalaryUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/employee_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/employee_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate = TRUE;
        $error_list = array();
        $salary_list = $this->readEmployeeCSV("uploads/employee_csv/" . $file_name);
        foreach (array_slice($salary_list, 1) as $i => $data) {
            if (!empty($data[0]) || !empty($data[1]) || !empty($data[2]) || !empty($data[3])) {
                $model_salary[$i] = new EmployeeSalary();
                $model_salary[$i]->scenario = "excelupload";
                if (!empty($data[0])) {
                    $employee_code = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"')), "e");
                    $model_employee = Employee::model()->find(array('condition' => 'employee_code="' . $employee_code . '"'));
                    if ($model_employee->id > 0) {
                        $model_salary[$i]->employee_id = $model_employee->id;
                    } else {
                        $model_salary[$i]->employee_id = '';
                    }
                } else {
                    $model_salary[$i]->employee_id = '';
                }
                $model_salary[$i]->emp_code = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"'));
                if (!empty($data[1])) {
                    $condition = '((REPLACE(`salary_name`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'))) . '%"  OR id LIKE "%' . $data[1] . '%" ) AND isActive ="Y")';
                    $model_salarytype[$i] = MasSalarytype::model()->find(array('select' => 'id', 'condition' => $condition));
                    if(!empty($model_salarytype[$i])){
                        $model_salary[$i]->salary_type = $model_salarytype[$i]->id;
                    }else{
                        $model_salary[$i]->salary_type = 0;
                    }
                } else {
                    $model_salary[$i]->salary_type = '0';
                }
                $model_salary[$i]->salary_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'));
                if (!empty($data[2])) {
                    $model_salary[$i]->valid_from = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                } else {
                    $model_salary[$i]->valid_from = '';
                }
                $model_salary[$i]->amount = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"'));
                $model_salary[$i]->consider_for_leave_payment = 'N';
                $model_salary[$i]->created_by = Yii::app()->user->id;
                $model_salary[$i]->created_date_time = date('Y-m-d H:i:s');
                $model_salary[$i]->isActive = 'Y';
                $validate = $model_salary[$i]->validate() && $validate;
            }
        }
        if ($validate) {
            if (!empty($model_salary)) {
                foreach ($model_salary as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['error'] = "";
            }
        } else {
            if (!empty($model_salary)) {
                foreach ($model_salary as $s => $data_model) {
                    $error_list[$s]['emp_code'] = $data_model['emp_code'];
                    $error_list[$s]['salary_name'] = $data_model['salary_name'];
                    $error_list[$s]['valid_from'] = $data_model['valid_from'];
                    $error_list[$s]['amount'] = $data_model['amount'];
                    if ($data_model->validate()) {
                        $error_list[$s]['remarks'] = "correct";
                    } else {
                        $error_list[$s]['remarks'] = $data_model->getErrors();
                    }
                }
            }
        }

        $j = 0;
        fclose($file);
        $list = array();
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Employee Code *,Salary Type *,Start Date *,Amount*,Remarks';
            foreach ($error_list as $i => $error_detail) {
                $error_view[$i] = '';
                if (!empty($error_detail)) {
                    if (!empty($error_detail['remarks']) && is_array($error_detail['remarks'])) {
                        foreach ($error_detail['remarks'] as $p => $error_value) {
                            if (is_array($error_value) && isset($error_value[0])) {
                                $error_view[$i] .= $error_value[0] . " / ";
                            }
                        }
                    } else {
                        $error_view[$i] .= '';
                    }
                    $list[$j++] = $error_detail['emp_code'] . ',' . $error_detail['salary_name'] . ',' . $error_detail['valid_from'] . ',' . $error_detail['amount'] . ',' . $error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }


        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('employee/DownloadErrorCsv', 'id' => $file_name), array('target' => '_blank',
                    'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                    . ''
        ));
        echo CJSON::encode($jsonData);
    }

    public function actionchangeprofilepic() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = Employee::model()->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_profile_pic', array('model' => $model), false, true);
    }

    public function actionSaveProfilepic() {
        $id = $_POST['Employee']['id'];
        $profile_photo = $_POST['Employee']['profile_photo'];
        ;
        Employee::model()->updateByPK($id, array('profile_photo' => $profile_photo, 'updated_date_time' => date('Y-m-d H:i:s'), 'updated_by' => Yii::app()->user->id));
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actioncodegenerate() {
        $branch = (int) Yii::app()->request->getParam('branch');
        $model_general_setting = HrGenerelSettings::model()->find();
        $new_employee_code = '';
        if ($model_general_setting->use_hr_code_increment_employee_code == 'Y' && $model_general_setting->auto_increment_employee_code == 'Y') {
            $model_branch = MasCompanyBranchSponsor::model()->findbyPk($branch);
            $hr_code = $model_branch->hr_code;
            $code_len = strlen($hr_code);
            $next_len = $code_len + 1;
            $model_employee = Employee::model()->find(array('select' => 'MAX(CAST(SUBSTRING(hr_code,' . $next_len . ', length(hr_code)-' . $code_len . ') AS UNSIGNED)) as employee_code', 'condition' => '(SUBSTRING(hr_code,1,' . $code_len . ') ="' . $hr_code . '")'));
            $new_no = '0001';
            if ($model_employee['employee_code'] != '') {
                $new_no = $model_employee['employee_code'] + 1;
            }
            if ((int) $new_no < 1000) {
                $new_no = str_pad($new_no, 4, '0', STR_PAD_LEFT);
            }
            $new_employee_code = $hr_code . '' . $new_no;
        } else if ($model_general_setting->auto_increment_employee_code == 'Y') {
            $model_employee = Employee::model()->find(array('select' => 'MAX(CAST(hr_code AS UNSIGNED)) AS hr_code'));
            $new_no = '0001';
            if ($model_employee['hr_code'] != '') {
                $new_no = $model_employee['hr_code'] + 1;
            }
            if ((int) $new_no < 1000) {
                $new_no = str_pad($new_no, 4, '0', STR_PAD_LEFT);
            }
            $new_employee_code = $new_no;
        }
        $jsonData['code'] = $new_employee_code;
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionView() {
        $model = new Employee();
        $model_asset = array(new EmployeeAsset());
        $model_leave = array(new EmployeeLeave());
        $emp_wps = new EmployeewpsCompany();
        $model_inoutdocument = array(new EmployeeInoutDocument());
        $model_documents = array(new EmployeeDocuments());
        $model_salary = array(new EmployeeSalary());
        $model_employee_salary = array(new EmployeeSalary());
        $model_notes = array(new EmployeeNotes());
        $model_dependants = array(new EmployeeDependants());
        $model_qualification = array(new HrEmployeeQualification());
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_qualification = HrEmployeeQualification::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_qualification)) {
                $model_qualification = array(new HrEmployeeQualification());
            }
            $model_dependants = EmployeeDependants::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_dependants)) {
                $model_dependants = array(new EmployeeDependants());
            }
            $model_asset = EmployeeAsset::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $emp_wps = EmployeewpsCompany::model()->find(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_asset)) {
                $model_asset = array(new EmployeeAsset());
            }
            $model_leave = EmployeeLeave::model()->findAll(array('condition' => 'employee_id="' . $id . '" and leave_year="' . date("Y") . '"'));
            $model_inoutdocument = array(new EmployeeInoutDocument());
            $model_inoutdocument_details = EmployeeInoutDocument::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $model_documents = EmployeeDocuments::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_documents)) {
                $model_documents = array(new EmployeeDocuments());
            }
            $model_salary = EmployeeSalary::model()->findAll(array('condition' => 'employee_id="' . $id . '" and isActive="Y"'));
            if (empty($model_salary)) {
                $model_salary = array(new EmployeeSalary());
            }
            $model_employee_salary = array(new EmployeeSalary());
            $model_salary_details_employee = EmployeeSalary::model()->with('salary')->findAll(array('condition' => 'employee_id="' . $id . '" and t.isActive="N"', 'order' => 'salary.salary_name asc'));
            if (empty($model_salary_details_employee)) {
                $model_salary_details_employee = array(new EmployeeSalary());
            }
            $model_loan = EmployeeLoanDetail::model()->findAll(array('condition' => 'employee_id="' . $id . '" and loan_status!=0'));
            $model_issued_certificates = EmployeeCertificate::model()->findAll(array('condition' => 'employee_id="' . $id . '" and (status="12" OR status="14")'));
            $model_warning_notice = EmployeeAttendanceWarning::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $model_notes = EmployeeNotes::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $model_contact = EmployeeContacts::model()->find(array('condition' => 'employee_id="' . $id . '"'));
            if (empty($model_contact->id)) {
                $model_contact = new EmployeeContacts();
            }
            $model_training_details = HrTrainingDetails::model()->findAll(array('condition' => 'employee_id="' . $id . '"'));
            $this->renderPartial('view_employee', array('model_salary_details_employee' => $model_salary_details_employee,'model_qualification' => $model_qualification, 'model' => $model, 'model_contact' => $model_contact, 'model_training_details' => $model_training_details, 'model_dependants' => $model_dependants, 'model_notes' => $model_notes, 'model_warning_notice' => $model_warning_notice, 'model_inoutdocument_details' => $model_inoutdocument_details, 'model_employee_salary' => $model_employee_salary, 'emp_wps' => $emp_wps, 'model_asset' => $model_asset, 'model_leave' => $model_leave, 'model_inoutdocument' => $model_inoutdocument, 'model_issued_certificates' => $model_issued_certificates, 'model_documents' => $model_documents, 'model_salary' => $model_salary, 'model_loan' => $model_loan), false, true);
        }
    }

    public function actionremovequalification() {
        $id = $_POST['id'];
        $model = HrEmployeeQualification::model()->findByPk($id);
        if ($model->certificate_document != '') {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/qualification/" . $model->certificate_document;
            if (unlink($path)) {
                HrEmployeeQualification::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            HrEmployeeQualification::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        echo CJSON::encode($jsonData);
    }

    public function actiondownloadqualification() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_qlf = HrEmployeeQualification::model()->findByPk($id);
        $file = $arr_employee_qlf->certificate_document;
        $path = Yii::getPathOfAlias('webroot') . "/uploads/qualification/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    //Created on 7/7/2022 by DIkson R
    public function actionEmployeebyBranch() {
        $branch = $_POST['branch_id'];
        $dropdownlist .= CHtml::dropdownlist('employee_id_val', '', Employee::getEmployee($branch), array('title' => 'Employee Name', 'data-label' => 'Employee Name', 'data-search' => true, 'empty' => 'All Employees', 'onchange' => 'employeedetails();'));
        $jsonData['employee'] = $dropdownlist;
        echo CJSON::encode($jsonData);
    }

    /*    public function actionremoveasset(){
      $id = $_POST['id'];

      if($id>0){
      EmployeeAsset::model()->deleteByPk($id);
      $status['status'] = 'success';
      }
      else{
      $status['status'] = 'error';
      }
      echo CJSON::encode($status);
      }

     */

    //updated by nisha on 02-12-2022
    public function actioncheckassetalreadyallocated() {
        $id = $_POST['id'];
        $asset_id = $_POST['asset_id'];
        //check whether already allocated
        $condition = 'asset_id="' . $asset_id . '" AND asset_status="1"';
        if ($id > 0) {
            $condition .= ' AND id!="' . $id . '"';
        }
        $data['asset_id'] = 0;
        $model_employee_asset = EmployeeAsset::model()->find(array('condition' => $condition));
        if (!empty($model_employee_asset)) {
            if ($id > 0) {
                $model_asset = EmployeeAsset::model()->findbyPK($id);
                $data['asset_id'] = $model_asset->asset_id;
            }
            $data['status'] = 'error';
        } else {
            $data['status'] = 'success';
        }
        echo CJSON::encode($data);
    }

    public function actionremoveasset() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model_asset = EmployeeAsset::model()->findbyPK($id);
            $asset_id = $model_asset->asset_id;
            EmployeeAsset::model()->deleteByPk($id);
            $model_employee_asset = EmployeeAsset::model()->find(array('condition' => 'asset_id="' . $asset_id . '" AND asset_status="1"'));
            if (empty($model_employee_asset)) {
                HrMasAssetDetails::model()->updateByPK($asset_id, array('availability_status' => 'Y', 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
            }
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionDownloadAssetDocument() {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_document = EmployeeAsset::model()->findByPk($id);
        $file = $arr_employee_document->asset_undertaking_letter;
        $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    public function actionPrintletter() {
        $id = Yii::app()->request->getParam('id');
        $model = EmployeeAsset::model()->findByPk($id);
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.employee.print_undertaking_letter', array('model' => $model), true));
        $mPDF1->Output('undertakingletter.pdf', 'I');
    }

    public function actionUndertakingPrintletter() {
        $asset_id = Yii::app()->request->getParam('asset_id');
        $employee_id = Yii::app()->request->getParam('employee_id');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.hr.views.employee.print_undertaking_letter_asset', array( 'asset_id' => $asset_id, 'employee_id' => $employee_id), true));
        $mPDF1->Output('undertakingletter.pdf', 'I');
    }

    public function actiondeleteuploadedassetfile() {
        $id = $_POST['id'];
        $file_name = $_POST['file_name'];
        $i = $_POST['row_field'];
        $document_detail = new EmployeeAsset();
        $model_documents = EmployeeAsset::model()->findByPk($id);
        $document_file_array = explode(',', $model_documents->asset_undertaking_letter);
        if (($key = array_search($file_name, $document_file_array)) !== false) {
            unset($document_file_array[$key]);
            $files = implode(',', $document_file_array);
            EmployeeAsset::model()->updateByPK($id, array('asset_undertaking_letter' => $files));
            unlink(Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file_name);
            $div_file = '<span id="spanassetfile_' . $i . '">';
            foreach ($document_file_array as $value_file) {
                $f_name = "'" . $value_file . "'";
                $div_file .= $value_file . '&nbsp;<a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete this file" onclick="deleteuploadedassetfile(this.id,' . $id . ',' . $f_name . ');" id="deleteast_file_'.$i.'"><i class="fa fa-trash"></i></a><br>';
            }
            $div_file .= '</span>';
            $div_file .= CHtml::activeHiddenField($document_detail, "[" . $i . "]asset_undertaking_letter", array('value' => $files));
            echo $div_file;
        }
    }

    public function actionuploademployeedocuments() {
        //added by nisha on 07-03-2023
        $model = new EmployeeDocuments();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_documents', array('model' => $model), false, true);
    }

    public function actionDownloadDocumentSampleCsv() {
        $filename = 'Document_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee code*,Document Name*,Document No,Expiry Date';
        Yii::app()->end();
    }

    public function actionDownloadDocumentErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/documents_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }

    public function actionSaveEmpDocumentCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/documents_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/documents_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate = TRUE;
        $error_list = array();
        $document_list = $this->readEmployeeCSV("uploads/documents_csv/" . $file_name);
        foreach (array_slice($document_list, 1) as $i => $data) {
            $renewal_remainder = 0;
            if (!empty($data[0]) || !empty($data[1]) || !empty($data[2]) || !empty($data[3])) {
                $model_document[$i] = new EmployeeDocuments();
                $model_document[$i]->scenario = "excelupload";
                if (!empty($data[0])) {
                    $emp_code = $data[0];
                    $employee_code = $this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0]), '"')), "e");
                    $model_employee = Employee::model()->find(array('condition' => 'employee_code="' . $employee_code . '"'));

                    if ($model_employee->id > 0) {
                        $model_document[$i]->employee_id = $model_employee->id;
                    } else {
                        $model_document[$i]->employee_id = '';
                    }
                $model_document[$i]->emp_code =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
                } else {
                    $model_document[$i]->employee_id = '';
                }
                if (!empty($data[1])) {
                    $condition = '((REPLACE(`document_name`, " ", "") LIKE "%' . str_replace(' ', '', trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[1]), '"'))) . '%"  OR id LIKE "%' . $data[1] . '%" ) AND isActive ="Y")';
                    $model_masdocument[$i] = MasDocument::model()->find(array('select' => 'id,renewal_remainder', 'condition' => $condition));
                    $model_document[$i]->document_id = $model_masdocument[$i]->id;
                    $renewal_remainder = $model_masdocument[$i]->renewal_remainder;
                } else {
                    $model_document[$i]->document_id = '0';
                }
                $model_document[$i]->document_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[2]), '"'));
                if (!empty($data[3])) {
                    $valid_date = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[3]), '"'));
                    $model_document[$i]->validate_till_date = $valid_date;
                    $model_document[$i]->renew_on = date('Y-m-d', strtotime('-' . $renewal_remainder . ' days', strtotime($valid_date)));
                } else {
                    $model_document[$i]->validate_till_date = '';
                    $model_document[$i]->renew_on = '';
                }
                $model_document[$i]->created_by = Yii::app()->user->id;
                $model_document[$i]->created_date_time = date('Y-m-d H:i:s');
                $validate = $model_document[$i]->validate() && $validate;
            }
        }
        if ($validate) {
            if (!empty($model_document)) {
                foreach ($model_document as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['error'] = "";
            }
        } else {
            if (!empty($model_document)) {
                foreach ($model_document as $s => $data_model) {
                    $error_list[$s]['emp_code']  =$data_model['emp_code'];
                    $error_list[$s]['document_name']  =$data_model->document->document_name;
                    $error_list[$s]['document_number'] =$data_model->document_number;
                    $error_list[$s]['validate_till_date'] =$data_model['validate_till_date'];
                    if($data_model->validate()){
                    $error_list[$s]['remarks']     ="correct";
                    }else{
                    $error_list[$s]['remarks']     =$data_model->getErrors();   
                    }
                }
            }
        }

        $j = 0;
        fclose($file);
        $list = array();
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Employee Code *,Document Name *,Document No ,Expiry Date,Remarks';
            foreach ($error_list as $i => $error_detail) {
                $error_view[$i] = '';
                if (!empty($error_detail)) {
                    if (!empty($error_detail['remarks'])) {
                        foreach ($error_detail['remarks'] as $p => $error_value) {
                            $error_view[$i] .= $error_value[0] . " / ";
                        }
                    } else {
                        $error_view[$i] .= '';
                    }
                    $list[$j++] =$error_detail['emp_code']. ',' .$error_detail['document_name']. ',' .$error_detail['document_number']. ',' .$error_detail['validate_till_date']. ',' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }


        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('employee/DownloadDocumentErrorCsv', 'id' => $file_name), array('target' => '_blank',
                    'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                    . ''
        ));
        echo CJSON::encode($jsonData);
    }

    public function actionUploadEmployeeLeave() {
        //added by nisha on 08-03-2023
        $model = new EmployeeLeave();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_employee_leave', array('model' => $model), false, true);
    }

    public function actionDownloadLeaveSampleCsv() {
        $filename = 'Leave_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Employee code*,Leave Type*,Year,Opening Balance,Current balance';
        Yii::app()->end();
    }

    public function actionDownloadLeaveErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/leave_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }

    public function actionSaveEmpLeaveCsv() {
        $file_name = Yii::app()->request->getParam('filename');  
        $jsonData['status'] = "success";
        $url = Yii::app()->basePath . '/../uploads/leave_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/leave_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $leave_list = $this->readEmployeeCSV("uploads/leave_csv/" . $file_name);
        foreach (array_slice($leave_list, 1) as $i => $data) {
            if(!empty($data[0])|| !empty($data[1])|| !empty($data[2])|| !empty($data[3])){
            $model_leave[$i] = new EmployeeLeave();
            $model_leave[$i]->scenario="excelupload";       
            if($data[0]!=''){
                $emp_code= $data[0];
                $employee_code=$this->ciphertext(trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"')),"e");
                $model_employee = Employee::model()->find(array('condition'=>'employee_code="'.$employee_code.'"'));

                if($model_employee->id>0){
                    $model_leave[$i]->employee_id =$model_employee->id;
                }else{
                    $model_leave[$i]->employee_id ='';
                }
                $model_leave[$i]->emp_code =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));
            }else{                    
                $model_leave[$i]->employee_id = '';
            }
            if($data[1]!=''){
                $leave_name=trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
                $condition = 'leave_name="'.$leave_name.'" AND branch_id="'.$model_employee->branch_or_sponsor_id.'" AND isActive ="Y"';        
                $model_masleave[$i] = MasLeave::model()->find(array('select' =>'id','condition' => $condition));
                if(!empty($model_masleave[$i])){
                    $model_leave[$i]->leave_type = $model_masleave[$i]->id;
                }else{
                    $model_leave[$i]->leave_type = '';
                }
            }else{
                $model_leave[$i]->leave_type = '';
            }
            $model_leave[$i]->leave_name =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[1]), '"'));
            $model_leave[$i]->leave_year =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[2]), '"'));
            if($data[3]!=''){
                $model_leave[$i]->leave_opening =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[3]), '"'));
            }else{
                $model_leave[$i]->leave_opening="";
            }
             if($data[4]!=''){
                $model_leave[$i]->leave_current_balance =trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[4]), '"'));
            }else{
                $model_leave[$i]->leave_current_balance="";
            }
            $model_leave[$i]->created_by  =Yii::app()->user->id;
            $model_leave[$i]->created_date_time = date('Y-m-d H:i:s');
            $validate = $model_leave[$i]->validate() && $validate;
            }
        }
        if ($validate) {                    
            if (!empty($model_leave)) {
                foreach ($model_leave as $eachModel) {
                    $eachModel->save(false);
                }
                $jsonData['error'] =""; 
            }   
        } else {            
            if (!empty($model_leave)) {
                foreach ($model_leave as $s => $data_model) {
                    $error_list[$s]['emp_code']  =$data_model['emp_code'];
                    $error_list[$s]['leave_type']  =$data_model['leave_name'];
                    $error_list[$s]['leave_year'] =$data_model['leave_year'];
                    $error_list[$s]['leave_opening'] =$data_model['leave_opening'];
                    $error_list[$s]['leave_current_balance'] =$data_model['leave_current_balance'];
                    if($data_model->validate()){
                    $error_list[$s]['remarks']     ="correct";
                    }else{
                    $error_list[$s]['remarks']     =$data_model->getErrors();   
                    }
                }
            }   
    }               
                     
    $j=0;
        fclose($file);
        $list = array(); 
        if(!empty($error_list)){
            $file_error = fopen($error_url, "w+");
            $list[$j++] = 'Employee code*,Leave Type*,Year,Opening Balance,Current balance,Remarks';
            foreach ($error_list as $i => $error_detail) {
                
            
                if(!empty($error_detail)){
                    if(!empty($error_detail['remarks'])){
                            $error_view[$i] = '';
                        foreach($error_detail['remarks'] as $p => $error_value){                        
                                $error_view[$i] .= $error_value[0]." / ";   

                        }
                    }else{
                        $error_view[$i] .= '';
                    }
                    $list[$j++] =$error_detail['emp_code']. ',' .$error_detail['leave_type']. ',' .$error_detail['leave_year']. ',' .$error_detail['leave_opening']. ',' .$error_detail['leave_current_balance']. ',' .$error_view[$i];
                }
            }
            foreach ($list as $line) {
                fputcsv($file_error, explode(',', $line));
            }
            fclose($file_error);
        }
        

        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('employee/DownloadLeaveErrorCsv', 'id'=>$file_name), array('target' => '_blank',
            'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
            . ''
            ));
        echo CJSON::encode($jsonData);
    }
    public function actionleaveinitialize() {
        $branch = (int) Yii::app()->request->getParam('branch');
        $date_join = Yii::app()->request->getParam('date_join');
        $gender = Yii::app()->request->getParam('gender');
        $condition = 'isActive =  "Y" and branch_id="'.$branch.'"';
        if($gender==1){
             $condition.=' and gender IN("1","0")';
        }else if($gender==2){
             $condition.=' and gender IN("2","0")';
        }
        $model_leave_type = MasLeave::model()->findAll(array('condition' => $condition));
        $model_setting = HrGenerelSettings::model()->find();
        $year = date("Y");
        $current_month = date("m");
        if($current_month<$model_setting->leave_carry_forward_month){
           $year=$year-1;
        }
         if ($date_join != '0000-00-00' && $date_join != '') {
                $date_join = date("Y-m-d", strtotime(str_replace('/', '-', $date_join)));
            }
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('leave_initialize_details', array('model_leave' => $model_leave_type,'date_join'=>$date_join,'branch'=>$branch), false, true);
        }
    public function actionsalaryinitialize() {
        $branch = (int) Yii::app()->request->getParam('branch');
        $date_join = Yii::app()->request->getParam('date_join');
        $model_salary = array(new EmployeeSalary());
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('salary_initialize_details', array('model_salary' => $model_salary,'date_join'=>$date_join,'branch'=>$branch), false, true);
        }
    public function actionlevelinitialize() {
        $scheme = (int) Yii::app()->request->getParam('scheme');
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('approval_level_initialize_details', array('scheme'=>$scheme), false, true);
        }
    public function actionlistdetaillevel() {
        $max_level =Yii::app()->request->getparam('max_level'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_detail_list', array('max_level' => $max_level,'functionality_id' => $functionality_id,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }
    public function actionleveldetailsdata() {
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $scheme_id =Yii::app()->request->getparam('scheme_id'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('employee_level_details_scheme', array('employee_id' => $employee_id,'scheme_id'=>$scheme_id), false, true); 
}    
}    
