<?php

class DocumentexpiryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetExpiryList','EditDocument','UpdateDocDetails','Upload','dIndex','GetDependantExpiryList','EditDependantDocument','UpdateDependantDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array('accessControl'); // perform access control for CRUD operations
    }
    public function actionIndex() {
        $model_module_employee = HrModules::model()->findByPK(1);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_employee_document_expiry_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y')) {
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }
    public function actionGetExpiryList() {
        $model = new EmployeeDocuments();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetails.employeecode',
            2 => 'employeedetails.first_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $to_date = date('Y-m-d');
        $condition = 'employeedetails.isActive="Y" AND t.renew_on<="' . $to_date . '"  AND (t.status = 0 OR t.status = 3) AND employeedetails.isActive ="Y" and document.document_type="1"';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetails.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and ( employeedetails.employee_code LIKE '%" . $searchString_en . "%' OR employeedetails.first_name LIKE '%" . $searchString_en . "%' OR employeedetails.middle_name LIKE '%" . $searchString_en . "%' OR employeedetails.last_name LIKE '%" . $searchString_en . "%' OR document.document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetails', 'document')->count(array('condition' => $condition));
        $model = $model->with('employeedetails', 'document')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.validate_till_date ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $update_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_employee_document_update']) || Yii::app()->user->authorised_user == 1) {
                $update_button =1;
                $button_string .= '<button class="btn btn-primary btn-xs" title="Employee Document Update" onclick="loadPopupModal(\'hr/documentexpiry/editdocument&id=' . $row['id'] . '\',\'' . $row['employeedetails']['employeefullname'] . ' \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            $color = 0;
            if ($row['expiry_notify'] == 2) {
                $color = 3;
            }
            $current_date = date('Y-m-d');
            $current_date_1 = date('Y-m-d', strtotime('+1 days', strtotime(date('Y-m-d'))));
            $current_date_15 = date('Y-m-d', strtotime('+15 days', strtotime(date('Y-m-d'))));
            if (strtotime($row->validate_till_date) <= strtotime($current_date)) {
                $color = 2;
            } else if ((strtotime($row->validate_till_date) >= strtotime($current_date_1)) && (strtotime($row->validate_till_date) <= strtotime($current_date_15))) {
                $color = 1;
            } else {
                $color = 0;
            }
            if ($row['status'] == 3) {
                $color = 4;
            }
            $rowData[] = array(++$m, $row->employeedetails->branch_sponsor->branch_or_sponsor_name, $row->employeedetails->employeecode, $row->employeedetails->employeefullname, $row->document->document_name, date("d/m/Y", strtotime($row->validate_till_date)), array('id'=>$row['id'],'employee_name'=>$row['employeedetails']['employeefullname'],'update_button'=>$update_button), $color);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionEditDocument() {
        $model = new EmployeeDocuments();
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $this->renderPartial('edit_document', array('model' => $model), false, true);
        } else {
            throw new CHttpException(404, 'Page not found.');
        }
    }
    public function actionUpdateDocDetails() {
        if (isset($_POST['EmployeeDocuments'])) {
            $model = new EmployeeDocuments();
            if ((int) @$_POST['EmployeeDocuments']['id'] > 0) {
                $id=(int)$_POST['EmployeeDocuments']['id'];
                $document_id=(int)$_POST['EmployeeDocuments']['document_id'];
                $document_number=$_POST['EmployeeDocuments']['document_number'];
                $model = EmployeeDocuments::model()->findByPK($id);
                $status = $model->status;
                $expiry_notify =$model->expiry_notify;
                $model_master_document= MasDocument::model()->findbyPK($document_id);
                $renewal_remainder = $model_master_document->renewal_remainder;
                $validate_till_date=$renew_on='';
                if ($_POST['EmployeeDocuments']['validate_till_date'] != '0000-00-00' && $_POST['EmployeeDocuments']['validate_till_date'] != '') {
                    $validate_till_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeDocuments']['validate_till_date'])));
                    $current_date = date("Y-m-d");
                    if (strtotime($validate_till_date) > strtotime($current_date)) {
                        $status = 0;
                        $expiry_notify = 0;
                    }
                    $renew_on = date('Y-m-d', strtotime('-' . $renewal_remainder . ' days', strtotime($validate_till_date)));
                }
                $document_file = $_POST['EmployeeDocuments']['document_file'];
                EmployeeDocuments::model()->updateByPK($id, array('validate_till_date' =>$validate_till_date,'document_number'=>$document_number,'renew_on' =>$renew_on,'document_file' =>$document_file,'status' =>$status,'expiry_notify' =>$expiry_notify, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
            echo CJSON::encode($jsonData);
        }
    }
    public function actiondIndex() {
        $model_module_employee = HrModules::model()->findByPK(1);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_dependant_document_expiry_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_employee->grant_access == 1 && $model_module_employee->isActive == 'Y')) {
            $this->render('dependant_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access');
        }
    }
    public function actionGetDependantExpiryList() {
        $model = new EmployeeDependants();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'employeedetail.employeecode',
            2 => 'employeedetail.first_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $to_date = date('Y-m-d');
        $condition = 'employeedetail.isActive="Y" AND t.renewal_date!="0000-00-00" AND t.renewal_date<="' . $to_date . '" AND employeedetail.isActive ="Y"';
        if (Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch != '') {
            $condition .= ' and employeedetail.branch_or_sponsor_id IN (' . Yii::app()->user->user_branch . ')';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en = $this->ciphertext($searchString, "e");
            $condition .= " and ( employeedetails.employee_code LIKE '%" . $searchString_en . "%' OR employeedetail.first_name LIKE '%" . $searchString_en . "%' OR employeedetail.middle_name LIKE '%" . $searchString_en . "%' OR employeedetail.last_name LIKE '%" . $searchString_en . "%' OR document.document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('employeedetail', 'document')->count(array('condition' => $condition));
        $model = $model->with('employeedetail', 'document')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.employee_id ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            $update_button =0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_dependant_document_update']) || Yii::app()->user->authorised_user == 1) {
                $update_button =1;    
                $button_string .= '<button class="btn btn-primary btn-xs" title="Dependant Document Update" onclick="loadPopupModal(\'hr/documentexpiry/editdependantdocument&id=' . $row['id'] . '\',\'' . $row['employeedetail']['employeefullname'] . ' \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            $color = 0;
            $current_date = date('Y-m-d');
            $current_date_1 = date('Y-m-d', strtotime('+1 days', strtotime(date('Y-m-d'))));
            $current_date_15 = date('Y-m-d', strtotime('+30 days', strtotime(date('Y-m-d'))));
            if (strtotime($row->renewal_date) <= strtotime($current_date)) {
                $color = 2;
            } else if ((strtotime($row->renewal_date) >= strtotime($current_date_1)) && (strtotime($row->renewal_date) <= strtotime($current_date_15))) {
                $color = 1;
            } else {
                $color = 0;
            }
            $rowData[] = array(++$m, $row->employeedetail->branch_sponsor->branch_or_sponsor_name, $row->employeedetail->employeecode, $row->employeedetail->employeefullname, $row->dependant_name,$row->document->document_name, date("d/m/Y", strtotime($row->renewal_date)), array('id'=>$row['id'],'employee_name'=>$row['employeedetail']['employeefullname'],'update_button'=>$update_button), $color);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionEditDependantDocument() {
        $model = new EmployeeDependants();
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $this->renderPartial('edit_dependant_document', array('model' => $model), false, true);
        } else {
            throw new CHttpException(404, 'Page not found.');
        }
    }
    
    public function actionUpdateDependantDetails() {
        if (isset($_POST['EmployeeDependants'])) {
            $model = new EmployeeDependants();
            if ((int) $_POST['EmployeeDependants']['id'] > 0) {
                $id=(int)$_POST['EmployeeDependants']['id'];
                $model = EmployeeDependants::model()->findByPK($id);
                $renewal_date='';
                if ($_POST['EmployeeDependants']['renewal_date'] != '0000-00-00' && $_POST['EmployeeDependants']['renewal_date'] != '') {
                    $renewal_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['EmployeeDependants']['renewal_date'])));
                }
                $document_file = $_POST['EmployeeDependants']['document_upload'];
                EmployeeDependants::model()->updateByPK($id, array('renewal_date' =>$renewal_date,'document_upload' =>$document_file, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d H:i:s')));
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
            echo CJSON::encode($jsonData);
        }
    }

}
