<?php

class DesignationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'Create', 'Directadd', 'SaveDesignation', 'GetList', 'Disable','UploadDesignation','UploadEmployeecsv','DownloadSampleCsv','DownloadErrorCsv','readDesignationCSV','SaveDesignationUploadCsv'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    //Code added by Dikson on 7/3/2018
    public function actionCreate() {
        $model = new MasDesignation();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_desgn_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new MasDesignation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            0 => 'id',
            1 => 't.id',
            2 => 'designation_name'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  = "  (designation_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $button_string = "";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_general_desgn_edit'])  || Yii::app()->user->authorised_user == 1) {
               $button_string = '<div style="width:100%; text-align:center;"><button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'designation/create&id=' . $row['id'] . '\',\'Edit Designation \',\'md\')"><i class="fa fa-edit"></i></button></div>';
             }

           $rowData[] = array(++$m, $row['designation_name'], $row['id'], array('id' => $row->id, 'status' => $row->isActive));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSaveDesignation() {

        $model = new MasDesignation();
        if (isset($_POST['MasDesignation'])) {
            if ((int) @$_POST['MasDesignation']['id'] > 0) {
                $id = (int) @$_POST['MasDesignation']['id'];
                $model = $model->findByPk($id);
               $model->scenario = 'update';
            }else{
                 $model->scenario = 'add';
            }
            $model->designation_name = $_POST['MasDesignation']['designation_name'];
            $model->isActive = 'Y';
            if ($model->validate()) {
                $model->save();
               
                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDirectadd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $status = array();
        $drop = '';
        if ($name != '') {
            $modelDesignation = new MasDesignation;
            $modelDesignation->designation_name = $name;
            if ($modelDesignation->save()) {
                $status['status'] = "success";
                $data = MasDesignation::getDesignation();
                if ($from == 'MasDesignation') {
                    $model = new Employee;
                    $field_name = 'designation';
                }
                $model->$field_name = $modelDesignation->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Designation <span style="color:red;">*</span>'));
                $status['drop'] = $drop;
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelDesignation, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
            public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasDesignation();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

     public function actionUploadDesignation(){
        //added by nisha on 01-03-2023
        $model=new MasDesignation();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_designation', array('model' => $model), false, true);
    }
public function actionDownloadSampleCsv() {
        $filename = 'designation_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Designation Name*';
        Yii::app()->end();
    } 
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/designation_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    public function readDesignationCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionSaveDesignationUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');  
        $url = Yii::app()->basePath . '/../uploads/designation_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/designation_csv/error/' . $file_name;
        $file = fopen($url, "r");
        $data = fgetcsv($file);
        $validate=TRUE;
        $error_list = array();
        $designation_error = array();
        $designation_list = $this->readDesignationCSV("uploads/designation_csv/" . $file_name);
        $linecount = count(file("uploads/designation_csv/" . $file_name))-1;
            foreach (array_slice($designation_list, 1) as $i => $data) {
                if(!empty($data[0])){
                    if($data[0]!=''){
                $designation_model[$i] = new MasDesignation();
                $designation_model[$i]->scenario="excelupload";
                $designation_model[$i]->designation_name = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT',$data[0]), '"'));

                }else{                    
                    $designation_model[$i]->designation_name = '';
                }
                $designation_error[$i] = $designation_model[$i]->designation_name;   
               
                $designation_model[$i]->isActive = 'Y';
                      
                $validate = $designation_model[$i]->validate() && $validate;
                }
            }
            //echo '<pre>';  print_r($designation_model);      die();
            function array_not_unique($raw_array) {
                $dupes = array();
                natcasesort($raw_array);
                reset($raw_array);

                $old_key   = NULL;
                $old_value = NULL;
                foreach ($raw_array as $key => $value) {
                    if ($value === NULL) { continue; }
                     if($old_value!=NULL){
                        if (strcasecmp($old_value, $value) === 0) {
                            $dupes[$old_key] = $old_value;
                            $dupes[$key]     = $value;
                        }
                     }
                    $old_value = $value;
                    $old_key   = $key;
                }
                return $dupes;
            }
               

            $des_common = array_not_unique($designation_error);
            if ($validate) {                    
                if (!empty($designation_model)) {
                    foreach ($designation_model as $eachModel) { 
                        $eachModel->save();
                    }
                    $jsonData['error'] =""; 
                }   
            } else {            
                if (!empty($designation_model)) {
                    foreach ($designation_model as $s => $data_model) {
                        $error_list[$s]['designation_name'] =$data_model['designation_name'];
                        
                        if($data_model->validate()){
                        $error_list[$s]['remarks']     ="correct";
                        }else{
                        $error_list[$s]['remarks']     =$data_model->getErrors();   
                        }
                    }
                }   
            }               

            $j=0;
            fclose($file);
            $list = array(); 
            if(!empty($error_list)){
                $file_error = fopen($error_url, "w+");
                $list[$j++] = 'Designation Name*,Remarks';
                foreach ($error_list as $i => $error_detail) {


                    if(!empty($error_detail)){
                        if(!empty($error_detail['remarks'])){
                                $error_view[$i] = '';
                            foreach($error_detail['remarks'] as $p => $error_value){                        
                                    $error_view[$i] .= $error_value[0]." / ";   

                            }
                        }else{
                            $error_view[$i] .= '';
                        }
                        if (in_array($error_detail['designation_name'], $des_common)){
                            $error_view[$i] .= " Designation name duplication in CSV /";
                        }   else {
                            $error_view[$i] .= '';
                        }
                        
                        $list[$j++] = $error_detail['designation_name'].  ',' .$error_view[$i];
                    }
                }
                foreach ($list as $line) {
                    fputcsv($file_error, explode(',', $line));
                }
                fclose($file_error);
            }
            $jsonData['status'] = "success";
            $jsonData['error_url'] = $error_url;
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download log', array('designation/DownloadErrorCsv', 'id'=>$file_name), array('target' => '_blank',
                'style'=>'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
                . ''
                ));
        
        echo CJSON::encode($jsonData);
    }


}
