<?php

class CronjobController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('confirmationclearance'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('confirmationclearance'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionconfirmationclearance() { 
        ini_set("memory_limit", "-1");
        ini_set('max_execution_time', "-1");
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=cumulush_2020_hr_moativ'; 
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        $month_date = date('Y-m-d', strtotime('+1 month', strtotime(date('Y-m-d'))));
        $arr_employee_document_reminder = EmployeeDocuments::model()->with('employeedetails', 'document')->findAll(array('condition' => 't.renew_on<="' . $month_date . '"  AND t.status = 0 AND employeedetails.isActive ="Y" and document.document_type="1" AND employeedetails.branch_or_sponsor_id ="1"', 'order' => 't.validate_till_date ASC'));
        $arr_company_document_reminder = CompanyDocument::model()->with('documentname')->findAll(array('condition' => 't.renew_on<="' . $month_date . '" and status="0" and documentname.document_type="1"', 'order' => 't.validate_till_date ASC'));
        $arr_confirmation_reminder = Employee::model()->findAll(array('condition' => 'probation_date>="' . $month_date . '" and probation_date<="' . $month_date . '" and probation_date!="0000-00-00"'));
        if(!empty($arr_employee_document_reminder) || !empty($arr_company_document_reminder) || !empty($arr_confirmation_reminder)){
            //Mail Setting
            $subject='Notification';  
            if(!empty($arr_employee_document_reminder)){
            $content.='EMPLOYEE DOCUMENTS<br><br>';
                $content.='
                     <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                        <tbody>
                            <tr>
                                <th style="border: 1px solid #666;padding: 4px 5px;">No</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Name</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Document</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Expiry</th>
                            </tr>';
                                $g=1;
                                    foreach ($arr_employee_document_reminder as $key => $value) {
                                        $validate_till_date='';
                                        if ($value->validate_till_date != '0000-00-00' & $value->validate_till_date != '') {
                                            $validate_till_date=date('d/m/Y', strtotime($value->validate_till_date));
                                        }
                                        $content.='<tr>
                                            <td style="border: 1px solid #666;padding: 4px 5px;">'.$g.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->employeedetails->employeefullname.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->document->document_name.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$validate_till_date.'</td>
                                            </tr>';
                                        $g++;
                                    }
                        $content.='</tbody>
                    </table>
                    <br><br>';
            }
            if(!empty($arr_company_document_reminder)){
                $content.='COMPANY DOCUMENTS<br><br>';
                $content.='
                     <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                        <tbody>
                            <tr>
                                <th style="border: 1px solid #666;padding: 4px 5px; width:10%"">No</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Document</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Document No</th>
                                <th style="border: 1px solid #666;padding: 4px 5px; width:18%">Expiry</th>
                            </tr>';
                                $f=1;
                                    foreach ($arr_company_document_reminder as $key => $value) {
                                        $validate_till_date='';
                                        if ($value->validate_till_date != '0000-00-00' & $value->validate_till_date != '') {
                                            $validate_till_date=date('d/m/Y', strtotime($value->validate_till_date));
                                        }
                                        $content.='<tr>
                                            <td style="border: 1px solid #666;padding: 4px 5px; width:10%">'.$f.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->documentname->document_name.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->document_number.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left; width:18%">'.$validate_till_date.'</td>
                                            </tr>';
                                        $f++;
                                    }
                        $content.='</tbody>
                    </table>
                    <br><br>';
            }
            if(!empty($arr_confirmation_reminder)){
                $content.='EMPLOYEE CONFIRMATION<br><br>';
                $content.='
                     <table cellpadding="0" cellspacing="0" align="center" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit;color: #313131;font-family: Arial, Helvetica Neue, Helvetica,sans-serif;">
                        <tbody>
                            <tr>
                                <th style="border: 1px solid #666;padding: 4px 5px; width:10%"">No</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Code</th>
                                <th style="border: 1px solid #666;padding: 4px 5px;">Name</th>
                                <th style="border: 1px solid #666;padding: 4px 5px; width:18%">Confirmation Date</th>
                            </tr>';
                                $f=1;
                                    foreach ($arr_confirmation_reminder as $key => $value) {
                                        $confirmation_date='';
                                        if ($value->probation_date != '0000-00-00' & $value->probation_date != '') {
                                            $confirmation_date=date('d/m/Y', strtotime($value->probation_date));
                                        }
                                        $content.='<tr>
                                            <td style="border: 1px solid #666;padding: 4px 5px; width:10%">'.$f.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->employeecode.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left">'.$value->employeefullname.'</td>
                                            <td style="border: 1px solid #666;padding: 4px 5px; text-align: left; width:18%">'.$confirmation_date.'</td>
                                            </tr>';
                                        $f++;
                                    }
                        $content.='</tbody>
                    </table>
                    <br><br>';
            }
            $salutation='Dear Team';
            //start Mail Content
            $mailContent['body'] = '
            <table cellpadding="0" cellspacing="0" align="left" width="100%" border="0" class="container" style="border-spacing: 0;border-collapse: collapse;vertical-align: top;margin: 0 auto;text-align: inherit">
                <tbody>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <div>'.$salutation.',</div>                                              
                        </td>
                    </tr>                                      
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">
                            <strong style="font-size: 15px">Sub: '.$subject.'</strong>
                        </td>
                    </tr>
                    <tr>
                        <td height="30"></td>
                    </tr>
                    <tr style="vertical-align: top">
                        <td align="left" width="100%" style="word-break: break-word;border-collapse: collapse !important;vertical-align: top;text-align: left;font-family: Arial, "Helvetica Neue", Helvetica,sans-serif;font-size: 13px">'                          
                            .$content.'<br>
                            <br>
                            <br>
                        </td>
                    </tr>
                </tbody>
            </table>';
        //End Mail Content
            $message = new YiiMailMessage;
            $message->view = 'send_notify';
            $message->setBody(array('mailContent' => $mailContent), 'text/html');
            $message->subject =$subject; 
            $message->from ='info@bluesky.ae';
            $message->addTo('mary.a@moativ.ae');
            $message->addCC('mia@mycon.ae');
            $message->addCC('rakhee.g@moativ.ae');
            Yii::app()->mail->send($message); 
        }
    }
    
}
