<?php

class CountryController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveCountry', 'DeleteCountry', 'DirectAdd', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
       if (isset(Yii::app()->user->haveHrPermissionOn['master_country_view']) || isset(Yii::app()->user->haveHrPermissionOn['hr_master_country_menu']) || Yii::app()->user->authorised_user == 1) {
            $this->render('index');
        }else{
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasCountry();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 =>'t.id',
            1 => 'country_name',
            2 => 'country_code',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition  = "  (country_name LIKE '%" . $searchString . "%' OR country_code LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = $offset;
        foreach ($model as $row) {
            $edit_button=$disable_button=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_country_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit_button=1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_country_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable_button =1;
            }
            $rowData[] = array(++$m,
                $row['country_name'],
                $row['country_code'],
                array('id' => $row['id'],'code'=>$row['country_code'], 'status' => $row->isActive,'edit_button'=>$edit_button,'disable_button'=>$disable_button));

        }



//                
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['country_name'],$row['country_code'],
//              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'hr/country/create&id='.$row['id'].'\',\'Edit Currency\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCountry('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//                }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasCountry();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('country_form', array('model' => $model), false, false);
    }

    public function actionSaveCountry() {
        $model = new MasCountry();
        if (isset($_POST['MasCountry'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasCountry']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasCountry']['id'];
                $model = $model->findByPk($id);
                
                 $model->scenario = 'update';
            }else{
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['MasCountry'];
            if ($model->save()) {
                $country_form ="";
                if(!empty($_POST['country_form'])){
                  $country_form = $_POST['country_form'];  
                }
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $country_form;
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteCountry() {

        $id = $_POST['id'];
        $model_c = Customer::model()->findAll(array('condition' => 'customer_country = ' . $id . ' '));
        $model_com = Company::model()->findAll(array('condition' => 'shipping_country = ' . $id . ' '));
        if (empty($model_c) && empty($model_com)) {
            $model = new MasCountry();
            $country = $model->findByPk($id); // audit log changes
            $model->deleteByPk($id);
            // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'COUNTRY',
                    Yii::app()->user->id,
                    'DELETED',
                    " with code : - {$country->country_code}"
                );
                // end audit log
            echo "success";
        } else {
            echo "fail";
        }
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $code = $_POST['code'];
        if ($name != '' && $code != '') {
            $modelCountry = new MasCountry;
            $modelCountry->created_by = Yii::app()->user->id;
            $modelCountry->created_datetime = date('Y-m-d h:i:s');
            $modelCountry->country_name = $name;
            $modelCountry->country_code = $code;
            if ($modelCountry->save()) {
                $data = MasCountry::getCountry();
                if ($from == 'customer') {
                    $model = new Customer;
                    $field_name = 'customer_country';
                }
                if ($from == 'vendor') {
                    $model = new Vendor;
                    $field_name = 'vendor_country';
                }
                $model->$field_name = $modelCountry->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Country <span style="color:red;">*</span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelCountry, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
            public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasCountry();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}
