<?php
//Created on 2/5/2022 by DIkson R
class CompanyController extends Controller
{
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Create','SaveCompany',),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        //Edit Form
    public function actionCreate()
    {
        $model= MasCompany::model()->findbyPK(Yii::app()->user->master_user_company_id);        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSaveCompany() {	 
        $model = new MasCompany();
        if (isset($_POST['MasCompany'])) {
            if ($_POST['MasCompany']['id'] > 0) {      
                $model = MasCompany::model()->findByPK($_POST['MasCompany']['id']);	
            }
            $model->attributes = $_POST['MasCompany']; 
            $model->shipping_address=$_POST['MasCompany']['billing_address'];
            $model->shipping_country=$_POST['MasCompany']['billing_country'];
            if ($model->validate()) {
                $model->save();
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CActiveForm::validate($modelloan, '', false);
                if ($error != '[]')
                echo $error;
            }

        }			
    }
}