<?php

class CatalogueController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create','Upload', 'SaveCatalogue', 'DeleteCatalogue','DownloadCatalogue',
                    'ViewCatalogue','ViewCataloguedetails', 'ClearCatalogue',
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $model_module_catalogue = HrModules::model()->findByPK(21);
        if ($model_module_catalogue->grant_access == 1 && $model_module_catalogue->isActive == 'Y') {
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_catalogue_menu']) || Yii::app()->user->authorised_user == 1) {
                Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
                $this->render('index');
            } else {
                throw new CHttpException(401, 'Unauthorized Access.');
            }
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {
        $model = new CompanyCatalogue();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
       // $type= $_POST['type'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'branch_or_sponsor_id',
            2 => 'department_id',
            3 => 'title',
            4 => 'notes',
            5 => 'created_date_time',
            6 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (t.title LIKE '%" . $searchString . "%' OR t.notes LIKE '%" . $searchString . "%')";
        }
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and t.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = '';
            $edit_catalogue=$delete_catalogue=$Download_catalogue=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_catalogue_edit'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/catalogue/create&id=' . $row['id'] . '\',\'Edit Catalogue \',\'xl\')"><i class="fa fa-edit"></i></button>';
                $edit_catalogue =1;
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_catalogue_delete'])  || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="deletecatalogue(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                $delete_catalogue =1;
                
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_catalogue_download'])  || Yii::app()->user->authorised_user == 1) {
                if($row['catalogue_attachment']!=''){
                    $button_string.= ' <a href="?r=hr/catalogue/downloadcatalogue&id=' . $row['id'] . '" title="Download"><button class="btn btn-primary btn-xs" title="Download" ><i class="fa fa-download"></i></button></a>&nbsp;';           
                    $Download_catalogue=1;
                }
            }
            $created_date_time ="";
            if ($row['created_date_time'] != '' && $row['created_date_time'] != '0000-00-00') {
                $created_date_time = date("d/m/Y", strtotime($row['created_date_time']));
            }
            $notes=strip_tags($row['notes']);
            $rowData[] = array($m,CompanyCatalogue::getbranch($row['id']),CompanyCatalogue::getdepartment($row['id']), $row['title'],'<div title="'.$notes.'">'.substr($notes, 0,25).'</div>',$created_date_time, array('id'=>$row['id'],'edit_catalogue'=>$edit_catalogue,'delete_catalogue'=>$delete_catalogue,'Download_catalogue'=>$Download_catalogue));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new CompanyCatalogue();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSaveCatalogue() {
        if (isset($_POST['CompanyCatalogue'])) {
            $model = new CompanyCatalogue();
            if ((int) @$_POST['CompanyCatalogue']['id'] > 0) {
                $model->id = (int) $_POST['CompanyCatalogue']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
            }
            $model->attributes = $_POST['CompanyCatalogue'];
            $model->notes = $_POST['notes'];
            if(isset($_POST['CompanyCatalogue']['branch_or_sponsor_id']) && count($_POST['CompanyCatalogue']['branch_or_sponsor_id']) > 0){
                $model->branch_or_sponsor_id = implode(',',$_POST['CompanyCatalogue']['branch_or_sponsor_id']);
            }else{
                $model->branch_or_sponsor_id = "";
            }
            if(isset($_POST['CompanyCatalogue']['department_id']) && count($_POST['CompanyCatalogue']['department_id']) > 0){
                $model->department_id = implode(',',$_POST['CompanyCatalogue']['department_id']);
            }else{
                $model->department_id = "";
            }
            if ($model->validate()) {
                $model->save();      
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionDeleteCatalogue() {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id != 0) {
            CompanyCatalogue::model()->updateByPK($id, array('isActive' => 'N','updated_by' => Yii::app()->user->id,'updated_date_time' => date('Y-m-d H:i:s')));
            echo CJSON::encode(array('status' => 'success'));
        }
    }   
    public function actionDownloadCatalogue() {
        $id = Yii::app()->request->getParam('id');
        $model = CompanyCatalogue::model()->findByPk($id);
        $file = $model->catalogue_attachment;
        if ($model->catalogue_attachment!='') {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/upload_catalogue/" . $file;
            header("Content-type:application/octet-stream"); //for txt file
            header("Content-Type: application/download");
            header('Content-Disposition: attachment; filename="' . basename($path) . '"');
            header('Content-Length: ' . filesize($path));
            readfile($path);
            Yii::app()->end();
        }
    }
    public function actionViewCatalogue() {
        $this->layout='main';
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->render('view_catalogue');
    }
    public function actionViewCataloguedetails() {
        $this->layout='main';
        $id = Yii::app()->request->getParam('id');
        $model = CompanyCatalogue::model()->findByPK($id);
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui.min.js' => false);
        $this->renderPartial('view_catalogue_details', array('model' => $model), false, true);
    }
    public function actionClearCircular() {
        if (isset($_POST['CompanyCircular'])) {
            $id = $_POST['CompanyCircular'];
            $employee = $_POST['employeeid_circular'];
            $model = CompanyCircular::model()->findByPK($id);
            if ($model->employees_viewed != '') {
                $employees_viewed = $model->employees_viewed . ',' . $employee;
            } else {
                $employees_viewed = $employee;
            }
            $model->employees_viewed = $employees_viewed;
            $model->save(false);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
}
