<?php

class CalendarController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetEvents', 'GetEventsAll','Calendar','hrcalendar','GetEvent','Employeecalendar','GetEmployeeEvent'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }
    
     public function actionCalendar() {
        $this->render('calendar');
    }

    public function actionGetEvents() {
        //HR Calendar Details-Start
        $model_settings = HrGenerelSettings::model()->find();
        if($model_settings->general_calendar== "Y"){  
         if($filter_val=="Leave"  || $filter_val == "all"){           
               $model_leave_details= EmployeeLeaveDetail::model()->findAll();
                 if((int) Yii::app()->user->havePermissionOn['calendar_view'] || Yii::app()->user->authorised_user==1){
                   foreach ($model_leave_details as $leavedetail) {
                       $leave_start_date='';
                       $leave_end_date='';
                         if ($leavedetail->leave_start_date!= '' && $leavedetail->leave_start_date!= '0000-00-00') {
                             $leave_start_date =date("d/m/Y", strtotime($leavedetail->leave_start_date));;
                         }
                         if ($leavedetail->leave_end_date != '' && $leavedetail->leave_end_date != '0000-00-00') {
                             $leave_end_date =date("d/m/Y", strtotime($leavedetail->leave_end_date));;
                         }
                       $jasoneventsLeave['type'] = "Leave";
                       $jasoneventsLeave['backgroundColor'] = '#FF6347'; //'#f4a1d2';
                       $jasoneventsLeave['url'] = "javascript:void(0);";
                       $jasoneventsLeave['date'] = $jasoneventsLeave['start'] = $leavedetail->leave_start_date;
                       $jasoneventsLeave['end'] =date('Y-m-d', strtotime('+1 days', strtotime($leavedetail->leave_end_date)));
                       $jasoneventsLeave['title'] =ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))). '-' .$leavedetail->leavetype->leave_name.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status); 
                       $jasoneventsLeave['description'] = ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))).' on '.$leavedetail->leavetype->leave_name.' from '.$leave_start_date.' to '.$leave_end_date.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status);
                       $jasoneventsLeave['allDay'] = false;


                       $jasonevents[] = $jasoneventsLeave;
                   }
               }

             }
            $model_notification= CalendarNotification::model()->findAll();
            foreach ($model_notification as $detail) {
                $start_date='';
                $end_date='';
                  if ($detail->start_date!= '' && $detail->start_date!= '0000-00-00') {
                      $start_date =date("d/m/Y", strtotime($detail->start_date));;
                  }
                  if ($detail->end_date != '' && $detail->end_date != '0000-00-00') {
                      $end_date =date("d/m/Y", strtotime($detail->end_date));;
                  }
                $notify['type'] = "Leave";
                $notify['backgroundColor'] = '#ff8c00'; //'#f4a1d2';
                $notify['url'] = "javascript:void(0);";
                $notify['date'] = $notify['start'] = $detail->start_date;
                $notify['end'] = $detail->end_date;
                $notify['title'] =$start_date.'-'.$end_date; 
                $notify['description'] =$detail->notification;
                $notify['allDay'] = false;
                $jasonevents[] = $notify;
            }
        }
        if($filter_val=="todolist"  || $filter_val == "all"){           
          $model_todolist= Todolist::model()->findAll();
            if((int) Yii::app()->user->havePermissionOn['calendar_view'] || Yii::app()->user->authorised_user==1){
              foreach ($model_todolist as $task) {
                    $todo_date='';
                    if($task->todo_date!='' && $task->todo_date!='0000-00-00'){
                        $todo_date=date("d/m/Y",strtotime($task->todo_date));
                    }
                    if($task->start_time!='' && $task->start_time!='00:00:00'){
                        $start_time=date("H:i",strtotime($task->start_time));
                    }
                    if($task->end_time!='' && $task->end_time!='00:00:00'){
                        $end_time=date("H:i",strtotime($task->end_time));
                    }
                  $jsontodolist['type'] = "Todo";
                  $jsontodolist['backgroundColor'] = '#F3547E'; //'#f4a1d2';
                  $jsontodolist['url'] = "javascript:void(0);";
                  $jsontodolist['id'] = $task->id;
                  $jsontodolist['date'] = $jasoneventsLeave['start'] = $task->todo_date;
                  $jsontodolist['end'] =  $task->todo_date;
                  $jsontodolist['title'] ='Todo List'; 
                  $jsontodolist['description'] =$task->userdetail->Fullname.'-'.$todo_date.'('.$start_time.' - '.$end_time.')';
                  $jsontodolist['allDay'] = false;


                  $jasonevents[] = $jsontodolist;
              }
          }

        }
        echo CJSON::encode($jasonevents);
        Yii::app()->end();
    }
    public function actionHrcalendar() {
        $model_module_calender= HrModules::model()->findByPK(25);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_calendar_menu']) || Yii::app()->user->authorised_user == 1) && ($model_module_calender->grant_access == 1 && $model_module_calender->isActive == 'Y')) {
            $this->render('hr_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEvent() {    
        $condition= ' 1=1 ';
        if(Yii::app()->user->authorised_user != 1 && Yii::app()->user->user_branch!='') {
            $condition.= ' and employeedetail.branch_or_sponsor_id IN ('.Yii::app()->user->user_branch.')';
        }
        $model_leave_details= EmployeeLeaveDetail::model()->with('employeedetail')->findAll(array('condition'=>$condition));
            foreach ($model_leave_details as $leavedetail) {
                $leave_start_date='';
                $leave_end_date='';
                  if ($leavedetail->leave_start_date!= '' && $leavedetail->leave_start_date!= '0000-00-00') {
                      $leave_start_date =date("d/m/Y", strtotime($leavedetail->leave_start_date));;
                  }
                  if ($leavedetail->leave_end_date != '' && $leavedetail->leave_end_date != '0000-00-00') {
                      $leave_end_date =date("d/m/Y", strtotime($leavedetail->leave_end_date));;
                  }
                $leave['type'] = "Leave";
                $leave['backgroundColor'] = '#FF6347'; //'#f4a1d2';
                $leave['url'] = "javascript:void(0);";
                $leave['date'] = $leave['start'] = $leavedetail->leave_start_date;
                $leave['end'] = $leavedetail->leave_end_date;
                $leave['title'] =ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))). '-' .$leavedetail->leavetype->leave_name.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status); 
                $leave['description'] = ucwords(strtolower($this->ciphertext($leavedetail->employeedetail->first_name, "d") . ' ' . $this->ciphertext($leavedetail->employeedetail->last_name, "d"))).' on '.$leavedetail->leavetype->leave_name.' from '.$leave_start_date.' to '.$leave_end_date.'-'.EmployeeLeaveDetail::getleavestatus($leavedetail->leave_status);
                $leave['allDay'] = false;


                $jsonevents[] = $leave;
            }
        $model_notification= CalendarNotification::model()->findAll();
            foreach ($model_notification as $detail) {
                $start_date='';
                $end_date='';
                  if ($detail->start_date!= '' && $detail->start_date!= '0000-00-00') {
                      $start_date =date("d/m/Y", strtotime($detail->start_date));;
                  }
                  if ($detail->end_date != '' && $detail->end_date != '0000-00-00') {
                      $end_date =date("d/m/Y", strtotime($detail->end_date));;
                  }
                $notify['type'] = "Leave";
                $notify['backgroundColor'] = '#ff8c00'; //'#f4a1d2';
                $notify['url'] = "javascript:void(0);";
                $notify['date'] = $notify['start'] = $detail->start_date;
                $notify['end'] = $detail->end_date;
                $notify['title'] =$start_date.'-'.$end_date; 
                $notify['description'] =$detail->notification;
                $notify['allDay'] = false;
                $jsonevents[] = $notify;
            }
        echo CJSON::encode($jsonevents);
        Yii::app()->end();
    }
    public function actionEmployeecalendar() {
        $this->layout='main';
        $model_module_calender= HrModules::model()->findByPK(25);
        if ($model_module_calender->grant_access == 1 && $model_module_calender->isActive == 'Y'){
            $this->render('employee_calender_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }
    public function actionGetEmployeeEvent() {
        $employee_id = User::model()->findbypk(Yii::app()->user->id)->employee_id;
        $model_employee = Employee::model()->findbyPK($employee_id);
        $model_color_code = HrMasColorCode::model()->findAll();
        $model_leave_details = EmployeeLeaveDetail::model()->with('employeedetail')->findAll(array('condition' => 'employee_id="'.$employee_id.'"'));
        foreach ($model_leave_details as $leavedetail) {
            $leave_start_date = '';
            $leave_end_date = '';
            $leave_status='';
            if ($leavedetail->leave_start_date != '' && $leavedetail->leave_start_date != '0000-00-00') {
                $leave_start_date = date("d/m/Y", strtotime($leavedetail->leave_start_date));
                ;
            }
            if ($leavedetail->leave_end_date != '' && $leavedetail->leave_end_date != '0000-00-00') {
                $leave_end_date = date("d/m/Y", strtotime($leavedetail->leave_end_date));
                ;
            }
            if($leavedetail->leave_status==1){
                $leave_status='Applied';
                $leave['backgroundColor'] = $model_color_code[0]['color_code'];//Dark blue
            }
            elseif($leavedetail->leave_status==12){
                $leave_status='Approved';
                $leave['backgroundColor'] = $model_color_code[1]['color_code'];//Dark blue
            }
            $leave['type'] = "Leave";
            $leave['url'] = "javascript:void(0);";
            $leave['start'] = $leavedetail->leave_start_date;
            $leave['end'] = $leavedetail->leave_end_date;
            $leave['title'] = $leavedetail->leavetype->leave_name . '-' . $leave_status;
            $leave['description'] =$leavedetail->leavetype->leave_name . ' from ' . $leave_start_date . ' to ' . $leave_end_date . '-' . $leave_status;
            $leave['allDay'] = false;

            $jsonevents[] = $leave;
        }
        
        $hol_condition= 'FIND_IN_SET("'.$model_employee->branch_or_sponsor_id.'",branch_id)';
        $model_holiday_details = MasHoliday::model()->findAll(array('condition' => $hol_condition));
        foreach ($model_holiday_details as $holidaydetail) {
            $holiday_date = '';
            
            if ($holidaydetail->holiday_date != '' && $holidaydetail->holiday_date != '0000-00-00') {
                $holiday_date = date("d/m/Y", strtotime($holidaydetail->holiday_date));
                ;
            }

            $holiday['type'] = "Holiday";
            $holiday['backgroundColor'] = $model_color_code[2]['color_code'];
            $holiday['url'] = "javascript:void(0);";
            $holiday['date'] = $holiday['start'] = $holidaydetail->holiday_date;
            $holiday['end'] = $holidaydetail->holiday_date;
            $holiday['title'] =ucwords(($holidaydetail->holiday_description)); 
            $holiday['description'] = ucwords(($holidaydetail->holiday_description));
            $holiday['allDay'] = false;
            $jsonevents[] = $holiday;
        }
        $model_attend_details = EmployeeAttendance::model()->with('employeedetail')->findAll(array('condition' =>'employee_id="'.$employee_id.'" AND (status="1" OR status="2" OR status="5")'));
        foreach ($model_attend_details as $attenddetail) {
            $attendance_date = '';
            if ($attenddetail->attendance_date!= '' && $attenddetail->attendance_date!= '0000-00-00') {
                $attendance_date =date("d/m/Y", strtotime($attenddetail->attendance_date));
            }
            if($attenddetail->status==1){
                if($attenddetail->excess_time!='00:00:00'){
                    $attend['backgroundColor'] =$model_color_code[5]['color_code'];
                }else if($attenddetail->variance_time_loss!='00:00:00' )
                {
                    $attend['backgroundColor'] = $model_color_code[3]['color_code'];
                }else{
                   $attend['backgroundColor'] = $model_color_code[4]['color_code'];
                }
                $attend['title'] =date('H:i',strtotime($attenddetail->login_time)).'- ' . date('H:i',strtotime($attenddetail->logout_time)); 
                $attend['description'] = 'Login : ' . date('H:i',strtotime($attenddetail->login_time)).'<br/> Logout : ' . date('H:i',strtotime($attenddetail->logout_time));         
            }else if($attenddetail->status==2){
                $attend['backgroundColor'] =$model_color_code[7]['color_code'];
                $attend['title'] ='Absent';
                $attend['description'] ='Absent';
            }else if($attenddetail->status==5){
                $attend['backgroundColor'] =$model_color_code[6]['color_code'];
                $attend['title'] ='Weekend';
                $attend['description'] ='Weekend';
            }
            $attend['type'] = "Attendance";
            $attend['url'] = "javascript:void(0);";
            $attend['date'] = $attend['start'] =$attend['end'] = $attenddetail->attendance_date;
            $attend['allDay'] = false;
            $jsonevents[] = $attend;
        }
        echo CJSON::encode($jsonevents);
        Yii::app()->end();
    }


}
