<?php

class BranchController extends Controller {

//	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'deleteInOut', 'saveBranch', 'GetList', 'ChangeBranch', 'GetEmployeelist', 'getEmployeeShift', 'SaveEmployeeBranch',
                    'UploadOrganizationChart', 'CreateCompanyWps', 'SaveCompanyWps', 'SaveBranch1', 'removewpsdetail', "Disable", 'Upload', 'DisablePayslipIndex', 'DisablePayslipGetList',
                    'DisablePayslipCreate', 'SaveDisableslip', 'checkleaveexist'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_menu']) || Yii::app()->user->authorised_user == 1) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionGetList() {

        $model = new MasCompanyBranchSponsor();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'branch_or_sponsor_name',
            2 => 'branch_or_sponsor_location',
            3 => 'branch_or_sponsor_phno',
            4 => 'branch_or_sponsor_email',
            5 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = ' t.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (branch_or_sponsor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m =$offset;
        foreach ($model as $row) {
//            $button_string = "";
            $edit=$disable=0;
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_edit']) || Yii::app()->user->authorised_user == 1) {
                $edit=1;
//                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/branch/create&id=' . $row['id'] . '\',\'Edit Branch \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_disable']) || Yii::app()->user->authorised_user == 1) {
                $disable=1;
            }
            $rowData[] = array(++$m, $row['branch_or_sponsor_name'], $row['branch_or_sponsor_location'], $row['branch_or_sponsor_phno'], $row['branch_or_sponsor_email'], $row['id'], array("id" => $row['id'],'status' => $row['isActive'],"edit" => $edit,"disable" =>$disable));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasCompanyBranchSponsor();
        $model_hours = array(new WorkingHours);
        $model_hour = new WorkingHours;
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_hours = WorkingHours::model()->findAll(array('condition' => 'company_branch_or_sponsor_id="' . $id . '"'));
            if (empty($model_hours)) {
                $model_hours = array(new WorkingHours);
            }
        }
        $model_hr_general_settings = HrGenerelSettings::model()->find();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model, 'model_hours' => $model_hours, 'model_hour' => $model_hour, 'model_hr_general_settings' => $model_hr_general_settings), false, true);
    }

    public function actionCreateCompanyWps() {
        $company_id = Yii::app()->user->master_user_company_id;
        $model_wps_details = MasCompanyWpsDetails::model()->findAll(array('condition' => 'company_id=' . $company_id));
        if (empty($model_wps_details)) {
            $model_wps_details = array(new MasCompanyWpsDetails);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create_company_wps', array('model_wps_details' => $model_wps_details), false, true);
    }

    public function actionSaveCompanyWps() {
        $validate = true;
        $company_id = Yii::app()->user->master_user_company_id;
        if (isset($_POST['MasCompanyWpsDetails'])) {
            foreach ($_POST['MasCompanyWpsDetails'] as $i => $items) {
                $modal_wps[$i] = new MasCompanyWpsDetails();
                if ($items['id'] > 0) {
                    $modal_wps[$i] = $modal_wps[$i]->findByPK($items['id']);
                    $modal_wps[$i]->scenario = 'update';
                }
                $modal_wps[$i]->company_name = $items['company_name'];
                $modal_wps[$i]->company_code = $items['company_code'];
                $modal_wps[$i]->company_bank_code = $items['company_bank_code'];
                $modal_wps[$i]->isActive = "Y";
                $modal_wps[$i]->scenario = 'add';

                $validate = $modal_wps[$i]->validate() && $validate;
            }
            if ($validate) {
                if (!empty($modal_wps)) {
                    foreach ($modal_wps as $eachWpsModel) {
                        $eachWpsModel->company_id = $company_id;
                        $eachWpsModel->save();
                    }
                }
                $model_id = "";
                if (!empty($model_id)) {
                    $model_id = $model->id;
                }
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model_id;
                echo CJSON::encode($jsonData);
            } else {
                $error2 = json_decode(CActiveForm::validate($modal_wps, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionSaveBranch() {
        $model = new MasCompanyBranchSponsor;
        if (isset($_POST['MasCompanyBranchSponsor'])) {
            if ((int) @$_POST['MasCompanyBranchSponsor']['id'] > 0) {
                $model->id = (int) $_POST['MasCompanyBranchSponsor']['id'];
                $model->scenario = 'update';

                $model = MasCompanyBranchSponsor::model()->findByPK($_POST['MasCompanyBranchSponsor']['id']);
            } else {
                unset($_POST['MasCompanyBranchSponsor']['id']);
                $model->scenario = 'add';
            }
            $model->attributes = $_POST['MasCompanyBranchSponsor'];
            $model->branch_or_sponsor_logo = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_logo'];
            $model->footer_logo = $_POST['MasCompanyBranchSponsor']['footer_logo'];
            $model->watermark_logo = $_POST['MasCompanyBranchSponsor']['watermark_logo'];
            //certificate_seal updated by nisha on 24-04-2023
            $model->certificate_seal = $_POST['MasCompanyBranchSponsor']['certificate_seal'];
            $model->branch_or_sponsor_code = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_code'];
            $model->slip_header_name = $_POST['MasCompanyBranchSponsor']['slip_header_name'];
            $model->branch_or_sponsor_location = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_location'];
            $model->branch_or_sponsor_city = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_city'];
            $model->branch_or_sponsor_state = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_state'];
            $model->branch_or_sponsor_email = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_email'];
            $model->branch_or_sponsor_phno = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_phno'];
            $model->branch_or_sponsor_fax = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_fax'];
            $model->branch_or_sponsor_web = $_POST['MasCompanyBranchSponsor']['branch_or_sponsor_web'];
            $model->organization_chart_name = $_POST['MasCompanyBranchSponsor']['organization_chart_name'];
            $model->branch_transfer = $_POST['MasCompanyBranchSponsor']['branch_transfer'];
            $exclude_holiday = "";
            if (!empty($_POST['MasCompanyBranchSponsor_exclude_holiday'])) {
                $exclude_holiday = $_POST['MasCompanyBranchSponsor_exclude_holiday'];
            }
            $exclude_weekend = "";
            if (!empty($_POST['MasCompanyBranchSponsor_exclude_weekend'])) {
                $exclude_weekend = $_POST['MasCompanyBranchSponsor_exclude_weekend'];
            }
            $model->exclude_holiday = $exclude_holiday;
            $model->exclude_weekend = $exclude_weekend;
            $model->workstart_time = $_POST['MasCompanyBranchSponsor']['workstart_time'];
            $model->workstart_time = date("H:i", strtotime($model->workstart_time));
            $model->workend_time = $_POST['MasCompanyBranchSponsor']['workend_time'];
            $model->workend_time = date("H:i", strtotime($model->workend_time));
            if ($_POST['MasCompanyBranchSponsor']['weekend_work_starttime'] != '') {
                $model->weekend_work_starttime = date("H:i", strtotime($_POST['MasCompanyBranchSponsor']['weekend_work_starttime']));
            }
            if ($_POST['MasCompanyBranchSponsor']['weekend_work_endtime'] != '') {
                $model->weekend_work_endtime = date("H:i", strtotime($_POST['MasCompanyBranchSponsor']['weekend_work_endtime']));
            }
            if ($_POST['MasCompanyBranchSponsor']['branch_working_hours'] != '') {
                $model->branch_working_hours = date("H:i", strtotime($_POST['MasCompanyBranchSponsor']['branch_working_hours']));
            }
            if ($_POST['MasCompanyBranchSponsor']['lunch_break_time'] != '') {
                $model->lunch_break_time = date("H:i", strtotime($_POST['MasCompanyBranchSponsor']['lunch_break_time']));
            }
            if ($model->validate()) {
                $model->save();

                if (isset($_POST['WorkingHours'])) {
                    if (is_array($_POST['WorkingHours'])) {

                        foreach ($_POST['WorkingHours'] as $i => $item) {
                            if ($item['id'] > 0) {
                                $model_hours[$i] = WorkingHours::model()->findbypk($item['id']);
                                $model_hours[$i]->scenario = 'update';
                            } else {
                                $model_hours[$i] = new WorkingHours;
                                $model_hours[$i]->scenario = 'add';
                            }
                            $model_hours[$i]->company_branch_or_sponsor_id = $model->id;
                            $model_hours[$i]->week_id = $item['week_id'];
                            $model_hours[$i]->weekend = $item['weekend'];
                            $valid = $model_hours[$i]->validate();
                        }
                    }
                    if (!empty($model_hours)) {
                        foreach ($model_hours as $eachModel) {
                            $eachModel->save();
                        }
                    }
                    /* $weekend_off1 = 0;
                      $weekend_off2 = 0;
                      $model_weekend = WorkingHours::model()->findAll(array('condition' => 'company_branch_or_sponsor_id="' . $model->id . '" and weekend="0"'));
                      if (!empty($model_weekend)) {
                      $weekend_off1 = $model_weekend[0]['week_id'];
                      $weekend_off2 = $model_weekend[1]['week_id'];
                      }
                      $model_employee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $model->id . '"'));
                      foreach ($model_employee as $i => $value) {
                      Employee::model()->updateByPK($value->id, array('weekend_off1' => $weekend_off1, 'weekend_off2' => $weekend_off2));
                      } */
                }
                $model->refresh();

                $jsonData['model'] = 'MasCompanyBranchSponsor';
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }

    public function actionUploadOrganizationChart($folder = null) {

        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $field_id = "";
        if (isset($_GET['field_id'])) {
            $field_id = Yii::app()->request->getParam('field_id');
        }


        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("pdf");
        $sizeLimit = 10 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME
        $this->CropIfImage($folder, $fileName, 600, 300);

        $imagename = Yii::app()->basePath . '/../uploads/organizationchart/' . $fileName;

        //$imagename_thumb	=	Yii::app()->basePath.'/../uploads/filim/photo/'.$fileName;


        Yii::import("ext.EPhpThumb.EPhpThumb");

        //$thumb=new EPhpThumb();
        //$thumb->init(); //this is needed
        //chain functions
        //$thumb->create($imagename)->resize(728,728)->save($imagename_thumb);
        //$thumb->create($imagename)->resize(100,100)->save($imagename_poster);

        echo $return; // it's array
    }

    public function actionChangeBranch() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->render('branch_form');
    }

    public function actionGetEmployeelist() {
        $branch = Yii::app()->request->getparam('branch');
        $model_employee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '" and isActive!="B"', 'order' => 'first_name'));
        $arr_employee = array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'], "d") . ' ' . $this->ciphertext($value['last_name'], "d")] = $value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('employee_list', array('branch' => $branch, 'arr_employee' => $arr_employee), false, true);
    }

    public function actiongetEmployeeShift() {
        $id = $_POST['id'];
        $effective_date = $_POST['effective_date'];
        $effective_date = str_replace('/', '-', $effective_date);
        $effective_date = date("Y-m-d", strtotime($effective_date));
        $model_shift = EmployeeShift::model()->find(array('condition' => '((from_date<="' . $effective_date . '" AND to_date>="' . $effective_date . '") OR  (from_date BETWEEN  "' . $effective_date . '" AND  "' . $effective_date . '"
                            OR to_date BETWEEN  "' . $effective_date . '" AND  "' . $effective_date . '")) AND employee_id="' . $id . '"'));
        if (empty($model_shift)) {
            $jsonData['status'] = 'success';
        } else {
            $jsonData['message'] = 'Shift exist from ' . date_format(date_create($model_shift->from_date), 'd/m/Y') . ' to ' . date_format(date_create($model_shift->to_date), 'd/m/Y');
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveEmployeeBranch() {
        if (isset($_POST['Employee'])) {
            $model_setting = HrGenerelSettings::model()->find();
            $leave_year = date("Y");
            $current_month = date("m");
            if ($current_month < $model_setting->leave_carry_forward_month) {
                $leave_year = $leave_year - 1;
            }
            foreach ($_POST['Employee'] as $i => $items) {
                if ($items['id'] > 0 && $items['effective_date'] != "") {
                    $old_branch = $items['old_branch'];
                    $new_branch = $items['branch_or_sponsor_id'];
                    if ($old_branch != $new_branch) {
                        $model = Employee::model()->findByPK($items['id']);
                        $model->branch_or_sponsor_id = $items['branch_or_sponsor_id'];
                        $effective_date = $items['effective_date'];
                        $effective_date = str_replace('/', '-', $effective_date);
                        $effective_date = date("Y-m-d", strtotime($effective_date));
                        $model->weekend_off1 = 0;
                        $model->weekend_off2 = 0;
                        $model_workinghour = WorkingHours::model()->findAll(array('condition' => 'company_branch_or_sponsor_id="' . $new_branch . '" and weekend="0"'));
                        foreach ($model_workinghour as $key => $value) {
                            if ($key == 0) {
                                $model->weekend_off1 = $value->week_id;
                            }
                            if ($key == 1) {
                                $model->weekend_off2 = $value->week_id;
                            }
                        }
                        $model->save(false);
                        $model_branch = new EmployeeBranch();
                        $model_branch->employee_id = $model->id;
                        $model_branch->branch_id = $model->branch_or_sponsor_id;
                        $model_branch->from_date = $effective_date;
                        $model_branch->created_by = Yii::app()->user->id;
                        $model_branch->created_date_time = date('Y-m-d h:i:s');
                        $model_branch->save();
                        $to_date = date('Y-m-d', strtotime('-1 days', strtotime($effective_date)));
                        $model_branch_details = EmployeeBranch::model()->find(array('condition' => 'employee_id="' . $model->id . '" and branch_id="' . $old_branch . '" and to_date="0000-00-00"'));
                        if (!empty($model_branch_details)) {
                            EmployeeBranch::model()->updateByPK($model_branch_details->id, array('to_date' => $to_date, 'updated_by' => Yii::app()->user->id, 'updated_date_time' => date('Y-m-d h:i:s')));
                        }
                        //Updating Leave Details Table
                        $model_mas_leave = MasLeave::model()->findAll(array('condition' => 'branch_id="' . $old_branch . '"'));
                        foreach ($model_mas_leave as $key => $value) {
                            $model_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="' . $items['id'] . '" and leave_type="' . $value->id . '" and leave_year="' . $leave_year . '"'));
                            $model_mas_new_leave = MasLeave::model()->find(array('condition' => 'branch_id="' . $new_branch . '" and leave_abbreviation="' . $value->leave_abbreviation . '"'));
                            if (!empty($model_leave_details) && $model_leave_details->id > 0 && !empty($model_mas_new_leave)) {
                                EmployeeLeave::model()->updateByPK($model_leave_details->id, array('leave_type' => $model_mas_new_leave->id));
                            }
                        }
                    }
                }
            }
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionremovewpsdetail() {
        $id = $_POST['id'];
        if ($id > 0) {
            $model_wps_company = EmployeewpsCompany::model()->findAll(array('condition' => 'wps_company_id="' . $id . '"'));
            if (empty($model_wps_company)) {
                MasCompanyWpsDetails::model()->deleteByPk($id);
                $jsonData['status'] = 'success';
            } else {
                $jsonData['status'] = 'error';
            }
        } else {
            $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }

    public function actionSaveBranch1() {
        $model_employee = Employee::model()->findAll(array('condition' => 'isActive!="B"', 'order' => 'first_name'));
        foreach ($model_employee as $i => $items) {
            $model_branch = new EmployeeBranch();
            $model_branch->employee_id = $items->id;
            $model_branch->branch_id = $items->branch_or_sponsor_id;
            $model_branch->from_date = $items->date_join;
            $model_branch->save();
        }
    }

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasCompanyBranchSponsor();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

    public function actionDisablePayslipIndex() {
        $model_module_payroll= HrModules::model()->findByPK(7);
        if ((isset(Yii::app()->user->haveHrPermissionOn['hr_payroll_disable_ess_salary_slip_menu']) || Yii::app()->user->authorised_user == 1)&& ($model_module_payroll->grant_access == 1 && $model_module_payroll->isActive == 'Y')) {
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('salaryslip_index');
        } else {
            throw new CHttpException(401, 'Unauthorized Access.');
        }
    }

    public function actionDisablePayslipGetList() {

        $model = new MasCompanyBranchSponsor();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'branch_or_sponsor_name',
            2 => 'salary_slip_view_ess',
            3 => 'id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = ' t.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (branch_or_sponsor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";

            if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_branch_edit']) || Yii::app()->user->authorised_user == 1) {
                $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'hr/branch/create&id=' . $row['id'] . '\',\'Edit Branch \',\'lg\')"><i class="fa fa-edit"></i></button>';
            }
            $context_data = array(
                "id" => $row['id'],
                'status' => $row['isActive']
            );
            $rowData[] = array($m, $row['branch_or_sponsor_name'], $row['salary_slip_view_ess'], $row['id'], $context_data);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDisablePayslipCreate() {
        $model = new MasCompanyBranchSponsor();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('salary_slip_enable', array('model' => $model), false, true);
    }

    public function actionSaveDisableslip() {
        $model = new MasCompanyBranchSponsor;
        if (isset($_POST['MasCompanyBranchSponsor'])) {
            if ((int) @$_POST['MasCompanyBranchSponsor']['id'] > 0) {
                $model->id = (int) $_POST['MasCompanyBranchSponsor']['id'];
                $model->scenario = 'update';
                $model = MasCompanyBranchSponsor::model()->findByPK($_POST['MasCompanyBranchSponsor']['id']);
            }
            $model->salary_slip_view_ess = $_POST['MasCompanyBranchSponsor']['salary_slip_view_ess'];
            $model->save();
            $jsonData['model'] = 'MasCompanyBranchSponsor';
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }
    public function actionCheckleaveExist() {
        $id = (int) Yii::app()->request->getParam('id');
        $branch = (int) Yii::app()->request->getParam('branch');
        $old_branch = (int) Yii::app()->request->getParam('old_branch');
        $model_setting = HrGenerelSettings::model()->find();
        $leave_year = date("Y");
        $current_month = date("m");
        if ($current_month < $model_setting->leave_carry_forward_month) {
            $leave_year = $leave_year - 1;
        }
        $flag=0;
        $model_mas_leave = MasLeave::model()->findAll(array('condition' =>'branch_id="'.$old_branch.'"'));
        foreach ($model_mas_leave as $key => $value) {
            $model_leave_details = EmployeeLeave::model()->find(array('condition' => 'employee_id="'.$id.'" and leave_type="' . $value->id . '" and leave_year="'. $leave_year.'"'));
            $model_mas_new_leave = MasLeave::model()->find(array('condition' =>'branch_id="'.$branch.'" and leave_abbreviation="'.$value->leave_abbreviation.'"')); 
            if(empty($model_mas_new_leave) && !empty($model_leave_details)){
                $flag=1;
                $jsonData['status'] = 'error';
                break;
            }
        }
        if($flag==0){
            $jsonData['status'] = 'success';
        }
        echo CJSON::encode($jsonData);
    }

}
